import random
import string
import uvicorn

from fastapi import Request, HTTPException, APIRouter
from fastapi.exceptions import RequestValidationError
from starlette.middleware.cors import CORSMiddleware
from fastapi.staticfiles import StaticFiles
from starlette.middleware.sessions import SessionMiddleware

import config

from services.core.exception_handler.exception_service import exception_wrapper

from services.core.fastapi.fastapi_service import init_fastapi_app

from services.core.authorization.user.user_router import router as router_user
from services.core.authorization.routers.auth_router import router as router_auth
from services.core.authorization.token.token_router import router as router_token

from services.core.region.region_router import router as router_region
from services.core.role.role_router import router as router_role
from services.core.system.system_router import router as router_system
from services.core.system_type.system_type_router import router as types_systems_router
from features.record.record_router import router as router_record

from fastapi import Request
from fastapi.staticfiles import StaticFiles
from fastapi.responses import FileResponse

app = init_fastapi_app("Speech To Text", {})

api_router = APIRouter(prefix='/speech_recognition/api')

api_router.include_router(router_auth)
api_router.include_router(router_user)
api_router.include_router(router_system)
api_router.include_router(router_region)
api_router.include_router(router_role)
api_router.include_router(types_systems_router)
api_router.include_router(router_token)
api_router.include_router(router_record)

app.include_router(api_router)

app.mount("/speech_recognition/assets", StaticFiles(directory="dists/assets",
          html=True), name="static")

origins = [
    "http://localhost:8000",
    "http://localhost:5173"
]

app.add_middleware(
    SessionMiddleware,
    secret_key=''.join(random.choices(string.ascii_lowercase, k=16)),
    max_age=720
)

app.add_middleware(
    CORSMiddleware,
    allow_origins=origins,
    allow_credentials=True,
    allow_methods=["GET", "POST", "OPTIONS", "DELETE", "PATCH", "PUT"],
    allow_headers=["Content-Type", "Set-Cookie", "Access-Control-Allow-Headers", "Access-Control-Allow-Origin",
                   "Authorization"],
)


@app.exception_handler(404)
async def not_found_handler(request: Request, exc: HTTPException):
    return FileResponse("dists/index.html")


@app.exception_handler(Exception)
@exception_wrapper
async def global_exception_handler(request: Request, exception: Exception):
    return {"request": request, "exception": exception}


@app.exception_handler(HTTPException)
@exception_wrapper
async def global_exception_handler(request: Request, exception: HTTPException):
    return {"request": request, "exception": exception}


@app.exception_handler(RequestValidationError)
@exception_wrapper
async def global_exception_handler(request: Request, exception: RequestValidationError):
    return {"request": request, "exception": exception}


if __name__ == "__main__":
    uvicorn.run(app, host="0.0.0.0", port=8000)
