from sqlalchemy import Table, Column, Integer, String, MetaData, Boolean, ForeignKey, TIMESTAMP

from services.core.system.system_table import system

metadata = MetaData()

record = Table(
    "record",
    metadata,
    Column("id", Integer, primary_key=True, autoincrement=True),
    Column("system_id", Integer, ForeignKey(system.c.id), nullable=False),
    Column("predicted_text", String, nullable=True),
    Column("model_name", String, nullable=False),
    Column("date", TIMESTAMP(timezone=True)),
)
