"""Init migration

Revision ID: b159e5adda2c
Revises: 
Create Date: 2025-12-17 16:28:37.375668

"""
from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa

from sqlalchemy.dialects.postgresql import insert as pg_insert


# revision identifiers, used by Alembic.
revision: str = 'b159e5adda2c'
down_revision: Union[str, None] = None
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    """Upgrade schema."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('region',
                    sa.Column('id', sa.Integer(),
                              autoincrement=True, nullable=False),
                    sa.Column('name', sa.String(), nullable=True),
                    sa.Column('gmt', sa.String(), nullable=True),
                    sa.PrimaryKeyConstraint('id')
                    )
    op.create_table('role',
                    sa.Column('id', sa.Integer(),
                              autoincrement=True, nullable=False),
                    sa.Column('name', sa.String(), nullable=True),
                    sa.Column('is_superadmin', sa.Boolean(), nullable=True),
                    sa.PrimaryKeyConstraint('id')
                    )
    op.create_table('role_regions',
                    sa.Column('id', sa.Integer(),
                              autoincrement=True, nullable=False),
                    sa.Column('role_id', sa.Integer(), nullable=True),
                    sa.Column('region_id', sa.Integer(), nullable=True),
                    sa.ForeignKeyConstraint(['region_id'], ['region.id'], ),
                    sa.ForeignKeyConstraint(['role_id'], ['role.id'], ),
                    sa.PrimaryKeyConstraint('id')
                    )
    op.create_table('user',
                    sa.Column('id', sa.Integer(), nullable=False),
                    sa.Column('email', sa.String(), nullable=False),
                    sa.Column('username', sa.String(), nullable=False),
                    sa.Column('registered_at', sa.TIMESTAMP(), nullable=True),
                    sa.Column('hashed_password', sa.String(), nullable=False),
                    sa.Column('role_id', sa.Integer(), nullable=True),
                    sa.ForeignKeyConstraint(['role_id'], ['role.id'], ),
                    sa.PrimaryKeyConstraint('id')
                    )
    op.create_table('system_type',
                    sa.Column('id', sa.Integer(),
                              autoincrement=True, nullable=False),
                    sa.Column('name', sa.String(), nullable=True),
                    sa.PrimaryKeyConstraint('id')
                    )
    op.create_table('system',
                    sa.Column('id', sa.Integer(),
                              autoincrement=True, nullable=False),
                    sa.Column('name', sa.String(), nullable=True),
                    sa.Column('token', sa.String(), nullable=True),
                    sa.Column('region_id', sa.Integer(), nullable=True),
                    sa.Column('system_type_id', sa.Integer(), nullable=True),
                    sa.Column('bug_tracker', sa.String(), nullable=True),
                    sa.Column('is_gpt_enabled', sa.Boolean(), nullable=True),
                    sa.Column('is_ignored_token', sa.Boolean(),
                              server_default='false', nullable=False),
                    sa.ForeignKeyConstraint(['region_id'], ['region.id'], ),
                    sa.ForeignKeyConstraint(['system_type_id'], [
                                            'system_type.id'], ),
                    sa.PrimaryKeyConstraint('id')
                    )
    op.create_table('token',
                    sa.Column('id', sa.Integer(), nullable=False),
                    sa.Column('user_id', sa.Integer(), nullable=False),
                    sa.Column('refresh_token', sa.String(), nullable=False),
                    sa.Column('date_create_token', sa.TIMESTAMP(
                        timezone=True), nullable=True),
                    sa.ForeignKeyConstraint(
                        ['user_id'], ['user.id'], ondelete='CASCADE'),
                    sa.PrimaryKeyConstraint('id')
                    )
    op.create_table('record',
                    sa.Column('id', sa.Integer(),
                              autoincrement=True, nullable=False),
                    sa.Column('system_id', sa.Integer(), nullable=False),
                    sa.Column('predicted_text', sa.String(), nullable=True),
                    sa.Column('model_name', sa.String(), nullable=False),
                    sa.Column('date', sa.TIMESTAMP(
                        timezone=True), nullable=True),
                    sa.ForeignKeyConstraint(['system_id'], ['system.id'], ),
                    sa.PrimaryKeyConstraint('id')
                    )

    bind = op.get_bind()
    meta = sa.MetaData()
    meta.reflect(bind=bind, only=("role",))

    role = sa.Table("role", meta, autoload_with=bind)

    insert_stmt = pg_insert(role).values(
        id=1,
        name="SuperAdmin",
        is_superadmin=True
    )

    stmt = insert_stmt.on_conflict_do_update(
        index_elements=[role.c.id],
        set_={
            "name": insert_stmt.excluded.name,
            "is_superadmin": insert_stmt.excluded.is_superadmin
        }
    )

    bind.execute(stmt)

    # ### end Alembic commands ###


def downgrade() -> None:
    """Downgrade schema."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('record')
    op.drop_table('token')
    op.drop_table('system')
    op.drop_table('system_type')
    op.drop_table('user')
    op.drop_table('role_regions')
    op.drop_table('role')
    op.drop_table('region')
    # ### end Alembic commands ###
