﻿// var KS = KS || {};
// KS.HttpModule = KS.HttpModule || {};
// KS.HttpModule.Npx = 
function lavandaMod(lavandaCall) {
    var _call = function (p) {
        p.command = "module/" + p.command + "/";

        var onSuccess = p.onSuccess;
        if (onSuccess) {
            p.onSuccess = function (value) {
                var rv;
                try {
                    rv = JSON.parse(value);
                    if (rv.error) {
                        p.onError(rv.error);
                        return;
                    }
                } catch (e) {
                    rv = value;
                }
                onSuccess(rv);
            };
        }

        lavandaCall(p);
    };

    return {
        OpenDirectory: function () {
            _call({
                command: "directory/v1"
            });
        },

        GetInfo: function (p) {
            _call({
                command: "info/v1",
                timeout: (typeof p.timeout === "number") ? p.timeout : 1000,
                onProgress: (typeof p.onProgress === "function")
                    ? function (response, progressevent) {
                        p.onProgress(response, progressevent);
                    }
                    : null,
                onSuccess: (typeof p.onSuccess === "function")
                    ? function (value) {
                        p.onSuccess(value);
                    }
                    : null,
                onError: (typeof p.onError === "function")
                    ? function (msg) {
                        p.onError(msg);
                    }
                    : null,
                notStart: (typeof p.notStart === "boolean")
                    ? p.notStart
                    : false
            });
        },

        Update: function (p) {
            _call({
                command: "update/v1",
                data: p.zipfile,
                contentType: (typeof p.contentType === "string") ? p.contentType : "application/zip",
                timeout: (typeof p.timeout === "number") ? p.timeout : 30000,
                onProgress: (typeof p.onProgress === "function")
                    ? function (response, progressevent) {
                        p.onProgress(response, progressevent);
                    }
                    : null,
                onSuccess: (typeof p.onSuccess === "function")
                    ? function (value) {
                        p.onSuccess(value);
                    }
                    : null,
                onError: (typeof p.onError === "function")
                    ? function (msg) {
                        p.onError(msg);
                    }
                    : null
            });
        },

        Quit: function (p) {
            _call({
                command: "quit/v1",
                onSuccess: (typeof p.onSuccess === "function")
                    ? function (value) {
                        p.onSuccess(value);
                    }
                    : null,
                onError: (typeof p.onError === "function")
                    ? function (msg) {
                        p.onError(msg);
                    }
                    : null
            });
        }
    };
}