// ============= KS.Ext =======================
(function () {
    function setViewListeners(obj, vl, scope) {
        if (Ext.isEmpty(vl) || !Ext.isFunction(obj.on)) return;
        for (var event in vl)
            if (vl.hasOwnProperty(event)) obj.on(event, vl[event], scope);
    }

    function selectOptionVisibleDependCheckHandler(cb, checked) {
        cb.visibleDependent.setVisible(checked);
        cb.ownerCt.ownerCt.ownerCt.updateLayout();
    }

    KS.apply(KS.Ext, {
        updateLayout: function (c) {
            c.updateLayout();
        },

        create: function () {
            var isTpl = Ext.isObject(arguments[0]),
                type = isTpl ? arguments[0].type : arguments[0];
            switch (type) {
                case 'button':
                    return new Ext.Button(arguments[1]);

                case 'toolbar':
                    var tbCfg = arguments[1];
                    tbCfg['enableOverflow'] = true;
                    return new Ext.toolbar.Toolbar(tbCfg);

                case 'label':
                    var lblCfg = arguments[1];
                    if (Ext.isString(lblCfg)) lblCfg = { text: lblCfg };
                    return new Ext.form.Label(lblCfg);

                case 'selectBbar':
                    return KS.Ext.createSelectBbar.apply(this, arguments);

                case 'panel':
                    return KS.Ext.createPanel.apply(this, arguments);

                case 'tbspacer':
                    return new Ext.toolbar.Spacer({ xtype: 'tbspacer', width: arguments[1] });

                case 'simpleMenu':
                    return KS.Ext.createSimpleMenu.apply(this, arguments);

                case 'grid':
                    return KS.Ext.createGrid.apply(this, arguments);

                case 'tree':
                    return KS.Ext.createTree.apply(this, arguments);

                case 'combo':
                    return KS.Ext.createCombo.apply(this, arguments);

                case 'checkbox':
                    return KS.Ext.createCheckbox.apply(this, arguments);

                case 'periodComponent':
                    return KS.Ext.createPeriodComponent.apply(this, arguments);

                case 'gridEditor':
                    return KS.Ext.createGridEditor.apply(this, arguments);

                case 'dateField':
                    return KS.Ext.createDateField.apply(this, arguments);

                case 'gridGroupingView':
                    return KS.Ext.createGridGroupingView.apply(this, arguments);

                case 'record':
                    return KS.Ext.createRecord.apply(this, arguments);

                case 'textField':
                    return new Ext.form.field.Text(arguments[1]);

                default:
                    KS.error('Unknown component ' + type);
                    return null;
            }
        },

        createSelectBbar: function () {
            var view = arguments[1],
                text = arguments[2],
                handler = arguments[3],
                toc = arguments[4],
                optCfg = arguments[5],
                buttonAlign = 'right',
                items = [];
            if (Ext.isObject(optCfg)) {
                buttonAlign = 'left';
                items.push(view.selectOptions123 = KS.Ext.createOptionsGroup(optCfg), '->');
            }
            items.push({
                text: text,
                scope: view,
                //padding: 10,
                cls: 'marked-button',
                handler: handler
            }, KS.Ext.create('tbspacer', 10));
            if (Ext.isString(toc))
                items.push(KS.Svod.helpBtn(toc, 'dlg'));
            items.push(KS.Ext.create('tbspacer', 8), {
                text: 'Закрыть',
                cls: 'dim-button',
                scope: view,
                handler: view.close
            });
            var bbar = new Ext.toolbar.Toolbar({
                buttonAlign: buttonAlign,
                items: items
            });
            return bbar;
        },

        createOptionsGroup: function (optCfg) {
            KS.apply(optCfg, {
                columns: Ext.isNumber(optCfg.columns) ? optCfg.columns : 1,
                defaults: { scale: 'medium' }
            });
            optCfg.items = KS.Ext.processTbarItems(optCfg.items);
            var selectOptions = new Ext.ButtonGroup(optCfg);
            selectOptions.items.each(function (item) {
                var vd = item.initialConfig.visibleDepends;
                if (!vd) return;
                vd = '#' + vd;
                var parentChkbx = item.up().down(vd);
                if (parentChkbx && parentChkbx.xtype === 'checkbox') {
                    item.setVisible(parentChkbx.checked);
                    parentChkbx.visibleDependent = item;
                    parentChkbx.ownerGroup = selectOptions;
                    parentChkbx.on('change', selectOptionVisibleDependCheckHandler);
                }
            });
            return selectOptions;
        },

        processTbarItems: function (rawTbarItems) {
            var tbarItems = [];
            Ext.each(rawTbarItems, function (tbItem) {
                if (Ext.isString(tbItem)) {
                    if (tbItem === '-') {
                        tbarItems.push({ xtype: 'tbseparator' });
                    } else if (tbItem.indexOf(' ') === 0) {
                        var width = +tbItem.substring(1);
                        if (!(width > 0)) width = 3;
                        tbarItems.push(KS.Ext.create('tbspacer', width));
                    }
                } else {
                    tbarItems.push(tbItem);
                }
            });
            return tbarItems;
        },

        createSimpleMenu: function () {
            var view = arguments[1],
                items = arguments[2],
                defaults = arguments[3] || { scope: view };
            for (var itemIdx = 0; itemIdx < items.length; itemIdx++) {
                switch (items[itemIdx]) {
                    case '-':
                        items[itemIdx] = {
                            xtype: 'menuseparator'
                        }
                        break;
                }
            }
            var menu = new Ext.menu.Menu({
                defaults: defaults,
                items: items
            });
            return menu;
        },

        createGrid: function () {
            var isTpl = Ext.isObject(arguments[0]),
                ctrl = arguments[0],
                view = isTpl ? ctrl.parentView : arguments[1],
                gridSettings = isTpl ? ctrl.gridSettings : arguments[2],
                gridCfg = isTpl ? KS.apply(arguments[1] || {}, ctrl.json) : arguments[3];
            if (isTpl) {
                gridCfg.isTpl = isTpl;
            } else {
                gridCfg.tbarItems = KS.Ext.processTbarItems(gridCfg.tbarItems);
            }
            var grid = Ext.create('KS.Ext.Grid', view, gridSettings, gridCfg);
            if (isTpl) {
            } else {
                setViewListeners(grid, gridCfg.viewListeners, view);
                setViewListeners(grid.getSelectionModel(), gridCfg.selModelViewListeners, view);
            }
            return grid;
        },

        createTree: function () {
            var view = arguments[1],
                tobj = arguments[2],
                treeCfg = arguments[3];
            var tree = new KS.Ext.Tree(view, tobj, treeCfg);
            setViewListeners(tree, treeCfg.viewListeners, view);
            return tree;
        },

        createCombo: function () {
            var view = arguments[1],
                cboCfg = arguments[2];
            KS.apply(cboCfg, {
                typeAhead: true,
                mode: 'local',
                triggerAction: 'all',
                iconCls: 'no-icon'
            });
            cboCfg.editable = cboCfg.editable ? 'true' : 'false';
            var combo = new Ext.form.field.ComboBox(cboCfg);
            setViewListeners(combo, cboCfg.viewListeners, view);
            return combo;
        },

        createCheckbox: function () {
            var cbxBoxLabel = arguments[1],
                cbxChecked = arguments[2],
                view = arguments[3],
                cbxCfg = arguments[4] || {};
            KS.apply(cbxCfg, {
                boxLabel: cbxBoxLabel,
                checked: cbxChecked
            });
            var checkbox = new Ext.form.field.Checkbox(cbxCfg);
            setViewListeners(checkbox, cbxCfg.viewListeners, view);
            return checkbox;
        },

        createPeriodComponent: function () {
            var x = arguments[1],
            y = arguments[2],
            mode = arguments[3],
            itemId = arguments[4];
            var periodComponent = new KS.Ext.periodComponent({
                x: x,
                y: y,
                mode: mode,
                itemId: itemId
            });
            return periodComponent;
        },

        createGridEditor: function () {
            var combo = arguments[1],
                grid = arguments[2];
            combo.editable = combo.editable ? 'true' : 'false';
            combo.xtype = 'combo';
            return new Ext.form.field.ComboBox(combo);
        },

        createDateField: function () {
            return new Ext.form.field.Date(arguments[1]);
        },

        createGridGroupingView: function () {
            return Ext.create('Ext.grid.feature.Grouping', arguments[1]);
        },

        createRecord: function () {
            return Ext.create('Ext.data.Model', arguments[2]);
        },

        createPanel: function () {
            return new Ext.panel.Panel(arguments[1]);
        },

        getRoot: function (c) {
            return c.store.root;
        },

        hideUI: function (c) {
            //c.ui.hide();
        },

        showUI: function (c) {
            //c.ui.show();
        },

        setCheckedNode: function (node, checked) {
            node.set('checked', checked);
        },

        getSelNode: function (c) {
            return (c.selected.items.length > 0) ? c.selected.items[0] : null;
        },

        setText: function (node, text) {
            node.data.text = text;
        },

        getText: function (c) {
            return c.data.text;
        },

        decode: function (c) {
            return c;
        },

        getSplitTBar: function () {
            return '&nbsp';
        },

        getDataForStatusChangeHandler: function (c) {
            return c.html;
        },

        getElOfPrintOptions: function (view) {
            for (var i = 0; i < view.options.length; i++) {
                if (view.options[i].xtype !== 'fieldset') {
                    var el = view.options[i].constructor();
                    for (var attr in view.options[i]) {
                        if (view.options[i].hasOwnProperty(attr)) el[attr] = view.options[i][attr];
                    }
                    el.padding = '0 0 0 0';
                    el.margin = '0 0 0 0';
                    view.options[i].xtype = 'fieldset';
                    view.options[i].id = null;
                    view.options[i].items = [];
                    view.options[i].items.push(el);
                    view.options[i].border = 0;
                    view.options[i].padding = '0 0 0 0';
                    view.options[i].margin = '0 0 0 0';
                }
            }
            var field = new Ext.create('Ext.form.FieldSet', {
                border: 0,
                items: []
            });
            var button = KS.Ext.create('button', {
                text: 'Выполнить',
                cls: 'marked-button',
                margin: '0 0 0 280%',
                handler: function () {
                    view.selected();
                },
                groupLink: 0
            });
            field.items.items.push(button);
            view.options.push(field);
        },

        getOptionPrint: function (c) {
            return (c.items) ? c.items[0] : c;
        },

        doOptionPrintSyncSize: function (c) {
            var pos = c.items.items[c.items.items.length - 1].getPosition();
            c.height = pos[1];
        },

        treeReload: function (c) {
            c.getRootNode().load();
        },

        addClass: function (o, cls) {
            o.addCls(cls);
        },

        expandRow: function (c, rowIdx) {
            //c.store.data.items[rowIdx].setCollapsed(false);
        },

        getNewsGridParams: function () {
            return {
                stateful: false,
                enablePaging: false,
                rowExpanderTemplate: new Ext.Template('</br><p>{Body}</p>')
            };
        },

        setTooltip: function (metadata, tip) {
            metadata.tdAttr = tip;
        },

        lookupReference: function (el, target) {
            return el.lookupReference(target);
        },

        getGridCheckcolumnParams: function () {
            return { xtype: 'checkcolumn' };
        }
    });
})();

// ============= KS.Grid =======================
(function () {
    KS.apply(KS.Grid, {
        hideButtonHandler: function () {
            KS.msg('Недоступно');
        },

        setColumnsVisibility: function (grid, dataIdxs, hidden) {
        },

        moveClass: function (grid, cls, direction) {
        },

        addClass: function (grid, cls) {
        },

        removeClass: function (grid, cls) {
        },

        loadJson: function (grid, json) {
            grid.getStore().loadDataPage(1, json);
        },

        getSelectedRecs: function (grid) {
            return grid.getSelectionModel().getSelection();
        },

        getCheckedRecs: function (grid) {
            return [];
        },

        getTopToolbar: function (grid) {
            return grid.getDockedItems('toolbar[dock="top"]')[0];
        }
    });
})();
