﻿SystemJournalView = KS.extend(BaseTreeView, {});

// ============= BASE =======================
(function (viewClass) {
    var sc = SystemJournalView.superclass;

    KS.apply(viewClass, {

        getTbarClickHandler: function(tbarItem) {
            switch (tbarItem.code) {
                case "MARK":
                    return this.invertTreeNode;

                case "MARK_CHILD":
                case "MARK_CHILD2":
                    return this.checkAllChildrenTreeNode;

                case "MARK_DIRECT_CHILDREN":
                    return this.checkDirectChildren;

                case "UNMARK":
                    return this.uncheckTreeNode;
            default:
                return sc.getTbarClickHandler.apply(this, arguments);
            }
        },

        buildContainerToolbarItemControl: function(tbarNode) {
            if (tbarNode.additional && tbarNode.additional.type === "textField") {
                return new Ext.form.field.Text({
                    itemId: tbarNode.code,
                    emptyText: "(нет фильтра)",
                    readOnly: true,
                    tbarNode: tbarNode
                });
            }
            return sc.buildContainerToolbarItemControl.apply(this, arguments);
        },

        refreshJournal: function() {
            var view = this.parentView || this;
            var startDateCmp = view.getToolbarItem(view.rootPanel, null, "StartDate");
            var startDate = startDateCmp.getValue();
            var endDateCmp = view.getToolbarItem(view.rootPanel, null, "EndDate");
            var endDate = endDateCmp.getValue();
            var checkedNodes = view.baseTree.getChecked();
            var checkedLinks = [];
            Ext.each(checkedNodes, function(node) {
                checkedLinks.push(node.id + "_" + KS.Grid.getAnyCase(node, "parentId"));
            });

            view.serverCall({
                method: "ReloadJournal",
                params: [startDate, endDate, checkedLinks],
                success: function() {
                    view.mainGrid.reload();
                }
            });
        },

        cleanJournal: function() {
            var view = this.parentView;
            var startDateCmp = view.getToolbarItem(view.rootPanel, null, "StartDate");
            var startDate = startDateCmp.getValue();
            var startDateString = KS.formatDate(startDate);
            var endDateCmp = view.getToolbarItem(view.rootPanel, null, "EndDate");
            var endDate = endDateCmp.getValue();
            var endDateString = KS.formatDate(endDate);
            KS.confirm("Удалить все записи за период с " + startDateString + " по " + endDateString + "?", "Внимание", function (btn) {
                if (btn === 'yes') {
                    view.serverCall({
                        method: "CleanJournalForSelectPeriod",
                        params: [startDate, endDate],
                        success: function() {
                            view.mainGrid.reload();
                        }
                    });
                }
            });
        },

        cleanUsers: function() {
            var view = this.parentView;
            view.serverCall({
                method: 'CleanUsers',
                disableFog: true,
                success: function() {
                    view.getToolbarItem(view.subPanel, null, "usersField").setValue("");
                    view.refreshJournal();
                }
            });
        },

        selectUsers: function() {
            var view = this.parentView;
            view.serverCall({
                method: 'GetSelectUsersGrid',
                disableFog: true,
                success: view.showSelectUsersGrid
            });
        },

        showSelectUsersGrid: function(grid) {
            var view = this;
            view.selectUsersGrid = this.createTemplateControl(grid);
            view.selectUsersWin = KS.showModal(view.selectUsersGrid, {
                title: 'Выберите значение...',
                autoHeight: false,
                modal: true,
                height: 600,
                width: 700,
                buttonAlign: 'left',
                buttons: ['->', {
                        text: 'ОК',
                        cls: 'dim-button',
                        scope: view,
                        handler: function() {
                            view.setSelectedUsers();
                        }
                    }, { xtype: 'tbspacer', width: 8 },
                    {
                        text: 'Отмена',
                        cls: 'dim-button',
                        handler: function() {
                            view.selectUsersWin.close();
                        }
                    }]
            }, true);
        },

        setSelectedUsers: function() {
            var view = this;
            var checkedRows = view.selectUsersGrid.getCheckedRows();
            if (!Ext.isEmpty(checkedRows)) {
                var usersNames = [];
                var links = [];
                Ext.each(checkedRows, function(record) {
                    usersNames.push(KS.Grid.getAnyCase(record, "USER"));
                    links.push(KS.Grid.getAnyCase(record, "LINK_LOG_USER"));
                });
                var usersFieldValue = usersNames.join(", ");
                view.serverCall({
                    method: 'SetSelectedUsers',
                    disableFog: true,
                    params: [links],
                    success: function() {
                        var textField = view.getToolbarItem(view.subPanel, null, "usersField");
                        textField.setValue(usersFieldValue);
                        view.refreshJournal();
                        view.selectUsersWin.close();
                    }
                });
            }
        },

        cleanApps: function() {
            var view = this.parentView;
            view.serverCall({
                method: 'CleanApps',
                disableFog: true,
                success: function() {
                    view.getToolbarItem(view.subPanel, null, "appsField").setValue("");
                    view.refreshJournal();
                }
            });
        },

        selectApps: function() {
            var view = this.parentView;
            view.serverCall({
                method: 'GetSelectAppsGrid',
                disableFog: true,
                success: view.showSelectAppsGrid
            });
        },

        showSelectAppsGrid: function(grid) {
            var view = this;
            view.selectAppsGrid = this.createTemplateControl(grid);
            view.selectAppsWin = KS.showModal(view.selectAppsGrid, {
                title: 'Выберите значение...',
                autoHeight: false,
                modal: true,
                height: 600,
                width: 700,
                buttonAlign: 'left',
                buttons: ['->', {
                        text: 'ОК',
                        cls: 'dim-button',
                        scope: view,
                        handler: function() {
                            view.setSelectedApps();
                        }
                    }, { xtype: 'tbspacer', width: 8 },
                    {
                        text: 'Отмена',
                        cls: 'dim-button',
                        handler: function() {
                            view.selectAppsWin.close();
                        }
                    }]
            }, true);
        },

        setSelectedApps: function() {
            var view = this;
            var checkedRows = view.selectAppsGrid.getCheckedRows();
            if (!Ext.isEmpty(checkedRows)) {
                var appsNames = [];
                var links = [];
                Ext.each(checkedRows, function(record) {
                    appsNames.push(KS.Grid.getAnyCase(record, "CODE"));
                    links.push(KS.Grid.getAnyCase(record, "LINK_APPLICATION"));
                });
                var appsFieldValue = appsNames.join(", ");
                view.serverCall({
                    method: 'SetSelectedApps',
                    disableFog: true,
                    params: [links],
                    success: function() {
                        var textField = view.getToolbarItem(view.subPanel, null, "appsField");
                        textField.setValue(appsFieldValue);
                        view.refreshJournal();
                        view.selectAppsWin.close();
                    }
                });
            }
        },

        cleanHosts: function() {
            var view = this.parentView;
            view.serverCall({
                method: 'CleanHosts',
                disableFog: true,
                success: function() {
                    view.getToolbarItem(view.subPanel, null, "hostsField").setValue("");
                    view.refreshJournal();
                }
            });
        },

        selectHosts: function() {
            var view = this.parentView;
            view.serverCall({
                method: 'GetSelectHostsGrid',
                disableFog: true,
                success: view.showSelectHostsGrid
            });
        },

        showSelectHostsGrid: function(grid) {
            var view = this;
            view.selectHostsGrid = this.createTemplateControl(grid);
            view.selectHostsWin = KS.showModal(view.selectHostsGrid, {
                title: 'Выберите значение...',
                autoHeight: false,
                modal: true,
                height: 600,
                width: 700,
                buttonAlign: 'left',
                buttons: ['->', {
                        text: 'ОК',
                        cls: 'dim-button',
                        scope: view,
                        handler: function() {
                            view.setSelectedHosts();
                        }
                    }, { xtype: 'tbspacer', width: 8 },
                    {
                        text: 'Отмена',
                        cls: 'dim-button',
                        handler: function() {
                            view.selectHostsWin.close();
                        }
                    }]
            }, true);
        },

        setSelectedHosts: function() {
            var view = this;
            var checkedRows = view.selectHostsGrid.getCheckedRows();
            if (!Ext.isEmpty(checkedRows)) {
                var hostsNames = [];
                var links = [];
                Ext.each(checkedRows, function(record) {
                    hostsNames.push(KS.Grid.getAnyCase(record, "CODE"));
                    links.push(KS.Grid.getAnyCase(record, "LINK_HOST"));
                });
                var hostsFieldValue = hostsNames.join(", ");
                view.serverCall({
                    method: 'SetSelectedHosts',
                    disableFog: true,
                    params: [links],
                    success: function() {
                        var textField = view.getToolbarItem(view.subPanel, null, "hostsField");
                        textField.setValue(hostsFieldValue);
                        view.refreshJournal();
                        view.selectHostsWin.close();
                    }
                });
            }
        }
    });
}(SystemJournalView.prototype));