﻿// ============= VIEW =======================
SavedFormCheckKSView = KS.extend(BaseDictionaryView, {});
var vc = SavedFormCheckKSView.prototype;

(function(viewClass) {
    var sc = SavedFormCheckKSView.superclass;
    var progressRefreshInterval = 5 * 1000;

    KS.apply(viewClass,
        {
            getTbarClickHandler: function(tbarItem) {
                switch (tbarItem.code) {
                case 'recalc':
                    return this.recalculate;

                case 'html':
                case 'excel':
                case 'openoffice':
                    return this.getProtocolAs;
                }
                return sc.getTbarClickHandler.apply(this, arguments);
            },

            onTemplateRendered: function() {
                if(!this.data || !this.data.identifier) return;
                var id = this.data.identifier;
                this.deferred = id.DeferredCalculate;
                this.action = id.ActionType;
                this.panel.update(this.getStartMsg());
                if (this.deferred) {
                    this.fullLinksSet = [];
                    this.deferred = {
                        total: this.data.total,
                        current: 0
                    };
                    this.executeCalculations();
                } else {
                    this.renderProtocol();
                }
                if (this.action == 5)
                    this.refreshTaskList();
            },

            afterRenderProtocolPanel: function() {
                this.hideProgressMessage();
                KS.updateLayout(this.panel);
            },

            getStartMsg: function() {
                return this.deferred
                    ? 'Документов в обработке: ' + this.data.total
                    : 'Подготовка протокола';
            },

            recalculate: function () {
                var view = this.parentView || this;
                if (!view.deferred) return;
                view.deferred.linksToProcess = [].concat(view.fullLinksSet);
                view.deferred.current = 0;
                view.panel.update(view.getStartMsg(view.fullLinksSet));
                view.serverCall({
                    method: 'ResetCalculationResults',
                    waitMessage: 'Подготовка к вычислениям ...',
                    success: view.executeCalculationsCallback
                });
            },

            executeCalculations: function() {
                this.renderProtocol();
                var def = this.deferred;
                if (!def || def.current >= def.total) return;
                var isLast = (++def.current >= def.total);
                this.serverCall({
                    method: 'ExecuteCalculations',
                    waitMessage: this.buildProgressMessage(),
                    timeout: 10 * progressRefreshInterval,
                    params: [this.deferred.current, isLast],
                    cancellable: true,
                    abort: this.cancelCalculations,
                    success: this.executeCalculationsCallback,
                    delay: this.getProgressMessage
                });
            },

            executeCalculationsCallback: function(data) {
                this.data = data;
                this.executeCalculations();
            },

            cancelCalculations: function () {
                var view = this.viewContext || this;
                view.stopProgressTimer();
                view.deferred = null;
                view.serverCall({
                    method: 'CancelCalculations',
                    waitMessage: 'Отмена выполнения ...',
                    success: view.reloadProtocol
                });
            },

            getProgressMessage: function() {
                this.serverCall({
                    method: 'GetProgressMessage',
                    disableFog: true,
                    success: this.getProgressMessageCallback
                });
            },

            getProgressMessageCallback: function(msg) {
                if (Ext.isEmpty(msg)) {
                    this.reloadProtocol();
                } else {
                    this.showProgressMessage(msg);
                    var view = this;
                    view.progressTimerId = setTimeout(function() {
                            view.getProgressMessage();
                        },
                        progressRefreshInterval);
                }
            },

            buildProgressMessage: function (statusMsg) {
                var def = this.deferred,
                    msg = '';
                if (def && def.current <= def.total) {
                    msg += 'Проверка отчета ' + def.current + ' из ' + def.total;
                }
                if (!KS.isEmpty(statusMsg)) {
                    msg += '<br/>' + statusMsg + '<br/><img src="PlatformHandler.axd?res=loading.gif"/>' + 
                        '<br/><a class="cancel_link" onclick="KS.getView(' + "'" + this.viewID + "'" + ').cancelCalculations();return false;" href="">Отменить</a>';
                }
                return msg;
            },

            hideProgressMessage: function() {
                this.panel.body.unmask();
            },

            showProgressMessage: function (msg) {
                this.hideProgressMessage();
                this.panel.body.mask(this.buildProgressMessage(msg));
            },

            stopProgressTimer: function() {
                if (this.progressTimerId)
                    clearInterval(this.progressTimerId);
            },

            reloadProtocol: function() {
                this.serverCall({
                    method: 'ReloadProtocol',
                    waitMessage: 'Чтение протокола ...',
                    success: this.executeCalculationsCallback
                });
            },

            renderProtocol: function() {
                var html = this.resolveViewId(this.data.inlineProtocol);
                if (Ext.isString(html)) {
                    //this.panel.body.mask('...');
                    var view = this;
                    this.panel.update(html,
                        false,
                        function() {
                            view.afterRenderProtocolPanel();
                            setTimeout(function() {
                                    view.afterRenderProtocolPanel();
                                },
                                500);
                        });
                }
            },

            getProtocolAs: function() {
                this.parentView.serverCall({
                    method: 'GetProtocolAs',
                    waitMessage: 'Обработка протокола ...',
                    params: [this.actionIdx || 0, (this.tbarNode) ? this.tbarNode.code : this.text, !Ext.isEmpty(this.tbarNode)],
                    success: this.parentView.openUrl
                });
            },

            onBeforeClose: function() {
                this.stopProgressTimer();
                return sc.onBeforeClose.call(this);
            }
        });
}(vc));

function reportCalculationGetProtocolAs(viewId, format, actionIdx) {
    var view = KS.getView(viewId);
    if (view) {
        view.getProtocolAs.call({
            text: format,
            parentView: view,
            actionIdx: actionIdx
        });
    }
}

if (typeof(Sys) !== 'undefined') Sys.Application.notifyScriptLoaded();