﻿PlanningTasksView = KS.extend(BaseDictionaryView, { });

// ============= TOOLBAR =======================
(function (viewClass) {
    var sc = PlanningTasksView.superclass;

    KS.apply(viewClass, {

        // Для инверсий и отмечаний
        findOwnerGrid: function() {
            return this.mainGrid;
        },

        buildContainerToolbarItemControl: function(tbarItem) {
            if (tbarItem.code.indexOf("COLOR_") !== -1 && tbarItem.additional.color) {
                var color = convertToHexString(tbarItem.additional.color);
                return new Ext.panel.Panel({
                    bodyStyle: {"background-color": color},
                    height: 20,
                    width: 20,
                    border: false
                });
            }
            return sc.buildContainerToolbarItemControl.apply(this, arguments);
        },
        
        getTbarClickHandler: function(tbarItem) {
            if (!tbarItem) return null;
            if (!this.checkHandler(tbarItem.pluginNameWeb)) {
                switch (tbarItem.code) {
                    case 'CALENDAR':
                        return this.openCalendar;
                }
            }
            return sc.getTbarClickHandler.call(this, tbarItem);
        },

        openCalendar: function() {
            var view = this.parentView || this;

            if (!window.planningCalendarClassAdded) {
                $("<style type='text/css'>" +
                    ".planningCalendar .x-datepicker-disabled .x-datepicker-date {" +
                    "color: red; " +
                    "background: inherit; " +
                    "}" +
                    ".planningCalendar .x-datepicker-disabled .x-datepicker-date:hover {" +
                    "color: red; " +
                    "}" +
                    "</style>").appendTo("head");
                window.planningCalendarClassAdded = true;
            }

            view.planningCalendar = new Ext.picker.Date({
                disabledDays : [0, 6],
                cls : 'planningCalendar',
                disabledDaysText : ""
            });

            view.planningCalendarWin = KS.showModal(view.planningCalendar, {
                title: "Календарь",
                autoHeight: false,
                width: 300,
                minWidth: 300,
                height: 270,
                minHeight: 270,
                buttonAlign: 'center',
                buttons: new Array({
                    text: "Закрыть",
                    cls: "dim-button",
                    handler: function () {
                        view.planningCalendarWin.close();
                    }
                })
            }, true);

//            view.serverCall({
//                method: 'OpenCalendar'
//            });
        },

        notReadyCheckChange: function(comp, newValue) {
            var view = this;
            this.serverCall({
                method: 'NotReadyCheckChange',
                params: [newValue],
                success: function() {
                    view.mainGrid.reload();
                }
            });
        },

        urlClick: function(closeCode) {
            this.serverCall({
                method: 'UrlClick',
                params: [closeCode]
            });
        }
    });
}(PlanningTasksView.prototype));

function planningTasksUrlRenderer(value, metadata, record, rowIndex, colIndex, store) {
    if (value.toLowerCase() === "отчет не создан")
        return value;

    return '<span class="like-hypertext" onclick="KS.getView(' + "'" + store.grid.parentView.viewID + "'" + ').urlClick(' + store.grid.getCloseCode(store.getAt(rowIndex)) + ');return false;"/>' + value + '</span>';
}

if (typeof(Sys) !== 'undefined') Sys.Application.notifyScriptLoaded();