﻿ObjectAccessView =  KS.extend(BaseSvodView, { });
var sc = ObjectAccessView.superclass;

// ============= COMMON =======================
(function(viewClass) {
    KS.apply(viewClass,
        {
            onTemplateRendered: function() {
                this.accessObjectTree.selectFirstNode();
            },
            
            setPermissions: function() {
                var view = this.parentView;
                var code = this.tbarNode.code || '';
                var mode = 0;
                var set = true;
                switch (code) {
                    case "SET":
                    case "SET2":
                        mode = 0;
                        set = true;
                        break;
                    case "SET_CURRENT":
                        mode = 1;
                        set = true;
                        break;
                    case "SET_CHILDREN":
                        mode = 2;
                        set = true;
                        break;
                    case "RESET":
                    case "RESET2":
                        mode = 0;
                        set = false;
                        break;
                    case "RESET_CURRENT":
                        mode = 1;
                        set = false;
                        break;
                    case "RESET_CHILDREN":
                        mode = 2;
                        set = false;
                        break;
                }
                var msg = view.getPermissionsMsg(mode, set);
                view.serverCall({
                    method: 'GetPermissons',
                    success: function(permissions) {
                        view.showSetPermissionsPanel(permissions, msg, mode, set);
                    }
                });
            },

            showSetPermissionsPanel: function(permissions, msg, mode, set) {
                var view = this;
                var pemrItems = view.getPermChecks(permissions);
                view.setPermissionsPanel = KS.showModal([
                    {
                        xtype: 'label',
                        text: msg,
                        padding: 10
                    }, {
                        xtype: 'checkboxgroup',
                        itemId : "checkPermGroup",
                        columns: 2,
                        width: 250,
                        vertical: true,
                        items: pemrItems 
                    }], {
                    layout: 'vbox',
                    plain: true,
                    frame: true,
                    modal: true,
                    maximizable: false,
                    minHeight: 110,
                    height: 270,
                    width: 300,
                    resizable: false,
                    title: "Выбор значения",
                    buttonAlign: 'left',
                    buttons: new Array('->', {
                            text: 'ОК',
                            cls: 'dim-button',
                            handler: function () {
                                var permissions = view.setPermissionsPanel.getComponent("checkPermGroup").getChecked();
                                view.doSetPermissions(permissions, mode, set);
                            }
                        }, { xtype: 'tbspacer', width: 8 },
                        {
                            text: 'Отмена',
                            cls: 'dim-button',
                            handler: function() {
                                view.setPermissionsPanel.close();
                            }
                        })
                }, true);
            },

            doSetPermissions: function(permissions, mode, set) {
                var view = this;
                var tree = this.treesTabPanel.getActiveTab();
                var nodeId = tree.getSelected();
                var treeId = tree.ctrlId;
                var permNames = [];
                Ext.each(permissions,  function(perm) {
                    permNames.push(perm.inputValue);
                });
                this.serverCall({
                    method: 'SetPermissions',
                    params: [permNames, mode, set, treeId, nodeId],
                    success: function() {
                        view.touch();
                        view.reelectTreeNode();
                        view.setPermissionsPanel.close();
                    }
                });
            },

            getPermChecks: function(permissions) {
                var permChecks = [];
                var i = 0;
                Ext.each(permissions,  function(permName) {
                    permChecks.push({ boxLabel: permName, name: 'permCheck', inputValue: i, checked: true });
                    i++;
                });
                return permChecks;
            },

            getPermissionsMsg: function(mode, set) {
                var msg = "";
                switch (mode)
                {
                    case 0:
                        msg = (set ? "Назначить" : "Сбросить") + " доступ на все объекты";
                        break;

                    case 1:
                        msg = (set ? "Назначить" : "Сбросить") + " доступ на текущий объект";
                        break;

                    case 2:
                        msg = (set ? "Назначить" : "Сбросить") + " доступ на дочерние объекты";
                        break;
                }
                return msg;
            },

            touch: function () {
                this.hasChanges = true;
                this.setSavedState(false);
                this.getToolbarItem(this.rootPanel, null, 'SAVE').setDisabled(false);
                this.getToolbarItem(this.rootPanel, "bottom", 'APPLY').setDisabled(false);
            },
            
            discardChanges: function () {
                this.hasChanges = false;
                this.setSavedState(true);
                this.getToolbarItem(this.rootPanel, null, 'SAVE').setDisabled(true);
                this.getToolbarItem(this.rootPanel, "bottom", 'APPLY').setDisabled(true);

                this.reelectTreeNode();
            },

            // Перевыбираем узел дерева, чтобы обновить грид с правами
            reelectTreeNode: function() {
                var tree = this.treesTabPanel.getActiveTab();
                var selNode = tree.getSelNode();
                this.treeNodeSelect(tree.getSelectionModel(), [selNode]);
            },

            saveChanges: function() {
                var view = this.parentView || this;
                view.doSaveChanges();
            },

            doSaveChanges: function() {
                var view = this;
                view.serverCall({
                    method: 'SaveChanges',
                    success: function(result) {
                        if (result) {
                            view.discardChanges();
                        }
                    }
                });
            },

            designAccess: function() {
                var view = this.parentView;
                var tree = view.treesTabPanel.getActiveTab();
                var nodeId = tree.getSelected();
                var treeId = tree.ctrlId;
                view.serverCall({
                    method: 'OpenDesignAccess',
                    params: [treeId, nodeId]
                });
            },

            okBtnClick: function() {
                var view = this.parentView;
                if (view.hasChanges)
                    view.doSaveChanges();
                view.close();
            },

            exitBtnClick: function() {
                this.parentView.close();
            },

            applyBtnClick: function() {
                var view = this.parentView;
                view.doSaveChanges();
            },

            treeNodeSelect: function(treeModel, selected) {
                var nodeId = selected[0].data.id;
                var treeId = treeModel.view.grid.ctrlId;
                this.serverCall({
                    method: 'TreeSelectChange',
                    disableFog: true,
                    params: [treeId, nodeId],
                    success: this.afterTreeSelectChange
                });
            },

            afterTreeSelectChange: function(data) {
                if (!Ext.isEmpty(data) && !Ext.isEmpty(data[0])) {
                    var gridData = data[0];
                    var grid = this.accessGrid;
                    grid.reload(KS.safeDecode(gridData, false));

                    var designBtnDisabled = data[1] === "False";
                    this.getToolbarItem(this.rootPanel, null, 'DESIGN').setDisabled(designBtnDisabled);

                    var gridView = grid.getView();
                    grid.store.each(function(rec) {
                        var editable = KS.Grid.getAnyCase(rec, "VISIBLE");
                        gridView.removeRowCls(rec, "ks-cell-disabled");
                        if (!editable) {
                            gridView.addRowCls(rec, "ks-cell-disabled");
                        }
                    });
                }
            },

            accessGridCellClick: function(gridView, td, cellIndex, record, tr, rowIndex) {
                var column = gridView.grid.getColumns()[cellIndex];
                if (column && column.aspType === "checkcolumn") {
                    var editable = KS.Grid.getAnyCase(record, "VISIBLE");
                    if (!editable) {
                        record.set(column.dataIndex, !record.get(column.dataIndex));
                        return false;
                    }
                    if (column.dataIndex === "GRANT" && record.get(column.dataIndex) === true) {
                        record.set("DENY", false);
                    }                    
                    if (column.dataIndex === "DENY" && record.get(column.dataIndex) === true) {
                        record.set("GRANT", false);
                    }
                    var grant = record.get("GRANT");
                    var deny = record.get("DENY");
                    var tree = this.treesTabPanel.getActiveTab();
                    var treeId = tree.ctrlId;
                    var nodeId = tree.getSelected();
                    this.serverCall({
                        method: 'AccessGridChange',
                        disableFog: true,
                        params: [grant, deny, rowIndex, treeId, nodeId]
                    });
                    this.touch();
                }
                return true;
            }
        });
}(ObjectAccessView.prototype));

if (typeof(Sys) !== 'undefined') Sys.Application.notifyScriptLoaded();