﻿ExtendedDictionaryView = KS.extend(BaseDictionaryView, {});

// ============= COMMON =======================
(function(viewClass) {
    KS.apply(viewClass, {
        saveErrorMsg: '',

        saveChanges: function(close) {
            var view = this.parentView || this;
            if (view.data.isDictionaryLiquidation) {
                KS.confirm(view.data.liquidationSaveMsg, "Внимание", function (btn) {
                    if (btn === "yes") view.doSaveChanges(close);
                });
            } else {
                view.doSaveChanges(close);
            }            
        },

        doSaveChanges: function(close) {
            var sc = ExtendedDictionaryView.superclass;
            sc.saveChanges.apply(this, arguments);
        },

        cellDblClickHandler: function(gridView, td, cellIndex, record, tr, rowIndex, e) {
            var column = e.position.column;
            var dataIndex = column.dataIndex;

            if (column.renderer === dictRenderer) {
                var link = KS.Grid.getAnyCase(record, gridView.grid.closeCode);
                
                if (dataIndex.toUpperCase() === "PERIOD") {
                    this.getSelectPeriodPanel(link);
                    return false;
                }

                this.serverCall({
                    method: 'OpenDictionary',
                    params: [dataIndex, link]
                });
                return false;
            }

            switch (dataIndex.toUpperCase()) {
                case "ATTRIBUTE":
                case "NOTE":
                case "YEAR":
                    this.showPopupStringEditor(dataIndex.toUpperCase(), record);
                    return false;
            }
        },

        newHandler: function() {
            var view = this.parentView || this;
            view.serverCall({
                method: 'AddRecord',
                disableFog: true,
                success: function(dataRow) {
                    if (dataRow) {
                        view.mainGrid.addRecord(dataRow);
                        view.touch();
                    }
                }
            });
        },

        copyHandler: function() {
            var view = this.parentView || this;
            var checkedCodes = view.mainGrid.getCheckedCodes();
            if (Ext.isEmpty(checkedCodes)) return;
            view.serverCall({
                method: 'CopyRecord',
                params: [checkedCodes],
                success: function(dataRows) {
                    if (!Ext.isEmpty(dataRows)){
                        Ext.each(dataRows, function(dataRow){
                            view.mainGrid.addRecord(dataRow);
                        })
                        view.touch();
                    }
                }
            });
        },

        showPopupStringEditor: function (dataIndex, record) {
            var view = this;
            var isYear = dataIndex === "YEAR";
            var column = view.mainGrid.getColConfigByKey(dataIndex);
            var value = KS.Grid.getAnyCase(record, dataIndex);

            var editor = {
                xtype: 'textarea',
                itemId: 'pseArea',
                value: isYear && Ext.isEmpty(value)
                    ? (new Date()).getFullYear()
                    : value
            };

            if (column.tag && column.tag.maxLength){
                editor.maxLength = column.tag.maxLength;
                if (column.tag.enforceMaxLength)
                    editor.enforceMaxLength = column.tag.enforceMaxLength;
            }

            if (isYear){
                editor.xtype = 'numberfield';
                editor.minValue = 1800;
                editor.maxValue = 2100;
                editor.width = 190;
            }

            view.pseWin = KS.showModal(editor,
            {
                layout: isYear ? 'vbox' : 'fit',
                plain: true,
                frame: true,
                autoScroll: !isYear,
                modal: true,
                maximizable: true,
                minWidth: 200,
                minHeight: 110,
                width: isYear ? 200 : Math.max(400, KS.rootViewport.getWidth() / 2),
                height: isYear ? 110 : Math.max(300, KS.rootViewport.getHeight() / 1.5),
                title: isYear ? "Введите год" : "Введите значение",
                buttonAlign: 'right',
                buttons: [{
                        text: 'ОК',
                        cls: 'dim-button',
                        handler: function () {
                            var pseArea = view.pseWin.getComponent("pseArea");
                            if (pseArea.validate()) {
                                var newValue = pseArea.getValue();
                                view.editCell({
                                    value: newValue,
                                    originalValue: value,
                                    field: dataIndex,
                                    record: record
                                });
                                view.pseWin.close();
                            } else {
                                KS.alert(pseArea.activeError, 'Внимание')
                            }
                        }
                    }, { xtype: 'tbspacer', width: 8 },
                    {
                        text: 'Отмена',
                        cls: 'dim-button',
                        handler: function() {
                            view.pseWin.close();
                        }
                    }]
            }, true);

            view.pseWin.getComponent("pseArea").focus();
            view.pseWin.getComponent("pseArea").selectText(value.toString().length);
        },

        editCell: function(context) {
            var value = context.value;
            var dataIndex = context.field;

            if (value === null || value === context.originalValue ||
                (dataIndex === "YEAR" && !Ext.isNumeric(value))) 
                return false;

            var view = this;
            var closeCode = KS.Grid.getAnyCase(context.record, this.mainGrid.closeCode);

            view.serverCall({
                method: 'EditCell',
                params: [dataIndex, closeCode, value],
                disableFog: true,
                success: function(result) {
                    if (result) {
                        context.record.set(dataIndex, value);
                        view.touch();
                    }
                }
            });
            return true;
        },
        
        editGridCell: function(plugin, context) {
            if (context.field.toUpperCase() !== 'CHECKED')
                this.editCell(context);
        },

        getSelectPeriodPanel: function(link) {
            var view = this;
            view.selectedPeriodRowLink = link;
            view.serverCall({
                method: 'GetSelectPeriodGrid',
                disableFog: true,
                success: function(grid) {
                    view.showSelectPeriodGrid(grid);
                }
            });
        },

        showSelectPeriodGrid: function(grid) {
            var view = this;
            view.selectPeriodGrid = KS.create(grid);
            view.selectPeriodWin = KS.showModal(view.selectPeriodGrid, {
                title: 'Выберите значение...',
                autoHeight: false,
                resizable: true,
                autoScroll: true,
                maximizable: true,
                width: Math.max(400, KS.rootViewport.getWidth() / 2),
                height: Math.max(300, KS.rootViewport.getHeight() / 1.5),
                minHeight: 300,
                minWidth: 400,
                buttonAlign: 'left',
                buttons: ['->', {
                        text: 'ОК',
                        cls: 'dim-button',
                        handler: function () {
                            view.selectPeriods();
                        }
                    }, { xtype: 'tbspacer', width: 8 },
                    {
                        text: 'Отмена',
                        cls: 'dim-button',
                        handler: function() {
                            view.selectPeriodWin.close();
                        }
                    }]
            }, true);
        },

        selectPeriods: function() {
            var view = this;
            view.selectedPeriods = [];
            view.periodsQueue = [];
            var selectedPeriodsRows = view.selectPeriodGrid.getCheckedRows();
            if (!Ext.isEmpty(selectedPeriodsRows)) {
                Ext.each(selectedPeriodsRows,
                    function(period) {
                        view.periodsQueue.push(period.data);
                    });

                view.processQueuedActions();
            } else {
                view.deletePeriods();
            }
            view.selectPeriodWin.close();
        },

        processQueuedActions: function() {
            if (!Ext.isEmpty(this.periodsQueue)) {
                var period = this.periodsQueue.splice(0, 1)[0];

                //Указаный год
                var selectedRecord = this.mainGrid.findRecord(this.selectedPeriodRowLink, this.mainGrid.closeCode.toLowerCase());
                var year = selectedRecord != null ? KS.Grid.getAnyCase(selectedRecord, "YEAR") : null;

                var periodType = period["PERIOD_TYPE"];
                if (periodType == 8 && !Ext.isEmpty(year)) {
                    this.selectPeriodWeek(period);
                } else if (periodType == 16 && !Ext.isEmpty(year)) {
                    this.selectPeriodDay(period);
                } else {
                    this.selectedPeriods.push(period);
                    this.processQueuedActions();
                }
            } else {
                this.doSelectPeriods();
            }
        },

        selectPeriodWeek: function(period) {
            var view = this;
            view.serverCall({
                method: 'GetPeriodWeekGrid',
                params: [view.selectedPeriodRowLink],
                success: function(grid) {
                    view.showPeriodWeekGrid(grid, period);
                }
            });
        },

        showPeriodWeekGrid: function(grid, period) {
            var view = this;
            view.periodWeekGrid = KS.create(grid);
            view.periodWeekWin = KS.showModal(view.periodWeekGrid, {
                title: 'Выберите значение...',
                autoHeight: false,
                resizable: true,
                autoScroll: true,
                maximizable: true,
                width: Math.max(400, KS.rootViewport.getWidth() / 2),
                height: Math.max(300, KS.rootViewport.getHeight() / 1.5),
                minHeight: 300,
                minWidth: 400,
                buttonAlign: 'left',
                buttons: ['->', {
                        text: 'ОК',
                        cls: 'dim-button',
                        handler: function () {
                            var selectedWeeks = view.periodWeekGrid.getCheckedRows();
                            if (!Ext.isEmpty(selectedWeeks)) {
                                period["PERIOD_NUMBER"] = KS.Grid.getAnyCase(selectedWeeks[0], "WEEK_NUMBER");

                                view.periodWeekWin.close();
                                view.selectedPeriods.push(period);
                                view.processQueuedActions();
                            }
                        }
                    }, { xtype: 'tbspacer', width: 8 },
                    {
                        text: 'Отмена',
                        cls: 'dim-button',
                        handler: function() {
                            view.periodWeekWin.close();
                            view.selectedPeriods.push(period);
                            view.processQueuedActions();
                        }
                    }]
            }, true);
        },

        selectPeriodDay: function(period) {
            var view = this;
            view.periodDayWin = KS.showModal({
                xtype: 'numberfield',
                itemId: 'periodDay',
                minValue: 1,
                maxValue: 366,
                width: 190
            }, {
                layout: 'vbox',
                title: 'Введите номер дня',
                autoHeight: false,
                resizable: true,
                maximizable: true,
                width: 200,
                height: 110,
                minWidth: 200,
                minHeight: 110,
                buttonAlign: 'left',
                buttons: ['->', {
                        text: 'ОК',
                        cls: 'dim-button',
                        handler: function () {
                            var periodDay = view.periodDayWin.getComponent("periodDay");
                            if (periodDay.validate()) {
                                var newValue = view.periodDayWin.getComponent("periodDay").getValue();
                                if (Ext.isNumeric(newValue))
                                    period["PERIOD_NUMBER"] = newValue;

                                view.periodDayWin.close();
                                view.selectedPeriods.push(period);
                                view.processQueuedActions();
                            } else {
                                KS.alert(periodDay.activeError, 'Внимание')
                            }
                        }
                    }, { xtype: 'tbspacer', width: 8 },
                    {
                        text: 'Отмена',
                        cls: 'dim-button',
                        handler: function() {
                            view.periodDayWin.close();
                            view.selectedPeriods.push(period);
                            view.processQueuedActions();
                        }
                    }]
            }, true);
        },
        
        doSelectPeriods: function() {
            if (!Ext.isEmpty(this.selectedPeriods)) {
                var view = this;
                view.serverCall({
                    method: 'SelectPeriods',
                    params: [this.selectedPeriods, this.selectedPeriodRowLink],
                    success: function() {
                        view.touch();
                        view.mainGrid.reload();
                    }
                });
            }
        },

        deletePeriods: function() {
            var view = this;
            view.serverCall({
                method: 'DeletePeriods',
                params: [this.selectedPeriodRowLink],
                success: function() {
                    view.touch();
                    view.mainGrid.reload();
                }
            });
        }
    });
}(ExtendedDictionaryView.prototype));

if (typeof (Sys) !== 'undefined') { Sys.Application.notifyScriptLoaded(); }