ExportReportsToWebView = KS.extend(BaseSvodView, {});

// ============= BASE =======================
(function (viewClass) {
    KS.apply(viewClass, {
        resetView: function () {
            this.mainGrid.reload();
        },
        
        openSettings: function(){
            var view = this.parentView || this;
            view.serverCall({
                method: 'OpenSettings'
            });
        },

        markInvertHandler: function(){
            this.parentView.mainGrid.markInvert();
        },

        unmarkHandler: function(){
            this.parentView.mainGrid.unmark();
        },
        
        export: function(){
            var view = this.parentView || this;
            var settings = view.getSettings();
            var checekdCodes = view.mainGrid.getCheckedCodes();
            view.serverCall({
                method: 'Export',
                waitMessage: 'Передача отчетов...',
                params: [settings, checekdCodes]
            });
        },

        getSettings: function(){
            return {
                SvodUrl: this.svodUrl.getValue(),
                SvodUser: this.svodUser.getValue(),
                SvodPwd: this.svodPwd.getValue(),
                SetReadyStatus: this.setReadyStatus.getValue(),
                CheckKS: this.checkKS.getValue(),
                SendSign: this.sendSign.getValue(),
                NewVersion: this.newVersion.getValue(),
                VersionType: this.versionType.getValue().versionType
            }
        },

        onServerReloadGrid: function(){
            this.mainGrid.reload();  
        },

        newVersionChange: function(comp, newValue){
            this.versionType.setHidden(!newValue);
        },
        
        showDescription: function(savedFormLink, databaseLink){
            this.serverCall({
                method: 'ShowDescription',
                params: [savedFormLink, databaseLink]
            });
        }
    });
}(ExportReportsToWebView.prototype));

function descriptionRenderer(value, metadata, record, rowIndex, colIndex, store){
    if (!Ext.isEmpty(value)) {
        var viewId = store.grid.parentView.viewID;
        var savedFormLink = KS.Grid.getAnyCase(record, "LINK_SAVED_FORM");
        var databaseLink = KS.Grid.getAnyCase(record, "LINK_DATABASE");
        var newValue = value.replace(/<\/?[^>]+(>|$)/g, ""); // удаляем старую гиперссылку
        return '<span class="like-hypertext" onclick="KS.getView(' + "'" + viewId + "'" + ').showDescription(' + savedFormLink + ',' + databaseLink +');return false;"/>' + newValue + '</span>';
    }
    return value;
}