﻿EgrulDictionaryView = KS.extend(BaseDictionaryView, { });

// ============= COMMON =======================
(function(viewClass) {
    var sc = EgrulDictionaryView.superclass;

    KS.apply(viewClass, {
        getTbarClickHandler: function (tbarItem) {
            switch (tbarItem.code) {
                case 'NEW':
                    return this.addNewRecordInternal;

                case 'EDIT':
                    return this.editRecordInternal;

                case 'DELETE':
                    return this.deleteRecord;

                case 'LOAD':
                    return this.loadEgrulDict;

                case 'SAVE':
                case 'REFRESH':
                case 'EXIT':
                case 'MARK_INVERT':
                case 'MARK_INVERT2':
                case 'MARK_TOP':
                case 'MARK_ALL':
                case 'MARK_REST':
                case 'MARK_BETWEEN':
                case 'UNMARK':
                    return sc.getTbarClickHandler.apply(this, arguments);

                default:
                    return sc.getTbarClickHandler.apply(this, arguments);
            }
        },

        getPropertyGridWindow: function (settings, link, isNew) {
            var view = this.parentView || this;
            view.propertyGrid = view.getPropertyGridByOption(settings, "generalPropertyGrid", "Общие");
            view.editVersionWin = KS.showModal(view.propertyGrid, {
                title: 'Свойства',
                autoHeight: false,
                layout: 'anchor',
                height: 400,
                minHeight: 200,
                width: 600,
                minWidth: 300,
                buttonAlign: 'left',
                buttons: ['->', {
                    text: 'ОК',
                    cls: 'dim-button',
                    handler: function () {
                        view.doEditRecordInternal(link, isNew);
                    }
                }, { xtype: 'tbspacer', width: 8 },
                    {
                        text: 'Отмена',
                        cls: 'dim-button',
                        handler: function() {
                            view.editVersionWin.close();
                        }
                    }]
            }, true);
        },

        addNewRecordInternal: function () {
            var view = this.parentView || this;
            view.serverCall({
                method: 'GetGridProperties',
                params: [null, true],
                waitMessage: 'Получение свойств ... ',
                success: function(settings) {
                    view.getPropertyGridWindow(settings, null, true);
                }
            });
        },

        rowDblClickHandler: function() {
            this.editRecordInternal();
        },

        editRecordInternal: function () {
            var view = this.parentView || this,
                grid = view.mainGrid,
                rows = grid.getCheckedRows();
            if (Ext.isEmpty(rows)) return;
            var link = KS.Grid.getAnyCase(rows[0], "LINK");
            view.serverCall({
                method: 'GetGridProperties',
                params: [link, false],
                waitMessage: 'Получение свойств ... ',
                success: function(settings) {
                    view.getPropertyGridWindow(settings, link, false);
                }
            });
        },

        doEditRecordInternal: function (link, isNew) {
            var view = this;
            var newValues = view.propertyGrid.source;
            view.serverCall({
                method: 'EditRecordInternal',
                params: [newValues, link, isNew],
                waitMessage: 'Редактирование ...',
                success: function (success) {
                    if (success) {
                        view.touch();
                        view.editVersionWin.close();
                        view.mainGrid.reload();
                    }
                }
            });
        },

        deleteRecord: function () {
            var view = this.parentView || this,
                grid = view.mainGrid,
                rows = grid.getCheckedRows();
            if (Ext.isEmpty(rows)) return;

            var linkList = [];
            Ext.each(rows, function(row) {
                var link = KS.Grid.getAnyCase(row, 'LINK');
                linkList.push(link);
            })

            KS.confirm("Будет удалено строк: " + rows.length + ". Продолжить?",
                "Подтвердите удаление", function (btn) {
                    if (btn === 'yes')
                        view.deleteRecordInternal(linkList);
                });
        },

        deleteRecordInternal: function (linkList) {
            var view = this;
            view.serverCall({
                method: 'DeleteRecordInternal',
                params: [linkList],
                waitMessage: 'Удаление ...',
                success: function () {
                    view.touch();
                    view.mainGrid.reload()
                }
            });
        },

        loadEgrulDict: function () {
            var view = this.parentView || this,
                grid = view.mainGrid,
                rows = grid.getCheckedRows();

            var innList = [];
            Ext.each(rows, function(row) {
                var inn = KS.Grid.getAnyCase(row, 'inn');
                innList.push(inn);
            })

            view.serverCall({
                method: 'LoadEgrulDict',
                params: [innList],
                waitMessage: 'Загрузка ...'
            });
        }

    });
}(EgrulDictionaryView.prototype));

if (typeof (Sys) !== 'undefined') Sys.Application.notifyScriptLoaded();