﻿DictionaryRRONpaView = KS.extend(BaseDictionaryView, { });

// ============= EDIT =======================
(function(viewClass) {
    KS.apply(viewClass, {
        onTemplateRendered: function() {
            this.discardChanges();
        },

        resetView: function () {
            this.fullReloadGrid();
        },

        editHandler: function(grid, context) {
            if (context.originalValue === context.value ||
                context.column.dataIndex === "CHECKED")  
                return;
            var isDate = Ext.isDate(context.value);
            this.serverCall({
                method: 'SaveCellValue',
                params: [
                    KS.Grid.getAnyCase(context.record, 'CODE') || '', context.field,
                    isDate ? Ext.util.Format.date(context.value, 'Y-m-d') : context.value
                ],
                disableFog: !isDate,
                waitMessage: 'Установка значения ...',
                success: this.touch,
                error: function() {
                    context.record.reject();
                }
            });
        },

        cellDblClickHandler: function(gridView, td, cellIndex, record, tr, rowIndex) {
            var grid = gridView.grid;
            if (!grid.parentView.data.allowEdit)
                return false;
            var col = grid.getColCfgByIndex(cellIndex);

            if (col.renderer === dictionaryNpaTypeRenderer) {
                this.showNpaTypeDictionary(rowIndex, cellIndex);
                return false;
            }

            if (col.renderer === dictionaryNpaOrgFilterRenderer) {
                this.openOrgFilterDictionary(rowIndex);
                return false;
            }

            return true;
        },

        openOrgFilterDictionary: function(rowIndex) {
            var record = this.mainGrid.store.getAt(rowIndex);
            var linkDictRow = KS.Grid.getAnyCase(record, 'LINK_DICTION_ROW_HISTORY');
            this.serverCall({
                method: 'OpenOrgFilterDictionary',
                params: [linkDictRow],
                waitMessageL: 'Открытие словаря...'
            });
        },

        showNpaTypeDictionary: function(rowIndex, colIndex) {
            var view = this;
            var bbarItems = [{
                    text: 'Выбрать',
                    width: 90,
                    cls: 'marked-button',
                    scope: view,
                    handler: view.setNpaTypeValue
                },
                { xtype: 'tbspacer', width: 8 },
                {
                    text: 'Закрыть',
                    cls: 'dim-button',
                    handler: function() {
                        view.ntWin.close();
                    }
                }];
            
            this.npaTypeGrid = KS.create(view.tpl.controls.npaTypeGrid);
            this.npaTypeGrid.rowIndex = rowIndex;
            this.npaTypeGrid.colIndex = colIndex;
            this.npaTypeGrid.on('celldblclick', this.setNpaTypeValue, this);
            this.ntWin = KS.showModal(this.npaTypeGrid, {
                autoHeight: false,
                width: 450,
                height: 350,
                buttonAlign: 'right',
                buttons: bbarItems
            }, true);
        },

        setNpaTypeValue: function() {
            var dataRec = this.mainGrid.store.getAt(this.npaTypeGrid.rowIndex),
                ntRecs = this.npaTypeGrid.getSelectedRecs(),
                ntRec = ntRecs[0];
            if (Ext.isEmpty(ntRec) || Ext.isEmpty(ntRec)) return;
            var dataCol = this.mainGrid.getColCfgByIndex(this.npaTypeGrid.colIndex);
            this.serverCall({
                method: 'SaveCellValue',
                params: [KS.Grid.getAnyCase(dataRec, "CODE") || '', dataCol.dataIndex, KS.Grid.getAnyCase(ntRec, "code")],
                disableFog: true,
                success: function() {
                    this.touch();
                    dataRec.set('NPA_TYPE', KS.Grid.getAnyCase(ntRec, "code"));
                    dataRec.set('NPA_TYPE_STRING', KS.Grid.getAnyCase(ntRec, "col1"));
                }
            });
            this.ntWin.close();
        },

        newHandler: function() {
            var view = this.parentView || this;
            view.serverCall({
                method: 'AddRow',
                disableFog: true,
                success: view.createGridRow
            });
        },

        copyHandler: function() {
            var view = this.parentView || this;
            var ccc = view.mainGrid.getCheckedCodes(true);
            if (Ext.isEmpty(ccc)) return;
            view.serverCall({
                method: 'CopyRow',
                params: [ccc[0]],
                waitMessage: 'Копирование...',
                success: view.createGridRow
            });
        },

        createGridRow: function(dict) {
            if (KS.isEmpty(dict)) return;
            var grid = this.mainGrid;
            this.touch();
            var newRec = this.convertLowToUpDataName(dict);
            grid.store.insert(0, newRec);
            grid.select(0);
        },

        convertLowToUpDataName: function(dict) {
            var newDict = {};
            for (var key in dict) {
                var upper = key.toUpperCase();
                newDict[upper] = dict[key]; 
            }
            return newDict;
        },

        onValuesSelected: function () {
            this.touch();
            this.fullReloadGrid();
        },

        deleteCallback: function(deleted, autoSave) {
            if (deleted) {
                this.fullReloadGrid();

                if (!autoSave)
                    this.touch();
            }
        },

        fullReloadGrid: function () {
            var view = this;
            view.mainGrid.pageCacheLib.reset();
            view.mainGrid.reload();
        }
    });
}(DictionaryRRONpaView.prototype));

function dictionaryNpaTypeRenderer(value, metadata) {
    setTooltip(metadata, value);
    metadata.css += ' npa-dict-cell';
    return value;
}

function dictionaryNpaOrgFilterRenderer(value, metadata) {
    setTooltip(metadata, value);
    metadata.css += ' npa-dict-cell';
    return value;
}

function dictionaryNpaDateRenderer(value, metadata, record, rowIndex, colIndex, store) {
    var colCfg = store.grid.getColCfgByIndex(colIndex);
    if (Ext.isEmpty(value) && record.previousValues && !Ext.isEmpty(record.previousValues[colCfg.dataIndex])) {
        value = record.previousValues[colCfg.dataIndex];
    }
    if (!Ext.isEmpty(value) && (new Date(value) != "Invalid Date")) {
        value = new Date(value);
    }
    if (Ext.isString(value)) {
        if (Ext.isEmpty(value) || value.length < 10) {
            return value;
        } else {
            var parsed = KS.parseAjaxDateTime(value);
            if (parsed) {
                return Ext.util.Format.date(parsed, 'd.m.Y');
            } else {
                return value.substring(0, 10);
            }
        }
    } else {
        return Ext.util.Format.date(value, 'd.m.Y');
    }
}

if (typeof (Sys) !== 'undefined') {Sys.Application.notifyScriptLoaded(); }