﻿DictionaryRRONpaTypeView = KS.extend(BaseDictionaryView, { });

// ============= EDIT =======================
(function(viewClass) {
    KS.apply(viewClass, {
        onTemplateRendered: function() {
            this.discardChanges();
        }, 

        editCellHandler: function(grid, context) {
            if (context.originalValue === context.value ||
                context.column.dataIndex === "CHECKED")  
                return;
            this.touch();
            this.serverCall({
                method: 'SaveCellValue',
                params: [KS.Grid.getAnyCase(context.record, 'CODE') || '', context.field, context.value],
                disableFog: true,
                error: function() {
                    context.record.reject();
                }
            });
        },

        newHandler: function() {
            var view = this.parentView || this;
            view.serverCall({
                method: 'AddRow',
                success: view.createGridRow
            });
        },

        createGridRow: function(dict) {
            if (KS.isEmpty(dict)) return;
            var grid = this.mainGrid;
            grid.store.insert(0, dict);
            grid.select(0);
            this.touch();
        },

        deleteCallback: function(deleted) {
            if (deleted) {
                this.mainGrid.reload();
                this.touch();
            }
        }
    });
}(DictionaryRRONpaTypeView.prototype));

if (typeof (Sys) !== 'undefined') {Sys.Application.notifyScriptLoaded(); }