ChatBotView = KS.extend(KS.Ext.ClientView, {
    customName: "ChatBotView",

    constructor: function(viewId) {
        ChatBotView.superclass.constructor.call(this, viewId);
    },

    onTemplateRendered: function() {
        let chatBotPanel = new Svod.ChatBotPanel({
                parentView : this
            });
        this.rootPanel.add(chatBotPanel);
    },

    setTooltip: function(component, text) {
        if (!component.rendered || Ext.isEmpty(text)) {
            return;
        }

        component.getEl().set({ 'data-qtip': text });
    },

    postRate: function (
        queryId,
        answerType,
        usefulRate,
        chatBotName,
        successCallBack
    ) {
        this.serverCall({
            method: 'PostUsefulRate',
            params: [queryId,
                answerType,
                usefulRate,
                chatBotName],
            success: function () {
                if (successCallBack)
                    successCallBack();
            }
        });
        // .catch(revertButtons);
    },

    getHelpLinks: function(container){
        this.serverCall({
            method: 'GetHelpLinks',
            success: function (result) {
                if (result && container.renderChatBotMenuContainer)
                    container.renderChatBotMenuContainer.call(container, result.helpTopic, result.bugTracking);
            }
        });
    }
});

// ============= ChatMessageController =======================
(function (viewClass) {
    KS.apply(viewClass, {

        sendMessage(
            msgValue,
            mainComponent,
            messageId = null,
            isForceSendMessage = false
        ) {
            const view = this.parentView || this;
            const chatMessageStore = mainComponent?.chatMessageStore;
            const chatsStore = mainComponent?.chatStore;
            const displayChatSendMessageContainer =
                mainComponent?.displayChatSendMessageContainer;
            const displayChat = displayChatSendMessageContainer?.displayChat;
            const chatModelId = mainComponent.chatModelId;
            const btn = displayChatSendMessageContainer?.postMessageButton;
            const textareaField = displayChatSendMessageContainer?.messageField;
            const isNotChosedChatBotType =
                chatsStore.getById(chatModelId).data.IsNotChosedChatBotType;

            mainComponent.isSendingMessage = true;

            if (msgValue.trim()) {
                const placeholderText = textareaField.getEmptyText();

                textareaField.setValue('');
                msgValue = view.inputValueXSSprevent(msgValue);

                view.toggleButtonAndField(
                    btn,
                    textareaField,
                    'Идет поиск, пожалуйста, подождите.',
                    false
                );

                if (isNotChosedChatBotType) {
                    view.choseChatBotType(
                        msgValue,
                        chatMessageStore,
                        placeholderText,
                        chatModelId,
                        mainComponent,
                        btn,
                        textareaField,
                        displayChatSendMessageContainer,
                        displayChat
                    );
                } else {
                    let sendMessageCallBack = function(){
                        view.incrementQueriesCount(
                            chatsStore,
                            mainComponent.chatModelId
                        );

                        displayChat.refresh();
                        view.toggleButtonAndField(
                            btn,
                            textareaField,
                            placeholderText,
                            true
                        );
                        view.scrollToBottom(
                            displayChatSendMessageContainer.displayChat
                        );
                        mainComponent.isSendingMessage = false;
                        textareaField.focus();
                    }
                    // Создание первого чата и сообщения
                    view.checkFirstChatAndSendMessage(
                            chatsStore,
                            msgValue,
                            mainComponent,
                            chatMessageStore,
                            chatModelId,
                            isForceSendMessage,
                            sendMessageCallBack
                        );
                        // .catch(async (error) => {
                        //     switch (error?.Text) {
                        //         case 'Произошла ошибка при получении ответа!':
                        //             view.callBackChatMessageAddResult(
                        //                 chatMessageStore,
                        //                 null,
                        //                 messageId ??
                        //                 mainComponent.chatMessageModelId
                        //             );
                        //             break;
                        //         default:
                        //             // KSWN.ErrorHandler.handle(error);
                        //             break;
                        //     }

                        //     if (isForceSendMessage) {
                        //         chatMessageStore
                        //             .getById(messageId)
                        //             .set({ IsNeedForce: false });
                        //     }
                        // })
                }
            }
        },

        showQueries(mainComponent, chatSelectionId) {
            let view = this;
            const itemStore = mainComponent.chatStore;
            const store = mainComponent.chatMessageStore;
            const displayChatSendMessageContainer =
                mainComponent.displayChatSendMessageContainer;
            const chatListArea = mainComponent.chatListArea;
            const isDisplayChatSendMessageContainerHidden =
                displayChatSendMessageContainer.isHidden();

            store.filter('chatModel', chatSelectionId);
            mainComponent.chatModelId = chatSelectionId;

            const chatId = itemStore.getById(mainComponent.chatModelId).data.ChatId;

            if (chatId) {
                mainComponent.ChatId = chatId;
            }
            // получаем первую страницу сообщений
            if (
                itemStore.getById(mainComponent.chatModelId).data.InitialGetChat ===
                false
            ) {
                let successCallBack = function(result){
                    view.callBackAddToStoreFirstQueries(
                        result,
                        itemStore,
                        mainComponent
                    );

                    if (isDisplayChatSendMessageContainerHidden) {
                        chatListArea.hide();
                        displayChatSendMessageContainer.show();
                        view.scrollToBottom(
                            displayChatSendMessageContainer.displayChat
                        );
                    }

                    mainComponent.displayChatSendMessageContainer.messageField.focus();
                }

                view.getChatChatBot(mainComponent, true, chatId, 1, successCallBack);

                    // .catch((error) => {
                    //     itemStore.getById(
                    //         mainComponent.chatModelId
                    //     ).data.InitialGetChat = true;
                    //     KSWN.ErrorHandler.handle(error);
                    // });
            } else {
                if (isDisplayChatSendMessageContainerHidden) {
                    chatListArea.hide();
                    displayChatSendMessageContainer.show();
                }

                view.scrollToBottom(
                    displayChatSendMessageContainer.displayChat
                );
                mainComponent.displayChatSendMessageContainer.messageField.focus();
            }
            view.hideScrollBottomBtn(mainComponent.scrollBottomBtn);
        },

        initialGetChatList: function(mainComponent){
            let view = mainComponent.parentView;

            const chatMessageStore = mainComponent.chatMessageStore;
            const chatStore = mainComponent.chatStore;

            mainComponent.isInitalGetChatListCompleted = false;

            // обновляем состояние компонентов и сторы
            view.refreshChatBot(mainComponent, chatStore, chatMessageStore);

            view.serverCall({
                method: 'AuthChatBot',
                success: function(response) {
                    view.getArticlesInfo(mainComponent);
                }
            });
        },

        getArticlesInfo: function(mainComponent){
            let view = this;
            view.serverCall({
                method: 'GetArticlesInfo',
                success: function(articlesInfo) {
                    view.setArticlesInfo(mainComponent, articlesInfo);
                },
                // error: function() {
                //     // Если произошла ошибка при первом обращении к сервису, пробуем один раз перезапустить
                //     if (!mainComponent.startRefreshed){
                //         view.initialGetChatList(mainComponent);
                //         mainComponent.startRefreshed = true;
                //     }
                // }
            });
        },

        setArticlesInfo: function(mainComponent, articlesInfo){
            let view = this;
            const chatListArea = mainComponent.chatListArea;
            const displayChatSendMessageContainer = mainComponent.displayChatSendMessageContainer;

            articlesInfo.forEach((infoItem) => {
                if (
                    mainComponent.chatBotInfo.length < articlesInfo.length
                ) {
                    mainComponent.chatBotInfo.push({
                        ChatBotName: infoItem.ChatBotName,
                        DataNames: infoItem.Info.map((output) => {
                            return output.DataName;
                        }),
                        isCurrent: false
                    });
                }
            });

            if (articlesInfo.length === 1) {
                view.setCurrentChatBotInfo(
                    mainComponent,
                    articlesInfo[0].ChatBotName
                );
                chatListArea.getColumns()[1].setHidden(true);
                displayChatSendMessageContainer
                    .getEl()
                    .dom.querySelector(
                    '.displayChatSendMessageContainer-chatBotNameContainer'
                ).style.display = 'none';
            }
            
            view.getPageSize(mainComponent);
        },

        getPageSize: function(mainComponent){
            let view = this;
            view.serverCall({
                method: 'GetPageSize',
                success: function(pageSize) {
                    mainComponent.pageSize = pageSize;
                    view.chatListChatBot(mainComponent);
                }
            });
        },

        chatListChatBot: function(mainComponent){
            let view = this;
            view.serverCall({
                method: 'ChatListChatBot',
                success: function(chatList) {
                    view.setChatList(mainComponent, chatList);
                }
            });
        },
        
        setChatList: function(mainComponent, chatList){
            let view = this;
            let isChat = true;
            const chatMessageStore = mainComponent.chatMessageStore;
            const chatStore = mainComponent.chatStore;
            const chatListArea = mainComponent.chatListArea;

            if (chatList?.Chat.length < 1) {
                isChat = false;

                if (mainComponent.chatBotInfo.length > 1) {
                    view.addNotChosedChat(
                        'Новый чат',
                        mainComponent,
                        chatMessageStore
                    );
                } else {
                    var chatBotName = view.getCurrentChatBotInfo(mainComponent).ChatBotName;
                    view.serverCall({
                        method: 'CreateChatChatBot',
                        params: [0, true, 'Новый чат', chatBotName],
                        success: function (res) {
                            if (res.status === 'error') {
                                throw new Error(
                                    'Произошла ошибка при создании чата!'
                                );
                            }
                            view.callBackChatCreateChat(
                                res,
                                'Новый чат',
                                mainComponent,
                                chatMessageStore
                            );

                            view.getChatChatBot(
                                mainComponent,
                                isChat,
                                chatStore.getById(mainComponent.chatModelId).data.ChatId
                            );
                        }
                    });

                    return; // getChatChatBot дергаем отдельно
                }

            } else {
                view.addChatsToChatStore(chatList, chatStore);
                const lastChat =
                    mainComponent.ChatId === null
                        ? chatStore.last()
                        : chatStore.getAt(
                            chatStore.find('ChatId', mainComponent.ChatId)
                        );
                mainComponent.chatModelId = lastChat.getId();
                mainComponent.chatMessageStore.filter(
                    'chatModel',
                    mainComponent.chatModelId
                );
                chatListArea.getView().setSelection(lastChat);
                view.setCurrentChatBotInfo(
                    mainComponent,
                    lastChat.data.ChatBotName
                );
            }

            view.getChatChatBot(
                mainComponent,
                isChat,
                chatStore.getById(mainComponent.chatModelId).data.ChatId
            );
        },

        getChatChatBot: function(mainComponent, isChat, chatId, pageNumber, successCallBack){
            pageNumber = pageNumber || 1;
            let view = this;
            let chatBotInfo = view.getCurrentChatBotInfo(mainComponent); 
            if (chatBotInfo) {
                if (isChat) {
                    view.serverCall({
                        method: 'GetChatChatBot',
                        params: [chatId, pageNumber, chatBotInfo.ChatBotName],
                        success: function (result) {
                            if (successCallBack)
                                successCallBack(result)
                            else 
                                view.addToStoreFirstQueries(mainComponent, result);
                        }
                    });
                } else {
                    // Нужно возвращать объект типа OutputGetChat
                    view.addToStoreFirstQueries(mainComponent);
                }
            }
        },

        addToStoreFirstQueries: function(mainComponent, result){
            let view = this;
            view.callBackAddToStoreFirstQueries(
                result,
                mainComponent.chatStore,
                mainComponent
            );
            mainComponent.displayChatSendMessageContainer
                .getTargetEl()
                .addCls('displayChatSendMessageContainer-botAvatar');
            mainComponent.displayChatSendMessageContainer.toggleShowTitle(
                true
            );
            mainComponent.displayChatSendMessageContainer.updateLayout();
            mainComponent.displayChatSendMessageContainer.messageField.focus();
            mainComponent.addListener('show', function () {
                this.displayChatSendMessageContainer.messageField.focus();
            });
            view.scrollToBottom(
                mainComponent.displayChatSendMessageContainer.displayChat
            );
        },

        callBackAddToStoreFirstQueries(res, itemStore, mainComponent) {
            let view = this;
            // добавляем первую страницу сообщений при первом заходе в чат
            view.addChatAndMessageToStores(
                res,
                mainComponent.chatMessageStore,
                mainComponent.chatModelId
            );
            itemStore.getById(mainComponent.chatModelId).set({
                InitialGetChat: true,
                TotalQueriesCount: res?.TotalCount
            });
            view.insertWelcomeMessage(
                mainComponent,
                mainComponent.chatModelId,
                res
            );
        },

        paginationChatBot(
            mainComponent,
            storeChatMessage,
            domElement,
            chatStore,
            component
        ) {
            let view = this;
            // пагинация
            const chatModelId = mainComponent.chatModelId,
                storeCount = storeChatMessage.data.count(),
                scrollHeight = domElement.scrollHeight;

            if (
                storeCount < chatStore.getById(chatModelId)?.data.TotalQueriesCount
            ) {
                // считываем какую страницу надо получить, учитываем количество сообщений на фронте
                const pageNumber = Math.floor(
                    storeChatMessage.data.count() / mainComponent?.pageSize + 1
                );

                let successCallBack = function(result){
                    view.addToChatMessageStorePagination(
                        result,
                        storeChatMessage,
                        chatModelId
                    );
                    view.setTotalQueriesCountToChat(
                        chatModelId,
                        chatStore,
                        result
                    );
                    view.insertWelcomeMessage(mainComponent, chatModelId);

                    component
                        .getScrollable()
                        .scrollTo(0, domElement.scrollHeight - scrollHeight);
                    component.getScrollable().trackingScrollTop =
                        domElement.scrollHeight - scrollHeight;
                    component.paginationLoadCheck = true;
                };

                view.getChatChatBot(mainComponent, true, chatStore.getById(chatModelId)?.data.ChatId, pageNumber, successCallBack)

                // .catch((error) => {
                //     KSWN.ErrorHandler.handle(error);
                // })
            } else {
                component.paginationLoadCheck = true;
            }
        },

        callBackChatMessageAddResult(
            itemStore,
            res,
            chatMessageId,
            sendMessageCallBack
        ) {
            // добавляем в стор сообщение об ошибке или полученный ответ
            let itemToAdd = {
                Result: 'Произошла ошибка при получении ответа!',
                Type: -1
            };

            if (res) {
                let accordionToShow = '';
                let bestScore = 0;

                res.Data?.Result.forEach((item) => {
                    if (item.BestTfIdfScore > bestScore) {
                        bestScore = item.BestTfIdfScore;
                        accordionToShow = item.DataName;
                    }
                });

                if (res.Data?.Result?.length > 0 && accordionToShow === '') {
                    accordionToShow = res.Data.Result[0].DataName;
                }

                itemToAdd = {
                    QueryId: res?.Data?.Id,
                    Result: res.Data?.Result,
                    Comment: res.Data?.Comment,
                    Type: res.Data?.IsValid,
                    IsGptAnswer: res.Data?.IsGptAnswer,
                    AccordionShowNames: accordionToShow
                };
            }

            itemStore.getById(chatMessageId)?.set(itemToAdd);
            
            if (Ext.isFunction(sendMessageCallBack)){
                sendMessageCallBack();
            }
        }
    });
}(ChatBotView.prototype));

// ============= ChatBotController =======================
(function (viewClass) {
    KS.apply(viewClass, {
        // ChatListArea
        addNewChatButtonHandler(chatListArea) {
            const mainComponent = chatListArea.mainComponent;
            const store = mainComponent.chatMessageStore;
            let creatingChatModal = mainComponent.creatingChatModal;

            mainComponent.mask();

            if (creatingChatModal) {
                creatingChatModal.setPosition(
                    (mainComponent.getWidth() - creatingChatModal.getWidth()) / 2,
                    (mainComponent.getHeight() - creatingChatModal.getHeight()) / 2
                );
                creatingChatModal.show();
                creatingChatModal.chatNameField.focus();
                return;
            }

            creatingChatModal = new Svod.chatList.CreatingChatModal({
                parentView: mainComponent.parentView
            });
            creatingChatModal.chatBotComponent = mainComponent;
            creatingChatModal.chatBotChatsStore = store;
            mainComponent.creatingChatModal = creatingChatModal;
            creatingChatModal.show();
            creatingChatModal.chatNameField.focus();
        },

        chatListAreaCellClick() {
            let view = this.parentView;
            const mainComponent = this.mainComponent;
            const chatSelectionId = this.selection.id;

            view.setCurrentChatBotInfo(
                mainComponent,
                this.selection.data.ChatBotName
            );
            view.showQueries(mainComponent, chatSelectionId);
        },

        // CreatingChatModal
        /** *
         * @description Описание f()
         * @param textfield - описание параметра1
         * @param eventObject -описание параметра2
         */
        chatNameFieldKeypress(textfield, eventObject) {
            let view = this.parentView;
            const component = this;
            const creatingChatModalSave = component?.creatingChatModalSave;

            view.keypressListener(
                textfield,
                eventObject,
                creatingChatModalSave,
                true
            );
        },

        /** *
         * @description Описание f()
         */
        creatingChatModalSaveHandler() {
            let view = this.parentView;
            const creatingChatModal = this;
            const chatNameField = this.chatNameField;

            if (chatNameField.getValue().trim()) {
                view.createChat(
                    chatNameField,
                    creatingChatModal,
                    creatingChatModal?.chatBotComponent?.maxChatCount
                );
            }
        },

        /** *
         * @description Описание f()
         */
        creatingChatModalCancelHandler() {
            this.hide();
        },

        /** *
         * @description Описание f()
         */
        chatNameFieldKeypressChange() {
            let view = this.parentView;
            const component = this;
            const creatingChatModalSave = component?.creatingChatModalSave;

            view.toggleButton(this.chatNameField, creatingChatModalSave);
        },

        // DisplayChatSendMessageContainer
        /** *
         * @description Описание f()
         * @param component - 1
         * @param textareafield - 2
         * @param eventObject - 3
         */
        messageFieldKeypress(component, textareafield, eventObject) {
            let view = this;
            const postMessageButton = component?.postMessageButton;

            view.keypressListener(
                textareafield,
                eventObject,
                postMessageButton,
                false
            );
        },

        /** *
         * @description Описание f()
         */
        messageFieldKeypressChange(component) {
            let view = this;
            const messageField = component?.messageField;
            const postMessageButton = component?.postMessageButton;

            view.toggleButton(messageField, postMessageButton);
        },

        /** *
         * @description Описание f()
         */
        postMessageButtonHandler(component) {
            let view = this;
            const mainComponent = component.mainComponent;
            const textareaField = component?.messageField;

            view.sendMessage(textareaField.getValue(), mainComponent);
        },

        // DisplayChat
        /** *
         * @description Описание f()
         */
        displayChatAfterrender() {
            const displayChat = this;

            // функционал в шаблоне прописан на чистом js
            displayChat.getEl().on(
                'click',
                function (event, domElement) {
                    displayChat.toggle(domElement.closest('div.accordion__item'));
                },
                null,
                { delegate: '.accordion__header' }
            );

            displayChat.getEl().on(
                'click',
                function (event, domElement) {
                    displayChat.postRate(domElement);
                },
                null,
                { delegate: '.chatBot-displayChat-rateButton' }
            );

            displayChat.getEl().on(
                'click',
                function (event, domElement) {
                    displayChat.forceSendMessage(domElement);
                },
                null,
                { delegate: '.chatBot-displayChat-buttonAsk' }
            );

            displayChat.getEl().on(
                'click',
                function (event, domElement) {
                    displayChat.createChatWithChoose(domElement);
                },
                null,
                { delegate: '.chooseChatBotTypeButton' }
            );

            new Ext.tip.ToolTip({
                target: displayChat,
                delegate: [
                    '.accordion__header',
                    '.chatBot-displayChat-rateButton',
                    '.chooseChatBotTypeButton'
                ],
                listeners: {
                    beforeshow(tip) {
                        const current = tip.currentTarget.dom;

                        if (current.className.includes('chooseChatBotTypeButton')) {
                            tip.setHtml(current.getAttribute('data-chatBotType'));
                            return;
                        }

                        tip.setHtml(current.innerHTML);
                    }
                }
            });
        },

        toggleView(toShow, toHide) {
            if (toShow.isHidden()) {
                toHide.hide();
                toShow.show();
            }
        },

        getCurrentChatBotInfo(component) {
            const chatBotInfo = component.chatBotInfo;
            let currentChatBotInfo;

            chatBotInfo.forEach((item) => {
                if (item.isCurrent) {
                    currentChatBotInfo = item;
                }
            });

            return currentChatBotInfo;
        },

        setCurrentChatBotInfo(component, selectedName) {
            const chatBotInfo = component.chatBotInfo;

            chatBotInfo.forEach((item) => {
                if (item.isCurrent) {
                    item.isCurrent = false;
                }
                if (item.ChatBotName === selectedName) {
                    item.isCurrent = true;
                }
            });
        },

        choseChatBotType(
            msgValue,
            chatMessageStore,
            placeholderText,
            chatModelId,
            mainComponent,
            btn,
            textareaField,
            displayChatSendMessageContainer,
            displayChat
        ) {
            let view = this;
            const validChatBotInfo = [];
            let botBadMessage = [
                'Пожалуйста, введите ваш вопрос поточнее',
                'Я не понимаю ваш вопрос, могли бы вы его задать поточнее?',
                'Я смогу найти ответ на ваш вопрос, если он будет корректнее'
            ];
            const welcomeMessage = Ext.create('Svod.ChatMessageModel', {
                Query: msgValue,
                Result: null,
                chatModel: chatModelId,
                Type: 1,
                IsNotChosedChatBotType: true,
                ChatBotNames: null
            });

            chatMessageStore.add(welcomeMessage);
            view.scrollToBottom(displayChatSendMessageContainer.displayChat);

            for (const info of mainComponent.chatBotInfo) {
                view.serverCall({
                    method: isForceSendMessage ? 'ForceQueryChatBot': 'QueryChatBot',
                    params: [ 1,
                        msgValue,
                        info.DataNames,
                        info.ChatBotName
                    ],
                    success: function (result) {
                        if (result.Data.IsValid) {
                            validChatBotInfo.push({
                                ...info,
                                BestTfIdfScore: Math.max(
                                    ...result.Data.Result.map((item) => {
                                        return item.BestTfIdfScore;
                                    })
                                )
                            });
                        }

                        view.choseChatBotTypeCallBack(
                            msgValue,
                            chatMessageStore,
                            placeholderText,
                            chatModelId,
                            mainComponent,
                            btn,
                            textareaField,
                            displayChatSendMessageContainer,
                            displayChat,
                            validChatBotInfo,
                            welcomeMessage,
                            botBadMessage
                        );
                    },
                    error: function() {
                        botBadMessage = 'Произошла ошибка при получении ответа!';

                        view.choseChatBotTypeCallBack(
                            msgValue,
                            chatMessageStore,
                            placeholderText,
                            chatModelId,
                            mainComponent,
                            btn,
                            textareaField,
                            displayChatSendMessageContainer,
                            displayChat,
                            validChatBotInfo,
                            welcomeMessage,
                            botBadMessage
                        );
                    }
                })
            }            
        },

        choseChatBotTypeCallBack(
            msgValue,
            chatMessageStore,
            placeholderText,
            chatModelId,
            mainComponent,
            btn,
            textareaField,
            displayChatSendMessageContainer,
            displayChat,
            validChatBotInfo, 
            welcomeMessage,
            botBadMessage
        ){
            let view = this;
            if (validChatBotInfo.length === 1) {
                view.createChatAndSendMessage(
                    validChatBotInfo[0].ChatBotName,
                    msgValue,
                    mainComponent,
                    chatModelId
                );
                return;
            }

            const messageToChoseType = chatMessageStore.getById(welcomeMessage.id);

            if (messageToChoseType) {
                chatMessageStore.getById(welcomeMessage.id).set(
                    validChatBotInfo.length > 0
                        ? {
                            Result: 'Пожалуйста, выберите к какой базе данных будет привязан чат: ',
                            ChatBotNames: validChatBotInfo
                                .sort((current_item, next_item) => {
                                    if (
                                        current_item.BestTfIdfScore >
                                        next_item.BestTfIdfScore
                                    ) {
                                        return -1;
                                    }

                                    if (
                                        current_item.BestTfIdfScore <
                                        next_item.BestTfIdfScore
                                    ) {
                                        return 1;
                                    }

                                    return 0;
                                })
                                .map((item) => {
                                    return { ChatBotName: item.ChatBotName };
                                })
                        }
                        : {
                            Result: botBadMessage[Math.floor(Math.random() * 3)],
                            ChatBotNames: null
                        }
                );
            }

            displayChat.refresh();
            view.toggleButtonAndField(btn, textareaField, placeholderText, true);
            view.scrollToBottom(displayChatSendMessageContainer.displayChat);
            mainComponent.isSendingMessage = false;
            mainComponent.chatMessageModelId = null;
            textareaField.focus();
        },

        createChatAndSendMessage(
            chatBotName,
            msgValue,
            mainComponent,
            chatModelId
        ) {
            let view = this;
            const chat = mainComponent.chatStore.getById(chatModelId);

            if (chat === null) {
                return;
            }

            const chatName = chat.data.Name;
            const chatMessageStore = mainComponent.chatMessageStore;

            let createChatChatBotCallBack = function (result){
                chat.set({
                    ChatId: result?.Data?.ChatId,
                    TotalQueriesCount: 0,
                    ChatBotName: chatBotName,
                    IsNotChosedChatBotType: false
                });

                mainComponent.chatModelId = chat.data.Id;
                mainComponent.chatId = chat.data.ChatId;

                chatMessageStore.filter('chatModel', chat.data.Id);

                mainComponent.chatListArea.getView().setSelection(chat);

                const welcomeMessage = Ext.create('KSWN.models.ChatMessageModel', {
                    Query: null,
                    Result: KSWN.Locale.privetstviebota,
                    chatModel: chat.data.Id,
                    Type: -1
                });

                chatMessageStore.remove(chatMessageStore.data.items);

                chatMessageStore.add(welcomeMessage);

                view.setCurrentChatBotInfo(mainComponent, chatBotName);

                mainComponent.displayChatSendMessageContainer.fireEvent('beforeshow');

                mainComponent.displayChatSendMessageContainer.messageField.focus();

                view.sendMessage(msgValue, mainComponent);
            }

            view.createChatChatBot(chatName, chatBotInfo.ChatBotName, createChatChatBotCallBack);
        }
    });
}(ChatBotView.prototype));

// ============= ChatController =======================
(function (viewClass) {
    KS.apply(viewClass, {

        createChat(input, creatingChatModal, maxChatsCount) {
            let view = this;
            let chatName = input.getValue();
            const mainComponent = creatingChatModal.chatBotComponent;
            const chatBotInfo = view.getCurrentChatBotInfo(mainComponent);

            if (chatName.trim()) {
                const store = creatingChatModal.chatBotChatsStore;
                // Предотвращаем возможную xss атаку
                chatName = view.inputValueXSSprevent(chatName);

                if (mainComponent.chatBotInfo.length === 1) {
                    let createChatChatBotCallBack = function(res){
                        view.callBackChatCreateChat(
                            res,
                            chatName,
                            mainComponent,
                            store
                        );

                        const chats = mainComponent.chatStore;

                        if (chats.count() > maxChatsCount) {
                            chats.remove(chats.first());
                        }

                        view.toggleView(
                            mainComponent.displayChatSendMessageContainer,
                            mainComponent.chatListArea
                        );
                        mainComponent.displayChatSendMessageContainer.messageField.focus();

                        creatingChatModal.hide()
                    }

                    view.createChatChatBot(chatName, chatBotInfo.ChatBotName, createChatChatBotCallBack)
                } else {
                    view.addNotChosedChat(
                        chatName,
                        mainComponent,
                        store,
                        creatingChatModal,
                        maxChatsCount
                    );
                }
            }
            input.setValue('');
            view.hideScrollBottomBtn(mainComponent.scrollBottomBtn);
        },

        createChatChatBot(chatName, chatBotName, successCallBack){
            let view = this;
            view.serverCall({
                method: 'CreateChatChatBot',
                params: [0, true, chatName, chatBotName],
                success: function (res) {
                    if (successCallBack)
                        successCallBack(res);
                }
            });  
        },

        callBackChatCreateChat(res, chatName, mainComponent, store) {
            let view = this;
            // Создаем модель чата в сторе, записываем id в chatBotPanel, фильтруем стор сообщений по чату и выделяем колонку созданного чата
            const chat = view.addToChatStore(
                res,
                chatName,
                view.getCurrentChatBotInfo(mainComponent).ChatBotName
            );
            const id = chat.id;

            mainComponent.chatStore.add(chat);
            mainComponent.chatModelId = id;
            mainComponent.ChatId = res?.Data?.ChatId;
            store.filter('chatModel', id);
            mainComponent.chatListArea.getView().setSelection(chat);

            mainComponent.chatMessageStore?.add(
                view.getWelcomeMessage(
                    mainComponent.chatMessageStore,
                    mainComponent.chatModelId,
                    view.getCurrentChatBotInfo(mainComponent).ChatBotName
                )
            );

            return chat;
        },

        addNotChosedChat(
            chatName,
            mainComponent,
            store,
            creatingChatModal = null,
            maxChatsCount = 0
        ) {
            let view = this;

            const chatWithChoose = Ext.create('Svod.ChatModel', {
                Name: chatName,
                InitialGetChat: true,
                TotalQueriesCount: 0,
                ChatBotName: null,
                IsNotChosedChatBotType: true
            });

            mainComponent.chatStore.add(chatWithChoose);
            mainComponent.chatModelId = chatWithChoose.id;
            store.filter('chatModel', chatWithChoose.id);
            mainComponent.chatListArea.getView().setSelection(chatWithChoose);

            const welcomeMessage = Ext.create('Svod.ChatMessageModel', {
                Query: null,
                Result: 'Здравствуйте! Вас приветствует Чат-бот. Вы можете задать мне вопрос, а я постараюсь на него ответить.',
                chatModel: chatWithChoose.id,
                Type: -1
            });

            mainComponent.chatMessageStore.add(welcomeMessage);

            if (maxChatsCount && mainComponent.chatStore.count() > maxChatsCount) {
                mainComponent.chatStore.remove(mainComponent.chatStore.first());
            }

            view.toggleView(
                mainComponent.displayChatSendMessageContainer,
                mainComponent.chatListArea
            );

            mainComponent.displayChatSendMessageContainer.messageField.focus();

            if (creatingChatModal) {
                creatingChatModal.hide();
            }
        }
    });
}(ChatBotView.prototype));

// ============= UtilController =======================
(function (viewClass) {
    KS.apply(viewClass, {
        // Взаимодействие с помощью клавиш
        keypressListener(input, eventObject, btn, onlyEnter) {
            switch (eventObject.getCharCode()) {
                case Ext.EventObject.ENTER:
                    event.preventDefault();

                    if (!btn.isDisabled()) {
                        btn.fireHandler();
                    }
                    break;
                // 10 это клавиша ctrl
                case 10:
                case !btn.isDisabled():
                    if (!onlyEnter) {
                        input.setValue(input.getValue() + '\n');
                        input.inputEl.scroll('bottom', 9999, true);
                    }
                    break;
                default:
                    break;
            }
        },

        // Защита от xss
        inputValueXSSprevent(msgValue) {
            return msgValue
                ?.toString()
                .replace(/</g, '&lt;')
                .replace(/>/g, '&gt;')
                .replace(/'/g, '&#39;')
                .replace(/"/g, '&#34;');
        },

        toggleButtonAndField(button, field, placeholder, toggle) {
            field.setEmptyText(placeholder);

            if (!toggle) {
                button.disable();
                field.disable();
            } else {
                button.enable();
                field.enable();
            }
        },

        toggleButton(input, btn) {
            if (input.getValue().length > input.maxLength) {
                btn.disable();
            } else {
                btn.enable();
            }
        },

        // Слушатель под скролл(показ и сокрытие кнопки скролла вниз, пагинация)
        scrollEventListener(component, mainComponent, scrollBottomBtn) {
            const storeChatMessage = mainComponent.chatMessageStore;
            const chatStore = mainComponent.chatStore;

            component.el.on('scroll', function (event, domElement) {
                let view = component.parentView;
                const height = component.getTargetEl().getHeight();

                if (
                    height + domElement.scrollTop >=
                    domElement.scrollHeight - 150 &&
                    !scrollBottomBtn.hasCls('scrollBottomBtn-hide')
                ) {
                    view.hideScrollBottomBtn(scrollBottomBtn);
                }

                if (
                    domElement.scrollTop <= domElement.scrollHeight - height * 2 &&
                    scrollBottomBtn.hasCls('scrollBottomBtn-hide')
                ) {
                    view.showScrollBottomBtn(scrollBottomBtn);
                }

                if (
                    domElement.scrollTop <= 50 &&
                    component.paginationLoadCheck === true
                ) {
                    component.paginationLoadCheck = false;
                    view.paginationChatBot(
                        mainComponent,
                        storeChatMessage,
                        domElement,
                        chatStore,
                        component
                    );
                }

                scrollBottomBtn.setPosition({}, height + domElement.scrollTop - 65);
            });
        },

        // Скролл вниз
        scrollToBottom(component, anim = false) {
            component
                .getScrollable()
                .scrollTo(
                    0,
                    component.el.dom.scrollHeight - component.el.dom.offsetHeight,
                    anim === true
                );
            component.getScrollable().trackingScrollTop =
                component.el.dom.scrollHeight - component.el.dom.offsetHeight;
        },

        createScrollBottomBtn(component) {
            const view = this;

            return Ext.create('Ext.button.Button', {
                title: 'toBottom',
                reference: 'scrollBottomBtn',
                cls: ['scrollBottomBtn', 'scrollBottomBtn-hide'],
                tooltip: 'Вниз',
                floated: true,
                handler() {
                    view.scrollToBottom(component.displayChat);
                }
            });
        },

        hideScrollBottomBtn(scrollBottomBtn) {
            if (!scrollBottomBtn.hasCls('scrollBottomBtn-hide')) {
                scrollBottomBtn.addCls('scrollBottomBtn-hide');
            }
        },

        showScrollBottomBtn(scrollBottomBtn) {
            if (scrollBottomBtn.hasCls('scrollBottomBtn-hide')) {
                scrollBottomBtn.removeCls('scrollBottomBtn-hide');
            }
        },

        setTotalQueriesCountToChat(chatId, itemStore, res) {
            itemStore.getById(chatId).set({
                TotalQueriesCount: res.TotalCount
            });
        },

        incrementQueriesCount(chatStore, chatModelId) {
            const item = chatStore.getById(chatModelId);
            item?.set({
                TotalQueriesCount: item.getData()?.TotalQueriesCount + 1
            });
        },

        addToChatStore(res, chatName, chatBotName) {
            return Ext.create('Svod.ChatModel', {
                ChatId: res?.Data?.ChatId,
                Name: chatName,
                InitialGetChat: true,
                TotalQueriesCount: 0,
                ChatBotName: chatBotName
            });
        },

        addChatsToChatStore(chatList, itemStore) {
            chatList?.Chat?.map((item) => {
                const chat = Ext.create('Svod.ChatModel', {
                    ChatId: item.Id,
                    Name: item.Name,
                    InitialGetChat: false,
                    TotalQueriesCount: 0,
                    ChatBotName: item.ChatBotName
                });

                itemStore.add(chat);
            });
        },

        // Относится к модели сообщений
        addToChatMessageStoreDefaultId(msgValue, chatModelId, chatMessageStore) {
            const query = Ext.create('Svod.ChatMessageModel', {
                Query: msgValue,
                Result: '',
                Comment: '',
                IsNeedForce: true,
                chatModel: chatModelId,
                Type: 1,
                AccordionShowNames: '',
                UsefulNames: null,
                NotUsefulNames: null,
                IsUseful: null
            });

            chatMessageStore.add(query);
            return query;
        },

        addToChatMessageStorePagination(res, chatMessageStore, chatModelId) {
            res?.QueryList?.map((item) => {
                chatMessageStore.insert(
                    0,
                    Ext.create('Svod.ChatMessageModel', {
                        QueryId: item.Id,
                        Query: item.Query,
                        Result: item.Result,
                        IsGptAnswer: item.IsGptAnswer,
                        Comment: item.Comment,
                        IsNeedForce: false,
                        chatModel: chatModelId,
                        Type: item.IsValid,
                        AccordionShowNames: '',
                        UsefulNames: item.UsefulNames,
                        NotUsefulNames: item.NotUsefulNames,
                        IsUseful: item.IsUseful
                    })
                );
            });
        },

        addChatAndMessageToStores(res, chatMessageStore, chatModelId) {
            res?.QueryList
                ?.slice(0)
                .reverse()
                .map((item) => {
                    chatMessageStore.add(
                        Ext.create('Svod.ChatMessageModel', {
                            QueryId: item.Id,
                            Query: item.Query,
                            Result: item.Result,
                            IsGptAnswer: item.IsGptAnswer,
                            Comment: item.Comment,
                            IsNeedForce: false,
                            chatModel: chatModelId,
                            Type: item.IsValid,
                            AccordionShowNames: '',
                            UsefulNames: item.UsefulNames,
                            NotUsefulNames: item.NotUsefulNames,
                            IsUseful: item.IsUseful
                        })
                    );
                });
        },

        refreshChatBot(mainComponent, chatStore, chatMessageStore) {
            const displayChatSendMessageContainer = mainComponent?.displayChatSendMessageContainer;
            const chatListArea = mainComponent?.chatListArea;

            chatStore.clearData();
            chatMessageStore.clearData();
            chatListArea.view.refresh();
            displayChatSendMessageContainer.displayChat.refresh();
            chatListArea.addNewChatButton.disabled = false;
            displayChatSendMessageContainer?.postMessageButton.enable();
            displayChatSendMessageContainer?.messageField.enable();
            displayChatSendMessageContainer.toggleShowTitle(false);
            displayChatSendMessageContainer
                .getTargetEl()
                .removeCls('displayChatSendMessageContainer-botAvatar');
            chatListArea?.setEmptyText('');
            this.hideScrollBottomBtn(mainComponent?.scrollBottomBtn);
        },

        checkFirstChatAndSendMessage(
            chatsStore,
            msgValue,
            mainComponent,
            chatMessageStore,
            chatModelId,
            isForceSendMessage,
            sendMessageCallBack
        ) {
            const view = this;
            const displayChatSendMessageContainer = mainComponent?.displayChatSendMessageContainer;
            const currentChatBotInfo = view.getCurrentChatBotInfo(mainComponent);
            let chatBotName = currentChatBotInfo.ChatBotName;
            let messageId = '';

            if (chatsStore.count() === 0) {
                view.serverCall({
                    method: 'CreateChatChatBot',
                    params: [0, true, 'Новый чат', chatBotName],
                    success: function (res) {
                        if (res.status === 'error') {
                            throw new Error(
                                'Произошла ошибка при создании чата!'
                            );
                        }

                        view.callBackChatCreateChat(
                            res,
                            msgValue,
                            mainComponent,
                            chatMessageStore
                        );

                        messageId = view.addToChatMessageStoreDefaultId(
                            msgValue,
                            mainComponent.chatModelId,
                            chatMessageStore
                        ).id;

                        mainComponent.chatMessageModelId = messageId;

                        view.scrollToBottom(
                            displayChatSendMessageContainer.displayChat
                        );

                        view.serverCall({
                            method: isForceSendMessage ? 'ForceQueryChatBot': 'QueryChatBot',
                            params: [ chatId,
                                    msgValue,
                                    currentChatBotInfo.DataNames,
                                    currentChatBotInfo.ChatBotName
                                    ],
                            success: function (resQuery) {
                                view.callBackChatMessageAddResult(
                                        chatMessageStore,
                                        resQuery,
                                        messageId
                                    );
                            }
                        })
                    }
                });
            } else {
                messageId = view.addToChatMessageStoreDefaultId(
                    msgValue,
                    mainComponent.chatModelId,
                    chatMessageStore
                ).id;

                mainComponent.chatMessageModelId = messageId;

                view.scrollToBottom(displayChatSendMessageContainer.displayChat);

                const chatId = chatsStore.getById(chatModelId).data.ChatId;

                view.serverCall({
                    method: isForceSendMessage ? 'ForceQueryChatBot': 'QueryChatBot',
                    params: [ chatId,
                        msgValue,
                        currentChatBotInfo.DataNames,
                        currentChatBotInfo.ChatBotName
                        ],
                    success: function (resQuery) {
                        view.callBackChatMessageAddResult(
                            chatMessageStore,
                            resQuery,
                            messageId,
                            sendMessageCallBack
                        );
                    }
                })
            }
        },

        insertWelcomeMessage(mainComponent, chatId) {
            let view = this;

            if (
                mainComponent.chatStore?.getById(chatId)?.data
                    ?.TotalQueriesCount ===
                mainComponent?.chatMessageStore?.data.count()
            ) {
                mainComponent.chatMessageStore?.insert(
                    0,
                    view.getWelcomeMessage(
                        mainComponent.chatMessageStore,
                        chatId,
                        view.getCurrentChatBotInfo(mainComponent).ChatBotName
                    )
                );
            }
        },

        getWelcomeMessage(chatMessageStore, chatId) {
            return Ext.create('Svod.ChatMessageModel', {
                Query: null,
                Result: 'Здравствуйте! Вас приветствует Чат-бот. Вы можете задать мне вопрос, а я постараюсь на него ответить.',
                chatModel: chatId,
                Type: -1
            });
        }
    });
}(ChatBotView.prototype));