﻿BaseSvodExportView = KS.extend(BaseSvodView, { });

(function(viewClass) {
    KS.apply(viewClass, {
        onTemplateRendered: function() {
            this.addExportProperties();
            this.mainGrid.getSelectionModel().selectAll();
        },

        addExportProperties: function() {
            this.serverCall({
                method: 'GetExportPropertiesData',
                disableFog: true,
                success: this.fillExportProperties
            });
        },

        fillExportProperties: function(listOptions) {
            if (listOptions) {
                var view = this;
                view.exportProperties.removeAll();
                if (!Ext.Object.isEmpty(listOptions)) {
                    var i = 0;
                    for (var prop in listOptions) {
                        if (listOptions.hasOwnProperty(prop)) {
                            var propertyGrid = view.getPropertyGridByOption(listOptions[prop], "exportPropGrid" + i++, prop);
                            if (!Ext.isEmpty(view.propertyChange))
                                propertyGrid.on("propertychange", view.propertyChange, view);
                            view.exportProperties.add(propertyGrid);
                        }
                    }
                }
            }
        },

        select: function() {
            var view = this.parentView;
            var gridState = "";
            if (view.mainGrid) {
                gridState = JSON.stringify(view.mainGrid.getControlState());
            }
            view.serverCall({
                method: 'SaveGridState',
                params: [gridState],
                disableFog: true,
                success: function(){
                    view.startExport();
                }
            });
        },
        
        startExport: function(){
            var view = this;
            var checkedCodes = view.mainGrid.getCheckedCodes();
            if (Ext.isEmpty(checkedCodes)) {
                KS.alert("Не выбрана ни одна запись для экспорта");
                return;
            }
            var collectProperties = view.collectProperties();
            view.serverCall({
                method: 'StartExport',
                params: [collectProperties, checkedCodes],
                waitMessage: 'Подготовка данных...',
                success: function () {
                    view.destroyContainerItems();
                }
            });
        },

        collectProperties: function() {
            var properties = {};
            Ext.each(this.exportProperties.items.items, function(propertyGrid) {
                var sourcePropGrid = propertyGrid.source;
                if (!Ext.Object.isEmpty(sourcePropGrid)) {
                    for (var prop in sourcePropGrid) {
                        if (sourcePropGrid.hasOwnProperty(prop)) {
                            var propKey = prop.split("#")[1];
                            properties[propKey] = sourcePropGrid[prop];
                        }
                    }
                }
            });
            return properties;
        }
    });
}(BaseSvodExportView.prototype));

if (typeof(Sys) !== 'undefined') Sys.Application.notifyScriptLoaded();