function FormSignerServer(p) {
    var ajaxContainer = (p && p.ajaxContainer) ? p.ajaxContainer : window;

    var is64arch = function () {
        if (navigator.userAgent.indexOf("WOW64") != -1
            || navigator.userAgent.indexOf("Win64") != -1
            || navigator.userAgent.indexOf("x86_64") != -1) {
            return true;
        } else {
            return false;
        }
    }();

    var isWindows = Ext.isWindows;


    var log = function (method, msg) {
        console.log("FormSignerServer: " + method + ": " + msg);
    };

    return {
        GetSettings: function (p /*mode, objcode, links, edsSchema, onSuccess*/) {
            var links = "";
            if (Array.isArray(p.links)) {
                links = p.links.join();
            } else {
                links = p.links;
            }

            ajaxContainer.AjaxRequest({
                mask: {
                    text: "Пожалуйста, подождите, получаем настройки.",
                    id: (p.shadowObjId) ? p.shadowObjId : null //ObjX.idContainer
                },
                url: "/Sign/GetOpenData",
                success: (typeof p.onSuccess === "function") ? function (settings) {
                    p.onSuccess(settings);
                } : function () { },
                error: (typeof p.onError === "function") ? function (r) {
                    p.onError(r);
                } : function (r) {
                    log("GetSettings", r);
                },
                params: {
                    mode: p.mode,
                    objcode: p.objcode,
                    links: links,
                    objectParameters: p.objectParameters,
                    objectParametersForGetData: p.objectParametersForGetData
                }
            });
        },

        GetServerVersion: function (p) {
            //var isWindows = (typeof p.isWindows === "boolean") ? p.isWindows : true; //Ext.isWindows
            ajaxContainer.AjaxRequest({
                mask: {
                    text: "Запрос номера версии на сервере.",
                    id: (p.shadowObjId) ? p.shadowObjId : null //ObjX.idContainer
                },
                url: "/Sign/GetModuleVersion",
                success: function (arr, params) {
                    var ver = arr[0],
                        filename = arr[1],
                        success = arr[2];
                    if (!ver || !filename || !success) {
                        p.onError("Не удалось определить версию на сервере [" + ver + "," + filename + "]");
                    } else if (typeof p.onSuccess === "function") {
                        p.onSuccess({
                            ver: ver,
                            filename: filename,
                            success: success,
                            reqParams: params
                        });
                    }
                },
                error: (typeof p.onError === "function") ? function (r) {
                    p.onError(r);
                } : function (r) {
                    log("GetServerVersion", r);
                },
                params: {
                    name: (p.moduleName) ? p.moduleName : null,
                    os: isWindows ? "windows" : "linux",
                    arch: is64arch ? "amd64" : "386",
                    mod: (p.mod) ? p.mod : "",
                    ext: isWindows ? "zip" : "tar.gz"
                }
            });
        },

        GetDataForSign: function (p /*settings, onSuccess*/) {
            ajaxContainer.AjaxRequest({
                mask: {
                    text: "Пожалуйста, подождите, получаем данные для подписи.",
                    id: (p.shadowObjId) ? p.shadowObjId : null //ObjX.idContainer
                },
                url: "/Sign/GetDataForSign",
                success: (typeof p.onSuccess === "function") ? function (dataForSign) {
                    p.onSuccess(dataForSign);
                } : function () { },
                error: (typeof p.onError === "function") ? function (r) {
                    p.onError(r);
                } : function (r) {
                    log("GetDataForSign", r);
                },
                params: {
                    settings: JSON.stringify(p.settings)
                },
                // !!! прогресс нужен в аяксреквесте !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
                uploadprogress: function (perc) {
                    uploadprogress(perc);
                },
                progress: function (perc) {
                    progress(perc);
                },
                errorTitle: "Ошибка получения данных для подписи (Sign/GetDataForSign)"
            });
        },

        GetDownloadedHash: function (p /*hashAlgOid*/) {
            ajaxContainer.AjaxRequest({
                mask: {
                    text: "Пожалуйста, подождите, получаем хэш данных для подписи.",
                    id: (p.shadowObjId) ? p.shadowObjId : null //ObjX.idContainer
                },
                url: "/Sign/GetDownloadedHash",
                success: (typeof p.onSuccess === "function") ? function (hashes) {
                    p.onSuccess(hashes);
                } : function () { },
                // function (d) {
                //     dataForSign = d; // заменим подписываемые данные (в данном случае там ключи для сервиса первичек) их хэшами
                //     data = p.dataForSign[i];
                //     nextStep();
                // },
                error: (typeof p.onError === "function") ? function (r) {
                    p.onError(r);
                } : function (r) {
                    log("GetDownloadedHash", r);
                },
                params: {
                    settings: JSON.stringify(p.settings),
                    data: Ext.encode(p.dataForSign),
                    hashAlgOid: p.hashAlgOid
                },
                // !!! прогресс нужен в аяксреквесте !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
                uploadprogress: function (perc) {
                    uploadprogress(perc);
                },
                progress: function (perc) {
                    progress(perc);
                },
                errorTitle: "Ошибка получения хэша данных (Sign/GetDownloadedHash)"
            });
        },

        FormSign_SignSave: function (p /*settings, dataForSave, afterSave*/) {
            ajaxContainer.AjaxRequest({
                mask: {
                    text: "Пожалуйста, подождите, сохранение подписей.",
                    id: (p.shadowObjId) ? p.shadowObjId : null //ObjX.idContainer
                },
                async: true,
                url: "/Sign/Sign",
                params: {
                    settings: JSON.stringify(p.settings),
                    data: Ext.encode(p.dataForSave)
                },
                success: (typeof p.onSuccess === "function") ? function (r) {
                    p.onSuccess(r);
                } : function () { },
                error: (typeof p.onError === "function") ? function (r) {
                    p.onError(r);
                } : function (r) {
                    log("FormSign_SignSave", r);
                },
                // function (r) {
                //     // Удалим архив сертификатов
                //     _signer.DeleteArchive();
                //     if (r.error) return false;
                //     if (opener)
                //         opener.SignDocument_CallBack();

                //     ShowProtocol(null, "b0b5", null, r);
                //     if (typeof afterSave === "function") afterSave();
                //     return false;
                // },
                // !!! прогресс нужен в аяксреквесте !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
                uploadprogress: function (perc) {
                    uploadprogress(perc);
                },
                progress: function (perc) {
                    progress("", perc);
                },
                errorTitle: "Ошибка передачи данных (Sign/Sign)"
            });
        },

        CallServerMethod: function (p) {
            return new Promise(function (resolve, reject) {
                ajaxContainer.AjaxRequest({
                    mask: {
                        text: "Пожалуйста, подождите.",
                        id: (p.shadowObjId) ? p.shadowObjId : null
                    },
                    async: true,
                    url: p.method,
                    params: p.params,
                    success: resolve,
                    error: reject,
                    errorTitle: "Ошибка выполнения (" + p.method + ")"
                });
            });
        }
    };
}