/**
 * List compiled by mystix on the extjs.com forums.
 * Thank you Mystix!
 *
 * English Translations
 * updated to 2.2 by Condor (8 Aug 2008)
 */
Ext.onReady(function() {

    if (Ext.data && Ext.data.Types) {
        Ext.data.Types.stripRe = /[\$,%]/g;
    }

    if (Ext.Date) {
        Ext.Date.defaultFormat = 'd.m.Y';
        Ext.Date.monthNames = ["Январ", "Феврал", "Март", "Апрел", "Май", "Июн", "Июл", "Август", "Сентябр", "Октябр", "Ноябр", "Декабр"];
        Ext.Date.shortMonthNames = ["Янв", "Февр", "Март", "Апр", "Май", "Июнь", "Июль", "Авг", "Сент", "Окт", "Нояб", "Дек"];
        Ext.Date.getShortMonthName = function(month) {
            return Ext.Date.monthNames[month].substring(0, 3);
        };

        Ext.Date.monthNumbers = {
            'Янв': 0,
            'Февр': 1,
            'Март': 2,
            'Апр': 3,
            'Май': 4,
            'Июн': 5,
            'Июл': 6,
            'Авг': 7,
            'Сент': 8,
            'Окт': 9,
            'Нояб': 10,
            'Дек': 11
        };

        Ext.Date.getMonthNumber = function(name) {
            return Ext.Date.monthNumbers[name.substring(0, 1).toUpperCase() + name.substring(1, 3).toLowerCase()];
        };

        Ext.Date.dayNames = ["Якшанбе", "Душанбе", "Сешанбе", "Чоршанбе", "Панҷшанбе", "Ҷумъа", "Шанбе"];

        Ext.Date.getShortDayName = function(day) {
            return Ext.Date.dayNames[day].substring(0, 3);
        };

        Ext.Date.parseCodes.S.s = "(?:st|nd|rd|th)";

        Ext.Date.firstDayOfWeek = 0;
        Ext.Date.weekendDays = [6, 0];
    }

    if (Ext.util && Ext.util.Format) {
        Ext.apply(Ext.util.Format, {
            thousandSeparator: ' ',
            decimalSeparator: '.',
            currencySign: 'сом',
            dateFormat: 'd.m.Y'
        });
    }
});

Ext.define("Ext.locale.ru.tab.Tab", {
    override: "Ext.tab.Tab",
    closeText: "Пӯшидани ин ҷадвалбандӣ"
});

Ext.define("Ext.locale.tg.data.validator.Bound", {
    override: "Ext.data.validator.Bound",
    emptyMessage: "Must be present"
});

Ext.define("Ext.locale.tg.data.validator.Email", {
    override: "Ext.data.validator.Email",
    message: "Is not a valid email address"
});

Ext.define("Ext.locale.tg.data.validator.Exclusion", {
    override: "Ext.data.validator.Exclusion",
    message: "Is a value that has been excluded"
});

Ext.define("Ext.locale.tg.data.validator.Format", {
    override: "Ext.data.validator.Format",
    message: "Is in the wrong format"
});

Ext.define("Ext.locale.tg.data.validator.Inclusion", {
    override: "Ext.data.validator.Inclusion",
    message: "Is not in the list of acceptable values"
});

Ext.define("Ext.locale.tg.data.validator.Length", {
    override: "Ext.data.validator.Length",
    minOnlyMessage: "Length must be at least {0}",
    maxOnlyMessage: "Length must be no more than {0}",
    bothMessage: "Length must be between {0} and {1}"
});

Ext.define("Ext.locale.tg.data.validator.Presence", {
    override: "Ext.data.validator.Presence",
    message: "Must be present"
});

Ext.define("Ext.locale.tg.data.validator.Range", {
    override: "Ext.data.validator.Range",
    minOnlyMessage: "Must be must be at least {0}",
    maxOnlyMessage: "Must be no more than than {0}",
    bothMessage: "Must be between {0} and {1}",
    nanMessage: "Must be numeric"
});

Ext.define("Ext.locale.tg.view.View", {
    override: "Ext.view.View",
    emptyText: ""
});

Ext.define("Ext.locale.tg.grid.plugin.DragDrop", {
    override: "Ext.grid.plugin.DragDrop",
    dragText: "{0} сатри интихобшуда"
});

// changing the msg text below will affect the LoadMask
Ext.define("Ext.locale.tg.view.AbstractView", {
    override: "Ext.view.AbstractView",
    loadingText: "Боргирӣ..."
});

Ext.define("Ext.locale.tg.picker.Date", {
    override: "Ext.picker.Date",
    todayText: "Имрӯз",
    minText: "Ин сана аз санаи ҳадди ақалӣ пештар аст ",
    maxText: "Ин сана аз санаи ҳадди аксарӣ дертар аст",
    disabledDaysText: "",
    disabledDatesText: "",
    nextText: 'Моҳи баъдӣ (Control+Ба рост)',
    prevText: 'Моҳи қаблӣ (Control+Ба чап)',
    monthYearText: 'Интихоби моҳ (Control+Ба боло/Ба поён барои интихоби сол)',
    todayTip: "{0} (Фосила)",
    format: "d.m.y",
    startDay: 0
});

Ext.define("Ext.locale.tg.picker.Month", {
    override: "Ext.picker.Month",
    okText: "&#160;OK&#160;",
    cancelText: "Бекоркунӣ"
});

Ext.define("Ext.locale.tg.toolbar.Paging", {
    override: "Ext.PagingToolbar",
    beforePageText: "Саҳифа",
    afterPageText: "аз {0}",
    firstText: "Саҳифаи аввал",
    prevText: "Саҳифаи қаблӣ",
    nextText: "Саҳифаи баъдӣ",
    lastText: "Саҳифаи охирин",
    refreshText: "Навсозӣ кардан",
    displayMsg: "Намоиш дода мешаванд сабтҳо аз {0} то {1}, ҳамагӣ {2}",
    emptyMsg: 'Додаҳо барои намоиш нест'
});

Ext.define("Ext.locale.tg.form.Basic", {
    override: "Ext.form.Basic",
    waitTitle: "Лутфан, мунтазир бошед..."
});

Ext.define("Ext.locale.tg.form.field.Base", {
    override: "Ext.form.field.Base",
    invalidText: "The value in this field is invalid"
});

Ext.define("Ext.locale.tg.form.field.Text", {
    override: "Ext.form.field.Text",
    minLengthText: "Тӯли ҳадди ақалии ин майдон {0}",
    maxLengthText: "Тӯли ҳадди аксарии ин майдон {0}",
    blankText: "Пур кардани ин майдон ҳатмӣ аст",
    regexText: "",
    emptyText: null
});

Ext.define("Ext.locale.tg.form.field.Number", {
    override: "Ext.form.field.Number",
    decimalPrecision: 2,
    minText: "Мафҳуми ин майдон наметавонад камтар аз {0} бошад",
    maxText: "Мафҳуми ин майдон наметавонад бештар аз {0} бошад",
    nanText: "{0} шумора намебошад",
    negativeText: 'Мафҳум наметавонад манфӣ бошад'
});

Ext.define("Ext.locale.tg.form.field.Date", {
    override: "Ext.form.field.Date",
    disabledDaysText: "Дастрас нест",
    disabledDatesText: "Дастрас нест",
    minText: "Сана дар ин майдон бояд дертар аз {0} бошад",
    maxText: "Сана дар ин майдон бояд пештар аз {0} бошад",
    invalidText: "{0} санаи дуруст намебошад - сана бояд дар формати {1} бошад",
    format: "d.m.y",
    altFormats: "d.m.y|d/m/Y|d-m-y|d-m-Y|d/m|d-m|dm|dmy|dmY|d|Y-m-d"
});

Ext.define("Ext.locale.tg.form.field.ComboBox", {
    override: "Ext.form.field.ComboBox",
    valueNotFoundText: undefined
}, function() {
    Ext.apply(Ext.form.field.ComboBox.prototype.defaultListConfig, {
        loadingText: "Боргирӣ..."
    });
});

Ext.define("Ext.locale.tg.form.field.VTypes", {
    override: "Ext.form.field.VTypes",
    emailText: 'Ин майдон бояд дорои суроғаи почтаи эллектрони дар формати "user@example.com" бошад',
    urlText: 'Ин майдон бояд дорои URL дар формати "http:/' + '/www.example.com" бошад',
    alphaText: 'Ин майдон бояд танҳо ҳарфҳои лотинӣ ва аломати зерхаткашӣ "_" дошта бошад',
    alphanumText: 'Ин майдон бояд танҳо ҳарфҳои лотинӣ, рақамҳо ва аломати зерхаткашӣ "_" дошта бошад'
});

Ext.define("Ext.locale.tg.form.field.HtmlEditor", {
    override: "Ext.form.field.HtmlEditor",
    createLinkText: 'Лутфан, суроғаро ворид кунед:'
}, function() {
    Ext.apply(Ext.form.field.HtmlEditor.prototype, {
        buttonTips: {
            bold: {
                title: 'Нимбарҷаста (Ctrl+B)',
                text: 'Ба кор бурдани ҳарфҳои нимағафс нисбати матни ҷудокардашуда.',
                cls: Ext.baseCSSPrefix + 'html-editor-tip'
            },
            italic: {
                title: 'Курсив (Ctrl+I)',
                text: 'Татбиқи шакли курсивӣ ба матни интихобшуда.',
                cls: Ext.baseCSSPrefix + 'html-editor-tip'
            },
            underline: {
                title: 'Хаткашида шуда (Ctrl+U)',
                text: 'Зерхаткашии матни интихобшуда.',
                cls: Ext.baseCSSPrefix + 'html-editor-tip'
            },
            increasefontsize: {
                title: 'Афзоиш додани андоза',
                text: 'Афзоиши андозаи шрифт.',
                cls: Ext.baseCSSPrefix + 'html-editor-tip'
            },
            decreasefontsize: {
                title: 'Уменьшить размер',
                text: 'Коҳиш додани андозаи шрифт.',
                cls: Ext.baseCSSPrefix + 'html-editor-tip'
            },
            backcolor: {
                title: 'Рангпошӣ',
                text: 'Тайири ранги пасзамина барои матни интихобшуда ё сархат.',
                cls: Ext.baseCSSPrefix + 'html-editor-tip'
            },
            forecolor: {
                title: 'Ранги матн',
                text: 'Тағйири ранги матн.',
                cls: Ext.baseCSSPrefix + 'html-editor-tip'
            },
            justifyleft: {
                title: 'Баробар кардани матн аз самти чап',
                text: 'Баробаркунии матн аз самти чап.',
                cls: Ext.baseCSSPrefix + 'html-editor-tip'
            },
            justifycenter: {
                title: 'Ба марказ',
                text: 'Вырaвнивание текста по центру.',
                cls: Ext.baseCSSPrefix + 'html-editor-tip'
            },
            justifyright: {
                title: 'Баробар кардани матн аз самти рост',
                text: 'Баробар кардани матн аз самти рост.',
                cls: Ext.baseCSSPrefix + 'html-editor-tip'
            },
            insertunorderedlist: {
                title: 'Маркерҳо',
                text: 'Оғоз кардани рӯйхати маркировкашуда.',
                cls: Ext.baseCSSPrefix + 'html-editor-tip'
            },
            insertorderedlist: {
                title: 'Рақамгузорӣ',
                text: 'Оғоз кардани рӯйхати рақамагузоришуда.',
                cls: Ext.baseCSSPrefix + 'html-editor-tip'
            },
            createlink: {
                title: 'Гузоштани гиперистинод',
                text: 'Эҷоди истинод аз матни интихобшуда.',
                cls: Ext.baseCSSPrefix + 'html-editor-tip'
            },
            sourceedit: {
                title: 'Рамзи аслӣ',
                text: 'Гузариш ба рамзи аслӣ.',
                cls: Ext.baseCSSPrefix + 'html-editor-tip'
            }
        }
    });
});

Ext.define("Ext.locale.tg.grid.header.Container", {
    override: "Ext.grid.header.Container",
    sortAscText: "Мураттабсозӣ ба таври суудӣ",
    sortDescText: "Мураттабсозӣ ба таври нузулӣ",
    columnsText: "Сутунҳо",
    lockText: 'Устувор кардани сутун',
    unlockText: 'Баровардани сутун'
});

Ext.define("Ext.locale.tg.grid.GroupingFeature", {
    override: "Ext.grid.feature.Grouping",
    emptyGroupText: '(Холӣ)',
    groupByText: 'Гурӯҳбандӣ кардан аз рӯи ин майдон',
    showGroupsText: 'Намоиш додан аз рӯи гурӯҳҳо'
});

Ext.define("Ext.locale.tg.grid.PropertyColumnModel", {
    override: "Ext.grid.PropertyColumnModel",
    nameText: "Ном",
    valueText: "Мафҳум",
    dateFormat: "d.m.Y",
    trueText: "true",
    falseText: "false"
});

Ext.define("Ext.locale.tg.grid.BooleanColumn", {
    override: "Ext.grid.BooleanColumn",
    trueText: "true",
    falseText: "false",
    undefinedText: '&#160;'
});

Ext.define("Ext.locale.tg.grid.NumberColumn", {
    override: "Ext.grid.NumberColumn",
    format: '0,000.00'
});

Ext.define("Ext.locale.tg.grid.DateColumn", {
    override: "Ext.grid.DateColumn",
    format: 'd.m.Y'
});

Ext.define("Ext.locale.tg.form.field.Time", {
    override: "Ext.form.field.Time",
    minText: "The time in this field must be equal to or after {0}",
    maxText: "The time in this field must be equal to or before {0}",
    invalidText: "{0} is not a valid time",
    format: "g:i A",
    altFormats: "g:ia|g:iA|g:i a|g:i A|h:i|g:i|H:i|ga|ha|gA|h a|g a|g A|gi|hi|gia|hia|g|H"
});

Ext.define("Ext.locale.tg.form.field.File", {
    override: "Ext.form.field.File",
    buttonText: "Мурур..."
});

Ext.define("Ext.locale.tg.form.CheckboxGroup", {
    override: "Ext.form.CheckboxGroup",
    blankText: "You must select at least one item in this group"
});

Ext.define("Ext.locale.tg.form.RadioGroup", {
    override: "Ext.form.RadioGroup",
    blankText: "You must select one item in this group"
});

Ext.define("Ext.locale.tg.window.MessageBox", {
    override: "Ext.window.MessageBox",
    buttonText: {
        ok: "OK",
        cancel: "Бекоркунӣ",
        yes: "Ҳа",
        no: "Нест"
    }
});

Ext.define("Ext.locale.tg.grid.filters.Filters", {
    override: "Ext.grid.filters.Filters",
    menuFilterText: "Filters"
});

Ext.define("Ext.locale.tg.grid.filters.filter.Boolean", {
    override: "Ext.grid.filters.filter.Boolean",
    yesText: "Ҳа",
    noText: "Нест"
});

Ext.define("Ext.locale.tg.grid.filters.filter.Date", {
    override: "Ext.grid.filters.filter.Date",
    fields: {
        lt: { text: 'Before' },
        gt: { text: 'After' },
        eq: { text: 'On' }
    },
    // Defaults to Ext.Date.defaultFormat
    dateFormat: null
});

Ext.define("Ext.locale.tg.grid.filters.filter.List", {
    override: "Ext.grid.filters.filter.List",
    loadingText: "Боргирӣ..."
});

Ext.define("Ext.locale.tg.grid.filters.filter.Number", {
    override: "Ext.grid.filters.filter.Number",
    emptyText: "Enter Number..."
});

Ext.define("Ext.locale.tg.grid.filters.filter.String", {
    override: "Ext.grid.filters.filter.String",
    emptyText: "Enter Filter Text..."
});

Ext.define("Ext.locale.tg.view.MultiSelectorSearch", {
    override: 'Ext.view.MultiSelectorSearch',
    searchText: 'Ҷустуҷӯ...'
});

Ext.define("Ext.locale.tg.view.MultiSelector", {
    override: 'Ext.view.MultiSelector',
    emptyText: 'Nothing selected',
    removeRowTip: 'Remove this item',
    addToolText: 'Search for items to add'
});

// This is needed until we can refactor all of the locales into individual files
Ext.define("Ext.locale.tg.Component", {
    override: "Ext.Component"
});
