﻿function getLevelName(level) {
    switch (+level) {
        case 0:
            return 'Trace';
        case 1:
            return 'Debug';
        case 2:
            return 'Info';
        case 3:
            return 'Warn';
        case 4:
            return 'Error';
        case 5:
            return 'Fatal';
        default:
            return '';
    }
}

function baseRenderer(value, metadata, record) {
    metadata.css += ' log-level-' + getLevelName(record.get('Level'));
    return value;
}

function levelRenderer(value, metadata, record) {
    baseRenderer(value, metadata, record);
    return getLevelName(record.get('Level'));
}

function dateTimeRenderer(value, metadata, record) {
    baseRenderer(value, metadata, record);
    var dt = KS.parseAjaxDateTime(value);
    return Ext.Date.format(dt, "H:i:s");
}

// view class
LogReaderView = KS.extend(KS.Ext.ClientView,
    {
        constructor: function(viewId) {
            LogReaderView.superclass.constructor.call(this, viewId);
        },

        loaded: false,

        logLevelNames: ['TRACE', 'DEBUG', 'INFO', 'WARN', 'ERROR', 'FATAL'],

        onInit: function() {
            var view = this,
                now = new Date(),
                ret = new Ext.Template(
                    '<p><b>Message:</b> {HtmlMessage}</p></br><p><b>Exception:</b> {HtmlException}</p>');

            var logLevels = [];
            Ext.each(view.logLevelNames,
                function(name, idx) {
                    logLevels.push({
                        boxLabel: name,
                        checked: (idx > 2)
                    });
                });

            view.renderToParent({
                layout: 'border',
                tbar: [
                    {
                        iconCls: 'ks-icon-refresh',
                        tooltip: 'Перечитать данные',
                        scope: view,
                        handler: view.fetchData
                    },
                    '-',
                    {
                        iconCls: 'ks-icon-copy',
                        tooltip: 'Копировать в буфер обмена',
                        scope: view,
                        handler: view.copyToClipBoard
                    }
                ],
                width: 500,
                height: 300,
                defaults: { split: true },
                items: [
                    {
                        height: 200,
                        region: 'south',
                        layout: 'hbox',
                        collapsed: (KS.getCookie('logdetails') != 1),
                        collapseMode: 'mini',
                        layoutConfig: { align: 'stretch' },
                        items: [
                            view.msgPanel = new Ext.Panel({
                                flex: 1,
                                autoScroll: true,
                                title: 'Текст сообщения',
                                html: ''
                            }),
                            view.exeptPanel = new Ext.Panel({
                                flex: 1,
                                autoScroll: true,
                                title: 'Текст исключения',
                                html: ''
                            })
                        ],
                        listeners: {
                            'collapse': function() { KS.setCookie('logdetails', 0, new Date().addDays(7)); },
                            'expand': function() { KS.setCookie('logdetails', 1, new Date().addDays(7)); }
                        }
                    },
                    {
                        minWidth: 250,
                        region: 'west',
                        layout: 'form',
                        collapsible: true,
                        labelWidth: 70,
                        padding: 10,
                        defaults: { width: 200 },
                        items: [
                            view.date = new Ext.form.DateField({
                                fieldLabel: 'Дата',
                                value: now
                            }),
                            view.startTime = new Ext.form.TimeField({
                                fieldLabel: 'Начало',
                                format: 'H:i',
                                value: new Date(now.getFullYear(),
                                    now.getMonth(),
                                    now.getDate(),
                                    now.getHours() - 1,
                                    now.getMinutes())
                            }),
                            view.endTime = new Ext.form.TimeField({
                                fieldLabel: 'Конец',
                                format: 'H:i',
                                value: now
                            }),
                            view.user = new Ext.form.TextField({
                                fieldLabel: 'Логин'
                            }),
                            view.search = new Ext.form.TextField({
                                fieldLabel: 'Поиск'
                            }),
                            view.exclude = new Ext.form.TextField({
                                fieldLabel: 'Исключить'
                            }),
                            view.logLevels = new Ext.form.CheckboxGroup({
                                fieldLabel: 'LogLevels',
                                border: true,
                                columns: 1,
                                items: logLevels
                            })
                        ]
                    },
                    view.grid = Ext.create('KS.Ext.Grid',
                        view.gridcfg,
                        {
                            region: 'center',
                            //disabled: true,
                            maskOnDisable: false,
                            minHeight: 350,
                            width: 500,
                            parentView: view
                            //loadMask: false,
                            //customLoad: true,
                        })
                ]
            });

            view.grid.getSelectionModel().on('selectionchange', view.select, view);
            view.fetchData();
        },

        fetchData: function() {
            var view = this,
                date = Ext.util.Format.date(view.date.getValue(), 'Y-m-d'),
                startTime = view.startTime.getValue(),
                endTime = view.endTime.getValue(),
                user = view.user.getValue(),
                searchString = view.search.getValue(),
                excludeString = view.exclude.getValue(),
                logLevels = [];

            view.logLevels.items.each(function(checkbox) {
                if (checkbox.getValue()) {
                    logLevels.push(checkbox.boxLabel);
                }
            });
            view.serverCall({
                method: 'DoFetchData',
                waitMessage: 'Чтение данных...',
                params: [
                    date, startTime.getHours() + ':' + startTime.getMinutes(),
                    endTime.getHours() + ':' + endTime.getMinutes(), user, searchString, excludeString, logLevels
                ],
                success: function(recsCount) {
                    view.recordsCount = recsCount;

                    if (recsCount <= 0) {
                        view.grid.store.removeAll();
                        KS.msg('Нет данных');
                    } else {
                        view.grid.store.loadPageFromServerTemplate(view.grid.getActivePage());
                        //if (view.loaded) {
                        //    view.grid.resetGrid();
                        //} else {
                        //    view.grid.store.loadPageFromServerTemplate(1);
                        //    view.loaded = true;
                        //}
                    }
                }
            });
        },

        select: function(selModel) {
            var view = this,
                rec = selModel.getSelected().items[0];

            if (rec) {
                view.msgPanel.update(rec.data.HtmlMessage);
                view.exeptPanel.update(rec.data.HtmlException);
            }
        },

        columnsToCopy: ['Stamp', 'Level', 'User', 'Message', 'Exception'],

        copyToClipBoard: function() {
            var view = this,
                rec = view.grid.getSelectionModel().getSelection()[0];

            if (rec) {
                var text = '';
                Ext.each(view.columnsToCopy,
                    function(colKey) {
                        text += rec.data[colKey] + '\r\n\r\n';
                    });
                KS.copyToClipBoard(text);
            }
        },

        gridcfg: {
            editable: false,
            enablePaging: true,
            title: false,
            json: {},
            itemId: 'LogReaderView',
            EnabledGroup: 0,
            autoLoad: true,
            gridSettings: {
                Band: [
                    {
                        PageSize: 20,
                        autoExpandColumn: 'Message',
                        checked: false,
                        layout: null,
                        rowNumberer: false,
                        title: null,
                        Column: [
                            {
                                dataIndex: 'HtmlMessage',
                                visibility: false
                            },
                            {
                                dataIndex: 'HtmlException',
                                visibility: false
                            },
                            {
                                dataIndex: 'ID',
                                visibility: false
                            },
                            {
                                dataIndex: 'ThreadID',
                                visibility: false
                            },
                            {
                                dataIndex: 'Stamp',
                                header: 'Stamp',
                                renderer: 'dateTimeRenderer',
                                width: 120,
                                sortable: true,
                                result: null,
                                visibility: true,
                                align: 2
                            },
                            {
                                dataIndex: 'Level',
                                header: 'Level',
                                renderer: 'levelRenderer',
                                width: 65,
                                sortable: true,
                                visibility: true,
                                align: 2
                            },
                            {
                                dataIndex: 'User',
                                header: 'User',
                                renderer: 'baseRenderer',
                                width: 85,
                                sortable: true,
                                visibility: true,
                                align: 2
                            },
                            {
                                dataIndex: 'Message',
                                renderer: 'baseRenderer',
                                header: 'Message',
                                width: 85,
                                sortable: true,
                                visibility: true
                            },
                            {
                                dataIndex: 'Exception',
                                renderer: 'baseRenderer',
                                header: 'Exception',
                                width: 85,
                                sortable: true,
                                visibility: true
                            }
                        ]
                    }
                ]
            }
        }
    });