﻿# Скрипт создания файла appsettings.Production.json
Write-Host "Создание файла конфига appsettings.Production.json" -ForegroundColor Green
Write-Host ""

# Проверка существования файла
if (Test-Path "appsettings.Production.json") {
    $overwrite = Read-Host "Файл appsettings.Production.json уже существует. Перезаписать? (y/n)"
    if ($overwrite -ne "y" -and $overwrite -ne "Y") {
        Write-Host "Операция отменена." -ForegroundColor Red
        pause
        exit 1
    }
    Write-Host ""
}

Write-Host "Настройка подключения к базе" -ForegroundColor Yellow
Write-Host ""

# Ввод данных
$dataSourceType = Read-Host "Тип источника данных (0-MSSQL, 3-PGSQL)"
$server = Read-Host "Сервер (для PG указывать с портом)"
$database = Read-Host "База данных"

# Создание JSON содержимого
$jsonContent = @"
{
  "Serilog": {
    "MinimumLevel": {
      "Default": "Information",
      "Override": {
        "Microsoft": "Warning",
        "Microsoft.Hosting.Lifetime": "Information",
        "Microsoft.AspNetCore": "Warning",
        "Microsoft.AspNetCore.Mvc.Razor.Internal": "Warning",
        "Microsoft.AspNetCore.Mvc.Razor.Razor": "Debug",
        "Microsoft.AspNetCore.Mvc.Razor": "Error",
        "Quartz": "Warning"
      }
    }
  },

  "SqlClient": {
    "DataSourceType_comment": "Тип БД (MSSQL=0, PostgreSQL=3)",
    "DataSourceType": "$dataSourceType",
    "Server": "$server",
    "DataBase": "$database"
  },

  "SystemSettings": {
    "AlternativeUploadService_comment": "Сервис оправдательных документов (переопределяет значение из БД)",
    "AlternativeUploadService": "",

    "AuthorizationType": 0,
    "AuthorizationService": "",
    "AuthorizationAccountLogin": "sa_manager",
    "AuthorizationAccountPassword": ""
  },

  "HandlerServices_comment": "Данные для установки подключения при работе с сервисами",
  "HandlerServices": {
    "User": "admin",
    "Password": ""
  }
}
"@

# Сохранение файла
$jsonContent | Set-Content -Path "appsettings.Production.json" -Encoding UTF8

Write-Host "Настройки заданы. Файл appsettings.Production.json создан успешно!" -ForegroundColor Green
Write-Host ""

# Создание web.config если не существует
if (-not (Test-Path "web.config")) {
    $webConfigContent = @'
<?xml version="1.0" encoding="utf-8"?>
<configuration>
  <location path="." inheritInChildApplications="false">
    <system.webServer>
      <handlers>
        <add name="aspNetCore" path="*" verb="*" modules="AspNetCoreModuleV2" resourceType="Unspecified" />
      </handlers>
      <aspNetCore processPath="dotnet" arguments=".\Keysystems.Svod.Web.Core.dll" stdoutLogEnabled="false" stdoutLogFile=".\logs\stdout" hostingModel="inprocess" >
        <environmentVariables>
          <environmentVariable name="ASPNETCORE_ENVIRONMENT" value="Production" />
        </environmentVariables>
      </aspNetCore>
    </system.webServer>
  </location>
</configuration>
'@
    $webConfigContent | Set-Content -Path "web.config" -Encoding UTF8
    Write-Host "Файл web.config создан успешно!" -ForegroundColor Green
}

pause