﻿SavedFormView = KS.extend(BaseSvodView, {});

// ============= BASE =======================
(function (viewClass) {
    KS.apply(viewClass, {
        onTemplateRendered: function() {
            if (this.data.isRPN && !this.rpnFieldAdded)
                this.addRpnField();
            this.childViews = [];
            this.showNotes();
            this.postRenderInit();
            if (!KS.isEmpty(this.deferredAddChildViews)) {
                for (var idx = 0; idx < this.deferredAddChildViews.length; idx++) {
                    this.addChildView(this.deferredAddChildViews[idx]);
                }
                delete this.deferredAddChildViews;
            }
            if (!Ext.isEmpty(this.form))
                this.form.collapse();
            if (this.data.startProtocol) 
                KS.Svod.showHtmlProtocol(this.data.startProtocol.html, this.data.startProtocol.title);

            KS.Ajax.pingServer();
        },

        formExpanded: function () {
            this.form.setTitle("<span class='x-fieldset-title'>Форма</span>");
        },

        formCollapsed: function() {
            var formInfo = this.data.formInfo;
            var title = 'Форма' + ' [' + formInfo.FormCode + '] - ' + this.formDate.getValue() + ' - ' + formInfo.FormName + ' - ' + formInfo.FormComment;
            this.form.setTitle("<span class='x-fieldset-title'>" + title + "</span>");
        },

        isHtmlForm: function () {
            var r = false;
            this.eachTable(function (tableView) { if (tableView.data && tableView.data.isHtmlForm) r = true; });
            return r;
        },

        touch: function (fromDependent) {
            if (this.initState === true) return;
            if (fromDependent !== true) this.hasChanges = true;
            this.setSavedState(false);
            this.getToolbarItem(this.rootPanel, null, 'SAVE').setDisabled(false);
            this.getToolbarItem(this.rootPanel, null, 'SAVE2').setDisabled(false);
        },

        setValues: function () {
           this.initState = true;

            this.setCustomDetails();

            //window.weekPeriods = this.data.weeks; // ??

            this.setPeriod();

            this.reportStatus.store.loadData(this.data.statuses);
            this.reportStatus.setValue(this.getSavedStatusLink());

            this.showNotes();

            this.initState = false;
        },

        getSavedStatusLink: function() {
            var sForm = this.data.savedForm;
            return sForm && !this.data.useBPMSStatus
                ? sForm.SavedFormStatusLink
                : this.data.bpmsStatus;
        },

        openBudgOrgDictionary: function () {
            this.parentView.openDictionary('budgOrgDict');
        },

        openAttrDictionary: function (srcCmp) {
            var view = this,
                colKey = '';
            if (srcCmp.xtype === 'textfield') {
                view = this.parentView;
                colKey = srcCmp.code;
            }
            if (!Ext.isEmpty(colKey)) view.openDictionary('attrDict', colKey);
        },

        openDictionary: function (dict, key) {
            this.serverCall({
                method: 'OpenDictionary',
                params: [dict, key || ''],
                waitMessage: 'Открытие справочника'
            });
        },

        addNote: function () {
            var view = this.parentView,
                note = view.noteField.getValue();
            if (Ext.isEmpty(note)) {
                return;
            }
            view.serverCall({
                method: 'AddNote',
                params: [note],
                progressOnly: true,
                success: function (notes) {
                    if (notes) {
                        view.data.notes = notes;
                        view.noteField.setValue('');
                        view.showNotes();
                    }
                }
            });
        },

        deleteNote: function(noteLink){
            var view = this;
            view.serverCall({
                method: 'DeleteNote',
                params: [noteLink],
                success: function (notes) {
                    if (notes) {
                        view.data.notes = notes;
                        view.showNotes();
                    }
                }
            });
        },

        showNotes: function () {
            if (!this.notesTab) return;
            var view = this,
                showSystem = view.showSystemNotes.getValue(),
                notes = '';
            if (view.data.notes) {
                Ext.each(view.data.notes,
                    function (note) {
                        if (note.Type !== 0 && note.Type !== 9 && !showSystem) {
                            return;
                        }
                        var noteText = note.Text;
                        if (!Ext.isEmpty(noteText)) {
                            noteText = noteText.replace(/<<<ViewID>>>/g, view.viewID);
                        }
                        notes += '[' + note.DateString + '] ' + note.UserName + ': ' + noteText + '</br>';
                    });
            }
            if (view.notesPanel.rendered)
                view.notesPanel.update(notes);
        },

        saveChanges: function (close) {
            var view;
            if (close === true) {
                view = this;
            } else {
                view = this.parentView || this;
            }
            var isNew = view.data.savedForm.LinkSavedForm < 0;
            view.resetQueuedActions();
            if (view.hasChanges || view.hasTablesChanges() || isNew) {
                view.addAction({ cmd: 'flush' });
                view.addAction({ cmd: 'save' });

                if (view.data.isInternationalRPN)
                    view.addAction({ cmd: 'rpnSendNotice' });

                if (close === true) {
                    view.addAction({ cmd: 'close' });  //?
                } else {
//                        if (view.data.settings.AutoReload || isNew) {
//                            view.addAction({ cmd: 'refresh' });
//                        } else {
//                            view.addAction({ cmd: 'discard' });
//                        }

                    view.addAction({ cmd: 'refresh' }); //Пока всегда refresh таблиц, не нашёл AutoReload в SFModel

                    view.addAction({ cmd: 'alert', params: ['Сохранение выполнено успешно'] });
                }
            }
            view.processQueuedActions();
        },

        saveChanges2: function () {
            var view = this.parentView;
            view.resetQueuedActions();
            if (view.hasChanges || view.hasTablesChanges() || view.data.isNewTask) {
                view.addAction({ cmd: 'flush' });
                view.addAction({ cmd: 'save' });
                view.addAction({ cmd: 'calc' });
                view.addAction({ cmd: 'checkKS', params: ["SHOW_CHECK_SUMS_REPORT"]});
                view.addAction({ cmd: 'refresh' });
            }
            view.processQueuedActions();
        },

        resetQueuedActions: function () {
            this.queuedActions = [];
        },

        addAction: function (action) {
            if (!this.queuedActions) {
                this.resetQueuedActions();
            }
            this.queuedActions.push(action);
        },

        processQueuedActions: function () {
            var view = this;
            if (Ext.isEmpty(view.queuedActions)) {
                view.resetQueuedActions();
                return;
            }
            var action = view.queuedActions.splice(0, 1)[0];
            action.params = action.params || [];
            switch (action.cmd) {
                case 'close':
                    view.close();
                    break;
                case 'flush':
                    this.eachTable(function (tableView) { tableView.needFlush = true; });
                    view.flushAllTables();
                    break;
                case 'save':
                    view.doSaveChanges(action.params);
                    break;
                case 'refresh':
                    view.refresh(action.params);
                    break;
                case 'autoTable':
                    view.loadDefaultTable();
                    break;
                case 'discard':
                    view.discardChanges(true);
                    break;
                case 'calc':
                    view.doCalcResults(false);
                    break;
                case 'calcTable':
                    view.doCalcResults(true);
                    break;
                case 'checkKS':
                    view.docheckKS(action.params);
                    break;
                case 'repeatSvod':
                    view.doRepeatSvod(action.params);
                    break;
                case 'print':
                    view.doPrintReport(false);
                    break;
                case 'printPreview':
                    view.doPrintReport(true);
                    break;
                case 'alert':
                    if (!Ext.isEmpty(action.params)) KS.alert.apply(KS, action.params);
                    break;
                case 'msg':
                    if (!Ext.isEmpty(action.params)) KS.msg.apply(KS, action.params);
                    break;
                case 'rpnSendNotice':
                    view.handleInternationalNoticeSaveRPN();
                    break;
                default:
                    KS.msg('Unknown report action: ' + action.cmd);
                    KS.log('Unknown report action: ' + action.cmd);
                    break;
            }
        },

        //flush
        eachTable: function (fn) {
            Ext.each(this.childViews, function (tableView) {
                if (tableView && fn && typeof (fn) == 'function') {
                    fn.call(tableView, tableView);
                }
            });
        },

        flushAllTables: function () {
            var allFlushed = true;
            this.eachTable(function (tableView) {
                if (tableView.needFlush) {
                    if (allFlushed) {
                        try {
                            tableView.flushCachedValues.apply(tableView, [true]);
                        } catch (e) {
                            KS.log('Flush table failed: ' + e);
                        }
                    }
                    allFlushed = false;
                }
            });
            if (allFlushed && (this.hasChanges || this.hasTablesChanges() || this.data.isNewTask)) {
                this.processQueuedActions();
            }
        },

        //save
        doSaveChanges: function (params) {
            var isAuto = Ext.isArray(params) && params[0] === 'auto';
            this.collectValues();
            if (!this.checkAttributes()) {
                return;
            }
            this.serverCall({
                method: 'SaveReportChanges',
                waitMessage: isAuto ? undefined : 'Сохранение ...',
                params: [this.data.reportTask, this.data.savedForm],
                success: this.saveChangesCallback,
                error: this.resetQueuedActions
            });
        },

        collectValues: function () {
            var rTask = this.data.reportTask;

            if (this.dateCmp && rTask.Period.Type === 16) {
                var date = this.dateCmp.getValue();
                if (!Ext.isEmpty(date)) {
                    rTask.Period.Year = date.getFullYear();
                    rTask.Period.Number = Ext.Date.getDayOfYear(date) + 1;
                }
            } else {
                var pCmp = this.period;
                rTask.Period.Year = pCmp.getYear();
                rTask.Period.Type = pCmp.getType();
                rTask.Period.Number = pCmp.getNumber();
            }
        },

        checkAttributes: function () {
            var view = this;
            if (!view.hasAttributes() || !view.attrGrid || !view.attrGrid.rendered)
                return true;
            var rec = view.attrGrid.store.getAt(0);
            if (!rec)
                return true;
            var cfg = view.attrGrid.getColumnModel().config,
                ok = true,
                aspType;
            Ext.each(cfg, function (col) {
                aspType = col.aspType;
                if (!Ext.isEmpty(aspType) && aspType.indexOf('code_attribute') >= 0 && Ext.isEmpty(rec.get(col.dataIndex))) {
                    ok = false;
                    KS.alert("Ключевой атрибут не может быть пустым");
                }
            });
            return ok;
        },

        hasAttributes: function () {
            return (this.attributes && this.attributes !== 'null');
        },

        saveChangesCallback: function (saveResult) {
            var view = this,
                hasErrors = (saveResult.hasOwnProperty('HAS_SAVE_ERRORS') && saveResult['HAS_SAVE_ERRORS'] !== false),
                hasFiles = (saveResult.hasOwnProperty('HAS_FILES') && saveResult['HAS_FILES'] === true);
            if (hasErrors) {
                var errCode = (saveResult['ERROR_CODE']);
                switch (errCode) {
                    case 12:
                        var confirmMessage = (saveResult['CONFIRM_MESSAGE']),
                            settings = (saveResult['REPORT_VALIDATE_SETTINGS']);
                        KS.confirm(confirmMessage, "Подтвердите действие", function (btn) {
                            if (btn === 'yes') {
                                settings.SaveWithNotSignedFiles = true;
                                view.validateSavedForm(settings);
                            }
                        });
                        break;
                }
                this.resetQueuedActions();
                return;
            }
            if (hasFiles) {
                KS.confirm('Скопировать прикрепленные файлы?',
                    "Подтвердите копирование",
                    function(btn) {
                        var copyFiles = btn === 'yes';
                        view.serverCall({
                            method: 'CopyFilesAfterSave',
                            waitMessage: 'Копирование файлов ...',
                            disableFog: !copyFiles,
                            params: [copyFiles],
                            success: function () {
                                view.discardChanges(true);
                            }
                        });
                    });
            } else {
                this.discardChanges(true);
            }

            Ext.each(this.topTabPanel.items.items, function(tab) { //В толстом настраивают visible, в вебе с visible не получилось,
                if (tab.isDisabled())                              //потому что setVisible/setHidden триггирят activateTabHandler
                    tab.setDisabled(false);
                });
        },

        getActiveTabIndex: function () {
            return this.topTabPanel.items.findIndex('id', this.topTabPanel.getActiveTab().id);
        },

        postRenderInit: function () {
            if (this.data.isNewTask)
                this.touch();

            this.processHyperLink();

            this.setValues();
            this.setDetailsEditState();
            this.updateWarnPanel();
            
            this.containerPanel.tab.setTooltip(this.data.tooltipMessage);
        },

        processHyperLink: function () {
            var view = this,
                tableLink = (view.data.reportTableCell) ? view.data.reportTableCell.TableLink || 0 : 0;
            if (tableLink > 0) {
                var ati = view.topTabPanel.items.findIndex('ctrlId', 'TABLE_' + tableLink);
                if (ati > 0) {
                    setTimeout(function () {
                        view.topTabPanel.setActiveTab(ati);
                        view.data.reportTableCell = null;
                    }, 200);
                }
            }
        },

        setDetailsEditState: function () {
            var isNew = this.data.isNewTask,
                readOnly = this.data.isDetailsReadOnly;

            this.setMainMenuAccess('SAVE', !isNew, readOnly);
            this.setMainMenuAccess('SAVE2', !isNew, readOnly || this.data.isRPN || this.data.isSur);
            this.setMainMenuAccess('REFRESH', isNew);
            this.setMainMenuAccess('CHECK_SUMS_MENU', isNew, !this.data.allowCheckKS);
            this.setMainMenuAccess('CALCULATE_RESULTS_MENU', isNew, !this.data.allowCalculateResults);
            this.setMainMenuAccess('REPORT_SVOD_CALC', isNew, !this.data.allowCalc);
            this.setMainMenuAccess('AUTOFILL', isNew, !this.data.allowAutofill);
            this.setMainMenuAccess('ANALYZE_MENU', isNew, isNew);
            this.setMainMenuAccess('SYSTEM_JOURNAL', isNew, isNew);
            this.setMainMenuAccess('EXPORT', isNew, !this.data.allowExport);

            this.setHiddenToolbarMenuItem('PRINT_MENU', 'PRINT_REPORT', !this.data.allowPrint);
            this.setHiddenToolbarMenuItem('PRINT_MENU', 'PRINT_PREVIEW', !this.data.allowPrint);

            this.setHiddenToolbarMenuItem('SETTINGS_MENU', 'CLEAR_REPORT', !this.data.allowClearReport);
            this.setHiddenToolbarMenuItem('SETTINGS_MENU', 'SEND_MAIL', !this.data.allowExport);
        },

        setMainMenuAccess: function (name, disabled, hidden) {
            var item = this.getToolbarItem(this.rootPanel, null, name);
            if (item) {
                if (Ext.isBoolean(disabled)) item.setDisabled(disabled);
                if (Ext.isBoolean(hidden)) item.setVisible(!hidden);
            }
        },

        refreshAllTables: function () {
            this.eachTable(function (tableView) {
                if (tableView.isActiveView()) {
                    try {
                        tableView.doRefreshTable();
                    } catch (e) {
                        KS.log('RefreshTable failed: ' + e);
                    }
                } else {
                    tableView.needRefresh = true;
                }
            });
        },

        //discard
        discardChanges: function (queued) {
            this.hasChanges = false;
            this.discardAllTablesChanges();
            this.trySetSavedState();
            if (queued === true)
                this.processQueuedActions();
        },

        discardAllTablesChanges: function () {
            this.eachTable(function (tableView) {
                tableView.discardChanges(false);
            });
        },

        trySetSavedState: function () {
            if (!this.hasChanges && !this.hasTablesChanges()) {
                this.setSavedState(true);
                if (!this.isHtmlForm() && !this.data.isRPN) this.getToolbarItem(this.rootPanel, null, 'SAVE').setDisabled(true);
                if (!this.isHtmlForm()) this.getToolbarItem(this.rootPanel, null, 'SAVE2').setDisabled(true);
            }
        },

        hasTablesChanges: function () {
            var r = false;
            this.eachTable(function (tableView) {
                if (tableView.hasDataChanges()) {
                    r = true;
                }
            });
            return r;
        },

        setStatusLink: function (newStatusLink) {
            if (this.getSavedStatusLink() === newStatusLink.value)
                return;
            this.serverCall({
                method: 'SetStatusLink',
                params: [newStatusLink.value, this.confirmMsg || null],
                progressOnly: true,
                success: function (result) {
                    if (result && result.confirm) {
                        this.buildConfirmWindow(result.confirm, result.confirmTitle, this.statusNoteConfirm);
                    } else {
                        this.touch();
                        
                        if (this.addNoteBtn)
                            this.addNoteBtn.setDisabled(result.denyAddNotes);
                        if (this.noteField)
                            this.noteField.setDisabled(result.denyAddNotes);

                        this.data.warnDesc = result.warnDesc;
                        this.updateWarnPanel();

                        if (!this.data.useBPMSStatus)
                            this.data.savedForm.SavedFormStatusLink = newStatusLink.value;

                        this.data.isReadOnly = result.isReadOnly;               //Для таблиц
                        this.data.isDetailsReadOnly = result.isDetailsReadOnly; //Для реквизитов, Identifier.SavedFormLink > 0
                        this.setRequisitesFieldDisable(result.isDetailsReadOnly);

                        var saveButton = this.getToolbarItem(this.rootPanel, null, 'SAVE');
                        saveButton.setVisible(true);
                        saveButton.setDisabled(false);
                    }
                }
            });
        },

        statusNoteConfirm: function () {
            this.setStatusLink(this.reportStatus.getValue());
        },

        setRequisitesFieldDisable: function(state) {
            if (!this.data.isRPN) {
                this.period.setDisabled(state);
                this.reportOrgName.setDisabled(state);
                this.reportBudget.setDisabled(state);
                if (this.hasAttributes()) {
                    this.attributes.items.each(function(attribute) {
                        attribute.setDisabled(state);
                    });
                }
//                this.getToolbarItem(this.filesGrid, null, "NEW_FILE").setHidden(state);
//                this.getToolbarItem(this.filesGrid, null, "DELETE").setHidden(state);
            }
        },

        setCustomDetails: function () {
            var view = this,
                fDesc = view.data.formInfo,
                rTask = view.data.reportTask,
                sForm = view.data.savedForm,
                dp = view.formReportAttr;

            if (dp.items.items[0] && fDesc && !view.data.isRPN) {
                view.setDetailTextFieldVauefunction('formName', '[' + fDesc['FormCode'] + '] ' + fDesc['FormName']);
                view.setDetailTextFieldVauefunction('formNotes', fDesc['FormComment']);
                view.setDetailValue('form', 'formDate', view.data.formVersion);
            }

            if (view.data.editableAttributes) {
                Ext.Object.each(view.data.editableAttributes, function (key, value) {
                    if (view[key + '_TEXT']) {
                        var textField = view[key + '_TEXT'].getComponent('textField');
                        if (textField.value !== value) {
                            textField.setOldAttrValue = true;
                            textField.setValue(value);
                        }
                    }
                });
            }

            if (dp.items.items[1] && rTask) {
                if (view.data.isRPN) {
                    view.setDetailTextFieldVauefunction('terr', rTask.OrganizationName);
                    if (fDesc && fDesc.FormName)
                        view.setDetailTextFieldVauefunction('category', fDesc.FormName);
                    var numField = view.num;
                    var oldNumber = numField.getValue() || '';
                    if (oldNumber !== view.data.reportNumber.toString())
                        view.containerPanel.setTitle('Уведомление ' + view.data.reportNumber);
                    numField.setValue(view.data.reportNumber);

                    if (view.noticeType)
                        view.noticeType.setValue(view.getNoticeFieldValue());
                } else {
                    view.setDetailTextFieldVauefunction('reportOrgName', '[' + (rTask.OrganizationCode || fDesc.ORGANIZATION_CODE) + '] ' + (rTask.OrganizationName || fDesc.ORGANIZATION_NAME));
                    view.setDetailTextFieldVauefunction('reportBudget', '[' + (rTask.BudgetCode || fDesc.BUDGET_CODE) + '] ' + (rTask.BudgetName || fDesc.BUDGET_NAME));
                    view.setDetailTextFieldVauefunction('reportVersion', sForm.Version);
                }
            }
        },

        setDetailTextFieldVauefunction: function (code, value) {
            this[code].getComponent('textField').setValue(value);
        },

        setDetailValue: function (group, code, value) {
            var item = this.findDetailItem(group, code);
            if (item) item.setValue(value);
        },

        findDetailItem: function (group, field) {
            var res = null,
                groupPanel = this.formReportAttr[group];
            if (groupPanel && groupPanel.form) {
                groupPanel.form.items.each(function (item) {
                    if (item && item.fieldCode === field)
                        res = item;
                    if (item && item.field && item.field.fieldCode === field)
                        res = item.field;
                });
            }
            return res;
        },

        setPeriod: function () {
            if (this.topTabPanel.getActiveTab() !== this.Requisites) return;
            var rTask = this.data.reportTask;
            this.initState = true;
            if (this.dateCmp && rTask.Period.Type === 16) {
                var date0 = new Date(rTask.Period.Year, 0);
                this.dateCmp.setValue(new Date(date0.setDate(rTask.Period.Number)));
            } else {
                var pCmp = this.period;
                pCmp.setType(rTask.Period.Type);
                pCmp.setYear(rTask.Period.Year);
                pCmp.setNumber(rTask.Period.Number);
            }
            this.initState = false;
        },

        setAttrValue: function (field, newValue, isClientChange) {
            if (!this.initState && (this.hasAttributes() || this.data.isRPN))
                this.data.reportTask.AttributesChanged = true;
            if (!isClientChange && this[field]) {
                this[field].getComponent('textField').setValue(newValue);
            }
        },

        setAttrValues: function (valuesDict) {
            for (var field in valuesDict) {
                if (valuesDict.hasOwnProperty(field))
                    this.setAttrValue(field, valuesDict[field]);
            }
            this.eachTable(function (tableView) {
                if (tableView.data.tableStatus)
                    tableView.refreshTableStatus();
            });
        },

        afterEditAttrValue: function(field, value, oldValue) {
            if (field.setOldAttrValue) {
                // Если было установлено предыдущее значение, то saveAttrValue вызывать не надо
                field.setOldAttrValue = false;
                return;
            }
            if (value.endsWith(',') || value.endsWith('.')) {
                // Добавляем ноль, чтобы не было установки предыдущего значения
                value += '0';
            }
            if (value !== '' && field.valueValidateMask && !new RegExp(field.valueValidateMask).test(value)) {
                field.setOldAttrValue = true;
                this.setAttrValue(field.code, oldValue, false);
                return;
            }
            this.saveAttrValue(field, value);
        },

        saveAttrValue: function (field, value) {
            this.touch();
            if (KS.isEmpty(value)) return;
            this.serverCall({
                method: 'SaveAttrValue',
                params: [field.code, value],
                disableFog: true,
                success: function (newValue) {
                    this.setAttrValue(field.code, newValue, true);
                }
            });
        },

        setAttrNumericMask: function(field){
            if (field)
                field.maskRe = new RegExp(field.inputCharMask);
        },

        resetMainTabs: function () {
            this.subTabPanel.setActiveTab(this.data.defaultTable);
            this.refreshAllTables();
        },

        resizeComments: function () {
            KS.updateLayout(this);
        },

        formPeriodChange: function () {
            this.data.reportTask.Period.Type = this.period.getType();
            this.data.reportTask.Period.Number = this.period.getNumber();
            this.touch();
        },

        subTabPanelBeforeActivateTab: function(tabPanel, newCard) {
            if (newCard.getItemId() === "filesGrid" && this.data.isNewTask) {
                KS.alert("Перед выполнением операции необходимо сохранить отчет");
                return false;
            }
            return true;
        },

        subTabPanelActivateTab: function(tabPanel, newCard){
            var tabId = newCard.getItemId();
            if (!this.isGrid(newCard)) return;
            this.serverCall({
                method: 'ReqTabActivate',
                params: [tabId],
                disableFog: true,
                success: function () {
                    if (!newCard.tabLoaded){
                        newCard.tabLoaded = true;
                        newCard.reload();
                    }
                }
            });
        },

        exit: function() {
            var view = this.parentView || this;
            view.onBeforeClose();
        },

        afterMainTabsRenderHandler: function () {
            if (this.data.isRPN && this.data.isNewTask) {
                if (!this.dateCmp)
                    this.addRpnField();

                if (this.rpnAttr && Ext.isEmpty(this.getNoticeFieldValue())){
                    this.selectNoticeTypeWindow();
                } else{
                    this.addAction({ cmd: 'save', params: ['auto'] });
                    this.addAction({ cmd: 'refresh', params: ['auto'] });
                    this.processQueuedActions();
                }                
            } else {
                var view = this;
                setTimeout(function() {
                    view.loadDefaultTable();
                }, 20);
            }
        },

        loadDefaultTable: function () {
            if (this.data.defaultTable == 0 || Ext.isEmpty(this.data.tablesDictionary) || this.data.tablesDictionary.length < this.data.defaultTable)
                return;
            var defaultTableLink = 0;
            for (var linkPair in this.data.tablesDictionary) {
                if (this.data.tablesDictionary.hasOwnProperty(linkPair)) {
                    var linkArray = linkPair.split('#');
                    if (linkArray.length === 2 && linkArray[0] == this.data.defaultTable)
                        defaultTableLink = linkArray[1];
                }
            }
            if (defaultTableLink > 0)
                this.topTabPanel.setActiveTab(this.data.defaultTable);
        },

        formNoteRendered: function(comp) {
            var view = this;
            comp.body.on('click', function(event) {
                view.formNoteLinkClick(event);
            });
        },

        formNoteLinkClick: function(e) {
            if (e.target.href && e.target.href.toLowerCase().indexOf("svod_file:") !== -1) {
                e.preventDefault();
                this.serverCall({
                    method: 'TitleLabelOnLinkClicked',
                    params: [e.target.href],
                    disableFog: true
                });
            }
        }
    });
}(SavedFormView.prototype));

// ============= TOOLBAR =======================
(function (viewClass) {
    KS.apply(viewClass, {

        getTbarClickHandler: function (tbarItem) {
            var code = tbarItem.code || '';
            switch (code) {
                case "NEW_FILE":
                    return this.saveFiles;

                case "SAVE":
                    return this.saveChanges;

                case "OPEN_FILE":
                    return this.openFile;

                case "SAVE2":
                    return this.saveChanges2;

                case "REFRESH":
                    return this.refresh;

                case "PRINT_MENU":
                case "PRINT_REPORT":
                case "PRINT_PREVIEW":
                    return this.data.allowPrint ? this.printReport :
                                                    this.data.isNewTask ? this.printReport : null;

                case "PRINT_EXCEL":
                    return this.excelExport;

                case "PRINT_TABLE":
                    return this.printTable;

                case "PRINT_USERS":
                case "PRINT_FILES":
                    return this.exportToExcel;

                case "CHECK_SUMS_MENU":
                case "CALCULATE_RESULTS_MENU":
                case "ANALYZE_MENU":
                case "IMPORT":
                case "NOTICE_EAEU_PUBLICATION":
                    return null;

                case "SHOW_CHECK_SUMS_REPORT":
                case "SHOW_CHECK_SUMS_REPORT_TABLE":
                case "SHOW_CHECK_SUMS_REPORT_RULES":
                case "CHECK_MDKS":
                case "CHECK_MDKS_RULES":
                    return this.checkKS;

                case "RESULTS":
                case "RESULTS_TABLE":
                    return this.calcResults;

                case "AUTOFILL":
                    return this.autoFill;

                case "REPORT_ANALYZE":
                case "REPORT_TABLE_ANALYZE":
                case "ROW_ANALYSIS":
                case "CELL_ANALYSIS":
                case "CELL_CALC_ANALYSE":
                case "ROUTE_SIGN_LIST":
                case "EDS_INFO":
                case "DETALIZE_IN_SMETA":
                    return this.reportAnalyze;

                case "ABOUT_MENU":
                case "ABOUT":
                    return this.doLoadReportInfo;

                case "ABOUT_TABLE":
                case "ABOUT_CELL":
                    return this.loadInfoAboutTable;

                case "DELETE_USER":
                    return this.deleteUser;

                case "DELETE_FILE":
                    return this.deleteFile;

                case "NEW":
                    return this.addUser;

                case "MARK_INVERT":
                case "MARK_INVERT2":
                    return this.invertAll;

                case "UNMARK":
                    return this.uncheckAll;

                case "MARK_ALL":
                    return this.checkAll;

                case "MARK_TOP":
                    return this.checkFromFirst;

                case "MARK_REST":
                    return this.checkToEnd;

                case "MARK_BETWEEN":
                    return this.checkBetween;

                case "REPORT_SVOD_CALC":
                    return this.smetaCalc;

                case "EDS":
                case "EDS2":
                case "EDS_INFO_FILE":
                    return this.fileEds;

                case "EDS_SIGN":
                    return this.prepareSignFile;

                case "EDS_UNSIGN":
                    return this.unsignFile;

                case "SVOD_SIMPLY":
                case "SVOD_SIMPLY2":
                case "SVOD_LAST":
                case "SVOD_LAST_WITH_COLUMNS_SELECT":
                    return this.repeatSvod;

                case "SHOW_TOTALS":
                case "SHOW_TOTALS_TABLE":
                    return this.showTotals;

                case "CLEAR_REPORT":
                    return this.clearReport;

                case "EXIT":
                    return this.exit;

                case "SYSTEM_JOURNAL":
                case "FORM_FILES":
                case "EXPORT":
                case "GET_DATA_243":
                case "SETTINGS_MENU":
                case "SETTINGS":
                case "SEND_MAIL":
                case "OPEN_REPORT_STRUCT":
                    return this.tryExecuteTask;
            }
            return SavedFormView.superclass.getTbarClickHandler.apply(this, arguments);
        },

        customToolBar: function (isTable) {
            this.setHiddenToolbarMenuItem("PRINT_MENU", "PRINT_TABLE", !isTable);
            this.setHiddenToolbarMenuItem("PRINT_MENU", "1944181331", !isTable);
            var checkSumsMenu = this.getToolbarItem(this.rootPanel, null, "CHECK_SUMS_MENU");
            if (this.data.allowCheckKS && checkSumsMenu !== null && checkSumsMenu.getHidden() !== true) {
                this.setHiddenToolbarMenuItem("CHECK_SUMS_MENU", "SHOW_CHECK_SUMS_REPORT_TABLE", !(this.data.allowCheckKS && isTable));
            }

            var calculateResultMenu = this.getToolbarItem(this.rootPanel, null, "CALCULATE_RESULTS_MENU");
            if (this.data.allowCalculateResults && calculateResultMenu !== null && calculateResultMenu.getHidden() !== true) {
                this.setHiddenToolbarMenuItem("CALCULATE_RESULTS_MENU", "RESULTS_TABLE", true); //по багу 122332, кнопка всегда скрыта
//                this.setHiddenToolbarMenuItem("CALCULATE_RESULTS_MENU", "RESULTS_TABLE", !(this.data.allowCalculateResults && isTable));
                this.setHiddenToolbarMenuItem("CALCULATE_RESULTS_MENU", "1063881942", !(this.data.allowCalculateResults && isTable));
            }

            var analyzeMenu = this.getToolbarItem(this.rootPanel, null, "ANALYZE_MENU");
            if (!this.data.isNewTask && analyzeMenu !== null && analyzeMenu.getHidden() !== true) {
                this.setHiddenToolbarMenuItem("ANALYZE_MENU", "ROW_ANALYSIS", !(!this.data.isNewTask && isTable));
                this.setHiddenToolbarMenuItem("ANALYZE_MENU", "CELL_ANALYSIS", !(!this.data.isNewTask && isTable));
                this.setHiddenToolbarMenuItem("ANALYZE_MENU", "1067307216", !(!this.data.isNewTask && isTable));
                this.setHiddenToolbarMenuItem("ANALYZE_MENU", "CELL_CALC_ANALYSE", !(!this.data.isNewTask && isTable));
                this.setHiddenToolbarMenuItem("ANALYZE_MENU", "REPORT_TABLE_ANALYZE", !(!this.data.isNewTask && isTable));
                this.setHiddenToolbarMenuItem("ANALYZE_MENU", "DETALIZE_IN_SMETA", !(!this.data.isNewTask && isTable));
                this.setHiddenToolbarMenuItem("ANALYZE_MENU", "1189780457", !(!this.data.isNewTask && isTable));
                this.setHiddenToolbarMenuItem("ANALYZE_MENU", "SHOW_TOTALS_TABLE", !(this.data.allowVirtualPrint && isTable));
                this.setHiddenToolbarMenuItem("ANALYZE_MENU", "1093374809", !(this.data.allowVirtualPrint && isTable));
            }
            this.setHiddenToolbarMenuItem("ABOUT_MENU", "ABOUT_TABLE", !(!this.data.isNewTask && isTable));
            this.setHiddenToolbarMenuItem("ABOUT_MENU", "ABOUT_CELL", !(!this.data.isNewTask && isTable));
            this.setHiddenToolbarMenuItem("ABOUT_MENU", "364008580", !(!this.data.isNewTask && isTable));
        },

        setHiddenToolbarMenuItem: function (parenItemCode, menuItemCode, value) {
            var parentItem = this.getToolbarItem(this.rootPanel, null, parenItemCode);
            if (parentItem == null) return null;
            var menuItem = null;
            Ext.each(parentItem.menu.items.items, function (child) {
                if (child.tbarNode.code === menuItemCode) {
                    menuItem = child;
                }
            });
            if (!Ext.isEmpty(menuItem)) {
                menuItem.setHidden(value);
            }
            return menuItem;
        },

        refresh: function (params) {
            var view = this.parentView || this;
            if (!view.hasChanges && !view.hasTablesChanges()) {
                view.doRefresh(params);
                return;
            }
            KS.confirm("Обновить " + KS.locale.ReportTitle.toLowerCase() + "? Несохраненные данные будут утеряны...", "Подтвердите обновление", function (btn) {
                if (btn === 'yes') {
                    view.doRefresh(params);
                }
            });
        },

        doRefresh: function (params) {
            var isAuto = Ext.isArray(params) && params[0] === 'auto';
            this.needRefreshList = this.data.isNewTask && !isAuto;
            this.serverCall({
                method: 'RefreshAndGetSettings',
                waitMessage: isAuto ? undefined : 'Обновление ' + ((this.needRefreshList) ? 'формы' : 'реквизитов') + '...',
                success: this.refreshCallback
            });
        },

        refreshCallback: function (data) {
            if (Ext.isEmpty(data)) return;
            this.data = data;

            if (this.needRefreshList === true) {
                var view = this;
                KS.confirm("Обновить список отчетов?", "Подтвердите обновление", function (btn) {
                    if (btn === 'yes') {
                        view.activateTaskList();
                        view.refreshTaskList();
                        view.needRefreshList = false;
                    }
                });
            }

            this.postRenderInit();

            this.refreshAllTables();

            this.subTabPanel.setActiveTab(0);
            if (!this.data.isRPN) {
                this.usersGrid.tabLoaded = false;
                this.lockGrid.tabLoaded = false;
            }
            this.filesGrid.tabLoaded = false;

            this.filesGrid.gridLoaded = false;
            if (!this.data.isRPN)
                this.usersGrid.gridLoaded = false;
            this.discardChanges(this.getActiveTabIndex() === 0);
            
            if (this.data.isRPN && this.rpnAttr &&
                Ext.isEmpty(this.getNoticeFieldValue())){
                this.selectNoticeTypeWindow();
                this.touch();
            }
        },

        printReport: function () {
            var view = this.parentView || this;
            if (!view.data.allowPrint) return;
            view.resetQueuedActions();
            var isPreview = this.tbarNode.code === "PRINT_PREVIEW";
            var saveMsg = isPreview ? 'Сохранить перед предварительным просмотром?' : 'Сохранить перед печатью?';
            if (view.hasChanges || view.hasTablesChanges()) {
                var changesWin = Ext.MessageBox.show({
                    icon: Ext.MessageBox.QUESTION,
                    title: 'Сохранить изменения?',
                    msg: 'Отчёт содержит несохраненные изменения. <br />' + saveMsg,
                    buttons: Ext.MessageBox.YESNO,
                    fn: function(btn) {
                        switch (btn) {
                            case 'yes':
                                view.addAction({ cmd: 'save' });
                                view.addAction({ cmd: 'refresh' });
                                break;
                            case 'no':
                                view.doRefresh();
                                break;
                        }
                        if (isPreview) {
                            view.addAction({ cmd: 'printPreview' });
                        } else {
                            view.addAction({ cmd: 'print' });
                        }
                        view.processQueuedActions();
                    }
                });
            } else {
                if (isPreview) {
                    view.addAction({ cmd: 'printPreview' });
                } else {
                    view.addAction({ cmd: 'print' });
                }
                view.processQueuedActions();
            }
        },

        doPrintReport: function (isPreview) {
            var view = this;
            view.serverCall({
                method: 'OnPrint',
                params: [isPreview],
                waitMessage: 'Получение параметров печати ...',
                async: true
            });
        },

        excelExport: function () {
            var view = this.parentView || this;
            var onlyOneTable = view.topTabPanel.items.length === 2;
            if (onlyOneTable && view.childViews[1]) {
                view.childViews[1].printTable();
            } else {
                var fileLink = KS.getFakeLink();
                view.serverCall({
                    method: 'DoExcelExport',
                    waitMessage: 'Выгрузка таблиц ...',
                    params: [fileLink],
                    timeout: 50000, // 50s
                    delay: function() {
                        view.checkExportResult(fileLink)
                    },
                    success: view.openUrl
                });
            }
        },

        checkExportResult: function(fileLink) {
            var view = this;
            view.containerPanel.unmask();
            view.containerPanel.mask(this.getWaitExportMsg());
            view.serverCall({
                method: 'GetExportResult',
                params: [fileLink],
                disableFog: true,
                success: function(result) {
                    view.checkResultCallback(result, fileLink)
                }
            });
        },

        checkResultCallback: function(result, fileLink) {
            if (!Ext.isEmpty(result)) {
                this.containerPanel.unmask();
                this.openUrl(result);
            } else {
                var view = this;
                view.exportProgressTimerId = setTimeout(function () {
                    view.checkExportResult(fileLink);
                }, 5000);
            }
        },

        getWaitExportMsg: function() {
            if (!this.waitExportMsg) {
                this.waitExportMsg = 'Формирование файла выгрузки отчета .';
            } else {
                var index = this.waitExportMsg.indexOf('....');
                if (index !== -1)
                    this.waitExportMsg = this.waitExportMsg.substring(0, index + 1);
                else
                    this.waitExportMsg += '.';
            }
            return this.waitExportMsg;
        },

        stopExportProgressTimer: function() {
            if (this.exportProgressTimerId)
                clearInterval(this.exportProgressTimerId);
        },

        printTable: function() {
            var view = this.parentView || this;
            var atv = view.getActiveTableView();
            if (atv) atv.printTable();
        },

        repeatSvod: function() {
            var view = this.parentView;
            var operation = this.tbarNode.code;
            view.resetQueuedActions();
            if (view.hasChanges || view.hasTablesChanges()) {
                view.addAction({ cmd: 'flush' });
                view.addAction({ cmd: 'save' });
            }
            view.addAction({ cmd: 'repeatSvod', params: [operation] });
            view.processQueuedActions();
        },

        doRepeatSvod: function(operation) {
            var view = this,
                operationCode = operation[0],
                message = "";
            switch(operationCode) {
                case "SVOD_SIMPLY":
                case "SVOD_SIMPLY2":
                    message = "Выполнить перерасчет свода?";
                    break;
                case "SVOD_LAST":
                    message = "Повторить последний свод?";
                    break;
                case "SVOD_LAST_WITH_COLUMNS_SELECT":
                    view.serverCall({
                        method: 'GetSvodLastColumnTree',
                        success: view.buildSvodLastWithColumn
                    });
                    break;
            }
            if (!Ext.isEmpty(message) && view.data.savedForm.IsSvod === true) {
                KS.confirm(message, "Подтвердите действие", function (btn) {
                    if (btn !== 'yes') return;
                    view.serverCall({
                        method: 'RepeatSvod',
                        params: [operationCode]
                    });
                });
            }
        },

        buildSvodLastWithColumn: function(nodes) {
            var view = this,
                operationCode = "SVOD_LAST_WITH_COLUMNS_SELECT";

            for (var nodeIndex in nodes) {
                if (nodes.hasOwnProperty(nodeIndex)){
                    var childrens = nodes[nodeIndex].children;
                    for (var childrenNode in childrens) {
                        if (childrens.hasOwnProperty(childrenNode)) {
                            childrens[childrenNode].checked = false;
                        }
                    }
                }
            }
            var store = Ext.create('Ext.data.TreeStore',
                { root: {
                    expanded: true,
                    children: nodes
                 }
                });

            var treePanel = {
                xtype: "treepanel",
                id: "treeSvodLastColumn",
                store: store,
                rootVisible: false
            };

            var modalTreeSvodLast = KS.showModal( treePanel, {
                modal: false,
                title: 'Выберите значения...',
                width: 400,
                id: "modalTreeSvodLast",
                heigth: 600,
                tbar: [{
                        xtype: 'button',
                        tooltip: "Инверсия",
                        iconCls: "ks-icon-galka",
                        handler: function() {
                            var tree = Ext.getCmp("treeSvodLastColumn");
                            setCheckedRecursive(tree.getRootNode());
                        }
                    },{
                        xtype: 'button',
                        tooltip: "Отметить подчиненные",
                        iconCls: "ks-icon-child_mark",
                        handler: function() {
                            var tree = Ext.getCmp("treeSvodLastColumn");
                            var sn = tree.selection;
                            if (!sn) return;
                            Ext.each(sn.childNodes, function (subNode) {
                                setChecked(subNode, true);
                            });
                        }
                    },{
                        xtype: 'button',
                        tooltip: "Разметить все",
                        iconCls: "ks-icon-unmark",
                        handler: function() {
                            var tree = Ext.getCmp("treeSvodLastColumn");
                            setCheckedRecursive(tree.getRootNode(), false);
                        }
                    },{
                        xtype: 'button',
                        tooltip: "Свернуть",
                        iconCls: "ks-icon-treecollapse",
                        handler: function() {
                            Ext.getCmp("treeSvodLastColumn").collapseAll();
                        }
                    },{
                        xtype: 'button',
                        tooltip: "Развернуть",
                        iconCls: "ks-icon-treeexpand",
                        handler: function() {
                            Ext.getCmp("treeSvodLastColumn").expandAll();
                        }
                    }],
                bbar: ['->',
                    {
                        text: 'ОК',
                        cls: 'marked-button',
                        handler:
                            function () {
                                var selectedNode = [];
                                treePanel.store.data.each(function(item) {
                                    if (item.data.checked === true) {
                                        selectedNode.push(item.data.id);
                                    }
                                });
                                view.serverCall({
                                    method: 'RepeatSvodWithColumn',
                                    params: [operationCode,selectedNode]
                                });
                                modalTreeSvodLast.close(true);
                            }
                    },
                    {
                        text: 'Отмена',
                        cls: 'dim-button',
                        handler: function () {
                            modalTreeSvodLast.close(true);
                        }
                    }]
            });
        },

        checkKS: function () {
            var view = this.parentView;
            var operation = this.tbarNode.code;
            if (view.hasChanges || view.hasTablesChanges()) {
                KS.confirm("Сохранить изменения?", "Внимание", function(btn) {
                    if (btn !== 'yes') return;
                    view.resetQueuedActions();
                    view.addAction({ cmd: 'flush' });
                    view.addAction({ cmd: 'save' });
                    if (view.data.settings.AutoReload) // undefined
                        view.addAction({ cmd: 'refresh' });
                    view.addAction({ cmd: 'checkKS', params: [operation] });
                    view.processQueuedActions();
                });
            } else {
                view.resetQueuedActions();
                view.addAction({ cmd: 'checkKS', params: [operation] });
                view.processQueuedActions();
            }
        },

        docheckKS: function (operation) {
            var view = this;
            var tableLink = null;
            if (operation[0] === "SHOW_CHECK_SUMS_REPORT_TABLE")
                tableLink = this.getActiveTableView().data.identifier.TableLink;
            view.serverCall({
                method: 'DoCheckKS',
                waitMessage: 'Проверка КС...',
                params: [operation[0], tableLink],
                success: view.processQueuedActions,
                error: view.resetQueuedActions
            });
        },

        calcResults: function () {
            var view = this.parentView;
            var isTable = this.tbarNode.code === "RESULTS_TABLE";
            var msg = (view.hasChanges || view.hasTablesChanges()) ? "Сохранить изменения и расчитать итоги?" : "Рассчитать итоги?";
            KS.confirm(msg, "Подтвердите действие", function (btn) {
                if (btn !== 'yes') return;
                view.resetQueuedActions();
                if (view.hasChanges || view.hasTablesChanges()) {
                    view.addAction({ cmd: 'flush' });
                    view.addAction({ cmd: 'save' });
                }
                if (isTable) {
                    view.addAction({ cmd: 'calcTable' });
                } else {
                    view.addAction({ cmd: 'calc' });
                }
                view.addAction({ cmd: 'refresh' });
                view.addAction({ cmd: 'alert', params: ['Расчет итогов успешно выполнен'] });
                view.processQueuedActions();
            });
        },

        doCalcResults: function (isTable) {
            var view = this;
            var tableLink = isTable ? this.getActiveTableView().data.identifier.TableLink : null;
            this.eachTable(function (tableView) { 
                if (tableView.data.showGroupTree)
                {
                    tableView.baseTree.touchedNonSavedData = true; // При расчёте итого могут заполнится и другие узлы, их нужно тоже выделить жирным
                }
            });
            view.serverCall({
                method: 'DoCalculateResults',
                params: [isTable, tableLink],
                waitMessage: 'Расчет итогов...',
                cancellable: true,
                success: function (ok) {
                    if (ok) {
                        view.processQueuedActions();
                    } else {
                        view.resetQueuedActions();
                    }
                },
                error: view.resetQueuedActions
            });
        },

        autoFill: function () {
            var view = this.parentView;
            KS.confirm("Выполнить автозаполнение?", "Подтвердите действие", function (btn) {
                if (btn !== 'yes') return;
                view.resetMainTabs();
                view.serverCall({
                    method: 'OnAutoFill',
                    waitMessage: 'Получение списка правил ...',
                    success: view.resetQueuedActions
                });
            });
        },

        rowAnalyze: function () {
            var atv = this.parentView.getActiveTableView();
            if (atv) atv.rowAnalyze();
        },

        cellAnalyze: function () {
            var atv = this.parentView.getActiveTableView();
            if (atv) atv.cellAnalyze();
        },

        smetaDetalize: function () {
            var atv = this.parentView.getActiveTableView();
            if (atv) atv.smetaDetalize();
        },

        cellTotalsAnalyze: function () {
            var atv = this.parentView.getActiveTableView();
            if (atv) atv.cellTotalsAnalyze();
        },

        reportAnalyze: function () {
            var view = this.parentView;
            var tableView = view.getActiveTableView(),
                tableLink = null,
                columnKey = null,
                linkSavedRow = null;

            var operation = this.tbarNode.code;
            if (!Ext.isEmpty(tableView)) {
                tableLink = tableView.data.identifier.TableLink;
                if (!Ext.isEmpty(tableView.mainGrid.getSelectionModel().selected) &&
                    !Ext.isEmpty(tableView.mainGrid.getSelectionModel().selected.endCell)) {
                    var cell = tableView.mainGrid.getSelectionModel().selected.endCell;
                    var rec = cell.record;
                    linkSavedRow = tableView.mainGrid.getAnyCase(rec, 'LINK_SAVED_ROW');
                    columnKey = cell.column.dataIndex;
                }

                tableView.flushCachedValues();
            }

            var entity = "main";
            var analyzeParams = {
                tableLink: tableLink,
                linkSavedRow: linkSavedRow,
                columnKey: columnKey
            }

            view.serverCall({
                method: 'ReportTryExecuteTask',
                params: [entity, operation, analyzeParams, null],
                waitMessage: 'Выполняется контроль ...'
            });
        },

        reportTableAnalyze: function () {
            var atv = this.parentView.getActiveTableView();
            if (atv) atv.reportAnalyze();
        },

        smetaCalc: function () {
            var view = this.parentView;
            KS.confirm("Выполнить импорт отчетных данных?</br>Все существующие данные будут удалены.", "Подтвердите действие", function (btn) {
                if (btn !== 'yes') return;
                view.resetMainTabs();
                view.serverCall({
                    method: 'SmetaCalc',
                    cancellable: true,
                    success: view.refresh
                });
            });
        },

        showTotals: function() {
            var view = this.parentView || this;
            var operation = this.tbarNode.code;
            if (view.hasChanges || view.hasTablesChanges()) {
                KS.confirm("Сохранить изменения?", "Внимание", function(btn) {
                        if (btn === 'yes') {
                            view.saveChanges();
                        }
                    });
            } else {
                view.serverCall({
                    method: 'ShowTotals',
                    params: [false, operation]
                });
            }
        },

        clearReport: function(){
            var view = this.parentView || this;
            KS.confirm("Все данные будут удалены. Продолжить?", "Внимание", function(btn) {
                if (btn === 'yes') {
                    view.serverCall({
                        method: 'ClearReport',
                        waitMessage: "Очистка отчета...",
                        success: function(){
                            view.refresh();
                        }
                    });
                }
            });
        },

        tryExecuteTask: function() {
            var view = this.parentView || this;
            var operation = this.tbarNode.code;
            view.serverCall({
                method: 'ReportTryExecuteTask',
                params: ["main", operation, null, null]
            });
        },

        handleInternationalNoticeSaveRPN: function () {
            var view = this;

            if (view.reportStatus.value !== 50) // Документ
            {
                view.switchNoticePublicationButtonsAll(true);
                view.processQueuedActions();
                return;
            }

            view.switchNoticePublicationButtons(view.data.isRequestedToPublishRPN);

            if (!view.data.isRequestedToPublishRPN) {
                view.processQueuedActions();
                return;
            }

            view.sendNoticeToEec(true);
        },

        publishNoticeInEec: function () {
            var view = this.parentView || this;
            view.sendNoticeToEec(true);
        },

        excludeNoticeFromEec: function () {
            var view = this.parentView || this;
            view.sendNoticeToEec(false);
        },

        sendNoticeToEec: function (isPublication) {
            var view = this;

            if (view.hasChanges || view.hasTablesChanges()) {
                KS.warning('Сначала необходимо сохранить изменения!');
                return;
            }

            view.serverCall({
                method: 'SendNoticeToEec',
                params: [isPublication],
                success: function () {
                    view.switchNoticePublicationButtons(isPublication);
                    if (isPublication) {
                        view.data.isRequestedToPublishRPN = true;
                        KS.alert('Уведомление №' + view.data.reportNumber + ' успешно направлено');
                    }
                    else {
                        KS.alert('Успешно направлено исключение уведомления №' + view.data.reportNumber);
                    }
                    view.processQueuedActions();
                }
            });
        },

        switchNoticePublicationButtons: function (isPublication) {
            var view = this;
            var parentButton = view.getToolbarItem(view.rootPanel, null, 'NOTICE_EAEU_PUBLICATION');

            parentButton.setDisabled(false);

            if (isPublication){
                view.getButtonMenuToolbarItem(parentButton, "PUBLISH_NOTICE_IN_EEC").setDisabled(isPublication);
                view.getButtonMenuToolbarItem(parentButton, "EXCLUDE_NOTICE_FROM_EEC").setDisabled(!isPublication);
            }
            else {
                if (!view.data.isRequestedToPublishRPN) {
                    view.getButtonMenuToolbarItem(parentButton, "PUBLISH_NOTICE_IN_EEC").setDisabled(isPublication);
                }
                view.getButtonMenuToolbarItem(parentButton, "EXCLUDE_NOTICE_FROM_EEC").setDisabled(!isPublication);
            }
        },

        switchNoticePublicationButtonsAll: function (disable) {
            var view = this;
            var parentButton = view.getToolbarItem(view.rootPanel, null, 'NOTICE_EAEU_PUBLICATION');

            parentButton.setDisabled(disable);
            view.getButtonMenuToolbarItem(parentButton, "PUBLISH_NOTICE_IN_EEC").setDisabled(disable);
            view.getButtonMenuToolbarItem(parentButton, "EXCLUDE_NOTICE_FROM_EEC").setDisabled(disable);
        },

        showPublicationConsentWindow: function () {
            var view = this.parentView;
            view.serverCall({
                method: 'GetPublicationConsentSendPanel',
                success: function (panel) {
                    view.publicationPanel = view.createTemplateControl(panel, 'publicationPanel');
                    view.addPanelItems(panel, view.publicationPanel);
                    view.publicationPanel.items.items[2].items.items[0].items.items[0].saveFiles = view.savePublicationConsentFile;
                    view.publicationModal = KS.showModal(view.publicationPanel, {
                        title: 'Одобрение публикации сведений',
                        autoHeight: true,
                        layout: 'anchor',
                        width: 600,
                        buttonAlign: 'left',
                        buttons: ['->', {
                            text: 'Отправить',
                            cls: 'dim-button',
                            handler: function () {
                                view.sendPublicationConsent(view);
                            }
                        }, { xtype: 'tbspacer', width: 8 },
                        {
                            text: 'Отмена',
                            cls: 'dim-button',
                            handler: function () {
                                view.publicationModal.close();
                            }
                        }]
                    }, true);
                }
            })
        },

        sendPublicationConsent: function (view) {
            var publicationConsent = Ext.getCmp('publicationConsent').value,
                resultText = Ext.getCmp('resultText').value,
                fileKey = view.data.publicationConsentFileKey !== undefined ? view.data.publicationConsentFileKey : null;
            view.serverCall({
                method: 'SendPublicationConsent',
                params: [publicationConsent, resultText, fileKey],
                success: function () {
                    view.publicationModal.close();
                    KS.alert('Согласие на публикацию уведомления успешно направлено!');
                }
            });
        },

        savePublicationConsentFile: function (fileKeys, smth, filefield) {
            var view = this;
            view.data.publicationConsentFileKey = fileKeys[0];
            filefield.setRawValue(fileKeys[0].fileName + fileKeys[0].fileExtension);
            //view.saveFiles(fileKeys, smth, filefield);
        },

        getButtonMenuToolbarItem: function (parentButton, itemCode) {
            return parentButton.getMenu().items.findBy(function (item) {
                return (item && item.tbarNode && (item.tbarNode.code === itemCode));
            });
        }
    });
}(SavedFormView.prototype));

// ============= WARNING PANEL =======================
(function (viewClass) {
    KS.apply(viewClass, {
        updateWarnPanel: function () {
            var hasWarn = this.data.warnDesc && !KS.isEmpty(this.data.warnDesc.text),
                warnPanel = this.getToolbar(this.topTabPanel);
            warnPanel.setHidden(!hasWarn);
            if (hasWarn) {
                switch(this.data.warnDesc.level) {
                    case 1:
                        warnPanel.setStyle({
                            backgroundColor: '#FFED86',
                            color: '#FF0000',
                            backgroundImage: 'none'
                        });
                        break;
                }

                this.getToolbarItem(this.topTabPanel, null, 'warningText').setText(this.data.warnDesc.text);
            }
        },

        closeWarnPanel: function () {
            var view = this.parentView || this;
            view.getToolbar(view.topTabPanel).setHidden(true);
        }
    });
}(SavedFormView.prototype));

// ============= INVERSION =======================
(function (viewClass) {
    KS.apply(viewClass, {
        invertAll: function () {
            var me = this.parentView.subTabPanel.activeTab;
            me.store.each(function (rec) { me.checkRecord(rec, !rec.get('CHECKED')); });
            me.getSelectionModel().doMultiSelect(me.checkList, false, true);
        },

        checkRecord: function (rec, v) {
            var me = this,
                checkList = me.checkList,
                i = KS.Array.recordIndexOf(checkList, rec, 'id'),
                exsists = i !== -1;

            if (v) {
                !exsists && checkList.push(rec);
            } else {
                exsists && checkList.splice(i, 1);
            }

            rec.set('CHECKED', v);

            return checkList;
        },

        checkAll: function () {
            this.parentView.subTabPanel.activeTab.uncheckAll(true);
        },

        uncheckAll: function (cond) {
            var me = this.parentView.subTabPanel.activeTab;
            cond = false;
            me.store.each(function (rec) { me.checkRecord(rec, !!cond); });
            me.getSelectionModel().doMultiSelect(me.checkList, false, true);
        },

        checkFromFirst: function () {
            var grid = this.parentView.subTabPanel.activeTab,
                sel = grid.getSelectionModel().getSelection();

            if (sel.length) {
                grid.store.each(function (rec) {
                    if (!sel.length) return false;
                    grid.checkRecord(rec, true);
                    KS.Array.remove(sel, rec);
                    return true;
                });
            } else {
                grid.checkAll();
            }

            grid.getSelectionModel().doMultiSelect(grid.checkList, false, true);
        },

        checkToEnd: function () {
            var grid = this.parentView.subTabPanel.activeTab,
                sel = grid.getSelectionModel().getSelection(),
                recs = grid.store.getRange();

            if (sel.length) {
                Ext.each(recs,
                    function (rec) {
                        if (!sel.length) return false;
                        grid.checkRecord(rec, true);
                        KS.Array.remove(sel, rec);
                        return true;
                    },
                    grid,
                    true);
            } else {
                grid.checkAll();
            }

            grid.getSelectionModel().doMultiSelect(grid.checkList, false, true);
        },

        checkBetween: function () {
            var grid = this.parentView.subTabPanel.activeTab,
                store = grid.getStore(),
                frst = false,
                last = false;

            store.each(function (rec) {
                if (rec.get('CHECKED')) {
                    if (!frst) frst = rec;
                    last = rec;
                }
            });

            if (frst) {
                var start = store.indexOf(frst),
                    end = store.indexOf(last);

                Ext.each(store.getRange(start, end), function (rec) { grid.checkRecord(rec, true); });
            }

            grid.getSelectionModel().doMultiSelect(grid.checkList, false, true);
        }
    });
}(SavedFormView.prototype));

// ============= REPORT INFO =======================
(function (viewClass) {
    KS.apply(viewClass, {
        doLoadReportInfo: function () {
            var view = this.parentView || this;
            view.serverCall({
                method: 'DoLoadReportInfo',
                waitMessage: 'Чтение ...'
            });
        },

        loadInfoAboutTable: function() {
            var isCell = this.tbarNode.code === "ABOUT_CELL",
                view = this.parentView,
                tableView = view.getActiveTableView(),
                tableLink = tableView.data.identifier.TableLink,
                columnKey = null,
                linkSavedRow = null,
                selected = tableView.mainGrid.getSelectionModel().getSelected();

            if (isCell && !Ext.isEmpty(selected)) {
                var cell = selected.endCell;
                var rec = cell.record;
                linkSavedRow = tableView.mainGrid.getAnyCase(rec, 'LINK_SAVED_ROW');
                columnKey = cell.column.dataIndex;
            }

            tableView.flushCachedValues();

            view.serverCall({
                method: 'LoadInfoAboutTable',
                params: [isCell, tableLink, linkSavedRow, columnKey]
            });
        },

        loadFormFiles: function () {
            this.serverCall({
                method: 'DoLoadFormFiles'
            });
        }
    });
}(SavedFormView.prototype));

// ============= FILES =======================
(function (viewClass) {
    KS.apply(viewClass, {
        saveFiles: function (fileKeys) {
            var view = this.parentView || this;
            if (view.checkValidFileExt(fileKeys[0].fileName, fileKeys[0].fileExtension)) {
                view.serverCall({
                    method: 'DoSaveFiles',
                    params: [fileKeys, this.requiredFileNote || ""],
                    waitMessage: 'Сохранение файлов...',
                    success: view.saveFilesCallback
                });
            }
        },

        checkValidFileExt: function (fileName, fileExtension) {
            var s = this.data.settings,
                maxLen = s.MaxFileNameLength,
                invalidExts = s.BadExtensions,
                validExts = KS.isEmpty(s.FileExtensions) ? [] : s.FileExtensions.split(", ");
            if (!KS.isEmpty(validExts) && validExts.indexOf(fileExtension) < 0) {
                KS.alert("Тип файла " + fileExtension + " не разрешен для прикрепления");
                return false;
            }
            if (!KS.isEmpty(invalidExts) && invalidExts.indexOf(fileExtension) >= 0) {
                KS.alert("Тип файла " + fileExtension + " запрещен для прикрепления");
                return false;
            }
            if (this.data.isRPN){
                if (!KS.isEmpty(this.downloadFileFormat) &&
                    this.downloadFileFormat.toUpperCase().indexOf(fileExtension.toUpperCase()) < 0) {
                    KS.alert("Тип файла " + fileExt + " не разрешен для прикрепления.\n" +
                        "В качестве выбранного документа можно прикрепить только файлы следующих форматов: " + this.downloadFileFormat.replace(/,/g, ', '));
                    this.downloadFileFormat = "";
                    return false;
                }
                if (this.rpnAttr && Ext.isEmpty(this.getNoticeFieldValue())){
                    KS.alert("Необходимо выбрать тип уведомления");
                    return false;
                }
            }
            if (maxLen > 0 && fileName.length > maxLen) {
                KS.alert("Длина имени файла не должна превышать " + maxLen + " символов");
                return false;
            }
            return true;
        },

        saveFilesCallback: function (links) {
            this.requiredFileNote = null;
            if (this.data.settings.SignReportFiles && !Ext.isEmpty(links)) {
                this.fileSign(links);
            } else {
                this.reloadFilesList();
            }
        },

        openFile: function () {
            var view = this.parentView,
                links = this.parentView.getCheckedFileRows('LINK_FILE');
            if (Ext.isEmpty(links))
                return;
            view.serverCall({
                method: 'OpenFiles',
                params: [links]
            });
        },

        getCheckedFileRows: function (field) {
            var recs = this.filesGrid.checkList;
            if (Ext.isString(field) && !Ext.isEmpty(field)) {
                var fields = [];
                Ext.each(recs, function (r) {
                    fields.push(KS.Grid.getAnyCase(r, field));
                });
                return fields;
            }
            return recs;
        },

        reloadFilesList: function () {
            var view = this.parentView || this;
            view.serverCall({
                method: 'ReloadFilesList',
                success: function() {
                    this.filesGrid.reload();
                }
            });
        },

        deleteFile: function () {
            var view = this.parentView,
                links = this.parentView.getCheckedFileRows('LINK_FILE');
            if (Ext.isEmpty(links)) return;
            if (view.getSignedFilesCount() > 0) {
                KS.warning('Удаление подписанных файлов запрещено');
                return;
            }
            KS.confirm("Удалить выделенные строки?", "Подтвердите удаление", function (btn) {
                if (btn === 'yes') {
                    view.serverCall({
                        method: 'DeleteFiles',
                        params: [links],
                        success: view.reloadFilesList
                    });
                }
            });
        },

        getSignedFilesCount: function () {
            var signLinks = this.getCheckedFileRows('link_sign'),
                signedCount = 0;
            Ext.each(signLinks, function (signLink) {
                if (signLink > 0) {
                    signedCount++;
                }
            });
            return signedCount;
        },

        beforeeditFilesGrid: function(e, context){
            var view = this;
            var dataIndex = context.column.dataIndex;
            if (view.data.isRPN){
                // Для колонки Комментарий в уведомлениях разрешаем редактирование если это не обязательные файлы
                // или если стоит галочка "Документ отсутствует"
                if (dataIndex == "COMMENT" &&
                    KS.Grid.getAnyCase(context.record, 'IS_REQUIRED') &&
                    !KS.Grid.getAnyCase(context.record, 'IS_NOT_EXIST')){
                    return false;
                }
                // Для колонки Документ в уведомлениях разрешаем редактирование если это не обязательные файлы
                if (dataIndex == "NOTE" &&
                    KS.Grid.getAnyCase(context.record, 'IS_REQUIRED')){
                    return false;
                }
            }
            return true;
        },

        editFilesGrid: function (e, context) {
            if (context.value === context.originalValue) return false;
            var view = this;
            var linkFile = KS.Grid.getAnyCase(context.record, 'LINK_FILE');
            var dataIndex = context.column.dataIndex;
            var changedFields = {};

            changedFields[context.field] = context.value;
            // Если файл добавлен или это не обязательный файл, то нельзя изменить "Документ не требуется" и "Документ отсутствует"
            if (view.data.isRPN) {
                if ((dataIndex == "NO_DOCUMENT_REQUIRED" || dataIndex == "IS_NOT_EXIST")  &&
                    !Ext.isEmpty(KS.Grid.getAnyCase(context.record, 'FULL_NAME')) || !KS.Grid.getAnyCase(context.record, 'IS_REQUIRED')) {
                    context.record.set("NO_DOCUMENT_REQUIRED", false);
                    context.record.set("IS_NOT_EXIST", false);
                    return;
                }
                if (dataIndex == "NO_DOCUMENT_REQUIRED" && context.value) {
                    context.record.set("IS_NOT_EXIST", false);
                    changedFields["IS_NOT_EXIST"] = false;
                }
                if (dataIndex == "IS_NOT_EXIST" && context.value) {
                    context.record.set("NO_DOCUMENT_REQUIRED", false);
                    changedFields["NO_DOCUMENT_REQUIRED"] = false;
                }
            }

            var isRpnNote = view.data.isRPN && dataIndex === "NOTE";
            view.serverCall({
                method: 'ChangeFileCell',
                params: [linkFile, changedFields],
                disableFog: !isRpnNote,
                success: function() {
                    if (isRpnNote){
                        view.reloadFilesList();
                    }
                    view.touch();
                }
            });
            return true;
        },

        fileEds: function (callback) {
            var view = this.parentView || this,
                filesLinks = view.getCheckedFileRows('LINK_FILE');
            if (KS.isEmpty(filesLinks)) return;
            view.serverCall({
                method: 'FileEds',
                params: [filesLinks, this.tbarNode.code],
                success: callback
            });
        },

        filesGridDblClick: function(gridView, record, element, rowIndex, e){
            var dataIndex = e.position.column.dataIndex;
            if (this.data.isRPN && dataIndex !== 'NOTE' && dataIndex !== 'COMMENT') {
                this.loadDocumentFile(record);
            }
        },

        loadDocumentFile: function (record) {
            if (KS.Grid.getAnyCase(record, 'IS_REQUIRED')) {
                var selectFileBtn = Ext.getCmp('selectFileBtn');
                if (selectFileBtn &&
                    selectFileBtn.fileInputEl &&
                    selectFileBtn.fileInputEl.dom) {
                    var fileBtnDom = selectFileBtn.fileInputEl.dom;
                    this.requiredFileNote = KS.Grid.getAnyCase(record, 'NOTE');
                    // Запоминаем изначальные настройки
                    var oldFormatAccept = fileBtnDom.accept;
                    var oldMultiple = fileBtnDom.multiple;
                    // временно настраиваем формат загружаемых файлов и возможность загрузки только 1 файла
                    this.downloadFileFormat = KS.Grid.getAnyCase(record, 'FILE_FORMAT');
                    if (!Ext.isEmpty(this.downloadFileFormat)) {
                        fileBtnDom.accept = this.downloadFileFormat;
                    }
                    fileBtnDom.multiple = false;
                    // открываем окно выбора файла
                    fileBtnDom.click();
                    // возвращаем всё обратно
                    fileBtnDom.accept = oldFormatAccept;
                    fileBtnDom.multiple = oldMultiple;
                }
            }
        },

        prepareSignFile: function() {
            var view = this.parentView;
            view.fileEds.call(this, view.signFile);
        },

        signFile: function() {
            var view = this.parentView || this,
                filesLinks = view.getCheckedFileRows('LINK_FILE');
            KS.XCrypt.viewContext = view;
            view.signDataSelector(filesLinks, view.trySignFiles);
        },

        trySignFiles: function (links) {
            this.serverCall({
                method: 'OnGroupOperation',
                params: ['SIGN_FILES', links, null],
                waitMessage: 'Чтение данных ...',
                success: this.afterTrySign
            });
        },

        afterSignData: function () {
            this.reloadFilesList();
        },

        unsignFile: function() {
            var view = this.parentView || this,
                code = this.tbarNode.code;
            KS.confirm("Вы действительно хотите снять подпись?",
                "Подтвердите действие",
                function(btn) {
                    if (btn === 'yes') {
                        var filesLinks = view.getCheckedFileRows('LINK_FILE');
                        view.serverCall({
                            method: 'FileEds',
                            params: [filesLinks, code],
                            success: view.reloadFilesList
                        });
                    }
                });
        }
    });
}(SavedFormView.prototype));

// ============= USERS =======================
(function (viewClass) {
    KS.apply(viewClass, {
        editUsersGrid: function (e, context) {
            var view = this,
                userLink = context.grid.getAnyCase(context.record, 'LINK_USER');
            view.serverCall({
                method: 'ChangeUser',
                params: [userLink, context.field, context.value],
                disableFog: true,
                success: view.touch
            });
        },

        addUser: function () {
            this.parentView.serverCall({
                method: 'AddUser',
                waitMessage: 'Открытие справочника ...'
            });
            this.parentView.data.reportTask.TaskUsersChanged = true;
        },

        deleteUser: function () {
            var view = this.parentView,
                recs2Del = [],
                userLinks = [],
                store = view.usersGrid.store;
            store.each(function (rec) {
                if (KS.Grid.getAnyCase(rec, "CHECKED") && KS.Grid.getAnyCase(rec, "LINK_USER")) {
                    recs2Del.push(rec);
                    userLinks.push(KS.Grid.getAnyCase(rec, "LINK_USER"));
                }
            });
            if (Ext.isEmpty(userLinks)) return;
            KS.confirm("Удалить отмеченных пользователей?", "Подтвердите удаление", function (btn) {
                if (btn === 'yes') {
                    view.serverCall({
                        method: 'DeleteUser',
                        params: [userLinks],
                        waitMessage: 'Удаление ...',
                        success: function (changed) {
                            if (changed) {
                                view.touch();
                                Ext.each(recs2Del, function (r) {
                                    store.remove(r);
                                });
                                this.data.reportTask.TaskUsersChanged = true;
                            }
                        }
                    });
                }
            });
        }
    });
}(SavedFormView.prototype));

// ============= LOCK =======================
(function (viewClass) {
    KS.apply(viewClass, {
        refreshLock: function () {
            var view = this.parentView || this;
            view.serverCall({
                method: 'ReloadLock',
                progressOnly: true,
                success: function () {
                    view.lockGrid.reload();
                }
            });
        }
    });
}(SavedFormView.prototype));

// ============= BASE HANDLERS =======================
(function (viewClass) {
    KS.apply(viewClass, {
        onValuesSelected: function (arg) {
            var view = this;
            $.each(arg[0], function (i, v) {
                for (var field in v) {
                    if (v.hasOwnProperty(field) && field.indexOf("SET_ATTR_ROW") === 0) {
                        view.setAttrValues(v[field]);
                        view.touch();
                    }
                }
                if ('LINK_BUDGET' in v) {
                    view.touch();
                    var budgCode = (v['CODE'] == null) ? v["BUDGET_CODE"] : v['CODE'];
                    var budgName = (v['NAME'] == null) ? v["BUDGET_NAME"] : v['NAME'];
                    view.setDetailTextFieldVauefunction('reportBudget', '[' + budgCode + '] ' + budgName);
                    view.data.reportTask.BudgetLink = v['LINK_BUDGET'];
                }
                if ('LINK_ORGANIZATION' in v) {
                    view.touch();
                    var orgCode = (v['CODE'] == null) ? v["ORGANIZATION_CODE"] : v['CODE'];
                    var orgName = (v['NAME'] == null) ? v["ORGANIZATION_NAME"] : v['NAME'];
                    view.setDetailTextFieldVauefunction('reportOrgName', '[' + orgCode + '] ' + orgName);
                    view.data.reportTask.OrganizationLink = v['LINK_ORGANIZATION'];
                }
                if ('CLOSE_CODE' in v) {
                    switch (v['CLOSE_CODE']) {
                        case 'LINK_USER':
                            view.usersGrid.reload();
                            view.touch();
                            break;
                    }
                }
                if ('PRINT_URL' in v) {
                    Ext.each(v['PRINT_URL'], function (url) {
                        view.openUrl(url);
                    });
                }
                if ('ACTION' in v) {
                    switch (v['ACTION']) {
                        case 'refreshTable': //после автозаполнения
                            var tableView = view.getActiveTableView();
                            if (tableView) {
                                tableView.doRefreshTable();
                            }
                            break;
                    }
                }
            });
        },

        onBeforeClose: function() {
            var view = this,
                warnReason = null,
                warnMessage = null;
            if (view.hasChanges || view.hasTablesChanges()) {
                warnMessage = KS.locale.ReportTitle + ' содержит несохраненные изменения. <br />Сохранить перед закрытием?';
                warnReason = 'unsaved';
            } else if (view.filesGrid && view.filesGrid.hasUploadTasks) {
                warnMessage = 'Имеются незавершенные загрузки файлов. <br />Закрыть?';
                warnReason = 'upload';
            }
            if (warnMessage) {
                Ext.MessageBox.show({
                    icon: Ext.MessageBox.QUESTION,
                    title: 'Подтвердите действие',
                    msg: warnMessage,
                    buttons: Ext.MessageBox.YESNOCANCEL,
                    fn: function(btn) {
                        switch (btn) {
                            case 'yes':
                                if (warnReason === 'unsaved') {
                                    view.saveChanges(true);
                                } else if (warnReason === 'upload') {
                                    view.close();
                                }
                                break;
                            case 'no':
                                if (warnReason === 'unsaved') {
                                    view.close();
                                }
                                break;
                        }
                    }
                });
                return false;
            }
            return SavedFormView.superclass.onBeforeClose.call(view);
        }
    });
}(SavedFormView.prototype));

// ============= RPN =======================
(function (viewClass) {
    KS.apply(viewClass, {
        addRpnField: function() {
            this.dateCmp = new Ext.form.DateField({
                format: 'd.m.Y',
                fieldLabel: 'Дата уведомления',
                labelWidth: 260,
                editable: false,
                enableKeyEvents: false
            });
            this.dateCmp.on('change', this.touch, this);
            this.report.insert(0, this.dateCmp);

            if (this.rpnAttr) {
                var items = [];
                this.noticeType = new Ext.form.field.TextArea({
                    parentView: this,
                    itemId: "noticeType",
                    readOnly: true,
                    flex: 1,
                    fieldCls: 'textfield-dict',
                    value: this.getNoticeFieldValue()
                });
                this.noticeType.on('render', function (c) {
                    c.getEl().on('dblclick',
                        this.parentView.selectNoticeTypeWindow,
                        this.parentView);
                });
                items.push(this.noticeType);

                var selectBtn = new Ext.Button({
                    iconCls: 'ks-icon-get_dictionary',
                    parentView: this,
                    margin: '0 0 0 5',
                    handler: this.selectNoticeTypeWindow
                });
                items.push(selectBtn);

                this.rpnAttr.add(new Ext.form.FieldContainer({
                    layout: 'hbox',
                    fieldLabel: "Типы уведомлений",
                    labelWidth: 260,
                    items: items
                }));
            }

            this.rpnFieldAdded = true;
        },

        selectNoticeTypeWindow: function() {
            var view = this.parentView || this,
                items = [];
            view.originalSelectedRPNTypes = [];

            Ext.each(view.data.rpnTypes, function(type) {
                var checked = type.VALUE === "true";
                var attributeLink = type.ATTRIBUTE_LINK.toString();
                if (checked)
                    view.originalSelectedRPNTypes.push(attributeLink);
                items.push(new Ext.form.field.Checkbox({
                    boxLabel: type.NAME,
                    height: 30,
                    attributeLink: attributeLink,
                    anchor: "95% -53",
                    checked: checked
                }));
            });

            var height = Math.min(items.length*30 + 150, KS.rootViewport.getHeight() / 1.25);

            view.noticeTypesWin = new Ext.Window({
                title: 'Перечень уведомлений',
                resizable: true,
                maximizable: true,
                autoScroll: true,
                modal: true,
                width: Math.max(400, KS.rootViewport.getWidth() / 2),
                height: height,
                minWidth: 400,
                minHeight: 200,
                plain: true,
                labelWidth: 200,
                labelStyle: 'font-size:10px;',
                items: items,
                bodyStyle: 'padding:5px;',
                buttonAlign: 'right',
                buttons: [{
                    text: 'Выбрать',
                    cls: 'marked-button',
                    scope: view,
                    handler: view.noticeTypeSelected
                },{ xtype: 'tbspacer', width: 8 }, {
                    text: 'Отмена',
                    cls: 'dim-button',
                    scope: view,
                    handler: view.noticeTypesWinClose
                }]
            }).show();
        },

        noticeTypesWinClose: function() {
            this.noticeTypesWin.close();
        },

        noticeTypeSelected: function() {
            var view = this;
            var typesState = [];
            var selectedRPNTypes = [];
            view.noticeTypesWin.items.each(function(item) {
                var checked = item.getValue().toString();
                if (checked === "true")
                    selectedRPNTypes.push(item.attributeLink.toString());
                typesState.push({
                    "ATTRIBUTE_LINK": item.attributeLink,
                    "VALUE": checked
                });
            });
            if (view.originalSelectedRPNTypes.join() === selectedRPNTypes.join()) {//ничего нового не выбрали
                view.noticeTypesWin.close();
                return;
            }
            view.originalSelectedRPNTypes = [];

            view.serverCall({
                method: 'SelectRPNTypes',
                params: [typesState],
                disableFog: true,
                success: function(rpnTypes) {
                    view.data.rpnTypes = rpnTypes;
                    view.noticeTypesWin.close();
                    view.noticeType.setValue(view.getNoticeFieldValue());
                    view.eachTable(function(tableView) {
                        if (tableView.tableName === "Данные") { // Обновляем только таблицу "Данные"
                            tableView.needRefresh = true;
                            tableView.restoreCachedValues = true;
                        }
                    });
                    view.data.reportTask.AttributesChanged = true;
                    if (this.data.isNewTask){
                        if (!Ext.isEmpty(selectedRPNTypes)){
                            this.addAction({ cmd: 'save', params: ['auto'] });
                            this.addAction({ cmd: 'refresh', params: ['auto'] });
                            this.processQueuedActions();
                        }
                    } else {
                        view.reloadFilesList();
                        view.touch();
                    }
                }
            });
        },

        getNoticeFieldValue: function() {
            var view = this;
            var fieldValue = [];
            Ext.each(view.data.rpnTypes, function(type) {
                if (type.VALUE === "true")
                    fieldValue.push(type.NAME);
            });

            return fieldValue.join("\n");
        },

        processSelectedAttributeRow: function (attributeLink, selectedRow) {
            this.serverCall({
                method: 'ProcessSelectedAttributeRow',
                params: [attributeLink, selectedRow],
                disableFog: true,
                success: this.setAttrValues
            });
        }
    });
}(SavedFormView.prototype));

// ============= TABLES =======================
(function (viewClass) {
    KS.apply(viewClass, {
        activateTabHandler: function (tabPanel, newTab) {
            var idParts = newTab.ctrlId.split('_');
            if (idParts[0] !== 'TABLE') {
                this.customToolBar(false);
                return;
            }
            this.customToolBar(true);
            var tableLink = +idParts[1];
            if (tableLink <= 0 && !newTab.isMergedTable) return;
            if (newTab.nestedView) {
                // Opened
                if (newTab.nestedView.needRefresh) {
                    newTab.nestedView.doRefreshTable.apply(newTab.nestedView);
                    newTab.nestedView.needRefresh = false;
                }
                newTab.nestedView.setEditState();
            } else {
                // Not opened
                this.openTable(tableLink);
            }
        },

        openTable: function (tableLink) {
            this.serverCall({
                method: 'OpenTable',
                waitMsg: 'Открытие таблицы ...',
                params: [tableLink, this.data.reportTableCell || null]
            });
        },

        addChildView: function (panel) {
            if (!this.topTabPanel) {
                // Parent view is not ready, render child later
                if (!this.deferredAddChildViews) {
                    this.deferredAddChildViews = [];
                }
                this.deferredAddChildViews.push(panel);
                return true;
            }
            var tabIndex = this.topTabPanel.items.findIndex('title', panel.title, 1);
            if (tabIndex > 0) {
                var tab = this.topTabPanel.items.getAt(tabIndex);
                panel.tbar = false;
                panel.header = false;
                tab.add(panel);
                var tableView = eval(panel.classInstance);
                if (tableView) {
                    this.childViews[tabIndex] = tableView;
                    tableView.parentView = this;
                    tab.nestedView = tableView;
                }
                KS.updateLayout(tab);
                return true;
            }
            return false;
        },

        onDependentChanged: function () {
            if (KS.isEmpty(this.dependentViews)) return;
            KS.updateLayout(this.containerPanel);
        },

        getActiveTableView: function () {
            var activeTabIndex = this.getActiveTabIndex();
            if (activeTabIndex > 0) {
                return this.childViews[activeTabIndex];
            }
            return null;
        },

//        Используется в SFTV.js
        tableReadOnly: function() {
            return this.data.isReadOnly;
        },

        reportAllowDenyColumns: function() {
            return this.data.allowDenyColumns;
        }
    });
}(SavedFormView.prototype));

// ============= TREE =======================
function setCheckedRecursive(node, checked) {
    if (node.id !== 'root' && node.isLeaf()) setChecked(node, checked);
    Ext.each(node.childNodes,
        function() {
            setCheckedRecursive(this, checked);
        });
}

function setChecked(node, checked) {
    if (!Ext.isBoolean(checked)) {
        checked = !node.data.checked;
    }
    node.set('checked', checked);
}

function loadDocumentFile (viewId, internalId) {
    var view = KS.getView(viewId);
    var record = view.filesGrid.getStore().getByInternalId(internalId);
    view.loadDocumentFile(record);
}

function fileNameRenderer(value, metadata, record) {
    var rightAlign = 'float: right',
        loadFileBtn = '<img src="PlatformHandler.axd?icon=add_attachment.png" onclick="loadDocumentFile(\'' + record.store.grid.parentView.viewID + '\', \'' + record.internalId  + '\')" style="' + rightAlign + '"/>',
        emptyText = '';
    if (KS.Grid.getAnyCase(record, 'IS_REQUIRED') &&
        KS.Grid.getAnyCase(record, 'FULL_NAME') === "") {
        if (KS.Grid.getAnyCase(record, 'NO_DOCUMENT_REQUIRED') ||
            KS.Grid.getAnyCase(record, 'IS_NOT_EXIST')) {
            metadata.css += ' link-setting-88';
            loadFileBtn = '';
        }
        else {
            metadata.css += ' link-setting-99';
            emptyText = '<a style="color: gray">Выберите файл...</a>';
        }
    }
    return value + emptyText + loadFileBtn;
}

function fileNoteRenderer(value, metadata) {
    setTooltip(metadata, value);
    return value;
}

function fileCommentRenderer(value, metadata, record) {
    setTooltip(metadata, value);
    if (KS.Grid.getAnyCase(record, 'IS_REQUIRED') &&
        !KS.Grid.getAnyCase(record, 'IS_NOT_EXIST')){
        metadata.css += " ks-cell-disabled";
    }
    return value;
}

function deleteNote(viewId, noteLink) {
    var view = KS.getView(viewId);
    view.deleteNote(noteLink);
}

if (typeof (Sys) !== 'undefined') Sys.Application.notifyScriptLoaded();