﻿BaseSvodImportView = KS.extend(BaseSvodView, { });

(function(viewClass) {
    KS.apply(viewClass, {
        onTemplateRendered: function() {
            this.configureSelectFileBtn();
        },

        configureSelectFileBtn: function() {
            var selectFileBtn = Ext.getCmp("selectImportFileBtn");
            if (!KS.isEmpty(selectFileBtn)) {
                selectFileBtn.fileInputEl.dom.multiple = false;
            }
        },

        import: function() {
            var view = this.parentView;
            if (Ext.isEmpty(view.importFilePath)) {
                KS.alert("Выберите файл для импорта");
                return;
            }
            view.doImport();
        },

        doImport: function() {
            this.serverCall({
                method: 'ImportFile',
                params: [this.importFilePath],
                waitMessage: 'Импорт файла...'
            });
        },

        saveFiles: function(fileKeys) {
            var view = this.parentView || this;
            var file = fileKeys[0];
            if (!view.validateFile(file)) return;
            view.serverCall({
                method: 'AnalizeFile',
                params: [file],
                waitMessage: 'Анализ файла...',
                success: function(filePath) {
                    view.importFilePath = filePath;
                    view.configureSelectFileBtn();
                    view.mainGrid.reload();
                }
            });
        },

        validateFile: function(file) {
            var fileExtension = file.fileExtension;
            var validExts = [".zip", ".sql"];
            if (!KS.isEmpty(validExts) && validExts.indexOf(fileExtension) < 0) {
                KS.alert("Тип файла " + fileExtension + " не разрешен для загрузки. Разрешенные типы : '.sql, .zip'");
                return false;
            }
            return true;
        }
    });
}(BaseSvodImportView.prototype));

if (typeof(Sys) !== 'undefined') Sys.Application.notifyScriptLoaded();