using System.Threading;
using System.Threading.Tasks;
using Keysystems.Core.Web.Controls;
using System.Linq;
using Keysystems.Core.Web.Views;

namespace Keysystems.Core.Web.Scripts
{
    /// <summary>
    /// </summary>
    public class PlatformScriptManager : Control
    {
        #region Static members

        /// <summary>
        ///   Возвращает текущий объект менеджера. Если надо - добавляет на страницу
        /// </summary>
        /// <param name = "control"></param>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        public static async Task<PlatformScriptManager> GetCurrentAsync(Control control, CancellationToken cancellationToken)
        {
            var view = control.FindNearestParentWebView() as Control;
            if (view.Controls.FirstOrDefault(c => c is PlatformScriptManager) is not PlatformScriptManager manager)
            {
                manager = new PlatformScriptManager();
                await manager.SetIdAsync("psm", cancellationToken);
                await view.Controls.AddAsync(manager, cancellationToken);
            }

            return manager;
        }
        
        #endregion

        #region Public methods

        /// <summary>
        /// Регистрирует стартап-литерал
        /// </summary>
        /// <param name = "container"></param>
        /// <param name = "script"></param>
        /// <param name="cancellationToken"></param>
        public async Task<ScriptLiteral> RegisterScriptLiteralAsync(Control container, string script,
            CancellationToken cancellationToken)
        {
            var scriptLiteral = new ScriptLiteral {Text = script, NeedTags = true};
            await container.Controls.AddAsync(scriptLiteral, cancellationToken);
            return scriptLiteral;
        }

        /// <summary>
        /// Регистрирует стартап-литерал
        /// </summary>
        /// <param name = "container"></param>
        /// <param name="id">Идентификатор литерала, если такой уже есть, то меняет его значение</param>
        /// <param name = "script"></param>
        /// <param name="cancellationToken"></param>
        public async Task<ScriptLiteral> RegisterScriptLiteralAsync(Control container, string id, string script,
            CancellationToken cancellationToken)
        {
            var c = container.FindControl(id);
            ScriptLiteral scriptLiteral;
            if (c == null)
            {
                scriptLiteral = new ScriptLiteral {Text = script, NeedTags = true};
                await container.Controls.AddAsync(scriptLiteral, cancellationToken);
            }
            else
            {
                scriptLiteral = (ScriptLiteral) c;
                scriptLiteral.Text = script;
                scriptLiteral.NeedTags = true;
            }

            return scriptLiteral;
        }

        #endregion
    }
}