﻿SavedFormSignView = KS.extend(BaseTreeView, {});

// ============= COMMON =======================
(function (viewClass) {
    KS.apply(viewClass, {
        resetView: function () {
            this.getToolbarItem(this.mainTabs, 'top', 'SIGN').setDisabled(true);
            var sAllBtn = this.getToolbarItem(this.mainTabs, 'top', 'SIGN_ALL');
            if (sAllBtn) {
                this.singleReport = this.baseTree.getRootNode().childNodes.length === 1;
                if (sAllBtn.setHidden) sAllBtn.setHidden(this.singleReport);
                sAllBtn.setDisabled(!this.hasUnsignedReports() || this.singleReport);
            }
            if (this.pdfTab) this.getToolbar(this.pdfTab).setDisabled(true);
            this.hideProtocol();
            this.allReports = this.baseTree.getRootNode().childNodes;
            this.allReportCount = this.allReports.length;
            if (!KS.isEmpty(this.data.formsWoutOptions)) {
                var view = this,
                    codes = '';
                Ext.each(this.data.formsWoutOptions, function (code) { codes += (code + ',') });
                setTimeout(function() {
                    KS.confirm("Для форм " + codes + " нет настроек печати по умолчанию. Необходимо обратиться к администратору комплекса. Продолжить?",
                        "Продолжить?", 
                        function (btn) {
                            if (btn === 'yes') {
                                view.allPrepareFormCount = view.data.formsWoutOptions.length;
                                view.currentPrepareForm = 0;
                                view.prepareFormsForSign();
                            } else {
                                view.close();
                            }
                        });
                }, 10);
            } else {
                this.fillSignContext();
            }
        },

        prepareFormsForSign: function(){ // вызывает окна PrintOptionsView для настройки шаблонов
            var view = this;
            var waitMessage = 'Подготовка к подписи ' + this.currentPrepareForm + ' из ' + this.allPrepareFormCount;
            this.showShortWaitMsg(waitMessage);
            this.serverCall({
                method: 'PrepareFormsForSign',
                waitMessage: waitMessage,
                success: function(){
                    view.currentPrepareForm++;
                },
            });
        },

        showShortWaitMsg: function (msg, timeout) { // Показать сообщение (дефолтно на 2 секунды)
            var view = this;
            view.containerPanel.mask(msg);
            setTimeout(function() {
                view.containerPanel.unmask();
            }, timeout || 2000);
        },

        fillSignContext: function(){ // вызывается когда все шаблоны готовы
            this.currentReport = 0;
            this.prepareFormContext();
        },

        prepareFormContext: function(){
            if (this.currentReport === this.allReportCount) {
                this.baseTree.selectFirstNode();
                this.allReportsReady = true; // Признак, что все контексты заполнены и отчёты готовы для подписи
            } else {
                var view = this;
                view.isPreparingFormContext = true;
                var treeNode = view.allReports[view.currentReport];
                view.prepareForm(treeNode.id, view.prepareFormContextCallback,
                    'Заполнение контекста подписи ' + view.currentReport + ' из ' + view.allReportCount);
            }
        },

        prepareFormContextCallback: function (objData) {
            if (objData)
                this.allReports[this.currentReport].objData = objData;

            if (!objData || (!this.isReportNeedPdf(objData) || objData.errorProtocol)) {
                this.currentReport++;
                this.prepareFormContext();
            }
        },

        selectForm: function (selModel, selected) {
            this.treeNode = selected[0] || selected;
            if (!Ext.isEmpty(this.treeNode)) {
                if (this.treeNode.objData && !this.isReportNeedPdf(this.treeNode.objData)) {
                    this.showFormData(this.treeNode.objData);
                } else {
                    this.isPreparingFormContext = false;
                    this.currentReport = Ext.Array.indexOf(this.allReports, this.treeNode);
                    this.prepareForm(this.treeNode.id, this.showFormData);
                }
            }
        },

        prepareForm: function (id, callback = null, waitMsg = 'Подготовка данных') {
            var view = this;
            view.serverCall({
                method: 'PrepareForm',
                waitMessage: waitMsg,
                params: [id],
                success: function (objData) {
                    if (Ext.isFunction(callback))
                        callback.call(view, objData);
                }
            });
        },

        updateFormData: function () {
            var view = this;
            var treeNode = view.allReports[view.currentReport];
            view.serverCall({
                method: 'ShowFormDataForSign',
                params: [treeNode.id],
                waitMessage: 'Получение данных',
                success: function (objData) {
                    if (view.isPreparingFormContext) {
                        if (objData)
                            treeNode.objData = objData;
                        view.currentReport++;
                        view.prepareFormContext();
                    }
                    else
                        view.showFormData(objData);
                }
            });
        },

        showFormData: function (objData) {
            var enableSign = false,
                nextCalled = false;
            if (objData) this.treeNode.objData = objData;
            if (!objData) {
                this.showProtocol('');
            } else if (objData.errorProtocol) {
                this.showProtocol(objData.errorProtocol);
            } else {
                this.hideProtocol();
                var isSigned = objData.SIGNED;
                if (isSigned) {
                    this.baseTree.setIcon(this.treeNode, 'ks-icon-key');
                    this.treeNode.signed = true;
                    this.signNext();
                    nextCalled = true;
                }
                if (objData.N86_URL) {
                    this.mainTabs.setActiveTab(this.n86Tab);
                    this.n86Tab.setTitle('N86 файл ' + (isSigned ? '(подписан)' : ''));
                    this.n86Tab.update(objData.N86_CONTENT);
                } else {
                    if (this.n86Tab) {
                        this.setTabHidden(this.n86Tab, true);
                        this.n86Tab._hidden = true;
                    }
                }
                if (objData.TXT_CONTENT) {
                    this.mainTabs.setActiveTab(this.txtTab);
                    this.txtTab.setTitle('Текстовый файл ' + (isSigned ? '(подписан)' : ''));
                    this.txtTab.update(objData.TXT_CONTENT);
                }
                if (this.data.loadPdf) {
                    this.pdfTab.setTitle('PDF файл ' + (isSigned && this.data.loadPdf ? '(подписан)' : ''));
                    if (objData.PDF_URL) {
                        this.mainTabs.setActiveTab(this.pdfTab);
                        this.getToolbarItem(this.pdfTab, 'top', 'download').setDisabled(false);
                        this.previewPdf(objData.PDF_URL);
                    }
                    else {
                        this.getToolbar(this.pdfTab, 'top').setDisabled(true);
                        this.pdfTab.update('');
                    }
                }
                if (objData.FILES) {
                    this.setTabHidden(this.filesTab, KS.isEmpty(objData.FILES));
                    this.filesTab.setTitle('Прикрепленные файлы ' + (isSigned && this.allFilesSigned() ? '(подписаны)' : ''));
                    var root = this.filesTree.getRootNode();
                    root.removeAll();
                    this.filesTree.addChildNodes(root, objData.FILES);
                }
                if (objData.MCHD_PROTOCOL){
                    this.setTabHidden(this.protocolTab, false);
                    this.protocolTab.update(objData.MCHD_PROTOCOL);
                }
                enableSign = !isSigned;
                if ((this.txtTab && !objData.TXT_CONTENT) ||
                    (this.pdfTab && this.isReportNeedPdf(objData)) ||
                    (this.n86Tab && !this.n86Tab._hidden && !objData.N86_CONTENT))
                    enableSign = false;
            }
            this.getToolbarItem(this.mainTabs, 'top', 'SIGN').setDisabled(!enableSign);
            var sAllBtn = this.getToolbarItem(this.mainTabs, 'top', 'SIGN_ALL');
            if (sAllBtn) {
                sAllBtn.setDisabled(!this.hasUnsignedReports() || this.singleReport);
            }
            if (!nextCalled) {
                this.signNext();
            }
        },

        signReportCallback: function (objData) {
            if (objData) this.treeNode.objData = objData;
            if (!objData) {
                this.showProtocol('');
            } else if (objData.errorProtocol) {
                this.showProtocol(objData.errorProtocol);
            } else {
                this.hideProtocol();
                var isSigned = objData.SIGNED;
                if (isSigned) {
                    this.baseTree.setIcon(this.treeNode, 'ks-icon-key');
                    this.treeNode.signed = true;
                    this.signNext();
                }
            }
        },

        hideProtocol: function () {
            if (this.n86Tab && !this.n86Tab._hidden) this.setTabHidden(this.n86Tab, false);
            this.setTabHidden(this.txtTab, false);
            this.setTabHidden(this.pdfTab, false);
            this.setTabHidden(this.filesTab, false);
            this.setTabHidden(this.protocolTab, true);
        },

        showProtocol: function (protocol) {
            this.setTabHidden(this.n86Tab, true);
            this.setTabHidden(this.txtTab, true);
            this.setTabHidden(this.pdfTab, true);
            this.setTabHidden(this.filesTab, true);
            this.setTabHidden(this.protocolTab, false);
            this.mainTabs.setActiveTab(this.protocolTab);
            this.protocolTab.update(protocol);
            this.containerPanel.unmask();
        },

        setTabHidden: function (tab, hidden) {
            if (!tab) return;
            if (this.mainTabs && Ext.isFunction(this.mainTabs.hideTabStripItem)) {
                if (hidden) {
                    this.mainTabs.hideTabStripItem(tab);
                } else {
                    this.mainTabs.unhideTabStripItem(tab);
                }
            } else {
                var tabBar = this.mainTabs.getTabBar();
                tabBar.items.each(function (item) {
                    if (tab.title === item.text) {
                        item.setHidden(hidden);
                    }
                });
            }
        },

        activateTabHandler: function (tabPanel, newTab) {
            if (this.data.loadPdf || newTab.ctrlId !== 'pdfTab') return;
            var view = this;
            if (view.treeNode && view.treeNode.objData) {
                var objData = view.treeNode.objData;
                if (objData.PDF_URL) {
                    view.previewPdf(objData.PDF_URL);
                } else {
                    view.preparePdf(objData.ID);
                }
            }
        },
        
        preparePdf: function(objDataId){
            this.serverCall({
                method: 'PreparePdf',
                waitMessage: 'Подготовка данных...',
                params: [objDataId]
            });
        },

        onServerLoadPdf: function(pdfUrl){
            this.treeNode.objData.PDF_URL = pdfUrl;
            this.previewPdf(pdfUrl);              
        },

        getTbarClickHandler: function(tbarItem) {
            if (tbarItem.code === 'SIGN') {
                return this.sign;
            } else if (tbarItem.code === 'SIGN_ALL') {
                return this.signAll;
            } else {
                return SavedFormSignView.superclass.getTbarClickHandler.call(this, tbarItem);
            }
        },

        sign: function() {
            var view = this.parentView || this,
                od = view.treeNode.objData;
            KS.XCrypt.viewContext = view;
            delete KS.XCrypt.lastSignError;
            delete view.certErrorDisplayed;
            if (od && !od.SIGNED && od.ID) view.getOpenData([od.ID]);
        },

        signNext: function () {
            if (this.signAllReports) {
                if (this.hasUnsignedReports()) {
                    this.signAll();
                } else if (this.allReportsReady) { // Подписали все отчёты
                    this.containerPanel.unmask();
                    this.allReportsReady = null;
                    this.treeNode = this.baseTree.getSelNode();
                    this.checkBadSignReports(this.treeNode.objData); // обновляем выбранную форму
                }
                else {
                    this.signAllReports = false;
                }
            } else {
                this.containerPanel.unmask();
            }
        },

        signAll: function () {
            var view = this.parentView || this,
                od = view.treeNode.objData;
            view.signAllReports = true;
            if (od && !od.SIGNED && !od.errorProtocol && !view.isReportNeedPdf(od)) {
                view.sign.apply(this);
            } else {
                var n = view.findFirstUnsignedReportNode();
                if (n) {
                    if (this.allReportsReady) {
                        view.treeNode = n;
                        view.sign();
                    } else {
                        if (KS.isFunction(n.select)) {
                            n.select();
                        } else {
                            view.baseTree.getSelectionModel().select(n);
                        }
                    }
                }
            }
        },

        showSignProgressMsg: function(){
            if (this.allReportsReady && this.certData) {
                this.currentSignReport = this.currentSignReport || 0;
                this.containerPanel.mask("Подпись отчётов " + this.currentSignReport + " из " + this.allReportCount);
                this.currentSignReport++;
            }
        },

        getCertificates: function () {
            if (this.signAllReports && this.certData) {
                delete this.certData.INT_SIGN;
                delete this.certData.N86_SIGN;
                delete this.certData.PDF_SIGN;
                delete this.certData.TXT_SIGN;
                this.getDataForSign(this.certData, this.certsJson);
            } else {
                KS.XCrypt.selectCertificate(this.getDataForSign, this);
            }
        },

        getDataForSign: function (certData, certsJson) {
            this.certData = certData;
            this.certsJson = certsJson;
            this.showSignProgressMsg();
            if (certsJson) {
                var originalCert = Ext.Array.findBy(certsJson, function (cert) {
                    return cert.subjectid === certData.subjectid;
                });
                if (originalCert) {
                    this.certData['originalSubject'] = originalCert.subject;
                }
            }
            var od = this.treeNode.objData;
            if (od.DATA_TO_SIGN) {
                KS.XCrypt.sign(od.DATA_TO_SIGN, certData.serial, 1, 'TspUrl=', this.dataSigned, this);
            }
            this.edsTypeSelector('txt', od.TXT_URL, this.txtDownloaded, this.txtSigned);
            this.edsTypeSelector('pdf', od.PDF_URL, this.pdfDownloaded, this.pdfSigned);
            this.edsTypeSelector('int', od.INT_URL, this.intDownloaded, this.intSigned);
            this.edsTypeSelector('n86', od.N86_URL, this.n86Downloaded, this.n86Signed);
            if (od.FILES) this.signNextFile();
        },

        edsTypeSelector: function (format, url, fnDownloaded, fnSigned) {
            if (KS.isEmpty(url)) return;
            if (KS.XCrypt.signSettings.primaryB64) {
                this.signBase64(format, fnSigned);
            } else {
                KS.XCrypt.downloadFile(url, fnDownloaded, this);
            }
        },

        signBase64: function (format, callback) {
            var od = this.treeNode.objData;
            this.serverCall({
                method: 'LoadBase64',
                waitMessage: 'Чтение данных',
                params: [format, od.ID || null],
                success: function (base64String) {
                    KS.XCrypt.sign(base64String, this.certData.serial, 1, 'TspUrl=', callback, this);
                }
            });
        },

        dataSigned: function (sign) {
            if (this.checkSignForErrors(sign)) {
                this.containerPanel.unmask();
                return;
            }
            this.certData.SIGN = sign;
            this.trySaveData();
        },

        txtDownloaded: function (path) {
            if (this.checkSignForErrors(path, true)) {
                this.signBase64('txt', this.txtSigned);
            } else {
                KS.XCrypt.signFileWeb(path, this.certData.serial, 1, 'TspUrl=', this.txtSigned, this);
            }
        },

        txtSigned: function(sign) {
            if (this.checkSignForErrors(sign, true)) {
                //this.showProtocol(KS.XCrypt.lastSignError);
                if (!this.certErrorDisplayed)
                    KS.Svod.showHtmlProtocol(KS.XCrypt.lastSignError, 'Ошибка сертификата');
                this.certErrorDisplayed = true;
                this.containerPanel.unmask();
                return;
            }
            this.certData.TXT_SIGN = sign;
            this.trySaveData();
        },

        pdfDownloaded: function (path) {
            if (this.checkSignForErrors(path, true)) {
                this.signBase64('pdf', this.pdfSigned);
            } else {
                KS.XCrypt.signFileWeb(path, this.certData.serial, 1, 'TspUrl=', this.pdfSigned, this);
            }
        },

        pdfSigned: function (sign) {
            if (this.checkSignForErrors(sign, true)) {
                //this.showProtocol(KS.XCrypt.lastSignError);
                if (!this.certErrorDisplayed)
                    KS.Svod.showHtmlProtocol(KS.XCrypt.lastSignError, 'Ошибка сертификата');
                this.certErrorDisplayed = true;
                this.containerPanel.unmask();
                return;
            }
            this.certData.PDF_SIGN = sign;
            this.trySaveData();
        },

        intDownloaded: function (path) {
            if (this.checkSignForErrors(path, true)) {
                this.signBase64('int', this.intSigned);
            } else {
                KS.XCrypt.signFileWeb(path, this.certData.serial, 1, 'TspUrl=', this.intSigned, this);
            }
        },

        intSigned: function (sign) {
            if (this.checkSignForErrors(sign)) {
                this.containerPanel.unmask();
                return;
            }
            this.certData.INT_SIGN = sign;
            this.trySaveData();
        },

        n86Downloaded: function (path) {
            if (this.checkSignForErrors(path, true)) {
                this.signBase64('n86', this.n86Signed);
            } else {
                KS.XCrypt.signFileWeb(path, this.certData.serial, 1, 'TspUrl=', this.intSigned, this);
            }
        },

        n86Signed: function (sign) {
            if (this.checkSignForErrors(sign)) {
                this.containerPanel.unmask();
                return;
            }
            this.certData.N86_SIGN = sign;
            this.trySaveData();
        },

        trySaveData: function() {
            var view = this,
                od = this.treeNode.objData,
                cd = this.certData;
            if ((od.DATA_TO_SIGN && !cd.SIGN) ||
                (od.TXT_URL && !cd.TXT_SIGN) ||
                (od.PDF_URL && !cd.PDF_SIGN) ||
                (od.INT_URL && !cd.INT_SIGN) ||
                (od.N86_URL && !cd.N86_SIGN) ||
                view.getNextUnsignedFileNode() != null) {
                return;
            }
            KS.apply(cd, view.collectFilesSignes().signes);
            // Reset cached cert password
            if (KS.edsType === 2) {
                KS.XCrypt.cmInitor.container.Lavanda.Crypto.Clear({});
            }
            view.serverCall({
                method: 'SaveSignData',
                waitMessage: 'Подписывание',
                params: [cd, od.ID],
                success: function (objData) {
                    if (view.allReportsReady && !view.singleReport) {
                        view.signReportCallback(objData, od.ID);
                    } else {
                        view.checkBadSignReports(objData, od.ID)
                    }
                }
            });
        },

        hasUnsignedReports: function() {
            return this.findFirstUnsignedReportNode() != null;
        },

        findFirstUnsignedReportNode: function () {
            var view = this;
            var node = null;
            this.baseTree.getRootNode().eachChild(function (n) {
                if (n.objData && !n.objData.errorProtocol && !view.isReportNeedPdf(n.objData) &&
                    !n.signed && !(n.data.json && n.data.json.notForSign)) {
                    node = n;
                    return false;
                }
            });
            return node;
        },

        nodeDblClick: function (baseTree, node) {
            if (node.objData && this.isReportNeedPdf(node.objData)) {
                this.prepareForm(node.id, this.showFormData);
            }
        },

        isReportNeedPdf: function (objData) {
            return !!(!objData.PDF_URL && this.data.loadPdf);
        }
    });
}(SavedFormSignView.prototype));

// ============= Files =======================
(function (viewClass) {
    KS.apply(viewClass, {
        allFilesSigned: function () {
            if (KS.isEmpty(this.filesTree)) return true;
            var s = this.collectFilesSignes();
            return s.all && s.errors === 0;
        },

        collectFilesSignes: function () {
            var signes = {},
                all = true,
                errors = 0,
                view = this;
            if (this.filesTree) {
                this.filesTree.getRootNode().eachChild(function(node) {
                    if (KS.isEmpty(node.sign)) {
                        all = false;
                    } else {
                        if (view.checkSignForErrors(node.sign)) errors++;
                        signes["FILE_SIGN_" + node.id] = node.sign;
                    }
                });
            }
            return {
                signes: signes,
                all: all,
                errors: errors
            };
        },

        signNextFile: function () {
            var view = this,
                node = this.getNextUnsignedFileNode();
            if (KS.isEmpty(node)) {
                this.trySaveData();
                return;
            }
            function signed(sign) {
                node.sign = sign;
                if (!view.checkSignForErrors(sign))
                    view.filesTree.setIcon(node, 'ks-icon-key');
                view.signNextFile();
            }
            var od = this.treeNode.objData;
            if (KS.XCrypt.signSettings.primaryB64) {
                this.signBase64(node.id, signed);
            } else {
                KS.XCrypt.downloadFile(od['FILE_URL_' + node.id], function (path) {
                    KS.XCrypt.signFileWeb(path, this.certData.serial, 1, 'TspUrl=', signed, this);
                }, this);
            }
        },

        getNextUnsignedFileNode: function () {
            if (KS.isEmpty(this.filesTree)) return null;
            var node = null;
            this.filesTree.getRootNode().eachChild(function (n) {
                if (KS.isEmpty(n.sign)) node = n;
            });
            return node;
        },

        previewFile: function (tree, node) {
            if (KS.isEmpty(node)) {
                this.filePreview.update('');
            } else {
                var od = this.treeNode.objData;
                this.filePreview.update('<a href="' + (od['FILE_URL_' + node.id]) + '" target="_blank">Скачать</a>');
            }
        }
    });
}(SavedFormSignView.prototype));

// ============= Error Signs =======================
(function (viewClass) {
    KS.apply(viewClass, {
        checkBadSignReports: function (objData, contextId) {
            var view = this;

            if (!Ext.isEmpty(view.data.identifier) &&
                !Ext.isEmpty(view.data.identifier.AdditionalParams) &&
                view.data.identifier.AdditionalParams["ENTITY_CLOSE_CODE"] == "ID_REPORT_TASK_LIST_SIGN") {
                view.refreshDocumentForSign();
            } else {
                view.refreshTaskList();
            }
            view.showFormData(objData);
            // view.serverCall({
            //    method: 'CheckBadSignReports',
            //    waitMessage: 'Сохранение',
            //    params: [view.certData, contextId],
            //    success: function (objData) {
            //        view.checkBadSignsCallback(objData, contextId)
            //    }
            // });
        },

        checkBadSignsCallback: function (objData, contextId) {
            if (KS.isEmpty(objData.badReports)) {
                this.refreshTaskList();
                this.showFormData(objData);
            } else {
                this.pleaseWait('Завершение подписи');
                this.badReports = objData.badReports;
                this.resignNextBadReport(contextId);
            }
        },

        resignNextBadReport: function (contextId) {
            var finished = true;
            for (var idx = 0; idx < this.badReports.length; idx++) {
                var br = this.badReports[idx];
                if (!KS.isEmpty(br['TXT_BASE64']) && KS.isEmpty(br['TXT_SIGN'])) {
                    this.createBadReportSign(br, "TXT", contextId);
                    finished = false;
                    break;
                }
                if (!KS.isEmpty(br['PDF_BASE64']) && KS.isEmpty(br['PDF_SIGN'])) {
                    this.createBadReportSign(br, "PDF", contextId);
                    finished = false;
                    break;
                }
            }
            if (finished) {
                this.stopWaiting();
                this.saveRenewedEds(contextId);
            }
        },

        createBadReportSign: function (br, format, contextId) {
            this.badReport = br;
            this.badReportFormat = format;
            this.currentContextId = contextId;
            KS.XCrypt.sign(br[format + "_BASE64"], this.certData.serial, 1, 'TspUrl=', this.badReportSigned, this);
        },

        badReportSigned: function (sign) {
            this.badReport[this.badReportFormat + '_SIGN'] = sign;
            delete this.badReport[this.badReportFormat + '_BASE64'];
            this.resignNextBadReport(this.currentContextId);
            delete this.currentContextId;
        },

        saveRenewedEds: function (contextId) {
            this.serverCall({
                method: 'SaveRenewedEds',
                waitMessage: 'Завершение подписи',
                params: [this.certData, this.badReports, contextId],
                success: this.showFormData
            });
        }
    });
}(SavedFormSignView.prototype));

// ============= PDF.JS =======================
(function (viewClass) {
    KS.apply(viewClass, {
        downloadPdf: function() {
            KS.openUrl(this.parentView.treeNode.objData.PDF_URL);
        },

        prevPage: function() {
            this.parentView.gotoPage(this.parentView.currentPage - 1);
        },

        nextPage: function() {
            this.parentView.gotoPage(this.parentView.currentPage + 1);
        },

        checkPdfJsSupported: function() {
            return !!window.Promise;
        },

        previewPdf: function(url) {
            if (this.checkPdfJsSupported() && window.PDFJS) {
                this.pdfTab.update('<canvas id="the-canvas"></canvas>');
                window.PDFJS.workerSrc = 'js/svod/Views/ViewerJS/pdf.worker.js';
                this.maskPdf('Формирование документа');
                window.PDFJS.getDocument(url).then(this.renderPdf.bind(this));
            } else {
                this.pdfTab.update('<h1>В данном браузере предварительный просмотр недоступен</h1>');
            }
        },

        renderPdf: function(pdf) {
            this.pdf = pdf;
            this.gotoPage(1);
        },

        gotoPage: function(pageNum) {
            this.currentPage = pageNum;
            var numPages = this.pdf.pdfInfo.numPages,
                pdfTbar = this.getToolbar(this.pdfTab, 'top'),
                prevBtn = this.getToolbarItem(this.pdfTab, 'top', 'prevBtn'),
                nextBtn = this.getToolbarItem(this.pdfTab, 'top', 'nextBtn'),
                pageLabel = this.getToolbarItem(this.pdfTab, 'top', 'pageLabel');
            if (this.currentPage < 1) this.currentPage = 1;
            if (this.currentPage > numPages) this.currentPage = numPages;
            if (numPages > 1) {
                prevBtn.setDisabled(this.currentPage == 1);
                nextBtn.setDisabled(this.currentPage == numPages);
            }
            pdfTbar.setDisabled(false);
            pageLabel.setText(this.currentPage + ' из ' + numPages);
            this.maskPdf('Формирование страницы');
            this.pdf.getPage(this.currentPage).then(this.renderPdfPage.bind(this));
        },

        renderPdfPage: function(page) {
            var scale = 2,
                viewport = page.getViewport(scale),
                canvas = document.getElementById('the-canvas'),
                context = canvas.getContext('2d');
            canvas.height = viewport.height;
            canvas.width = viewport.width;
            var renderContext = {
                canvasContext: context,
                viewport: viewport
            };
            this.maskPdf('Формирование страницы');
            var callback = this.pdfPageRenderComplete.bind(this);
            page.render(renderContext).then(callback, callback);
        },

        pdfPageRenderComplete: function () {
            this.unmaskPdf();
        },

        maskPdf: function(msg) {
            this.pdfTab.body.unmask();
            this.pdfTab.body.mask(msg);
        },

        unmaskPdf: function() {
            this.pdfTab.body.unmask();
        }
    });
}(SavedFormSignView.prototype));

if (typeof(Sys) !== 'undefined') Sys.Application.notifyScriptLoaded();