﻿BaseCheckSumsExcelEditView = KS.extend(BaseSvodView, {
    touch: function () {
        var view = this;
        view.hasChanges = true;
        view.setSavedState(false);
        view.getToolbarItem(view.checkSumsExcelEditPanel, null, 'SAVE').setDisabled(false);
    },

    saveChanges: function () {
        var view = this.parentView || this;
        view.uploadRulesExcel();
        view.hasChanges = false;
        view.setSavedState(true);
    },

    downloadRulesExcel: function () {
        var view = this.parentView;
        view.serverCall({
            method: 'DownloadRulesExcel',
            success: function (url) {
                if (Ext.isEmpty(url)) return;
                KS.openUrl(url);
            }
        })
    },

    showFileChooserPanel: function () {
        var view = this.parentView || this;
        view.uploadExcelBtn = KS.create({
            type: 'filefield',
            parentView: this,
            itemId: 'uploadExcelBtn'
        },
        {
            buttonConfig: {
                tooltip : 'Загрузить файл',
                iconCls: 'ks-icon-folder_open',
                text: ''
            },
            multiple: false,
            buttonOnly: true,
            width: 26,
            callback: view.saveFiles
        });

        view.fileChooserPanel = new Ext.panel.Panel({
            bodyPadding: '5 0 5 0',
            layout: {
                type: 'hbox',
                align: 'begin'
            },
            items: [
                {
                    xtype: 'textfield',
                    itemId: 'excelFileName',
                    value: 'Выберите файл...',
                    margin: '0 0 0 3',
                    readOnly: true
                },
                view.uploadExcelBtn
            ]
        });

        view.fileChooserWin = KS.showModal(view.fileChooserPanel, {
            title: 'Выбор файла',
            autoHeight: false,
            resizable: false,
            maximizable: false,
            width: 220,
            minWidth: 220,
            height: 110,
            minHeight: 110,
            buttonAlign: 'center',
            buttons: [{
                text: 'ОК',
                cls: 'dim-button',
                handler: function() {
                    view.fileChooserWin.close();

                    if(view.excelFileKey) {
                        KS.confirm('Сохранить правила?', 'Загрузка правил', function (btn) {
                            if (btn !== 'yes') return;
                            view.uploadRulesExcel();
                        });
                    }
                }
            }]
        }, true);
    },

    uploadRulesExcel: function () {
        var view = this;
        view.serverCall({
            method: 'UploadRulesExcel',
            params: [view.excelFileKey],
            waitMessage: 'Загрузка правил...',
            success: function(hasErrors) {
                if (!hasErrors) {
                    view.getToolbarItem(view.checkSumsExcelEditPanel, null, 'SAVE').setDisabled(true);
                    view.hasChanges = false;
                    KS.alert('Правила сохранены.', 'Загрузка правил');
                }
            }
        });
    },

    saveFiles: function (fileKeys) {
        var view = this.parentView || this;

        if (!Ext.isEmpty(fileKeys)) {
            var fileKey = fileKeys[0];
        }

        var fileExtension = fileKey.fileExtension;
        if (fileExtension !== '.xlsx') {
            KS.alert('Тип файла ' + fileExtension + ' не разрешен для загрузки. Разрешенный тип: .xlsx');
            return;
        }

        var fileNameField = view.fileChooserPanel.getComponent('excelFileName');
        if (fileNameField)
            fileNameField.setValue(fileKey.fileName + fileExtension);

        view.excelFileKey = fileKey;

        view.touch();
    }
});

if (typeof(Sys) !== 'undefined') Sys.Application.notifyScriptLoaded();