////////////////////////////////////////////////////////////////////////////////
// Viewport tools
KS.apply(KS, {    
    queueCheckRedirects: function() {
        var v, n;
        for (n = 0; n < KS.ajaxResultQueue.length; n++) {
            v = KS.ajaxResultQueue[n];
            if (v.action == 1) {
                if (v.params?.[2] === true)
                    KS.isRedirectedWithLogout = true;
                
                if (typeof (WorkspaceView) !== 'undefined')
                    WorkspaceView.askLeavePage(false);
                if (v.params.length > 1 && v.params[1]) {
                    if (KS.Ajax.pingTimer)
                        clearInterval(KS.Ajax.pingTimer);
                    KS.alert(v.params[1], KS.L10n.serverMessage, function() { window.location = v.params[0]; });
                } else
                    window.location = v.params[0];
                return true;
            }
        }
        return false;
    },

    queueCheckRepeat: function(request) {
        var v, n;
        for (n = 0; n < KS.ajaxResultQueue.length; n++) {
            v = KS.ajaxResultQueue[n];
            if (v.action == 18) {
                KS.ajaxResultQueue.splice(n, 1);
                if (v.params.length >= 1 && v.params[0])
                    KS.log('Request repeat: ' + KS.describeException(v.params));
                else
                    KS.log('Request repeat');
                return true;
            }
            if (v.action == 23) {
                KS.ajaxResultQueue.splice(n, 1);
                KS.MacroManager.repeatCurrentStep(request, v.params);
                return 23;
            }
        }
        return false;
    },

    // true - найдены редиректы
    queueExecuteActions: function(ajax) {
        var field, pid, v, m, n, p, d, taskName, 
            viewContext = KS;

        if (KS.queueCheckRedirects())
            return true;
        
        if (KS.maskOnlyTaskCaller && ajax && ajax.viewContext) {
            viewContext = ajax.viewContext;
        }

        while (KS.ajaxResultQueue.length > 0) {
            var task = KS.ajaxResultQueue[0];

            TRACE('Executing action: ' + KS._getActionDesc(task), 'queue');

            KS.ajaxResultQueue.splice(0, 1);
            switch (task.action) {
                // UpdatePanel                
                case 2:
                    {
                        if (KS.netCore) {
                            viewContext.pleaseWait.apply(viewContext, [KS.L10n.waitMessage]);
                            var url = location.href; //.replace(/#/g, '');
                            var hashIndex = url.search(/#.*/);
                            var hash = hashIndex !== -1 ? url.slice(hashIndex) : '';
                            url = url.replace(/#.*/, '');
                            if (url.indexOf("?") < 0) url = url + '?';
                            url = url.replace("?", "/Update?container=" + task.container + "&");
							url = url + "&dt=" + new Date().getTime();
                            url += hash;
                            $.ajax({
                                type: "GET",
                                url: url,
                                success: function(result) {
                                    result.ajaxResult = JSON.parse(result.ajaxResult);
                                    for (var scIdx = 0; scIdx < result.viewScripts.length; scIdx++) {
                                        eval(result.viewScripts[scIdx]);
                                    }
                                    for (var upIdx = 0; upIdx < result.updatedPanels.length; upIdx++) {
                                        var updatedPanel = result.updatedPanels[upIdx],
                                            panelId = updatedPanel.ID;
                                        $("#" + panelId).empty();
                                        for (var hfIdx = 0; hfIdx < updatedPanel.Controls.length; hfIdx++) {
                                            var hiFi = updatedPanel.Controls[hfIdx];
                                            $('<input>').attr({
                                                type: 'hidden',
                                                id: hiFi.ID,
                                                name: hiFi.ID,
                                                value: hiFi.Value
                                            }).appendTo("#" + panelId);
                                        }
                                        KS._syncPanel(panelId);
                                    }
                                    viewContext.stopWaiting();
                                    KS.ajaxResultQueue = KS.ajaxResultQueue.concat(result.ajaxResult.actions);
                                    KS.queueExecuteActions(null);
                                },
                                error: function(){
                                    KS.error('Update error!');
                                }
                            });
                        }
                        else {
                            var prm = Sys.WebForms.PageRequestManager.getInstance();
                            if (!prm.get_isInAsyncPostBack()) {
                                KS.waitPanelUpdate = true;
                                KS.pleaseWait.apply(KS, [KS.L10n.waitMessage]);
                                prm._doPostBack(task.container + '_u', "");
                            } else {
                                // вставляем обратно в очередь
                                KS.ajaxResultQueue.splice(0, 0, task);
                                TRACE('Skipping action because already is in async postback', 'queue');
                            }
                        }
                        return false;
                    }
                    // ChangeViewID               
                case 3:
                    {
                        var newid = task.params[0];
                        field = document.getElementById(task.container + '_instance');
                        var view = eval(field.value);
                        var oldKey = view.viewID;
                        for (var oldid in KS.registeredViews) {
                            if (KS.registeredViews[oldid].viewID == oldKey)
                                delete KS.registeredViews[oldid];
                        }
                        view.viewID = newid;
                        KS.registeredViews[newid] = view;
                        KS.changeDependencyKey(oldKey, newid);
                        break;
                    }
                    // SelectedEvent
                case 4:
                    field = eval(document.getElementById(task.container + '_instance').value);
                    field.onValuesSelected.apply(field, [task.params]);
                    break;
                // UpdateEvent                
                case 5:
                    field = eval(document.getElementById(task.container + '_instance').value);
                    field.onUpdateData.apply(field, [task.params]);
                    break;
                // ReloadEvent                
                case 6:
                    field = eval(document.getElementById(task.container + '_instance').value);
                    if (!field._closing)
                        field.onReloadData.apply(field, [task.params]);
                    break;
                // CustomEvent                
                case 7:
                    field = document.getElementById(task.container + '_instance').value;
                    var i = eval(field);

                    m = task.params[0];
                    if (m == null || m.length == 0) {
                        KS.error(KS.L10n.clientEventNotFound);
                        break;
                    }

                    if (m in i) {
                        KS.defer(i[m], task.params.slice(1), i, 1);
                    } else
                        KS.error(null, null, null, KS.L10n.eventHandler + ' "' + m + '" ' + KS.L10n.clientDisplayNotDefined + ' "' + field + '"');

                    break;
                // AddDependentViews                
                case 8:
                    pid = task.params[0];
                    v = KS.getView(pid);
                    if (v) {
                        var check = function(id) {
                            var dv;
                            for (dv = 0; dv < v.dependentViews.length; dv++) {
                                if (v.dependentViews[dv] == id) return true;
                            }
                            return false;
                        };

                        for (n = 1; n < task.params.length; n++) {
                            var dep = task.params[n];
                            if (check(dep)) continue;
                            v.dependentViews.push(dep);
                            var depView = KS.getView(dep);
                            if (depView)
                                depView.masterView = pid;
                        }
                        v.onDependentChanged.apply(v);
                    } else {
                        KS.error(null, null, null, KS.L10n.parentDisplayNotFound + ' "' + pid + '".');
                    }
                    break;
                // RemoveDependentViews                
                case 9:
                    pid = task.params[0];
                    v = KS.getView(pid);

                    if (v) {
                        for (n = 1; n < task.params.length; n++) {
                            for (d = 0; d < v.dependentViews.length; d++) {
                                if (v.dependentViews[d] == task.params[n])
                                    v.dependentViews.splice(d, 1);
                            }
                        }
                        v.onDependentChanged.apply(v);
                    } else {
                        KS.error(null, null, null, KS.L10n.parentDisplayNotFound + ' "' + pid + '".');
                    }

                    break;
                // DropView                
                case 10:
                    field = eval(document.getElementById(task.container + '_instance').value);
                    if (KS.isDefined(field))
                        field.drop.apply(field);
                    break;
                // ActivateView      
                case 11:
                    var el = document.getElementById(task.container + '_instance');
                    if (el && el.value) {
                        field = eval(el.value);
                        if (field) {
                            field.activate.apply(field);
                        }
                    }
                    break;
                // MacroSequence         
                case 12:
                    var sequence = new KS.MacroSequence(task.params[0]);
                    KS.MacroManager.executeNextStep(sequence);
                    break;
                // ExecuteTask         
                case 13:
                    taskName = task.params[0];
                    p = task.params.slice(1);
                    if (taskName in KS.clientTasks) {
                        setTimeout(function() {
                            KS.clientTasks[taskName].fn(new KS.MacroSequence(p[0]));
                        }, 0);
                    } else
                        throw KS.L10n.taskNotFound + " " + taskName;
                    break;
                // CloseView       
                case 14:
                    var el = document.getElementById(task.container + '_instance');
                    if (el && el.value) {
                        field = eval(el.value);
                        if (field)
                            field.drop.apply(field);
                    }
                    break;
                // Refresh     
                case 15:
                    field = eval(document.getElementById(task.container + '_instance').value);
                    field.onRefresh.apply(field, [task.params]);
                    break;
                // MessageBox     
                case 16:
                    KS.alert(task.params[0], task.params[1]);
                    break;
                // ErrorBox     
                case 17:
                    KS.error(task.params[0], task.params[1], null, task.params[2]);
                    break;
                // ConsoleOutput     
                case 19:
                    KS.log(task.params[0], task.params[1] || 'console');
                    break;
                // ExecuteClientMethod 
                case 20:
                    taskName = task.params[0];
                    p = task.params.slice(1);
                    m = KS.clientTasks[taskName];
                    if (KS.isValid(m) && typeof (m.fn) === 'function')
                        KS.defer(m.fn, p, m, 0);
                    else
                        throw KS.L10n.taskNotFound + " " + taskName;
                    break;
                // FatalRefresh 
                case 21:
                    KS.confirm(KS.L10n.fatalError, KS.L10n.actionConfirmation,
                    function(btn) {
                        if (btn != 'yes') return;
                        WorkspaceView.askLeavePage(false);
                        location.reload();
                    });
                    break;
                // MethodQueued
                case 22:
                    if (ajax && task.params.length >= 1 && task.params[0]) {
                        var taskID = task.params[0];
                        if (KS.isValid(ajax.viewContext))
                            ajax.onBackground.apply(ajax.viewContext, [taskID]);
                        else
                            ajax.onBackground(taskID);
                        ajax.backgroundCalled = 1;
                    }
                    break;
                default:
                    //#ifdef DEBUG
                    // Unknown server message
                    debugger;
                    //#else
                    throw KS.L10n.unknownServerMessage;
                    //#endif
            }
        } // while

        return false;
    }
});