﻿UniDictTreeView2 = KS.extend(BaseDictionaryView, {
    constructor: function(viewId) {
        UniDictTreeView2.superclass.constructor.call(this, viewId);
    },

    onTemplateRendered: function () {
    },

    select: function () {
        var view = this.parentView || this;
        view.disable();
        var selNodeId = view.tree.getSelNodeId(); 
        view.serverCall({
            method: 'EndSelection',
            params: [[selNodeId], [], view.getAdditionalParams()],
            success: function (ok) {
                if (ok) {
                    view.destroyContainerItems();
                } else {
                    view.enable();
                }
            },
            error: view.enable
        });
    },

    resetView: function () {
        this.tree.getRootNode().removeAll(true);
        this.tree.fullReload();
    },
    
    showSystemJournal: function() {
        var view = this.parentView || this;
        var node = view.tree.getSelNode();
        view.serverCall({
            method: 'ShowSystemJournal',
            params: [node ? node.id : null]
        });
    },

    printTreeToExcel: function() {
        var view = this.parentView;
        var treeId = view.tree.itemId;
        view.serverCall({
            method: 'ExportToExcel',
            waitMessage: 'Формирование документа Excel ...',
            params: [treeId, '', '', '', {}],
            success: view.openUrl
        });
    },

    searchTree: "tree"
});

if (typeof(Sys) !== 'undefined') Sys.Application.notifyScriptLoaded();