﻿ToolbarAccessView =  KS.extend(BaseSvodView, { });
var sc = ToolbarAccessView.superclass;

// ============= COMMON =======================
(function(viewClass) {
    KS.apply(viewClass,
        {
            touch: function () {
                this.hasChanges = true;
                this.setSavedState(false);
                this.getToolbarItem(this.rootPanel, "bottom", 'APPLY').setDisabled(false);
            },
            
            discardChanges: function () {
                this.hasChanges = false;
                this.setSavedState(true);
                this.getToolbarItem(this.rootPanel, "bottom", 'APPLY').setDisabled(true);
            },

            doSaveChanges: function(needRefreshTree) {
                var view = this;
                view.serverCall({
                    method: 'SaveChanges',
                    params: [needRefreshTree],
                    success: function(result) {
                        if (result) {
                            view.discardChanges();
                            if (needRefreshTree) {
                                view.objectTree.getRootNode().removeAll(true);
                                view.objectTree.fullReload();
                            }
                        }
                    }
                });
            },

            okBtnClick: function() {
                var view = this.parentView;
                if (view.hasChanges) {
                    view.doSaveChanges(false);
                }
                view.close();
            },

            exitBtnClick: function() {
                this.parentView.close();
            },

            applyBtnClick: function() {
                var view = this.parentView;
                view.doSaveChanges(true);
            },

            treeNodeCheck: function(node, checkState) {
                var nodeId = node.data.id;
                this.serverCall({
                    method: 'TreeCheckChange',
                    disableFog: true,
                    params: [nodeId, checkState],
                    success: this.touch
                });
            }
        });
}(ToolbarAccessView.prototype));

if (typeof(Sys) !== 'undefined') Sys.Application.notifyScriptLoaded();