TemplateManagerView = KS.extend(KS.Ext.ClientView, {
    customName: 'TemplateManagerView'
});

// ================ COMMON ====================
(function (viewClass) {
    KS.apply(viewClass, {
        onTemplateRendered: function () {
            var view = this;
            view.rendered = true;
        },

        doLoadSpreadsheetView: function () {
            var view = this;
            view.serverCall({
                method: 'DoLoadSpreadsheetView'
            });
        },

        addChildView: function (panel) {
            if (!this.templateSpreadsheetPanel) {
                // Parent view is not ready, render child later
                if (!this.deferredAddChildViews) {
                    this.deferredAddChildViews = [];
                }
                this.deferredAddChildViews.push(panel);

                if (this.deferredSpreadsheetActions && this.deferredSpreadsheetActions.length !== 0) {
                    Ext.each(this.deferredSpreadsheetActions, function (deferredAction) {
                        deferredAction();
                    });
                }

                return true;
            }

            panel.header = false;
            if (this.templateSpreadsheetPanel) {
                this.templateSpreadsheetPanel.removeAll();
                this.templateSpreadsheetPanel.add(panel);
                var childView = eval(panel.classInstance);
                if (childView) {
                    this.childViews = [childView];
                    this.spreadsheetView = childView;
                    childView.parentView = this;
                }
                KS.updateLayout(this.templateSpreadsheetPanel);
                this.templateSpreadsheetPanel.unmask();
                return true;
            }

            return false;
        }
    });
}(TemplateManagerView.prototype));

// =============== TOOLBAR ====================
(function (viewClass) {
    KS.apply(viewClass, {
        openTemplate: function() {
            var view = this.parentView || this;
            var selection = view.templatesGrid.getSelection();

            if (Ext.isEmpty(selection)) return;

            var selectedLink = selection[0].get('link');
            view.currentTemplateName = KS.Grid.getAnyCase(selection[0], 'name');
            view.serverCall({
                method: 'OpenSelectedTemplate',
                params: [selectedLink],
                success: view.afterDocumentCreated
            });
        },

        openTemplateByName: function (name) {
            var view = this.parentView || this;
            view.currentTemplateName = name;
            view.serverCall({
                method: 'OpenTemplateByName',
                params: [name],
                success: view.afterDocumentCreated
            });
        },

        refreshTemplates: function () {
            var view = this.parentView || this;
            view.refreshTemplatesGrid();
        },

        deleteSelectedTemplates: function () {
            var view = this.parentView || this,
                selected = view.templatesGrid.getSelection(),
                templateNames = [];

            Ext.each(selected, function (record) {
                templateNames.push(record.data.NAME);
            });

            KS.confirm('Вы уверены, что хотите удалить выбранные шаблоны?', 'Подтвердите удаление', function(btn) {
                if (btn === 'yes') {
                    view.doDeleteTemplates(templateNames);
                }
            });
        },

        doDeleteTemplates: function (templateNames) {
            var view = this;
            view.serverCall({
                method: 'DeleteSelectedTemplates',
                params: [templateNames],
                success: function (isDeleted) {
                    if (isDeleted) {
                        KS.alert('Выбранные шаблоны успешно удалены');
                        view.templatesGrid.reload();
                    }
                    else {
                        KS.alert('Не удалось удалить шаблоны');
                    }
                }
            })
        },

        afterDocumentCreated: function (documentPath) {
            var view = this;
            if (!view.spreadsheetView) {
                view.doLoadSpreadsheetView(); // функция не гарантирует загрузку представления в success колбэке
                view.deferredSpreadsheetActions = []; // поэтому действия к spreadsheetView деферятся
                view.deferredSpreadsheetActions.push((function () {
                    view.spreadsheetView.openNewDocument(documentPath);
                }).bind(view));
            } else {
                view.spreadsheetView.openNewDocument(documentPath);
            }
        },

        saveAndUploadTemplate: function () {
            var view = this.parentView || this;
            if (view.isNewTemplate) {
                view.askForTemplateName();
            }
            else {
                var templateName = view.currentTemplateName;
                view.showTemplateExistsModal(templateName);
            }
        },

        showTemplateExistsModal: function (templateName) {
            var view = this;
            Ext.create('Ext.window.Window', {
                title: 'Внимание!',
                width: 400,
                height: 150,
                layout: {
                    type: 'hbox',
                    align: 'center',
                    pack: 'center'
                }, 
                buttons: [{
                    text: 'Перезаписать',
                    handler: function () {
                        view.spreadsheetView.saveDocument(view.uploadTemplateToServer, view);
                        this.up('window').close();
                    }
                }, {
                    text: 'Переименовать',
                    handler: function () {
                        view.renameTemplateModal(templateName);
                        this.up('window').close();
                    }
                }, {
                    text: 'Отмена',
                    handler: function () {
                        this.up('window').close();
                    }
                }],
                items: [
                    {
                        xtype: 'image',
                        x: 10,
                        y: 10,
                        width: 32,
                        height: 32,
                        src: KS.infoImage
                    },
                    {
                        xtype: 'panel',
                        html: "В базе уже имеется шаблон с именем '" + templateName + "'.",
                        bodyStyle: 'background: none; border: none;',
                        margin: '0 0 0 10'
                    }]
            }).show();
        },

        renameTemplateModal: function (name) {
            var view = this.parentView || this;
            var panel = Ext.create('Ext.window.Window', {
                title: 'Введите новое имя шаблона',
                width: 400,
                height: 100,
                layout: {
                    type: 'hbox',
                    align: 'center',
                    pack: 'center'
                },
                buttons: [{
                    text: 'Ок',
                    handler: function () {
                        var templateName = Ext.getCmp('newTemplateNameCmp').getValue();
                        view.getTempPathForNewDocument(templateName, true);
                        panel.close();
                    }},
                    {
                    text: 'Отмена',
                    handler: function () {
                        panel.close();
                    }}
                ],
                items: { 
                    xtype: 'textfield',
                    id: 'newTemplateNameCmp',
                    value: name,
                    width: 380,
                    height: 25
                }
            }).show();
        },

        uploadTemplateToServer: function () {
            var view = this;
            view.serverCall({
                method: 'UploadTemplateToServer',
                success: view.afterUploadTemplate
            });
        },

        uploadRenamedTemplate: function () {
            var view = this;
            view.serverCall({
                method: 'UploadRenamedTemplate',
                success: view.afterUploadTemplate
            });
        },

        afterUploadTemplate: function (result) {
            var view = this;
            if (result.isSuccess) {
                view.isNewTemplate = false;
                KS.alert('Шаблон успешно загружен');
                view.templateLoadBtn.setDisabled(true);
            }
            else {
                var message = !Ext.isEmpty(result.message) ? '<br>' + result.message : '';
                KS.alert('Не удалось загрузить шаблон. ' + message);
            }
        },

        downloadTemplateFile: function () {
            var view = this.parentView || this;

            var selectedLink = view.templatesGrid.getSelection()[0].get('link');
            view.serverCall({
                method: 'DownloadTemplateFile',
                params: [selectedLink],
                success: function (url) {
                    KS.openUrl(url);
                }
            });
        },

        chooseTemplateScriptLang: function () {
            var view = this.parentView || this;

            Ext.MessageBox.show({
                title: 'Выгрузка шаблона в скрипт',
                message: 'Выгрузить шаблон в',
                buttons: Ext.Msg.YESNOCANCEL,
                buttonText: {
                    yes: 'SQL-скрипт',
                    no: 'PostgreSQL-скрипт'
                },
                callback: function (btn) {
                    if (btn === 'cancel') return;
                    view.downloadTemplateScript(btn === 'yes');
                }
            });
        },

        downloadTemplateScript: function (isSql) {
            var view = this;
            var selectedLink = view.templatesGrid.getSelection()[0].get('link');
            var diffFiles = false;
            view.serverCall({
                method: 'DownloadTemplateScript',
                params: [isSql, selectedLink, diffFiles],
                success: function (url) {
                    if (url) {
                        KS.openUrl(url);
                    }
                }
            });
        },

        importTemplates: function () {
            var view = this.parentView || this;
            view.serverCall({
                method: 'GetTemplateImportPanel',
                success: function (panel) {
                    if (Ext.isEmpty(panel)) return;
                    view.importTemplatePanel = view.createTemplateControl(panel, 'importTemplatePanel');
                    view.addPanelItems(panel, view.importTemplatePanel);
                    view.importTemplateWin = KS.showModal(view.importTemplatePanel, {
                        title: 'Загрузка шаблона...',
                        autoHeight: false,
                        height: 20,
                        width: 80,
                        layout: {
                            type: 'hbox',
                            align: 'center',
                            pack: 'center'
                        },
                        buttonAlign: 'left',
                        buttons: ['->',
                            {
                                text: 'ОК',
                                cls: 'dim-button',
                                handler: function () {
                                    view.doImportTemplates(view.templateKeys);
                                }
                            }, { xtype: 'tbspacer', width: 8 },
                            {
                                text: 'Отмена',
                                cls: 'dim-button',
                                handler: function () {
                                    view.importTemplateWin.close();
                                }
                            }]
                    }, true);
                }
            })
        },

        saveFiles: function (fileKeys, smth, fileField) {
            var view = this.parentView;

            if (Ext.isEmpty(view.templateKeys)) {
                view.templateKeys = [];
            }

            Ext.each(fileKeys, function (key) {
                if (key.fileExtension === '.xlt'){
                    view.templateKeys.push(key);
                }
            });

            fileField.setRawValue(fileKeys[0].fileName + fileKeys[0].fileExtension);
        },

        doImportTemplates: function(fileKeys) {
            var view = this;
            view.serverCall({
                method: 'ImportTemplates',
                params: [fileKeys],
                waitMessage: 'Сохранение ...',
                success: function (isLoaded) {
                    if (isLoaded) {
                        KS.alert('Шаблон успешно загружен');
                        view.templatesGrid.reload();
                    }
                    else {
                        KS.alert('Не удалось загрузить шаблон');
                    }

                    view.importTemplateWin.close();
                }
            });
        },

        createNewTemplate: function () {
            var view = this.parentView || this;
            view.isNewTemplate = true;
            view.doLoadSpreadsheetView();
        },

        askForTemplateName: function () {
            var view = this;
            KS.prompt('Введите имя шаблона', 'Создание шаблона', 'shablon', view.setNewTemplateName.bind(view));
        },

        setNewTemplateName: function (templateName, isRenamed) {
            var view = this;

            if (Ext.isEmpty(templateName))
                return;

            view.getTempPathForNewDocument(templateName, isRenamed);
        },

        getTempPathForNewDocument: function (templateName, isRenamed) {
            var view = this;
            view.serverCall({
                method: 'GetTempPathForNewDocument',
                params: [templateName],
                success: function (tempFileKey) {
                    if (isRenamed) {
                        view.spreadsheetView.saveDocumentCopy(tempFileKey, view.uploadRenamedTemplate, view);
                    }
                    else {
                        view.spreadsheetView.saveDocumentCopy(tempFileKey, view.uploadTemplateToServer, view);
                    }
                }
            });
        }
    });
}(TemplateManagerView.prototype));

// ================ GRID ======================
(function (viewClass) {
    KS.apply(viewClass, {
        refreshTemplatesGrid: function () {
            var view = this;
            view.templatesGrid.reload();
        },

        templateSelectionChange: function (sm, selection) {
            var view = this;
            var deleteButton = view.getToolbarItem(view.templatesGrid, null, 'DELETE_TEMPLATE');
            deleteButton.setDisabled(selection.length === 0);
        }
    });
}(TemplateManagerView.prototype));

// ============= SPREADSHEET ==================
(function (viewClass) {
    KS.apply(viewClass, {
        onSpreadsheetDocumentChanged: function (s, e) {
            var view = this;
            var spreadsheetState = s.getSpreadsheetState();
            view.templateLoadBtn.setDisabled(false);
        }
    });
}(TemplateManagerView.prototype));

if (typeof(Sys) !== 'undefined') Sys.Application.notifyScriptLoaded();