﻿SvodAdmUpdateView = KS.extend(BaseSvodView, {
    customName: 'SvodAdmUpdateView'
});

// ================ COMMON ====================
(function (viewClass) {
    KS.apply(viewClass, {
        isPollingMaskSet: false,

        onTemplateRendered: function () {
            var view = this;
            view.tuneScriptsGridColumns();
            view.beginConnect();
        },

        gridRerender: function () {
            var view = this,
                grid = view.scriptsGrid;

            grid.getView().refresh();
        },

        setProtocol: function (protocol) {
            if (Ext.isEmpty(protocol)) return;
            this.protocolPanel.setHtml(protocol);
        },

        getSkippedScripts: function () {
            var view = this;

            var grid = view.scriptsGrid,
                skippedColName = 'SKIP',
                codeColName = 'ID',
                scriptRecords = [];

            grid.store.each(function (rec) {
                var checked = grid.getAnyCase(rec, skippedColName);
                if (checked)
                    scriptRecords.push(grid.getAnyCase(rec, codeColName));
            });

            return scriptRecords;
        },

        getScriptIdsToNotUpdate: function () {
            var view = this;

            if (!view.updateToThisRecord)
                return [];

            var scriptIdsToNotUpdate = [],
                gotCheckedUpdateToCol = false,
                store = view.scriptsGrid.getStore();

            store.each(function (record) {
                if (gotCheckedUpdateToCol) {
                    scriptIdsToNotUpdate.push(record.get('ID'));
                    return;
                }

                if (record.get('UPDATE_TO') === true)
                    gotCheckedUpdateToCol = true;
            });

            return scriptIdsToNotUpdate;
        },

        tuneScriptsGridColumns: function (){
            var view = this;
            view.scriptsGrid.eachColumnCfg(function(column){
                if (column.renderer === skipScriptRenderer) {
                    // Удаляем платформенный checkchange из renderer.js
                    column.clearListeners();
                    column.on({
                        beforecheckchange: view.checkIsAllowedToSkipScript
                    });
                }
                else if (column.renderer === updateToThisRenderer) {
                    column.on({
                        beforecheckchange: view.beforeCheckUpdateTo,
                        checkchange: view.toggleUpdateToCheckbox
                    });
                }
            })
        },

        checkIsAllowedToSkipScript: function (cmp, td, cellIndex, record, tr, rowIndex, e) {
            var allowSkip = KS.Grid.getAnyCase(record, "ALLOW_SKIP");
            return Ext.isBoolean(allowSkip) ? allowSkip : false;
        },

        toggleUpdateToCheckbox: function (cmp, rowIndex, checked, record, e) {
            var view = this.ownerCt.ownerCt.parentView;

            if (checked)
                view.updateToThisRecord = record;
            else
                delete view.updateToThisRecord;

            view.gridRerender();
        },

        beforeCheckUpdateTo: function (cmp, td, cellIndex, record, tr, rowIndex, e) {
            var view = this.ownerCt.ownerCt.parentView;

            var updateToAlreadyChecked = view.updateToThisRecord ? view.updateToThisRecord !== record : false;
            return !updateToAlreadyChecked;
        },

        toggleUpdateDbButton: function (shouldDisable) {
            var updateBtn = Ext.ComponentQuery.query('button[ctrlId=updateDbBtn]')[0];
            updateBtn.setDisabled(shouldDisable);
        },

        gridGetRowClass: function(record) {
            var executed = KS.Grid.getAnyCase(record, 'EXECUTED');
            if (executed) {
                return ' update-scripts-grid-lightgreen';
            }

            return '';
        },

        showPopupStringEditor: function (scriptId, dataIndex, title) {
            var view = this;
            var record = this.scriptsGrid.findRecord(scriptId, 'ID');
            var value = KS.Grid.getAnyCase(record, dataIndex);
            view.pseWin = KS.showModal({
                xtype: 'textarea',
                itemId: 'pseArea',
                value: value,
                readOnly: true
            }, {
                layout: 'fit',
                plain: true,
                frame: true,
                autoScroll: true,
                modal: true,
                maximizable: true,
                minWidth: 400,
                minHeight: 300,
                width: Math.max(400, KS.rootViewport.getWidth() / 2),
                height: Math.max(300, KS.rootViewport.getHeight() / 1.5),
                title: title,
                buttonAlign: 'right',
                buttons: new Array({
                    text: 'Закрыть',
                    cls: 'marked-button',
                    handler: function () {
                        view.pseWin.close(true);
                    }
                })
            }, true);
        },

        showScriptProtocol: function (scriptId) {
            var view = this;
            view.serverCall({
                method: 'GetScriptProtocol',
                params: [scriptId],
                success: function (html) {
                    if (Ext.isEmpty(html)) {
                        html = 'Пусто';
                    }

                    KS.showHtmlProtocol(html);
                }
            });
        },

        maskPolling: function (scriptsCountExecuted, scriptsCountAll) {
            var view = this;

            view.isPollingMaskSet = true;

            var waitMessage = 'Выполняется обновление...';

            if (!Ext.isEmpty(scriptsCountExecuted) && !Ext.isEmpty(scriptsCountAll)) {
                waitMessage += ` Выполнено: ${scriptsCountExecuted} из ${scriptsCountAll}`;
            }

            view.mainPanel.mask(waitMessage);
        },

        unmaskPollingIfSet: function () {
            var view = this;

            if (view.isPollingMaskSet) {
                view.mainPanel.unmask();
                view.isPollingMaskSet = false;
            }
        },
    });
}(SvodAdmUpdateView.prototype));

// ================ AJAX ====================
(function (viewClass) {
    KS.apply(viewClass, {
        beginConnect: function () {
            var view = this.parentView || this;
            view.serverCall({
                method: 'BeginConnect',
                success: view.processConnectResult
            });
        },

        processConnectResult: function (connectResult) {
            var view = this;

            if (Ext.isEmpty(connectResult))
                return;

            if (connectResult.protocol) {
                view.setProtocol(connectResult.protocol);
                view.scriptsGrid.reload();
            }

            var disableBtn = connectResult.scriptsToExecuteCount <= 0;
            view.toggleUpdateDbButton(disableBtn);
        },

        checkForUpdates: function () {
            var view = this.parentView || this;
            view.serverCall({
                method: 'CheckForUpdates',
                success: function (protocol) {
                    if (protocol) {
                        view.setProtocol(protocol);
                        view.scriptsGrid.reload();
                    }
                }
            });
        },

        toggleExecutedScripts: function () {
            var view = this.parentView || this;
            view.showedExecutedScripts = this.pressed;
            view.serverCall({
                method: 'ToggleExecutedScripts',
                params: [view.showedExecutedScripts],
                success: function () {
                    view.scriptsGrid.reload();
                }
            });
        },

        updateFromKeysystemsService: function () {
            var view = this.parentView || this;
            view.serverCall({
                method: 'UpdateFromKeysystemsService',
                success: view.processConnectResult
            });
        },

        updateDatabase: function () {
            var view = this.parentView,
                skippedScripts = view.getSkippedScripts(),
                scriptIdsToNotUpdate = view.getScriptIdsToNotUpdate();

            view.serverCall({
                method: 'UpdateDb',
                params: [skippedScripts, scriptIdsToNotUpdate],
                waitMessage: 'Выполняется обновление...',
                success: view.showUpdateDbProtocol
            });
        },

        updateDatabasePolling: function () {
            var view = this.parentView,
                skippedScripts = view.getSkippedScripts(),
                scriptIdsToNotUpdate = view.getScriptIdsToNotUpdate();

            var scriptsCountAll = view.scriptsGrid.getStore().getCount() - skippedScripts.length - scriptIdsToNotUpdate.length;
            var scriptsCountExecuted = 0;

            view.unmaskPollingIfSet();
            view.maskPolling(scriptsCountExecuted, scriptsCountAll);

            view.serverCall({
                method: 'UpdateDb',
                params: [skippedScripts, scriptIdsToNotUpdate],
                timeout: 50000,
                disableFog: true,
                success: view.showUpdateDbProtocol,
                delay: function () {
                    view.checkUpdateProgress(scriptsCountAll);
                }
            });
        },

        checkUpdateProgress: function (scriptsCountAll) {
            var view = this;
            view.serverCall({
                method: 'CheckUpdateProgress',
                disableFog: true,
                success: function (updateStatus) {
                    view.checkUpdateProgressCallback(updateStatus, scriptsCountAll);
                }
            });
        },

        checkUpdateProgressCallback: function (updateStatus, scriptsCountAll) {
            var view = this;

            if (!updateStatus)
                return;

            if (updateStatus.updateCompleted === true) {
                view.showUpdateDbProtocol(updateStatus.protocol);
            } else {
                view.unmaskPollingIfSet();
                view.maskPolling(scriptsCountAll - updateStatus.scriptsLeft, scriptsCountAll);

                view.progressTimerId = setTimeout(function () {
                    view.checkUpdateProgress(scriptsCountAll);
                }, 5000);
            }

            // view.gridRerender(); // т.к. store не обновленный, не покрасит зеленым скрипты
        },

        showUpdateDbProtocol: function(protocol) {
            var view = this;
            view.toggleUpdateDbButton(true);
            view.setProtocol(protocol);
            view.scriptsGrid.reload();

            view.unmaskPollingIfSet();
        },

        unlockUpdateBlock: function () {
            var view = this;
            view.serverCall({
                method: 'UnlockUpdateBlock',
                waitMessage: 'Снятие блокировки обновлений...',
            });
        }
    });
}(SvodAdmUpdateView.prototype));

// =========== SYSTEM HANDLERS ==============
(function (viewClass) {
    KS.apply(viewClass, {
        onBeforeClose: function () {
            var view = this;
            view.unlockUpdateBlock();
            view.stopProgressTimer();
            return SvodAdmUpdateView.superclass.onBeforeClose.call(view);
        },

        stopProgressTimer: function () {
            if (this.progressTimerId)
                clearInterval(this.progressTimerId);
        },
    });
}(SvodAdmUpdateView.prototype));

function skipScriptRenderer(value, metadata, record, rowIndex, colIndex, store) {
    var allowSkip = KS.Grid.getAnyCase(record, "ALLOW_SKIP");

    if (!allowSkip)
        metadata.css += " ks-cell-disabled";

    return Ext.grid.column.Check.prototype.defaultRenderer.apply(this, arguments);
}

function updateToThisRenderer(value, metadata, record, rowIndex, colIndex, store) {
    var view = KS.findSingleView('customName', 'SvodAdmUpdateView');

    if (view.showedExecutedScripts) {
        metadata.css += " ks-cell-disabled";
        return '';
    }

    if (view.updateToThisRecord && view.updateToThisRecord !== record) {
        metadata.css += " ks-cell-disabled";
        return '';
    }

    return Ext.grid.column.Check.prototype.defaultRenderer.apply(this, arguments);
}

function changeFilterCell(viewId, oper, closeCode, gridId) {
    var view = KS.getView(viewId);
    if (view)
        view.changeFilterCell(oper, closeCode, gridId);
}

function showWindowPopupEditor(viewId, scriptId, dataIndex, title) {
    var view = KS.getView(viewId);
    if (view)
        view.showPopupStringEditor(scriptId, dataIndex, title);
}

function showProtocolEditor(viewId, scriptId) {
    var view = KS.getView(viewId);
    if (view)
        view.showScriptProtocol(scriptId);
}

function showWindowPopupRenderer(viewId, renderedValue, scriptId, dataIndex, title) {
    var rightBtnStyle = 'width: 16px; height: 16px; display: block; vertical-align: middle; position: absolute; top: 0; bottom: 0; margin: auto 0; right: 0;';
    var onClickParams = `'${viewId}', '${scriptId}', '${dataIndex}', '${title}'`;
    var iconStyle = 'ks-icon-analyse';
    var analyseBtn = '<span onclick="showWindowPopupEditor(' + onClickParams + ')" style="' + rightBtnStyle + '" class="' + iconStyle + '"></span>';

    if (Ext.isEmpty(renderedValue))
        renderedValue = '&nbsp;';

    return `<div><span>${renderedValue}</span>${analyseBtn}</div>`;
}

function commentRenderer(value, metadata, record, rowIndex, colIndex, store) {
    if (Ext.isEmpty(value))
        return '';

    var viewId = store.grid.parentView.viewID,
        scriptId = KS.Grid.getAnyCase(record, 'ID'),
        htmlLinkValue = '';

    var startIndex = value.toLowerCase().indexOf("[http://");
    if (startIndex >= 0) {
        var endIndex = value.toLowerCase().indexOf("]", startIndex + 8);
        if (endIndex >= 0) {
            htmlLinkValue = value.substring(startIndex + 1, endIndex);
            value = value.slice(0, startIndex) + value.slice(endIndex + 1);
        }
    }

    if (!Ext.isEmpty(htmlLinkValue)) {
        var rightBtnStyle = 'width: 16px; height: 16px; display: block; vertical-align: middle; position: absolute; top: 0; bottom: 0; margin: auto 0; right: 16px;';
        var onClickParams = `'${viewId}', '${scriptId}', 'HTML', 'HTML'`;
        var iconStyle = 'ks-icon-html';
        record.set('HTML', htmlLinkValue);
        var htmlBtn = '<div onclick="showWindowPopupRenderer(' + onClickParams + ')" style="' + rightBtnStyle + '" class="' + iconStyle + '"></div>';

        value = value + htmlBtn;
    }

    return showWindowPopupRenderer(viewId, value, scriptId, 'COMMENT', 'Комментарий');
}

function protocolRenderer(value, metadata, record, rowIndex, colIndex, store) {
    var viewId = store.grid.parentView.viewID,
        scriptId = KS.Grid.getAnyCase(record, 'ID');

    var rightBtnStyle = 'width: 16px; height: 16px; display: block; vertical-align: middle; position: absolute; top: 0; bottom: 0; margin: auto 0; right: 0;';
    var onClickParams = `'${viewId}', '${scriptId}'`;
    var iconStyle = 'ks-icon-analyse';
    var analyseBtn = '<span onclick="showProtocolEditor(' + onClickParams + ')" style="' + rightBtnStyle + '" class="' + iconStyle + '"></span>';

    if (Ext.isEmpty(value))
        value = '&nbsp;'

    return `<div><span>${value}</span>${analyseBtn}</div>`;
}

function reasonsRenderer(value, metadata, record, rowIndex, colIndex, store) {
    if (Ext.isEmpty(value))
        return '';

    var viewId = store.grid.parentView.viewID,
        scriptId = KS.Grid.getAnyCase(record, 'ID');

    return showWindowPopupRenderer(viewId, value, scriptId, 'REASONS', 'Основания (НПА/инициатор)');
}