﻿SavedFormTableView = KS.extend(BaseTreeView,
    {
        emptyNumericValue: '0,00',
        emptyStringValue: '',
        maxCountRowsInHeader: 7
    });

// ============= COMMON =======================
(function (viewClass) {
    KS.apply(viewClass, {

        onTemplateRendered: function () {
            this.resolveParentView();

            if (this.data.isHtmlForm) {
                this.editor.mask('Загрузка...');
            }
            else {
                this.undoManager = new Svod.UndoManager({
                    grid: this.mainGrid,
                    closeCode: 'link_saved_row',
                    isCaseSensitive: false
                });

                Svod.ColumnSortingManager.addColumnSorter(this.mainGrid);
            }

            this.cachedValues = [];
            KS.registerCssStyles(this.data.visualSettings.cssList);
            
            this.needFlush = false;
            this.hasChanges = false;
            this.allItemProperties = {};
            this.itemPropertiesChanges = true;
            this.resetCellValue = false;
            this.pasteMode = "simple";

            this.tableName = this.containerPanel.title;

            if (this.data.isHtmlForm) {
                this.editor.resumeEvents();
            } else if (this.data.isTransform) {
                this.resetGridPage();
                // RPN SUR
            } else {
                if (this.mainGrid != null) {
                    this.addLockedGridFilterFunctions();
                }

                this.customClipboardPlugin();
                // edit from touch device
                if (KS.browser.OS === "Android") {
                    this.mainGrid.on('cellclick', this.cellClickHandlerAndroid, this);
                }
                this.resetGroupTree();
                this.resetGridPage();
                this.loadVisualSettings();
                this.setAdditionalStyles();
                this.setHeaderColor(true);
                this.addHideColumnsButton();
                this.customColumns();
                this.customFilterMenuItems();
//                this.toggleGroupingFeature();
            }

            this.setEditState();
        },

        resolveParentView: function() {
            if (this.parentView) return;
            for (var view in KS.registeredViews) {
                if (KS.registeredViews.hasOwnProperty(view) && this.findReportViewComparer.call(this, KS.registeredViews[view])) {
                    this.parentView = KS.registeredViews[view];
                    this.masterView = this.parentView.viewID;
                    return;
                }
            }
            KS.msg('Не найден отчет');
        },

        undoChange: function () {
            var view = this.parentView;
            var undoRecOptions = view.undoManager.undo(view.mainGrid.getStore());

            if (!undoRecOptions)
                return;

            view.undoRedoCallback(undoRecOptions, true);
            view.touch();
        },

        redoChange: function () {
            var view = this.parentView;
            var redoRecOptions = view.undoManager.redo(view.mainGrid.getStore());

            if (!redoRecOptions)
                return;

            view.undoRedoCallback(redoRecOptions, false);
            view.touch();
        },

        undoRedoCallback: function (recOptions, needReverseValues) {
            var view = this;

            var rec = view.mainGrid.store.findRecord('link_saved_row', recOptions.link) ||
                view.mainGrid.store.findRecord('LINK_SAVED_ROW', recOptions.link);
            if (!rec)
                return;

            var value = needReverseValues ? recOptions.originalValue : recOptions.value;
            var originalValue = needReverseValues ? recOptions.value : recOptions.originalValue;
            var cvalue = buildCellValue(rec, recOptions.colKey, value, originalValue, false);
            view.cachedValues.push(cvalue);
        },

        findReportViewComparer: function (other) {
            if (!other.data || !other.data.savedForm) return false;
            var sf1 = this.data.savedForm,
                sf2 = other.data.savedForm;
            return (other !== this &&
                sf1.LinkSavedForm === sf2.LinkSavedForm &&
                sf1.LinkTask === sf2.LinkTask);
        },

        customClipboardPlugin: function() {
            var clipboardPlugin = this.mainGrid.getPlugin('clipboard');
            if (!Ext.isEmpty(clipboardPlugin)) {
                clipboardPlugin.setFormats({
                    text: {
                        get: 'getTextDataRedef',
                        put: 'putTextData'
                    }
                });
                clipboardPlugin.getTextDataRedef = getTextDataRedef;
                clipboardPlugin.putTextData = putTextData;
            }
        },

        resetGridPage: function () {
            if (this.mainGrid) {
                this.mainGrid.getSelectionModel().deselectAll();
                this.refillItemProperties();
                var rtc = this.data.reportTableCell;
                if (rtc && rtc.Page > 0) {
                    this.mainGrid.getStore().loadPageFromServerTemplate(rtc.Page);
                } else {
                    this.mainGrid.reload();
                }
            }
        },

        getAdditionalGetDataParams: function (getDataParams) {
            if (!KS.isEmpty(this.cachedValues)) {
                getDataParams['cachedValues'] = this.cachedValues;
                this.isFlushing = true;
            }
        },

        loadVisualSettings: function () {
            this.applyVisualSettings(this.data.visualSettings);
            //this.serverCall({
            //    method: 'LoadVisualSettings',
            //    waitMessage: 'Загрузка итоговых ячеек ...',
            //    cancellable: true,
            //    success: this.applyVisualSettings
            //});
        },

        applyVisualSettings: function (vs) {
            if (vs) {
                this.data.visualSettings = vs;
                KS.registerCssStyles(vs.cssList);
                //if (vs.disabledValue) {
                    //this.data.disabledValue = vs.disabledValue;
                    this.data.disabledValue = "X"; // временно
                //}
                this.data.summaryAppearanceLink = vs.summaryAppearanceLink;
                this.mainGrid.getView().refresh();
            }
            if (this.parentView) this.parentView.processQueuedActions();
        },

        isActiveView: function () {
            return (this.parentView &&
                this.parentView.topTabPanel &&
                this.parentView.topTabPanel.getActiveTab &&
                this.parentView.topTabPanel.getActiveTab() &&
                this.parentView.topTabPanel.getActiveTab().nestedView === this);
        },

        getColumnName: function(header) {
            var brIndex = header.indexOf('</br>');
            if (brIndex < 0) {
                brIndex = 0;
            } else {
                brIndex += 5;
            }
            return header.substring(brIndex);
        },

        hasDisabledColumns: function () {
            var r = false;
            this.eachColumnCfg(function (cfg) {
                if (cfg.tag && cfg.tag.DisableReason > 0) {
                    r = true;
                }
            });
            return r;
        },

        eachColumn: function (fn) {
            var view = this;
            Ext.each(view.mainGrid.gridSettings.Band[0].Column, function (c, idx) {
                if (c && typeof (fn) == "function") {
                    fn.call(view, c, idx);
                }
            });
        },

        eachColumnCfg: function (fn) {
            var view = this;
            Ext.each(view.mainGrid.columns, function (cfg, idx) {
                if (cfg && typeof (fn) == "function") {
                    fn.call(view, cfg, idx);
                }
            });
        },

        isRecordDisabled: function (record) {
            var dcs = this.data.visualSettings.disabledCells,
                ldr = record.get("link_diction_row");
            return (dcs && dcs[ldr + "#"] && dcs[ldr + "#"].IsDisabledSidewallRow);
        },

        // Ищет есть ли запись, и если есть, возвращает порядковый номер в store
        findRecBySavedLink: function (linkSavedRow) {
            return this.mainGrid.getStore().findBy(function (rec) {
                return KS.Grid.getAnyCase(rec, 'link_saved_row') == linkSavedRow;
            });
        },

        findRecByDictionLink: function (dictRowLink, groupLink) {
            return this.mainGrid.getStore().findBy(function (rec) {
                var groupMatches = (Ext.isEmpty(groupLink) || groupLink == 0) ? true : KS.Grid.getAnyCase(rec, 'LINK_DICTION_ROW_GROUP') == groupLink;
                return groupMatches && KS.Grid.getAnyCase(rec, 'LINK_DICTION_ROW') == dictRowLink;
            });
        },

        isEmptyRow: function (r) {
            if (this.codeIsFilled(r)) return false;
            return ((+KS.Grid.getAnyCase(r,"LINK_SAVED_ROW") === 0) || (r.isEmpty === true));
        },

        codeIsFull: function (rec) {
            var view = this,
                r = true;
            view.eachColumnCfg(function (cfg) {
                if (cfg.visibility && Ext.isEmpty(rec.get(cfg.dataIndex)) &&
                    cfg.renderer === sidewallRenderer && cfg.renderer !== groupRenderer) {
                    r = false;
                }
            });
            return r;
        },

        codeIsFilled: function (rec) {
            var r = false;
            this.eachColumnCfg(function (cfg) {
                if (cfg.tag && cfg.tag.IsCode && !cfg.tag.IsGroup && !Ext.isEmpty(rec.get(cfg.dataIndex))) {
                    r = true;
                }
            });
            return r;
        },

        fillFakeLinks: function (rec) {
            var lsr = + KS.Grid.getAnyCase(rec, 'link_saved_row');
            if (isNaN(lsr) || !(lsr !== 0)) {
                lsr = KS.getFakeLink();
                rec.set("link_saved_row", lsr);
            }
            var ldr = + KS.Grid.getAnyCase(rec, 'link_diction_row');
            if (isNaN(ldr) || !(ldr !== 0)) {
                ldr = KS.getFakeLink();
                rec.set("link_diction_row", ldr);
            }
        },

        hasDataChanges: function () {
            return (this.data.isHtmlForm) ? this.hasHtmlChanges() : this.hasChanges;
        },

        hasHtmlChanges: function () {
            if (!this.data.isHtmlForm) return false;
            return this.richEditFrame.hasChanges();
        },

        isGroup: function (colKey) {
            return (this.getRenderer(colKey) === groupRenderer);
        },

        touchRow: function (r) {
            if (this.isEmptyRow(r)) {
                r.isEmpty = false;
            }
        },

        isSidewall: function (colKey) {
            var renderer = this.getRenderer(colKey);
            return (renderer === sidewallRenderer || renderer === swallNonCodeDictRenderer);
        },

        getRenderer: function (colKey) {
            var colConfig = this.mainGrid.getColConfigByKey(colKey);
            return (colConfig) ? colConfig.renderer : null;
        },

        getEditorType: function (colKey) {
            var et = null;
            this.eachColumn(function (c) {
                if (c.dataIndex === colKey) et = c.editorType;
            });
            return et;
        },

        showMainGridRowsCount: function () {
        },

        gridStoreNotEmpty: function() {
            return this.mainGrid && this.mainGrid.getStore() &&
                this.mainGrid.getStore().getCount() > 0;            
        },

        onValuesSelected: function (arg) {
            var view = this;
            if (view.data.readOnly)
                return;
            for (var field in arg[0][0]) {
                if (arg[0][0].hasOwnProperty(field) ) {
                    if (field === 'ACTION') {
                        var action = arg[0][0][field];
                        switch (action) {
                            case 'RESET_GRID_PAGE':
                                view.resetGridPage();
                                break;
                            case 'SPREADSHEET':
                                KS.openSpreadsheetView(arg[0][0]['URL'], view);
                                break;
                            case 'ASSIGN_COLUMNS':
                                view.assignColumns();
                                break;
                            default:
                                var ap = action.split(':'),
                                    fn = ap[1];
                                if (ap[0] === 'js' && Ext.isFunction(view[fn]))
                                    view[fn].call(this, args[0][0]);
                                break;
                        }
                    } else if (field === 'GROUP_CODE') {
                        var code = arg[0][0][field],
                            tedId = arg[0][0]['GROUP_FIELD_ID'];
                        if (this[tedId]) {
                            this[tedId].setValue(code);
                            view.touch();
                            if (view.baseTree)
                                view.baseTree.setSelected(arg[0][0].LINK_DICTION_ROW.toString()); // Узел выберется только если он отрендерен
                            return;
                        }
                    }
                }
            }
            if (view.data.isTransform) {
                Ext.each(arg[0], function (dict) {
                    for (var colKey in dict) {
                        if (dict.hasOwnProperty(colKey) ) {
                            view.setTransformItemValue(colKey, dict[colKey]);
                        }
                    }
                });
            } else {
                if (view.mainGrid.getSelection() == null)
                    return;
                var rec = view.mainGrid.selection;
                if (arg[0][0].hasOwnProperty("nastr")) {
                    if (KS.Grid.getAnyCase(rec, "nastr") !== arg[0][0]["nastr"]) {
                        view.refillItemProperties();
                        rec.set("nastr", arg[0][0]["nastr"]);
                    }
                }
                Ext.each(arg[0], function (dict) {
                    for (var colKey in dict) {
                        if (dict.hasOwnProperty(colKey) &&
                            view.mainGrid.getColIndexByKey(colKey) !== -1) {
                            rec.set(colKey, dict[colKey]);
                            view.touchRow(rec);
                        }
                    }
                });
            }
            view.touch();
            view.touchActiveGroup();
        },
    
        deleteCellValue: function(rec, colCfg) {
            var colKey = colCfg.dataIndex,
                originalValue = rec.get(colKey),
                emptyValue = this.getEmptyValueByRenderer(colCfg.renderer, colCfg.tag);
            if (originalValue !== emptyValue)
                this.saveCellValue(rec, colKey, emptyValue, originalValue, true, null, null, true);
        },
        
        select: function(){
            var sc = SavedFormTableView.superclass;
            var view = this.parentView;
            if (view.data.isSubTable){
                view.serverCall({
                    method: 'CloseSubTable',
                    params: [view.cachedValues]
                });
                return;
            }
            sc.select.apply(this, arguments);
        },
        
        onServerCloseSubTable: function(){
            this.close();
        },
        
        onServerActivateTableCell: function(reportTableCell){
            this.data.reportTableCell = reportTableCell;
            this.processReportTableCell();
        },

        onRichEditDocumentLoaded: function(isFirstDocumentLoad) {
            if (isFirstDocumentLoad) {
                this.editor.unmask();
            }
            else {
                this.touch();
            }
        },

        onRichEditDocumentChanged: function() {
            this.touch();
        }
    });
}(SavedFormTableView.prototype));

// ============= TOOLBAR =======================
(function (viewClass) {
    KS.apply(viewClass, {
        buildContainerToolbarItemControl: function (tbarItem, schema) {
            if (this.data.isTransform)
                switch (tbarItem.code) {
                    case 'STATUS_COMBO':
                        return this.buildTableStatus();
                }
            return SavedFormTableView.superclass.buildContainerToolbarItemControl.call(this, tbarItem, schema);
        },

        getTbarClickHandler: function(tbarItem) {
            var sc = SavedFormTableView.superclass;
            switch (tbarItem.code) {

                case "SUM":
                case "SUM2":
                case "SUM_MENU":
                    return this.sumHandler;

                case "GROUP_BY_CODE":
                    return this.groupByCode;

                case 'GROUP_BY_CODE_PART':
                    return this.groupByCodePart;

                case 'NEW':
                    return this.newHandler;

                case 'EDIT':
                    return this.editHandler;

                case 'COPY':
                case 'COPY_ROW':
                    return this.copyRowHandler;

                case 'COPY2':
                    return this.copyHandler;

                case 'COPY_COLUMN':
                    return this.copyColumn;

                case 'PASTE':
                case 'PASTE2':
                    return this.pasteHandler;

                case 'PASTE_SPECIAL':
                    return this.pasteSpecialHandler;

                case 'DELETE':
                case 'DELETE_MENU':
                    return this.deleteHandler;

                case 'MARK_INVERT':
                    return this.markInvertHandler;

                case 'MARK_INVERT2':
                    return this.markInvertHandler;

                case 'MARK_TOP':
                    return this.markTopHandler;

                case 'MARK_ALL':
                    return this.markAllHandler;

                case 'MARK_REST':
                    return this.markRestHandler;

                case 'MARK_BETWEEN':
                    return this.markBetweenHandler;

                case 'UNMARK':
                    return this.unmarkHandler;

                case 'SET_TO_ZERO':
                case 'SHARE':
                case 'SHARE_BANK':
                case 'MULTIPLY':
                case 'ROUND_TO_INT':
                case 'ROUND_TO_INT_BANK':
                case 'ROUND_TO_FLOAT':
                case 'ROUND_TO_FLOAT_BANK':
                    if (Ext.isEmpty(tbarItem.additional))
                        tbarItem.additional = { menuAlign: 'tl-tr' };
                    return this.calculationData;

                case 'SET_TO_ZERO_COLUMNS':
                case 'SHARE_COLUMNS':
                case 'SHARE_BANK_COLUMNS':
                case 'MULTIPLY_COLUMNS':
                case 'ROUND_TO_INT_COLUMNS':
                case 'ROUND_TO_INT_BANK_COLUMNS':
                case 'ROUND_TO_FLOAT_COLUMNS':
                case 'ROUND_TO_FLOAT_BANK_COLUMNS':
                    return this.selectColumns;

                case 'SIDEWALL':
                case 'HIDE_EMPTY_ROWS':
                case 'SHOW_ALL_ROWS':
                    return this.sidewallRows;

                case 'CLEAN_COLUMN':
                    return this.cleanColumn;

                case 'RAND_RIGHTS':
                case 'RAND_RIGHTS1':
                case 'RAND_RIGHTS_DOWN':
                case 'RAND_RIGHTS_ALL':
                case 'RAND_RIGHTS_DEL':
                case 'RAND_RIGHTS1_DEL':
                case 'RAND_RIGHTS_DOWN_DEL':
                case 'RAND_RIGHTS_ALL_DEL':
                    return this.areaAccess;

                case 'SWITCH_VIEW_GROUP':
                    return this.switchGroupTree;
                
                case 'COLUMN_RIGHTS':
                    return this.loadColumnsRights;

                case 'SELECT_GROUPS':
                    return this.selectVisibleGroups;

                case 'SETTINGS':
                case 'DICT_MENU':
                case 'DATA':
                case 'PASTE_FROM_EXCEL'://Пока не реализовано, убираем чтобы не мигало при нажатии
                    return null;

                case 'Default':
                    return this.deleteSettings;

                case 'GROUP_DELETE':
                    return this.deleteGroup;

                case 'OPEN_SIDEWALL_DICT':
                    return this.openSidewallDict;

                case 'OPEN_GROUP_DICT':
                    return this.openGroupDict;

                case 'CLEAR_DISABLED_CELLS_VALUES':
                    return this.clearDisabledCellsValues;

                default:
                    return sc.getTbarClickHandler.apply(this, arguments);
            }
        },

        disableToolbar: function() {
            this.setToolbarDisabled(true);
        },

        enableToolbar: function() {
            this.setToolbarDisabled(false);
        },

        setToolbarDisabled: function(state) {
            if (this.mainGrid && this.mainGrid.rendered) {
                var newButton = this.getToolbarItem(this.mainGrid, null, "NEW"),
                    copyButton = this.getToolbarItem(this.mainGrid, null, "COPY"),
                    deleteButton = this.getToolbarItem(this.mainGrid, null, "DELETE_MENU");
                if (newButton)
                    newButton.setDisabled(state);                
                if (copyButton)
                    copyButton.setDisabled(state);                
                if (deleteButton)
                    deleteButton.setDisabled(state);
            }
        },

        reload: function() {
            var view = this.parentView;
            if (!view.hasChanges) {
                view.doRefreshTable();
                return;
            }
            KS.confirm("Обновить таблицу? Несохраненные данные будут утеряны.",
                "Подтвердите обновление",
                function(btn) {
                    if (btn === 'yes') {
                        view.doRefreshTable();
                    }
                });
        },

        doRefreshTable: function() {
            this.serverCall({
                method: "Reload",
                waitMessage: "Обновление таблицы " + (this.tableName || "") + "...",
                success: this.refreshCallBack
            });
        },

        refreshCallBack: function(data) {
            var cachedValues = this.cachedValues;
            this.discardChanges();
            if (this.restoreCachedValues) { //сохраняем значение ячеек при обновлении формы(для рпн)
                this.cachedValues = cachedValues;
                this.restoreCachedValues = false;
            }
            if (this.data.isHtmlForm) {
                this.editor.mask('Загрузка...');
                this.richEditFrame.reloadFrame();
            } else if (this.data.isTransform) {
                this.data = data;
                this.resetTransformGrid();
            } else {
                if (data)
                    this.data.visualSettings = data.visualSettings;
                if (this.data.showGroupTree) {
                    this.resetGroupTree();
                } else {
                    this.resetGridPage();
                }
            }
            KS.registerCssStyles(this.data.visualSettings.cssList);
        },

        //ADD ROW
        newHandler: function(cache, callback) {
            var view;
            cache === true ? view = this : view = this.parentView;
            view.refillItemProperties();
            view.serverCall({
                method: "AddRow",
                disableFog: true,
                success: KS.isFunction(callback)
                    ? callback
                    : view.newHandlerCallBack
            });
        },

        newHandlerCallBack: function(dataRow) {
            var newRec = this.mainGrid.addRecord(dataRow);
            if (this.data.isTransform) {
                var addedTab = this.addTransformRecord(newRec.data, newRec);
                if (!this.data.isSingleTransform) {
                    this.transPanel.setActiveTab(addedTab);
                }
            }
            this.touchActiveGroup();
            this.touch();
        },

        copyRowHandler: function() {
            var view = this.parentView || this;
            if (view.reportReadOnly() || view.data.isStatic) {
                view.copySelectCells();
                return;
            }

            var record = view.mainGrid.selection;
            if (view.data.isTransform){
                var activeTab = view.transPanel.getActiveTab();
                if (!activeTab)
                    return;
                var savedRowLink = getRecDataValue(activeTab.recData, "LINK_SAVED_ROW");
                var recIndex = view.findRecBySavedLink(savedRowLink);
                record = view.mainGrid.getStore().getAt(recIndex);
            }
            if (Ext.isEmpty(record) || !view.gridStoreNotEmpty()) {
                return;
            }
            view.refillItemProperties();
            view.serverCall({
                method: "CopyRow",
                params: [KS.Grid.getAnyCase(record, 'link_saved_row'), view.cachedValues],
                success: function(dataRow) {
                    if (!Ext.isEmpty(dataRow)) {
                        if (view.data.isTransform) {
                            view.newHandlerCallBack(dataRow);
                            return;
                        }
                        var store = view.mainGrid.getStore();
                        store.insert(store.indexOf(record) + 1, dataRow);
                        KS.updateLayout(view.mainGrid);
                        view.touch();
                    }
                }
            });
        },

        copyHandler: function() {
            var view = this.parentView || this;
            view.copySelectCells();
        },

        copySelectCells: function() {
            var clipPlugin = this.mainGrid.getPlugin('clipboard');
            if (clipPlugin) {
                clipPlugin.doCutCopy(null, false);
                if (!Ext.isIE && navigator.clipboard) {
                    var text = clipPlugin.getTextDataRedef('text', false);
                    navigator.clipboard.writeText(text);
                }
            }
        },

        copyColumn: function() {
            var view = this.parentView || this;
            if (view.reportReadOnly()) return;
            var selected = view.mainGrid.getSelectionModel().getSelected();

            if (!view.gridStoreNotEmpty() ||
                Ext.isEmpty(selected) ||
                Ext.isEmpty(selected.startCell))
                return;

            var selectedCell = view.mainGrid.getSelectionModel().getSelected().startCell,
                rec = selectedCell.record,
                index = selectedCell.column.dataIndex;

            view.serverCall({
                method: "PrepareCopyRow",
                params: [index, KS.Grid.getAnyCase(rec, 'link_saved_row')],
                success: view.createCopyColumnPanel
            });
        },

        createCopyColumnPanel: function(columnsGrid) {
            var view = this,
                colIdx = view.mainGrid.getSelectionModel().getSelected().startCell.colIdx,
                colDesc = view.mainGrid.getVisibleColumns()[colIdx].tag,
                linkCol = colDesc.ColumnLink;
            var copyColumnsGrid = KS.create(columnsGrid);
            var copyColumnsWin = KS.showModal(copyColumnsGrid, {
                title: 'Выберите колонки для вставки',
                autoHeight: false,
                height: 400,
                buttonAlign: 'left',
                buttons: ['->', {
                    text: 'Выбрать',
                    scope: this,
                    handler: function () {
                        view.copyColumnsSelected(linkCol, copyColumnsWin.getComponent('copyColumnsGrid').getSelection());
                        copyColumnsWin.close();
                    }
                }]
            }, true);
        },

        copyColumnsSelected: function (linkCol, checkList) {
            var selectedColumns = [];
            for (var checkColumn in checkList) {
                if( checkList.hasOwnProperty(checkColumn) ) {
                    selectedColumns.push(checkList[checkColumn].data.LINK_COL);
                }
            }
            this.serverCall({
                method: "SelectColumnsToCopy",
                params: [linkCol, selectedColumns],
                success: function () {
                    this.mainGrid.reload();
                    this.touch();
                }
            });
        },

        //PASTE
        pasteHandler: function() {
            var view = this.parentView || this;
            view.pasteClipboardInTable();
        },

        pasteClipboardInTable: function() {
            var clipPlugin = this.mainGrid.getPlugin('clipboard');
            clipPlugin.pasteClipboardData('text');
            if (!Ext.isIE && navigator.clipboard) {
                navigator.clipboard.readText().then(function(clipText) {
                    clipPlugin.putTextData(clipText);
                });
            }
        },

        //PASTE_SPECIAL
        pasteSpecialHandler: function() {
            var view = this.parentView || this;
            var pasteSpecialForm = KS.showModal([
                {
                    xtype: 'label',
                    text: 'Операция',
                    margin: '0 0 15 10'
                }, {
                    xtype: 'radiogroup',
                    columns: 2,
                    itemId: 'pasteSFRadioGroup',
                    maxHeight: 70,
                    vertical: true,
                    items: [
                        { boxLabel: 'Нет', name: 'oper', inputValue: 'simple', checked: true },
                        { boxLabel: 'Сложить', name: 'oper', inputValue: 'sum' },
                        { boxLabel: 'Вычесть', name: 'oper', inputValue: 'sub' },
                        { boxLabel: 'Умножить', name: 'oper', inputValue: 'mul' },
                        { boxLabel: 'Разделить', name: 'oper', inputValue: 'div' }
                    ]
                }, {
                    xtype   : 'checkbox',
                    boxLabel: 'Очистить перед вставкой',
                    itemId  : 'clearCells',
                    checked : false
                }
            ], {
                title: 'Специальная вставка',
                autoHeight: false,
                height: 180, 
                minHeight: 180,
                width: 250,
                minWidth: 250,
                buttonAlign: 'left',
                buttons: ['->', {
                    text: 'ОК',
                    cls: 'dim-button',
                    handler: function () {
                        view.pasteMode = pasteSpecialForm.getComponent("pasteSFRadioGroup").getValue().oper;
                        var clearCells = pasteSpecialForm.getComponent("clearCells").getValue();
                        pasteSpecialForm.close();
                        view.pasteClipboardInTable();
                    }
                }, { xtype: 'tbspacer', width: 8 },
                    {
                        text: 'Отмена',
                        cls: 'dim-button',
                        handler: function() {
                            pasteSpecialForm.close();
                        }
                    }]
            }, true);
        },

        //DELETE
        deleteHandler: function () {
            var view = this.parentView,
                confirmMsg = "Удалить ",
                sm = view.mainGrid.getSelectionModel(),
                store = view.mainGrid.getStore(),
                selRows = [];
            if (view.data.isTransform) {
                var activeTab = view.transPanel.getActiveTab();
                if (!activeTab)
                    return;
                var savedRowLink = getRecDataValue(activeTab.recData, "LINK_SAVED_ROW"),
                    rec2Del = view.findRecBySavedLink(savedRowLink);
                selRows.push(store.getAt(rec2Del));
                confirmMsg += "выделенную строку?";
            } else {
                selRows = view.mainGrid.getSelection();
                if (selRows.length === 0) { // Нет чекнутых строк, ищем выделенные ячейки                   
                    if (Ext.isEmpty(sm.getSelected())) return;
                    var range = sm.getSelected().getRange();
                    var row1 = range[0][1];
                    var row2 = range[1][1];
                    for (var rowIdx = row1; rowIdx <= row2; rowIdx++) {
                        selRows.push(store.getAt(rowIdx));
                    }
                }
                if (selRows.length === 0)
                    return;
                switch (selRows.length) {
                    case 1:
                        confirmMsg += "выделенную строку";
                        var c = KS.Grid.getAnyCase(selRows[0], 'CODE');
                        if (c && c.length > 0) {
                            confirmMsg += " с кодом " + c;
                        }
                        confirmMsg += "?";
                        break;
                    case 2:
                    case 3:
                    case 4:
                        confirmMsg += (selRows.length) + " строки?";
                        break;
                    default:
                        confirmMsg += (selRows.length) + " строк?";
                        break;
                }
            }
            KS.confirm(confirmMsg, "Подтвердите удаление", function (btn) {
                if (btn === "yes") view.doDeleteRows(selRows);
            });
        },

        doDeleteRows: function (selRows) {
            var view = this,
                cvalues = [],
                recs2Del = [],
                deletedSavedRowLinks = [],
                cvalue;
            Ext.each(selRows, function(rec) {
                if (rec && !view.isRecordDisabled(rec)) {
                    if (view.hasDisabledColumns() && !view.data.isTransform) {
                        view.clearRecValues(rec);
                    } else {
                        recs2Del.push(rec);
                        cvalue = buildCellValue(rec, null, null, null, false);
                        cvalues.push(cvalue);
                        deletedSavedRowLinks.push(cvalue.LinkSavedRow);
                    }
                }
            });
            view.serverCall({
                method: "DeleteTableRows",
                params: [cvalues],
                success: function () {
                    if (view.data.isTransform) {
                        Ext.each(recs2Del, function (rec2Del) {
                            view.removeTransformRecord(rec2Del);
                        });
                    }
                    view.mainGrid.getStore().remove(recs2Del);
                    // При pruneRemoved = false удаленные строки остаются в selModel
                    Ext.each(recs2Del, function (rec) {
                        view.mainGrid.getSelectionModel().deselect(rec);
                    });
                    view.mainGrid.checkList = []; // строки, выделенные через checkRecord, не удаляются из grid.checkList
                    var tepmCachedValues = [];
                    Ext.each(view.cachedValues, function(cv) {
                        if (cv && $.inArray(cv.LinkSavedRow, deletedSavedRowLinks) < 0) {
                            tepmCachedValues.push(cv);
                        }
                    });
                    view.cachedValues = tepmCachedValues;
                    view.removeBoldTextInNode();
                }
            });
            view.touch();
        },

        clearRecValues: function (rec) {
            var view = this;
            this.eachColumnCfg(function (colCfg) {
                if (colCfg.tag && colCfg.tag.IsData && !colCfg.tag.WasDeleted) {
                    view.clearCell(rec, colCfg);
                }
            });

            if (view.needFlush) {
                view.flushCachedValues();
            }
        },

        clearCell: function (rec, colCfg) {
            if (typeof (colCfg) == "undefined" || !colCfg.visibility || 
                getItemProperties(rec, colCfg.dataIndex).IsReadOnly || this.reportReadOnly())//|| !colCfg.editable )
                return;
            var ds = getCellDisableState(rec, colCfg, null),
                forceDisable = (ds === true || !isCellEmpty(rec.data[colCfg.dataIndex], colCfg));

            if (ds !== false && !forceDisable)
                return;

            var colKey = colCfg.dataIndex,
                originalValue = rec.get(colKey),
                value = this.getEmptyValueByRenderer(colCfg.renderer, colCfg.tag);

            this.saveCellValue(rec, colKey, value, originalValue, false, undefined, forceDisable);
        },

        getEmptyValueByRenderer: function(renderer, colDesc) {
            switch (renderer) {
                case stringRenderer:
                    return this.emptyStringValue;

                case numberRenderer:
                    if (!colDesc.hasOwnProperty("DefaultValue")) // DefaultValue == null
                        return null;
                    return this.emptyNumericValue;

                case reportTableCellRenderer:
                    return this.emptyStringValue;

                default:
                    return this.emptyStringValue;
            }
        },

        updateGridCheckList: function(grid, checkList, uncheckList) {
            // Запоминаем выделенные строки, которых нет в данный момент в store
            grid.checkList = Ext.Array.clone(grid.getSelectionModel().selected.selectedRecords.items);
            Ext.each(uncheckList || [], function(record) {
                var i = grid.checkList.indexOf(record);
                if (i !== -1)
                    grid.checkList.splice(i, 1);
            });
            Ext.each(checkList || [], function (record) {
                if (grid.checkList.indexOf(record) === -1)
                    grid.checkList.push(record);
            });
        },

        markInvertHandler: function () {
            var view = this.parentView;
            var grid = view.mainGrid;
            if (grid) {
                var checkedRows = grid.getCheckedRows();
                var checkList = [];
                var uncheckList = [];
                grid.store.each(function(rec) {
                    if (checkedRows.indexOf(rec) >= 0) {
                        uncheckList.push(rec);
                    } else {
                        checkList.push(rec);
                    }
                });
                view.updateGridCheckList(grid, checkList, uncheckList);
                grid.getSelectionModel().selectRows(grid.checkList, false, true);
                grid.confirmCheckSelection();
            }
            view.updateSummaryRow();
        },

        markTopHandler: function() {
            var view = this.parentView;
            var grid = view.mainGrid;
            if (grid) {
                var sel = grid.getSelectionModel().getStoreSelection();
                if (sel.length) {
                    var store = grid.getStore(),
                        lastRec = sel[sel.length - 1],
                        lastRecIndex = store.indexOf(lastRec);
                    var checkList = store.getRange(0, lastRecIndex);
                    view.updateGridCheckList(grid, checkList);
                    grid.getSelectionModel().selectRows(grid.checkList, false, true);
                } else {
                    view.markAllHandler.call(this);
                }
            }
            view.updateSummaryRow();
        },

        markRestHandler: function() {
            var view = this.parentView;
            var grid = view.mainGrid;
            if (grid) {
                var sel = grid.getSelectionModel().getStoreSelection();
                if (sel.length) {
                    var store = grid.getStore(),
                        firstRec = sel[0],
                        firstRecIndex = store.indexOf(firstRec);
                    var checkList = store.getRange(firstRecIndex, grid.getStore().getCount() - 1);
                    view.updateGridCheckList(grid, checkList);
                    grid.getSelectionModel().selectRows(grid.checkList, false, true);
                } else {
                    view.markAllHandler.call(this);
                }
            }
            view.updateSummaryRow();
        },

        markBetweenHandler: function() {
            var view = this.parentView;
            var grid = view.mainGrid;
            if (grid) {
                var sel = grid.getSelectionModel().getStoreSelection();
                if (sel.length) {
                    var store = grid.getStore(),
                        firstRec = sel[0],
                        firstRecIndex = store.indexOf(firstRec),
                        lastRec = sel[sel.length - 1],
                        lastRecIndex = store.indexOf(lastRec);
                    var checkList = store.getRange(firstRecIndex, lastRecIndex);
                    view.updateGridCheckList(grid, checkList);
                    grid.getSelectionModel().selectRows(grid.checkList, false, true);
                }
            }
            view.updateSummaryRow();
        },

        markAllHandler: function() {
            var view = this.parentView;
            var grid = view.mainGrid;
            if (grid) view.setAllCheckState(true, grid);
            view.updateSummaryRow();
        },

        unmarkHandler: function() {
            var view = this.parentView;
            var grid = view.mainGrid;
            if (grid) view.setAllCheckState(false, grid);
            view.updateSummaryRow();
        },

        setAllCheckState: function(checked, grid) {
            var checkList = [];
            var uncheckList = [];
            grid.store.each(function(rec) {
                if (!checked) {
                    uncheckList.push(rec);
                } else {
                    checkList.push(rec);
                }
            });
            this.updateGridCheckList(grid, checkList, uncheckList);
            grid.getSelectionModel().selectRows(grid.checkList, false, true);
            grid.confirmCheckSelection();
        },

        calculationData: function () {
            var key = this.config.tbarNode.code;
            var view = this.parentView;
            var links = view.mainGrid.getCheckedCodes();
            var selectedCellCount = 1;
            var selectedRange = 0;
            var selectedCells = view.mainGrid.getSelectionModel().getSelected();
            if (!KS.isEmpty(selectedCells)) {
                selectedRange = selectedCells.getRange();
                if (selectedRange) {
                    selectedCellCount = selectedCells.getRangeSize();
                }
            }
            var confirmMsg = view.getGroupDataOperationName(key, false) + (selectedCellCount > 1
                ? " в выбранных ячейках"
                : links.length > 0
                    ? " в выбранных строках"
                    : "");
            KS.confirm(confirmMsg, "Подтвердите действие", function (btn) {
                if (btn === "yes") {
                    var cells = [];
                    var isRow = false;
                    if (links.length > 0 || selectedCellCount <= 1) {
                        cells = links;
                        isRow = true;
                    } else {
                        for (var rowIndex = selectedRange[0][1]; rowIndex <= selectedRange[1][1]; rowIndex++) {
                            var record = view.mainGrid.getStore().getAt(rowIndex);
                            var cellkeys = KS.Grid.getAnyCase(record, 'link_saved_row');
                            for (var cellIndex = selectedRange[0][0]; cellIndex <= selectedRange[1][0]; cellIndex++) {
                                cellkeys += " " + view.mainGrid.getVisibleColumns()[cellIndex].key;
                            }
                            cells.push(cellkeys);
                        }
                    }
                    view.doCalculationData(cells, key, isRow);
                }
            });
        },

        doCalculationData: function (cells, key, isRows) {
            this.serverCall({
                method: "CalculationData",
                params: [cells, key, isRows, this.cachedValues],
                success: function () {
                    this.mainGrid.reload();
                    this.touch();
                }
            });
        },

        getGroupDataOperationName: function (code, forToolbar) {
            switch (code) {
                case "SET_TO_ZERO":
                    return forToolbar ? "Обнулить" : "Обнулить все данные";

                case "SHARE":
                    return forToolbar ? "Разделить на 1000 (стандартное округление)" : "Разделить данные на 1000";

                case "SHARE_BANK":
                    return forToolbar ? "Разделить на 1000 (банковское округление)" : "Разделить данные на 1000";

                case "MULTIPLY":
                    return forToolbar ? "Умножить на 1000" : "Умножить данные на 1000";

                case "ROUND_TO_INT":
                    return forToolbar ? "Округлить до целых (стандартное округление)" : "Округлить данные до целых";

                case "ROUND_TO_INT_BANK":
                    return forToolbar ? "Округлить до целых (банковское округление)" : "Округлить данные до целых";

                case "ROUND_TO_FLOAT":
                    return forToolbar ? "Округлить до 1 знака после запятой (стандартное округление)" : "Округлить данные до 1 знака после запятой";

                case "ROUND_TO_FLOAT_BANK":
                    return forToolbar ? "Округлить до 1 знака после запятой (банковское округление)" : "Округлить данные до 1 знака после запятой";
            }
            return "";
        },

        selectColumns: function () {
            var view = this.parentView;
            var key = this.config.tbarNode.code;
            var columnsGrid = KS.create(view.tpl.controls.columnsGrid);
            var links = view.mainGrid.getCheckedCodes();
            var columnsWin = KS.showModal(columnsGrid, {
                title: 'Выбор столбцов',
                autoHeight: false,
                height: 400,
                buttonAlign: 'left',
                buttons: ['->', {
                    text: 'Выбрать',
                    scope: this,
                    handler: function () {
                        view.columnsSelected(key, links, columnsWin.getComponent('columnsGrid').getSelection());
                        columnsWin.close();
                    }
                }]
            }, true);
        },

        columnsSelected: function (key, links, checkList) {
            var columns = [];
            for (var checkColumn in checkList) {
                if( checkList.hasOwnProperty(checkColumn) ) {
                    columns.push(KS.Grid.getAnyCase(checkList[checkColumn], 'CODE'));
                }
            }
            var decolumnedKey = key.replace("_COLUMNS", "");
            this.serverCall({
                method: "SelectColumns",
                params: [decolumnedKey, links, columns],
                success: function () {
                    this.mainGrid.reload();
                    this.touch();
                }
            });
        },

        //SHOW/HIDE EMPTY ROW
        sidewallRows: function () {
            var operationType = this.config.tbarNode.code;
            this.parentView.serverCall({
                method: "SidewallRows",
                params: [operationType],
                success: function () {
                    this.mainGrid.reload();
                }
            });
        },

        //CLEAN
        cleanColumn: function () {
            var view = this.parentView;
            var checkedRows = view.mainGrid.getCheckedRows(false);
            var selected = view.mainGrid.getSelectionModel().getSelected();
            if (Ext.isEmpty(selected) || Ext.isEmpty(selected.endCell))
                return;

            var colIndex = selected.endCell.colIdx;
            var col = view.mainGrid.getVisibleColumns()[colIndex].tag;
            var confirmMsg = checkedRows.length === 0
                ? ("Очистить все данные в графе " + col.Name + "?")
                : ("Очистить данные в графе " + col.Name + " в выбранных строках?");
            KS.confirm(confirmMsg, "Подтвердите очищение", function (btn) {
                    if (btn === "yes") {
                        view.doCleanColumn(checkedRows, col);
                    }
                });
        },

        doCleanColumn: function (checkedRows, col) {
            this.serverCall({
                method: "ClearColumn",
                params: [checkedRows, col],
                success: function () {
                    this.mainGrid.reload();
                    this.touch();
                }
            });
        },

        areaAccess: function () {
            var key = this.config.tbarNode.code;
            var view = this.parentView;
            switch (key) {
                case "RAND_RIGHTS":
                case "RAND_RIGHTS1":
                    view.onSaveRandRights(false, 0);
                    break;
                case "RAND_RIGHTS_DOWN":
                    view.onSaveRandRights(false, 1);
                    break;
                case "RAND_RIGHTS_ALL":
                    view.onSaveRandRights(false, 2);
                    break;
                case "RAND_RIGHTS_DEL":
                case "RAND_RIGHTS1_DEL":
                    view.onSaveRandRights(true, 0);
                    break;
                case "RAND_RIGHTS_DOWN_DEL":
                    view.onSaveRandRights(true, 1);
                    break;
                case "RAND_RIGHTS_ALL_DEL":
                    view.onSaveRandRights(true, 2);
                    break;
            }
        },

        onSaveRandRights: function (del, mode) {
            var view = this;
            var selectedRange;
            var selected = view.mainGrid.getSelectionModel().getSelected();
            if (!KS.isEmpty(selected) && !KS.isEmpty(selected.startCell) && !KS.isEmpty(selected.endCell)) {
                selectedRange = selected.getRange();
            }
            else { return }
            var selectedCell = [];
            for (var rowIdx = selectedRange[0][1]; rowIdx <= selectedRange[1][1]; rowIdx++) {
                var rec = view.mainGrid.getStore().getAt(rowIdx),
                    dictionLink = KS.Grid.getAnyCase(rec, 'LINK_DICTION_ROW'),
                    groupLink = KS.Grid.getAnyCase(rec, 'LINK_DICTION_ROW_GROUP') || 0,
                    linkSavedRow = KS.Grid.getAnyCase(rec, 'LINK_SAVED_ROW');
                for (var colIdx = selectedRange[0][0]; colIdx <= selectedRange[1][0]; colIdx++) {
                    var colDesc = view.mainGrid.getVisibleColumns()[colIdx].tag;
                    if (colDesc && dictionLink > 0) {
                        selectedCell.push({
                            LINK_COL: colDesc.ColumnLink,
                            LINK_DICTION_ROW_GROUP: groupLink,
                            LINK_DICTION_ROW: dictionLink,
                            LINK_SAVED_ROW: linkSavedRow
                        });
                    }
                }
            }
            view.doOnSaveRandRights(del, mode, selectedCell);
        },

        doOnSaveRandRights: function (del, mode, selectedCell) {
            this.serverCall({
                method: "OnSaveRandRights",
                waitMessage: 'Установка прав доступа ...',
                params: [del, mode, selectedCell],
                success: this.onSaveRandRightsCallback
            });
        },

        onSaveRandRightsCallback: function (disabledCells) {
            if (disabledCells) {
                this.data.visualSettings.disabledCells = disabledCells;
                this.resetGridPage();
            }
        },

        loadColumnsRights: function () {
            this.parentView.serverCall({
                method: "LoadColumnsRights",
                waitMessage: 'Загрузка прав доступа ...',
                success: this.parentView.showColumnRights
            });
        },

        showColumnRights: function (data) {
            var view = this;
            view.tpl.controls.columnRightsGrid.value = data;
            var columnRightsGrid = KS.create(view.tpl.controls.columnRightsGrid);
            var columnsWin = KS.showModal(columnRightsGrid, {
                title: 'Выбор столбцов для запрета доступа',
                autoHeight: false,
                height: 450,
                buttonAlign: 'left',
                buttons: [{
                    xtype: 'buttongroup',
                    id: 'props',
                    title: 'Настройки',
                    columns: 1,
                    defaults: {
                        scale: 'medium',
                        xtype: 'checkbox',
                        checked: false
                    },
                    items: [{
                            id: 'childReports',
                            boxLabel: 'Применить ко всем нижестоящим отчетам',
                            handler: function(component, newValue) {
                                if (newValue) {
                                    Ext.get('allReports').component.setValue(false);
                                }
                            }
                        }, { xtype: 'tbspacer', width: 15 },
                        {
                            boxLabel: 'Применить ко всем отчетам',
                            id: 'allReports',
                            handler: function(component, newValue) {
                                if (newValue) {
                                    Ext.get('childReports').component.setValue(false);
                                }
                            }
                        }]
                },
                    '->',
                    {
                        text: 'Применить',
                        cls: 'marked-button',
                        handler:
                            function () {
                                var denyMode = (Ext.get('allReports').component.value) ? 2 :
                                    ((Ext.get('childReports').component.value) ? 1 : 0);
                                view.saveColumnRights(columnsWin.getComponent('columnRightsGrid').getSelection(), denyMode);
                                columnsWin.close();
                            }
                    }, { xtype: 'tbspacer', width: 8 }, {
                        text: 'Отмена',
                        cls: 'dim-button',
                        handler: function () {
                            columnsWin.close();
                        }
                    }]
            }, true);
        },

        saveColumnRights: function (checkList, denyMode) {
            var view = this,
                checkedColLink = [];
            for (var checkColumn in checkList) {
                if( checkList.hasOwnProperty(checkColumn) ) {
                    checkedColLink.push(checkList[checkColumn].get("LINK_COL"));
                }
            }
            view.serverCall({
                method: 'DoSaveColumnRights',
                waitMessage: 'Сохранение ...',
                params: [checkedColLink, denyMode],
                success: view.saveColumnRightsCallback
            });
        },

        saveColumnRightsCallback: function (columnLinks) {
            this.resetGridPage();
            this.setHeaderColor(false, columnLinks);
        },
        
        selectVisibleGroups: function () {
            var view = this.parentView;
            var groupsGrid = KS.create(view.tpl.controls.groupsGrid);
            
            var visibleGroups = view.getVisibleGroups();
            groupsGrid.store.each(function(rec) {
                var code = KS.Grid.getAnyCase(rec, "CODE");
                if (visibleGroups.indexOf(code) !== -1) 
                    groupsGrid.checkRecord(rec, true, true);
            });

            var groupsWin = KS.showModal(groupsGrid, {
                title: 'Выбор групп для отображения',
                autoHeight: false,
                height: 400,
                buttonAlign: 'left',
                buttons: ['->', {
                    text: 'Выбрать',
                    scope: this,
                    handler: function () {
                        var grid = groupsWin.getComponent('groupsGrid'),
                            selection = grid.getSelection();
                        if (Ext.isEmpty(selection)) {                    // Если ничего не выбрано, 
                            selection = { 0 : grid.getStore().getAt(0)}; // выбирать первую строку
                        }
                        view.setVisibleGroups(selection);
                        groupsWin.close();
                    }
                },{ xtype: 'tbspacer', width: 8 },
                    {
                        text: 'Отмена',
                        cls: 'dim-button',
                        handler: function() {
                            groupsWin.close();
                        }
                    }]
            }, true);
        },

        getVisibleGroups: function() {
            var checkedColumns = [];
            this.mainGrid.eachColumnCfg(function(column) {
                if (!Ext.isEmpty(column.renderer) && !column.hidden &&
                    !Ext.isEmpty(column.parentGroup)) {
                    checkedColumns.push(column.parentGroup.header);
                }
            });

            var onlyUnique = function (value, index, self) { 
                return self.indexOf(value) === index;
            }
            return checkedColumns.filter(onlyUnique);
        },

        setVisibleGroups: function (checkList) {
            var columns = [];
            for (var checkColumn in checkList) {
                if( checkList.hasOwnProperty(checkColumn) ) {
                    if (checkList[checkColumn].data.CODE === this.emptyStringValue) {
                        columns.push("&nbsp;");
                    } else {
                        columns.push(checkList[checkColumn].data.CODE);
                    }
                }
            }
            this.mainGrid.eachColumnCfg(function(column) {
                if (!Ext.isEmpty(column.renderer)) {
                    if (column.visibility !== false && (!Ext.isEmpty(column.parentGroup) && 
                        columns.indexOf(column.parentGroup.header) !== -1 ||
                        column.isCheckColumn)) {
                        column.setHidden(false);
                    } else {
                        column.setHidden(true);
                    }
                }
            });
        },

        deleteSettings: function() {
            var view = this.parentView || this;
            KS.confirm("Восстановить внешний вид по умолчанию?", "Внимание",
                function(btn) {
                    if (btn === 'yes') {
                        view.serverCall({
                            method: 'ClearMainGridProfile',
                            params: [view.cachedValues],
                            success: function(newMainGrid){
                                view.saveProfile(null);
                                view.recreateMainGrid(newMainGrid);                            
                            }
                        });
                    }
            });            
        },
        
        recreateMainGrid: function(newMainGrid){
            var mainGrid = this.mainGrid;
            var parentGridPanel = mainGrid.ownerCt;
            var gridIndex = parentGridPanel.items.items.indexOf(mainGrid);
            parentGridPanel.remove(mainGrid);
            this.mainGrid = this.createTemplateControl(newMainGrid);
            parentGridPanel.insert(gridIndex, this.mainGrid);
            
            this.cachedValues = [];
            this.mainGrid.reload();

            if (this.mainGrid != null)
                this.addLockedGridFilterFunctions();
            
            this.customClipboardPlugin();
            
            if (KS.browser.OS === "Android") 
                this.mainGrid.on('cellclick', this.cellClickHandlerAndroid, this);

            this.addHideColumnsButton();
            this.customColumns();
            this.setCountRowsInHeader();
            this.setHeaderColor(true);
            this.customFilterMenuItems();
        },

        setManualHeaderRowsHeight: function() {
            var view = this.parentView || this;
            var headerRowsHeightWin = KS.showModal({
                xtype: 'numberfield',
                anchor: '100%',
                itemId: 'rowsHeight',
                fieldLabel: 'Число строк в заголовках таблицы:',
                labelWidth: 220,
                padding: 10,
                value: view.data.countRowsInHeader ? view.data.countRowsInHeader : 1,
                maxValue: view.maxCountRowsInHeader,
                minValue: 1
            }, {
                layout: 'vbox',
                plain: true,
                frame: true,
                modal: true,
                minHeight: 110,
                height: 110,
                width: 420,
                resizable: false,
                title: "Установить высоту заголовков таблицы",
                buttonAlign: 'right',
                buttons: [{
                        text: 'Сохранить',
                        cls: 'marked-button',
                        handler: function() {
                            var rowsCount = headerRowsHeightWin.getComponent("rowsHeight").getValue();
                            view.serverCall({
                                method: 'SetHeaderRowsHeight',
                                disableFog: true,
                                params: [rowsCount]
                            });
                            view.data.countRowsInHeader = rowsCount;
                            view.setCountRowsInHeader();
                            headerRowsHeightWin.close();
                        }
                    }, {
                        text: 'Отмена',
                        cls: 'marked-button',
                        handler: function() {
                            headerRowsHeightWin.close();
                        }
                    }]
            }, true);
        },

        setAdditionalStyles: function() {
            this.addCountRowsInHeaderStyles();
            this.setRowsHeight();
            this.setColumnsAlign();
        },

        addCountRowsInHeaderStyles: function() {
            if (this.mainGrid && this.data.countRowsInHeader > 0) {
                if (!window.reportTableCountRowsInHeaderClassAdded) {
                    var rowHeight = KS.theme === 'Classic' ? 13 : 16;
                    for (var countRows = 1; countRows <= this.maxCountRowsInHeader; countRows++) {
                        $("<style type='text/css'>" +
                            ".tableHeaderRows" + countRows + " .ks-column-header-text {" +
                            "white-space: normal !important;" +
                            "overflow: hidden !important;" +
                            "text-align: center;" +
                            "height: auto;" +
                            "max-height: " + (countRows * rowHeight).toString() + "px;" +
                            "}</style>").appendTo("head");
                    }
                    window.reportTableCountRowsInHeaderClassAdded = true;
                }
                this.setCountRowsInHeader();
            }
        },

        setCountRowsInHeader: function() {
            if (this.mainGrid && this.data.countRowsInHeader > 0) {
                var countRows = this.data.countRowsInHeader;
                for (var i = 1; i <= this.maxCountRowsInHeader; i++) {
                    this.mainGrid.removeCls("tableHeaderRows" + i);
                }
                this.mainGrid.addCls("tableHeaderRows" + countRows);
                KS.updateLayout(this.mainGrid);
            }
        },
        
        setRowsHeight: function() {
            var rh = this.data.rowHeight;
            if (!window.reportTableRowClassAdded && rh > 0 && rh != 20) {
                $("<style type='text/css'>" +
                    ".report-table-grid .x-grid-row td .x-grid-cell-inner {height:" + rh + "px; white-space : normal; }" +
                    "</style>").appendTo("head");
                window.reportTableRowClassAdded = true;
            }
        },    

        setColumnsAlign: function() {
            if (!window.reportTableColumnAlignClassAdded) {
                $("<style type='text/css'>" +
                    ".report-table-grid .x-column-header-text-container {text-align: center; }" +
                    "</style>").appendTo("head");
                window.reportTableColumnAlignClassAdded = true;
            }
        },

        setHeaderColor: function(isFirstLoad, columnLinks) {
            var grid = this.mainGrid;
            if (isFirstLoad) {
                grid.eachColumnCfg(function(column) { // При первой загрузке страницы
                    if (!Ext.isEmpty(column.tag) && column.tag.DisableReason === 2) {
                        if (!column.hasCls('closed-column'))
                            column.addCls('closed-column');
                    } else {
                        if (column.hasCls('closed-column'))
                            column.removeCls('closed-column');
                    }
                });
            } else {
                grid.eachColumnCfg(function(column) { // При изменении прав на колонки
                    if (!Ext.isEmpty(column.tag)) {
                        if (!Ext.isEmpty(columnLinks) && columnLinks.indexOf(column.tag.ColumnLink) !== -1) {
                            if (!column.hasCls('closed-column'))
                                column.addCls('closed-column');
                            column.tag.DisableReason = 2;
                        } else {
                            if (column.hasCls('closed-column'))
                                column.removeCls('closed-column');
                            column.tag.DisableReason = 0;
                        }
                    }
                });
            }
            
            KS.updateLayout(this.mainGrid);
        },

        deleteGroup: function() {
            var view = this.parentView || this,
                selection = view.mainGrid.selection;
            if (!KS.isEmpty(selection)) {
                var linkSavedRow = KS.Grid.getAnyCase(selection, 'LINK_SAVED_ROW');
                view.serverCall({
                    method: 'GetGroupCode',
                    params: [linkSavedRow],
                    success: view.doDeleteGroup
                });
            }
        },

        doDeleteGroup: function(groupGode) {
            var view = this;
            if (!KS.isEmpty(groupGode)) {
                KS.confirm("Удалить данные группы " + groupGode + "?", "Внимание",
                    function(btn) {
                        if (btn === 'yes') {
                            var groupLink = KS.Grid.getAnyCase(view.mainGrid.selection, "LINK_DICTION_ROW_GROUP");
                            view.serverCall({
                                method: 'DeleteGroup',
                                waitMessage: 'Удаление ...',
                                params: [groupLink],
                                success: function() {
                                    view.touch();
                                    view.mainGrid.reload();
                                    view.removeBoldTextInNode();
                                }
                            });
                        }
                    });
            }
        },

        openSidewallDict: function() {
            var view = this.parentView || this,
                operationCode = this.config.tbarNode.code;
            view.serverCall({
                params: [operationCode],
                waitMessage: "Открытие справочника боковика...",
                method: 'OpenSidewallDict'
            });
        },        
        
        openGroupDict: function() {
            var view = this.parentView || this,
                operationCode = this.config.tbarNode.code;
            view.serverCall({
                params: [operationCode],
                waitMessage: "Открытие справочника групп...",
                method: 'OpenGroupDict'
            });
        },
        
        switchGroupTree: function() {
            var view = this.parentView || this;
            if (!Ext.isEmpty(view.baseTree)) {
                if (view.baseTree.getCollapsed())
                    view.baseTree.expand();
                else
                    view.baseTree.collapse();
            }
        },

        sumHandler: function() {
            var view = this.parentView || this;
            var doubleSummaryLock = view.mainGrid.lockedGrid.getView().findFeature('doubleSummary');
            if (doubleSummaryLock) {
                doubleSummaryLock.toggleSummaryRow();
                view.updateSummaryRow();
            }
        },

        groupByCode: function() {
            var view = this.parentView || this;
            view.toggleGroupingFeature();
        },

        toggleGroupingFeature: function() {
            var groupingFeature = this.mainGrid.lockedGrid.getView().findFeature('grouping');
            if (groupingFeature.disabled) {
                groupingFeature.enable();
            } else {
                groupingFeature.disable();
            }
        },

        // Настраиваемая группировка по части кода
        groupByCodePart: function() {
            var view = this.parentView || this;
            view.serverCall({
                method: 'GetCodeColumn',
                success: view.showCodePartPanel
            });
        },

        showCodePartPanel: function(codeColumns) {
            var view = this;
            var options = new Ext.form.CheckboxGroup({
                layout: "vbox",
                id: "checkBoxOptions",
                width: "100%",
                padding: '5 0 0 5',
                border: false
            });

            var maxLength = 0;

            Ext.each(codeColumns,function(column) {
                options.add({
                    xtype: "checkbox",
                    boxLabel: column.Name,
                    tag: column
                });
                maxLength += column.Length;
            });

            var typeGroupBox = new Ext.Panel({
                title: "Вид",
                layout: "fit",
                width: "100%",
                height: 80,
                hidden: codeColumns.length === 1,
                id: "typeGroupBox",
                items: [{
                    xtype: 'radiogroup',
                    padding: '5 0 0 5',
                    vertical: false,
                    columns:1,
                    id: "typeRadioGroup",
                    items: [
                        { boxLabel: 'На основе структурного кода', name: 'typeGroup', inputValue: '0', checked: true},
                        { boxLabel: 'Произвольная группировка', name: 'typeGroup', inputValue: '1'}
                    ],
                    listeners: {
                        change: function(comp, newValue) {
                            Ext.getCmp("ultraTabSharedControlsPage").getLayout().setActiveItem(parseInt(newValue.typeGroup));
                        }
                    }
                }]
            });

            var ultraTabSharedControlsPage = new Ext.Panel({
                layout: "card",
                width: "100%",
                activeItem: codeColumns.length === 1 ? 1 : 0,
                id: "ultraTabSharedControlsPage",
                items: [
                    options,
                    {
                        xtype: 'panel',
                        layout: "vbox",
                        border: false,
                        items:[
                            {
                                xtype: 'numberfield',
                                labelWidth: 150,
                                anchor: '100%',
                                id: 'startPositionCodePart',
                                fieldLabel: 'Начальная позиция',
                                padding: '5 0 0 5',
                                value: 1,
                                maxValue: maxLength,
                                minValue: 1
                            }, {
                                xtype: 'numberfield',
                                labelWidth: 150,
                                anchor: '100%',
                                id: 'endPositionCodePart',
                                fieldLabel: 'Конечная позиция',
                                padding: '0 0 0 5',
                                value: maxLength,
                                maxValue: maxLength,
                                minValue: 1
                            }
                        ]
                    }
                ]
            });
            
            var groupBoxRows = new Ext.Panel({
                title: "Группирующие строки в отчете",
                layout: "fit",
                width:"100%",
                id: "groupBoxRows",
                items: [{
                    xtype: 'radiogroup',
                    vertical: true,
                    columns: 2,
                    padding: '0 0 0 5',
                    id: "groupRowsRadioGroup",
                    items: [
                        { boxLabel: 'Свернуть', name: 'groupBox', inputValue: '0', checked: true},
                        { boxLabel: 'Развернуть', name: 'groupBox', inputValue: '1'}
                    ]
                }]
            });

            var codePartPanel = KS.showModal(
                [typeGroupBox,
                 ultraTabSharedControlsPage,
                 groupBoxRows], {
                layout: 'vbox',
                plain: true,
                frame: true,
                autoScroll: true,
                modal: true,
                maximizable: true,
                minWidth: 400,
                minHeight: 200,
                title: "Настраиваемая группировка по части кода",
                buttonAlign: 'right',
                buttons: [{
                        text: 'ОК',
                        cls: 'marked-button',
                        handler: function() {
                            var optionSet = Ext.getCmp("typeRadioGroup").getValue().typeGroup,
                                groupRowsOption = Ext.getCmp("groupRowsRadioGroup").getValue().groupBox,
                                startPosition = Ext.getCmp("startPositionCodePart").getValue(),
                                endPosition = Ext.getCmp("endPositionCodePart").getValue(),
                                checkBoxOptions = Ext.getCmp("checkBoxOptions"),
                                columns = [];

                            checkBoxOptions.eachBox(function(item){
                                if (item.getValue()) {
                                    columns.push(item.tag);
                                }
                            });

                            view.serverCall({
                                params: [optionSet, groupRowsOption, startPosition, endPosition, columns],
                                method: 'DoGroupByCode',
                                success: function() {
                                    codePartPanel.close();
                                }
                            });
                        }
                    }, {
                    text: 'Отмена',
                    cls: 'marked-button',
                    handler: function() {
                        codePartPanel.close();
                    }
                }]
            }, true);
        },

        setVisiblColumns: function() {
            var view = this.parentView || this;
            var visibleColumns = [];
            view.mainGrid.eachColumnCfg(function (column) {
                    if (column.dataIndex && !Ext.isEmpty(column.renderer) && column.hidden !== true) {
                        visibleColumns.push(column.dataIndex);
                    }
                });
            view.serverCall({
                method: "PrepareColumnsGrid",
                params: [visibleColumns],
                success: view.createVisibleColumnsPanel
            });
        },

        createVisibleColumnsPanel: function(visibleColumnsGrid) {
            var view = this;
            view.visibleColumnsGrid = KS.create(visibleColumnsGrid);
            view.visibleColumnsWin = KS.showModal(view.visibleColumnsGrid, {
                title: 'Выбор колонок',
                autoHeight: false,
                resizable: true,
                autoScroll: true,
                maximizable: true,
                width: Math.max(400, KS.rootViewport.getWidth() / 2),
                height: Math.max(300, KS.rootViewport.getHeight() / 1.5),
                minHeight: 300,
                minWidth: 400,
                buttonAlign: 'left',
                buttons: ['->', {
                            text: 'ОК',
                            cls: 'dim-button',
                            handler: function () {
                                view.doVisibleColumns(view.visibleColumnsGrid.getSelection());
                            }
                        }, { xtype: 'tbspacer', width: 8 },
                        {
                            text: 'Отмена',
                            cls: 'dim-button',
                            handler: function() {
                                view.visibleColumnsWin.close();
                            }
                        }]
            }, true);
        },

        doVisibleColumns: function(checkList) {
            var view = this,
                colNames = [];
            for (var checkColumn in checkList) {
                if( checkList.hasOwnProperty(checkColumn) ) {
                    colNames.push(checkList[checkColumn].get("CODE"));
                }
            }
            this.mainGrid.eachColumnCfg(function(column) {
                if (!Ext.isEmpty(column.renderer)) {
                    if (column.visibility !== false && 
                        (colNames.indexOf(column.dataIndex) !== -1 ||
                        column.isCheckColumn)) {
                        column.setHidden(false);
                    } else {
                        column.setHidden(true);
                    }
                }
            });
            view.visibleColumnsWin.close();
        },

        addHideColumnsButton: function() {
            var panelWithToolbar = (this.baseTree && !this.data.isRRO) ? this.tableRootPanel : this.mainGrid;
            this.getToolbar(panelWithToolbar).insert(0, this.mainGrid.createHideButton());
        },

        customColumns: function(){
            this.mainGrid.eachColumnCfg(function(column){
                if (column.renderer === reportCheckboxRenderer){
                    // Удаляем платформенный checkchange из renderer.js
                    column.clearListeners();
                    // Добавляем свои евенты
                    column.on({
                        beforecheckchange: function (column, rowIndex, checked, record) {
                            if (isCellDisabled(record, column) || getItemProperties(record, column.dataIndex).IsReadOnly) {
                                return false;
                            }
                        },
                        checkchange: function (column, rowIdx, checked, record, e) {
                            column.grid.fireEvent("edit", e,
                                {
                                    record: record,
                                    field: column.dataIndex,
                                    value: checked ? 1 : 0,
                                    originalValue: checked ? 0 : 1
                                });
                        }
                    });
                }
            })
        },

        headerClick: function(ct, column) {
            if (column.isCheckColumn) {
                var grid = this.mainGrid,
                    selModel = grid.getSelectionModel(),
                    selRowsCount = selModel.getStoreSelection().length,
                    store = grid.store,
                    storeCount = store.getCount(),
                    allSelected = selRowsCount === storeCount;
                this.setAllCheckState(!allSelected, grid);
                selModel.checkColumn.setHeaderStatus(!allSelected);
            }
            return false;
        },

        tableNoteRendered: function(comp) {
            var view = this;
            comp.body.on('click', function(event) {
                view.tableNoteLinkClick(event);
            });
        },

        tableNoteLinkClick: function(e) {
            if (e.target.href && e.target.href.toLowerCase().indexOf("svod_file:") !== -1) {
                e.preventDefault();
                this.serverCall({
                    method: 'TitleLabelOnLinkClicked',
                    params: [e.target.href],             
                    disableFog: true
                });
            }
        },

        clearAllFilters: function(){
            var view = this.parentView || this,
                grid = view.mainGrid;
            if (grid.hasOwnProperty("isLocked"))
                grid.ownerGrid.removeGridFilter();
            else
                grid.removeGridFilter();            
        }
    });
}(SavedFormTableView.prototype));

// ============= GROUPS =======================
(function (viewClass) {
    KS.apply(viewClass, {
        selectGroup: function(groupLink) {
            if (!Ext.isEmpty(this.baseTree.pathToSelectNode)) return;// Чтобы не было лишних обновлений до окончательного выбора узла при обновлении
            if (groupLink && !Ext.isNumber(groupLink))
                groupLink = null;
            var view = this;
            view.serverCall({
                method: 'SetActiveGroup',
                waitMessage: 'Установка ...',
                params: [groupLink || view.getSelectedNodeId(), this.cachedValues],
                success:function (result) {
                    var activeGroup = result.activeGroup;
                    view.cachedValues = [];
                    if (activeGroup) {
                        view.data.activeGroup = activeGroup;
                        view.GroupsContainer_unidict.setValue(activeGroup.Code);
                    }
                    if (groupLink &&
                        groupLink == view.data.activeGroup.DictionRowLink &&
                        groupLink != view.getSelectedNodeId()) {
                        var node = view.findGroupTreeNode(view.data.activeGroup.DictionRowLink);
                        if (node) {
                            var nodePath = node.getPath().split('/'); 
                            view.selectNodeByPath(nodePath);
                        }
                    }
                    view.setEditState();
                    if (result.disabledCells) {
                        view.data.visualSettings.disabledCells = result.disabledCells;
                    }
                    view.resetGridPage();
                } 
            });
        },

        selectGroupByDict: function() {
            var view = this.parentView || this,
                operationCode = this.config.code;
            view.serverCall({
                method: 'SelectGroupByDict',
                params: [operationCode],
                waitMessage: "Открытие справочника..."
            });
        },

        resetGroupTree: function () {
            if (!this.data.showGroupTree) return;
            var root = this.baseTree.getRootNode();
            if (Ext.isEmpty(root.childNodes)) {
                KS.error('Справочник групп пуст');
                return;
            }
            if (this.baseTree.touchedNonSavedData) {
                this.savePathToSelectNode();  
                this.baseTree.getRootNode().removeAll(true);
                this.baseTree.fullReload();
            } else {
                if (this.data.isRRO) {
                    var activeGroupLink = (this.data.activeGroup) ? this.data.activeGroup.DictionRowLink : 0;
                    if (activeGroupLink === 0) {
                        this.baseTree.selectFirstNode();
                    }
                } else {
                    this.selectGroup();
                }
            }
            this.baseTree.touchedNonSavedData = false;
        },

        savePathToSelectNode: function() {  // Запоминаем путь до выбранного узла
            var path =  this.baseTree.getSelNode().getPath().split('/');
            if (Ext.isEmpty(path[0]) && path.length > 1) {
                path.shift();
            }
            this.baseTree.pathToSelectNode = path;
        },

        baseTreeNodeLoad: function() {  
            if (!Ext.isEmpty(this.baseTree.pathToSelectNode)) {
                this.selectNodeBySavePath(this.baseTree.pathToSelectNode);
            }
        },

        selectNodeBySavePath: function(path) {
            var selNode = this.baseTree.getStore().getNodeById(path[0]);
            if (selNode) {
                if (path.length === 1) {  
                    this.baseTree.pathToSelectNode = [];
                    this.baseTree.setSelected(path[0]);
                } else {
                    this.baseTree.pathToSelectNode.shift();
                    if (!selNode.isRoot()) {
                        selNode.expand(); // запускает baseTreeNodeLoad
                    } else {
                        this.selectNodeBySavePath(this.baseTree.pathToSelectNode);
                    }
                }
            }
        },

        selectNodeByPath: function(path) {
            if (Ext.isEmpty(path[0]) && path.length > 1) 
                path.shift();
            var selNode = this.baseTree.getStore().getNodeById(path[0]);
            if (selNode) {
                if (path.length === 1) {  
                    this.baseTree.setSelected(path[0]);
                } else {
                    path.shift();
                    if (!selNode.isRoot()) 
                        selNode.expand();
                    this.selectNodeByPath(path);
                }
            }
        },

        getDefaultGroupValue: function () {
            return (this.defaultGroup) ? this.defaultGroup.getValue() : null;
        },

        touchActiveGroup: function () {
            if (this.data.showGroupTree && this.data.activeGroup) {
                var groupNode = this.findGroupTreeNode(this.data.activeGroup.DictionRowLink);
                if (!Ext.isEmpty(groupNode)) {
                    var columnValues = groupNode.get("columnValues");
                    if (!Ext.isEmpty(columnValues)) {
                        for (var valueName in columnValues) {
                            if (columnValues.hasOwnProperty(valueName) ) {
                                var valueText = groupNode.get(valueName);
                                if (valueText.indexOf('<b>') < 0 && valueName.indexOf('linkSetting') < 0) {
                                    groupNode.set(valueName, '<b>' + valueText + '</b>');
                                    this.baseTree.touchedNonSavedData = true;
                                }
                            }
                        }
                    }
                }
            }
        },

        removeBoldTextInNode: function() {
            if (this.data.showGroupTree && this.data.activeGroup &&
                !this.gridStoreNotEmpty()) {
                var groupNode = this.findGroupTreeNode(this.data.activeGroup.DictionRowLink);
                if (!Ext.isEmpty(groupNode)) {
                    var columnValues = groupNode.get("columnValues");
                    if (!Ext.isEmpty(columnValues)) {
                        for (var valueName in columnValues) {
                            if (columnValues.hasOwnProperty(valueName) ) {
                                var valueText = groupNode.get(valueName);
                                if (valueText.indexOf('<b>') >= 0) {
                                    valueText = valueText.replace(/<b>/g, "");
                                    valueText = valueText.replace(/<\/b>/g, "");
                                    groupNode.set(valueName, valueText);
                                    this.baseTree.touchedNonSavedData = true;
                                }
                            }
                        }
                    }
                }
            }
        },
        
        findGroupTreeNode: function (groupLink) {
            return this.baseTree.getRootNode().findChildBy(function (node) {
                return node.id.split('_')[0] == groupLink;
            }, this, true);
        }
    });
}(SavedFormTableView.prototype));

// ============= EDIT =======================
(function (viewClass) {
    KS.apply(viewClass, {

        touch: function () {
            this.hasChanges = true;
            this.parentView.touch(true);
        },

        discardChanges: function (batch) {
            if (this.data.isHtmlForm)
                this.richEditFrame.discardChanges();
            this.hasChanges = false;
            this.needFlush = false;
            this.cachedValues = [];
            if (!this.data.isHtmlForm && this.mainGrid && this.mainGrid.getStore()) {
                this.mainGrid.getStore().commitChanges();
            }
            this.parentView.trySetSavedState();
            if (batch === true) {
                this.parentView.processQueuedActions();
            }
        },

        setEditState: function () {
            if (this.data.isHtmlForm) {
//                this.getToolbarItem(this.parentView.rootPanel, null, 'SAVE').setDisabled(false);
                return;
            }

            var readOnly = this.reportReadOnly();
            var staticTable = this.data.isStatic;
            var allowDenyColumns = this.parentView.reportAllowDenyColumns();

            this.setToolbarsButtonState("NEW", readOnly && !staticTable, !readOnly && !staticTable);
            this.setToolbarsButtonState("DELETE_MENU", readOnly && !staticTable, !readOnly && !staticTable);
            this.setToolbarsButtonState("GROUP_DELETE", readOnly, !readOnly);
            this.setToolbarsButtonState("COPY_ROW", readOnly, !readOnly);
            this.setToolbarsButtonState("COPY_COLUMN", readOnly, !readOnly);
            this.setToolbarsButtonState("PASTE", readOnly, !readOnly);
            this.setToolbarsButtonState("DATA", readOnly, !readOnly);
            this.setToolbarsButtonState("AUTO_CALCULATE", readOnly, !readOnly);
            this.setToolbarsButtonState("SWITCH_VIEW_GROUP", !this.data.showGroupTree, this.data.showGroupTree);
            this.setToolbarsButtonState("SETTINGS", allowDenyColumns === false, allowDenyColumns !== false, "COLUMN_RIGHTS");
            this.setToolbarsButtonState("COPY", readOnly, !readOnly, "COPY_ROW");
            this.setToolbarsButtonState("COPY", readOnly, !readOnly, "COPY_COLUMN");

            if (this.data.countRowsInHeader) {
                this.setCountRowsInHeader();
            }
        },

        setToolbarsButtonState: function (code, disable, visible, childCompCode) {
            var panel = this.mainGrid;
            if (this.data.showGroupTree && !Ext.isEmpty(this.baseTree)) {
                panel = this.tableRootPanel;
            }
            var button = this.getToolbarItem(panel, null, code);
            if (!Ext.isEmpty(button)) {
                if (!Ext.isEmpty(childCompCode)) {  //Если нужно взять компонент из подменю
                    button = button.getMenu().items.findBy(function(item) {
                        return (item && item.tbarNode && (item.tbarNode.code === childCompCode));
                    });
                    if (Ext.isEmpty(button)) return;
                }
                button.setDisabled(disable);
                button.setVisible(visible);
            }
        },

        validateCellValue: function (cvalue, fromDict) {
            cvalue.Value = cvalue.Value || {};
            var colCfg = this.mainGrid.getColConfigByKey(cvalue.ColKey),
                clen = (colCfg && colCfg.tag) ? colCfg.tag.ActualLength : 0,
                directValue = cvalue.Value.Direct;
            if (!colCfg) return true;
            switch (colCfg.renderer) {
                case numberRenderer:
                    if (colCfg.tag && !colCfg.tag.hasOwnProperty("DefaultValue") && Ext.isEmpty(directValue)) // DefaultValue == null
                        cvalue.Value.Direct = null;
                    else
                        cvalue.Value.Direct = KS.Svod.normalizeFloatValue(directValue, clen);
                    break;
                case sidewallRenderer:
                case groupRenderer:
                    if (!Ext.isEmpty(directValue) && clen > 0 && directValue.length > clen && fromDict !== true) {
                        KS.alert("Введенное значение превышает допустимую длину.");
                        return false;
                    }
                    if (!KS.Svod.isMathesMask(directValue, colCfg.tag.Mask)) {
                        KS.alert("Введенное значение не соответствует маске.");
                        return false;
                    }
                    break;
                default:
                    if (colCfg.dataType === "system.decimal") 
                        cvalue.Value.Direct = KS.Svod.normalizeFloatValue(directValue, clen);
                    break;
            }
            return true;
        },

        // needFlush - пока везде false
        // fromDict - ни в одном вызове функции не задаётся
        // forceDisable - нигде не используется
        // isDeleteHandler - задаётся true только при запуске после нажатия кнопки Delete
        saveCellValue: function (rec, colKey, cellValue, originalValue, needFlush, fromDict, forceDisable, isDeleteHandler) {
            var view = this;

            var cellIndex = view.mainGrid.getColIndexByKey(colKey);
            if ((isCellDisabled(rec, cellIndex) || getItemProperties(rec, colKey).IsReadOnly) &&
                isDeleteHandler !==true){// || !colCfg.editable) {
                return false;
            }

            view.touch();
            view.fillFakeLinks(rec);

            var isNewRow = (colKey == null && cellValue == null);

            // if (cellValue && typeof (cellValue) == "string") {
            //     cellValue = cellValue.replace(/\r/g, "");
            //     cellValue = cellValue.replace(/\n/g, "");
            // }
            if (Ext.isDate(cellValue)) {
                cellValue = Ext.util.Format.date(cellValue, "d.m.Y");
            }
            
//            if (Ext.isDate(cellValue)) {
//                switch (colCfg.dataType) {
//                case "date":
//                    cellValue = Ext.util.Format.date(cellValue, "d.m.Y");
//                    break;                    
//                case "datetime":
//                    cellValue = Ext.util.Format.date(cellValue, "d.m.Y H:i:s");
//                    break;
//                }
//            }
            var cvalue = buildCellValue(rec, colKey, cellValue, originalValue, isNewRow);
            if (!view.validateCellValue(cvalue, fromDict)) {
                rec.set(colKey, cvalue.OriginalValue);
                return false;
            }
            if (view.isSidewall(colKey)) {
                cvalue.FakeSavedLink = KS.getFakeLink();
                cvalue.FakeDictionLink = KS.getFakeLink();
            }
            rec.set(colKey, cvalue.Value.Direct);
            if (cvalue.Value.Direct !== cvalue.OriginalValue) {
                view.cachedValues.push(cvalue);
            }
            view.touchActiveGroup();
            if (!isNewRow) {
                view.touchRow(rec);
            }

            if (needFlush)
                view.needFlush = true;
            return true;
        },

        flushCachedValues: function (flushAllTables) {
            var view = this,
                needValidate = (flushAllTables === true),
                validateOnly = false,
                values;
            if (view.data.readOnly) return false;
            if (view.data.isHtmlForm) {
                var base64 = view.richEditFrame.exportToBase64();
                values = [buildCellValue(null, null, base64, null)];
                values[0].Value.Dictionary = {
                    key: view.editor.key
                };
            } else {
                if (Ext.isEmpty(view.cachedValues)) {
                    if (needValidate) {
                        validateOnly = true;
                        values = [];
                    } else {
                        view.needFlush = false;
                        view.parentView.flushAllTables();
                        return false;
                    }
                } else {
                    values = view.cachedValues;
                }
                view.cachedValues = [];
            }
            view.isFlushing = true;
            view.disableToolbar();
            view.serverCall({
                method: "SaveCells",
                params: [values, needValidate, (view.accumulate === true)],
                urgent: true,
                waitMessage: (validateOnly) ? "Проверка таблицы ..." : "Отправка данных на сервер ...",
                disableFog: !needValidate,
                success: function (saveResultList) {
                    view.needFlush = false;
                    view.accumulate = false;
                    if (view.hasSaveErrors(saveResultList)) {
                        if (!view.isDoubleCodeError(saveResultList))
                            view.parentView.resetQueuedActions();
                    } else {
                        if (!Ext.isEmpty(saveResultList) && !view.data.isHtmlForm)               
                            view.setVisSetBySaveResult(saveResultList);
                        if (flushAllTables === true) {
                            view.parentView.flushAllTables();
                        }
                    }
                },
                complete: function () {
                    view.enableToolbar();
                    view.isFlushing = false;
                },
                error: function () {
                    view.parentView.resetQueuedActions();
                }
            });
            return true;
        },

        onServerProcessSaveCachedValues: function (saveResultList) {
            if (!this.hasSaveErrors(saveResultList)) {
                this.isFlushing = false;
                this.needFlush = false;
                this.cachedValues = [];
            }
        },

        //Если поле nastr у строки изменилось, задать новое значение и перерендерить ячейки
        //newValue.Cvalue.VisualSetting - старое значение поля nastr
        setVisSetBySaveResult: function(newValues) {
            var view = this;
            Ext.each(newValues, function(newValue) {
                var newNastrValue = "";
                Ext.each(newValue.Actions, function(action) {
                    if (action.Arguments[0] === "nastr" || 
                        action.Arguments[0] === "NASTR") {
                        newNastrValue = action.Arguments[1];
                    }
                });
                if (Ext.isEmpty(newNastrValue) || 
                    newValue.Cvalue.VisualSettings === newNastrValue) {
                    return;
                }
                view.refillItemProperties();
                var rec = view.mainGrid.store.findRecord("link_saved_row", newValue.Cvalue.LinkSavedRow) ||
                          view.mainGrid.store.findRecord("LINK_SAVED_ROW", newValue.Cvalue.LinkSavedRow);
                if (rec)
                    rec.set("nastr", newNastrValue);
            });
        },

        hasSaveErrors: function (saveResultList) {
            var view = this,
                hasErrors = false,
                resultMsg = "";
            Ext.each(saveResultList, function (saveResult) {
                var psr = view.processSaveResult(saveResult);
                if (psr.hasErrors) hasErrors = true;
                if (!Ext.isEmpty(psr.msg)) resultMsg += psr.msg;
            });
            if (!Ext.isEmpty(resultMsg)) KS.alert(resultMsg);
            return hasErrors;
        },

//        updatePageCache: function() {
//            var grid = this.mainGrid,
//                store = grid.store,
//                hasPaging = grid.isPagingEnabled(),
//                pageSize = grid.getBand().PageSize,
//                totalCount = store.getTotalCount(),
//                realPageSize = hasPaging ? pageSize : totalCount,
//                currentPage = store.currentPage,
//                fromRecord = hasPaging ? ((currentPage - 1) * pageSize) : 0,
//                data = store.getProxy().data;
//
//            grid.pageCacheLib.set(grid.pageCacheLib.getKey({
//                    start: fromRecord,
//                    to: fromRecord + (pageSize - 1),
//                    gridKey: grid.ctrl.itemId,
//                    order: grid.getOrder(),
//                    filter: grid.getFilter()
//                }),
//                currentPage,
//                realPageSize,
//                data);
//        },
//
//        resetPageCache: function() {
//            this.mainGrid.pageCacheLib.reset();
//        },

        processSaveResult: function (saveResult) {
            if (!saveResult) return null;
            var view = this,
                rec = null,
                cvalue = saveResult.Cvalue,
                hasErrors = (saveResult.Error !== 0),
                resultMsg = '';
            Ext.each(saveResult.Messages, function (message) {
                resultMsg += '- ' + message + '<br />';
            });
            if (cvalue && !view.data.isHtmlForm && view.grid && view.grid.store) {
                rec = view.findRecBySavedLink(cvalue.LinkSavedRow);
            }
            Ext.each(saveResult.Actions, function (action) {
                var params = action.Arguments;
                switch (action.Cmd) {
                    case 1:
                        if (rec && cvalue) view.setTableValue(rec, cvalue.ColKey, cvalue.OriginalValue);
                        break;
                    case 2:
                        if (rec && !Ext.isEmpty(params[0])) view.setTableValue(rec, params[0], params[1]);
                        break;
                    case 42:
                        var rvr = action.Arguments[0];
                        if (rvr.Result === 1) hasErrors = true;
                        if (rvr.ErrorCode === 7) {
                            Ext.MessageBox.show({
                                icon: Ext.MessageBox.QUESTION,
                                title: 'Подтверждение',
                                msg: rvr.StringMessage,
                                buttons: Ext.MessageBox.YESNO,
                                fn: function (btn) {
                                    if (btn !== 'yes') return;
                                    view.accumulate = true;
                                    if (!Ext.isEmpty(view.parentView.queuedActions) &&
                                        view.parentView.queuedActions[0].cmd === 'save') {
                                        view.parentView.queuedActions.unshift({ cmd: 'flush' });
                                        view.parentView.processQueuedActions();
                                    } else {
                                        view.parentView.saveChanges();
                                    }
                                }
                            });
                        } else if (!Ext.isEmpty(rvr.StringMessage)) {
                            resultMsg += '- ' + rvr.StringMessage + '<br />';
                        }
                        break;
                }
            });
            return {
                msg: resultMsg,
                hasErrors: hasErrors
            };
        },

        isDoubleCodeError: function(saveResultList) {
            var result = false;
            Ext.each(saveResultList, function(saveResult) {
                if (!Ext.isEmpty(saveResult.Actions)) {
                    Ext.each(saveResult.Actions, function(action) {
                        if (action.Cmd === 42 && action.Arguments[0].ErrorCode === 7) {
                            result = true;
                        }
                    });
                }
            });
            return result;
        },

        editTable: function (e, context) {
            if (context.value === null) return false;
            if (context.value === context.originalValue) return false;
            this.saveCellValue(context.record, context.field, context.value, context.originalValue, false);
            if (this.needFlush) {
                this.flushCachedValues();
            }
            return true;
        },

        showPopupStringEditor: function (value, cfg, rec) {
            var view = this;
            view.pseWin = KS.showModal({
                xtype: 'textarea',
                itemId: 'pseArea',
                value: value
            },{
                layout: 'fit',
                plain: true,
                frame: true,
                autoScroll: true,
                modal: true,
                maximizable: true,
                minWidth: 400,
                minHeight: 300,
                width: Math.max(400, KS.rootViewport.getWidth() / 2),
                height: Math.max(300, KS.rootViewport.getHeight() / 1.5),
                title: view.getColumnName(cfg.text),
                buttonAlign: 'right',
                buttons: new Array({
                    text: 'Применить',
                    cls: 'marked-button',
                    handler: function () {
                        var newValue = view.pseWin.getComponent("pseArea").getValue();
                        view.saveCellValue(rec, cfg.dataIndex, newValue, value, false);
                        if (view.needFlush) {
                            view.flushCachedValues();
                        }
                        view.pseWin.close(true);
                    }
                })
            }, true);

            view.pseWin.getComponent("pseArea").selectText(value.length);
        },

        reportReadOnly: function() {
            return this.parentView.tableReadOnly(); //Берём isReadOnly из SavedFormModel
        },

        htmlEditorChange: function() {
            if (this.isHtmlReload) {
                this.isHtmlReload = false;
                return;
            }
            this.touch();
        },

        saveFiles: function (fileKeys) {
            var view = this.parentView || this;
            if (Ext.isEmpty(view.cellOptionsForFile)) {
                view.serverCall({
                    method: 'PasteExcelData',
                    params: [fileKeys],
                    waitMessage: 'Вставка ...',
                    success: view.saveExcelFileCallback
                });
            } else {
                view.selectFileForCell(fileKeys);
            }
        },

        saveExcelFileCallback: function (result) {
            this.touch();
            if (result === true) {
                this.resetGridPage();
            } else {
                KS.openSpreadsheetView(result, this);
            }
        },

        assignColumns: function () {
            this.serverCall({
                method: 'AssignColumns'
            });
        },

        showFileChooserPanel: function(dataIndex, rec) {
            var fileName = KS.Grid.getAnyCase(rec, dataIndex);

            this.selectCellFileBtn = KS.create({
                    type: 'filefield',
                    parentView: this,
                    itemId: 'selectCellFileBtn'
                },
                { 
                    buttonConfig: {
                        tooltip : 'Загрузить файлы',
                        iconCls: 'ks-icon-folder_open',
                        text: '',
                        width: 22
                    },
                    multiple: true,
                    buttonOnly: true,
                    emptyText: "Выберите файлы...",
                    width: 22
                });

            this.fileChooserPanel = new Ext.panel.Panel({
                bodyPadding: '5 0 5 0',
                layout: {
                    type: 'hbox',
                    align: 'begin'
                },
                items: [
                    {
                        xtype: 'button',
                        tooltip : 'Удалить файлы',
                        iconCls: 'ks-icon-delete',
                        margin: '0 3 0 3',
                        scope: this,
                        handler: this.deleteCellFile
                    }, {
                        xtype: 'textfield',
                        itemId: 'cellFileName',
                        value: fileName,
                        readOnly: true
                    },
                    {
                        xtype: 'button',
                        tooltip : 'Скачать файлы',
                        iconCls: 'ks-icon-save',
                        margin: '0 3 0 3',
                        scope: this,
                        handler: this.saveCellFile
                    },
                    this.selectCellFileBtn
                ]
            });

            var view = this;

            view.cellOptionsForFile = {
                dataIndex: dataIndex,
                linkSavedRow: KS.Grid.getAnyCase(rec, "LINK_SAVED_ROW"),
                linkTable: KS.Grid.getAnyCase(rec, "LINK_TABLE"),
                record: rec
            }

            this.fileChooserWin = KS.showModal(this.fileChooserPanel, {
                title: 'Выбор файла',
                autoHeight: false,
                resizable: false,
                maximizable: false,
                width: 265,
                minWidth: 265,
                height: 110,
                minHeight: 110,
                buttonAlign: 'center',
                buttons: new Array({
                        text: 'ОК',
                        cls: 'dim-button',
                        handler: function() {
                            view.fileChooserWin.close();
                            view.cellOptionsForFile = null;
                        }
                    })
            }, true);
        },

        selectFileForCell: function(fileKeys) {
            if (!Ext.isEmpty(fileKeys) && !Ext.isEmpty(this.cellOptionsForFile)) {
                var view = this;
                var msgs = [];
                var validFiles = [];
                Ext.each(fileKeys, function(fileKey){
                    var fileMsg = view.validateFile(fileKey.fileName, fileKey.fileExtension);
                    if (Ext.isEmpty(fileMsg))
                        validFiles.push(fileKey);
                    else
                        msgs.push(fileMsg);
                })

                if (!Ext.isEmpty(msgs))
                    KS.alert(msgs.join("<br>"));

                if (!Ext.isEmpty(validFiles)) {
                    var linkTable = this.cellOptionsForFile.linkTable;
                    var linkSavedRow = this.cellOptionsForFile.linkSavedRow;
                    var dataIndex = this.cellOptionsForFile.dataIndex;
                    this.serverCall({
                        method: "AttachFileToCell",
                        params: [linkTable, linkSavedRow, dataIndex, validFiles],
                        success: this.selectFileForCellCallback
                    });
                }
            }
        },

        validateFile: function (fileName, fileExtension) {
            var s = this.parentView.data.settings,
                maxLen = s.MaxFileNameLength,
                invalidExts = s.BadExtensions,
                validExts = KS.isEmpty(s.FileExtensions) ? [] : s.FileExtensions.split(", ");
            if (!KS.isEmpty(validExts) && validExts.indexOf(fileExtension) < 0)
                return "Тип файла " + fileExtension + " не разрешен для прикрепления";
            if (!KS.isEmpty(invalidExts) && invalidExts.indexOf(fileExtension) >= 0)
                return "Тип файла " + fileExtension + " запрещен для прикрепления";
            if (maxLen > 0 && fileName.length > maxLen) {
                return "Длина имени файла не должна превышать " + maxLen + " символов";
            }
            return "";
        },

        selectFileForCellCallback: function(fileNames) {
            var dataIndex = this.cellOptionsForFile.dataIndex;
            if (this.data.isTransform) {
                this.setTransformItemValue(dataIndex, fileNames);
                this.cellOptionsForFile = null;
            } else {
                var record = this.cellOptionsForFile.record;
                var oldValue = "";
                var fileNameField = this.fileChooserPanel.getComponent('cellFileName');
                if (fileNameField) {
                    oldValue = fileNameField.getValue();
                    fileNameField.setValue(fileNames);
                }
                this.saveCellValue(record, dataIndex, fileNames, oldValue, false);
            }
            this.touch();
        },

        saveCellFile: function() {
            var linkTable = this.cellOptionsForFile.linkTable;
            var linkSavedRow = this.cellOptionsForFile.linkSavedRow;
            var dataIndex = this.cellOptionsForFile.dataIndex;
            var view = this;
            this.serverCall({
                method: "SaveCellFile",
                params: [linkTable, linkSavedRow, dataIndex],
                success: function(){
                    if (view.data.isTransform) {
                        view.cellOptionsForFile = null;
                    }
                }
            });
        },

        deleteCellFile: function() {
            var linkTable = this.cellOptionsForFile.linkTable;
            var linkSavedRow = this.cellOptionsForFile.linkSavedRow;
            var dataIndex = this.cellOptionsForFile.dataIndex;
            this.serverCall({
                method: "DeleteCellFile",
                params: [linkTable, linkSavedRow, dataIndex],
                success: this.deleteCellFileCallback
            });
        },

        deleteCellFileCallback: function() {
            var dataIndex = this.cellOptionsForFile.dataIndex;
            if (this.data.isTransform) {
                this.setTransformItemValue(dataIndex, "");
                this.cellOptionsForFile = null;
            } else {
                var record = this.cellOptionsForFile.record;
                var oldValue = "";
                var fileNameField = this.fileChooserPanel.getComponent('cellFileName');
                if (fileNameField) {
                    oldValue = fileNameField.getValue();
                    fileNameField.setValue("");
                }
                this.saveCellValue(record, dataIndex, null, oldValue, false);
                this.touch();
            }
        },

        clearDisabledCellsValues: function(){
            var view = this.parentView || this;
            KS.confirm("Очистить данные во всех заблокированных ячейках?", "Внимание",
                function(btn) {
                    if (btn === 'yes') {
                        view.serverCall({
                            method: "ClearDisabledCellsValues",
                            params: [view.cachedValues],
                            success: function () {
                                view.resetGridPage();
                                view.touch();
                            }
                        });
                    }
            });
        }
    });
}(SavedFormTableView.prototype));

// ============= EXCEL =======================
(function (viewClass) {
    KS.apply(viewClass, {
        printTable: function() {
            var visibleColumns = [];
            this.mainGrid.eachColumnCfg(function (column) {
                if (column.dataIndex && !Ext.isEmpty(column.renderer) && column.hidden !== true) {
                    visibleColumns.push(column.dataIndex);
                }
            });
            this.serverCall({
                method: "PrepareColumnsGrid",
                params: [visibleColumns],
                success: this.createExportTablePanel
            });
        },

        createExportTablePanel: function(exportTableGrid) {
            var view = this;
            view.exportTableGrid = KS.create(exportTableGrid);
            var ignoreEmptyColumnsCheck = new Ext.form.field.Checkbox({
                itemId: 'ignoreEmptyColumns',
                boxLabel: 'Печать только ненулевых столбцов',
                padding: 5
            });
            view.excelWin = KS.showModal([
                view.exportTableGrid,
                ignoreEmptyColumnsCheck
            ], {
                title: 'Выбор колонок',
                layout: 'vbox',
                autoHeight: false,
                resizable: true,
                autoScroll: true,
                maximizable: true,
                width: Math.max(400, KS.rootViewport.getWidth() / 2),
                height: Math.max(300, KS.rootViewport.getHeight() / 1.5),
                minHeight: 300,
                minWidth: 400,
                buttonAlign: 'left',
                buttons: ['->', {
                        text: 'ОК',
                        cls: 'dim-button',
                        handler: function () {
                            var ignoreEmptyColumns = view.excelWin.getComponent("ignoreEmptyColumns").getValue();
                            view.doExcelExport(ignoreEmptyColumns);
                        }
                    }, { xtype: 'tbspacer', width: 8 },
                    {
                        text: 'Отмена',
                        cls: 'dim-button',
                        handler: function() {
                            view.excelWin.close();
                        }
                    }]
            }, true);
        },

        doExcelExport: function(ignoreEmptyColumns) {
            var colNames = [];
            this.exportTableGrid.store.each(function(record){
                if (record.get("CHECKED"))
                    colNames.push(record.get("CODE"));
            });
            this.excelWin.close();
            var savedRowLinks = this.mainGrid.getCheckedCodes(false);
            var filter = this.getExportFilter();
            var fileLink = KS.getFakeLink();
            var view = this;
            this.serverCall({
                method: 'DoExcelExport',
                params: [colNames, savedRowLinks, filter, ignoreEmptyColumns, fileLink],
                waitMessage: 'Выгрузка таблицы ...',
                timeout: 50000, // 50s
                delay: function() {
                    view.checkExportResult(fileLink)
                },
                success: this.openUrl
            });
        },

        checkExportResult: function(fileLink) {
            var view = this;
            view.containerPanel.unmask();
            view.containerPanel.mask(this.getWaitExportMsg());
            view.serverCall({
                method: 'GetExportResult',
                params: [fileLink],
                disableFog: true,
                success: function(result) {
                    view.checkResultCallback(result, fileLink)
                }
            });
        },

        checkResultCallback: function(result, fileLink) {
            if (!Ext.isEmpty(result)) {
                this.containerPanel.unmask();
                this.openUrl(result);
            } else {
                var view = this;
                view.exportProgressTimerId = setTimeout(function () {
                    view.checkExportResult(fileLink);
                }, 5000);
            }
        },

        getWaitExportMsg: function() {
            if (!this.waitExportMsg) {
                this.waitExportMsg = 'Формирование файла выгрузки таблицы .';
            } else {
                var index = this.waitExportMsg.indexOf('....');
                if (index !== -1)
                    this.waitExportMsg = this.waitExportMsg.substring(0, index + 1);
                else
                    this.waitExportMsg += '.';
            }
            return this.waitExportMsg;
        },

        stopExportProgressTimer: function() {
            if (this.exportProgressTimerId)
                clearInterval(this.exportProgressTimerId);
        },

        onBeforeClose: function() {
            this.stopExportProgressTimer();
            return  SavedFormTableView.superclass.onBeforeClose.call(this);
        },

        getExportFilter: function() {
            var grid = this.mainGrid,
                lockedGridFilter = grid.getFilter(grid.lockedGrid),
                normalGridFilter = grid.getFilter(grid.normalGrid);

            if (!Ext.isEmpty(lockedGridFilter) && lockedGridFilter !== "[]") {
                return lockedGridFilter;
            }
            if (!Ext.isEmpty(normalGridFilter) && normalGridFilter !== "[]") {
                return normalGridFilter;
            }
            return "";
        },  

        getFilterString: function(dataIndex) {
            var cfg = this.mainGrid.getColConfigByKey(dataIndex);
            if (cfg) {
                var brIdx = cfg.text.indexOf('</br>');
                if (brIdx >= 0) {
                    return cfg.text.substring(brIdx + 5);
                }
            }
            return null;
        }
    });
}(SavedFormTableView.prototype));

// ============= DICTIONARIES =======================
(function (viewClass) {
    KS.apply(viewClass, {

        showNonSidewallDictionary: function (colKey, rec) {
            this.fillFakeLinks(rec);
            this.serverCall({
                method: "SelectCellValueFromDictionary",
                params: [colKey, KS.Grid.getAnyCase(rec, 'LINK_DICTION_ROW'), 
                        KS.Grid.getAnyCase(rec, 'LINK_SAVED_ROW'), 
                        KS.Grid.getAnyCase(rec, 'LINK_DICTION_ROW_GROUP') || null],
                waitMessage: "Открытие справочника..."
            });
        },

        showDictionary: function (colKey, rec) {
            this.fillFakeLinks(rec);
            this.serverCall({
                method: "SelectCellValueFromDictionary",
                params: [colKey, KS.Grid.getAnyCase(rec, 'LINK_DICTION_ROW'), 
                        KS.Grid.getAnyCase(rec, 'LINK_SAVED_ROW'), 
                        KS.Grid.getAnyCase(rec, 'LINK_DICTION_ROW_GROUP') || null],
                waitMessage: "Открытие справочника..."
            });
        }

    });
}(SavedFormTableView.prototype));

// ============= SYS HANDLERS =======================
(function (viewClass) {
    KS.apply(viewClass, {
        mainGridPageLoaded: function () {
            if (this.data.isRRO) {
                this.fillRROPanel();
            }
            if (this.data.isTransform) {
                this.renderTransformData();
                this.setTableStatus();
            }
            this.processReportTableCell();
            this.removeBoldTextInNode();
        },

        cellTableDblClickHandler: function (grid, td, cellIndex, record, tr, rowIndex, e) {
            var view = this;
            if (record == null || view.reportReadOnly() || e.type === "keydown") {
                return false;
            }
            var col = e.position.column,
                rec = grid.getStore().getAt(rowIndex);

            if (col.isCheckColumn && col.renderer !== reportCheckboxRenderer) 
                return false;

            if (col.renderer === rroRenderer) {
                var ctype = getReportRROColumnType(rec, col.dataIndex);
                switch (ctype) {
                    case "name":
                        view.showRRONameDictionary(col.dataIndex, rec);
                        break;
                    case "part":
                        view.showRROPartDictionary(col.dataIndex, rec);
                        break;
                }
                return false;
            }

            if (isCellDisabled(rec, col) || getItemProperties(rec, col.dataIndex).IsReadOnly){//!col.editable) {
                return false;
            }
            if (col.renderer === selectFromDictionRenderer && col.tag.IsSelectableFromDiction) {
                view.showDictionary(col.dataIndex, rec);
                return false;
            }
            if (col.renderer === nonSidewallDictRenderer || (col.tag && col.tag.DictionLink && col.tag.DictionRowAdd)) {
                view.showNonSidewallDictionary(col.dataIndex, rec);
                return false;
            }
            if (view.isSidewall(col.dataIndex) || col.renderer === groupRenderer) {
                view.showDictionary(col.dataIndex, rec);
                return false;
            }
            if (col.renderer === fileChooseRenderer) {
                view.showFileChooserPanel(col.dataIndex, rec);
                return false;
            }
            if (col && col.tag && col.tag.Type &&
                (col.tag.Length > 255 || col.tag.Length === 0) &&
                !(col.tag.VisualSchema && col.tag.VisualSchema.Style === 2)) {
                view.showPopupStringEditor(rec.get(col.dataIndex), col, rec);
                return false;
            }
            return true;
        },

        //Обновлять summaryRow если кликнули на колонку с чекбоксами или выбрали ячейку
        selectCellChange: function(){
            this.updateSummaryRow();
            this.mainGrid.getSelectionModel().checkColumn.setHeaderStatus(false);
            this.toggleSummaryStatusPanel.apply(this);
        },

        updateSummaryRow: function() {
            var grid = this.mainGrid;
            if (grid && grid.lockedGrid) {
                var doubleSummaryLock = grid.lockedGrid.getView().findFeature('doubleSummary');
                var doubleSummaryNorm = grid.normalGrid.getView().findFeature('doubleSummary');
                if (doubleSummaryLock && doubleSummaryLock.showSummaryRow) {
                    var selected = grid.getSelectionModel().getSelected();
                    if (selected && ((selected.selectedRecords && selected.selectedRecords.length > 0) ||
                        (!KS.isEmpty(selected.startCell) && !KS.isEmpty(selected.endCell)))) {
                        doubleSummaryLock.summaryBarSelected.setVisible(true);
                        doubleSummaryNorm.summaryBarSelected.setVisible(true);
                    } else {
                        doubleSummaryLock.summaryBarSelected.setVisible(false);
                        doubleSummaryNorm.summaryBarSelected.setVisible(false);
                    }
                    KS.updateLayout(doubleSummaryLock.summaryBar);
                    KS.updateLayout(doubleSummaryLock.summaryBarSelected);
                }
            }
        },

        toggleSummaryStatusPanel: function() {
            this.summaryStatusPanel.setVisible(false);
            var selected = this.mainGrid.getSelectionModel().getSelected();

            var selectedRange = selected.getRange();

            var r1 = selectedRange[0][1],
                c1 = selectedRange[0][0],
                r2 = selectedRange[1][1],
                c2 = selectedRange[1][0],
                labelText;

            if (!(r2 - r1 > 0 || c2 - c1 > 0)) // выбрана только 1 ячейка
                return;

            try {
                var hasNumberCols = false;
                var sum = 0, value, rec, colCfg = null, columns = this.mainGrid.getVisibleColumns();
                for (var rowIdx = r1; rowIdx <= r2; rowIdx++) {
                    rec = this.mainGrid.store.getAt(rowIdx);
                    for (var colIdx = c1; colIdx <= c2; colIdx++) {
                        colCfg = columns[colIdx];
                        if (colCfg.renderer === numberRenderer) {
                            value = rec.data[colCfg.dataIndex] || '0';
                            sum += parseFloat(value.replace(',', '.'));
                            hasNumberCols = true;
                        }
                    }
                }
                if (!hasNumberCols) return;

                labelText = 'Сумма по ячейкам: ' + Ext.util.Format.number(parseFloat(sum), '0,000.00');
            } catch (e) {
                this.summaryStatusPanel.setVisible(false);
            }

            this.summaryStatusPanel.setHtml(labelText);
            this.summaryStatusPanel.setVisible(true);
        },

        cellClickHandlerAndroid: function (grid, td, cellIndex, record, tr, rowIndex, e) {
            var selected = this.mainGrid.getSelectionModel().getSelected();
            if (Ext.isEmpty(selected) || Ext.isEmpty(selected.startCell))
                return;

            var activeColConfig = e.position.column;
            cellIndex = this.mainGrid.getColIndexByKey(activeColConfig.dataIndex);
            var activeCell = selected.startCell,
                activeRowNum = activeCell.rowIdx,
                activeColNum = activeCell.colIdx;
            if (activeRowNum === rowIndex && activeColNum === cellIndex) {
                if (this.cellTableDblClickHandler(grid, td, cellIndex, record, tr, rowIndex, e)) {
                    this.mainGrid.getPlugin('cellediting').startEditByPosition({
                        row: activeRowNum,
                        column: activeColNum
                    });
                }
            }
        },

        keyDownHandler: function (grid, td, cellIndex, record, tr, rowIndex, e) {
            var view = this,
                selectedRange;

            var code = e.getKey();
            var isDigit = ((code >= e.ZERO) && (code <= e.NINE)) || ((code >= e.NUM_ZERO) && (code <= e.NUM_NINE));
            var isChar = ((code >= 65) && (code <= 90)) || ((code >= 186) && (code <= 192)) || ((code >= 219) && (code <= 220));
            var isEditKey = isChar || isDigit || code == e.NUM_MINUS || code == 189 || code == e.DELETE || code == e.ENTER || code == e.F2;

            if (view.reportReadOnly() && isEditKey) {
                return false;
            }

            if (view.mainGrid.selection === null) {
                return false;
            }

            var activeRowNum = rowIndex;
            var activeColConfig = e.position.column;
            var activeColNum = view.mainGrid.getColIndexByKey(activeColConfig.dataIndex);

            if (activeColConfig.xtype === "checkcolumn") {
                return true;
            }

            if (code == e.DELETE) {
                if (this.data.isRRO) {
                    var activeRec = view.mainGrid.store.getAt(activeRowNum);
                    view.serverCall({
                        method: 'DeleteRROData',
                        params: [KS.Grid.getAnyCase(activeRec, 'LINK_SAVED_ROW'), KS.Grid.getAnyCase(activeRec, 'LINK_DICTION_ROW'), 
                                 KS.Grid.getAnyCase(activeRec, 'LINK_DICTION_ROW_GROUP'), activeColConfig.dataIndex],
                        disableFog: true,
                        success: function (saveResult) {
                            this.processSaveResult(saveResult);
                            this.touch();
                        }
                    });
                } else {
                    selectedRange = view.mainGrid.getSelectionModel().getSelected().getRange();
                    var row1 = selectedRange[0][1],
                        col1 = selectedRange[0][0],
                        row2 = selectedRange[1][1],
                        col2 = selectedRange[1][0];
                    for (var rowIdx = row1; rowIdx <= row2; rowIdx++) {
                        var rec = view.mainGrid.store.getAt(rowIdx);
                        for (var colIdx = col1; colIdx <= col2; colIdx++) {
                            var colCfg = view.mainGrid.getVisibleColumns()[colIdx];
                            if (getItemProperties(rec, colCfg.dataIndex).IsDeletable)
                                view.deleteCellValue(rec, colCfg);
                        }
                    }

                    if (this.needFlush) {
                        this.flushCachedValues();
                    }

                    return true;
                }
            }

            if ((isCellDisabled(record, activeColConfig) || 
                getItemProperties(record, activeColConfig.dataIndex).IsReadOnly ||
                (activeColConfig.tag && activeColConfig.tag.SelectableFromDictionOnly))
                && isEditKey) {
                return false;
            }

            // войти в режим редактирования по нажатию 0..9 , или, если это справочник, то по буквам и знакам препинания
            if (activeColConfig.editable && (isDigit || code == e.NUM_MINUS || code == 189 ||
                (isChar && activeColConfig.tag && activeColConfig.tag.DictionLink && activeColConfig.tag.Type))  && !e.ctrlKey) {//colDesc.Type
//            if (!getItemProperties(record, activeColConfig.dataIndex).IsReadOnly && !this.reportReadOnly() && 
//                (isDigit || code == e.NUM_MINUS || code == 189)) { //hasEditableColumns в renderer влияет на добавление плагина

                if (activeColConfig.tag && activeColConfig.tag.Length && activeColConfig.getEditor() &&
                    activeColConfig.getEditor().enforceMaxLength === true) {
                    activeColConfig.getEditor().maxLength = activeColConfig.tag.Length;
                }
                
                view.mainGrid.editByKey = true;

                var editPlugin = view.mainGrid.getPlugin('cellediting');
                if (editPlugin == null) return false;

                view.resetCellValue = activeColConfig.renderer != uniDictComboRenderer; // для выпадающих списков не сбрасываем значение ячейки
                editPlugin.startEditByPosition({
                    row: activeRowNum,
                    column: activeColNum
                });
                view.resetCellValue = false;
            }
            
            return true;
        },

        beforeCellEdit: function(edPlugin, context) {
            var view = edPlugin.grid.parentView;
            if (view.reportReadOnly()) {
                return false;
            }
            if (view.resetCellValue === true) {
                context.value = "";
                context.column.field.isKeyDown = true;
            }
            return true;
        }
    });
}(SavedFormTableView.prototype));

// ============= APPEARANCE =======================
(function (viewClass) {
    KS.apply(viewClass, {
        getAllItemProperties: function () {
            var view = this;
            var grid = this.mainGrid;
            view.allItemProperties = {};
            Ext.each(grid.store.getRange(),
                function (row) {
                    var nastr = KS.Grid.getAnyCase(row, 'nastr');
                    if (Ext.isEmpty(nastr)) return;
                    var arrNastr = nastr.split(';&');
                    var allCellinRowItemProp = {};
                    Ext.each(arrNastr, function (columnNastr) {
                        var arr = columnNastr.split('#|');
                        allCellinRowItemProp[arr[1]] = {
                            AppearanceLink: arr.length >= 1 ? Number(arr[0]) || arr[0] : "",
                            ColumnKey: arr.length >= 2 ? arr[1] : KS.getFakeLink(),
                            IsTotal: arr.length >= 3 && Number(arr[2]) === 1,
                            IsDisable: arr.length >= 4 && Number(arr[3]) === 1,
                            IsReadOnly: arr.length >= 5 && Number(arr[4]) === 1,
                            IsDeniedRand: arr.length >= 6 && Number(arr[5]) === 1,
                            Tooltip: arr.length >= 7 ? arr[6] : "",
                            IsDeletable: arr.length >= 8 && Number(arr[7]) === 1,
                            Bold: arr.length >= 9 && Number(arr[8]) === 1,
                            Italic: arr.length >= 10 && Number(arr[9]) === 1,
                            Underline: arr.length >= 11 && Number(arr[10]) === 1,
                            ForCheck: arr.length >= 12 && Number(arr[11]) === 1,
                            IsUserTooltip: arr.length >= 13 && Number(arr[12]) === 1
                        }
                    });
                    view.allItemProperties[KS.Grid.getAnyCase(row, 'link_saved_row')] = allCellinRowItemProp;
                });
            view.itemPropertiesChanges = false;
        },

        refillItemProperties: function () {
            this.itemPropertiesChanges = true;
        }
    });
}(SavedFormTableView.prototype));

// ============= HYPERLINK =======================
(function (viewClass) {
    KS.apply(viewClass, {
        processReportTableCell: function () {
            if (this.parentView && this.parentView.deferredReportTableCell) {
                this.data.reportTableCell = this.parentView.deferredReportTableCell;
                delete this.parentView.deferredReportTableCell;
            }
            var rtc = this.data.reportTableCell;
            if (!rtc) return;
            if (this.data.isTransform){
                this.selectTransformTableCell(rtc.ColumnKey || rtc.Column.Key, rtc.DictionRowLink);
                delete this.data.reportTableCell;
                return;
            }
            var rowIdx = this.findRecByDictionLink(rtc.DictionRowLink, rtc.DictionGroupLink);
            if (rowIdx >= 0) {
                KS.defer(this.selectTableCell, [rtc.ColumnKey || rtc.Column.Key, rowIdx], this, 300);
                delete this.data.reportTableCell;
            } else if (this.data.showGroupTree && this.data.activeGroup.DictionRowLink != rtc.DictionGroupLink && rtc.DictionGroupLink > 0) {
                this.selectGroup(rtc.DictionGroupLink, true);
            } else {
                var view = this;
                this.serverCall({
                    method: 'CalculateHyperLinkRowPage',
                    success: function (page) {
                        if (page <= 0 || page === this.lastHyperLinkRowPage) {
                            // page num calculated wrong
                            delete view.data.reportTableCell;
                            //KS.msg('Ошибка перехода по ссылке');
                        } else {
                            view.lastHyperLinkRowPage = page;
                            view.mainGrid.getStore().loadPageFromServerTemplate(page);
                        }
                    }
                });
            }
        },

        selectTableCell: function (colKey, rowIdx) {
            try {
                var sm = this.mainGrid.getSelectionModel(),
                    colCfg = this.mainGrid.getColConfigByKey(colKey),
                    colIdx = this.mainGrid.getVisibleColumns().indexOf(colCfg);
                sm.clearSelections();
                sm.selectCells([colIdx, rowIdx], [colIdx, rowIdx]);
                this.scrollToActiveCell(colCfg, rowIdx);
            } catch (e) {
                KS.log(e);
            }
        },

        scrollToActiveCell: function(colCfg, rowIdx) {
            var gridWidth = this.mainGrid.getWidth();
            var halfGridWidth = gridWidth / 2;
            var lockedGridWidth = this.mainGrid.lockedGrid ? this.mainGrid.lockedGrid.getWidth() : 0;
            var widthToCol = 0;
            Ext.each(this.mainGrid.getVisibleColumns(), function(column){
                if (column !== colCfg) {
                    widthToCol += column.width;
                    return true;
                }
                return false;
            });
            var leftMargin = (lockedGridWidth > halfGridWidth) ? lockedGridWidth : halfGridWidth;
            if (widthToCol > leftMargin) {
                this.mainGrid.setScrollX(widthToCol - leftMargin);
            }

            var gridHeight = this.mainGrid.getHeight();
            var cellHeight = KS.theme === 'Classic' ? 22 : 25;
            var heightToRow = rowIdx * cellHeight;
            if (heightToRow > gridHeight/2) {
                this.mainGrid.setScrollY(heightToRow - gridHeight/2);
            }
        }
    });
}(SavedFormTableView.prototype));

// ============= RRO =======================
(function (viewClass) {
    KS.apply(viewClass, {
        rroPartFieldNames: ["Номер абзаца", "Номер подпункта", "Номер пункта", "Номер части", "Номер статьи"],
        rroHeaderHeight: 32,

        showRRONameDictionary: function (colKey, rec) {
            this.fillFakeLinks(rec);
            this.serverCall({
                method: "OpenRRODictionary",
                params: [KS.Grid.getAnyCase(rec, "LINK_SAVED_ROW"), KS.Grid.getAnyCase(rec, "LINK_DICTION_ROW"), KS.Grid.getAnyCase(rec, "LINK_DICTION_ROW_GROUP"), colKey],
                waitMessage: "Открытие справочника..."
            });
        },

        showRROPartDictionary: function (colKey, rec) {
            var view = this, startColumn;
            switch (colKey) {
                case "FED_NPA_PART":
                    startColumn = this.data.rroFedNpaColumn.Order + 1;
                    break;
                case "SUB_NPA_PART":
                    startColumn = this.data.rroSubNpaColumn.Order + 1;
                    break;
                case "MO_NPA_PART":
                    startColumn = this.data.rroMoNpaColumn.Order + 1;
                    break;
                default:
                    return;
            }
            this.fillFakeLinks(rec);
            this.rroPartGrid = new KS.Ext.Grid({
                parentView: this,
                stateful: false,
                enableToolbar: false,
                viewConfig: { forceFit: true },
                disableLockColumns: true,
                clicksToEdit: 1,
                rec: rec,
                gridSettings: {
                    Band: new Array({
                        Column: KS.Grid.ColumnArray([{
                                dataIndex: "name",
                                header: "Наименование",
                                width: 250,
                                align: 1,
                                visibility: true
                            }, {
                                dataIndex: "value",
                                header: "Значение",
                                width: 100,
                                align: 1,
                                editable: true,
                                editor: "KS.Ext.Grid.textEditor",
                                visibility: true
                            }])
                    })
                }
            });
            this.rroPartGrid.startColumn = startColumn;
            this.rroPartGrid.colKey = colKey;

            this.rpdWin = KS.showModal(this.rroPartGrid, {
                title: "Справочник РРО",
                autoHeight: false,
                width: 450,
                height: 250,
                buttons: ['->', {
                        text: "Установить",
                        width: 90,
                        cls: "marked-button",
                        scope: view,
                        handler: view.setRROPartValue
                    }, { xtype: "tbspacer", width: 8 },
                    {
                        text: "Закрыть",
                        cls: "dim-button",
                        handler: function () {
                            view.rpdWin.close();
                        }
                    }]
            });
            for (var idx = 0; idx < view.rroPartFieldNames.length; idx++) {
                var newRec = {
                    name: view.rroPartFieldNames[idx],
                    value: rec.get("COL" + (startColumn + idx))
                };
                view.rroPartGrid.addRecord(newRec);
            }
        },

        setRROPartValue: function() {
            var view = this,
                parts = [],
                startColumn = view.rroPartGrid.startColumn,
                rec = view.mainGrid.selection,
                colKey,
                dictRowValue;
            if (Ext.isEmpty(rec)) return;
            for (var idx = 0; idx < view.rroPartFieldNames.length; idx++) {
                colKey = "COL" + (startColumn + idx);
                dictRowValue = view.rroPartGrid.store.getAt(idx).get('value');
                rec.set(colKey, dictRowValue);
                parts.push(dictRowValue);
            }
            view.touch();
            view.rpdWin.close();
            view.serverCall({
                method: 'GetRROPartString',
                params: [KS.Grid.getAnyCase(rec, "LINK_SAVED_ROW"), KS.Grid.getAnyCase(rec, "LINK_DICTION_ROW"), KS.Grid.getAnyCase(rec, "LINK_DICTION_ROW_GROUP"), startColumn, view.rroPartGrid.colKey, parts],
                disableFog: true,
                success: function(cellValue) {
                    rec.set(view.rroPartGrid.colKey, cellValue);
                    view.touchActiveGroup();
                }
            });
        },

        fillRROPanel: function() {
            var store = this.mainGrid.getStore(),
                row = store.getAt(0);
            if (!row) {
                this.newHandler(true, this.addRRORow);//Добавляем пустую строку для хранения данных полей
                return;
            }
            var recData = row.data;
            this.rroPanelData = recData;
            this.fillrroPanelItems();
            if (!Ext.isEmpty(this.rroPanelItems)) {
                for (var idx = 0; idx < this.rroPanelItems.length; idx++) {
                    var ctrl = this.rroPanelItems[idx],
                        colKey = ctrl.colMapped;
                    if (colKey) {
                        //setValue запускает эвент change, setRawValue не запускает
                        ctrl.setRawValue(recData[colKey].replace(",","."));
                        var disabled = (this.isEditSumsOnly() &&
                            (colKey === 'COL9' || colKey === 'COL10' || colKey === 'COL25'));
                        ctrl.setDisabled(disabled);
                        if (disabled) {
                            ctrl.addCls('textfield-read-only');
                        } else {
                            ctrl.removeCls('textfield-read-only');
                        }
                    }
                }
            }
            this.mainGrid.getStore().remove(row);
        },

        fillrroPanelItems: function() {
            var rroPanelItems = [];
            if (this.rroPanel) {
                //по возможности найти замену всем items.item
                this.rroPanel.items.each(function(rroFieldPanel){
                    if (rroFieldPanel.ctrlId.indexOf("numberFieldPanel") !== -1) {
                        rroPanelItems.push(rroFieldPanel.items.items[0].items.items[0]);
                    }                    
                    if (rroFieldPanel.ctrlId.indexOf("textFieldPanel") !== -1) {
                        rroPanelItems.push(rroFieldPanel.items.items[1]);
                    }
                });
            }
            this.rroPanelItems = rroPanelItems;
        },

        saveRROPanelControlValue: function(ctrl, newValue, oldValue) {
            var view = ctrl.parentView,
                savedLink = view.rroPanelData["LINK_SAVED_ROW"] || view.rroPanelData["link_saved_row"];
            if (Ext.isEmpty(savedLink) || savedLink == 0) {
                savedLink = KS.getFakeLink();
                view.rroPanelData["LINK_SAVED_ROW"] = savedLink;
            }
            if (ctrl.itemId === "numberField") {
                newValue = newValue.toString().replace(".", ",");
            }
            var cvalue = {
                'LinkSavedRow': savedLink,
                'LinkDictionRowGroup': view.rroPanelData["LINK_DICTION_ROW_GROUP"] || 
                                       view.rroPanelData["link_diction_row_group"],
                'LinkDictionRow': view.rroPanelData["LINK_DICTION_ROW"] || 
                                  view.rroPanelData["link_diction_row"],
                'FakeDictionLink': 0,
                'FakeSavedLink': 0,
                'ColKey': ctrl.colMapped,
                'Value': { Direct: newValue },
                'OriginalValue': oldValue,
                'IsNewRow': false
            };
            view.addNewCachedValues(cvalue);
            view.touch();
            view.touchActiveGroup();
        },

        //Если меняем одно и то же поля несколько раз подрят, просто меняем последнее chachedValue
        addNewCachedValues: function(newCachedValue) {
            if (!Ext.isEmpty(this.cachedValues)) {
                var lastCachedValue = this.cachedValues[this.cachedValues.length - 1];
                if (lastCachedValue.LinkSavedRow === newCachedValue.LinkSavedRow &&
                    lastCachedValue.LinkDictionRowGroup === newCachedValue.LinkDictionRowGroup &&
                    lastCachedValue.LinkDictionRow === newCachedValue.LinkDictionRow &&
                    lastCachedValue.FakeDictionLink === newCachedValue.FakeDictionLink &&
                    lastCachedValue.FakeSavedLink === newCachedValue.FakeSavedLink &&
                    lastCachedValue.ColKey === newCachedValue.ColKey &&
                    lastCachedValue.IsNewRow === newCachedValue.IsNewRow) {
                    lastCachedValue.Value = newCachedValue.Value;
                    lastCachedValue.OriginalValue = newCachedValue.OriginalValue;
                    return;
                }
            }
            this.cachedValues.push(newCachedValue);
        },

        isEditSumsOnly: function() {
            return !!(this.data.activeGroup && this.data.activeGroup.Fields && this.data.activeGroup.Fields['EDIT_ONLY_SUMS']);
        },

        addRRORow: function(dataRow) {
            if (dataRow) {
                this.mainGrid.addRecord(dataRow);
                this.fillRROPanel();
            }
        }
    });
}(SavedFormTableView.prototype));

// ============= RPN (Transform) =======================
(function (viewClass) {
    KS.apply(viewClass, {
        resetTransformGrid: function(){
            var view = this;
            view.serverCall({
                method: 'RebuildMainGrid',
                waitMessage: "Обновление таблицы " + (view.tableName || "") + "...",
                success: function (newMainGrid) {
                    view.mainGrid = view.createTemplateControl(newMainGrid);
                    view.resetGridPage();
                }
            });
        },

        renderTransformData: function() {
            this.transPanel.removeAll();
            this.allItemProperties = {};
            this.virtualCheckboxes = [];
            var view = this;
            this.mainGrid.getStore().each(function(rec){
                view.addTransformRecord(rec.data, rec);
            });
            if (!this.data.isSingleTransform)
                this.transPanel.setActiveTab(0);
        },

        addTransformRecord: function(recData, rec) {
            var titleFieldValue = getRecDataValue(recData, this.data.transformTitleField),
                title = this.data.isSingleTransform
                    ? undefined
                    : '#' + (titleFieldValue || KS.Grid.getAnyCase(rec, "CODE") || (this.transPanel.items.getCount() + 1));
            if (title && title.length > 10) {
                title = title.substring(0, 10);
            }
            if (!Ext.isEmpty(this.cachedValues)) { //сохраняем значение ячеек при обновлении формы(для рпн)
                Ext.each(this.cachedValues, function(cachedValue) {
                    if (recData.hasOwnProperty(cachedValue.ColKey) &&
                        recData["link_diction_row"] == cachedValue.LinkDictionRow) {
                        recData[cachedValue.ColKey] = cachedValue.Value.Direct;
                    }
                });
            }

            var addedTab = {
                xtype: 'panel',
                title: title,
                recData: recData,
                layout: 'anchor',
                border: false,
                items: this.buildTransformRecordItems(recData, rec)
            };
            if (!this.data.isSingleTransform) {
                addedTab.height = "100%";
                addedTab.scrollable = true;
            }
            addedTab = this.transPanel.add(addedTab);
            KS.updateLayout(this.transPanel);
            this.eachTransformItem(this.dogNail);
            return addedTab;
        },

        removeTransformRecord: function() {
            this.transPanel.remove(this.transPanel.getActiveTab());
        },

        buildTransformRecordItems: function(recData, rec) {
            var view = this,
                band = this.mainGrid.gridSettings.Band[0],
                items = [],
                fsets = [],
                colHdr = this.data.tableDescription.VisualSchema.ColumnHeader;
            Ext.each(band.Column, function (column) {
                if (column.tag) { //скрываем колонки не выбранных типов и колонки, помеченные как "Скрыта"
                    if (view.data.hiddenColumnsLinks.indexOf(column.tag.ColumnLink.toString()) !== -1 || column.tag.IsHidden)
                        column.visibility = false;
                    else if (!column.tag.IsCode)
                        column.visibility = true;
                    items.push(view.buildTransformItem(column, recData, rec));
                }
            });
            Ext.each(colHdr, function(thch) {
                var fsetItems = [],
                    x = thch.X - 1,
                    countHiddenColumns = 0;
                for (var idx = x; idx < x + thch.SpanX; idx++) {
                    if (items[idx]) {
                        fsetItems.push(items[idx]);
                        if (items[idx].hidden) {
                            countHiddenColumns++;
                        }
                    }
                } //Если скрыты все колонки в заголовке(или колонок нет), скрываем заголовок
                fsets.push(view.buildTransformFieldSet(thch.Name, fsetItems, thch.Hidden || fsetItems.length === countHiddenColumns));
            });
            return fsets;
        },

        buildTransformFieldSet: function(name, fsetItems, hidden) {
            return {
                xtype: 'fieldset',
                defaultType: 'textfield',
                title: Ext.isEmpty(name) ? "" : "<span class='x-fieldset-title'>" + name + "</span>",
                fieldDefaults: {
                    labelAlign: 'left',
                    labelWidth: 300
                },
                collapsible: true,
                border: true,
                checkboxToggle: false,
                autoHeight: true,
                padding: "5 15 5 15",
                margin: "5 5 5 5",
                width: "100%",
                hidden: hidden,
                items: fsetItems
            };
        },

        buildTransformItem: function(column, recData, rec) {
            var label = column.header,
                brIdx = label.indexOf('</br>'),
                isString = column.tag.Type,
                style = column.tag.VisualSchema.Style,
                dataIndex = column.dataIndex,
                value = recData[dataIndex],
                dcbx = this.data.dependentCheckboxes,
                ls = getItemProperties(rec, dataIndex).AppearanceLink,
                item = {
                    parentView: this,
                    value: value,
                    column: column,
                    recData: recData,
                    columnStyle: style,
                    hidden: !column.visibility,
                    colMapped: dataIndex,
                    readOnly: !column.editable || column.tag.DisableReason > 0 || (this.parentView && this.parentView.data.isReadOnly),
                    listeners: { 'change': this.transformItemChangeHandler }
                },
                isDisabled = isCellDisabled(rec, column);
            if (ls > 0) {
                item.cls = 'rpn-field link-setting-' + ls + (isDisabled ? '-disabled' : '');
            }
            if (brIdx >= 0) {
                label = label.substring(brIdx + 5);
            }
            // Зависимые от чекбокса колонки (заблокированные)
            if (this.data.readonlyCheckboxes) {
                for (var cbxKey in this.data.readonlyCheckboxes) {
                    if (this.data.readonlyCheckboxes.hasOwnProperty(cbxKey)) {
                        var cbxChk = (KS.Svod.normalizeFloatValue(recData[cbxKey], 0) == 1 || recData[cbxKey] == true);
                        Ext.each(this.data.readonlyCheckboxes[cbxKey], function (colKey) {
                            if (item.colMapped == colKey) {
                                item.readOnly = item.readOnly || !cbxChk;
                            }
                        });
                    }
                }
            }
            // Зависимые от чекбокса колонки (скрытые)
            if (this.data.hiddenCheckboxes) {
                for (var cbxKey2 in this.data.hiddenCheckboxes) {
                    if (this.data.hiddenCheckboxes.hasOwnProperty(cbxKey2)) {
                        var cbxChk2 = (KS.Svod.normalizeFloatValue(recData[cbxKey2], 0) == 1 || recData[cbxKey] == true);
                        Ext.each(this.data.hiddenCheckboxes[cbxKey2], function (colKey) {
                            if (item.colMapped == colKey) {
                                item.hidden = !cbxChk2;
                            }
                        });
                    }
                }
            }
            if (item.readOnly) {
                switch (style) {
                    case 1:
                    case 4:
                        break;
                    default:
                        item.fieldCls += ' textfield-read-only';
                        break;
                }
            }
            switch (style) {
                case 1:
                    item.xtype = 'checkbox';
                    item.checked = Ext.isBoolean(value) ? value : (KS.Svod.normalizeFloatValue(value, 0) == 1);
                    item.value = item.checked;
                    for (var dateCol in dcbx) {
                        if (dcbx.hasOwnProperty(dateCol)) {
                            if (dcbx[dateCol] == dataIndex) {
                                item.virtual = true;
                                this.virtualCheckboxes[dcbx[dateCol] + '#' + getRecDataValue(recData, "link_saved_row")] = item;
                                return null;
                            }
                        }
                    }
                    item.listeners['change'] = this.processReadonlyCheckbox;
                    if (column.header && column.header.indexOf("Организация-ручной ввод") !== -1) {
                        item.disabled = !item.checked;
                    }
                    break;
                case 2:
                    item.xtype = 'datefield';
                    item.format = 'd.m.Y';
                    item.formatText = 'Формат даты дд.мм.гггг';
                    item.invalidText = '{0} не является правильной датой - дата должна быть указана в формате дд.мм.гггг';
                    item.editable = true;
                    if (KS.isSurDB && this.data.tableDescription.Code !== '003' && item.colMapped !== 'COL18') {
                        item.maxValue = new Date();
                    }
                    item.enableKeyEvents = false;
                    item.value = this.buildTransformDate(item.value);
                    var clrBtn = new Ext.Button({
                        xtype: 'button',
                        iconCls: 'ks-icon-clean',
                        width: 20,
                        parentView: this,
                        disabled: item.readOnly,
                        item: item,
                        handler: this.clearTransformItemValue
                    });
                    item = {
                        xtype: 'fieldcontainer',
                        layout: 'hbox',
                        parentView: this,
                        fieldLabel: item.fieldLabel,
                        hidden: item.hidden,
                        items: [item, clrBtn]
                    };
                    break;
                case 4:
                    item.xtype = 'fieldcontainer';
                    item.layout = 'hbox';
                    item.items = [
                        {
                            xtype: 'datefield',
                            format: 'd.m.Y',
                            formatText: 'Формат даты дд.мм.гггг',
                            invalidText : '{0} не является правильной датой - дата должна быть указана в формате дд.мм.гггг',
                            colMapped: dataIndex,
                            columnStyle: style,
                            editable: true,
                            itemId: 'date',
                            maxValue: KS.isSurDB ? new Date() : undefined,
                            readOnly: item.readOnly,
                            cls: item.readOnly ? ' textfield-read-only' : undefined,
                            enableKeyEvents: false,
                            value: this.buildTransformDate(item.value),
                            listeners: {
                                'change': function() {
                                    this.ownerCt.fireEvent('change');
                                }
                            }
                        }, {
                            xtype: 'timefield',
                            format: 'H:i:s',
                            formatText: 'Формат времени чч:мм:сс',
                            invalidText: '{0} не является правильным временем – время должно быть в формате чч:мм:сс',
                            increment: 30,
                            width: 100,
                            itemId: 'time',
                            readOnly: item.readOnly,
                            cls: item.readOnly ? ' textfield-read-only' : undefined,
                            editable: true,
                            enableKeyEvents: false,
                            value: this.buildTransformTime(item.value),
                            listeners: {
                                'change': function() {
                                    this.ownerCt.fireEvent('change');
                                }
                            }
                        }, {
                            xtype: 'button',
                            iconCls: 'ks-icon-clean',
                            disabled: item.readOnly,
                            width: 20,
                            parentView: this,
                            item: item,
                            handler: function() {
                                var cf = this.ownerCt;
                                cf.getComponent("date").setValue('');
                                cf.getComponent("time").setValue('');
                            }
                        }
                    ];
                    item.listeners = {
                        'change': function() {
                            var date = this.getComponent("date").getRawValue(),
                                time = this.getComponent("time").getRawValue();
                            if (KS.isEmpty(date) && KS.isEmpty(time)) {
                                this.parentView.transformItemChangeHandler(this, '', '');
                                return;
                            }
                            var value = date + ' ' + time;
                            this.parentView.transformItemChangeHandler(this, value, '');
                        }
                    }
                    break;
                    
                case 6:
                    var linkSavedRow = KS.Grid.getAnyCase(rec, "LINK_SAVED_ROW");
                    var linkTable = KS.Grid.getAnyCase(rec, "LINK_TABLE");
                    var fileBtnId = 'fileBtn_' + linkSavedRow + "_" + linkTable + "_"  + dataIndex;
                    var fileName = KS.Grid.getAnyCase(rec, dataIndex);
                    item.xtype = 'fieldcontainer';
                    item.layout = 'hbox';
                    item.fileBtnId = fileBtnId;
                    item.cellOptionsForFile = {
                        dataIndex: dataIndex,
                        linkSavedRow: linkSavedRow,
                        linkTable: linkTable,
                        record: rec
                    };
                    item.items = [
                        {
                            xtype: 'button',
                            tooltip : 'Удалить файл',
                            iconCls: 'ks-icon-delete',
                            margin: '0 3 0 3',
                            handler: this.transformDeleteFile
                        }, {
                            xtype: 'textfield',
                            itemId: 'cellFileName' + dataIndex,
                            columnStyle: style,
                            colMapped: dataIndex,
                            parentView: this,
                            recData: recData,
                            value: fileName,
                            readOnly: true
                        }, {
                            xtype: 'button',
                            tooltip : 'Скачать файл',
                            iconCls: 'ks-icon-save',
                            margin: '0 3 0 3',
                            handler: this.transformDownloadFile
                        }, {
                            xtype: 'button',
                            tooltip : 'Загрузить файл',
                            iconCls: 'ks-icon-folder_open',
                            handler: this.transformAddFile
                        },
                        KS.create( //Скрытая кнопка, запускает saveFiles
                            {
                                itemId: 'ADD_FILE' + dataIndex,
                                type: 'filefield',
                                parentView: this
                            },
                            {
                                buttonConfig: 
                                {
                                    id: fileBtnId
                                },
                                multiple: false,
                                "owner.hidden": true
                            })
                    ];
                    break;

                case 7:
                    item.xtype = "combo";
                    item.value = KS.Svod.normalizeFloatValue(value, 0);
                    item.queryMode = 'local';
                    item.valueField = 'valueField';
                    item.displayField = 'displayField';
                    item.store = new Ext.data.Store({
                        fields: ['valueField', 'displayField'],
                        data: [
                            { 'valueField' : 0, 'displayField' : 'Нет' },
                            { 'valueField': 1, 'displayField': 'Да' }
                        ]
                    });
                    item.width = 370;
                    for (var dateCol2 in dcbx) {
                        if (dcbx.hasOwnProperty(dateCol2)) {
                            if (dcbx[dateCol2] == dataIndex) {
                                item.virtual = true;
                                this.virtualCheckboxes[dcbx[dateCol2] + '#' + getRecDataValue(recData, "LINK_SAVED_ROW")] = item;
                                return null;
                            }
                        }
                    }
                    item.listeners['select'] = this.processReadonlyCombobox;
                    if (column.header && column.header.indexOf("Организация-ручной ввод") !== -1) {
                        item.disabled = KS.Svod.normalizeFloatValue(value, 0) === '0';
                    }
                    break;

                case 8:
                    item = Ext.create('KS.Ext.BarEditor',
                        {
                            textValue: item.value,
                            parentView: item.parentView,
                            column: item.column,
                            recData: item.recData,
                            hidden: item.hidden,
                            colMapped: item.colMapped,
                            listeners: {
                                'change': function () {
                                    var barcode = Ext.getCmp('barcodeTextValue').getValue();

                                    if (KS.isEmpty(barcode)) {
                                        this.parentView.transformItemChangeHandler(this, '', '');
                                        return;
                                    }
                                    this.parentView.transformItemChangeHandler(this, barcode, '');
                                }
                            }
                        });
                    break;

                case 9:
                    item.xtype = "combo";
                    item.value = KS.Svod.normalizeFloatValue(value, 0);
                    item.width = 370;
                    item.queryMode = 'local';
                    item.valueField = 'valueField';
                    item.displayField = 'displayField';
                    item.store = new Ext.data.Store({
                        fields: ['valueField', 'displayField'],
                        data: [
                            { 'valueField' : 0, 'displayField' : ''},
                            { 'valueField' : 1, 'displayField' : 'Нет' },
                            { 'valueField': 2, 'displayField': 'Да' }
                        ]
                    });
                    item.tpl = '<tpl for="."><div class="x-boundlist-item">{displayField}&nbsp;</div></tpl>';
                    break;

                default:
                    if (isString) {
                        if (column.tag.Length > 250) {
                            item.xtype = 'textarea';
                            item.height = 48;
                        }
                        item.width = '100%';
                    } else {
                        item.xtype = 'numberfield';
                        item.decimalSeparator = ',';
                        item.decimalPrecision = column.tag.Length;
                    }
                    break;
            }
            if (column.tag.DictionLink > 0 && column.visibility) {
                var dblClickFunc = function (elem) {            // Открытие справочника по двойному клику
                    elem.getEl().on('dblclick', function () {
                        elem.parentView.transformItemTriggerClick.call(elem);
                    });
                };
                var comboData = this.data.dictionaryCombo[dataIndex];
                if (comboData) {
                    comboData.value = value;
                    var wasHidden = item.hidden; // Был скрыт т.к. зависимый
                    item = this.buildDictionaryCombo(comboData, {
                            emptyText: '...',
                            editable: !column.tag.SelectableFromDictionOnly,
                            allowEmpty: column.tag.AllowEmpty,
                            readOnly: item.readOnly,
                            onSelectHandler: this.dictionaryComboSelected,
                            storeLoadEvent: comboData.dataSrc === "DADATA" ? this.dadataComboStoreLoad : false
                    });
                    item.labelWidth = 300;
                    item.width = '100%';
                    item.colMapped = dataIndex;
                    item.parentView = this;
                    item.column = column;
                    item.recData = recData;
                    item.hidden = wasHidden || !column.visibility;
                    item.fieldCls = item.readOnly ? ' textfield-read-only' : ' textfield-dict';
                    if (comboData.cached) {
                        if (comboData.serverSearch) {
                            item.hideTrigger = true;
                        } else {
                            item.on('beforequery', this.dictionaryCachedComboQuery);
                            item.triggerClass = 'x-form-search-trigger';
                            item.onTriggerClick = this.transformItemTriggerClick;
                        }
                    } else if (column.tag.DictionCheck) {
                        item.validationEvent = false;
                        item.validator = function (v) {
                            var displayField = item.displayField,
                                found = false;
                            this.getStore().each(function (cr) {
                                if (cr.get(displayField) == v) {
                                    found = true;
                                }
                            });
                            return found ? true : 'Значение ' + v + ' не найдено в справочнике';
                        }
                    }
                    item.on('change', this.dictionaryComboChange, this);
                    if (comboData.dataSrc != "DADATA") {
                        item.on('afterrender', dblClickFunc);
                        item.queryMode = 'local';
                    }
                } else {
                    if (item.xtype == 'fieldcontainer')
                    {
                        Ext.each(item.items, function(subItem) {
                            if (subItem.xtype != 'button') {
                                subItem.fieldCls = item.readOnly ? ' textfield-read-only' : ' textfield-dict';
                                if (!subItem.listeners)
                                    subItem.listeners = {};
                                subItem.listeners.afterrender = dblClickFunc;
                            }
                        });
                        item.items.push(
                            {
                                xtype: 'button',
                                iconCls: 'dict-trigger-cls',
                                parentView: this,
                                clickArgs: {
                                    parentView: this,
                                    colMapped: dataIndex,
                                    recData: recData,
                                },
                                handler: function(){
                                    this.parentView.transformItemTriggerClick.call(this.clickArgs);   
                                }
                            })
                    } else {
                        item.xtype = 'textfield';
                        item.fieldCls = item.readOnly ? ' textfield-read-only' : ' textfield-dict';
                        item.triggers = {
                            foo: {
                                cls: 'dict-trigger-cls',
                                handler: this.transformItemTriggerClick
                            }
                        }
                        if (!item.listeners)
                            item.listeners = {};
                        item.listeners.afterrender = dblClickFunc;
                    }                                        
                }
            }
            item.fieldLabel = label;

            return item;
        },
        
        processReadonlyCombobox: function(combo) {
            var newValue = combo.getValue();
            this.parentView.setDependentItemsAppearance(combo, newValue == 1);
        },

        processReadonlyCheckbox: function(item, newValue, oldValue) {
            var view = this.parentView || this;
            view.setDependentItemsAppearance(item, newValue);
            view.transformItemChangeHandler(item, newValue, oldValue);
        },

        setDependentItemsAppearance: function(item, checked){
            var view = this,
                roc = view.data.readonlyCheckboxes,
                hiddenC = view.data.hiddenCheckboxes;
            Ext.each(roc[item.colMapped],
                function(colKey) {
                    var depItem = view.findTransformItem(colKey);
                    switch (depItem.xtype) {
                        case 'datefield':
                            var comp = depItem.ownerCt;
                            comp.items.each(function (bro) {
                                if (bro.xtype == 'button')
                                    bro.setDisabled(!checked);
                                else
                                    view.setReadOnlyAppearance(bro, !checked);
                            });
                            break;
                        default:
                            view.setReadOnlyAppearance(depItem, !checked);
                            if (!checked) {
                                view.setTransformItemValue(colKey, depItem.xtype == 'numberfield' ? 0 : null);
                            }
                            break;
                    }
                }
            );
            Ext.each(hiddenC[item.colMapped],
                function(colKey) {
                    var depItem = view.findTransformItem(colKey);
                    if (depItem) {
                        view.setHiddenAppearance(depItem, !checked);
                        if (!checked) {
                            switch (depItem.columnStyle){
                                case 4: // date+time
                                    var owner = depItem.ownerCt;
                                    if (owner)
                                        owner.items.each(function(child){
                                            if (child.setValue)
                                                child.setValue('');
                                        });
                                    break;
                                default:
                                    view.setTransformItemValue(colKey, depItem.xtype == 'numberfield' ? 0 : null);
                                    break;
                            }
                        }
                    }
                }
            );
        },

        setReadOnlyAppearance: function(item, readOnly) {
            if (item && item.setReadOnly) {
                item.setReadOnly(readOnly);
                switch (item.columnStyle){
                    case 1:
                    case 7:
                        if (!Ext.isFunction(item.setDisabled)) return;
                        item.setDisabled(readOnly);
                        break;
                    default:
                        if (readOnly) {
                            item.inputEl.addCls('textfield-read-only');
                        } else {
                            item.inputEl.removeCls('textfield-read-only');
                        }
                        break;
                }
            }
        },
        
        setHiddenAppearance: function(item, readOnly) {
            if (item && item.setHidden) {
                switch (item.columnStyle){
                    case 2:
                    case 4:
                    case 6:
                        item.setHidden(readOnly);
                        var owner = item.ownerCt;
                        if (owner && owner.setHidden)
                            owner.setHidden(readOnly);
                        break;
                    default:
                        item.setHidden(readOnly);
                        break;
                }
            }
        },

        dictionaryCachedComboQuery: function (e) {
            var view = this.parentView,
                combo = this;
            e.cancel = true;
            if (Ext.isEmpty(e.query)) return;
            view.serverCall({
                method: 'ProcessCachedComboQuery',
                params: [combo.comboData.link, e.query],
                disableFog: true,
                success: function(rows) {
                    var store = combo.getStore();
                    if (Ext.isEmpty(rows)) {
                        combo.comboData.rows = [];
                        store.removeAll();
                    } else {
                        combo.comboData.rows = rows;
                        var comboRows = this.prepareComboRows(combo.comboData);
                        store.loadData(comboRows.data);
                    }
                }
            });
        },

        dictionaryComboSelected: function (combo, row) {
            if (row && row.CODE && row.CODE === 'EMPTY_CODE') {
                this.setTransformItemValue(combo.colMapped, null);
                return;
            }
            var view = this;
            this.serverCall({
                method: 'CachedComboSelected',
                params: [combo.recData['LINK_SAVED_ROW'] || combo.recData['link_saved_row'], combo.comboData.link, row],
                disableFog: true,
                success: function(dict) {
                    if (dict) {
                        for (var colKey in dict) {
                            if (dict.hasOwnProperty(colKey))
                                view.setTransformItemValue(colKey, dict[colKey]);
                        }
                    }
                }
            });
        },

        dictionaryComboChange: function (combo, newValue, oldValue) {
            this.transformItemChangeHandler(combo, combo.getRawValue(), oldValue);
        },
        
        // Пришли данные с dadata
        dadataComboStoreLoad: function(store, records, options) {
            if (records == null) return;
            var view = this.parentView;

            var manualInputDisabled = function(state) {
                var column = null;
                view.eachColumnCfg(function(cfg) {
                    if (cfg.text && cfg.text.indexOf("Организация-ручной ввод") !== -1)
                        column = cfg;
                });
                if (column) {
                    var checkBox = view.findTransformItem(column.dataIndex);
                    if (checkBox) {
                        checkBox.setDisabled(state);
                        if (state)
                            checkBox.setValue('0');
                    }
                }
            };

            if (records.length === 1 && KS.Grid.getAnyCase(records[0], "CODE") === "EMPTY_CODE" &&
                !view.organizatinManualInput) {
                manualInputDisabled(false);
                view.organizatinManualInput = true; // Включен ли ручной ввод организации
            } else if ((records.length === 1 && KS.Grid.getAnyCase(records[0], "CODE") !== "EMPTY_CODE" || records.length !== 1) && view.organizatinManualInput) {
                manualInputDisabled(true);
                view.organizatinManualInput = false;
            }
        },

        clearTransformItemValue: function() {
            this.parentView.setTransformItemValue(this.item.colMapped, null);
        },

        transformItemTriggerClick: function() {
            if (this.readOnly) return;
            var view = this.parentView;
            view.serverCall({
                method: "SelectCellValueFromDictionary",
                params: [this.colMapped, 
                         getRecDataValue(this.recData, "link_diction_row"), 
                         getRecDataValue(this.recData, "link_saved_row"), 
                         getRecDataValue(this.recData, "link_diction_row_group") || null],
                waitMessage: "Открытие справочника..."
            });
        },

        findTransRowPanel: function(savedRowLink) {
            var rowPanel = null;
            if (this.data.isSingleTransform) {
                this.transPanel.items.each(function(rp) { rowPanel = rp; });
            } else {
                if (Ext.isNumber(savedRowLink) && savedRowLink !== 0) {
                    this.transPanel.items.each(function (rp) {
                        if (getRecDataValue(rp.recData, "link_saved_row") == savedRowLink)
                            rowPanel = rp;
                    });
                } else {
                    rowPanel = this.transPanel.getActiveTab();
                }
            }
            return rowPanel;
        },

        eachTransformItem: function(fn, savedRowLink) {
            var rowPanel = this.findTransRowPanel(savedRowLink);
            if (!rowPanel) return;
            rowPanel.items.each(function (fset) {
                fset.items.each(function (item) {
                    if (item.xtype == 'fieldcontainer') {
                        item.items.each(function(subItem) {
                            if (Ext.isFunction(fn)) fn.call(subItem.parentView, subItem);
                        });
                    } else {
                        if (Ext.isFunction(fn)) fn.call(item.parentView, item);
                    }
                });
            });
        },

        findTransformItem: function (colKey) {
            var rowPanel = this.findTransRowPanel(),
                savedRowLink = rowPanel && rowPanel.recData ? getRecDataValue(rowPanel.recData, "link_saved_row") : 0;
            return this.virtualCheckboxes[colKey + '#' + savedRowLink] || this.findTransformItemBy('colMapped', colKey);
        },

        findTransformItemBy: function(field, value) {
            var res = null;
            this.eachTransformItem(function (item) {
                if (item[field] === value) res = item;
            });
            return res;
        },

        getTransformRecTitle: function (rowPanel) {
            if (this.data.isSingleTransform)
                return undefined;
            var titleItem = this.findTransformItem(this.data.transformTitleField);
            if (titleItem) {
                var newValue = titleItem.getValue();
                if (Ext.isEmpty(newValue)) {
                    newValue = getRecDataValue(rowPanel.recData, "CODE");
                } else if (newValue.length > 10) {
                    newValue = newValue.substring(0, 10);
                }
                return newValue;
            }
            return undefined;
        },

        setTransformItemValue: function(colKey, rawNewValue) {
            var item = this.findTransformItem(colKey),
                newValue = rawNewValue;
            if (item) {
                switch (item.xtype) {
                    case 'checkbox':
                        newValue = Ext.isBoolean(newValue) ? newValue : (newValue == 1);
                        break;
                    case 'datefield':
                        newValue = this.buildTransformDate(newValue);
                        break;
                }
                if (item.columnStyle === 7){ // зависимые Да/Нет
                    newValue = rawNewValue ? 1 : 0;
                }
                var oldValue = item.virtual ? item.value : item.getValue();
                if (item.virtual)
                    item.value = newValue;
                else
                    item.setValue(newValue);
                this.transformItemChangeHandler(item, newValue, oldValue);
            }
            if (colKey === 'CODE') {
                var rowPanel = this.findTransRowPanel();
                if (rowPanel) rowPanel.setTitle('#' + newValue);
            }
        },

        actionCheckboxLabels: [
            'Меры в отношении лица, реализовавшего продукцию, завершены',
            'Меры в отношении лица, производителя товара, завершены'
        ],

        // ============= DOG-NAILS =======================
        dogNail: function (item) {
            var tableView = item.parentView;
            // Subitem of compositefield
            if (!tableView) return;
            // RPN notices only
            if (tableView.parentView.data.isRPN) {
                switch (tableView.tableName) {
                default:
                    if (this.data.isSingleTransform &&
                        jQuery.inArray(item.fieldLabel, this.actionCheckboxLabels) >= 0) {
                        var tableStatus = this.tableStatus.getRawValue();
                        if (item.checked && tableStatus !== 'Меры приняты') {
                            this.setStatusActionsTaken(true);
                        } else if (!item.checked && tableStatus === 'Меры приняты') {
                            this.setStatusActionsTaken(false);
                        }
                    }
                    break;
                }
            }
            if (KS.isSurDB) {
                // RPNSUR-99
//                if (tableView.data.tableDescription.Code === '001' && item.colMapped === "COL2") {
//                    var sln = item.getRawValue(),
//                        skkSendBtn = tableView.parentView.mainMenu.sendSkk;
//                    if (skkSendBtn) skkSendBtn.setDisabled(sln && sln.toUpperCase().indexOf('НА ОТБОРЕ ПРОБ') >= 0);
//                }
            }
            // Title
            if (tableView.data && item.colMapped === tableView.data.transformTitleField) {
                var rowPanel = tableView.findTransRowPanel(),
                    newValue = tableView.getTransformRecTitle(rowPanel);
                if (rowPanel && newValue) rowPanel.setTitle('#' + newValue);
            }
        },

        setStatusActionsTaken: function (taken) {
            var targetName = null,
                targetRow = null,
                df = this.data.tableStatus.comboData.displayField;
            if (taken === true) targetName = 'Меры приняты';
            if (taken === false) targetName = 'Меры не приняты';
            Ext.each(this.data.tableStatus.comboData.rows, function(row) {
                if (row[df] === targetName)
                    targetRow = row;
            });
            if (targetName) {
                this.data.tableStatus.value = targetName;
                this.tableStatus.setValue(this.data.tableStatus.value);
                this.comboTableStatusSelected(this.tableStatus, targetRow);
            }
        },

        comboTableStatusSelected: function (combo, row) {
            var attrLink = this.data.tableStatus.desc.AttributeLink;
            this.parentView.processSelectedAttributeRow(attrLink, row);
            this.touch();
            this.setCheckboxActionsTaken(combo, row);
        },

        setCheckboxActionsTaken: function (combo, row) {
            var acb = this.findActionCheckboxItem();
            if (acb) {
                switch (row[combo.displayField]) {
                case 'Меры приняты':
                    if (!acb.checked)
                        acb.setValue(true);
                    break;
                default:
                    if (acb.checked)
                        acb.setValue(false);
                    break;
                }
            }
        },

        findActionCheckboxItem: function () {
            var view = this,
                item = null;
            if (this.data.isSingleTransform) {
                Ext.each(this.actionCheckboxLabels, function(acl) {
                    var found = view.findTransformItemBy('fieldLabel', acl);
                    if (found && found.xtype === 'checkbox') item = found;
                });
            }
            return item;
        },

        refreshTableStatus: function () {
            this.serverCall({
                method: 'RefreshTableStatus',
                disableFog: true,
                success: this.setTableStatus
            });
        },

        transformItemChangeHandler: function(item, newValue, oldValue) {
            var view = item.parentView,
                value = { Direct: newValue };
            switch (item.xtype) {
                case 'checkbox':
                    if (Ext.isBoolean(newValue))
                        value.Direct = newValue ? 1 : 0;
                    break;
                case 'datefield':
                    var format = view.parentView.data.isRPN ? 'Y-m-d' : 'd.m.Y';
                    value.Direct = Ext.util.Format.date(value.Direct, format);
                    break;
            }
            var depCbx = view.data.dependentCheckboxes[item.colMapped];
            if (depCbx) view.setTransformItemValue(depCbx, !Ext.isEmpty(newValue));
            var recData = item.recData;
            var cvalue = {
                'LinkSavedRow': recData['LINK_SAVED_ROW'] || recData['link_saved_row'],
                'LinkDictionRowGroup': null,
                'LinkDictionRow': recData["LINK_DICTION_ROW"] || item.recData["link_diction_row"],
                'FakeDictionLink': 0,
                'FakeSavedLink': 0,
                'ColKey': item.colMapped,
                'Value': value,
                'OriginalValue': oldValue,
                'IsNewRow': false
            };
            view.addNewCachedValues(cvalue);
            view.touch();
            view.dogNail(item);
        },

        setTableStatus: function(status) {
            if (Ext.isString(status)) {
                this.tableStatus.setValue(status);
                return;
            }
            if (Ext.isObject(status))
                this.data.tableStatus = status;
            if (this.data.tableStatus)
                this.tableStatus.setValue(this.data.tableStatus.value);
        },

        applyTableState: function () {
            if (this.tableState) {
                if (this.data.isSingleTransform) {
                    this.transPanel.body.scrollTo('top', this.tableState.scroll.top);
                } else {
                    var rowPanel = this.findTransRowPanel(this.tableState.savedRowLink);
                    if (rowPanel) {
                        this.transPanel.setActiveTab(rowPanel);
                        rowPanel.body.scrollTo('top', this.tableState.scroll.top);
                    }
                }
                this.tableState = null;
            }
        },

        buildTableStatus: function() {
            var ctrls = [];
            ctrls.push({
                    xtype: 'label',
                    text: ' ' + this.data.tableStatus.desc.NameShort + ': '
                });
            if (this.data.tableStatus.comboData) {
                ctrls.push(this.tableStatus = this.buildDictionaryCombo(this.data.tableStatus.comboData,
                    {
                        emptyText: 'Статус не выбран',
                        editable: false,
                        onSelectHandler: this.comboTableStatusSelected,
                        listWidth: 'auto'
                    }));
            } else {
                ctrls.push(this.tableStatus = new Ext.form.TextField({
                        emptyText: 'Статус ',
                        readOnly: true,
                        value: this.data.tableStatus.value,
                        width: 150
                    }),
                    this.tableStatusButton = new Ext.Button({
                        iconCls: 'ks-icon-dict',
                        tableStatus: this.data.tableStatus,
                        parentView: this,
                        handler: function(btn) {
                            btn.parentView.parentView.openDictionary('attrDict', btn.tableStatus.desc.AttributeLink);
                        }
                    }));
            }
            return new Ext.Container({
                layout: {
                        type: 'hbox',
                        align: 'center'
                    },
                items: ctrls
                });
        },

        selectTransformTableCell: function(colKey, dictionRowLink){
            var item = this.findTransformItem(colKey);
            if (item){
                this.scrollTransformPanel(item, dictionRowLink);
                if (item.focus)
                    item.focus();
                item.addCls("select-empty-cell");
                setTimeout(function(){
                    item.removeCls("select-empty-cell")
                }, 5000); 
            }
        },
        
        scrollTransformPanel: function(selectItem, dictionRowLink){
            var selectItemSpace = 0;
            var rowPanel = this.findTransRowPanel(dictionRowLink);
            if (!rowPanel) return;
            if (Ext.isFunction(this.transPanel.setActiveTab))
                this.transPanel.setActiveTab(rowPanel);
            rowPanel.items.each(function (fset) {
                if (fset.items.items.indexOf(selectItem) >= 0) {
                    fset.items.each(function (item) {
                        if (!item.hidden && item != selectItem) {
                            selectItemSpace += item.getHeight();
                        } else {
                            return false;
                        }
                    });
                    selectItemSpace += 30; // Заголовок fieldset
                    return false;
                } else {
                    selectItemSpace += fset.getHeight();
                }
            });
            var transPanelHeight = this.transPanel.getHeight(); 
            if (selectItemSpace > transPanelHeight/2) {
                this.transPanel.setScrollY(selectItemSpace - transPanelHeight/2);
            }
        },
        
        transformAddFile: function(){
            var owner = this.ownerCt;
            var view = owner.parentView;
            view.cellOptionsForFile = owner.cellOptionsForFile;
            var fileBtn = Ext.getCmp(owner.fileBtnId);
            if (!KS.isEmpty(fileBtn)) {
                fileBtn.fileInputEl.dom.click(); // открываем окно выбора файла, после запускается saveFiles
            }
        },
        
        transformDownloadFile: function(){
            var owner = this.ownerCt;
            var view = owner.parentView;
            view.cellOptionsForFile = owner.cellOptionsForFile;
            view.saveCellFile();
        },
        
        transformDeleteFile: function(){
            var owner = this.ownerCt;
            var view = owner.parentView;
            view.cellOptionsForFile = owner.cellOptionsForFile;
            view.deleteCellFile();
        },
    });
}(SavedFormTableView.prototype));

// ============= FILTER MENU =======================
(function (viewClass) {
    KS.apply(viewClass, {
        customFilterMenuItems: function(){
            var grid = this.mainGrid;
            if (grid.lockedGrid) {
                this.changeFilterMenuItems(grid.lockedGrid);
                this.changeFilterMenuItems(grid.normalGrid);
            } else {
                this.changeFilterMenuItems(grid);
            }
        },

        changeFilterMenuItems: function(grid) {
            var filter = grid.getView().findFeature('filter');
            if (filter) {
                filter.getFilterMenuBase = filter.getFilterMenu;
                filter.getFilterMenu = this.getReportFilterMenu; // дёргается из renderer.js
                filter.parentView = this;
            }
        },

        getReportFilterMenu: function(me, context){
            var filterMenu = this.getFilterMenuBase(this, context);
            var view = this.parentView;
            var vs = view.data.visualSettings;
            var column = context.column;
            var itemIds = {
                aprSep: 'appearanceSeparator',
                allApr: 'allAppearance',
                defApr: 'defaultAppearance',
                sumApr: 'summaryAppearance',
                errApr: 'errorAppearance',
                disApr: 'disableAppearance'
            };
            if (filterMenu.appearanceFilter) {
                Ext.Array.forEach(Object.values(itemIds), function (itemId) {
                    var item = filterMenu.getComponent(itemId);
                    filterMenu.remove(item);
                })
            }
            if (column && column.tag && column.tag.IsData){
                filterMenu.add(
                    {
                        itemId: itemIds.aprSep,
                        xtype: 'menuseparator'
                    });
                filterMenu.add(
                    {
                        itemId: itemIds.allApr,
                        text: 'Все строки',
                        filterType: 'appearanceFilter',
                        appearanceLink: itemIds.allApr,
                        iconCls: 'ks-icon-filter_off',
                        handler: view.changeAppearanceFilter
                    });
                filterMenu.add(
                    {
                        itemId: itemIds.defApr,
                        text: 'Обычные строки',
                        filterType: 'appearanceFilter',
                        appearanceLink: vs.defaultAppearanceLink,
                        cls: 'link-setting-' + vs.defaultAppearanceLink,
                        handler: view.changeAppearanceFilter
                    });
                filterMenu.add(
                    {
                        itemId: itemIds.sumApr,
                        text: 'Итоги',
                        filterType: 'appearanceFilter',
                        appearanceLink: vs.summaryAppearanceLink,
                        cls: 'link-setting-' + vs.summaryAppearanceLink,
                        handler: view.changeAppearanceFilter
                    });
                filterMenu.add(
                    {
                        itemId: itemIds.errApr,
                        text: 'Ошибки',
                        filterType: 'appearanceFilter',
                        appearanceLink: vs.errorAppearanceLink,
                        cls: 'link-setting-' + vs.errorAppearanceLink,
                        handler: view.changeAppearanceFilter
                    });
                filterMenu.add(
                    {
                        itemId: itemIds.disApr,
                        text: 'Нет доступа',
                        filterType: 'appearanceFilter',
                        appearanceLink: vs.disableAppearanceLink,
                        cls: 'link-setting-' + vs.disableAppearanceLink,
                        style: {
                            textAlign: 'left !important'
                        },
                        handler: view.changeAppearanceFilter
                    });
                filterMenu.appearanceFilter = true;
            }
            return filterMenu;
        },

        changeAppearanceFilter: function (menuItem) {
            var context = menuItem.container.component.ctx,
                column = context.column,
                dataIndex = column.dataIndex,
                grid = context.grid,
                filterProp = 'nastr',
                showAllRows = menuItem.id === 'allAppearance';

            if (!grid.filter) {
                grid.filter = {
                    asString: JSON.stringify([])
                }
            }

            // if (showAllRows)
            //     column.removeCls('ks-filterCol'); 
            // else
            //     column.addCls('ks-filterCol'); // не удаляется подкраска по Очистить фильтр/все фильтры

            var newFilters = [],
                oldFilters = JSON.parse(grid.filter.asString);

            if (!showAllRows){
                var filterValue = menuItem.appearanceLink + "#|" + dataIndex.toUpperCase();
                newFilters = [{
                    Name: filterProp,
                    Condition: "contains",
                    Value: filterValue
                }]
            }

            // удаляем старые фильтры по колонке
            for (var i = oldFilters.length - 1; i >= 0; i--) {
                if (oldFilters[i].Name === filterProp)
                    oldFilters.splice(i, 1);
            }
            // присваиваем новые фильтры по колонке
            oldFilters = oldFilters.concat(newFilters);

            grid.filter = {
                asString: JSON.stringify(oldFilters)
            };

            grid.filterValue = filterValue;

            grid.getStore().loadPageFromServerTemplate(1, grid);
        }
    });
}(SavedFormTableView.prototype));

function buildCellValue(rec, colKey, value, originalValue, isNewRow) {
    value = (typeof (value) == "object")
        ? value
        : { Direct: value };
    return {
        'LinkSavedRow': (rec == null) ? 0 : +KS.Grid.getAnyCase(rec, "LINK_SAVED_ROW"),
        'LinkDictionRowGroup': (rec == null) ? 0 : +KS.Grid.getAnyCase(rec, "LINK_DICTION_ROW_GROUP"),
        'LinkDictionRow': (rec == null) ? 0 : +KS.Grid.getAnyCase(rec, "LINK_DICTION_ROW"),
        'FakeDictionLink': 0,
        'FakeSavedLink': 0,
        'ColKey': colKey,
        'Value': value,
        'OriginalValue': originalValue,
        'IsNewRow': isNewRow || false,
        'VisualSettings': (rec == null) ? "" : KS.Grid.getAnyCase(rec, "nastr")
    };
}

function getReportRROColumnType(record, colKey) {
    if (colKey.indexOf("NPA_DATE") >= 0) {
        return "date";
    } else if (colKey.indexOf("NPA_PART") >= 0) {
        return "part";
    } else if (colKey.indexOf("NPA_NAME") >= 0) {
        return "name";
    }
    return null;
}

function isCellDisabled(record, c) {
    return (getCellDisableState(record, c, null) !== false);
}

function getItemProperties(record, dataIndex) {
    var view = record.store.grid.parentView;
    var linkSavedRow = KS.Grid.getAnyCase(record, 'link_saved_row');
    if (view.itemPropertiesChanges === true || KS.isEmpty(view.allItemProperties[linkSavedRow])) {
        view.getAllItemProperties();
    }
    if (!KS.isEmpty(view.allItemProperties[linkSavedRow])) {
        return view.allItemProperties[linkSavedRow][dataIndex];
    } else {
        return { IsReadOnly: false };
    }
}

function isSubCell(code, columnKey, rowsOn, rowsOff) {
    if (KS.isEmpty(code)) return false;
    if (rowsOn && rowsOn[columnKey]) {
        return $.inArray(code, rowsOn[columnKey]) >= 0;
    }
    if (rowsOff && rowsOff[columnKey]) {
        return $.inArray(code, rowsOff[columnKey]) < 0;
    }
    return true;
}

function openSubTable(viewId, colKey, savedRowLink) {
    var view = KS.getView(viewId);
    if (view) {
        var recIndex = view.findRecBySavedLink(savedRowLink);
        var rec = view.mainGrid.getStore().getAt(recIndex);
        var linkSavedRow = KS.Grid.getAnyCase(rec, 'LINK_SAVED_ROW');
        view.fillFakeLinks(rec);
        view.serverCall({
            method: "OpenSubTable",
            params: [colKey, linkSavedRow]
        });
    }
}

function getReportTableFormat(value, metadata, record, rowIndex, dataIndex, store, useLinkSetting) {
    var view = store.grid.parentView,
        colDesc = metadata.column.tag,
            cellCss, 
        ls,
        isErr = KS.Grid.getAnyCase(record, "IS_ERROR"),
        isErrorRow = (isErr === true || isErr === "true");
                                                           
    var itemProperties = getItemProperties(record, dataIndex);

    if (isErrorRow) {
        cellCss = " error-cell";
    } else {
        ls = itemProperties.AppearanceLink; 
        
        cellCss = " link-setting-";
        if (typeof(ls) == "number") {
            if (ls > 0) {
                cellCss += ls;
            } else {
                cellCss += (-ls) + "-disabled";
            }
        } else {
            cellCss += ls;
        }
    }

    var appearanceLink = itemProperties.AppearanceLink,
        isBlockedCell = appearanceLink === 'blockedCellAppearance' ||
                     appearanceLink === 'blockedSummaryCellAppearance',
        disableState = itemProperties.IsDisable && !isBlockedCell,
        newValue = value,
        needParse = true;

    if (colDesc && colDesc.SubTable && isSubCell(KS.Grid.getAnyCase(record, "CODE"), colDesc.Key, view.data.rowsOnFilter, view.data.rowsOffFilter)) {
        newValue = '<span class="like-hypertext" onclick="' +
            "openSubTable('" + view.viewID + "','" + colDesc.Key + "'," + KS.Grid.getAnyCase(record, "LINK_SAVED_ROW") + ");" +
            '">' + (isCellEmpty(value, colDesc) ? 'Добавить' : 'Редактировать') + '</span>';
        needParse = false;
        cellCss += ' x-center-cell-align';
    }
    
    if (useLinkSetting === true) {

    } else if (disableState === true) {
        if (Ext.isEmpty(itemProperties.Tooltip)) {
            metadata.tdAttr = 'data-qtip=""';
        }
        if (!(typeof itemProperties.AppearanceLink == "string"))
            cellCss = isEmpty ? " default-cell-disabled" : " error-disable-cell";
        cellCss += " x-center-cell-align x-bold-cell";
        metadata.align = "center";
        newValue = getCellDisableValue(record, dataIndex);
        needParse = false;
    } else if (disableState !== false) {
        cellCss += "-disabled";
    }

    if (!Ext.isEmpty(itemProperties.Tooltip)) {
        setTooltip(metadata, itemProperties.Tooltip);
        if (itemProperties.IsUserTooltip) {
            cellCss += record.isDirty() ? " user-tooltip-dirty-cell" : " user-tooltip";
        }
    }

    return {
        newValue: newValue,
        cellCss: cellCss,
        needParseNewValue: needParse
    };
}

function getCellDisableState(rec, c, ls) {
    var view = rec.store.grid.parentView,
        dcs = view.data.visualSettings.disabledCells,
        colCfg = c;
    if (typeof (c) == 'number') {
        if (c < 0) return false;
        colCfg = view.mainGrid.getColCfgByIndex(c);
    }
    if (!colCfg) return false;
    if (colCfg.tag && colCfg.tag.MergedTableDisableReason) {
        if (colCfg.tag.MergedTableDisableReason[rec.data["LINK_TABLE"]] > 0)
            return colCfg.tag.MergedTableDisableReason[rec.data["LINK_TABLE"]];
    }
    else if (colCfg.tag && colCfg.tag.DisableReason > 0) return colCfg.tag.DisableReason;
    if (dcs) {
        var colKey = colCfg.dataIndex,
            ldr = KS.Grid.getAnyCase(rec, "LINK_DICTION_ROW"),
            ldrg = KS.Grid.getAnyCase(rec, "LINK_DICTION_ROW_GROUP") || 0,
            dc = dcs[ldr + "#" + colKey] || dcs["#" + colKey] || dcs[ldr + "#"] || dcs[ldr + "#" + ldrg + '#' + colKey];
        if (Ext.isDefined(dc)) {
            if (dc & 1)
                return true;
            if (dc & 2)
                return -1;
            if (dc & 4)
                return -3;
        }
    }
    var isSummary = ((ls || getLinkSetting(rec, c, rec.store, false)) == view.data.summaryAppearanceLink);
    if (view.data.onlyAdminCanEditTotalRows && !KS.isAdmin && isSummary) return -2;
    return false;
}

function isCellEmpty(value, colDesc) {
    if (colDesc && !colDesc.Type) {
        var fv = parseFloat((("" + value) || "0").replace(",", "."));
        return (isNaN(fv) === false && fv === 0);
    } else {
        return Ext.isEmpty(value);
    }
}

function getLinkSetting(record, col, store, useLinkSetting) {
    var view = store.grid.parentView,
        scs = view.data.visualSettings.summaryCells,
        colKey = col.dataIndex,
        ls = 0;

    if (!Ext.isEmpty(scs) && !Ext.isEmpty(colKey)) {
        var ldr = KS.Grid.getAnyCase(record, 'LINK_DICTION_ROW'),
            ldrg = KS.Grid.getAnyCase(record, 'LINK_DICTION_ROW_GROUP');
        if (ldrg == 0) ldrg = '';
        ls = getLsTemplate(scs, ldr, ldrg, colKey);
    }
    if (useLinkSetting) ls = KS.Grid.getAnyCase(record, 'LINK_SETTING');
    return ls || 0;
}

function getCellDisableValue(record, colKey) {
    var view = record.store.grid.parentView,
        dcv = view.data.visualSettings.disabledValues,
        value = null;

    if (dcv) {
        var ldr = KS.Grid.getAnyCase(record, "LINK_DICTION_ROW");
        value = dcv[ldr + "#" + colKey] || dcv["#" + colKey] || dcv[ldr + "#"];
    }

    return value || view.data.disabledValue;
}

function getLsTemplate(scs, ldr, ldrg, colKey) {
    return scs[ldr + "#" + ldrg + "#" + colKey] // single
        || scs["#" + ldrg + "#" + colKey] // all rows
        || scs[ldr + "##" + colKey] // all groups
        || scs[ldr + "#" + ldrg + "#"] // all columns
        || scs["##" + colKey]
        || scs["#" + ldrg + "#"]
        || scs[ldr + "##"]
        || scs["##"]; // all
}

function checkReadOnlyColumnAsDisabled(metadata, colIndex, store, defaultStyle, record) {
    var cellCss = defaultStyle;

    if (!metadata.column.editable) cellCss = ' sidewall-cell';

    if (record) {
        var isErr = KS.Grid.getAnyCase(record, "IS_ERROR"),
            isErrorRow = (isErr === true || isErr === "true" || isErr === "True");
        if (isErrorRow) {
            cellCss = " error-cell";
        }
    }

    metadata.css += cellCss;
}

function isEmpty(s) {
    return Ext.isEmpty(s);
}

function getRecDataValue(recData, field) {
    if (!recData || !field) return null;
    return recData[field] || recData[field.toLowerCase()] || recData[field.toUpperCase()];
}

// ============= RENDERERS =======================
function defaultReportCellRenderer(value, metadata, record, rowIndex, colIndex, store, defaultStyle){
    setTooltip(metadata, value);
    var rtf = getReportTableFormat(value, metadata, record, rowIndex, metadata.column.dataIndex, store, false);
    if (rtf.cellCss) metadata.css += rtf.cellCss;
    if (defaultStyle)
        checkReadOnlyColumnAsDisabled(metadata, colIndex, store, defaultStyle, record);
    return KS.getNbspString(rtf.newValue);
}

function numberRenderer(value, metadata, record, rowIndex, colIndex, store) {
    try {
        var colDesc = metadata.column.tag,
            rtf = getReportTableFormat(value, metadata, record, rowIndex, metadata.column.dataIndex, store, false),
            retValue = rtf.newValue || '0';

        if (!colDesc.hasOwnProperty("DefaultValue") && Ext.isEmpty(rtf.newValue)){ // DefaultValue == null
            retValue = '';
            rtf.needParseNewValue = false;
        }
        if (rtf.cellCss) {
            metadata.css = metadata.css ? metadata.css : "";  // metadata.css приходит null
            metadata.css += rtf.cellCss;
        }
        if (!rtf.needParseNewValue) return retValue;
        var actualLength = colDesc.ActualLength;
        if (colDesc.MergedTableActualLength) {
            var tableLink = store.data.items[rowIndex].data["LINK_TABLE"];
            actualLength = colDesc.MergedTableActualLength[tableLink];
        }
        retValue = KS.Svod.normalizeFloatValue(retValue, actualLength, colDesc.Divider);
        if (retValue.indexOf(",") != -1) {  // Чтобы не было пробелов в части после запятой, если там больше 3 чисел
            var numberParts = retValue.split(",");
            return numberParts[0].replace(/(\d)(?=(\d\d\d)+([^\d]|$))/g, '$1 ') + "," + numberParts[1];
        }
        return retValue.replace(/(\d)(?=(\d\d\d)+([^\d]|$))/g, '$1 ');
    } catch (e) {
        var errMsg = ((e.message == null) ? e.toString() : e.message);
        metadata.attr = 'ext:qtip=\"(' + value + ")" + errMsg.replace(/"/g, "'") + '\"';
        return value;
    }
}

function summaryRenderer(value, summaryData , dataIndex, metadata) {
    metadata.style += "background-color : #bed8fd;";
    if (this.dataType === "system.decimal") {
        var sum = 0,
            tempValue = '0',
            colDesc = metadata.column.tag,
            store = this.getView().getStore(),
            grid = store.grid,
            selected = grid.getSelectionModel().getSelected();
        if ((metadata.record.id.indexOf("-summary-record-selected") !== -1) && (selected && ((selected.selectedRecords && selected.selectedRecords.length > 0) ||
            (!KS.isEmpty(selected.startCell) && !KS.isEmpty(selected.endCell))))) {
            if (selected.selectedRecords) {
                selected.selectedRecords.each(function(row) {
                    tempValue = row.get(dataIndex) || '0';
                    sum += parseFloat(tempValue.replace(',', '.'));
                });
            } else {
                var selectedRange = selected.getRange();
                var columnIdx = -1;
                Ext.each(grid.getVisibleColumns(), function(colConfig, i) {
                        if (colConfig.dataIndex === dataIndex) {
                            columnIdx = i;
                        }
                    });
                if (columnIdx >= selectedRange[0][0] &&
                    columnIdx <= selectedRange[1][0]) {
                    for (var rowIdx = selectedRange[0][1]; rowIdx <= selectedRange[1][1]; rowIdx++) {
                        var row = store.getAt(rowIdx);
                        tempValue = row.get(dataIndex) || '0';
                        sum += parseFloat(tempValue.replace(',', '.'));
                    }
                }
            }
        } else {
            store.each(function(r) {
                tempValue = r.get(dataIndex) || '0';
                sum += parseFloat(tempValue.replace(',', '.'));
            });
        }
        sum = KS.Svod.normalizeFloatValue(sum, colDesc.ActualLength, colDesc.Divider);
        return sum.replace(/(\d)(?=(\d\d\d)+([^\d]|$))/g, '$1 ');
    }
    return value || "";
}

function stringRenderer(value, metadata, record, rowIndex, colIndex, store) {
    return defaultReportCellRenderer(value, metadata, record, rowIndex, colIndex, store);
}

function reportTableDateRenderer(value, metadata, record, rowIndex, colIndex, store) {
    return defaultReportCellRenderer(value, metadata, record, rowIndex, colIndex, store);
}

function reportTableDateTimeRenderer(value, metadata, record, rowIndex, colIndex, store) {
    return defaultReportCellRenderer(value, metadata, record, rowIndex, colIndex, store);
}

function reportTableCellRenderer(value, metadata, record, rowIndex, colIndex, store) {
    return defaultReportCellRenderer(value, metadata, record, rowIndex, colIndex, store);
}

function rroRenderer(value, metadata, record) {
    setTooltip(metadata, value);  
    var ctype = getReportRROColumnType(record, metadata.column.dataIndex);
    switch (ctype) {
        case 'name':
            metadata.css += ' sidewall-dict-cell';
            break;
        case 'part':
            break;
        case 'date':
            metadata.css += ' sidewall-cell';
            break;
    }
    return value;
}

function autoIncrementRenderer(value, metadata, record, rowIndex, colIndex, store) {
    return defaultReportCellRenderer(value, metadata, record, rowIndex, colIndex, store, ' sidewall-cell');
}

function swallNonCodeDictRenderer(value, metadata, record, rowIndex, colIndex, store) {
    return defaultReportCellRenderer(value, metadata, record, rowIndex, colIndex, store, ' sidewall-dict-cell');
}

function sidewallRenderer(value, metadata, record, rowIndex, colIndex, store) {
    return defaultReportCellRenderer(value, metadata, record, rowIndex, colIndex, store, ' sidewall-dict-cell');
}

function selectFromDictionRenderer(value, metadata, record, rowIndex, colIndex, store) {
    if (metadata.column.aspType === "datecolumn")
        value = getRendererDateValue(value, metadata.column.format)
    return defaultReportCellRenderer(value, metadata, record, rowIndex, colIndex, store, ' sidewall-dict-cell');
}

function groupRenderer(value, metadata, record, rowIndex, colIndex, store) {
    return defaultReportCellRenderer(value, metadata, record, rowIndex, colIndex, store, ' group-cell');
}

function nonSidewallDictRenderer(value, metadata, record, rowIndex, colIndex, store) {
    setTooltip(metadata, value);
    var rtf = getReportTableFormat(value, metadata, record, rowIndex, metadata.column.dataIndex, store, false);
    metadata.css = metadata.css ? metadata.css : "";  
    if (rtf.cellCss.substring(14)) {
        metadata.css += rtf.cellCss;
    } else {
        metadata.css += ' sidewall-dict-cell';  
    }
    // var colDesc = metadata.column.tag;
    // if (colDesc.SubTable) {
    //     return (value) ? 'редактировать' : 'добавить';
    // }
    return KS.getNbspString(rtf.newValue || value);
}

function popupDictRenderer(value, metadata, record, rowIndex, colIndex, store) {
    return defaultReportCellRenderer(value, metadata, record, rowIndex, colIndex, store);
}

function linkSettingTreeRenderer(value, metaData, record) {
    var cls = record.data.linkSetting;
    if (cls) metaData.tdCls = (metaData.tdCls || '') + cls;
    return value;
}

function selectFromDADATARenderer(value, metadata, record, rowIndex, colIndex, store) {
    return defaultReportCellRenderer(value, metadata, record, rowIndex, colIndex, store, ' sidewall-dict-cell');    
}

function uniDictComboRenderer(value, metadata, record, rowIndex, colIndex, store) {
    value = valuesListRenderer(value, metadata, record, rowIndex, colIndex, store);
    return defaultReportCellRenderer(value, metadata, record, rowIndex, colIndex, store, ' sidewall-dict-cell');
}

function fileChooseRenderer(value, metadata, record, rowIndex, colIndex, store) {
    return defaultReportCellRenderer(value, metadata, record, rowIndex, colIndex, store, ' sidewall-dict-cell');
}

function booleanComboRenderer(value, metadata, record, rowIndex, colIndex, store) {
    value = valuesListRenderer(value, metadata, record, rowIndex, colIndex, store);
    return defaultReportCellRenderer(value, metadata, record, rowIndex, colIndex, store);
}

function reportCheckboxRenderer(value, metadata, record, rowIndex, colIndex, store) {
    value = Ext.grid.column.Check.prototype.defaultRenderer.apply(this, arguments);
    var rtf = getReportTableFormat(value, metadata, record, rowIndex, metadata.column.dataIndex, store, false);
    if (rtf.cellCss) metadata.css += rtf.cellCss;
    metadata.align = "center";
    return rtf.newValue;
}

function getRendererDateValue(value, format) {
    if (value != null && value.length > 10) {
        var retDate = new Date(value);
        return Ext.Date.format(retDate, 'd.m.Y');
    } else if (Ext.isDate(value)) {
        return Ext.util.Format.date(value, format);
    }
    return value;
}

// ============= CLIPBOARD =======================
function getTextDataRedef (format, erase) { //Grid Clipboard override 
    var cmp = this.getCmp(),
        selModel = cmp.getSelectionModel(),
        ret = [],
        data, dataIndex, lastRecord, record, row, view,
        invalidXtype = ['rownumberer', 'checkcolumn'];

    selModel.getSelected().eachCell(function (cellContext) {
        var column = cellContext.column;
        if (invalidXtype.indexOf(column.xtype) > -1)
            return;

        view = column.getView();
        record = cellContext.record;

        if (lastRecord !== record) {
            lastRecord = record;
            ret.push(row = []);
        }
        
        dataIndex = column.dataIndex;
        data = record.data[dataIndex];
        if (column.aspType === "datecolumn")
            data = getRendererDateValue(data, column.format);

        row.push(data);

        if (erase && dataIndex) {
            record.set(dataIndex, null);
        }
    });
    return Ext.util.TSV.encode(ret);
}

function putTextData (data, format) {  // Вставка данных на crtl+v
    data = data.replace(/\r\n/g, "\n"); // При "Специальная вставка" идут переносы по \r\n
    if (data.substring(data.length-1) == "\n") 
        data = data.substring(0, data.length-1); // При вставке строки, скопированной из экселя, появлялась лишняя пустая строка
    var recCount = Ext.util.TSV.decode(data).length,
        gridPanel = this.getCmp(),
        parentView = gridPanel.parentView,
        maxRowIdx = gridPanel.getStore().getCount() - 1,
        selected = gridPanel.getSelectionModel().getSelected();
    if (parentView.reportReadOnly() || !parentView.gridStoreNotEmpty() || 
        Ext.isEmpty(selected) || Ext.isEmpty(selected.startCell)) {
        return;
    }

    var startRowIdx = selected.startCell.rowIdx;
    var newRecordsCount = recCount - (maxRowIdx - startRowIdx) - 1;
    if (newRecordsCount > 0 && !parentView.data.isStatic && 
        parentView.data.tableDescription.IsSidewallAdd) {
        parentView.serverCall({
            method: 'AddSeveralNewRow',
            params: [newRecordsCount],             
            disableFog: true,
            success: function (resultRows) {
                Ext.each(resultRows, function(dataRow) {
                    parentView.mainGrid.addRecord(dataRow);
                });
                doPutTextData(data, gridPanel);
            }
        });
    } else {
        doPutTextData(data, gridPanel);
    }
}

function doPutTextData(data, gridPanel) {
    var values = Ext.util.TSV.decode(data),
        recCount = values.length,
        colCount = recCount ? values[0].length : 0,
        store = gridPanel.getStore(),
        parentView = gridPanel.parentView,
        maxRowIdx = gridPanel.getStore().getCount() - 1,
        columns = gridPanel.getVisibleColumns(),
        maxColIdx = columns.length - 1,
        selected = gridPanel.getSelectionModel().getSelected(),
        startRowIdx = selected.startCell.rowIdx,
        startColIdx = selected.startCell.colIdx,
        destRowIdx = startRowIdx,
        destColIdx = startColIdx;

    for (var sourceRowIdx = 0; sourceRowIdx < recCount; sourceRowIdx++) {
        var rowValues = values.shift(),
            rec = store.getAt(destRowIdx++);

        for (var sourceColIdx = 0; sourceColIdx < colCount; sourceColIdx++) {
            var column = columns[destColIdx++],
                cellValue = rowValues.shift(),
                dataIndex = column.dataIndex,
                origValue = rec.get(dataIndex);

            cellValue = cellValue.replace(/\n+$/, ''); // Из конца строки удаляем все переносы строк
            if (column.renderer === numberRenderer) {
                cellValue = cellValue.replace(/\s/g, '');
                var floatCellValue = parseFloat(cellValue.replace(",","."));
                var floatOrigValue = column.tag && !column.tag.hasOwnProperty("DefaultValue") && Ext.isEmpty(origValue) ?  // DefaultValue == null
                                                0 : 
                                                parseFloat(origValue.toString().replace(",","."));
                switch (parentView.pasteMode) {
                    case 'sum':
                        cellValue = floatOrigValue + floatCellValue;
                        break;

                    case 'sub':
                        cellValue = floatOrigValue - floatCellValue;
                        break;

                    case 'mul':
                        cellValue = floatOrigValue * floatCellValue;
                        break;

                    case 'div':
                        cellValue = floatOrigValue / floatCellValue;
                        if (cellValue === Infinity)
                            cellValue = 0;
                        break;
                }
            }

            parentView.saveCellValue(rec, dataIndex, cellValue, origValue, false);

            if (destColIdx > maxColIdx) {
                break;
            }
        }

        destColIdx = startColIdx;

        if (destRowIdx > maxRowIdx && (parentView.data.isStatic || !parentView.data.tableDescription.IsSidewallAdd)) {
             break;
        }
    }

    if (parentView.needFlush) {
        parentView.flushCachedValues();
    }

//    parentView.updatePageCache(); 
    parentView.pasteMode = 'simple'; //сбрасываем, чтобы ctrl+v работало как обычно
}

// ============= EDITORS =======================
// строковая колонка с ограничением по количеству символов
Ext.define('SavedFormTable.stringLimitedLengthEditor',
    {
        extend: 'KS.Ext.Grid.textEditor',
        enforceMaxLength: true,
        listeners: {
            specialkey: navigateAfterEdit
        },
        isKeyDown: false,
        selectText: selectTextInEditor
    });

Ext.define('SavedFormTable.numberEditor',
    {
        extend: 'Ext.form.TextField',
        allowBlank: true,
        maskRe: /[0-9.,-]/,
        fieldStyle: {
            textAlign: 'right'
        },
        listeners: {
            specialkey: navigateAfterEdit
        },
        isKeyDown: false,
        selectText: selectTextInEditor
    });

// Эти потом уйдут в платформу
Ext.define('KS.Ext.Grid.remoteComboEditor',
    {
        extend: 'Ext.form.field.ComboBox',
        queryMode: 'local',
        queryDelay: 500,
        allowBlank: true,
        store: {
            fields: ['text', 'link']
        },
        valueField: 'text',
        displayField: 'text',
        style: 'text-align:center',
        selectText: selectTextInEditor,
        selectOnTab: true,
        enforceMaxLength: true,
        listeners: {
            'beforequery': function(queryPlan) {
                var combo = this,
                    query = queryPlan.query,
                    colKey = this.dataIndex,
                    editor = this.ownerCt,
                    grid = editor.ownerCmp,
                    dictDesc = grid.parentView.data.cachedQueryDicts[colKey];
                if (KS.isEmpty(query)) return false;
                if (combo.lastQuery === query) return false;
                if (dictDesc && query.length < dictDesc[0]) return false;
                combo.lastQuery = query;
                //combo.getStore().loadData([[query]]);
                //combo.expand();
                //combo.setLoading(query);
                grid.parentView.serverCall({
                    method: 'GetQueryData',
                    params: [colKey, query],
                    disableFog: true,
                    complete: function() {
                        //combo.setLoading(false);
                    },
                    success: function (data) {
                        if (Ext.isNumber(data) && data > 0) {
                            KS.log('Query: ' + query + ', rows: ' + data);
                            combo.collapse();
                        } else {
                            combo.getStore().loadData(data);
                            combo.expand();
                        }
                    }
                });
                return false;
            }
        }
    });

Ext.define('SavedFormTable.selectFromDADATAEditor',
    {
        extend: 'Ext.form.field.ComboBox',
        selectText: selectTextInEditor,
        listeners: {
            'beforerender': function(combo) {
                var colKey = this.dataIndex,
                    editor = this.ownerCt,
                    grid = editor.ownerCmp,
                    comboData = grid.parentView.data.dictionaryCombo[colKey];
                if (comboData.serverSearch) {
                    var url = 'PlatformHandler.axd?getctrldata=combo&s=' + comboData.dataSrc,
                        fields = [comboData.valueField, comboData.displayField];
                    combo.mode = 'remote';
                    if (comboData.dataSrc === 'DADATA') {
                        combo.emptyText = 'Введите название в свободной форме, адрес, ИНН или ОГРН';
                        combo.minChars = 1;
                        combo.tpl = '<tpl for="."><div class=' + ('"x-boundlist-item"') + '>' +
                            '<b>{NAME}</b><br><span>{INN:defaultValue("&nbsp;")} &nbsp;&nbsp; </span>{ADDR:defaultValue("&nbsp;")}' +
                            '</div></tpl>';
                        url += '&t=' + comboData.authToken;
                        fields.push('INN');
                        fields.push('ADDR');
                        fields.push('OGRN');
                    }
                
                    combo.valueField = comboData.displayField;//comboData.valueField;
                    combo.displayField = comboData.displayField;
                    combo.comboData = comboData;
                    combo.store = new Ext.data.Store({ 
						fields: fields,
						proxy: {
							type: 'ajax',
							url: url,
							reader: {
                                type: 'json',
                                rootProperty: 'rows',
                                totalProperty: 'total'
                            }
						}
                    });
                }
            },
			'select' : function(combo,record){
				var newValue = KS.Grid.getAnyCase(record, "NAME");
				combo.setValue(record);
				var editor = combo.ownerCt;
				editor.field.value = newValue;
				editor.completeEdit();
			}
        },
		
		findRecordByDisplay: function(value) {
            return false;
        },
		findRecordByValue: function(value) {
			// в value идет значение из ячейки, которое соответствует значению в столбце NAME, а не CODE
			/*var result = this.valueCollection.find("NAME", value);
            if (result) {
                return result;
            }*/
            return false;
        },
		getDisplayValue: function(tplData){
            tplData = tplData || this.displayTplData;
			var s = (tplData && tplData[0]) ? tplData[0][this.displayField] : "";
			return s.replace(this.newlineRe, '');
		}
    });

// Комбобоксы в РПН
comboEditor = KS.extend(Ext.form.ComboBox, {
    allowBlank: true,
    selectOnFocus: false,
    minChars: 2,
    mode: 'local',
    triggerAction: 'all',

    constructor: function(cfg) {
        var grid = cfg.grid,
            view = grid.parentView,
            comboData = view.data.dictionaryCombo[cfg.col.dataIndex],
            comboRows = view.prepareComboRows(comboData);

        KS.apply(cfg, {
            comboData: comboData,
            parentView: view,
            value: comboRows.value,
            editable: cfg.editable,
            emptyText: cfg.emptyText,
            tpl: '<tpl for="."><div class="x-boundlist-item">{' + comboData.displayField + ':defaultValue("&nbsp;")}</div></tpl>', 
            style: { overflow: 'hidden' },
            listeners: { 'select': view.comboDataSelectedHandler },
            onSelectHandler: this.dictionaryComboSelected
        });

        cfg.store = new Ext.data.ArrayStore({
            fields: [comboData.valueField, comboData.displayField],
            data: comboRows.data
            //filter: function (field, value) {
            //    Ext.data.ArrayStore.prototype.filter.apply(this, [field, value, true, false]);
            //}
        });

        comboEditor.superclass.constructor.call(this, cfg);
    }
});

Ext.define('SavedFormTable.uniDictComboEditor', {
    extend: 'valuesListEditor',
    queryMode: 'local',
    constructor: function(cfg) {
        this.callParent(arguments); // calls valuesListEditor constructor
        var colCfg = cfg.col;
        this.editable = colCfg.editable;
    }
});

Ext.define('SavedFormTable.booleanComboEditor', {
    extend: 'valuesListEditor',
    queryMode: 'local',
    constructor: function(cfg) {
        this.callParent(arguments);
    },
    listeners: {
        focus: function(comp){   // Сразу разворачиваем при активации ячейки
            comp.expand(); 
        },
        select: function(comp){
            comp.grid.view.setActionableMode(false);
        },
    }
});

//Смена фокуса на другую ячейку после редактирования
function navigateAfterEdit (field, e) {
    var key = e.getKey(),
        grid = field.grid,
        selModel = grid.getSelectionModel(),
        navModel = grid.getNavigationModel(),
        cellContext = navModel.lastFocused,
        rowIdx = Ext.isEmpty(cellContext) ? null : cellContext.rowIdx,
        colIdx = Ext.isEmpty(cellContext) ? null : cellContext.colIdx,
        newRowIdx,
        newColIdx;
    if (key == e.NUM_PERIOD || key == 188 || key == 190) {
        if ((isNaN(parseFloat(field.value)) === false) && field.value.indexOf(',') == -1) {
            field.value += ',';
        }
        e.stopEvent();
    } else if (key == e.UP || key == e.DOWN || key == e.ENTER) {
        if (key == e.DOWN) {
            if (Ext.isNumber(rowIdx)) newRowIdx = rowIdx + 1;
            if (Ext.isNumber(colIdx)) newColIdx = colIdx;
        }
        if (key == e.UP) {
            if (Ext.isNumber(rowIdx)) newRowIdx = rowIdx - 1;
            if (Ext.isNumber(colIdx)) newColIdx = colIdx;
        }
        if (key == e.ENTER && grid && grid.enterMoveDirection) {
            switch (grid.enterMoveDirection) {
                case 'down':
                    if (Ext.isNumber(rowIdx)) newRowIdx = rowIdx + 1;
                    if (Ext.isNumber(colIdx)) newColIdx = colIdx;
                    break;
                case 'right':
                    if (Ext.isNumber(rowIdx)) newRowIdx = rowIdx;
                    if (Ext.isNumber(colIdx)) newColIdx = colIdx + 1;
                    break;
                case 'next':
                    //if (grid) grid.fireEvent('selectnext', c.colMapped);
                    break;
            }
        }

        // завершить редактирование
        grid.editingPlugin.completeEdit();
        // перейти к следующей ячейке (нужны newRowIdx, newColIdx внутри lockedGrid/normalGrid, а не mainGrid)
        navModel.setPosition(newRowIdx, newColIdx);
        // новая позиция ячейки внутри lockedGrid/normalGrid
        var newPosition = navModel.getPosition();
        // null - если ушли за границы таблицы
        if (newPosition) {
            // новая позиция ячейки внутри mainGrid
            var newMainPosition = new Ext.grid.CellContext(grid.view).setPosition(newPosition.record, newPosition.column);
            // очистить выделения
            selModel.clearSelections();
            // выделить новую ячейку
            selModel.selected.setRangeStart(newMainPosition);
            // отменить перемещение скролла
            e.stopEvent();
        } else {
            // возвращаем позицию на текущую ячейку
            navModel.setPosition(cellContext.rowIdx, cellContext.colIdx);
        }
    } else if (key == e.TAB) {
        //if (grid && grid.enterMoveDirection == 'next') grid.fireEvent('selectnext');
    } else if (!(key >= e.NUM_ZERO && key <= e.NUM_NINE) &&
        !(key >= e.ZERO && key <= e.NINE) &&
        !(key == e.NUM_MINUS) &&
        !(key == e.LEFT) &&
        !(key == e.RIGHT) &&
        !(key == e.DELETE) &&
        !(key == e.BACKSPACE) &&
        !(key == 16) && // Ctrl
        !(key == 17) && // Shift
        !(key == 144) && // Num lock
        !(key == 189)) // -
    {
        e.stopEvent();
    }
}

function getVisibleColumns (grid) {
    var columns = [];
    grid.eachColumnCfg(function (column) {
        if (column.visibility === true) {
            columns.push(column);
        }
    });
    return columns;
}

// Двойная строка с суммами
Ext.define('Ext.grid.feature.DoubleSummary',
{
    extend: 'Ext.grid.feature.Summary',
    alias: 'feature.doubleSummary',

    init: function(grid) {
        var me = this,
            view = me.view,
            dock = me.dock;
 
        me.callParent([grid]);
 
        grid.addBodyCls(me.panelBodyCls + dock);
        
        grid.headerCt.on({
            add: me.onStoreUpdate,
            // we need to fire onStoreUpdate afterlayout for docked items
            // to re-run the renderSummaryRow on show/hide columns.
            afterlayout: me.onStoreUpdate,
            remove: me.onStoreUpdate,
            scope: me
        });
        
        grid.on({
            beforerender: function() {
                var tableCls = [me.summaryTableCls];
                
                if (view.columnLines) {
                    tableCls[tableCls.length] = view.ownerCt.colLinesCls;
                }

                // Нижняя строка, всегда показывает сумму всех строк
                me.summaryBar = grid.addDocked({
                    childEls: ['innerCt', 'item'],
                    /* eslint-disable indent, max-len */
                    renderTpl: [
                        '<div id="{id}-innerCt" data-ref="innerCt" role="presentation">',
                        '<table id="{id}-item" data-ref="item" cellPadding="0" cellSpacing="0" class="' + tableCls.join(' ') + '">',
                        '<tr class="' + me.summaryRowCls + '"></tr>',
                        '</table>',
                        '</div>'
                    ],
                    /* eslint-enable indent, max-len */
                    scrollable: {
                        x: false,
                        y: false
                    },
                    hidden: !me.showSummaryRow,
                    itemId: 'summaryBar',
                    cls: [me.dockedSummaryCls, me.dockedSummaryCls + '-' + dock],
                    xtype: 'component',
                    dock: dock,
                    weight: 10000000
                })[0];

                // Верхняя строка, показывается, если выбраны ячейки или строки
                me.summaryBarSelected =  grid.addDocked({
                    childEls: ['innerCt', 'item'],
                    /* eslint-disable indent, max-len */
                    renderTpl: [
                        '<div id="{id}-innerCt" data-ref="innerCt" role="presentation">',
                        '<table id="{id}-item" data-ref="item" cellPadding="0" cellSpacing="0" class="' + tableCls.join(' ') + '">',
                        '<tr class="' + me.summaryRowCls + '"></tr>',
                        '</table>',
                        '</div>'
                    ],
                    /* eslint-enable indent, max-len */
                    scrollable: {
                        x: false,
                        y: false
                    },
                    hidden: !me.showSummaryRow,
                    itemId: 'summaryBarSelected',
                    cls: [me.dockedSummaryCls, me.dockedSummaryCls + '-' + dock],
                    xtype: 'component',
                    dock: dock,
                    weight: 10000000
                })[0];
            },
            afterrender: function() {
                grid.getView().getScrollable().addPartner(me.summaryBar.getScrollable(), 'x');
                grid.getView().getScrollable().addPartner(me.summaryBarSelected.getScrollable(), 'x');
                me.onStoreUpdate();
                me.columnSizer = me.summaryBar.el;
            },
            single: true
        });
        
        grid.headerCt.on({
            afterlayout: me.afterHeaderCtLayout,
            scope: me
        });
 
        grid.ownerGrid.on({
            beforereconfigure: me.onBeforeReconfigure,
            columnmove: me.onStoreUpdate,
            scope: me
        });
        
        me.bindStore(grid, grid.getStore());
    },

    onStoreUpdate: function() {
        var me = this,
            view = me.view,
            selector = me.summaryRowSelector,
            dock = me.dock, oldRowDom, oldRowDomSelected, p;
 
        if (!view.rendered) {
            return;
        }
 
        var record = me.createSummaryRecord(view);
        var newRowDom = Ext.fly(view.createRowElement(record, -1)).down(selector, true);
 
        if (!newRowDom) {
            return;
        }
 
        // Summary row is inside the docked summaryBar Component
        if (dock && me.summaryBar.item) {
            p = me.summaryBar.item.dom.firstChild;
            oldRowDom = p.firstChild;
            
            p.insertBefore(newRowDom, oldRowDom);
            p.removeChild(oldRowDom);
        }           

        var recordSelected = me.createSummaryRecordSelected(view);
        var newRowDomSelected = Ext.fly(view.createRowElement(recordSelected, -1)).down(selector, true);

        if (!newRowDomSelected) {
            return;
        }

        if (dock && me.summaryBarSelected.item) {
            p = me.summaryBarSelected.item.dom.firstChild;
            oldRowDomSelected = p.firstChild;
            
            p.insertBefore(newRowDomSelected, oldRowDomSelected);
            p.removeChild(oldRowDomSelected);
        }
    },

    // Простой createSummaryRecord используется для нижней строки и определён в родителе
    // createSummaryRecordSelected - для верхней строки
    createSummaryRecordSelected: function(view) {
        var me = this,
            columns = view.headerCt.getGridColumns(),
            remoteRoot = me.remoteRoot,
            summaryRecord = me.summaryRecordSelected || (me.summaryRecordSelected = new Ext.data.Model({
                id: view.id + '-summary-record-selected'
            })),
            colCount = columns.length,
            i, column, dataIndex, summaryValue;
 
        // Set the summary field values
        summaryRecord.beginEdit();
 
        if (remoteRoot) {
            summaryValue = me.generateSummaryData();
            
            if (summaryValue) {
                summaryRecord.set(summaryValue);
            }
        }
        else {
            for (i = 0; i < colCount; i++) {
                column = columns[i];
 
                // In summary records, if there's no dataIndex, then the value in regular rows
                // must come from a renderer. We set the data value in using the column ID.
                dataIndex = column.dataIndex || column.getItemId();
 
                // We need to capture this value because it could get overwritten when setting
                // on the model if there is a convert() method on the model.
                summaryValue = me.getSummary(view.store, column.summaryType, dataIndex);
                summaryRecord.set(dataIndex, summaryValue);
 
                // Capture the columnId:value for the summaryRenderer in the summaryData object.
                me.setSummaryData(summaryRecord, column.getItemId(), summaryValue);
            }
        }
 
        summaryRecord.endEdit(true);
        // It's not dirty
        summaryRecord.commit(true);
        summaryRecord.isSummary = true;
 
        return summaryRecord;
    },

    onViewScroll: function() {
        this.summaryBar.setScrollX(this.view.getScrollX());
        this.summaryBarSelected.setScrollX(this.view.getScrollX());
    },

    toggleSummaryRow: function(visible, fromLockingPartner) {
        var me = this,
            bar = me.summaryBar,
            barSelected = me.summaryBarSelected;

        me.callParent([visible, fromLockingPartner]);
    
        if (bar) {
            bar.setVisible(me.showSummaryRow);
            me.onViewScroll();
        }

        if (barSelected) {
            barSelected.setVisible(me.showSummaryRow);
            me.onViewScroll();
        }
    },

    // Synchronize column widths in the docked summary Component or the inline summary row
    // depending on whether we are docked or not.
    afterHeaderCtLayout: function(headerCt) {
        var me = this,
            view = me.view,
            columns = view.getVisibleColumnManager().getColumns(),
            len = columns.length,
            i, column, summaryEl, summaryElSelected, el, width, innerCt, innerCtSelected;

        if (me.showSummaryRow && view.refreshCounter) {
            if (me.dock) {
                summaryEl = me.summaryBar.el;
                summaryElSelected = me.summaryBarSelected.el;
                width = headerCt.getTableWidth();
                innerCt = me.summaryBar.innerCt;
                innerCtSelected = me.summaryBarSelected.innerCt;

                // Stretch the innerCt of the summary bar upon headerCt layout
                me.summaryBar.item.setWidth(width);
                me.summaryBarSelected.item.setWidth(width);

                // headerCt's tooNarrow flag is set by its layout if the columns overflow.
                // Must not measure+set in after layout phase, this is a write phase.
                if (headerCt.tooNarrow) {
                    width += Ext.getScrollbarSize().width;
                }
            
                innerCt.setWidth(width);
                innerCtSelected.setWidth(width);
            }
            else {
                summaryEl =
                    Ext.fly(Ext.fly(view.getNodeContainer()).down('.' + me.summaryItemCls, true));
                summaryElSelected =
                    Ext.fly(Ext.fly(view.getNodeContainer()).down('.' + me.summaryItemCls, true));
            }

            // If the layout was in response to a clearView, there'll be no summary element
            if (summaryEl) {
                for (i = 0; i < len; i++) {
                    column = columns[i];
                    el = summaryEl.down(view.getCellSelector(column), true);
                
                    if (el) {
                        Ext.fly(el).setWidth(
                            column.width || (column.lastBox ? column.lastBox.width : 100)
                        );
                    }
                }
            }                
            // If the layout was in response to a clearView, there'll be no summary element
            if (summaryElSelected) {
                for (i = 0; i < len; i++) {
                    column = columns[i];
                    el = summaryElSelected.down(view.getCellSelector(column), true);
                
                    if (el) {
                        Ext.fly(el).setWidth(
                            column.width || (column.lastBox ? column.lastBox.width : 100)
                        );
                    }
                }
            }
        }
    }
});

if (typeof (Sys) !== "undefined") Sys.Application.notifyScriptLoaded();

//Barcode Editor
(function () {
    Ext.define('KS.Ext.BarEditor',
        {
            extend: 'Ext.form.FieldContainer',
            layout: 'hbox',

            initComponent: function () {
                var me = this;

                me.items = me.createItems();
                me.callParent(arguments);
            },

            createItems: function() {
                var me = this,
                    items = [
                    {
                        xtype: 'textfield',
                        layout: 'hbox',
                        parentView: this,
                        editable: true,
                        enableKeyEvents: false,
                        id: 'barcodeTextValue',
                        value: me.textValue,
                        listeners: {
                            'change': function () {
                                this.ownerCt.fireEvent('change');
                            }
                        }
                    }, {
                        xtype: 'button',
                        iconCls: 'ks-icon-scan_pp',
                        width: 20,
                        parentView: this,
                        handler: this.showBarcodeInputWindow
                    }, {
                        xtype: 'button',
                        iconCls: 'ks-icon-clean',
                        width: 20,
                        parentView: this,
                        handler: this.clearTextValue
                    }
                ];
                return items;
            },

            clearTextValue: function() {
                Ext.getCmp('barcodeTextValue').setValue('');
            },

            showBarcodeInputWindow: function () {
                var parentView = this.parentView,
                    addedToFormTable = 'Код добавлен в форму',
                    textCss = 'font: 500 16px/18px Segoe UI, Tahoma, verdana, sans-serif; color: #4BB543; justify-content: center; text-align: center;',
                    messageOutputCont = '<div style="' + textCss + '">' + addedToFormTable + '</div>',
                    notFoundCamera = 'Камера на компьютере не обнаружена / Нет доступа к камере',
                    notFoundCameraCss = 'padding-top: 100px; justify-content: center; text-align: center;',
                    notFoundCameraCont = '<div style="' + notFoundCameraCss + '">' + notFoundCamera + '</div>',
                    barcodeContCls = '#barcode-container';

                Ext.create('Ext.window.Window',
                    {
                        title: 'Сканер штрих-кода',
                        bodyPadding: 5,
                        width: 800,
                        height: 550,
                        fullscreen: true,
                        autoShow: true,
                        layout: 'anchor',
                        html: '<div id="dynamicContent"></div>',
                        defaults: {
                            anchor: '100%'
                        },
                        defaultType: 'textfield',
                        items: [
                            {
                                xtype: 'fieldcontainer',
                                fieldLabel: 'Тип кода',
                                defaultType: 'radiofield',
                                layout: 'hbox',
                                items: [
                                    {
                                        boxLabel: 'QR код',
                                        name: 'codetype',
                                        inputValue: 'qr',
                                        id: 'qrtype',
                                        padding: '0 20 0 0',
                                        checked: true
                                    },
                                    {
                                        boxLabel: 'Штрих-код',
                                        name: 'codetype',
                                        inputValue: 'barcode',
                                        id: 'barcodetype'
                                    }
                                ]
                            },
                            {
                                xtype: 'button',
                                text: 'Веб-камера',
                                width: 30,
                                margin: '3 0 3 0',
                                buttonAlign: 'left',
                                listeners: {
                                    click: function startScanner() {
                                        var htmlCont = document.getElementById('dynamicContent');

                                        if (Ext.getCmp('qrtype').checked === true) {
                                            parentView.qrcodeWebcam(htmlCont, messageOutputCont, notFoundCameraCont);
                                        }

                                        else if (Ext.getCmp('barcodetype').checked === true) {
                                            parentView.barcodeWebcam(htmlCont, messageOutputCont, notFoundCameraCont, barcodeContCls);
                                        }
                                    }
                                }
                            },
                            {
                                xtype: 'button',
                                text: 'Остановить',
                                margin: '0 0 5 0',
                                buttonAlign: 'left',
                                id: 'webcam-stop-button'
                            },
                            {
                                xtype: 'filefield',
                                id: 'barcodefilename',
                                name: 'File',
                                fieldLabel: 'Изображение',
                                listeners: {
                                    change: function (fileField) {
                                        var htmlCont = document.getElementById('dynamicContent'),
                                            file = fileField.fileInputEl.dom.files[0];

                                        if (Ext.getCmp('qrtype').checked === true) {
                                            parentView.qrcodeImg(htmlCont, messageOutputCont, file);
                                        }

                                        else if (Ext.getCmp('barcodetype').checked === true) {
                                            parentView.barcodeImg(htmlCont, messageOutputCont, barcodeContCls, file);
                                        }
                                    }
                                }
                            },
                            {
                                fieldLabel: "Код:",
                                id: 'code',
                                allowBlank: false
                            }
                        ]
                    });
            },

            qrcodeWebcam: function (htmlCont, messageOutputCont, notFoundCameraCont) {
                var scannerCss = 'display: block; position: absolute; left:15%; width: 70%; height: 70%; padding: 10px;';
                var qrCss = 'display: flex; padding-top: 5%; justify-content: center; text-align: center;';
                htmlCont.innerHTML = '<video id="webcam-qr-container" style="' + scannerCss + '"></video> <div id="qrcode-container" style="' + qrCss + '" />';

                var videoElem = document.getElementById('webcam-qr-container');
                var qrContainerElem = document.getElementById('qrcode-container');

                QrScanner.WORKER_PATH = 'lib/qr-scanner/qr-scanner-worker.min.js';

                var qrScanner = new QrScanner(videoElem,
                    function (result) {
                        qrContainerElem.innerHTML = '';
                        Ext.getCmp('code').setValue(result);
                        videoElem.style.display = 'none';
                        qrScanner.stop();
                        try {
                            new QRCode(qrContainerElem, result);
                        } catch (e) {
                            Ext.getCmp('code').setValue('Ошибка при генерации QR кода (Возможно, недопустимые символы в тексте)')
                        };
                        Ext.getCmp('barcodeTextValue').setValue(result);
                        htmlCont.insertAdjacentHTML('beforeend', messageOutputCont);
                    },
                    function (error) {
                        videoElem.style.transform = '';
                        Ext.getCmp('code').setValue('QR код не найден.');
                    });

                qrScanner.start().catch(function (error) {
                    htmlCont.innerHTML = notFoundCameraCont;
                });

                var stopWebcam = function (scanner) {
                    if (scanner) {
                        scanner.destroy();
                    }
                }

                var stopButton = Ext.getCmp('webcam-stop-button');
                stopButton.on('click', function () { stopWebcam(qrScanner) });

                setTimeout(stopWebcam, 60000, qrScanner); // таймер на выключение веб-камеры через минуту
            },

            barcodeWebcam: function (htmlCont, messageOutputCont, notFoundCameraCont, barcodeContCls) {
                var scannerCss = 'position: absolute; left:15%; width: 70%; height: 70%; padding: 10px;';
                var barcodeCss = 'display: block; margin-left: auto; margin-right: auto';
                htmlCont.innerHTML = '<div id="scanner-container" style="' + scannerCss + '"></div> <img id="barcode-container" style="' + barcodeCss + '" />';

                var _scannerIsRunning = false;
                var scannerContainerDiv = document.getElementById('scanner-container');
                Quagga.init({
                    inputStream: {
                        name: "Live",
                        type: "LiveStream",
                        target: document.querySelector('#scanner-container'),
                        constraints: {
                            width: 640,
                            height: 480,
                            facingMode: "environment"
                        }
                    },
                    locate:
                        true, //при true будет искать код в любом положении (перевернутом и т.п.)
                    decoder: {
                        readers: [// порядок некоторых важен! (upc > ean, ean_8 > upc_e)
                            "upc_reader", // 12 цифр
                            "ean_reader", // 13 цифр
                            "ean_8_reader", // 9 цифр
                            "upc_e_reader", // 8 цифр
                            "code_128_reader", // 0-9, a-z, A-Z + 128 ASCII
                            "code_39_reader", // 0-9, A-Z, нек. символы
                            "codabar_reader", // цифры, нек. символы, A,B,C,D,E
                            "i2of5_reader" // цифры
                        ]
                    }

                },
                    function (err) {
                        if (err && err.toString() === 'NotAllowedError: Permission denied') {
                            htmlCont.innerHTML = notFoundCameraCont;
                            return console.log(err);
                        } else if (err) {
                            return console.log(err);
                        }

                        Quagga.start();

                        var stopWebcam = function () {
                            Quagga.offDetected();
                            Quagga.stop();
                            scannerContainerDiv.style.display = 'none';
                        }

                        var stopButton = Ext.getCmp('webcam-stop-button');
                        stopButton.on('click', function () { stopWebcam() });

                        setTimeout(stopWebcam, 60000); // таймер на выключение веб-камеры через минуту

                        _scannerIsRunning = true;

                        var videoElem = document.getElementById('scanner-container').getElementsByTagName('video')[0];
                        videoElem.style.width = '100%'; // подгон видео 640x480 под размер контейнера
                        videoElem.style.height = '100%';
                        document.getElementById('barcode-container').style.display = 'none';
                        scannerContainerDiv.style.display = 'block';
                    });

                Quagga.onDetected(function (result) {
                    Quagga.stop();
                    scannerContainerDiv.style.display = 'none';
                    var resultCode = result.codeResult.code;

                    if (result.codeResult === undefined) {
                        htmlCont.innerHTML = '';
                        Ext.getCmp('code').setValue('Код не распознан');
                        Quagga.offDetected();
                        return;
                    }

                    if (!isValidBarcode(result.codeResult)) {
                        Ext.getCmp('code').setValue('Код распознан неверно');
                        console.log(resultCode);
                        Quagga.offDetected();
                        return;
                    }

                    Ext.getCmp('code').setValue(resultCode);

                    try {
                        document.getElementById('barcode-container').style.display = 'block';
                        switch (result.codeResult.format) {
                            case "ean_13":
                                JsBarcode(barcodeContCls, resultCode, { format: "ean13" });
                                break;
                            case "ean_8":
                                JsBarcode(barcodeContCls, resultCode, { format: "ean8" });
                                break;
                            case "upc_a":
                                JsBarcode(barcodeContCls, resultCode, { format: "upc" });
                                break;
                            case "upc_e":
                                JsBarcode(barcodeContCls, resultCode, { format: "upce" });
                                break;
                            case "codabar":
                                var codeValue = resultCode.replace(/\D/g, '');
                                JsBarcode(barcodeContCls, codeValue, { format: "codabar" });
                                break;
                            case "code_128":
                                JsBarcode(barcodeContCls, resultCode, { format: "code128" });
                                break;
                            case "code_39":
                                JsBarcode(barcodeContCls, resultCode, { format: "code39" });
                                break;
                            case "i2of5":
                                JsBarcode(barcodeContCls, resultCode, { format: "itf" });
                                break;
                            default:
                                document.getElementById('barcode-container').style.display = 'none';
                                Ext.getCmp('code').setValue('Неподходящий формат кода');
                                break;
                        }
                    } catch (e) {
                        if (e.error === undefined) console.log(resultCode);
                        else console.log(e.error);
                    }
                    Ext.getCmp('barcodeTextValue').setValue(resultCode);
                    htmlCont.insertAdjacentHTML('beforeend', messageOutputCont);

                    // Убирает обработчики с onDetected (без него будут копии функции)
                    Quagga.offDetected();
                });

                if (_scannerIsRunning) {
                    _scannerIsRunning = false;
                    Quagga.stop();
                }
                scannerContainerDiv.style.display = 'none';
            },

            qrcodeImg: function (htmlCont, messageOutputCont, file) {
                var qrCss = 'display: flex; padding-top: 5%; justify-content: center; text-align: center;';
                htmlCont.innerHTML = '<div id="qrcode-container" style="' + qrCss + '" />';

                if (file === undefined || !(file instanceof File)) return;

                QrScanner.WORKER_PATH = 'lib/qr-scanner/qr-scanner-worker.min.js';

                QrScanner.scanImage(file)
                    .then(function (result) {
                        Ext.getCmp('code').setValue(result);
                        new QRCode(document.getElementById('qrcode-container'), result);
                        Ext.getCmp('barcodeTextValue').setValue(result);
                        htmlCont.insertAdjacentHTML('beforeend', messageOutputCont);
                    })
                    .catch(function (error) { Ext.getCmp('code').setValue('QR код не найден.') });
            },

            barcodeImg: function (htmlCont, messageOutputCont, barcodeContCls, file) {
                var reader;

                if (file === undefined || !(file instanceof File)) return;

                reader = new FileReader();
                reader.onloadend = function (event) {
                    var binaryString = '',
                        bytes = new Uint8Array(event.target.result),
                        length = bytes.byteLength,
                        i,
                        base64String;

                    // Конвертация в двоичную строку
                    for (i = 0; i < length; i++) {
                        binaryString += String.fromCharCode(bytes[i]);
                    }

                    // Конвертация в base64
                    base64String = btoa(binaryString);

                    Quagga.decodeSingle({
                        decoder: {
                            readers: [// порядок некоторых важен! (upc > ean, ean_8 > upc_e)
                                "upc_reader", // 12 цифр
                                "ean_reader", // 13 цифр
                                "ean_8_reader", // 9 цифр
                                "upc_e_reader", // 8 цифр
                                "code_128_reader", // 0-9, a-z, A-Z + 128 ASCII
                                "code_39_reader", // 0-9, A-Z, нек. символы
                                "codabar_reader", // цифры, нек. символы, A,B,C,D,E
                                "i2of5_reader" // цифры
                            ]
                        },
                        locator: {
                            patchSize: "medium", // x-small, small, medium, large, x-large
                            halfSample: false
                        },
                        locate:
                            false, //при true будет искать код в любом положении (перевернутом и т.п.), но обнаружение значительно хуже
                        inputStream: {
                            size: 1920 // 320 640 800 1280 1600 1920 (px)
                        },
                        src: 'data:image/jpg;base64,' +
                            base64String //'/lib/quagga/gs1128.jpg' or 'data:image/jpg;base64,'
                    },
                        function (result) {
                            if (result.codeResult === undefined) {
                                htmlCont.innerHTML = '';
                                Ext.getCmp('code').setValue("Код не распознан");
                                return;
                            }

                            var resultCode = result.codeResult.code;
                            var barcodeCss = 'display: block; margin-left: auto; margin-right: auto';
                            htmlCont.innerHTML = '<img id="barcode-container" style="' + barcodeCss + '" />';

                            if (!isValidBarcode(result.codeResult)) {
                                Ext.getCmp('code').setValue("Код распознан неверно");
                                document.getElementById("barcode-container").style.display = 'none';
                                return;
                            }

                            Ext.getCmp('code').setValue(resultCode);

                            try {
                                document.getElementById("barcode-container").style.display = 'block';
                                switch (result.codeResult.format) {
                                    case "ean_13":
                                        JsBarcode(barcodeContCls, resultCode, { format: "ean13" });
                                        break;
                                    case "ean_8":
                                        JsBarcode(barcodeContCls, resultCode, { format: "ean8" });
                                        break;
                                    case "upc_a":
                                        JsBarcode(barcodeContCls, resultCode, { format: "upc" });
                                        break;
                                    case "upc_e":
                                        JsBarcode(barcodeContCls, resultCode, { format: "upce" });
                                        break;
                                    case "codabar":
                                        var codeValue = resultCode.replace(/\D/g, '');
                                        JsBarcode(barcodeContCls, codeValue, { format: "codabar" });
                                        break;
                                    case "code_128":
                                        JsBarcode(barcodeContCls, resultCode, { format: "code128" });
                                        break;
                                    case "code_39":
                                        JsBarcode(barcodeContCls, resultCode, { format: "code39" });
                                        break;
                                    case "i2of5":
                                        JsBarcode(barcodeContCls, resultCode, { format: "itf" });
                                        break;
                                    default:
                                        document.getElementById("barcode-container").style.display = 'none';
                                        Ext.getCmp('code').setValue("Неподходящий формат кода");
                                        break;
                                }
                            } catch (e) {
                                if (e.error === undefined) {
                                    console.log(resultCode);
                                } else {
                                    console.log(e.error);
                                }
                            }
                            Ext.getCmp('barcodeTextValue').setValue(resultCode);
                            htmlCont.insertAdjacentHTML('beforeend', messageOutputCont);
                        });
                };
                reader.readAsArrayBuffer(file);
            }
        });
})();