﻿ReportTableAnalysisView = KS.extend(BaseDictionaryView, {});
var vc = ReportTableAnalysisView.prototype;

// ============= TOOLBAR =======================
(function (viewClass) {
    var sc = ReportTableAnalysisView.superclass;

    KS.apply(viewClass,
    {
        onInit: function () {
            if (this.data.isAnalysisSuccess) {
                KS.alert("Контроль выполнен успешно", "Внимание")
            }
            sc.onInit.apply(this, arguments);
        },

        comboSelected: function (combo, record) {
            var view = combo.parentView;
            view.serverCall({
                method: 'OnComboChanged',
                params: [combo.itemId, KS.Grid.getAnyCase(record, "DATA_VALUE") || 0],
                success: function() {
                    view.reload();
                }
            });
        },

        resetView: function () {
            this.reloadBaseTree();
        },

        openUniDict: function() {
            this.parentView.serverCall({
                method: 'OpenUniDict',
                params: [4, this.code],
                waitMessage: 'Обработка ...'
            });
        },

        getTbarClickHandler: function (tbarNode) {
            switch (tbarNode.code) {
                case 'PRINT_MENU':
                case 'PRINT':
                case 'EXCEL':
                    return this.printExcel;

                case 'EXPAND_ALL':
                    return this.expandAllRows;

                case 'COLLAPSE_ALL':
                    return this.collapseAllRows;

                case 'SHOW_ALL_ROWS':
                    return this.showAllRows;

                case 'HIDE_EMPTY_ROWS':
                    return this.hideEmptyRows;
                    
                case 'SIDEWALL':
                    return null;
            }
            return sc.getTbarClickHandler.apply(this, arguments);
        },

        printExcel: function () {
            var view = this.parentView || this,
                code = (this.tbarNode) ? this.tbarNode.code : null;
            view.serverCall({
                method: 'PrintExcel',
                params: [code || null]
            });
        },

        onValuesSelected: function (args) {
            if (Ext.isEmpty(args) || Ext.isEmpty(args[0])) return;
            var owner = args[0][0]['OWNER'];
            for (var field in args[0][0]) {
                if (owner && field === 'CODE') {
                    var code = args[0][0][field],
                        editor = this[owner];
                    editor.getComponent('textField').setValue(code);
                }
            }
            sc.onValuesSelected.apply(this, arguments);
        }
    });
}(vc));

// ============= TREE =======================
(function (viewClass) {
    KS.apply(viewClass, {
        
        reloadBaseTree: function(){
            this.baseTree.getRootNode().removeAll(true);
            this.baseTree.getStore().clearFilter()
            this.baseTree.fullReload();
        },
        
        beforeTreeRender: function(tree) {
            var imageColumn = tree.getColumns()[0];
            if (this.data.hasExpandRows)
                imageColumn.setWidth(95);
            else 
                imageColumn.hide();
                
            var treeView = tree.getView();
            treeView.getRowClass = this.treeGetRowClass;
        },

        treeGetRowClass: function(record) {
            var highlight = KS.Grid.getAnyCase(record, 'HIGHLIGHT');
            if (highlight && highlight !== '-1') {
                var selector = "link-setting-" + highlight;
                KS.registerCssStyles([{
                    Properties: {
                        "background-color" : convertToHexString(highlight)
                    },
                    Selector: "." + selector
                }]);
                return selector;
            }
            var linkSettings = KS.Grid.getAnyCase(record, 'link_setting');
            if (linkSettings) {
                return "link-setting-" + linkSettings;
            }
            return "";
        },

        openReportHyperLink: function(treeId, colKey, nodeId){
            var gridContext = {
                activeColumn: colKey,
                checkedCodes: [nodeId],
                activeCode: nodeId
            };
            this.serverCall({
                method: 'OpenReportHyperLink',
                params: [colKey, gridContext],
                waitMessage: 'Обработка ...'
            });
        },

        beforeNodeExpand: function(node){
            if (node.id == 'root' || node.data.wasExpanded || this.data.allDataLoaded) return;
            this.serverCall({
                method: 'LoadNodeLevel',
                params: [node.id, node.data.depth - 1],
                waitMessage: 'Детализация ...',
                success: function(){
                    node.data.wasExpanded = true;
                }
            });
        },

        collapseAllRows: function(){
            var view = this.parentView || this;
            view.baseTree.collapseAll();
        },

        expandAllRows: function(){
            var view = this.parentView || this;
            if (view.data.allDataLoaded){
                view.baseTree.expandAll();
            } else {
                KS.confirm("Загрузить все данные?" , "Внимание", function (btn) {
                    if (btn === 'yes')
                        view.serverCall({
                            method: 'ExpandAllRows',
                            waitMessage: 'Загрузка данных...'
                        });
                });
            }
        },

        showAllRows: function(){
            var view = this.parentView || this;
            view.setRowsFilter([]);
        },

        hideEmptyRows: function(){
            var view = this.parentView || this;
            view.serverCall({
                method: 'GetEmptyRows',
                waitMessage: 'Загрузка данных...',
                success: function(rowsId){
                    view.setRowsFilter(rowsId);
                }
            });
        },

        setRowsFilter: function(rowsId){
            var emptyRowsFilter = new Ext.util.Filter({
                id: 'emptyRowsFilter',
                property: 'id',
                value: rowsId,
                operator: 'notin'
            });

            var treeStore = this.baseTree.getStore();
            if (Ext.isEmpty(rowsId))
                treeStore.removeFilter('emptyRowsFilter');
            else
                treeStore.addFilter(emptyRowsFilter);
        },

        onServerSetAllDataLoaded: function(allDataLoaded, expandAll){
            this.data.allDataLoaded = allDataLoaded;
            if (expandAll)
                this.reloadBaseTree();
        }
    });
}(vc));

function analysisHyperLinkRenderer(value, metadata, node, rowIndex, colIndex, store) {
    var tree = store.ownerTree,
        treeId = tree.ctrlId || '',
        colDesc = metadata.column,
        view = tree.parentView;
    return '<a href="' + rowIndex + '_' + colDesc.dataIndex + '" class="like-hypertext" ' +
        'onclick="KS.getView(' + "'" + view.viewID + "'" + ').openReportHyperLink('+ "'" + treeId + "','" + colDesc.dataIndex + "','" + node.id + "'" +
        ');return false;"/>' + value + '</a>';
}

if (typeof(Sys) !== 'undefined') Sys.Application.notifyScriptLoaded();