﻿// ============= VIEW =======================
ReportNavigationView = KS.extend(BaseSvodView, {
    customName: 'ReportNavigationView'
});

// ============= BASE =======================
(function (viewClass) {
    KS.apply(viewClass, {
        onTemplateRendered: function () {
            var view = this;

            var additionalName = 'ReportTaskList';
            switch (this.data.reportNavigationMode){
                case 1:
                    additionalName = 'Statistics';
                    break;
                case 5:
                    additionalName = 'EArchive';
                    break;
                case 7:
                    additionalName = 'ReportCache';
                    break;
            }
            view.customNameExt = 'ReportNavigationView_' + additionalName;

            this.scrollToActiveNode(this.budgetTree);
            if (KS.isObject(this.budgetTree.selection)) {
                this.budgetTree.selection.set("text", '<b>' + this.budgetTree.selection.get("text") + '</b>');
            }
            setTimeout(function() { view.afterTemplateRendered(); }, 0);

            this.correctCheckAllYearPeriod();
            this.correctPeriodPanelSize();
            
            this.containerPanel.on('activate', this.viewActivated, this);
        },

        viewActivated: function(){
            if (this.data.reportNavigationMode == 0 && this.isTaskListOpen()) {
                this.activateTaskList();
            } else if (this.data.reportNavigationMode == 1 && this.isStatisticsViewOpen()) {
                this.activateStatisticsView();
            } else if (this.data.reportNavigationMode == 5 && this.isEArchiveViewOpen()) {
                this.activateEArchiveView();
            } else if (this.data.reportNavigationMode == 7 && this.isReportCacheViewOpen()) {
                this.activateReportCacheView();
            }
        },

        afterTemplateRendered: function() {
            this.budgetTree.setRootHidden(this.data.viewState.FilterOrgOff);
            this.groupTree.setRootHidden(this.data.viewState.FilterGroupsOff);
            this.setBudgetToolbarVisitility();
            this.setGroupToolbarVisibility();

            if (!this.data.isTaskListOpen)
                this.showTaskList();
            this.initialized = true;
        },

        saveSettings: function () {
            this.collectFormValues();
            this.serverCall({
                method: 'SaveSettings',
                params: [this.data.viewState],
                disableFog: true
            });
        },

        getFilters: function() {
            if (!this.rendered())
                return null;
            this.collectFormValues();
            var viewState = Ext.clone(this.data.viewState);
            if (this.getAllPeriods()){
                viewState.Periods = [];
            }
            return viewState;
        },

        rendered: function () {
            return (this.groupTree && this.groupTree.rendered && this.budgetTree && this.budgetTree.rendered);
        },

        touch: function () {
            if (!this.initialized) return;
            this.hasChanges = true;
            if (this.data.autoUpdateReportList) {
                var view = this;
                setTimeout(function() {
                    view.showTaskList();
                }, 0);
            }
        },

        resetView: function(){
            var view = this.parentView || this;
            view.reloadBudgetTree();
            view.reloadGroupTree();
        }
    });
}(ReportNavigationView.prototype));

// ============= PERIODS =======================
(function (viewClass) {
    KS.apply(viewClass, {

        checkAllYearPeriods: function(cb, checked) {
            var periodCompPanel = cb.ownerCt;
            var pComp = periodCompPanel.items.items[2];
            pComp.setAllPeriods(checked);
            this.touch();
        },

        addPeriodComponent: function(btn, event){
            var view = this.parentView || this;
            if (view.periodPanel.items.items.length === view.data.maxPeriodsCount) {
                Ext.create('Ext.menu.Menu', {
                    plain: true,
                    bodyStyle: { backgroundColor: '#F0F0F0' },
                    items :[{
                        xtype: 'label',
                        padding: 3,
                        text: 'Максимум периодов: ' + view.data.maxPeriodsCount,
                    }]
                }).showAt(event.getXY()[0] + 15, event.getXY()[1] + 15);
                return;
            }
            view.serverCall({
                method: 'AddPeriodComponent',
                success: function(params){
                    if (params != null) {
                        if (params["periodComp"] && params["viewState"]) {
                            var periodCompPanel = view.createTemplateControl(params["periodComp"]);
                            view.addPanelItems(params["periodComp"], periodCompPanel);
                            view.periodPanel.add(periodCompPanel);
                            view.setHideForYearOption();
                            view.correctPeriodPanelSize();

                            view.data.viewState = params["viewState"];
                            view.touch();
                        }
                    }
                }
            });
        },

        deletePeriodComponent: function(){
            var view = this.parentView || this;
            if (view.periodPanel.items.items.length === 1) return;

            var periodCompPanel = this.ownerCt;
            var periodNumber = view.periodPanel.items.items.indexOf(periodCompPanel);
            view.serverCall({
                method: 'DeletePeriodComponent',
                params: [periodNumber],
                success: function(viewState){
                    if (viewState) {
                        view.periodPanel.remove(periodCompPanel);
                        view.setHideForYearOption();
                        view.correctPeriodPanelSize();

                        view.data.viewState = viewState;
                        view.touch();
                    }
                }
            });
        },

        setHideForYearOption: function(){
            if (this.periodPanel && this.periodPanel.items.items.length > 0) {
                var hide = this.data.hideCheckForYear || this.periodPanel.items.items.length > 1;
                var periodCompPanel = this.periodPanel.items.items[0];
                if (periodCompPanel.items.items[3]){ // чекбокс 'За год'
                    periodCompPanel.items.items[3].setHidden(hide);
                    periodCompPanel.items.items[3].setRawValue(false);
                }
                if (periodCompPanel.items.items[2]) // сам periodComponent
                    periodCompPanel.items.items[2].setAllPeriods(false);
            }
        },

        correctPeriodPanelSize: function(){
            if (this.periodPanel) {
                var pCompCount = this.periodPanel.items.items.length;
                var pCompHeight = pCompCount > 0 ? this.periodPanel.items.items[0].getHeight() : 0;
                this.periodPanel.setHeight(pCompCount * pCompHeight + 20 + 20); // высота всех периодов + заголовок(20) + место под скрол(20)
            }
        },

        correctCheckAllYearPeriod: function(){
            var periodCompPanel = this.periodPanel.items.items[0];
            var allYearCheck = periodCompPanel.items.items[3].getValue();
            periodCompPanel.items.items[2].setAllPeriods(allYearCheck);
        },

        showAllPeriods: function(btn){
            var view = this.parentView || this;
            Ext.each(view.periodPanel.items.items, function(periodCompPanel){
                periodCompPanel.setDisabled(btn.pressed);
            })
            view.touch();
        },

        getAllPeriods:function() {
            var btn = this.getToolbarItem(this.rootPanel, null, "ALL_PERIODS");
            return btn && btn.pressed;
        }
    });
}(ReportNavigationView.prototype));

// ============= BUDGET TREE =======================
(function (viewClass) {
    KS.apply(viewClass, {
        beforeBudgetChangeSelection: function (sm, newNode) {
            var budgTree = this.budgetTree,
                oldNode = budgTree.getSelNode();

            if (KS.isObject(oldNode)) {
                var textForOldNode = budgTree.getText(oldNode).replace('<b>', '').replace('</b>', '');
                budgTree.setText(oldNode, textForOldNode);
            }

            if (KS.isObject(newNode)) {
                var textForNewNode = '<b>' + budgTree.getText(newNode) + '</b>';
                budgTree.setText(newNode, textForNewNode);
            }
        },

        activateBudgetTreeNode: function (budgetHierarchyLink) {
            var root = this.budgetTree.getRootNode(),
                node = root.findChildBy(function(n) {
                    var id = n.id,
                        bhLink = id.split('_')[0];
                    return bhLink == budgetHierarchyLink;
                });
            if (node) {
                this.budgetTree.setSelected(node.id);
            } else {
                this.reloadBudgetTree(budgetHierarchyLink + '');
            }
        },

        reloadBudgetTree: function (nodeId) {
            var selNodeId = (KS.isString(nodeId) && !KS.isEmpty(nodeId)) ? nodeId : this.budgetTree.getSelNodeId();
            this.collectFormValues();
            var view = this;
            this.serverCall({
                method: 'RebuildBudgetTree',
                waitMessage: 'Загрузка дерева...',
                params: [this.data.viewState.Periods || null, selNodeId],
                success: function (obj) {
                    if (obj.subTree && obj.selNodeId) {
                        if (view.budgetTree.loadSubTreeInRoot(obj.subTree)) {
                            view.budgetTree.setSelected(obj.selNodeId);
                            view.scrollToActiveNode(view.budgetTree);
                        }
                    }
                }
            });
        },

        setBudgetToolbarVisitility: function () {
            var bcBtn = this.getToolbarItem(this.budgetPanel, 'top', 'BUDGET_CHECK'),
                mcBtn = this.getToolbarItem(this.budgetPanel, 'top', 'MARK_CHILDREN'),
                uaBtn = this.getToolbarItem(this.budgetPanel, 'top', 'UNMARK_ALL'),
                iaBtn = this.getToolbarItem(this.budgetPanel, 'top', 'INVERT_ALL');
            if (bcBtn && mcBtn && uaBtn) {
                var show = bcBtn.pressed;
                mcBtn.setVisible(show);
                uaBtn.setVisible(show);
                iaBtn.setVisible(show);
            }
            var filterBtn = this.getToolbarItem(this.budgetPanel, 'top', 'BUDGET_FILTER');
            this.budgetFilterGrid.setVisible(filterBtn.pressed);
            KS.updateLayout(this.budgetPanel);
        },

        budgetFilterChange: function (btn) {
            var view = this.parentView;
            view.data.viewState.FilterOrgOff = btn.pressed;
            view.budgetTree.setDisabled(btn.pressed);
            view.touch();
        },

        budgetCheckboxes: function (btn) {
            var view = this.parentView || this;
            view.serverCall({
                method: 'SetDataProperty',
                params: ['budgetCheck', btn.pressed],
                success: function() {
                    if (!btn.withoutReload)
                        view.reloadBudgetTree()
                }
            });
            view.setBudgetToolbarVisitility();
        },

        addFilterTemplate: function(){
            var view = this.parentView || this;
            view.filterWin = KS.showModal({
                xtype: 'textarea',
                itemId: 'pseArea'
            },{
                layout: 'fit',
                plain: true,
                frame: true,
                autoScroll: true,
                modal: true,
                maximizable: true,
                minWidth: 400,
                minHeight: 300,
                width: Math.max(400, KS.rootViewport.getWidth() / 2),
                height: Math.max(300, KS.rootViewport.getHeight() / 1.5),
                title: 'Введите наименование шаблона',
                buttonAlign: 'right',
                buttons: ['->', {
                    text: 'ОК',
                    cls: 'dim-button',
                    handler: function () {
                        var newValue = view.filterWin.getComponent("pseArea").getValue();
                        view.saveNewFilterTemplate(newValue);
                    }
                }, { xtype: 'tbspacer', width: 8 },
                    {
                        text: 'Отмена',
                        cls: 'dim-button',
                        handler: function() {
                            view.filterWin.close();
                        }
                    }]
            }, true);
        },

        saveNewFilterTemplate: function(newValue){
            var view = this;
            view.filterWin.mask('Сохранение...');
            view.serverCall({
                method: 'SaveNewFilterTemplate',
                params: [newValue],
                success: function(){
                    view.filterWin.close();
                }
            });
        },

        getFilterTemplate: function(){
            var view = this.parentView || this;
            view.serverCall({
                method: 'GetFilterTemplate'
            });
        },

        onServerSetFilterTemplate: function(viewState, periodPanel, activeBudgetNodeId, budgetTreeShowMode, budgetCheck){
            var view = this;
            this.data.viewState = viewState;

            // Периоды
            var periodItems = periodPanel.items;
            if (!Ext.isEmpty(periodItems)) {
                this.periodPanel.removeAll();
                Ext.each(periodItems, function(periodCmp){
                    var periodCompPanel = view.createTemplateControl(periodCmp);
                    view.addPanelItems(periodCmp, periodCompPanel);
                    view.periodPanel.add(periodCompPanel);
                });
            }
            view.correctCheckAllYearPeriod();
            view.correctPeriodPanelSize();

            // Комбо Отображать ... организации
            var budgetTreeShowModeCombo = view.getToolbarItem(view.budgetInsidePanel, 'top', 'budgetTreeShowMode');
            if (budgetTreeShowModeCombo) {
                budgetTreeShowModeCombo.isManualChange = true;
                budgetTreeShowModeCombo.setValue(budgetTreeShowMode.toString());
            }

            // Дерево организаций бюджетов
            var filterOrgOff = view.data.viewState.FilterOrgOff;
            var filterOrgOffBtn = view.getToolbarItem(this.budgetPanel, 'top', 'FILTER_ORG_OFF');
            if (filterOrgOffBtn)
                filterOrgOffBtn.setPressed(filterOrgOff);
            view.budgetTree.setDisabled(filterOrgOff)

            var budgetCheckBtn = view.getToolbarItem(this.budgetPanel, 'top', 'BUDGET_CHECK');
            if (budgetCheckBtn)
                budgetCheckBtn.setPressed(budgetCheck);
            view.budgetCheckboxes({
                pressed : budgetCheck,
                withoutReload : true
            });

            if (filterOrgOff || budgetCheckBtn) {
                view.reloadBudgetTree(activeBudgetNodeId);
            } else {
                view.touch();
            }

            // Дерево форм
            var filterGroupOff = view.data.viewState.FilterGroupsOff;
            var filterGroupOffBtn = view.getToolbarItem(view.groupPanel, 'top', 'FILTER_GROUPS_OFF');
            if (filterGroupOffBtn)
                filterGroupOffBtn.setPressed(filterGroupOff);
            view.groupFilterChange({pressed : filterGroupOff});
        },

        budgetTreeCheckChange: function(node, newValue) {
            var view = this.parentView || this;
            view.serverCall({
                method: 'BudgetTreeCheckChange',
                params: [node.id, newValue],
                success: function(viewState) {
                    view.data.viewState = viewState;
                    view.touch();
                }
            });
        },

        invertAllNode: function() {
            var view = this.parentView;
            view.budgetTree.invertAll();
            view.touch();
        },

        unMarkAll: function() {
            var view = this.parentView;
            view.budgetTree.uncheckAll();
            view.touch();
        },

        markChildren: function () {
            var view = this.parentView,
                bt = view.budgetTree;
            bt[this.fn].call(bt, arguments);
            view.touch();
        },

        budgetNodeMenuClick: function(menuItem) {
            var view = this.parentView,
                bsnId = view.budgetTree.getSelNodeId(),
                opCode = menuItem.tbarNode.code;
            if (!bsnId) return;
            view.serverCall({
                method: 'BudgetNodeMenuClick',
                params: [bsnId, opCode]
            });
        },

        copyBudgetNodePath: function() {
            var view = this.parentView;
            view.copyPathToActiveNode(view.budgetTree);
        },

        budgetSearch: function () {
            this.parentView.setBudgetToolbarVisitility();
        },

        searchBudgetNodes: function() {
            var view = this.parentView || this,
                searchField = view.getToolbarItem(view.budgetFilterGrid, null, "budgetFilterString");
            if (Ext.isEmpty(searchField)) return;
            var search = searchField.getValue();
            if (Ext.isEmpty(search)) return;
            view.serverCall({
                method: 'SearchBudgetNodes',
                params: [search],
                success: view.displayFoundBudgetNodes
            });
        },

        budgetFilterKeyUp: function (f, e) {
            if (e && e.keyCode === 13) {        // 13 - ENTER
                var view = this.parentView || this;
                view.searchBudgetNodes();
            }
        },

        displayFoundBudgetNodes: function(json) {
            var data = KS.safeDecode(json),
                store = this.budgetFilterGrid.getStore();
            store.loadData(data.rows);
        },

        budgetFilterSelect: function(grid, record) {
            this.reloadBudgetTree(record.get('id'));
        },

        budgetNodeLevelLoad: function (node) {
            var da = node.deferredAction;
            if (da) {
                da.tree[da.fn].call(da.tree, da.args);
                delete node.deferredAction;
            }
        },

        budgetTreeShowModeChange: function(combo, newValue) {
            var view = this;
            if (combo.isManualChange){ // Изменение комбика после установки шаблона
                combo.isManualChange = false;
                return;
            }
            view.serverCall({
                method: 'BudgetTreeShowModeChange',
                params: [newValue],
                success: function() {
                    view.reloadBudgetTree();
                    if (view.getToolbarItem(view.budgetPanel, 'top', 'BUDGET_FILTER').pressed)
                        view.searchBudgetNodes();
                }
            });
        },

        expandAllBudgets: function () {
            var view = this.parentView;
            if (view.budgetTree.ctrl.renderAll) {
                view.budgetTree.expandAll();
            } else {
                var selNodeId = view.budgetTree.getSelNodeId();
                view.collectFormValues();
                view.serverCall({
                    method: 'ExpandAllBudgets',
                    waitMessage: 'Загрузка дерева...',
                    params: [view.data.viewState.Periods || null, selNodeId],
                    success: function (obj) {
                        if (obj.subTree && obj.selNodeId) {
                            if (view.budgetTree.loadSubTreeInRoot(obj.subTree)) {
                                view.budgetTree.setSelected(obj.selNodeId);
                                // view.scrollToActiveNode(view.budgetTree);
                                view.budgetTree.ctrl.renderAll = true;
                            }
                        }
                    }
                });
            }
        },

        collapseAllBudgets: function () {
            this.parentView.budgetTree.collapseAll();
        },
    });
}(ReportNavigationView.prototype));

// ============= GROUP TREE =======================
(function (viewClass) {
    KS.apply(viewClass, {
        groupFilterChange: function (btn) {
            var view = this.parentView || this;
            view.data.viewState.FilterGroupsOff = btn.pressed;
            view.groupTree.setDisabled(btn.pressed);
            view.groupPanel.setTitle('Фильтр по группам форм' + (btn.pressed ? ' (выключен)' : ''));

            if (btn.pressed)
                view.groupPanel.collapse();
            else
                view.groupPanel.expand();

            var searchBtn = view.getToolbarItem(view.groupPanel, null, 'GROUP_SEARCH');
            searchBtn.setDisabled(btn.pressed);

            if (!btn.pressed && !view.groupTree.config.ctrl.renderAll) {
                view.renderAllGroupTree(true);
            }

            if (btn.isButton) // делаем touch только если запускаем по нажатию кнопки 
                view.touch();
        },

        renderAllGroupTree: function(shouldRenderAll) {
            var view = this;
            view.serverCall({
                method: 'SetRenderAllGroupTree',
                params: [shouldRenderAll],
                success: view.reloadGroupTree
            });
        },

        checkAllGroups: function () {
            var view = this.parentView,
                gt = view.groupTree,
                store = gt.store;

            if (store.filters.length > 0) {
                Ext.each(store.data.items,
                    function(node) {
                        node.set('checked', true);
                    });
            }
            else gt.checkAll();

            view.touch();
        },

        uncheckAllGroups: function () {
            var view = this.parentView;
            view.groupTree.uncheckAll();
            view.touch();
        },

        expandAllGroups: function () {
            this.parentView.groupTree.expandAll();
        },

        collapseAllGroups: function () {
            this.parentView.groupTree.collapseAll();
        },

        groupTreeCheckChange: function (node, checked, e) {
            var view = this;

            if (node.hasChildNodes()) {
                node.eachChild(function(childNode) {
                    childNode.set('checked', checked);
                });
            }

            view.touch();
        },

        reloadGroupTree: function() {
            if (this.groupTree) {
                this.groupTree.getRootNode().removeAll();
                this.groupTree.fullReload();
            }
        },

        groupSearch: function () {
            this.parentView.setGroupToolbarVisibility();
        },

        setGroupToolbarVisibility: function () {
            var view = this,
                docked = view.groupTree.getDockedItems(),
                searchBtn = view.getToolbarItem(view.groupPanel, null, 'GROUP_SEARCH');

            docked[0].setVisible(searchBtn.pressed);
            KS.updateLayout(this.groupTree);

            if (!searchBtn.pressed) {
                view.clearGroupSearchField();
            }
        },

        searchGroupNodes: function () {
            var view = this.parentView || this;
            view.doSearchByField(view.groupTree, view.groupTree);
        },

        clearGroupSearchField: function() {
            var view = this.parentView || this;
            view.getToolbarItem(view.groupTree, null, 'searchField').setValue('');
            view.searchGroupNodes();
        },

        searchGroupFieldKeyUp: function (f, e) {
            if (e && e.keyCode === 13) {        // 13 - ENTER
                var view = this.parentView || this;
                view.searchGroupNodes();
            }
        }
    });
}(ReportNavigationView.prototype));

// ============= VIEW STATE =======================
(function (viewClass) {
    KS.apply(viewClass, {
        collectFormValues: function () {
            var view = this,
                gt = view.groupTree,
                bt = view.budgetTree,
                viewState = this.data.viewState;

            Ext.each(view.periodPanel.items.items, function (periodCompPanel, periodNumber) {
                var pComp = periodCompPanel.items.items[2];
                if (pComp.rendered && !Ext.isEmpty(viewState.Periods)) {
                    if (viewState.Periods.length > periodNumber) {
                        var period = viewState.Periods[periodNumber],
                            year = pComp.getYear();
                        if (year > 2005 && year < 2079) {
                            period.Year = pComp.getYear();
                        } else {
                            pComp.setYear(period.Year);
                        }
                        period.Year = pComp.getYear();
                        period.Type = pComp.getType();
                        period.Number = pComp.getNumber();

                        var allYearCheck = periodCompPanel.items.items[3];
                        if (allYearCheck)
                            period.AllPeriods = !allYearCheck.getHidden() && allYearCheck.getValue();
                    }
                }
            });

            viewState.TreeLinks = {};
            viewState.TreeLinksForNotification = {};
            viewState.ActiveOrganizationLink = null;
            viewState.ActiveBudgetLink = null;

            var linksArr,
                orgLink,
                budgLink,
                btSelNode = bt.getSelNode();
            if (btSelNode/* && !viewState.FilterOrgOff*/) {
                linksArr = btSelNode.id.split('_');
                if (!viewState.FilterOrgOff) {
                    viewState.TreeLinks[linksArr[1]] = [linksArr[2]];
                    viewState.TreeLinksForNotification[linksArr[1]] = [linksArr[2]];
                }
                viewState.BudgetHierarchyLink = +linksArr[0];
                viewState.ActiveOrganizationLink = +linksArr[1];
                viewState.ActiveBudgetLink = +linksArr[2];
            }
            if (view.getToolbarItem(this.budgetPanel, 'top', 'BUDGET_CHECK').pressed) {
                var checked = bt.getChecked();
                if (!Ext.isEmpty(checked)) {
                    viewState.TreeLinks = {};
                    viewState.TreeLinksForNotification = {};
                }
                Ext.each(checked, function (btNode) {
                    linksArr = btNode.id.split('_');
                    orgLink = linksArr[1];
                    budgLink = linksArr[2];
                    //treeLink = view.viewState.TreeLinks[orgLink]; 
                    if (Ext.isEmpty(viewState.TreeLinks[orgLink]))
                        viewState.TreeLinks[orgLink] = [];
                    if (viewState.TreeLinks[orgLink].indexOf(budgLink) < 0)
                        viewState.TreeLinks[orgLink].push(budgLink);
                    if (btNode.parentNode.id != 'root') {
                        if (Ext.isEmpty(viewState.TreeLinksForNotification[orgLink]))
                            viewState.TreeLinksForNotification[orgLink] = [];
                        if (viewState.TreeLinksForNotification[orgLink].indexOf(budgLink) < 0)
                            viewState.TreeLinksForNotification[orgLink].push(budgLink);
                    }
                });
            }

            if (gt && gt.rendered && view.initialized) {
                viewState.CheckedGroups = [];

                var gtChkNodes = gt.getChecked(),
                    hasChecked = false;
                if (!viewState.FilterGroupsOff && !Ext.isEmpty(gtChkNodes)) {
                    $.each(gtChkNodes, function () {
                        var isGroup = (this.id.substring(0, 1) == 'g'),
                            link = +this.id.substring(1),
                            code = this.data.text.split(' - ')[0].replace('<b>', ''),
                            exists = false;

                        Ext.each(viewState.CheckedGroups, function (group) {
                            if (group.Link == link && isGroup == group.IsGroup) {
                                exists = true;
                            }
                        });

                        if (!exists) {
                            viewState.CheckedGroups.push({
                                Code: code,
                                Link: link,
                                IsGroup: isGroup
                            });
                            hasChecked = true;
                        }
                    });
                    if (!hasChecked) {
                        viewState.FilterGroupsOff = false;
                    }
                }
            }

            viewState.HasChild = (btSelNode) ? !btSelNode.isLeaf() : false;
            viewState.SvodType = !viewState.FilterOrgOff && viewState.BudgetHierarchyLink != 0 && viewState.HasChild ? 0 : -1;
            viewState.Index = 0;
        }
    });
}(ReportNavigationView.prototype));

// ============= TASK LIST =======================
(function (viewClass) {
    KS.apply(viewClass, {
        showTaskList: function () {
            if (this.data.reportNavigationMode == 0 && this.isTaskListOpen()) {
                if (this.hasChanges) {
                    this.activateTaskList();
                    this.refreshTaskList();
                }
            } else if (this.data.reportNavigationMode == 1 && this.isStatisticsViewOpen()) {
                if (this.hasChanges) {
                    this.activateStatisticsView();
                    this.refreshStatisticsView();
                }
            } else if (this.data.reportNavigationMode == 5 && this.isEArchiveViewOpen()) {
                if (this.hasChanges) {
                    this.activateEArchiveView();
                    this.refreshEArchiveView();
                }
            } else if (this.data.reportNavigationMode == 7 && this.isReportCacheViewOpen()) {
                if (this.hasChanges) {
                    this.activateReportCacheView();
                    this.refreshReportCacheView();
                }
            } else {
                this.collectFormValues();
                this.serverCall({
                    method: 'OpenTaskListMethod',
                    params: [this.data.viewState]
                });
            }
        },
        
        refreshTaskListCallBack: function () {
            this.containerPanel.enable();
            if (this.rendered() && this.hasChanges) {
                this.saveSettings();
                this.hasChanges = false;
            }
        }
    });
}(ReportNavigationView.prototype));

if (typeof (Sys) !== 'undefined') { Sys.Application.notifyScriptLoaded(); }