﻿ReportEdsInfoView = KS.extend(BaseDictionaryView, {
    resetView: function () {
        var grid = this.mainGrid;
        setTimeout(function() { grid.select(0); }, 10);
    }
});

// ============= TOOLBAR =======================
(function (viewClass) {
    KS.apply(viewClass, {
        getTbarClickHandler: function (tbarNode) {
            switch (tbarNode.code) {
                case 'EXPORT_EDS':
                    return this.exportEds;

                case 'COMPARE_SAVED_FORMS':
                case 'PRINT_PDF':
                    return this.execTask;
            }
            return ReportEdsInfoView.superclass.getTbarClickHandler.apply(this, arguments);
        },

        exportEds: function () {
            var view = this.parentView,
                grid = view.mainGrid;
            view.serverCall({
                method: 'ExportEds',
                params: [grid.itemId, JSON.stringify(grid.getControlState(null))]
            });
        },

        execTask: function() {
            this.parentView.tryExecuteSvodTask(0, this.tbarNode.code, null);
        },

        loadAndOpenFile: function (rowIndex, colKey) {
            var grid = this.mainGrid,
                record = grid.getStore().getAt(rowIndex),
                activeCode = grid.getAnyCase(record, grid.closeCode);

            var additional = {
                activeColumn: colKey,
                activeCode: activeCode,
                activeRowIndex: rowIndex
            }

            var gridState = JSON.stringify(additional);

            this.serverCall({
                method: 'TryExecuteTask',
                params: [5, colKey, grid.itemId, gridState]
            });
        }
    });
}(ReportEdsInfoView.prototype));

function loadAndOpenFilesRenderer(value, metadata, record, rowIndex, colIndex, store) {
    var view = store.grid.parentView,
        colCfg = store.grid.getColCfgByIndex(colIndex),
        colKey = colCfg.dataIndex;
    return '<span class="like-hypertext" onclick="KS.getView(' + "'" + view.viewID + "'" + ')' +
        '.loadAndOpenFile(' + rowIndex + ",'" + colKey + "'" + ');return false;"/>Открыть</span>';
}

if (typeof(Sys) !== 'undefined') Sys.Application.notifyScriptLoaded();