﻿ReportCalculationsSettingsView = KS.extend(BaseTreeView, {
    onTemplateRendered: function () {
        this.checkEnableMDKSGroupSelect();
    },

    checkEnableMDKSGroupSelect: function(){
        if (Ext.isEmpty(this.mainGrid)) return;
        var checkColumn = this.mainGrid.getColConfigByKey("CHECKED");
        if (checkColumn && checkColumn.tag && checkColumn.tag.disabled){         // Выключаем возможность изменить чеки
            this.mainGrid.getSelectionModel().setLocked(true);
            var visibleColumns = this.mainGrid.getVisibleColumns();
            Ext.each(visibleColumns, function(column){
                if (column.isCheckColumn) {
                    column.setDisabled(true);
                }
            })
        }
    },
    
    baseTreeCellClick: function(grid, td, cellIndex, record) {
        if (record.id === "filter_off") {               //у "Все группы" нету чека
            this.setCheckTreeFilter(true);
        } else {
            record.set("checked", !record.get("checked"));
            this.setCheckTreeFilter();
        }
    },

    baseTreeCheckChange: function(node) {
        node.set("checked", !node.get("checked")); //меняем чек, т.к. baseTreeCellClick тоже срабатывает и меняет его обратно
    },

    setCheckTreeFilter: function(isFilterOff) {
        var ids = [];
        var nodes = this.baseTree.getChecked();
        Ext.each(nodes, function(node) {
            if (node.id) {
                ids.push(node.id);
            }
        });
        if (KS.isEmpty(ids) || isFilterOff) {
            ids.push("filter_off");
        }

        this.saveCheckStatesInGrid();  //При смене правила, сохраняем отмеченные строки

        this.serverCall({
            method: 'SetCheckTreeFilter',
            params: [ids],
            waitMessage: 'Фильтрация ...',
            success: function() {
                this.resetGrid();
            }
        });
    },

    saveCheckStatesInGrid: function() {        // Для "Только отмеченные"
        var linkRules = [];
        Ext.each(this.mainGrid.getCheckedRows(), function(record) {
            linkRules.push(KS.Grid.getAnyCase(record, 'link_rule'));
        });
        this.serverCall({
            method: 'SaveCheckStatesInGrid',
            params: [linkRules],
            disableFog: true
        });
    }
});

if (typeof (Sys) !== 'undefined') { Sys.Application.notifyScriptLoaded(); }