﻿NotCreatedReportsShowView = KS.extend(BaseDictionaryView, {
    getTbarClickHandler: function(tbarItem) {
        if (tbarItem.code == 'CREATE_ALL_REPORTS') {
            return this.createAllReports;
        }
        return NotCreatedReportsShowView.superclass.getTbarClickHandler.call(this, tbarItem);
    },

    createAllReports: function () {
        var view = this.parentView,
            rows = view.mainGrid.getCheckedCodes();
        view.serverCall({
            method: 'CreateAllReports',
            params: [rows]
        });
    },

    urlClick: function(closeCode, linkDatabase) {
        this.serverCall({
            method: 'UrlClick',
            params: [closeCode, linkDatabase]
        });
    }
});

function notCreatedUrlRenderer(value, metadata, record, rowIndex, colIndex, store) {
    return '<span class="like-hypertext" onclick="KS.getView(' + "'" + store.grid.parentView.viewID + "'" + ').urlClick(' + store.grid.getCloseCode(store.getAt(rowIndex)) + ',' + (KS.Grid.getAnyCase(record, "LINK_DATABASE") || 0) + ');return false;"/>' + value + '</span>';
}

if (typeof(Sys) !== 'undefined') Sys.Application.notifyScriptLoaded();