﻿// ============= VIEW =======================
NewsView2 = KS.extend(BaseSvodView, {});
var vc = NewsView2.prototype;

// ============= COMMON =======================
(function(viewClass) {
    function getGridCheckcolumnParams() {
        return {
            editor: new Ext.form.Checkbox({}),
            renderer: function(value) {
                return '<div class = "x-grid3-check-col' + (value ? '-on' : '') + '"></div>';
            }
        };
    }

    function lookupReference(el, target) {
        return el[target];
    }

    KS.apply(viewClass,
    {
        onTemplateRendered: function () {
            this.htmlPanel.update(this.resolveViewId(this.data.html));
            var elements = document.getElementsByClassName('LENTA_msg_edit'),
                messages = document.getElementsByClassName('LENTA_msg_data'),
                idx;

            for (idx = 0; idx < elements.length; idx++) {
                elements[idx].onclick = this.onEditClick;
                elements[idx].parent = this;
                elements[idx].message = messages[idx].outerText;
            }

            elements = document.getElementsByClassName('LENTA_msg_del');
            for (idx = 0; idx < elements.length; idx++) {
                elements[idx].onclick = this.onDelClick;
                elements[idx].parent = this;
            }

            elements = document.getElementsByClassName('LENTA_msg_zoom');
            for (idx = 0; idx < elements.length; idx++) {
                elements[idx].onclick = this.onZoomClick;
                elements[idx].parent = this;
                elements[idx].message = messages[idx].outerText;
            }

            elements = document.getElementsByClassName('LENTA_msg_export');
            for (idx = 0; idx < elements.length; idx++) {
                elements[idx].onclick = this.onExportClick;
                elements[idx].parent = this;
            }

            elements = document.getElementById('LENTA_button_add_message');
            elements.onclick = this.addNew;
            elements.parent = this;

            elements = document.getElementById('LENTA_button_user_filter');
            elements.onclick = this.onFilterClick;
            elements.parent = this;

            elements = document.getElementById('LENTA_button_user_edit');
            elements.onclick = this.onUserEditClick;
            elements.parent = this;

            elements = document.getElementById('LENTA_previous_page');
            elements.onclick = this.onPreviousPageClick;
            elements.parent = this;

            elements = document.getElementById('LENTA_next_page');
            elements.onclick = this.onNextPageClick;
            elements.parent = this;
        },

        htmlElementClick: function(pageNum) {
            this.serverCall({
                method: 'HtmlElementClick',
                waitMessage: 'Обработка ...',
                params: [pageNum],
                success: this.reload
            });
        },

        addNew: function() {
            this.parent.openEditor(KS.getFakeLink());
        },

        openEditor: function(postId, value) {
            if (!value) value = '';
            var defaultInnerCfg = {
                    autoScroll: false,
                    title: false
                },
                defaultWinCfg = getDefaultWindowConfig();
            this.editor = new Ext.form.HtmlEditor({
                postId: postId,
                value: value
            });
            KS.apply(defaultInnerCfg, this.editor);
            KS.apply(defaultWinCfg,
            {
                title: 'Текст новости',
                width: Math.max(400, KS.rootViewport.getWidth() / 2),
                tbar: KS.Ext.create('toolbar',
                {
                    defaults: { scope: this },
                    region: 'south',
                    items: new Array({
                        iconCls: 'ks-icon-save',
                        tooltip: 'Сохранить',
                        scope: this,
                        handler: this.saveMessage
                    })
                })
            });
            this.containerPanel.editorContainer = (new Ext.Window(defaultWinCfg)).show();
            this.containerPanel.editorContainer.items.items.push(this.editor);
            KS.updateLayout(this.containerPanel.editorContainer);
            this.containerPanel.editorPanel = this.containerPanel.editorContainer.items.items[0];
        },

        saveMessage: function() {
            var postId = this.editor.postId,
                html = this.containerPanel.editorPanel.getValue();
            if (html.length > 0) {
                this.serverCall({
                    method: 'SaveMessage',
                    params: [postId, html],
                    success: this.reload
                });
                this.containerPanel.editorContainer.hide();
            }
        },

        onEditClick: function(click) {
            var el = click.currentTarget;
            var id = el.id;
            id = (id.substring(('LENTA_msg_edit_').length, id.length));
            id = parseInt(id);
            el.parent.openEditor(id, el.message);
        },

        onDelClick: function(click) {
            var el = click.currentTarget;
            var id = el.id;
            id = (id.substring(('LENTA_msg_del_').length, id.length));
            id = parseInt(id);
            el.parent.deleteMessage(id);
        },

        deleteMessage: function(postId) {
            var view = this;
            Ext.Msg.show({
                title: 'Подтверждение',
                message: 'Вы действительно хотите удалить сообщение?',
                buttons: Ext.Msg.YESNO,
                config: {
                    parent: view,
                    postId: postId
                },
                fn: function(btn, text, opt) {
                    var parent = opt.config.parent;
                    var postId = opt.config.postId;
                    if (btn === 'yes') {
                        parent.serverCall({
                            method: 'DeleteMessage',
                            waitMessage: 'Удаление ...',
                            params: [postId],
                            success: parent.reload
                        });
                    }
                }
            });
        },

        onZoomClick: function(click) {
            var el = click.currentTarget;
            var defaultWinCfg = getDefaultWindowConfig();
            KS.apply(defaultWinCfg,
            {
                title: 'Просмотр',
                width: Math.max(400, KS.rootViewport.getWidth() / 2),
                height: Math.max(300, KS.rootViewport.getHeight() / 2)
            });
            var panel = new Ext.Panel({
                autoScroll: true,
                html: el.message
            });
            el.parent.containerPanel.zoomContainer = (new Ext.Window(defaultWinCfg)).show();
            el.parent.containerPanel.zoomContainer.items.items.push(panel);
            KS.updateLayout(el.parent.containerPanel.zoomContainer);
        },

        onExportClick: function(click) {
            var el = click.currentTarget;
            var id = el.id;
            id = (id.substring(('LENTA_msg_export_').length, id.length));
            id = parseInt(id);
            el.parent.exportMessage(id);
        },

        exportMessage: function(postId) {
            this.serverCall({
                method: 'ExportMessage',
                waitMessage: 'Экспорт...',
                params: [postId],
                success: this.exportSuccess
            });
        },

        exportSuccess: function(data) {
            var defaultWinCfg = getDefaultWindowConfig();
            KS.apply(defaultWinCfg,
            {
                title: 'Экспорт',
                width: Math.max(400, KS.rootViewport.getWidth() / 2),
                height: Math.max(300, KS.rootViewport.getHeight() / 2)
            });
            var panel = new Ext.Panel({
                autoScroll: true,
                html: data
            });
            this.containerPanel.exportContainer = (new Ext.Window(defaultWinCfg)).show();
            this.containerPanel.exportContainer.items.items.push(panel);
            KS.updateLayout(this.containerPanel.exportContainer);
        },

        onFilterClick: function(click) {
            var el = click.currentTarget;
            el.parent.serverCall({
                method: 'UserFilter',
                params: [],
                success: el.parent.filterOpen
            });
        },

        filterOpen: function(list) {
            var defaultWinCfg = getDefaultWindowConfig();
            KS.apply(defaultWinCfg,
            {
                title: 'Фильтр',
                width: Math.max(400, KS.rootViewport.getWidth() / 2),
                height: Math.max(300, KS.rootViewport.getHeight() / 2),
                tbar: KS.Ext.create('toolbar',
                {
                    defaults: { scope: this },
                    items: new Array({
                        iconCls: 'ks-icon-save',
                        tooltip: 'Сохранить',
                        scope: this,
                        handler: this.onFilterSave
                    })
                })
            });
            var col = [
                { header: 'М', text: 'М', dataIndex: 'checked', type: 'boolean', width: 30 },
                { header: 'Code', text: 'Code', dataIndex: 'code', type: 'string', hidden: true },
                { header: 'Id', text: 'Id', dataIndex: 'id', type: 'int', hidden: true },
                { header: 'Имя', text: 'Имя', dataIndex: 'name', type: 'string', width: 400 }
            ];
            KS.apply(col[0], getGridCheckcolumnParams());
            var fields = [
                { name: 'checked', type: 'bool' },
                { name: 'code', type: 'string' },
                { name: 'id', type: 'int' },
                { name: 'name', type: 'string' }
            ];
            var grid = new Ext.grid.Panel({
                columns: col,
                store: new Ext.data.ArrayStore({
                    fields: fields
                })
            });
            this.containerPanel.filterContainer = new Ext.Window(defaultWinCfg).show();
            this.containerPanel.filterContainer.add(grid);
            KS.updateLayout(this.containerPanel.filterContainer);
            for (var i = 0; i < list[0].length; i++) {
                var newRec = new (grid.getStore().recordType)({});
                newRec.data.checked = list[0][i].checked;
                newRec.data.code = list[0][i].code;
                newRec.data.id = list[0][i].id;
                newRec.data.name = list[0][i].name;
                grid.getStore().add(newRec);
            }
        },

        onFilterSave: function() {
            var items = this.containerPanel.filterContainer.items.items[0].store.data.items,
                list = [];
            for (var i = 0; i < items.length; i++) {
                if (items[i].data.checked) list.push(items[i].data.id);
            }
            this.containerPanel.filterContainer.hide();
            this.serverCall({
                method: 'SaveUserFilter',
                params: [list],
                success: this.reload
            });
        },

        onUserEditClick: function(click) {
            var el = click.currentTarget;
            el.parent.serverCall({
                method: 'UserEdit',
                params: [],
                success: el.parent.userEditGetName
            });
        },

        userEditGetName: function(name) {
            this.userName = name;
            this.serverCall({
                method: 'UserEditGetImage',
                params: [],
                success: this.userEditOpen
            });
        },

        userEditOpen: function(data) {
            var name = this.userName;
            this.Image = data;
            var defaultWinCfg = getDefaultWindowConfig();
            KS.apply(defaultWinCfg,
            {
                title: 'Редактирование пользователя',
                width: 400,
                height: 250,
                tbar: KS.Ext.create('toolbar',
                {
                    defaults: { scope: this },
                    items: new Array(this.fp = new Ext.FormPanel({
                        fileUpload: true,
                        width: 300,
                        hideLabels: true,
                        autoHeight: true,
                        layout: 'hbox',
                        bodyStyle: 'padding: 2px 2px 0px 2px;',
                        defaults: {
                            flex: 1,
                            allowBlank: false,
                            msgTarget: 'side'
                        },
                        referenceHolder: true,
                        items: [
                            {
                                xtype: 'fileuploadfield',
                                emptyText: 'Выберите файл',
                                buttonText: '',
                                ref: 'upload',
                                reference: 'upload',
                                //multiple: true,
                                buttonCfg: {
                                    iconCls: 'ks-icon-open'
                                },
                                buttonConfig: {
                                    iconCls: 'ks-icon-open'
                                }
                            }
                        ]
                    }),
                    {
                        iconCls: 'ks-icon-save',
                        tooltip: 'Сохранить',
                        scope: this,
                        handler: this.userEditSave
                    },
                    {
                        iconCls: 'ks-icon-delete',
                        tooltip: 'Удалить изображение',
                        scope: this,
                        handler: this.userImageDel
                    })
                })
            });
            lookupReference(this.fp, 'upload').on('change', this.doUpload, this);
            var panel = new Ext.Panel({
                title: 'Имя',
                referenceHolder: true,
                height: 400,
                items: [
                    {
                        xtype: 'textfield',
                        value: name,
                        reference: 'userName',
                        ref: 'userName'
                    }, new Ext.Panel({
                        title: 'Изображение',
                        html: '<img src="' + data + '">',
                        reference: 'userImage',
                        ref: 'userImage'
                    })
                ]
            });
            this.containerPanel.userContainer = (new Ext.Window(defaultWinCfg)).show();
            this.containerPanel.userContainer.userPanel = panel;
            this.containerPanel.userContainer.items.items.push(panel);
            KS.updateLayout(this.containerPanel.userContainer);
        },

        userImageDel: function() {
            this.serverCall({
                method: 'ImageDel',
                params: [],
                success: this.afterImageDel
            });
        },

        afterImageDel: function(data) {
            lookupReference(this.containerPanel.userContainer
                    .userPanel,
                    'userImage')
                .body.dom.innerHTML = '<img src="' + data + '">';
        },

        doUpload: function() {
            var view = this;
            var form = view.fp.getForm();
            KS.updateLayout(this.containerPanel.userContainer.userPanel);
            if (form.isValid()) {
                form.submit({
                    url: 'PlatformHandler.axd?upload=1&important=1',
                    method: 'POST',
                    fileUpload: true,
                    waitMsg: 'Загрузка файла на сервер ...',
                    success: function() {
                    },
                    failure: function(fp, o) { // fuck ext
                        view.uploadCallback(o.result);
                    }
                });
            }
        },

        uploadCallback: function(fileKeys) {
            var view = this;
            var value = lookupReference(view.fp, 'upload').value;
            view.serverCall({
                method: 'SaveImage',
                params: [fileKeys, value],
                waitMessage: 'Анализ ...',
                success: view.setData
            });
        },

        setData: function(data) {
            lookupReference(this.containerPanel.userContainer
                    .userPanel,
                    'userImage')
                .body.dom.innerHTML = '<img src="' + data + '">';
        },

        userEditSave: function() {
            var data = lookupReference(this.containerPanel.userContainer.userPanel, 'userName').getValue();
            this.serverCall({
                method: 'SaveUserEdit',
                params: [data],
                success: this.reload
            });
            this.containerPanel.userContainer.hide();
        },

        onPreviousPageClick: function(click) {
            var el = click.currentTarget;
            var page = (document.getElementsByClassName('LENTA_current_page'))[0].id;
            page = (page.substring(('LENTA_page_').length, page.length));
            page = parseInt(page);
            if (page > 1) {
                page--;
                var newPage = 'LENTA_page_' + page;
                el.parent.htmlElementClick(newPage);
            }
        },

        onNextPageClick: function(click) {
            var el = click.currentTarget;
            var pages = document.getElementsByClassName('LENTA_page');
            var pageCount = pages.length + 1;
            var page = (document.getElementsByClassName('LENTA_current_page'))[0].id;
            page = (page.substring(('LENTA_page_').length, page.length));
            page = parseInt(page);
            if (page < pageCount) {
                page++;
                var newPage = 'LENTA_page_' + page;
                el.parent.htmlElementClick(newPage);
            }
        }
    });
}(vc));

function lentaNewsElementClickHandler(e, viewId, elId) {
    try {
        var view = KS.getView(viewId);
        if (view)
            view.htmlElementClick(elId);
    } catch (e) {
        KS.log('Error lenta click ' + elId, 'view');
    } finally {
        var evt = e ? e : window.event;
        if (evt.stopPropagation) evt.stopPropagation();
        if (evt.cancelBubble != null) evt.cancelBubble = true;
        return false;
    }
}

function getDefaultWindowConfig() {
    return {
        layout: 'fit',
        bodyStyle: 'padding:0;',
        modal: true,
        plain: true,
        frame: true,
        minWidth: 400,
        minHeight: 300,
        closeAction: 'hide'
    }
}

if (typeof(Sys) !== 'undefined') Sys.Application.notifyScriptLoaded();