﻿DictionaryRegulationsDateView = KS.extend(BaseDictionaryView, {});

// ============= COMMON =======================
(function(viewClass) {
    KS.apply(viewClass, {
        newHandler: function() {
            var view = this.parentView || this;
            view.serverCall({
                method: 'AddRecord',
                disableFog: true,
                success: function(dataRow) {
                    if (dataRow) {
                        view.mainGrid.addRecord(dataRow);
                        view.touch();
                    }
                }
            });
        },

        copyHandler: function() {
            var view = this.parentView || this;
            var checkedCodes = view.mainGrid.getCheckedCodes();
            if (Ext.isEmpty(checkedCodes)) return;
            view.serverCall({
                method: 'CopyRecord',
                params: [checkedCodes[0]],
                disableFog: true,
                success: function(dataRow) {
                    if (dataRow) {
                        view.mainGrid.addRecord(dataRow);
                        view.touch();
                    }
                }
            });
        },

        beforeCellEdit: function( editor, context) {
            if (context.field === "FORM_LIST" ||
                context.field === "PPP") {
                return false;
            }
        },

        editGridCell: function(plugin, context) {
            var value = context.value;
            var dataIndex = context.field;

            if (value === null || value === context.originalValue) 
                return false;
            
            var view = this;
            var closeCode = KS.Grid.getAnyCase(context.record, this.mainGrid.closeCode);

            view.serverCall({
                method: 'EditCell',
                params: [dataIndex, closeCode, value],
                disableFog: true,
                success: function(success) {
                    if (success) {
                        view.touch();
                    }
                }
            });
            return true;
        },

        formatDateTime: function(dt, format) {
            dt = KS.parseAjaxDateTime(dt);
            return (Ext.isEmpty(dt)) ? null : Ext.util.Format.date(dt, format);
        },

        cellDblClickHandler: function(gridView, td, cellIndex, record, tr, rowIndex, e) {
            var column = e.position.column;
            var dataIndex = column.dataIndex;
            var link = KS.Grid.getAnyCase(record, gridView.grid.closeCode);

            if (dataIndex.toUpperCase() === "PPP") {
                this.serverCall({
                    method: 'OpenDictionary',
                    params: [dataIndex, link]
                });
            }

            if (dataIndex.toUpperCase() === "FORM_LIST") {
                this.openFormListPanel(link);
            }
        },

        openFormListPanel: function(link) {
            var view = this;
            view.serverCall({
                method: 'GetFormListGrid',
                params: [link],
                success: function(grid) {
                    view.showFormListGrid(grid);
                }
            });
        },

        showFormListGrid: function(grid) {
            var view = this;
            view.formListGrid = view.createTemplateControl(grid, "formListGrid");
            view.formListWin = KS.showModal(view.formListGrid, {
                title: 'Справочник форм',
                autoHeight: false,
                resizable: true,
                autoScroll: true,
                maximizable: true,
                width: Math.max(400, KS.rootViewport.getWidth() / 2),
                height: Math.max(300, KS.rootViewport.getHeight() / 1.5),
                minHeight: 300,
                minWidth: 400,
                buttonAlign: 'left',
                buttons: new Array('->', {
                        text: 'ОК',
                        cls: 'dim-button',
                        handler: function () {
                            view.endEditFormRows(false);
                        }
                    }, { xtype: 'tbspacer', width: 8 },
                    {
                        text: 'Отмена',
                        cls: 'dim-button',
                        handler: function() {
                            view.endEditFormRows(true);
                        }
                    })
            }, true);
        },

        endEditFormRows: function(cancel) {
            var view = this;
            view.serverCall({
                method: 'EndEditFormRows',
                params: [cancel],
                success: function(result) {
                    if (result) {
                        view.formListWin.close();
                        view.mainGrid.reload();
                        if (!cancel)
                            view.touch();
                    }
                }
            });
        },

        addForm: function() {
            var view = this.parentView;
            view.serverCall({
                method: 'AddForm'
            });
        },

        deleteForm: function() {
            var view = this.parentView;
            var checkedCodes = view.formListGrid.getCheckedCodes();
            if (!Ext.isEmpty(checkedCodes)) {
                view.serverCall({
                    method: 'DeleteForm',
                    params: [checkedCodes],
                    success: function() {
                        view.formListGrid.reload();
                    }
                });
            }
        },

        copyForm: function() {
            var view = this.parentView;
            var checkedCodes = view.formListGrid.getCheckedCodes();
            if (!Ext.isEmpty(checkedCodes)) {
                view.serverCall({
                    method: 'CopyForm',
                    params: [checkedCodes],
                    success: function() {
                        view.formListGrid.reload();
                    }
                });
            }
        },

        formsGridDblClick: function(gridView, td, cellIndex, record, tr, rowIndex, e) {
            var column = e.position.column;
            var dataIndex = column.dataIndex;

            if (dataIndex.toUpperCase() === "ATTRIBUTES") {
                var view = this;
                var link = KS.Grid.getAnyCase(record, "FORM_ROW_LINK");
                view.serverCall({
                    method: 'GetFormAttrSelectGrid',
                    params: [link],
                    success: function(grid) {
                        view.showFormAttrSelectGrid(grid);
                    }
                });
            }
        },

        showFormAttrSelectGrid: function(grid) {
            var view = this;
            view.formAttrSelectGrid = view.createTemplateControl(grid, "formAttrSelectGrid");
            view.formAttrSelectWin = KS.showModal(view.formAttrSelectGrid, {
                title: 'Справочник атрибутов',
                autoHeight: false,
                resizable: true,
                autoScroll: true,
                maximizable: true,
                width: Math.max(400, KS.rootViewport.getWidth() / 3),
                height: Math.max(300, KS.rootViewport.getHeight() / 1.5),
                minHeight: 300,
                minWidth: 400,
                buttonAlign: 'left',
                buttons: new Array('->', {
                        text: 'ОК',
                        cls: 'dim-button',
                        handler: function () {
                            view.endEditFormAttrSelect();
                        }
                    }, { xtype: 'tbspacer', width: 8 },
                    {
                        text: 'Отмена',
                        cls: 'dim-button',
                        handler: function() {
                            view.cancelEditFormAttrSelect();
                        }
                    })
            }, true);
        },

        endEditFormAttrSelect: function() {
            this.serverCall({
                method: 'EndEditFormAttrSelect',
                success: function() {
                    this.formAttrSelectWin.close();
                    this.formListGrid.reload();
                }
            }); 
        },

        cancelEditFormAttrSelect: function() {
            this.serverCall({
                method: 'CancelEditFormAttrSelect',
                success: function() {
                    this.formAttrSelectWin.close();
                }
            }); 
        },

        formAttrSelectGridDblClick: function(gridView, td, cellIndex, record, tr, rowIndex, e) {
            var column = e.position.column;
            var dataIndex = column.dataIndex;

            if (dataIndex === "VALUE" &&
                !Ext.isEmpty(KS.Grid.getAnyCase(record, "LINK_DICTION")) &&
                !Ext.isEmpty(KS.Grid.getAnyCase(record, "DICTION_COL_ORDER"))) {

                var formRowLink = KS.Grid.getAnyCase(record, "form_row_link");
                var linkAttribute = KS.Grid.getAnyCase(record, "link_attribute");

                this.serverCall({
                    method: 'EditDictAttr',
                    params: [formRowLink, linkAttribute]
                }); 

                return false;
            }

            return true;
        },

        formAttrSelectCellEdit: function(plugin, context) {
            var value = context.value;
            var dataIndex = context.field;

            if (value === null || value === context.originalValue) 
                return false;

            var formRowLink = KS.Grid.getAnyCase(context.record, "form_row_link");
            var linkAttribute = KS.Grid.getAnyCase(context.record, "link_attribute");

            this.serverCall({
                method: 'FormAttrSelectCellEdit',
                params: [dataIndex, formRowLink, linkAttribute, value],
                disableFog: true
            });

            return true;
        }
    });
}(DictionaryRegulationsDateView.prototype));

function formAttrSelectRenderer(value, metadata, record) {
    setTooltip(metadata, value);
    if (!Ext.isEmpty(KS.Grid.getAnyCase(record, "LINK_DICTION")) &&
        !Ext.isEmpty(KS.Grid.getAnyCase(record, "DICTION_COL_ORDER"))) {
        metadata.css += ' sidewall-dict-cell';
    }
    return value;
}

if (typeof (Sys) !== 'undefined') { Sys.Application.notifyScriptLoaded(); }