﻿DictOrgReqView = KS.extend(BaseDictionaryView,
    {
         newHandler: function() {
            var view = this.parentView;
            view.getRegEditPanel(true, null);
        },
        
        editHandler: function() {
            var view = this.parentView;
            var ccc = view.mainGrid.getCheckedCodes();
            if (Ext.isEmpty(ccc)) return;
            if (ccc[0]) {
                view.getRegEditPanel(false, ccc[0]);
            }
        },

        getRegEditPanel: function(isNew, regId) {
            var view = this;
            view.serverCall({
                method: 'GetRegEditPanel',
                waitMessage: 'Открывается ...',
                params: [isNew, regId],
                success: function(panel) {
                    view.showCreateNewPost(panel, isNew, regId);
                }
            });
        },

         onServerTryEditReg: function (panel, regId) {
             this.showCreateNewPost(panel, false, regId);
         },

        showCreateNewPost: function (panel, isNew, regId) {
            if (Ext.isEmpty(panel)) return;
            this.regPanel = this.createTemplateControl(panel, "regPanel");
            this.addPanelItems(panel, this.regPanel);
            var view = this;
            this.editableRegId = regId;
            this.regPanelWin = KS.showModal(this.regPanel, {
                title: 'Редактирование реквизита организации',
                autoHeight: false,
                resizable: false,
                maximizable: false,
                layout: "anchor",
                height: 350,
                minHeight: 200,
                width: 600,
                minWidth: 300,
                buttonAlign: 'left',
                buttons: ['->', {
                        text: 'ОК',
                        cls: 'dim-button',
                        handler: function () {
                            view.doEditReg(isNew, regId);
                        }
                    }, { xtype: 'tbspacer', width: 8 },
                    {
                        text: 'Отмена',
                        cls: 'dim-button',
                        handler: function () {
                            view.rejectRegChanges(isNew, regId);
                        }
                    }]
            }, true);
        },

        doEditReg: function (isEdit, regId) {
            var newValues = this.collectRegEditValue();
            var view = this;
            this.serverCall({
                method: 'DoEditReg',
                waitMessage: 'Сохранение ...',
                params: [newValues, isEdit, regId],
                success: function (result) {
                    if (result) {
                        view.regPanelWin.close();
                        view.resetGrid();
                    }
                }
            });
        },

        rejectRegChanges: function (isNew, regId) {
            this.regPanelWin.close();
            this.serverCall({
                method: 'RejectRegChanges',
                params: [isNew, regId],
                disableFog: true
            });
        },

        collectRegEditValue: function () {
            return {
                "CODE": this.regCode.getValue(),
                "NAME": this.regName.getValue(),
                "REG_TYPE": this.reqType.getValue().reqType,
                "LINK_DICTION": this.regDictName.textField.linkDiction, // UniDictName.Tag
                "DICTION_COL_ORDER": this.regDictColName.textField.dictionColOrder // UniDictCol.Tag
            }
        },

         openDictionary: function () {
             var view = this.parentView;
             var regId = view.editableRegId;
             var relationId = this.ownerCt.textField.relationId;
             view.serverCall({
                 method: 'OpenDictionary',
                 params: [relationId, regId]
             });
        },

         onValuesSelected: function (arg) {
             var values = arg[0][0];
             switch (values["CLOSE_CODE"]) {
             case "LINK_DICTION":
                 this.regDictName.setValue(values["NAME"]);
                 this.regDictName.textField.linkDiction = values["LINK_DICTION"];

                 this.regDictColName.setValue("");
                 this.regDictColName.textField.dictionColOrder = null;
                     break;

             case "LINK_DICTION_ROW":
                 this.regDictColName.setValue(values["ACTIVE_CELL_NAME"]);
                     this.regDictColName.textField.dictionColOrder = values["DICTION_COL_ORDER"];
                 break;
             }
         },

        reqTypeChange: function(comp, newValue){
            this.reqDictInfo.setDisabled(newValue.reqType === 0);
        }
    });

if (typeof (Sys) !== 'undefined') Sys.Application.notifyScriptLoaded();