﻿CalculateAddrBookView = KS.extend(BaseDictionaryView, {
    onTemplateRendered: function() {
        this.discardChanges(); // задизейблить кнопку сохранения
    },

    beforeEditHandler: function (editor, context) {
        var grid = context.grid,
            cfg = grid.getColConfigByKey(context.field);
        if (cfg && cfg.renderer === dictRenderer) {
            this.serverCall({
                method: 'OpenDictionary',
                params: [grid.getCloseCode(context.record), context.field]
            });
            return false;
        }
        return true;
    },

    cellEdit: function (editor, context) {
        if (context.originalValue === context.value ||
            context.column.dataIndex === "CHECKED") 
            return;
        this.serverCall({
            method: 'SaveCellValue',
            params: [context.grid.getCloseCode(context.record), context.field, context.value],
            disableFog: true,
            success: this.touch,
            error: function () {
                context.record.reject();
            }
        });
    },

    newHandler: function () {
        var view = this.parentView || this;
        view.serverCall({
            method: 'AddRow',
            disableFog: true,
            success: view.createGridRow
        });
    },

    copyHandler: function () {
        var view = this.parentView || this;
        var ccc = view.mainGrid.getCheckedCodes(true);
        if (Ext.isEmpty(ccc)) return;        
        view.serverCall({
            method: 'CopyRow',
            params: [ccc[0]],
            waitMessage: 'Копирование...',
            success: view.createGridRow
        });
    },

    createGridRow: function(dict) {
        if (KS.isEmpty(dict)) return;
        this.mainGrid.store.insert(0, dict);
        this.mainGrid.select(0);
        this.touch();
    }
});

(function() {
    KS.apply(KS.Ext.Grid.prototype,
        {
            findRowByCode: function(closeCode) {
                return this.findRowByField(this.closeCode.toLowerCase(),closeCode); //Должно быть в renderer, но lowerCase
            }
        });
})();

if (typeof(Sys) !== 'undefined') Sys.Application.notifyScriptLoaded();