﻿// ReSharper disable FunctionsUsedBeforeDeclared
// KS
(function() {
    // virtual/abstract implement 
    KS.apply(KS,
        {
            isHttps: function() {
                return document.location.protocol === 'https:' || !KS.usebase64;
            },
            
            showHtmlProtocol: function(html, title) {
                if (Ext.isEmpty(html)) html = KS.L10n.protocol + KS.L10n.empty;
                return KS.Ext.showAdjustableWindow(html, Ext.isString(title) ? title : KS.L10n.protocol);
            },

            showModal: function() {
                return KS.Ext.showAdjustableWindow.apply(this, arguments);
            },

            create: function() {
                return KS.Ext.create.apply(this, arguments);
            },

            isChrome: function() {
                return Ext.isChrome;
            },

            isGecko: function() {
                return Ext.isGecko;
            },

            updateLayout: function(c) {
                if (c && Ext.isFunction(c.updateLayout)) c.updateLayout();
            },

            safeDecode: function(json, useNativeDecode) {
                try {
                    if (useNativeDecode !== false) return Ext.decode(json);

                    var defaultUseNativeJson = Ext.USE_NATIVE_JSON;
                    Ext.USE_NATIVE_JSON = false;
                    var decodeValue = Ext.decode(json);
                    Ext.USE_NATIVE_JSON = defaultUseNativeJson;
                    return decodeValue;
                } catch (e) {
                    return null;
                }
            },

            isEmpty: function(s) {
                return Ext.isEmpty(s);
            },

            isObject: function(v) {
                return Ext.isObject(v);
            },

            isString: function(v) {
                return Ext.isString(v);
            },

            isFunction: function(v) {
                return Ext.isFunction(v);
            },

            // Конвертация цвета от сервера (например "0033FF) "в RGB([255, 255, 255, 100])
            // Последняя цифра в массиве - alpha(прозрачность)
            hexToRgb: function(hex, alpha) {
                if (KS.isEmpty(hex)) return null;
                var shorthandRegex = /^#?([a-f\d])([a-f\d])([a-f\d])$/i;
                hex = hex.replace(shorthandRegex,
                    function(m, r, g, b) {
                        return r + r + g + g + b + b;
                    });

                var result = /^#?([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})$/i.exec(hex);
                return result
                    // ФОРМАТ RGB
                    ? //[parseInt(result[1], 16), parseInt(result[2], 16), parseInt(result[3], 16), alpha || 100]
                    // ФОРМАТ BGR
                    [parseInt(result[3], 16), parseInt(result[2], 16), parseInt(result[1], 16), alpha || 1]
                    : null;
            }
        });

    // Viewport tools
    KS.apply(KS,
        {
            renderRootViewport: function(activeTab) {
                KS.rootViewport = Ext.create('Ext.tab.Panel',
                    {
                        region: 'center',
                        //ui: 'navigator-ks',
                        defaults: { textAlign: 'left' },
                        enableTabScroll: true,
                        resizeTabs: true,
                        //minTabWidth: 150,
                        deferredRender: false,
                        activeTab: 0
                    });
            },

            processDialogPanel: function(panelId) { // dialogViewport - simple array by id UpdatePanel
                var u = document.getElementById(panelId + '_u'),
                    isEmpty = !u || $.string(u.value).empty(),
                    panel = KS.dialogViewport[panelId];

                if (panel) {
                    if (isEmpty) {
                        if (Ext.isFunction(panel.destroy))
                            panel.destroy();

                        if (panelId in KS.dialogViewport)
                            delete KS.dialogViewport[panelId];
                    }
                } else {
                    if (!isEmpty) {
                        var newPanel = eval(document.getElementById(panelId + '_s').value);
                        newPanel.updatePanel = panelId;
                        KS.dialogViewport[panelId] = newPanel;
                        newPanel.show();
                    }
                }
            },

            renderDialogs: function() {
                var keys = [];
                for (var key in KS.dialogViewport)
                    keys.push(key);
                keys.sort(function(key1, key2) {
                    var a = KS.intval(KS.dialogViewport[key1].order);
                    var b = KS.intval(KS.dialogViewport[key2].order);
                    if (a < b) return -1;
                    if (a > b) return 1;
                    return 0;
                });
                for (var n = 0; n < keys.length; n++)
                    KS.dialogViewport[keys[n]].show();
            },

            // tabViewport - TabPanel
            processTabPanel: function(panelId) {
                var u = document.getElementById(panelId + '_u');
                var isEmpty = !u || $.string(u.value).empty();
                var found = false;
                var panel;

                Ext.each(KS.tabViewport.items?.items,
                    function(item) {
                        panel = item;
                        if (!KS.isValid(panel)) return true;
                        if (panel.updatePanel == panelId) {
                            found = true;
                            if (isEmpty) {
                                KS.tabViewport.remove(panel, true);
                                KS.log('Removing view ' + panelId, 'view');
                                // Activate last tab if present
                                var n = KS.tabViewport.items.length;
                                if (n > 0)
                                    KS.tabViewport.setActiveTab(KS.tabViewport.items.items[n - 1]);
                            }
                            return false;
                        }
                    });

                //if (KS.tabViewport.items) {
                //    for (var index = 0; index < KS.tabViewport.items.length; index++) {
                //        panel = KS.tabViewport.items.get(index);
                //        if (!KS.isValid(panel)) continue;
                //        if (panel.updatePanel == panelId) {
                //            found = true;
                //            if (isEmpty) {
                //                KS.tabViewport.remove(panel, true);
                //                KS.log('Removing view ' + panelId, 'view');
                //                // Activate last tab if present
                //                var n = KS.tabViewport.items.length;
                //                if (n > 0)
                //                    KS.tabViewport.setActiveTab(KS.tabViewport.items.items[n - 1]);
                //            }
                //            break;
                //        }
                //    }
                //}

                if (!found && !isEmpty) {
                    panel = eval(document.getElementById(panelId + '_s').value);
                    panel.updatePanel = panelId;
                    KS.log('Adding view ' + panelId, 'view');
                    
                    if (panel.externalId) {
                        KS.processExternalPanel(panel);
                        return;
                    }

                    var added = false;
                    if (panel.parentViewID != null) {
                        var p = KS.getView(panel.parentViewID);
                        if (typeof (p.addChildView) === 'function')
                            added = p.addChildView.apply(p, [panel]);
                    }
                    if (!added && KS.tabViewport.items) {
                        KS.tabViewport.insert(KS.tabViewport.items.indexOf(KS.tabViewport.activeTab) + 1, panel);
                        //KS.tabViewport.doLayout(false, true);
                        KS.tabViewport.setActiveTab(panel);
                    }
                    else if (!KS.tabViewport.items) 
                        KS.updPanelStack.push(panelId);
                }

                if (KS.outcast && KS.tabViewport.items) {
                    KS.tabViewport.getTabBar().hide();
                }
            },

            processExternalPanel: function(panel) {
                if (KS.getView(panel.parentViewID)[panel.externalId]) {
                    KS.getView(panel.parentViewID)[panel.externalId].add(panel);
                } else {
                    KS.getView(panel.parentViewID).tpl.controls[panel.externalId].json.items = panel;
                }
            },

            // groupViewport - Panel
            processGroupPanel: function(panelId) {
                var u = document.getElementById(panelId + '_u'),
                    isEmpty = !u || $.string(u.value).empty(),
                    panel;

                if (KS.groupViewport.items) {
                    for (var index = 0; index < KS.groupViewport.items.length; index++) {
                        panel = KS.groupViewport.items.get(index);
                        if (!KS.isValid(panel)) continue;
                        if (panel.updatePanel == panelId) {
                            if (isEmpty) {
                                var f = function(p) {
                                    KS.groupViewport.remove(p, true);
                                    // expand previous panel
                                    var l = KS.groupViewport.items.length;
                                    if (l > 0) KS.groupViewport.items.get(l - 1).expand(true);
                                };
                                var collapsed = panel.collapsed;
                                // because of animation, event becomes async, func will be called after panel.collapse()
                                panel.on('collapse',
                                    function(pane) {
                                        pane.un('collapse', arguments.callee, pane);
                                        f(pane);
                                    });
                                panel.hide(); // need to be hidden, for correct elements shift during updateLayout
                                panel.collapse(true); // true - must collapse, for correct refresh before update
                                KS.log('Removing view ' + panelId, 'view');
                                //KS.groupViewport.doLayout(false, true);
                                // if panel was collapsed, event not raise
                                if (collapsed) f(panel);
                            }
                            return;
                        }
                    }
                }

                if (!isEmpty) {
                    panel = eval(document.getElementById(panelId + '_s').value);
                    panel.updatePanel = panelId;
                    KS.log('Adding view ' + panelId, 'view');
                    KS.groupViewport.add(panel);
                    panel.expand(false);
                    if (panel.notActivateOnOpen !== true) {
                        KS.groupViewport.setActiveTab(panel);
                    }
                }
            }
        });

    // Messages, error handling
    KS.apply(KS,
        {
            pageSizeLabel: KS.L10n.pageSize,
            _statusTO: null,
            statusLog: [],

            setStatus: function(text, ttl) {
                if (!KS.bbarStatus) return;
                if (!ttl) ttl = 15000;
                var id = KS.getNextID();
                KS.bbarStatus.msgID = id;

                // write to log
                var e = {
                    id: id,
                    stamp: new Date(),
                    text: text
                };
                KS.statusLog.push(e);

                KS.bbarStatus.setText(text);

                if (KS._statusTO != null) clearTimeout(KS._statusTO);
                KS._statusTO = setTimeout(function() {
                        // if status already contains other message, leave it
                        if (KS.bbarStatus.msgID == id)
                            KS.bbarStatus.setText('');
                    },
                    ttl);
            },

            confirm: function(msg, title, handler, buttons, buttonText) {
                KS.stopWaitingAll();

                if (typeof (handler) !== 'function')
                    return confirm(msg);
                
                var cfg = {
                    title: (!!title ? title : KS.L10n.msg),
                    msg: msg,
                    icon: Ext.Msg.QUESTION,
                    fn: handler
                };

                if (KS.Ext.styles && KS.Ext.styles.window) {
                    cfg.ui = KS.Ext.styles.window.ui;
                }

                if (Ext.isObject(buttons) && Ext.isObject(buttonText)) {
                    // ChooseBox confirmation
                    cfg.buttons = buttons;
                    cfg.buttonText = buttonText;
                } else {
                    cfg.buttons = Ext.Msg.YESNO;
                    
                }

                Ext.Msg.show(cfg);
                return 'no';
            },

            prompt: function(msg, title, defaultValue, handler) {
                var d = Ext.create('Ext.window.Window',
                    {
                        modal: true,
                         
                        frame: true,
                        plain: true,
                        shadow: false,
                        closable: true,
                        maximizable: false,
                        resizable: false,
                        title: (KS.isValid(title) ? title : KS.L10n.request),
                        width: 450,
                        height: 150,
                        layout: 'absolute',
                        items: new Array({
                                xtype: 'label',
                                width: 410,
                                height: 32,
                                x: 10,
                                y: 10,
                                text: msg
                            },
                            {
                                xtype: 'textfield',
                                width: 410,
                                x: 10,
                                y: 45,
                                itemId: 'promptValue',
                                value: (KS.isValid(defaultValue) ? defaultValue : '')
                            }),
                        buttons: [
                            {
                                text: 'OK',
                                handler: function() {
                                    var pv = d.getComponent('promptValue').getValue();
                                    d.close();
                                    if (handler) handler(pv);
                                }
                            }, {
                                text: KS.L10n.cancel,
                                handler: function() {
                                    d.close();
                                    if (handler) handler(null);
                                }
                            }
                        ]
                    }).show();
                return null;
            },

            msg: function(msg, title, time) {
                Ext.toast({
                    html: msg,
                    title: title, //|| KS.appName,
                    closable: true,
                    align: 'br',
                    autoCloseDelay: Ext.isNumber(time) ? time : 5000,
                    minWidth: 150,
                    cls: 'ks-msg-toast',
                    ...KS.msgToastAdditionalConfig
                });
                KS.setStatus(msg);
            },

            _desktopMsg: function(msg, title, time) {
                KS.statusLog.push(msg);
                var popup = window.webkitNotifications.createNotification(KS.infoImage, title, msg);
                popup.show();

                time = time ? time : 15000;
                setTimeout(popup.cancel, time);
            },

            templog: null,
            log: function(msg, level) {
                if (typeof (DebugOutput) === 'undefined')
                    return;

                if (level === 'sql' && window.SqlProfilerOutput && !KS.isEmpty(msg)) {
                    var content = (window.SqlProfilerOutput.getValue() || '');
                    content += msg.replace(/-->>>[^\n]*/g, '').replace(/\r/g, '').replace(/\n+/g, '\n');
                    window.SqlProfilerOutput.setValue(content);
                    return;
                }

                if (typeof (level) !== 'undefined') {
                    if (jQuery.inArray(level, KS.logLevels) < 0) return;
                } else
                    level = 'global';

                setTimeout(function() {
                        msg = KS.formatLogMessage(msg, level);
                        if (KS.isValidProp(window, 'console')) window.console.log(msg);
                        if (DebugOutput.rendered) {
                            if (KS.templog != null) {
                                for (var n = 0; n < KS.templog.length; n++)
                                    DebugOutput.el.dom.value += KS.templog[n];
                                KS.templog = null;
                            }
                            if (KS.isEmpty(KS._debugOutputContent)) KS._debugOutputContent = [];
                            KS._debugOutputContent.push([level, msg]);
                            var content = '';
                            for (var idx = 0; idx < KS._debugOutputContent.length; idx++) {
                                var fullMsg = KS._debugOutputContent[idx][1];
                                if (fullMsg.indexOf('<font') < 0) {
                                    var color = 'black';
                                    switch (KS._debugOutputContent[idx][0]) {
                                    case 'view':
                                        color = 'black';
                                        break;
                                    case 'ajax':
                                        color = 'gray';
                                        break;
                                    }
                                    fullMsg = '<font color="' + color + '">' + fullMsg + '</font>';
                                }
                                content += fullMsg;
                            }
                            DebugOutput.update(content);
                            var d = DebugOutput.body.dom;
                            d.scrollTop = d.scrollHeight - d.offsetHeight;
                        } else {
                            if (KS.templog == null) KS.templog = [];
                            KS.templog.push(msg);
                        }
                    },
                    0);
            },

            msgBox: function(msg, title, handler, details, icon, report) {
                var h = !details,
                    copyBtn,
                    d = Ext.create('Ext.Window',
                        {
                            modal: true,
                            frame: true,
                            plain: true,
                            shadow: false,
                            closable: true,
                            maximizable: true,
                            resizable: true,
                            title: title,
                            width: 450,
                            layout: 'fit',
                            referenceHolder: true,
                            defaultButtonTarget: 'el',
                            defaultButton: 'ok',
                            items: new Array({
                                layout: 'absolute',
                                frame: false,
                                items: new Array({
                                        xtype: 'image',
                                        x: 10,
                                        y: 10,
                                        width: 32,
                                        height: 32,
                                        src: icon
                                    },
                                    {
                                        x: 52,
                                        y: 10,
                                        //height: 52,
                                        anchor: '-10',
                                        border: false,
                                        padding: '0 0 15 0',
                                        html: '<span title="' + msg + '">' + msg + '</span>'
                                    },
                                    {
                                        x: 10,
                                        y: 72,
                                        xtype: 'fieldset',
                                        anchor: '100% 100%',
                                        title: KS.L10n.details,
                                        collapsible: true,
                                        collapsed: true,
                                        hidden: h,
                                        items: new Array({
                                            xtype: 'textarea',
                                            hideLabel: true,
                                            readOnly: true,
                                            autoScroll: true,
                                            height: 150,
                                            anchor: '100% 100%',
                                            border: false,

                                            style: {
                                                'font-family': 'helvetica,tahoma,verdana,sans-serif',
                                                'font-size': '11px'
                                            },
                                            value: details
                                        }),
                                        listeners: {
                                            expand: function() {
                                                copyBtn.show();
                                                d.updateLayout();
                                            },
                                            collapse: function() {
                                                copyBtn.hide();
                                                d.updateLayout();
                                            }
                                        }
                                    })
                            }),
                            listeners: {
                                'close': function() {
                                    if (!!handler) handler();
                                }
                            },
                            dockedItems: new Array({
                                xtype: 'toolbar',
                                dock: 'bottom',
                                ui: 'footer',
                                items: new Array({
                                        text: KS.L10n.sendToDev,
                                        hidden: !KS.issueTracking || !report,
                                        handler: function() {
                                            d.close();
                                            KS.issuePrompt(details);
                                        }
                                    },
                                    '->',
                                    copyBtn = Ext.create('Ext.Button',
                                        {
                                            text: KS.L10n.copy,
                                            hidden: h,
                                            handler: function() {
                                                KS.copyToClipBoard(details);
                                            }
                                        }),
                                    {
                                        text: 'OK',
                                        reference: 'ok',
                                        handler: function() {
                                            d.close();
                                        }
                                    })
                            })
                        }).show();
            },

            showStatistics: function() {
                var d = KS.L10n.indicators + ': ' +
                    KS.getCookie('Stat', null) +
                    '\r\n' +
                    KS.L10n.qualityLabel + ': ' +
                    KS.Stat.currentQualityValue +
                    '\r\n' +
                    KS.L10n.statusLabel + ': ' +
                    KS.Stat.currentQuality;
                KS.alert(KS.L10n.connectionQualityReport, KS.L10n.connectionQuality, null, d);
            },

            issuePrompt: function(details) {
                var sendButton,
                    d = new Ext.Window({
                        modal: true,
                        frame: true,
                        plain: true,
                        shadow: false,
                        closable: true,
                        maximizable: false,
                        resizable: true,
                        title: KS.L10n.sendToDev,
                        width: 450,
                        height: 320,
                        layout: 'fit',
                        items: new Array({
                            layout: 'absolute',
                            frame: false,
                            itemId: 'innerPanel',
                            items: new Array({
                                    xtype: 'image',
                                    x: 10,
                                    y: 10,
                                    width: 32,
                                    height: 32,
                                    url: KS.questionImage
                                },
                                {
                                    x: 52,
                                    y: 10,
                                    height: 52,
                                    anchor: '-10',
                                    border: false,
                                    html:
                                        KS.L10n.sendToDevDescription
                                },
                                {
                                    x: 10,
                                    y: 72,
                                    xtype: 'textarea',
                                    anchor: '-10 -10',
                                    hideLabel: true,
                                    autoScroll: true,
                                    border: false,
                                    itemId: 'userMessage',
                                    style: {
                                        'font-family': 'helvetica,tahoma,verdana,sans-serif',
                                        'font-size': '14px'
                                    }
                                })
                        }),
                        buttons: new Array(sendButton = Ext.create('Ext.Button',
                                {
                                    text: KS.L10n.send,
                                    handler: function() {
                                        var m = d.getComponent('innerPanel').getComponent('userMessage').getValue();
                                        if ($.string(m).empty()) return;
                                        d.close();
                                        KS.sendIssueReport(m, details);
                                    },
                                    countdown: 20,
                                    hidden: true
                                }),
                            {
                                text: KS.L10n.cancel,
                                handler: function() { d.close(); }
                            }),
                        listeners: {
                            'destroy': function() {
                                if (d.clearTimer) clearInterval(d.clearTimer);
                            }
                        }
                    }).show();

                d.clearTimer = setInterval(function() {
                        var m = d.getComponent('innerPanel').getComponent('userMessage').getValue(),
                            e = !$.string(m).empty();

                        if (sendButton.countdown > 0) {
                            var t = KS.L10n.send;
                            if (--sendButton.countdown > 0) {
                                t += ' (' + sendButton.countdown + ')';
                                e = false;
                            }
                            sendButton.setText(t);
                            sendButton.setVisible(true);
                        }

                        if (e) sendButton.enable();
                        else sendButton.disable();
                    },
                    1000);
            }
        });

    // Waitbox implementation
    KS.apply(KS,
        {
            showWaitBox: function(msg, c) {
                var p = KS.rootViewport;
                if (KS.isValid(p)) {
                    if (!p.rendered) {
                        p.on('render', KS._createWaitBox, KS, msg, c);
                    } else {
                        KS._createWaitBox(msg, c);
                    }
                }
            },

            hideWaitBox: function() {
                var p = KS.rootViewport;
                if (KS.isValid(p) && !!p) p.el.unmask();
            },

            _createWaitBox: function(msg, c) {
                KS.setStatus(msg);

                //msg += '<br/><img src="' + 'ks-icon-loading3' + '"/><br/>';
                if (!!c) msg += '<a class="cancel_link" onclick="return false;" href="">Отменить</a>';

                var p = KS.rootViewport;
                p.getEl().mask(msg).focus();
                p.un('render', KS._createWaitBox, KS);
                /*
                        var mm = Ext.Element.data(p.el.dom, 'maskMsg');
                        if (mm && typeof(c) === 'function') {
                            mm = mm.child('.cancel_link');
                            mm.on('click', c);
                        }*/
            },

            documentReady: function() {
                if (typeof (KS.journalIcon) !== 'undefined') {
                    KS.bbarStatusTip = new Ext.ToolTip({
                        title: '<b>'+ KS.L10n.msgHistory +'</b>',
                        id: 'status-log-tip',
                        target: KS.journalIcon.getEl(),
                        anchor: 'left',
                        width: 415,
                        autoHide: true,
                        closable: true,
                        autoScroll: true,
                        hideDelay: 10000,
                        listeners: {
                            'show': function() {
                                if (Ext.isEmpty(KS.statusLog)) {
                                    this.update(KS.L10n.noHistory);
                                }
                                var log = KS.statusLog.slice(KS.statusLog.length - 10);
                                var html = '<table class="status-log-table">';
                                Ext.each(log,
                                    function(rec) {
                                        html += '<tr class="status-log-row">';
                                        html += '<td class="status-log-date-cell">' +
                                            rec.stamp.toLocaleTimeString() +
                                            '</td>';
                                        html += '<td>' + rec.text + '</td>';
                                        html += '</tr>';
                                    });
                                html += '</table>';
                                this.update(html);
                            }
                        }
                    });
                }

                if (typeof (KS.debugViewport) !== 'undefined') {
                    KS.dbgkeys = [];

                    $(document).keydown(function(e) {
                        if (KS.dbgkeys == null) return;
                        KS.dbgkeys.push(e.keyCode);
                        if (KS.dbgkeys.toString().indexOf('90,79,82,66,65') >= 0) { // zorba
                            KS.dbgkeys = [];
                            if (typeof (KS.debugViewport) !== 'undefined') {
                                KS.debugViewport.setVisible(true);
                                KS.rootViewport.updateLayout();
                                KS.dbgkeys = null;
                            }
                        } else if (KS.dbgkeys.length > 20)
                            KS.dbgkeys = [];
                    });
                }
            },

            getExtStyle: function(ext) {
                if (ext) {
                    var re = /(?:\.([^.]+))?$/,
                        parsedExt = re.exec(ext)[1];

                    switch (parsedExt) {
                    case 'doc':
                    case 'docx':
                    case 'dot':
                    case 'rtf':
                    case 'txt':
                        return 'ks-icon-ext-doc';
                    case 'xls':
                    case 'xlsx':
                    case 'xlt':
                        return 'ks-icon-ext-xls';
                    case 'exe':
                        return 'ks-icon-exe';
                    case 'rar':
                    case '7z':
                    case 'zip':
                        return 'ks-icon-archive';
                    case 'pdf':
                        return 'ks-icon-ext-pdf';
                    default:
                        return 'ks-icon-send_to_arch';
                    }
                } else {
                    return '';
                }
            },

            selectDialogShow: function(title, text, yesFunc, noFunc, parent, callBack) {
                Ext.Msg.show({
                    title: title,
                    msg: text,
                    buttons: Ext.MessageBox.YESNO,
                    animateTarget: parent,
                    fn: function(buttonId) {
                        if (buttonId == 'yes' && yesFunc) yesFunc();
                        if ((buttonId == 'no' || buttonId == 'cancel') && noFunc) noFunc();
                        if (callBack) callBack();
                    },
                    icon: Ext.MessageBox.QUESTION
                });
            }
        });

    // Arrays
    KS.apply(KS,
        {
            //для работы с массивами
            Array: {
                equal: function (a, b) {
                    if (a === b) return true;
                    if (!a || !b) return false;
                    if (a.length != b.length) return false;

                    for (var i = 0; i < a.length; ++i) {
                        var isFind = false;
                        for (var j = 0; j < b.length; j++) {
                            if (a[i] === b[j]) {
                                isFind = true;
                                break;
                            }
                        }
                        if (!isFind) {
                            return false;
                        }
                    }
                    return true;
                },
                rowsEqual: function (a, b) {
                    if (a === b) return true;
                    if (!a || !b) return false;
                    if (a.length != b.length) return false;

                    for (var i = 0; i < a.length; ++i) {
                        var isFind = false;
                        for (var j = 0; j < b.length; j++) {
                            if ((a[i]) && (b[i]) && (a[i].data.LINK === b[j].data.LINK)) {
                                isFind = true;
                                break;
                            }
                        }
                        if (!isFind) {
                            return false;
                        }
                    }
                    return true;
                },
                copy: function (source, lvl, childFields) {
                    var copyItem = function (item, l) {
                        var res = {};
                        for (var k in item) {
                            if (lvl > l)
                                res[k] = copyItem(item[k], l + 1);
                            else res[k] = item[k];
                        }
                        return res;
                    };
                    if (lvl) {
                        var result = [],
                            i = 0,
                            len = source.length;
                        for (; i < len; i++) {
                            result.push(copyItem(source[i], 1));
                            if (childFields && childFields.length) {
                                var cVal = source[i][childFields[0]];
                                for (var j = 1, jLen = childFields.length; j < jLen; j++) {
                                    cVal = cVal[childFields[j]];
                                }
                                if (cVal) {
                                    var cRes = KS.Array.copy(cVal, lvl, childFields);
                                    cVal = result[i];
                                    for (j = 0; j < jLen - 1; j++) {
                                        cVal = cVal[childFields[j]];
                                    }
                                    cVal[childFields[jLen - 1]] = cRes;
                                }
                            }
                        }
                        return result;
                    } else return source.concat ? source.concat() : KsLib.objCopy(source);
                },
                find: function (source, adv, find, i, childFields) {
                    if (!source || (source.length == 0)) return -1;
                    if (i === undefined) i = 0;
                    if (!adv) adv = [];
                    if (i < 0) i += source.length;
                    if (i < 0) i = 0;
                    var val, j, len = adv.length, k, cLen = childFields ? childFields.length : 0, cVal;
                    for (var n = source.length; i < n; i++) {
                        val = source[i];
                        for (j = 0; j < len; j++) {
                            if (val) {
                                val = val[adv[j]];
                            }
                        }
                        if (val == find)
                            return i;
                        if (childFields && cLen) {
                            cVal = source[i][childFields[0]];
                            for (k = 1; k < cLen; k++) {
                                cVal = cVal[childFields[k]];
                            }
                            if (cVal) {
                                var res = KS.Array.find(cVal, adv, find, 0, childFields);
                                if (res != -1) {
                                    if (Ext.isArray(res)) {
                                        res.unshift(i);
                                        return res;
                                    } else {
                                        return [i, res];
                                    }
                                }
                            }
                        }
                    }
                    return -1;
                },
                filter: function (source, sign, find, i) {
                    if (!source.length) return [];
                    if (i === undefined) i = 0;
                    if (!sign) sign = [];
                    if (i < 0) i = 0;
                    var result = [];
                    for (var n = source.length; i < n; i++) {
                        var val = source[i];
                        for (var j = 0, len = sign.length; j < len; j++) {
                            val = val[sign[j]];
                        }
                        if (val == find)
                            result.push(source[i]);
                    }
                    return result;
                },
                diffArrays: function (source, A) {
                    var M = source.length, N = A.length, c = 0, C = [];
                    for (var i = 0; i < M; i++) {
                        var j = 0, k = 0;
                        while (A[j] !== source[i] && j < N) j++;
                        while (C[k] !== source[i] && k < c) k++;
                        if (j == N && k == c) C[c++] = source[i];
                    }
                    return C;
                },
                insert: function (source, index, value) {
                    if ((!index) || (index < 0)) index = 0;
                    if (index > source.length) {
                        source.push(value);
                    } else {
                        source.push(source[source.length - 1]);
                        for (var i = source.length - 2; i > index; i--) {
                            source[i] = source[i - 1];
                        }
                        source[index] = value;
                    }
                },
                remove: function (source, obj) {
                    var pos = Ext.Array.indexOf(source, obj);
                    if (pos !== -1) {
                        source.splice(pos, 1);
                    }
                },

                //удаляет массив объектов из источника
                removeList: function (source, removeList) { Ext.each(removeList, function (obj) { KS.Array.remove(source, obj); }); },

                //копирует поля по ключам из входного объекта в выходной
                copyByKeys: function (keys, inObj, outObj) {
                    Ext.each(keys, function (key) { outObj[key] = inObj[key]; });
                    return outObj;
                },

                //копирует поля по ключам объекты списка
                copyListByKeys: function (keys, inList, outList) {
                    Ext.each(inList, function (obj) { outList.push(KS.Array.copyByKeys(keys, obj, {})); });
                    return outList;
                },

                getLinks: function (source, field, isJson, childFields) {
                    if (!field) field = 'LINK';
                    var res = [];
                    Ext.each(source, function (e) {
                        if (childFields && e[childFields]) res = res.concat(KS.Array.getLinks(e[childFields], field, _, childFields));
                        e = (e.data || e)[field];
                        if (e) res.push(e);
                    });

                    if (isJson) res = JSON.stringify(res);

                    return res;
                },

                runLine: function (line, i, metod, callBack) {
                    if (i >= line.length) {
                        callBack();
                        return;
                    }
                    setTimeout(function () { metod(line[i], function () { KS.Array.runLine(line, i + 1, metod, callBack); }, i); }, 20);
                },

                //Безопастное извлечение свойства по пути
                getByPath: function (source, path, split) {
                    if (Ext.isString(path)) path = path.split(split || '.');
                    var res = source;
                    Ext.each(path, function (p) { return !!(res = res[p]); });
                    return res;
                },

                joinBy: function (source, field, d) {
                    var res = '';
                    d = d || ',';
                    Ext.each(source, function (r) {
                        if (res) res += d;
                        res += r[field];
                    });
                    return res;
                },

                recordIndexOf: function (source, rec, field) {
                    var res = -1;
                    rec = rec.data || rec;
                    field = field || 'LINK';
                    Ext.each(source, function (sRec, i) {
                        var d = sRec.data || sRec;
                        if (d[field] == rec[field]) {
                            res = i;
                            return false;
                        }
                        return true;
                    });
                    return res;
                },

                compareSplitLists: function (list1, list2, equalFn) {
                    var over1 = list1.concat(),
                        over2 = list2.concat(),
                        equal = [];

                    Ext.each(over1, function (r1) {
                        Ext.each(over2, function (r2) {
                            if (equalFn(r1, r2)) {
                                equal.push(r1);
                                KS.Array.remove(over1, r1);
                                KS.Array.remove(over2, r2);
                                return false;
                            }
                            return true;
                        });
                    }, _, true);

                    return { over1: over1, over2: over2, equal: equal };
                }
            }
        });

    //Для всех numberFields регистрируем разделитель разрядов
    Ext.util.Format.thousandSeparator = ' ';
    Ext.util.Format.decimalSeparator = '.';
})();

// KS.Ext
(function() {
    if (KS.isDefined(KS.Ext)) return;

    Ext.define('KS.Ext',
        {
            requires: ['Ext.data.*', 'Ext.tip.*'],
            singleton: true,

            //Стили различающиеся в проектах
            styles: {
                window: {
                    ui: 'default',
                    cls: '',
                },
                button: {
                    ui: 'default',
                    cls: '',
                },
                windowTbar: {
                    ui: 'default',
                    cls: '',
                },
            },

            showAdjustableWindow: function(content, winCfg, forceAuto) {
                var win,
                    items = new Array({
                        scrollable: false,
                        autoScroll: false,
                        title: false
                    }),
                    contentType = 'object',
                    vpWidth = KS.rootViewport.getWidth(),
                    maxHeight = Math.max(300, KS.rootViewport.getHeight() * 0.8),
                    defaultWinCfg = {
                        layout: 'fit',
                        cls: KS.Ext.styles.window.cls,
                        bodyPadding: 5,
                        bodyBorder: true,
                        ui: KS.Ext.styles.window.ui,
                        border: 2,
                        maximizable: true,
                        modal: true,
                        closable: true,
                        plain: true,
                        frame: true,
                        minWidth: 400,
                        minHeight: 300,
                        x: 5000,
                        autoHeight: true,
                        width: Math.max(400, vpWidth / 2)
                    };

                switch (typeof (winCfg)) {
                case 'string':
                    defaultWinCfg.title = winCfg;
                    break;
                case 'object':
                    KS.apply(defaultWinCfg, winCfg);

                    if (winCfg.bbar) {
                        Ext.each(winCfg.bbar,
                            function(el) {
                                if (el.xtype = 'button') {
                                    el.ui = KS.Ext.styles.button.ui;
                                    el.cls = KS.Ext.styles.button.cls;
                                }
                            });
                    }
                    break;
                }

                if (Ext.isArray(content)) {
                    items = content;
                    contentType = 'array';
                } else if (Ext.isObject(content)) {
                    items = content;
                    //KS.apply(items[0], content);
                } else if (Ext.isString(content)) {
                    items[0].html = content;
                } else {
                    contentType = 'none';
                }

                defaultWinCfg.items = items;

                try {
                    win = Ext.create('Ext.window.Window', defaultWinCfg).show();
                } catch (e) {
                    win = Ext.create('Ext.window.Window', defaultWinCfg);
                    win = win.show();
                }

                if ((win.getHeight() > maxHeight && contentType == 'object') && forceAuto !== true) {
                    win.close();
                    KS.apply(items[0] || items,
                        {
                            autoScroll: true,
                            scrollable: true
                        });
                    KS.apply(defaultWinCfg,
                        {
                            autoHeight: false,
                            autoScroll: true,
                            scrollable: true,
                            height: maxHeight,
                            x: undefined,
                            items: items
                        });
                    win = Ext.create('Ext.window.Window', defaultWinCfg).show();
                }
                win.center();
                return win;
            },

            renderModal: function(content, winCfg) {
                return KS.Ext.showAdjustableWindow(content, winCfg);
            },

            formatDateTime: function(dt, format) {
                dt = KS.Ext.parseAjaxDateTime(dt);
                return (Ext.isEmpty(dt)) ? null : Ext.util.Format.date(dt, format);
            },

            formatNumber: function(value, fixed) {
                var retValue = value || '0';
                if (typeof (retValue) != 'string') retValue = retValue.toString();
                var fValue = parseFloat(retValue.replace(',', '.'));
                if (isNaN(fValue) === true) fValue = 0;
                retValue = fValue.toFixed(fixed || 2).replace('.', ',');
                return retValue;
            }
        });
})();

// KS.Ext.ClientView
(function() {
    KS.Ext.ClientView = KS.extend(KS.ClientView,
        {
            viewLayout: {},
            containerPanel: null,

            constructor: function(viewId) {
                KS.Ext.ClientView.superclass.constructor.call(this, viewId);
            },

            init: function(panel) {
                this.containerPanel = panel;
                Ext.Function.defer(KS.Ext.ClientView.superclass.init, 1, this);
                //KS.Ext.ClientView.superclass.init.call(view);
            },

            onStateSave: function(c) {
                this.serverCall({
                    method: 'SetProfileProperty',
                    progressOnly: true,
                    disableFog: true,
                    params: [c.stateId, c.getState()]
                });
            },

            renderToParent: function(panel) {
                this.containerPanel.add(panel);
                this.updateContainer();
            },

            activate: function() {
                var p = this.containerPanel;
                switch (this.frame) {
                case 'tab':
                    KS.tabViewport.setActiveTab(p);
                    break;
                case 'group':
                    KS.groupViewport.getLayout().setActiveItem(p.getItemId());
                    break;
                case 'dialog':
                    var d = Ext.getCmp('id' + this.viewID);
                    if (d) d.show();
                    break;
                }
            },

            isActiveTab: function() {
                return (KS.tabViewport.getActiveTab() && KS.tabViewport.getActiveTab().id == this.containerPanel.id);
            },

            isModal: function() {
                return this.containerPanel && this.containerPanel.modal;
            },

            enable: function() {
                this.containerPanel.enable();
            },

            disable: function() {
                this.containerPanel.disable();
            },

            close: function(callExtCloseEvent) {
                var p = this.containerPanel;
                if (!p || !p.closable) return false;
                return KS.Ext.ClientView.superclass.close.call(this, callExtCloseEvent);
            }
        });

    KS.apply(KS.Ext.ClientView.prototype,
        {
            isModal: function() {
                return this.containerPanel.modal;
            },

            updateContainer: function() {
                KS.updateLayout(this.containerPanel);
            },

            enableContainer: function() {
                try {
                    this.containerPanel.enable();
                } catch (e) {
                }
            },

            disableContainer: function() {
                this.containerPanel.disable();
            },

            findOwnerContainer: function(inst, fn) {
                var depth = 10,
                    ownerCt = inst.ownerCt;
                while (ownerCt && depth > 0) {
                    if (fn.call(this, ownerCt))
                        return ownerCt;
                    ownerCt = ownerCt.ownerCt;
                    depth--;
                }
                return KS.Ext.ClientView.superclass.findOwnerContainer.apply(this, arguments);
            },

            findOwnerGrid: function(inst) {
                return this.findOwnerContainer(inst, this.isGrid);
            },

            getToolbar: function(c, dock) {
                return c ? c.getDockedItems('toolbar[dock="' + (dock || 'top') + '"]')[0] : null;
            },

            getToolbarItem: function(c, dock, code) {
                var tb = this.getToolbar(c, dock);
                if (tb) {
                    var found = tb.items.findBy(function(item) {
                        return (item && item.tbarNode && (item.tbarNode.code === code));
                    });
                    if (!KS.isEmpty(found)) {
                        return found;
                    }
                }
                return null;
            },

            setTbarItemAttributes: function(item, attrs) {
                if (!item || !attrs) return;
                for (var attr in attrs) {
                    switch (attr) {
                    case 'text':
                        item.setText(attrs[attr]);
                        break;
                    case 'tooltip':
                        item.setTooltip(attrs[attr]);
                        break;
                    case 'image':
                        item.setIconCls(attrs[attr]);
                        break;
                    case 'code':
                        item.tbarNode.code = attrs[attr];
                        break;
                    case 'disabled':
                        item.setVisible(!attrs[attr]);
                        break;
                    }
                }
            },

            buildToolbarBtn: function(tbarNode, showText) {
                var item = {
                    tooltip: tbarNode.tooltip || tbarNode.name,
                    disabled: tbarNode.disabled,
                    hidden: tbarNode.hidden,
                    disabledCls: tbarNode.disabledCls,
                    parentView: this,
                    handler: this.getTbarClickHandler(tbarNode),
                    cls: tbarNode.cls
                };

                if (tbarNode.ui) {
                    item.ui = tbarNode.ui;
                }

                KS.apply(item, tbarNode.additional);
                var hasIcon = this.resolveTbarItemImage(item, tbarNode.image);
                if (showText || tbarNode.parentNode || !hasIcon) item.text = tbarNode.name;
                return item;
            },

            processToolbarItemControl: function(ctrl) {
                if (ctrl.split) {
                    ctrl.xtype = 'splitbutton';
                }
                return KS.Ext.ClientView.superclass.processToolbarItemControl.apply(this, arguments);
            },

            resolveTbarItemImage: function(item, img) {
                if (KS.isEmpty(img)) return false;
                var colonIdx = img.indexOf(':');
                if (colonIdx > 0) {
                    item[img.substring(0, colonIdx)] = img.substring(colonIdx + 1); // template-style
                } else {
                    // old style
                    if (jQuery.inArray(img, KS.icons) >= 0) {
                        item.iconCls = 'ks-icon-' + img;
                    } else if (!KS.isEmpty(img)) {
                        item.icon = 'images/' + img + '.png';
                    } else {
                        return false;
                    }
                }
                return true;
            },

            setKeyMap: function(keyMap) {
            }
        });

    // Waitbox implementation
    KS.apply(KS.Ext.ClientView.prototype,
        {
            showWaitBox: function(msg, c) {
                var p = this.containerPanel;
                if (KS.isValid(p) && p != null) {
                    if (!p.rendered)
                        p.on('show', this._createWaitBox, this, msg, c);
                    else
                        this._createWaitBox(msg, c);
                }
            },

            hideWaitBox: function() {
                var p = this.containerPanel;

                if (KS.isValid(p) && p != null && p.rendered) {
                    this.hideProgressBar();
                    var waitBoxTarget = this.waitBoxTarget || p.body;
                    waitBoxTarget.unmask();
                }

                if (KS.isValid(KS.bbarStatus)) KS.bbarStatus.setText('');
            },

            showProgressBar: function() {
                var p = this.containerPanel;
                p && p.ksObjs && p.ksObjs.ksProgressBar && p.ksObjs.ksProgressBar.showProgressBar();
            },

            hideProgressBar: function() {
                var p = this.containerPanel;
                p && p.ksObjs && p.ksObjs.ksProgressBar && p.ksObjs.ksProgressBar.hideProgressBar();
            },
            
            setWaitBoxTarget: function(c) {
                this.waitBoxTarget = c;
            },

            clearWaitBoxTarget: function() {
                delete this.waitBoxTarget;
            },

            _createWaitBox: function(msg, c) {
                KS.setStatus(msg);
                //msg += '<br/><img src="' + KS.loaderImage + '"/><br/>';
                if (!!c) msg += '<br/><a class="cancel_link" onclick="return false;" href="">Отменить</a>';

                var p = this.containerPanel;

                if (KS.isValid(p) && p != null) {
                    if (p.rendered) {
                        this.showProgressBar();
                        var waitBoxTarget = this.waitBoxTarget || p.body;
                        if (waitBoxTarget.dom) {
                            waitBoxTarget.mask(msg);

                            if (c) {
                                var cancelBtn = Ext.Element.select('.cancel_link', waitBoxTarget.dom);
                                cancelBtn.on('click', c);
                            }
                                
                            // var mm = Ext.Element.data(p.body.dom, 'maskMsg');
                            // if (mm && typeof(c) === 'function') {
                            //     mm = mm.child('.cancel_link');
                            //     mm.on('click', c);
                            // }
                        }
                        
                    }
                    p.un('show', this._createWaitBox, this);
                }
            }
        });
})();

// KS.Ajax
(function() {
    KS.apply(KS.Ajax,
        {
            setOnline: function(o) {
                var old = KS.Ajax.isOnline;
                KS.Ajax.isOnline = !!o;

                if (KS.Ajax.isOnline != old) {
                    KS.Ajax.showOnlineStatus();
                    return true;
                }
                return false;
            },

            showOnlineStatus: function(dick) {
                var txt = KS.Ajax.isOnline ? KS.L10n.serverConnectionSet : KS.L10n.serverConnectionLost,
                    icon = null,
                    sign = typeof (KS.signalCtrl) !== 'undefined';

                if (typeof (dick) !== 'undefined') {
                    if (!KS.Ajax.isOnline)
                        return;
                    if (sign) icon = KS.signalIcons[dick];
                } else {
                    if (sign) icon = KS.Ajax.isOnline ? KS.signalIcons[KS.Stat.currentQuality] : KS.signalIcons[0];
                    KS.msg(txt);
                    KS.alert(txt);
                }

                if (sign && icon)
                    KS.signalCtrl.getEl().dom.src = icon;
            },

            pingServer: function() {
                var id;
                if (typeof (KS.pageView) !== 'undefined')
                    id = KS.pageView.id + ',Simplified';
                else if (typeof (WorkspaceView) !== 'undefined')
                    id = WorkspaceView.id + ',Explorer';
                else //if (typeof(OutcastView) !== 'undefined')
                    id = OutcastView.id + ',Explorer';
                id += ',' + KS.desktop;

                var p = new KS.Ajax.Request({
                    data: id,
                    url: KS.pingPath,
                    method: 'PingSession',
                    detectOffline: true,
                    success: function(data) {
                        KS.Ajax.setOnline(true);
                        if (KS.tbarClockPanel)
                            KS.tbarClockPanel.setText(data);
                    },
                    error: function() {
                        KS.Ajax.setOnline(false);
                    }
                });

                $.ajax(p);
            }
        });
})();

// Grid Filters
(function() {

    //на основе AbstractSummary
    Ext.define('Ext.grid.feature.AbstractFilter',
        {
            extend: 'Ext.grid.feature.Feature',
            alias: 'feature.abstractfilter',
            filterRowCls: Ext.baseCSSPrefix + 'grid-row-filter',

            readDataOptions: {
                recordCreator: Ext.identityFn
            },

            filterRowTpl: {
                fn: function (out, values, parent) {
                    if (values.record.isFilter && this.filterFeature.showFilterRow) {
                        this.filterFeature.outputFilterRecord(values.record, values, out, parent);
                    } else {
                        this.nextTpl.applyOut(values, out, parent);
                    }
                },
                priority: 1000
            },

            //cancelEdit: function (editor) {
            //},

            showFilterRow: true,

            init: function () {
                var me = this;

                me.view.filterFeature = me;
                me.rowTpl = me.view.self.prototype.rowTpl;
                me.view.addRowTpl(me.filterRowTpl).filterFeature = me;
                me.groupInfo = {};

                if (!me.filterTableCls) {
                    me.filterTableCls = Ext.baseCSSPrefix + 'grid-item';
                }

                me.filterRowSelector = '.' + me.filterRowCls;
            },

            bindStore: function (grid, store) {
                var me = this;

                Ext.destroy(me.readerListeners);

                if (me.remoteRoot) {
                    me.readerListeners = store.getProxy().getReader().on({
                        scope: me,
                        destroyable: true,
                        rawdata: me.onReaderRawData
                    });
                }
            },

            onReaderRawData: function (data) {
                this.filterRows = null;
                this.readerRawData = data;
            },

            toggleFilterRow: function (visible, fromLockingPartner) {
                var me = this,
                    prev = me.showFilterRow,
                    doRefresh;

                me.showFilterRow = visible = visible != null ? !!visible : !me.showFilterRow;

                if (visible && visible !== prev) {
                    me.updateFilterRow = true;
                }

                if (me.lockingPartner) {
                    if (!fromLockingPartner) {
                        me.lockingPartner.toggleFilterRow(visible, true);
                        doRefresh = true;
                    }
                } else {
                    doRefresh = true;
                }

                if (doRefresh) {
                    me.grid.ownerGrid.getView().refresh();
                }
            },

            outputFilterRecord: function (filterRecord, contextValues, out) {
                var view = contextValues.view,
                    savedRowValues = view.rowValues,
                    columns = contextValues.columns || view.headerCt.getVisibleGridColumns(),
                    colCount = columns.length,
                    i,
                    column,
                    values = {
                        view: view,
                        record: filterRecord,
                        rowStyle: '',
                        rowClasses: [this.filterRowCls],
                        itemClasses: [],
                        recordIndex: -1,
                        rowId: view.getRowId(filterRecord),
                        columns: columns
                    };

                for (i = 0; i < colCount; i++) {
                    column = columns[i];

                    column.savedRenderer = column.renderer;
                    if ((column.headerNoSpan === 'М') ||
                        (column.xtype === 'checkcolumn' && column.cls === 'x-selmodel-column')) {
                        column.renderer = function () {
                            return '<div class="ks-icon-clear_filter"  style="width:9px; height:9px; margin:3px 3px 3px 8px;" align="center" border="0" title="Очистить фильтр"/>';
                        };
                        continue;
                    }

                    column.renderer = this.createRenderer(column, filterRecord);
                }

                view.rowValues = values;
                view.self.prototype.rowTpl.applyOut(values, out, parent);
                view.rowValues = savedRowValues;

                for (i = 0; i < colCount; i++) {
                    column = columns[i];
                    column.renderer = column.savedRenderer;
                    column.savedRenderer = null;
                }
            },

            getRawData: function () {
                var data = this.readerRawData;

                if (data) {
                    return data;
                }

                return this.view.getStore().getProxy().getReader().rawData;
            },

            generateFilterData: function (groupField) {
                var me = this,
                    filterRows = me.filterRows,
                    convertedFilterRow = {},
                    remoteData = {},
                    storeReader,
                    reader,
                    rawData,
                    i,
                    len,
                    rows,
                    row;

                if (!filterRows) {
                    rawData = me.getRawData();

                    if (!rawData) {
                        return;
                    }

                    storeReader = me.view.store.getProxy().getReader();
                    reader = Ext.create('reader.' + storeReader.type, storeReader.getConfig());
                    reader.setRootProperty(me.remoteRoot);
                    filterRows = reader.getRoot(rawData);

                    if (filterRows) {
                        rows = [];

                        if (!Ext.isArray(filterRows)) {
                            filterRows = [filterRows];
                        }

                        len = filterRows.length;

                        for (i = 0; i < len; ++i) {
                            row = reader.extractRecordData(filterRows[i], me.readDataOptions);
                            rows.push(row);
                        }

                        me.filterRows = filterRows = rows;
                    }

                    reader.destroy();
                    me.readerRawData = null;
                }

                if (filterRows) {
                    for (i = 0, len = filterRows.length; i < len; i++) {
                        convertedFilterRow = filterRows[i];

                        if (groupField) {
                            remoteData[convertedFilterRow[groupField]] = convertedFilterRow;
                        }
                    }
                }

                return groupField ? remoteData : convertedFilterRow;
            },

            destroy: function () {
                Ext.destroy(this.readerListeners);
                this.readerRawData = this.filterRows = null;

                this.callParent();
            }
        });

    //на основе Summary (feature) и CellEditing (plugin)
    Ext.define('Ext.grid.feature.Filter',
        {
            extend: 'Ext.grid.feature.AbstractFilter',
            alias: 'feature.filter',
            dock: undefined,
            nullText: KS.L10n.empty,
            notNullText: KS.L10n.notEmpty,

            filterItemCls: Ext.baseCSSPrefix + 'grid-row-summary-item',
            dockedFilterCls: Ext.baseCSSPrefix + 'docked-summary ks-filter-dock',
            panelBodyCls: Ext.baseCSSPrefix + 'summary-',

            hasFeatureEvent: false,

            //значения фильтров по колонкам
            filters: {
                date: ['equals', 'notEquals', 'lessThan', 'lessThanOrEqualTo', 'greaterThan', 'greaterThanOrEqualTo']
            },

            //описания типов фильтров
            filterDesc:
            {
                //числа и даты, по умолчанию equals
                equals: { desc: KS.L10n.equals, iconCls: 'ks-icon-FilterOp_Equals', operator: '=' },
                notEquals: { desc: KS.L10n.notEquals, iconCls: 'ks-icon-FilterOp_NotEquals', opearator: '!=' },
                lessThan: { desc: KS.L10n.lessThan, iconCls: 'ks-icon-FilterOp_LessThan', operator: '<' },
                lessThanOrEqualTo: {
                    desc: KS.L10n.lessThanOrEqualTo,
                    iconCls: 'ks-icon-FilterOp_LessThanOrEqualTo',
                    operator: '<='
                },
                greaterThan: { desc: KS.L10n.greaterThan, iconCls: 'ks-icon-FilterOp_GreaterThan', operator: '>' },
                greaterThanOrEqualTo: {
                    desc: KS.L10n.greaterThanOrEqualTo,
                    iconCls: 'ks-icon-FilterOp_GreaterThanOrEqualTo',
                    operator: '>='
                },

                //строки, по умолчанию like
                like: { desc: KS.L10n.isLike, iconCls: 'ks-icon-FilterOp_Like', operator: 'like' },
                match: { desc: KS.L10n.suitable, iconCls: 'ks-icon-FilterOp_Match' },
                startsWith: { desc: KS.L10n.beginsWith, iconCls: 'ks-icon-FilterOp_StartsWith' },
                contains: { desc: KS.L10n.contains, iconCls: 'ks-icon-FilterOp_Contains', operator: 'like' },
                endsWith: { desc: KS.L10n.endWith, iconCls: 'ks-icon-FilterOp_EndsWith' },
                doesNotStartsWith: { desc: KS.L10n.doesNotStartWith, iconCls: 'ks-icon-FilterOp_DoesNotStartWith' },
                doesNotContains: { desc: KS.L10n.doesNotContain, iconCls: 'ks-icon-FilterOp_DoesNotContain' },
                doesNotEndsWith: { desc: KS.L10n.doesNotEndWith, iconCls: 'ks-icon-FilterOp_DoesNotEndWith' },
                doesNotMatch: { desc: KS.L10n.notMatching, iconCls: 'ks-icon-FilterOp_DoesNotMatch' },
                notLike: { desc: KS.L10n.isNotLike, iconCls: 'ks-icon-FilterOp_NotLike', operator: '/=' },
                is: { hidden: true },
                isNot: { hidden: true },

                valuesFilter: { iconCls: 'ks-icon-FilterOp_Equals', hidden: true }
            },

            //получение меню выбора типа фильтра
            getFilterMenu: function (me, context) {
                if (!me.filterMenu) {
                    var keys = Object.keys(me.filterDesc), items = [];
                    for (var i = 0; i < keys.length; i++) {
                        if (me.local && !me.filterDesc[keys[i]].operator) continue;
                        items.push(
                            {
                                text: me.filterDesc[keys[i]].desc,
                                filterType: keys[i],
                                iconCls: me.filterDesc[keys[i]].iconCls,
                                handler: me.changeFilterType,
                                hidden: me.filterDesc[keys[i]].hidden
                            });
                    }
                    me.filterMenu = new Ext.menu.Menu({
                        items: items,
                        me: me
                    });
                }
                me.filterMenu.ctx = context;

                if (me.grid && me.grid.ctrl.showFilterValueList) {
                    me.createValuesFilterMenu(me, context);
                }

                return me.filterMenu;
            },

            //обработка события изменения типа фильтра
            changeFilterType: function (menuItem) {
                var context = menuItem.container.component.ctx,
                    feature = context.view.filterFeature,
                    column = context.column,
                    dataIndex = column.dataIndex;

                //todo: Не всегда иконка сразу меняется
                if (feature.filters[dataIndex]) {
                    feature.filters[dataIndex].filterType = menuItem.filterType;
                    if (feature.filters[dataIndex].filterValue) {
                        //значение фильтра не пустое И поменялся тип фильтра - необходима заново выполнить фильтрацию
                        context.grid.fireEvent('filterchanged',
                            column,
                            feature.filters[dataIndex].filterValue,
                            menuItem.filterType);
                        return;
                    }
                } else {
                    feature.filters[dataIndex] = { filterType: menuItem.filterType, filterValue: '' };
                }

                //Хак для того чтобы менялась иконка
                var owner = column.ownerCt;
                if (owner.isGroupHeader) // если колонка в группе колонок
                    owner = owner.ownerCt;
                owner.fireEvent('afterlayout');
            },

            createValuesFilterMenu: function (me, context) {
                var grid = me.grid,
                    store = grid.getStore(),
                    data = store.getData(),
                    column = context.column,
                    dataIndex = column.dataIndex,
                    filterType = 'valuesFilter';

                if (!me.filterMenu.valueFilters)
                    me.filterMenu.valueFilters = {};

                if (!me.filterMenu.valueFilterItems)
                    me.filterMenu.valueFilterItems = {};

                if (!me.filterMenu.valueFilterItems[dataIndex] || grid.ownerGrid.needRefreshFilterValues)
                {
                    var feature = context.view.filterFeature,
                        valueItems = [];

                    valueItems.push({
                        text: 'Все',
                        checked: feature.filters['ALL'] && Ext.Array.contains(feature.filters['ALL'].filterValue, value) || false,
                        filterType: filterType,
                        checkHandler: me.changeValuesFilter
                    });

                    valueItems.push({
                        text: 'Пустые',
                        checked: feature.filters['EMPTY'] && Ext.Array.contains(feature.filters['EMPTY'].filterValue, value) || false,
                        filterType: filterType,
                        checkHandler: me.changeValuesFilter
                    });

                    var columnData = [];

                    data.column = column;

                    data.each(function(record) {
                        var recordValue = record.get(dataIndex);
                        if (recordValue == null || (recordValue.length && recordValue.length > 50))
                            return;

                        if (this.column.dataType === "system.datetime")
                            recordValue = Ext.util.Format.date(recordValue, this.column.format);

                        columnData.push(recordValue);
                    });

                    var uniqueValues = Ext.Array.sort(Ext.unique(columnData));

                    Ext.each(uniqueValues, function (value) {
                        if (Ext.isEmpty(value)) return;
                        var valueChecked = feature.filters[dataIndex]
                            && Ext.Array.contains(feature.filters[dataIndex].filterValue, value)
                            || false;
                        valueItems.push({
                            text: value,
                            checked: valueChecked,
                            filterType: filterType,
                            checkHandler: me.changeValuesFilter
                        });
                    });

                    me.filterMenu.valueFilterItems[dataIndex] = valueItems;
                    grid.ownerGrid.needRefreshFilterValues = false;
                }

                if (!me.filterMenu.valuesFilter) {
                    me.filterMenu.valuesFilter = me.filterMenu.insert(0, {
                        text: 'Выбор значения',
                        filterType: filterType,
                        iconCls: me.filterDesc[filterType].iconCls,
                        menu: {
                            showSeparator: false,
                            items: me.filterMenu.valueFilterItems[dataIndex],
                            ctx: context
                        }
                    });
                } else {
                    me.filterMenu.valuesFilter.menu.removeAll();
                    me.filterMenu.valuesFilter.menu.add(me.filterMenu.valueFilterItems[dataIndex]);
                    me.filterMenu.valuesFilter.menu.ctx = context;
                }
            },

            changeValuesFilter: function (menuItem, checked) {
                var context = menuItem.container.component.ctx,
                    feature = context.view.filterFeature,
                    column = context.column,
                    dataIndex = column.dataIndex,
                    valuesFilterMenu = feature.filterMenu.valuesFilter.menu;

                if (!feature.filters[dataIndex])
                    feature.filters[dataIndex] = {};

                if (!Ext.isEmpty(feature.filters[dataIndex].filterValue)) {
                    var checkedItems = [];
                    valuesFilterMenu.items.each(function(item) {
                        if (item.checked) {
                            checkedItems.push(item.text);
                        }
                    });
                    feature.filters[dataIndex].filterValue = checkedItems;
                    feature.setCheckedValueFilterItem(dataIndex, menuItem, checked);
                } else {
                    feature.filters[dataIndex] = { filterType: menuItem.filterType, filterValue: [menuItem.text] };
                    feature.setCheckedValueFilterItem(dataIndex, menuItem, true);
                }

                context.grid.fireEvent('valuesfilterchanged', column, feature.filters[dataIndex]);
            },

            setCheckedValueFilterItem: function (dataIndex, menuItem, checkedState) {
                var filterMenu = this.filterMenu;
                var foundItem = Ext.Array.findBy(filterMenu.valueFilterItems[dataIndex], function (item) { return item.text === menuItem.text; });
                if (foundItem)
                    foundItem.checked = checkedState;
            },

            //шаблон
            fullFilterTpl: [
                '{%',
                'var me = this.filterFeature,',
                '    record = me.filterRecord,',
                '    view = values.view,',
                '    bufferedRenderer = view.bufferedRenderer;',
                'this.nextTpl.applyOut(values, out, parent);',
                'if (!me.disabled && me.showFilterRow &&',
                '!view.addingRows && view.store.isLast(values.record)) {',
                'if (bufferedRenderer) {',
                '    bufferedRenderer.variableRowHeight = true;',
                '}',
                'me.outputFilterRecord((record && record.isModel) ? record : me.createFilterRecord(view), values, out, parent);',
                '}',
                '%}', {
                    priority: 300,

                    beginRowSync: function (rowSync) {
                        rowSync.add('fullFilter', this.filterFeature.filterRowSelector);
                    },

                    syncContent: function (destRow, sourceRow, columnsToUpdate) {
                        destRow = Ext.fly(destRow, 'syncDest');
                        sourceRow = Ext.fly(sourceRow, 'sycSrc');
                        var filterFeature = this.filterFeature,
                            selector = filterFeature.filterRowSelector,
                            destFilterRow = destRow.down(selector, true),
                            sourceFilterRow = sourceRow.down(selector, true);

                        if (destFilterRow && sourceFilterRow) {
                            if (columnsToUpdate) {
                                this.filterFeature.view.updateColumns(destFilterRow, sourceFilterRow, columnsToUpdate);
                            } else {
                                Ext.fly(destFilterRow).syncContent(sourceFilterRow);
                            }
                        }
                    }
                }
            ],

            //создание отрисовщика
            createRenderer: function (column, record) {
                var me = this,
                    dataIndex = column.dataIndex || column.getItemId();

                return function (value, metaData) {
                    return me.filterRendererFunction(record.data[dataIndex], null, dataIndex, metaData);
                };
            },

            //рисование фильтр-ячейки
            filterRendererFunction: function (recordData, filterData, di, metaData) {
                var filterType,
                    filterValue,
                    dataIndex = metaData.column.dataIndex;

                //если есть фильтр
                if (this.filters[dataIndex]) {
                    filterType = this.filters[dataIndex].filterType;
                    filterValue = this.filters[dataIndex].filterValue;
                } else {
                    //значения по умолчанию
                    filterType = 'contains';
                    filterValue = '';
                }

                if (metaData.column.aspType && metaData.column.aspType.indexOf('checkbox') != -1) {
                    return filterValue;
                }

                return '<div class="' +
                    this.filterDesc[filterType].iconCls +
                    '" style="width: 16px; height: 16px; padding: 0 0 0 18px; background-position: center;" align="left"/>' +
                    filterValue;
            },

            //инициализация
            init: function (grid) {
                var me = this,
                    view = me.view,
                    dock = me.dock;

                me.grid = grid;
                me.view = grid.view;

                me.callParent(arguments);

                me.editors = {};
                me.filters = {};

                grid.editingPlugin = grid.view.editingPlugin = me;

                if (dock) {

                    if (!grid.ctrl) {
	                    grid.ctrl = grid.ownerGrid.ctrl;
	                    grid.ksObjs = {};
                    }

                    grid.addBodyCls(me.panelBodyCls + dock);
                    grid.headerCt.on({
                        add: me.onStoreUpdate,
                        afterlayout: me.onStoreUpdate,
                        scope: me
                    });
                    
                    grid.on({
                        // Если убрать, то при изменении ширины колонки они будут криво отображаться
                        columnhide: () => me.onStoreUpdate(),
                        columnshow: () => me.onStoreUpdate(),
                        columnresize: function() {
                            me.onStoreUpdate()
                        }
                    });
                    
                    grid.on({
                        beforerender: function () {
                            var tableCls = [me.filterTableCls];
                            if (view.columnLines) {
                                tableCls.push(view.ownerCt.colLinesCls);
                            }
                            grid.ksObjs.filterBar = me.filterBar = grid.addDocked({
                                childEls: ['innerCt', 'item'],
                                renderTpl: [
                                    '<div id="{id}-innerCt" data-ref="innerCt" role="presentation">',
                                    '<table id="{id}-item" data-ref="item" cellPadding="0" cellSpacing="0" class="' +
                                    tableCls.join(' ') +
                                    '">',
                                    '<tr class="' + me.filterRowCls + '"></tr>',
                                    '</table>',
                                    '</div>'
                                ],
                                scrollable: {
                                    x: false,
                                    y: false
                                },
                                hidden: grid.ctrl.filterMode < 1,
                                itemId: 'filterBar',
                                cls: [me.dockedFilterCls, me.dockedFilterCls + '-' + dock],
                                xtype: 'component',
                                dock: dock,
                                weight: 10000000
                            })[0];
                        },
                        afterrender: function () {
                            grid.getView().getScrollable().addPartner(me.filterBar.getScrollable(), 'x');
                            me.onStoreUpdate();
                            //note: добавлено. обработка клика по фильтр-ячейке!!!
                            //источник http://derpturkey.com/trapping-click-events-in-extjs-summary-feature/
                            this.mon(this.el, 'click', me.onFilterCellClick, me, { delegate: '.x-grid-cell' });
                        },
                        single: true
                    });

                    grid.headerCt.afterComponentLayout = Ext.Function.createSequence(grid.headerCt.afterComponentLayout,
                        function () {
                            var width = this.getTableWidth(),
                                innerCt = me.filterBar.innerCt;

                            me.filterBar.item.setWidth(width);

                            if (this.tooNarrow) {
                                width += Ext.getScrollbarSize().width;
                            }
                            innerCt.setWidth(width);
                        });
                } else {
                    if (grid.bufferedRenderer) {
                        me.wrapsItem = true;
                        view.addRowTpl(Ext.XTemplate.getTpl(me, 'fullFilterTpl')).filterFeature = me;
                        view.on('refresh', me.onViewRefresh, me);
                    } else {
                        me.wrapsItem = false;
                        me.view.addFooterFn(me.renderFilterRow);
                    }
                }

                grid.ownerGrid.on({
                    beforereconfigure: me.onBeforeReconfigure,
                    columnmove: me.onStoreUpdate,
                    scope: me
                });
                me.bindStore(grid, grid.getStore());
            },

            /**
             * Удалить фильтр
             * 
             * @param {Ext.grid.column.Column} column
             */
            removeFilter: function(column) {
                var me = this;

                if (!column.dataIndex || !me.filters[column.dataIndex])
                    return;

                me.filterRecord.set(column.dataIndex, null);
                delete me.filters[column.dataIndex];
                column.removeCls('ks-filterCol');
            },

            /**
             * Установить фильтр
             * 
             * @param {(Ext.grid.column.Column|string)} column
             * @param {string} value
             * @param {string} [type=contains] - тип фильтрации
             */
            setFilter: function(column, value, type) {
                var me = this,
                    grid = me.grid,
                    cell;

                if (!type)
                    type = 'contains';

                if (Ext.typeOf(column) == 'string')
                    column = grid.getColumnManager().getHeaderByDataIndex(column);

                if (!column)
                    return;

                cell = $(me.getFilterBar().el.dom).find('[data-columnid="' + column.id + '"]').children().children();

                grid.fireEvent('filterchanged', column, value, type);
                me.filterRecord.set(column.dataIndex, value);
                column.addCls('ks-filterCol');
                cell.text(value);

                me.filters[column.dataIndex] = {
                    filterType: type,
                    filterValue: value
                };
            },

            //обработка события клика по ячейке грида
            //todo: Рефакторинг
            onFilterCellClick: function (e, target) {
                var me = this;
                //только если включена фильтр-строка
                if (!me.filterBar.hidden) {
                    //ячейка
                    var cell = Ext.get(target),
                        //текущий контрол-грид
                        grid = cell.up('.x-grid').component,
                        //строка по селектору
                        row = cell.up(me.filterRowSelector),
                        //предыдущий редактор (если есть)
                        prevEditor = me.getActiveEditor();
                    // если родителем ячейки является фильтр-строка
                    if (row) {
                        //проверяем на существование
                        if (grid === void 0) return;
                        //индекс ячейки
                        var cellIndex = e.position ? e.position.colIdx : cell.dom.cellIndex,
                            //grid view
                            view = e.position ? e.position.view : grid.getView(),
                            //колонка
                            column = e.position ? e.position.column : view.getVisibleColumnManager().columns[cellIndex],
                            record = me.filterRecord,
                            editor,
                            context,
                            p,
                            ret;

                        //ячейка колонки-нумератора
                        //if ((column.headerNoSpan === 'М') || (column.xtype == 'rownumberer' || column.xtype == 'checkcolumn')) {
                        //    //если есть что очищать
                        //    if (me.filters && Object.keys(me.filters).length > 0) {
                        //        //очистка фильтров
                        //        me.filters = {};
                        //        var ek = Object.keys(me.editors);
                        //        for (var i = 0; i < ek.length; i++) {
                        //            if (me.editors[ek[i]].el.dom) {
                        //                p = me.editors[ek[i]].el.dom.parentNode;
                        //                try {
                        //                    p.removeChild(me.editors[ek[i]].el.dom);
                        //                } catch (e) {
                        //                }
                        //                Ext.destroy(me.editors[ek[i]]);
                        //            }
                        //        }
                        //        me.editors = {};
                        //        grid.fireEvent('filterchanged', column, record.get(column.dataIndex), me.filters[dataIndex].filterType);
                        //    }

                        //    ret = true;
                        //}

                        if (prevEditor && prevEditor.editing && prevEditor.dataIndex != column.dataIndex) {
                            me.view.actionPosition = null;
                            prevEditor.cancelEdit();
                            ret = true;
                        }

                        if (ret) return;

                        context = new Ext.grid.CellContext(view).setAll(view, -1, cellIndex, record, column);
                        // Add extra Editing information 
                        context.grid = grid;
                        context.store = view.dataSource;
                        context.field = column.dataIndex;
                        context.value = context.originalValue = record.get(column.dataIndex);
                        context.row = row;
                        context.node = view.getNode(record);
                        context.cell = cell;

                        if (me.filterMenu && me.filterMenu.rendered && !me.filterMenu.hidden)
                            return;

                        var editors = me.editors,
                            editorId = column.getItemId();

                        editor = editors[editorId];

                        //восстановить значение в record.data
                        if (me.filters[column.dataIndex]) {
                            record.data[column.dataIndex] = me.filters[column.dataIndex].filterValue;
                        }

                        //todo: datefield необходимо отображать сразу с открытым меню
                        //var xtype = 'textfield', dateFormat = '';
                        //if (column.type == 'system.datetime') {
                        //    xtype = 'datefield';
                        //    dateFormat = 'd.m.Y';
                        //}

                        if (!editor || !editor.el.dom) {
                            //CellEditor, FilterEditor
                            editor = new Ext.grid.FilterEditor({
                                dataIndex: column.dataIndex,
                                floating: true,
                                editorId: editorId,
                                field: {
                                    maskRe: /[^!<>@#'$%"\^]/,
                                    triggers:
                                    {
                                        filterType: {
                                            side: 'right',
                                            handler: function (edr, trg) {
                                                var xy = edr.getXY();
                                                var size = edr.getSize();
                                                xy[1] = xy[1] + size.height;
                                                trg.menu.showAt(xy);
                                            }
                                        }
                                    }
                                }
                            });

                            editors[editorId] = editor;
                        }

                        //создать новое меню или обновить контекст
                        editor.field.triggers.filterType.menu = me.getFilterMenu(me, context);

                        editor.ownerCmp = me.grid.ownerGrid;
                        editor.setGrid(me.grid);
                        editor.editingPlugin = me;

                        if (!editor.rendered) {
                            editor.hidden = true;
                            editor.render(cell);
                        } else {
                            if (editor.el.dom) {
                                p = editor.el.dom.parentNode;
                                if (p !== cell.dom) {
                                    try {
                                        p.removeChild(editor.el.dom);
                                    } catch (e) {

                                    }
                                    editor.container = cell;
                                    cell.dom.appendChild(editor.el.dom, cell.dom.firstChild);
                                }
                            } else {
                                //сломанный редактор
                                alert('редактор сломан');
                                //todo: уничтожить и создать новый
                                return;
                            }
                        }

                        var editValue = me.filters[column.dataIndex] ? me.filters[column.dataIndex].filterValue : '';

                        if (editValue !== context.originalValue) {
                            context.value = context.originalValue = editValue;
                        }

                        me.context = editor.editingPlugin.context = context;
                        editor.startEdit(cell, context.value, true);

                        if (editor.editing) {
                            me.setActiveEditor(editor);
                            me.setActiveRecord(context.record);
                            me.setActiveColumn(context.column);
                            me.editing = true;
                        }
                    } else {
                        if (!grid.ctrl.showFloatFilterButton) return;

                        if (prevEditor && prevEditor.editing) {
                            me.view.actionPosition = null;
                            if (prevEditor.field)
                                prevEditor.completeEdit();

                        }
                        if (me.cellId && me.cellId == cell.id) {
                            me.cellId = -1;
                            return;
                        }
                        if (e.position === void 0) return;

                        var column = e.position.column,
                            invalidXtype = ['rownumberer', 'checkcolumn'],
                            invalidAspType = ['checkbox', 'filecolumn'];

                        if (column.hideFilterBtn ||
                            invalidXtype.indexOf(column.xtype) !== -1 ||
                            invalidAspType.indexOf(column.aspType) !== -1) {
                            column.hideFilterBtn = true;
                            return;
                        }

                        var xy = cell.getXY(); //[]
                        var s = cell.getSize(); //{}
                        me.buttonId = 'flowFilterButton';
                        var button = document.getElementById(me.buttonId);
                        if (!button) {
                            button = document.createElement('input');
                            button.id = me.buttonId;
                            button.type = 'button';
                            button.title = KS.L10n.setFilterByValue;
                            button.onclick = me.clickFilterByButton;
                            button.onfocusout = me.hideFilterButton;
                            button.onblur = me.hideFilterButton;
                            button.className = 'ks-filter ks-icon-filter_empty';
                            //button.style.backgroundColor = 'Transparent';
                            Ext.apply(button.style,
                                {
                                    backgroundRepeat: 'no-repeat',
                                    order: 'none',
                                    cursor: 'pointer',
                                    overflow: 'hidden',
                                    outline: 'none',
                                    left: xy[0] + s.width - 20 + 'px',
                                    top: xy[1] - (s.height / 2) + 'px',
                                    width: '20px',
                                    height: '20px',
                                    position: 'absolute',
                                    visibility: 'visible',
                                    zIndex: '2147483647',
                                    display: 'block'
                                });
                            document.body.appendChild(button);
                            document.body.flowFilterButton = button;
                        } else {
                            button.style.left = xy[0] + s.width - 20  + 'px';
                            button.style.top = xy[1] - (s.height / 2) + 'px';
                            button.style.display = 'block';
                        }
                        document.body.filterButtonVisible = true;
                        document.body.flowFilterData = e.position;
                        document.body.filterFeature = me;
                        button.focus();
                        me.cellId = cell.id;
                        return;
                    }
                }
            },

            hideFilterButton: function () {
                if (document.body.filterButtonVisible && document.body.flowFilterButton) {
                    document.body.flowFilterButton.style.display = 'none';
                    document.body.filterButtonVisible = false;
                }
            },

            clickFilterByButton: function (element) {
                element.currentTarget.style.display === 'block' ? 'none' : 'block';

                var position = document.body.flowFilterData;

                if (position && position.column) {
                    var me = document.body.filterFeature,
                        dataIndex = position.column.dataIndex,
                        val = position.record.data[dataIndex];

                    if (Ext.isDate(val)) {
                        val = Ext.util.Format.date(val, position.column.format);
                    }

                    if (me.filters[dataIndex]) {
                        me.filters[dataIndex].filterValue = val;
                    } else {
                        me.filters[dataIndex] = { filterType: 'contains', filterValue: val };
                    }

                    me.grid.fireEvent('filterchanged', position.column, val, me.filters[dataIndex].filterType);
                }

                element.stopPropagation();
            },

            setActiveEditor: function (ed) {
                this.activeEditor = ed;
            },

            getActiveEditor: function () {
                return this.activeEditor;
            },

            setActiveColumn: function (column) {
                this.activeColumn = column;
            },

            getActiveColumn: function () {
                return this.activeColumn;
            },

            setActiveRecord: function (record) {
                this.activeRecord = record;
            },

            getActiveRecord: function () {
                return this.activeRecord;
            },

            //из EditingPlugin
            //валидация введенного значения
            //возвращает true - если значение валидно, иначе - false
            validateEdit: function (ctx) {
                return true;
            },

            //из EditingPlugin
            //выход из редактирования без применения введенного значения (отмена)
            cancelEdit: function (activeEd) {
                var me = this,
                    context = me.context;

                // Called from CellEditor#onEditComplete when canceling. 
                if (activeEd && activeEd.isCellEditor) {
                    me.context.value = ('editedValue' in activeEd) ? activeEd.editedValue : activeEd.getValue();

                    // Editing flag cleared in superclass. 
                    // canceledit event fired in superclass. 
                    me.callParent(arguments);

                    // Clear our current editing context. 
                    // We only do this if we have not already started editing a new context. 
                    if (activeEd.context === context) {
                    }
                        // Re-instate editing flag after callParent 
                    else {
                        me.editing = true;
                    }
                }
                    // This is a programmatic call to cancel any active edit 
                else {
                    activeEd = me.getActiveEditor();
                    if (activeEd && activeEd.field) {
                        activeEd.cancelEdit();
                    }
                }
            },

            //из EditingPlugin
            onEditComplete: function (ed, value, startValue) {
                var me = this,
                    context = ed.context,
                    view = context.view,
                    record = context.record,
                    changed = false,
                    dataIndex = context.column.dataIndex;

                context.value = value;

                if (me.filters[dataIndex] && me.filters[dataIndex].filterType === "valuesFilter") {
                    me.valuesFilterCompleteEdit(ed, value);
                    return;
                }

                // Only update the record if the new value is different than the 
                // startValue. When the view refreshes its el will gain focus 
                if (!record.isEqual(value, startValue)) {
                    //добавлено
                    //сохранить фильтр
                    if (me.filters[dataIndex]) {
                        var grid = context.column.up('grid');
                        if (value)
                            me.filters[dataIndex].filterValue = value;
                        else {
                            if (grid.hasOwnProperty("isLocked"))
                                grid.ownerGrid.removeGridFilter(context.column);
                            else
                                grid.removeGridFilter(context.column);
                        }
                    } else {
                        me.filters[dataIndex] = { filterType: 'contains', filterValue: value };
                    }

                    changed = true;

                    record.set(dataIndex, value);
                }

                // We clear down our context here in response to the CellEditor completing. 
                // We only do this if we have not already started editing a new context. 
                if (me.context === context) {
                    me.setActiveEditor(null);
                    me.setActiveColumn(null);
                    me.setActiveRecord(null);
                    me.editing = false;
                }

                //me.fireEvent('edit', me, context);

                //перерисовать фильтр-строку
                //в случае применения нового фильтра требуется отрисовать новое значение и тип
                //me.filterBar.updateLayout();
                //me.filterBar.item.updateLayout();
                if (changed) {
                    context.grid.fireEvent('filterchanged',
                        context.column,
                        value,
                        me.filters[dataIndex] ? me.filters[dataIndex].filterType : null);
                    //перерисовать фильтр-строку
                    //me.filterBar.updateLayout();
                }
            },

            valuesFilterCompleteEdit: function (ed, value, startValue) {
                var me = this,
                    grid = me.grid,
                    context = ed.context,
                    view = context.view,
                    record = context.record,
                    changed = false,
                    dataIndex = context.column.dataIndex;

                var oldValue = '';
                if(Ext.isArray(grid.filterValue)) {
                    oldValue = grid.filterValue.toString();
                }

                if (value !== oldValue) {
                    if (me.filters[dataIndex]) {
                        if (!Ext.isArray(value))
                            value = [];

                        me.filters[dataIndex] = { filterType: 'contains', filterValue: '' };

                        Ext.each(me.filterMenu.valueFilterItems[dataIndex], function (item) {
                            item.checked = false;
                        });
                    } else {
                        me.filters[dataIndex] = { filterType: 'contains', filterValue: value };
                    }

                    changed = true;

                    record.set(dataIndex, value);
                }

                if (me.context === context) {
                    me.setActiveEditor(null);
                    me.setActiveColumn(null);
                    me.setActiveRecord(null);
                    me.editing = false;
                }

                if (changed) {
                    context.grid.fireEvent('valuesfilterchanged',
                        context.column,
                        value,
                        me.filters[dataIndex].filterType);
                }
            },

            /**
             * @private
             * Collects all information necessary for any subclasses to perform their editing functions.
             * @param {Ext.data.Model/Number} record The record or record index to edit.
             * @param {Ext.grid.column.Column/Number} columnHeader The column of column index to edit.
             * @return {Ext.grid.CellContext/undefined} The editing context based upon the passed record and column
             */
            getEditingContext: function (record, columnHeader, gridRow) {
                var me = this,
                    grid = me.grid,
                    colMgr = grid.visibleColumnManager,
                    view,
                    // gridRow,
                    rowIdx = -1,
                    colIdx,
                    result,
                    layoutView = me.grid.lockable ? me.grid : me.view;

                // The view must have had a layout to show the editor correctly, defer until that time. 
                // In case a grid's startup code invokes editing immediately. 
                if (!layoutView.componentLayoutCounter) {
                    layoutView.on({
                        boxready: Ext.Function.bind(me.startEdit, me, [record, columnHeader]),
                        single: true
                    });
                    return;
                }

                // If disabled or grid collapsed, or view not truly visible, don't calculate a context - we cannot edit 
                if (me.disabled || me.grid.collapsed || !me.grid.view.isVisible(true)) {
                    return;
                }

                // They've asked to edit by column number. 
                // Note that in a locked grid, the columns are enumerated in a unified set for this purpose. 
                if (Ext.isNumber(columnHeader)) {
                    columnHeader = colMgr.getHeaderAtIndex(Math.min(columnHeader, colMgr.getColumns().length));
                }

                // No corresponding column. Possible if all columns have been moved to the other side of a lockable grid pair 
                if (!columnHeader) {
                    return;
                }

                // Coerce the column to the closest visible column 
                if (columnHeader.hidden) {
                    columnHeader = columnHeader.next(':not([hidden])') || columnHeader.prev(':not([hidden])');
                }

                // Navigate to the view and grid which the column header relates to. 
                view = columnHeader.getView();
                grid = view.ownerCt;


                // Column index must be relative to the View the Context is using. 
                // It must be the real owning View, NOT the lockable pseudo view. 
                colIdx = view.getVisibleColumnManager().indexOf(columnHeader);

                // The record may be removed from the store but the view 
                // not yet updated, so check it exists 
                if (!record) {
                    return;
                }

                // Create a new CellContext 
                result = new Ext.grid.CellContext(view).setAll(view, rowIdx, colIdx, record, columnHeader);

                // Add extra Editing information 
                result.grid = grid;
                result.store = view.dataSource;
                result.field = columnHeader.dataIndex;
                result.value = result.originalValue = record.get(columnHeader.dataIndex);
                result.row = gridRow;
                result.node = view.getNode(record);
                result.cell = result.getCell(true);

                return result;
            },

            onBeforeReconfigure: function (grid, store) {
                this.filterRecord = null;

                if (store) {
                    this.bindStore(grid, store);
                }
            },

            bindStore: function (grid, store) {
                var me = this;

                Ext.destroy(me.storeListeners);
                me.storeListeners = store.on({
                    scope: me,
                    destroyable: true,
                    
                    // не надо перерисовывать строку фильтрации по каждому чиху
                    //update: me.onStoreUpdate,
                    //datachanged: me.onStoreUpdate
                });

                me.callParent([grid, store]);
            },

            //отрисовать фильтр-строку
            renderFilterRow: function (values, out, parent) {
                var view = values.view,
                    me = view.findFeature('filter'),
                    record,
                    rows;

                // If we get to here we won't be buffered 
                if (!me.disabled && me.showFilterRow && !view.addingRows && !view.updatingRows) {
                    record = me.filterRecord;

                    out.push('<table cellpadding="0" cellspacing="0" class="' +
                        me.filterItemCls +
                        '" style="table-layout: fixed; width: 100%;">');
                    me.outputFilterRecord((record && record.isModel) ? record : me.createFilterRecord(view),
                        values,
                        out,
                        parent);
                    out.push('</table>');
                }
            },

            //отобразить (или скрыть) фильтр-строку
            toggleFilterRow: function (visible, fromLockingPartner) {
                var me = this,
                    bar = me.filterBar;

                me.callParent([visible, fromLockingPartner]);
                if (bar) {
                    bar.setVisible(me.showFilterRow);
                    me.onViewScroll();
                }
            },

            //получить фильтр-строку
            getFilterBar: function () {
                return this.filterBar;
            },

            getFilterRowPlaceholder: function (view) {
                var placeholderCls = this.filterItemCls,
                    nodeContainer,
                    row;

                nodeContainer = Ext.fly(view.getNodeContainer());

                if (!nodeContainer) {
                    return null;
                }

                row = nodeContainer.down('.' + placeholderCls, true);

                if (!row) {
                    row = nodeContainer.createChild({
                        tag: 'table',
                        cellpadding: 0,
                        cellspacing: 0,
                        cls: placeholderCls,
                        style: 'table-layout: fixed; width: 100%',
                        children: [
                            {
                                tag: 'tbody' // Ensure tBodies property is present on the row 
                            }
                        ]
                    },
                        false,
                        true);
                }

                return row;
            },

            vetoEvent: function (record, row, rowIndex, e) {
                return !e.getTarget(this.filterRowSelector);
            },

            //обработчик прокрутки представления (грида)
            //при сдвиге грида, сдвинуть и фильтр-строку
            onViewScroll: function () {
                this.filterBar.setScrollX(this.view.getScrollX());
            },

            //обработчик обновления представления (грида)
            onViewRefresh: function (view) {
                var me = this,
                    record,
                    row;

                // Only add this listener if in buffered mode, if there are no rows then 
                // we won't have anything rendered, so we need to push the row in here 
                if (!me.disabled && me.showFilterRow && !view.all.getCount()) {
                    record = me.createFilterRecord(view);
                    row = me.getFilterRowPlaceholder(view);
                    row.appendChild(Ext.fly(view.createRowElement(record, -1)).down(me.filterRowSelector, true));
                }
            },

            createFilterRecord: function (view) {
                var me = this,
                    filterRecord = me.filterRecord,
                    modelData;

                if (!filterRecord) {
                    modelData = {
                        id: view.id + '-filter-record'
                    };
                    filterRecord = me.filterRecord = new Ext.data.Model(modelData);
                }

                // Set the filter field values 
                filterRecord.beginEdit();

                filterRecord.endEdit(true);
                // It's not dirty 
                filterRecord.commit(true);
                filterRecord.isFilter = true;

                // заглушки для иерархий
                filterRecord.isExpandable ??= () => false;
                filterRecord.isLastVisible ??= () => false;

                return filterRecord;
            },

            onStoreUpdate: function () {                
                var me = this,
                    view = me.view,
                    selector = me.filterRowSelector,
                    dock = me.dock,
                    record,
                    newRowDom,
                    oldRowDom,
                    p;

                if (!view.rendered) {
                    return;
                }

                record = me.createFilterRecord(view);
                newRowDom = Ext.fly(view.createRowElement(record, -1)).down(selector, true);

                if (!newRowDom) {
                    return;
                }

                // Filter row is inside the docked filterBar Component 
                if (dock) {
                    p = me.filterBar.item.dom.firstChild;
                    oldRowDom = p.firstChild;

                    p.insertBefore(newRowDom, oldRowDom);
                    p.removeChild(oldRowDom);

                    // If docked, the updated row will need sizing because it's outside the View 
                    me.onColumnHeaderLayout();
                }
                    // Filter row is a regular row in a THEAD inside the View. 
                    // Downlinked through the filter record's ID 
                else {
                    oldRowDom = view.el.down(selector, true);
                    p = oldRowDom && oldRowDom.parentNode;

                    if (p) {
                        p.removeChild(oldRowDom);
                    }

                    // We're always inserting the new filter row into the last rendered row, 
                    // unless no rows exist. In that case we will be appending to the special 
                    // placeholder in the node container. 
                    p = view.getRow(view.all.last());

                    if (p) {
                        p = p.parentElement;
                    }
                        // View might not have nodeContainer yet. 
                    else {
                        p = me.getFilterRowPlaceholder(view);
                        p = p && p.tBodies && p.tBodies[0];
                    }

                    if (p) {
                        p.appendChild(newRowDom);
                    }
                }
            },

            // Synchronize column widths in the docked filter Component 
            onColumnHeaderLayout: function () {
                var view = this.view;
                //columns = view.headerCt.getVisibleGridColumns(),
                //gridColumns = view.ownerGrid.headerCt.getVisibleGridColumns(),
                //column,
                //len = columns.length,
                //i,
                //allColumnsWidth = 0,
                //newWidth = 0,
                //filterEl = this.filterBar.el,
                //el;

                view.setWidth(view.ownerGrid.getWidth());
                //for (i = 0; i < len; i++) {
                //    column = columns[i];
                //    el = filterEl.down(view.getCellSelector(column), true);
                //    if (el) {
                //        var ind = KS.Array.find(gridColumns, ['id'], column['id']);
                //        if (ind !== -1) {
                //            newWidth = gridColumns[ind].width;
                //        } else {
                //            newWidth = column.width || (column.lastBox ? column.lastBox.width : 100);
                //        }

                //        if (column.isLastVisible) {
                //            newWidth = view.ownerGrid.getWidth() - allColumnsWidth;
                //        }

                //        Ext.fly(el).setWidth(newWidth > 0? newWidth: 0);
                //        allColumnsWidth += newWidth;
                //    }
                //}
            },

            destroy: function () {
                var me = this;
                if (me.button !== void 0) me.button.destroy();
                me.filterRecord = me.storeListeners = Ext.destroy(me.storeListeners);
                me.callParent();
            }
        });

    Ext.define('Ext.grid.FilterEditor', {
        extend: 'Ext.Editor',
        isCellEditor: true,
        alignment: 'l-l!',
        hideEl: false,
        cls: Ext.baseCSSPrefix +
            'small-editor ' +
            Ext.baseCSSPrefix +
            'grid-editor ' +
            Ext.baseCSSPrefix +
            'grid-cell-editor',
            treeNodeSelector: '.' + Ext.baseCSSPrefix + 'tree-node-text',
            shim: false,
            shadow: false,
            floating: true,
            alignOnScroll: false,
            useBoundValue: false,
            focusLeaveAction: 'completeEdit',
            // Set the grid that owns this editor.
            // Called by CellEditing#getEditor
            setGrid: function (grid) {
                this.grid = grid;
            },
            startEdit: function (boundEl, value, doFocus) {
                this.context = this.editingPlugin.context;
                this.callParent([
                    boundEl,
                    value,
                    doFocus
                ]);
            },
            /**
             * @private
             * Shows the editor, end ensures that it is rendered into the correct view
             * Hides the grid cell inner element when a cell editor is shown.
             */
            onShow: function () {
                var me = this,
                    innerCell = me.boundEl.down(me.context.view.innerSelector);
                if (innerCell) {
                    if (me.isForTree) {
                        innerCell = innerCell.child(me.treeNodeSelector);
                    }
                    innerCell.hide();
                }
                me.callParent(arguments);
            },
            onFocusEnter: function () {
                var me = this;
                me.realign(true);
                me.callParent(arguments);
                // Ensure that hide processing does not throw focus back to the previously focused element.
                me.focusEnterEvent = null;
            },
            onFocusLeave: function (e) {
                var me = this,
                    view = me.context.view,
                    related = Ext.fly(e.relatedTarget);

                // Quit editing in whichever way. 
                // The default is completeEdit. 
                // If we received an ESC, this will be cancelEdit. 
                if (me[me.focusLeaveAction]() === false) {
                    e.event.stopEvent();
                    return;
                }

                delete me.focusLeaveAction;

                // If the related target is not a cell, turn actionable mode off 
                if (!view.destroyed &&
                    view.el.contains(related) &&
                    (!related.isAncestor(e.target) || related === view.el) &&
                    !related.up(view.getCellSelector(), view.el)) {
                    me.context.grid.setActionableMode(false, view.actionPosition);
                }

                me.cacheElement();
                // Bypass Editor's onFocusLeave 
                Ext.container.Container.prototype.onFocusLeave.apply(me, arguments);
            },
            completeEdit: function (remainVisible) {
                var me = this,
                    context = me.context;

                //Лишний вызов абсолютно после startEdit в Ext
                if (remainVisible) return;
                if (me.editing) {
                    context.value = me.field.value;
                    //if (me.editingPlugin.validateEdit(context) === false) {
                    //    if (context.cancel) {
                    //        context.value = me.originalValue;
                    //        me.editingPlugin.cancelEdit();
                    //    }
                    //    return !!context.cancel;
                    //}
                }

                if (!me.field.bodyEl.dom) {
                    //todo: пока не решено
                    //редактор создан и отрисован, но dom = null
                    alert(KS.L10n.editorDestroyed);
                    return;
                }

                me.callParent([
                    remainVisible
                ]);
            },
            onEditComplete: function (remainVisible, canceling) {
                var me = this,
                    activeElement = Ext.Element.getActiveElement(),
                    boundEl;
                me.editing = false;
                // Must refresh the boundEl in case DOM has been churned during edit.
                boundEl = me.boundEl = me.context.cell; //.getCell();
                // We have to test if boundEl is still present because it could have been
                // de-rendered by a bufferedRenderer scroll.
                if (boundEl) {
                    me.restoreCell();
                    // IF we are just terminating, and NOT being terminated due to focus
                    // having moved out of this editor, then we must prevent any upcoming blur
                    // from letting focus fly out of the view.
                    // onFocusLeave will have no effect because the editing flag is cleared.
                    if (boundEl.contains(activeElement) && boundEl.dom !== activeElement) {
                        boundEl.focus();
                    }
                }
                me.callParent(arguments);
                // Do not rely on events to sync state with editing plugin,
                // Inform it directly.
                /*if (canceling) {
                    me.editingPlugin.cancelEdit(me);*/
                //} else {
                    me.editingPlugin.onEditComplete(me, me.getValue(), me.startValue);
                //}
            },
            cacheElement: function () {
                if (!this.editing && !this.destroyed) {
                    Ext.getDetachedBody().dom.appendChild(this.el.dom);
                }
            },
            /**
             * @private
             * We should do nothing.
             * Hiding blurs, and blur will terminate the edit.
             * Must not allow superclass Editor to terminate the edit.
             */
            onHide: function () {
                Ext.Editor.superclass.onHide.apply(this, arguments);
            },
            onSpecialKey: function (field, event, eOpts) {

                var me = this,
                    key = event.getKey(),
                    complete = me.completeOnEnter && key === event.ENTER && (!eOpts || !eOpts.fromBoundList),
                    cancel = me.cancelOnEsc && key === event.ESC,
                    view = me.editingPlugin.view;

                if (complete || cancel) {

                    //var me = this,
                    //    view = me.context.view,
                    //    related = Ext.fly(e.relatedTarget);
                    //// Quit editing in whichever way.
                    //// The default is completeEdit.
                    //// If we received an ESC, this will be cancelEdit.
                    if (me[me.focusLeaveAction]() === false) {
                        e.event.stopEvent();
                        return;
                    }
                    delete me.focusLeaveAction;
                    // If the related target is not a cell, turn actionable mode off
                    //if (!view.destroyed && view.el.contains(related) && (!related.isAncestor(e.target) || related === view.el) && !related.up(view.getCellSelector(), view.el)) {
                    //    me.context.grid.setActionableMode(false, view.actionPosition);
                    //}
                    me.cacheElement();
                    // Bypass Editor's onFocusLeave
                    Ext.container.Container.prototype.onFocusLeave.apply(me, arguments);

                    // Do not let the key event bubble into the NavigationModel after we're don processing it.
                    // We control the navigation action here; we focus the cell.
                    event.stopEvent();
                    // Maintain visibility so that focus doesn't leak.
                    // We need to direct focusback to the owning cell.
                    if (cancel) {
                        me.focusLeaveAction = 'cancelEdit';
                        //вернуть ячейку
                        me.context.cell.focus();
                    }

                    //view.ownerGrid.setActionableMode(false);
                    //me.setActionableMode.call(view.ownerGrid.view, false);

                    //var og = view.ownerGrid;
                    //og.fireEvent('actionablemodechange', false);
                    //og['removeCls'](og.actionableModeCls);     
                }
            },
            getRefOwner: function () {
                return this.column && this.column.getView();
            },
            restoreCell: function () {
                var me = this,
                    innerCell = me.boundEl.down(me.context.view.innerSelector);
                if (innerCell) {
                    if (me.isForTree) {
                        innerCell = innerCell.child(me.treeNodeSelector);
                    }
                    //innerCell.update();
                    //innerCell.updateText();
                    innerCell.show();
                }
            },
            /**
             * @private
             * Fix checkbox blur when it is clicked.
             */
            afterRender: function () {
                var me = this,
                    field = me.field;
                me.callParent(arguments);
                if (field.isCheckbox) {
                    field.mon(field.inputEl,
                        {
                            mousedown: me.onCheckBoxMouseDown,
                            click: me.onCheckBoxClick,
                            scope: me
                        });
                }
            },
            /**
             * @private
             * Because when checkbox is clicked it loses focus  completeEdit is bypassed.
             */
            onCheckBoxMouseDown: function () {
                this.completeEdit = Ext.emptyFn;
            },
            /**
             * @private
             * Restore checkbox focus and completeEdit method.
             */
            onCheckBoxClick: function () {
                delete this.completeEdit;
                this.field.focus(false, 10);
            },
            /**
             * @private
             * Realigns the Editor to the grid cell, or to the text node in the grid inner cell
             * if the inner cell contains multiple child nodes.
             */
            realign: function (autoSize) {
                var me = this,
                    boundEl = me.boundEl,
                    innerCell = boundEl.down(me.context.view.innerSelector),
                    innerCellTextNode = innerCell.dom.firstChild,
                    width = boundEl.getWidth(),
                    offsets = Ext.Array.clone(me.offsets),
                    grid = me.grid,
                    xOffset,
                    v = '',
                    // innerCell is empty if there are no children, or there is one text node, and it contains whitespace
                    isEmpty = !innerCellTextNode ||
                        (innerCellTextNode.nodeType === 3 && !(Ext.String.trim(v = innerCellTextNode.data).length));
                if (me.isForTree) {
                    // When editing a tree, adjust the width and offsets of the editor to line
                    // up with the tree cell's text element
                    xOffset = me.getTreeNodeOffset(innerCell);
                    width -= Math.abs(xOffset);
                    offsets[0] += xOffset;
                }
                if (grid.columnLines) {
                    // Subtract the column border width so that the editor displays inside the
                    // borders. The column border could be either on the left or the right depending
                    // on whether the grid is RTL - using the sum of both borders works in both modes.
                    width -= boundEl.getBorderWidth('rl');
                }
                if (autoSize === true) {
                    me.field.setWidth(width);
                }
                // https://sencha.jira.com/browse/EXTJSIV-10871 Ensure the data bearing element has a height from text.
                if (isEmpty) {
                    innerCell.dom.innerHTML = 'X';
                }
                me.alignTo(boundEl, me.alignment, offsets);
                if (isEmpty) {
                    innerCell.dom.firstChild.data = v;
                }
            },
            getTreeNodeOffset: function (innerCell) {
                return innerCell.child(this.treeNodeSelector).getOffsetsTo(innerCell)[0];
            }
        });
})();

// KS.Ext.Grid
(function() {
    if (KS.isDefined(KS.Ext.Grid)) return;

    // ============= COMPONENTS =======================
    Ext.define('KS.Ext.Grid',
        {
            extend: 'Ext.grid.Panel',
            // сортер для отображения признака сортировки (визуального), 
            // по факту отображаем точно так как приходит с сервера 
            remoteSorterFn: function() {
                return 0;
            },
            applyState: function(value) {
                if (Ext.isObject(value)) {
                    const sorters = value.storeState?.sorters;
                    if (Ext.isArray(sorters)) {
                        sorters.forEach(x => {
                            if (Ext.isEmpty(x.property)) {
                                x.sorterFn = this.remoteSorterFn;
                            }
                        });
                    }
                }
                this.callParent(arguments);
            },
            addPlugin: function(plugin) {
                if (!Ext.isArray(this.plugins))
                    this.plugins = [];
                return this.callParent(arguments);
                //this.plugins.push(plugin);
            },
            //ui: 'navigation-tabs-ks',
            constructor: function(ctrl, cfg) {
                var grid = this;
                grid.ksObjs = {};
                KS.apply(grid,
                    KS.apply(cfg || {}, ctrl.json),
                    {
                        gridSettings: ctrl.gridSettings,    
                        itemId: ctrl.itemId,
                        ctrl: ctrl,
                        isTpl: true,
                        parentView: ctrl.parentView,
                        maximizable: ctrl.maximizable,
                        columnLines: true,
                        removePanelHeader: false,
                        showSummaryRow: ctrl.showSummaryRow
                    });

                if (grid.enableLocking) {
                    grid.split = false;
                }

                if (ctrl.filterMode > 0) {
                    grid.addFeature(
                        {
                            id: 'filter',
                            ftype: 'filter',
                            dock: 'top'
                        }
                    );
                }
                
                
                if (grid.ctrl.exporter)
                    grid.addPlugin({ ptype: 'gridexporter'});

                if (!KS.isEmpty(grid.showSummaryRow)) {
                    grid.addFeature(
                        {
                            id: 'summary',
                            ftype: 'summary',
                            dock: 'bottom',
                            showSummaryRow: grid.showSummaryRow
                        }
                    );
                }

                if (ctrl.customViewConfig) {
                    grid.viewConfig = ctrl.parentView[ctrl.itemId + 'ViewConfig'];
                } else {
                    //renderer для readOnly
                    //grid.viewConfig = {
                    //    getRowClass: function(record, rowIndex) {
                    //        return this.grid.readOnly ? 'ks-row-read-only' : '';
                    //    }
                    //};
                }

                if (ctrl.viewConfig) {
                    grid.viewConfig = Ext.apply({}, ctrl.viewConfig, grid.viewConfig);
                }

                if (grid.displayProgress) {
                    grid.addPlugin({ ptype: 'ksProgress' });
                }

                KS.Ext.Grid.superclass.constructor.call(grid);

                if (grid.displayProgress) {
                    grid.ksObjs.ksProgressBar = this.plugins.find(function(x) { return x.ksProgressBar });
                    grid.bodyCls = 'ks-panel-progress';
                }

                this.setEventHandlers();

                var checkedIndex = grid.ctrl.checkedIndex,
                    page = 1;

                if (checkedIndex && checkedIndex !== -1)
                    page = Math.floor(checkedIndex / grid.getBand().PageSize) + 1;

                grid.ksObjs.files = {};

                if (!Ext.isEmpty(ctrl.value || grid.value)) {
                    grid.getStore().loadDataPage(page, ctrl.value || grid.value);
                } else if (ctrl.autoLoad) {
                    grid.getStore().loadPageFromServerTemplate(page);
                }
            },

            initComponent: function() {
                var grid = this,
                    ctrl = grid.ctrl,
                    band = grid.getBand(),
                    columns = this.makeColumns(grid),
                    store = Ext.create('KS.Ext.Grid.Store', grid, columns),
                    hasPaging = grid.isPagingEnabled(),
                    hasToolbar = hasPaging || !Ext.isEmpty(grid.tbar),
                    cfg = {
                        store: store,
                        columns: columns,
                    };


                if (ctrl.showViewSettingsButton) {
                    ctrl.initconfigColumn = columns;
                }

                KS.Ext.correctSize(grid, ctrl);

                if (ctrl.profileEnabled) {
                    grid.stateful ??= {};
                    grid.stateEvents ??= [];
                    
                    if (ctrl.saveFilterInProfile)
                    {
                        grid.stateful.filter = true;
                        grid.stateEvents.push('filterchanged');
                    }
                }

                if (grid.stateful) {
                    grid.stateId = grid.itemId + '~' + grid.parentView.viewID;
                    if (band.layout && !ctrl.saveFilterInProfile) {
                        var state = Ext.decode(band.layout, true);
                        if (state && state.storeState) {
                            delete state.storeState.filters;
                            band.layout = Ext.encode(state);
                        }
                    }
                    grid.parentView.viewLayout[grid.itemId] = band.layout;
                }

                switch (band.selection) {
                case 0:
                    if (grid.checkedColumnIdx < 0) {
                        grid.selModel = {
                            type: 'rowmodel'
                        };
                        break;
                    }
                case 1:
                    grid.selModel = {
                        type: 'kscheckboxmodel',
                        toggleOnClick: false,
                        mode: ctrl.uncheckBySelect ? 'MULTI' : 'SIMPLE',
                        pruneRemoved: ctrl.pruneRemoved,
                        listeners: {
                            selectionchange: ksCheckModelSelectionChange
                        }
                    };
                    break;
                case 2:
                    grid.selModel = {
                        type: 'cellmodel',
                        mode: 'SINGLE'
                    };
                    break;
                case 3:
                    grid.selModel = {
                        type: 'spreadsheet',
                        checkboxSelect: grid.checkedColumnIdx >= 0,
                        pruneRemoved: ctrl.pruneRemoved,
                        columnSelect: false,
                        rowNumbererHeaderWidth: band.rowNumberer ? 50 : 0,
                        checkboxColumnIndex: band.rowNumberer ? 1 : 0,
                        extensible: false
                    };
                    if (!Ext.isEmpty(grid.cellSelect))
                        grid.selModel.cellSelect = grid.cellSelect;
                    break;
                case 4:
                    grid.selModel = {
                        type: 'kscheckboxmodel',
                        toggleOnClick: false,
                        mode: 'SINGLE',
                        listeners: {
                            selectionchange: ksCheckModelSelectionChange
                        }
                    };
                    break;
                }
                
                if (grid.selModel?.type === 'kscheckboxmodel') {
                    if (!Ext.isEmpty(grid.ksCheckBoxModelColumnWidth))
                        grid.selModel.checkColumnWidth = grid.ksCheckBoxModelColumnWidth;
                    if (band.rowNumberer)
                        grid.selModel.injectCheckbox = grid.checkedColumnIdx;
                    if (!Ext.isEmpty(grid.ksCheckBoxModelInjectCheckbox))
                        grid.selModel.injectCheckbox = grid.ksCheckBoxModelInjectCheckbox;
                }
                
                grid.title = band.title || grid.title || false;

                var tb = null;
                cfg.dockedItems = cfg.dockedItems || [];
                if (hasToolbar) {
                    if (hasPaging) {
                        cfg.dockedItems.push(grid.ksObjs.pagingBar = Ext.create('KS.Ext.Grid.PagingToolbar',
                            {
                                dock: 'bottom',
                                pageSize: store.pageSize,
                                //baseItems: baseItems,
                                store: store
                            }));
                    }

                    tb = grid.tbar;

                    if (tb && grid.selModel && grid.selModel.mode === 'MULTI' && ctrl.addSelectButtons) {
                        var config = {
                            xtype: 'splitbutton',
                            iconCls: 'ks-icon-galka',
                            tooltip: KS.L10n.inversion,

                            menu: [
                                {
                                    text: KS.L10n.inversion,
                                    iconCls: 'ks-icon-galka',
                                    handler: function() { grid.invertAll(); }
                                }, {
                                    text: KS.L10n.checkAllHere,
                                    handler: function() { grid.checkAll(); }
                                }, {
                                    text: KS.L10n.uncheckAllHere,
                                    handler: function() { grid.uncheckAll(); }
                                }, {
                                    text: KS.L10n.checkFromBeginning,
                                    hidden: true,
                                    handler: function() { grid.checkFromFirst(); }
                                }, {
                                    text: KS.L10n.checkFromCurrent,
                                    hidden: true,
                                    handler: function() { grid.checkToEnd(); }
                                }, {
                                    text: KS.L10n.betweenChecked,
                                    hidden: true,
                                    handler: function() { grid.checkBetween(); }
                                }, {
                                    text: KS.L10n.checkSelected,
                                    hidden: true,
                                    handler: function() { grid.checkSelection(); }
                                }
                            ],
                            handler: function() { grid.invertAll(); }
                        };
                        
                        if (KS.useBigToolbarButtons) {
                            Object.assign(config, {
                                minWidth: 36,
                                height: 36,
                                iconCls: 'ks-icon-galka32',
                                cls: 'listview-toolbar'
                            });
                        }
                        
                        tb.add(config);
                    }
                }

                if (tb) cfg.dockedItems.push(tb);

                if (ctrl.filterMode > 0) {
                    grid.addPlugin({
                        ptype: 'gridfilters'
                    });
                }

                if (band.selection === 3) {
                    grid.addPlugin({
                        ptype: 'clipboard',
                        id: 'clipboard'
                    });
                }

                if (grid.rowExpanderTemplate) {
                    grid.addPlugin({
                        ptype: 'rowexpander',
                        id: 'rowexpander',
                        rowBodyTpl: new Ext.XTemplate(grid.rowExpanderTemplate)
                    });
                }

                Ext.apply(grid, cfg);

                Ext.each((grid.customCls || '').split(','), function(cls) {
                    if (Ext.isEmpty(cls)) return;
                    if (cls.indexOf('.') == 0)
                        grid.addCls(cls.substring(1));
                });

                grid.callParent(arguments);

                grid.onKsFilterChange = onKsFilterChange;
                grid.checkList = [];

                var header;

                if (grid.enableLocking) {
	                /*grid.lockedGrid.headerCt.getMenuItems = me.getMenuItems(me.lockedGrid.headerCt.getMenuItems, true);
	                grid.normalGrid.headerCt.getMenuItems = me.getMenuItems(me.normalGrid.headerCt.getMenuItems, false)*/
	                /*grid.lockedGrid.headerCt.showMenuBy =
		                Ext.Function.createInterceptor(me.lockedGrid.headerCt.showMenuBy, me.showMenuBy);
	                grid.normalGrid.headerCt.showMenuBy =
		                Ext.Function.createInterceptor(me.normalGrid.headerCt.showMenuBy, me.showMenuBy);*/
                    if (grid.lockedGrid) {
                        grid.lockedGrid.headerCt.originGetMenuItems = grid.lockedGrid.headerCt.getMenuItems;
                        grid.lockedGrid.headerCt.getMenuItems = grid.getMenuItemsKs;
                    }
                    header = grid.normalGrid.headerCt;
                } else {
	                header = grid.getHeaderContainer();
                }

                //Заменяем метод getMenuItems на наш
                var groupsCount = ctrl.groupLevel;//ctrl.columnHeaderGroups && ctrl.columnHeaderGroups.length;

                header.originGetMenuItems = header.getMenuItems;
                header.getMenuItems = grid.getMenuItemsKs;

                if (groupsCount) {
                    if (!ctrl.dynamicHeaderHeight) {
                        header.setMaxHeight((groupsCount + 1) * 30);
                        header.ksMaxHeight = (groupsCount + 1) * 30;
                    }

                    header.on('afterrender',
                        function(th) {
                            var cols = th.getGridColumns();

                            Ext.each(cols,
                                function(col) {
                                    if (col.isSubHeader || !col.parentGroup) {
                                        col.textEl && col.textEl.addCls('ks-column-header-text');
                                        
                                    } else {
                                        col.textEl && col.textEl.removeCls('ks-column-header-text');
                                    }
                                    
                                });
                        });

                } else {
                    if (!ctrl.dynamicHeaderHeight) {
                        header.setMaxHeight(30);
                        header.ksMaxHeight = 30;
                    }
                }

                if (ctrl.autoSizeColumns) {
                    grid.getView().on('viewready', autoSizeColumns, grid);
                }

                grid.pageCacheLib = {
                    cache: {},
                    _arrKeys: ['gridKey', 'start', 'to', 'order', 'filter'],

                    getKey: function(params) {
                        var key = '';
                        if (params) {
                            Ext.each(this._arrKeys,
                                function(k) {
                                    if (params[k]) {
                                        key += '_';
                                        key += params[k];
                                    }
                                });
                        }

                        return key;
                    },

                    set: function(key, page, size, data) {
                        var d = this.cache[key] || {};

                        if (data) {
                            this.cache[key] = data;
                        }
                    },

                    get: function(params) {
                        var me = this,
                            key = me.getKey(params);

                        return this.cache[key];
                    },

                    reset: function() {
                        this.cache = {};
                    }
                };
                
            },

            setEventHandlers: function() {
                var grid = this;
                if (grid.enableLocking && !KS.forceGridHandlersOnLockableMainGrid) {
                    setEventHandlers(grid.lockedGrid);
                    setEventHandlers(grid.normalGrid);
                } else {
                    setEventHandlers(grid);
                }
            },

            setFilterVisible: setFilterVisible,

            getMenuItemsKs: function() {
                var me = this,
                    menuItems = me.originGetMenuItems? me.originGetMenuItems(): [];

                menuItems.push({
                    iconCls: 'ks-icon-filter_empty',
                    text: KS.L10n.filterType,
                    handler: function () {
                        setFilterVisible.call(this);
                        if (this.filterVisible) {
                            removeGridFilter.call(this);
                        }
                    },
                    scope: me.grid
                }, {
                    iconCls: 'ks-icon-filter_off',
                    text: KS.L10n.clearThisFilter,
                    handler: function (item, e) {
                        removeGridFilter.call(this, item.up('gridcolumn'));
                    },
                    scope: me.grid
                }, {
                    iconCls: 'ks-icon-filter_off',
                    text: KS.L10n.clearAllFilters,
                    handler: function() {
                        removeGridFilter.call(this);
                    },
                    scope: me.grid
                }, {
                    iconCls: 'ks-icon-clean',
                    text: KS.L10n.cancelSorting,
                    handler: function () {
                        var me = this.hasOwnProperty("isLocked") ? this.ownerGrid : this,
                            store = me.getStore();

                        store.getSorters().removeAll();
                        me.parentView.viewLayout[me.ctrlId] = me.getState();
                        me.fireEvent('statesave', me, me.getState());

                        store.loadPageFromServerTemplate(1);
                    },
                    scope: me.grid
                });

                return menuItems;
            },

            removeGridFilter: function (column) {
                removeGridFilter.apply(this, arguments);
                if (column)
                    this.fireEvent('filterchanged', column, '', null);
            },

            getSelectionCount: function() {
                return this.getSelectionModel().getCount();
            },

            setReadOnly: function(readOnly) {
                this.readOnly = readOnly;
                this.view.refresh();
            },

            //#region check

            hasCheck: function() {
                return (this.checkedColumnIdx >= 0);
            },

            markTop: function () { this.checkFromFirst.call(this, arguments); },
            checkFromFirst: function () {
                var grid = this,
                    selModel = grid.getSelectionModel(),
                    sel = selModel.pruneRemoved === true
                        ? selModel.getSelection()
                        : selModel.getStoreSelection();

                if (sel.length) {
                    grid.store.each(function(rec) {
                        if (!sel.length) return false;
                        grid.checkRecord(rec, true);
                        KS.Array.remove(sel, rec);
                        return true;
                    });
                } else {
                    grid.checkAll();
                }

                selModel.doMultiSelect(grid.checkList, false, true);
            },

            markRest: function () { this.checkToEnd.call(this, arguments); },
            checkToEnd: function () {
                var grid = this,
                    selModel = grid.getSelectionModel(),
                    sel = selModel.pruneRemoved === true
                        ? selModel.getSelection()
                        : selModel.getStoreSelection();
                    recs = grid.store.getRange();

                if (sel.length) {
                    Ext.each(recs,
                        function(rec) {
                            if (!sel.length) return false;
                            grid.checkRecord(rec, true);
                            KS.Array.remove(sel, rec);
                            return true;
                        },
                        grid,
                        true);
                } else {
                    grid.checkAll();
                }

                selModel.doMultiSelect(grid.checkList, false, true);
            },

            markBetween: function () { this.checkBetween.call(this, arguments); },
            checkBetween: function () {
                var grid = this,
                    store = grid.getStore(),
                    frst = false,
                    last = false;

                store.each(function(rec) {
                    if (rec.get('CHECKED')) {
                        if (!frst) frst = rec;
                        last = rec;
                    }
                });

                if (frst) {
                    var start = store.indexOf(frst),
                        end = store.indexOf(last);

                    Ext.each(store.getRange(start, end), function(rec) { grid.checkRecord(rec, true); });
                }

                grid.getSelectionModel().doMultiSelect(grid.checkList, false, true);
            },

            getCheckedRows: function() {
                if (!Ext.isEmpty(this.checkedCodes)) {
                    var grid = this,
                        checkedColName = 'CHECKED';
                    grid.store.each(function (rec) {
                        if (grid.getAnyCase(rec, checkedColName) === false) {
                            grid.removeCodeFromCheckedList(grid.getCloseCode(rec));
                        }
                    });
                }
                return this.getSelectionModel().getSelection();
            },
            
            removeCodeFromCheckedList: function (cc) {
                var idx = $.inArray(cc, this.checkedCodes);
                if (idx >= 0) this.checkedCodes.splice(idx, 1);
            },

            getCheckedCodes: function(includeSelected) {
                var grid = this,
                    checkedRows = grid.getCheckedRows(includeSelected),
                    codes = [];
                Ext.each(checkedRows,
                    function(rec) {
                        var cc = grid.getCloseCode(rec);
                        if (cc) codes.push(cc);
                    });
                if (Ext.isEmpty(codes))
                    codes.push(...grid.checkedCodes);
                return codes;
            },

            // rec = запись
            // v = значение
            // needChangeSelModel если true = тогда делаем селект в модели, иначе надо руками делать надо
            checkRecord: function(rec, v, needChangeSelModel) {
                var me = this,
                    checkList = me.checkList,
                    i = KS.Array.recordIndexOf(checkList, rec, 'id'),
                    exsists = i !== -1;

                if (v) {
                    !exsists && checkList.push(rec);
                } else {
                    exsists && checkList.splice(i, 1);
                }

                rec.set('CHECKED', v);

                if (needChangeSelModel) {
                    me.getSelectionModel().doMultiSelect(checkList, false, true);
                }

                return checkList;
            },

            checkSelection: function() {
                var grid = this;
                Ext.each(grid.getSelectionModel().getSelection(), function(rec) { grid.checkRecord(rec); });
            },

            markInvert: function () { this.invertAll.call(this, arguments); },
            invertAll: function () {
                var grid = this;

                grid.store.each(function (rec) { grid.checkRecord(rec, !rec.get('CHECKED')); });
                grid.getSelectionModel().doMultiSelect(grid.checkList, false, true);
                grid.confirmCheckSelection();
            },

            markAll: function () { this.checkAll.call(this, arguments); },
            checkAll: function () {
                this.setAllCheckState(true);
            },

            unmark: function () { this.uncheckAll.call(this, arguments); },
            uncheckAll: function () {
                this.setAllCheckState(false);
            },

            setAllCheckState: function(checked) {
                var grid = this;
                grid.store.each(function (rec) { grid.checkRecord(rec, !!checked); });
                grid.getSelectionModel().doMultiSelect(grid.checkList, false, true);
                grid.confirmCheckSelection();
            },

            confirmCheckSelection: function (selection) {
                var grid = this;
                if (grid.parentView && KS.isFunction(grid.parentView.onGridCheckboxSelectionChange) &&
                    grid.selModel && grid.selModel.type === 'kscheckboxmodel') {
                    grid.parentView.onGridCheckboxSelectionChange(grid,
                        Ext.isArray(selection) ? selection : grid.getSelectionModel().getSelection());
                }
            }
            //#endregion check
        });

    Ext.define('KS.Ext.Grid.Store',
        {
            extend: 'Ext.data.Store',
            autoLoad: false,

            constructor: function(grid, columns) {
                var band = grid.getBand();

                this.grid = grid;

                var cfg = {
                    //model: modelName,
                    fields: this._makeFields(columns),
                    sorters: this.makeSorters(columns),
                    autoSort: grid.ctrl.autoSort === true,
                    
                    proxy: {
                        type: 'memory',
                        //не убирать, иначе proxy режет данные при сортировке
                        enablePaging: false,
                        reader: {
                            rootProperty: 'rows',
                            totalProperty: 'total'
                        }
                    }
                };
                
                if (grid.ctrl.storeProfileDisabled)
                    cfg.getState = function() {};

                // With paging, sorting is server-side
                if (grid.isPagingEnabled()) {
                    KS.apply(cfg,
                        {
                            pageSize: band.PageSize,
                            remoteSort: true,
                            preventRemoteSort: true
                        });

                    KS.defer(function () { delete this.getStore().preventRemoteSort }, [], grid, 500);
                }

                if (band.Group != null && band.Group.length > 0) {
                    var groupField = band.Group[0].key;
                    KS.apply(cfg,
                        {
                            groupField: groupField
                        });
                    grid.addFeature({
                        ftype: 'grouping',
                        groupHeaderTpl: grid.groupTextTemplate
                    });
                }

                KS.Ext.Grid.Store.superclass.constructor.call(this, cfg);
            },

            _makeFields: function(columns) {
                var fields = [];
                
                for (var i = 0; i < columns.length; i++) {
                    var column = columns[i],

                        field = {
                            name: column.dataIndex,
                            type: 'string',
                            allowNull: true
                        };
                    
                    switch (column.aspType) {
                        case 'number':
                            field.type = column.tag?.isBigNumberType === true ? 'string' : 'number';
                            
                            field.convert = function(value) {
                                if (Ext.typeOf(value) === 'string')
                                    value = value.replace(',', '.').replaceAll(Ext.util.Format.thousandSeparator, '');
                                
                                return Ext.isEmpty(value) ? undefined : (this.type === 'string' ? String(value) : Number(value));
                            };
                            break;
                        case 'combobox':

                            // bug 135995
                            if (column.tag && column.tag.isBool) {
                                field.type = 'number';
                            }

                            break;
                        case 'checkcolumn':
                        case 'checkbox':
                            field.type = 'bool';
                            break;
                        case 'datecolumn':
                            field.type = 'date';
                            field.dateFormat = !Ext.isEmpty(column.format) ? column.format : 'd.m.Y';
                            break;
                    }

                    fields.push(field);

                    if (column.columns)
                        columns = columns.concat(column.columns);
                }

                return fields;
            },

            makeSorters: function(columns) {
                var sorters = [];
                var sortColumns = [];

                for (var i = 0; i < columns.length; i++) {
                    var column = columns[i];
                    var sorter = column.sorter;
                    
                    if (sorter?.isFakeSorter)
                        continue;
                    
                    if(sorter)
                        sortColumns.push(column);
                    if (column.columns)
                        columns = columns.concat(column.columns);
                }

                sortColumns.sort(function(x, y) {
                    if (x.sorting_order < y.sorting_order) return -1;
                    if (x.sorting_order > y.sorting_order) return 1;
                    return 0;
                });
                Ext.each(sortColumns, function(c) {
                    sorters.push(c.sorter);
                });
                return sorters;
            },

            isDataInitialized: function(total) {
                if (this.getProxy().data && !Ext.isArray(this.getProxy().data.rows))
                    return false;
                if (Ext.isNumber(total) && this.getProxy().data && this.getProxy().data.rows.length !== total)
                    return false;
                return true;
            },

            resetData: function(total) {
                this.getProxy().data = {
                    rows: new Array(),
                    total: total
                };
                //Сохраняем количество записей пришедших с сервера
                this.grid.totalData = total;
                this.grid.setSBText(total);
            },

            checkPage: function(page) {
                var grid = this.grid,
                    hasPaging = grid.isPagingEnabled(),
                    fromRecord = hasPaging ? ((page - 1) * this.pageSize) : 0;

                return grid.pageCacheLib.get({
                    start: fromRecord,
                    to: fromRecord + (this.pageSize - 1),
                    gridKey: grid.ctrl.itemId,
                    order: grid.getOrder(),
                    filter: grid.getFilter()
                });
            },

            loadDataPage: function(page, json) {
                if (Ext.isEmpty(json)) return;
                if (Ext.isString(json))
                    json = Ext.decode(json, true);

                var smType = this.grid.selModel.type,
                    prevSelection = null;

                if (this.grid.ctrl.selectRows === 2) {
                    switch (smType) {
                    case 'cellmodel':
                    case 'kscheckboxmodel':
                    case 'spreadsheet':
                        prevSelection = this.grid.getCheckedRows();
                        break;
                    }
                }
                
                var grid = this.grid,
                    hasPaging = grid.isPagingEnabled(),
                    fromRecord = hasPaging ? ((page - 1) * this.pageSize) : 0,
                    realPageSize = hasPaging ? this.pageSize : json.rows.length;

                if (hasPaging && json.total > this.pageSize && grid.disablePageCaching !== true) {
                    //Грузим со второй страницы т.к. первая уже есть
                    for (var i = 2; i <= json.pagesCount; i++) {
                        if (json['page' + i]) {
                            fromRecord = fromRecord + this.pageSize;
                            grid.pageCacheLib.set(grid.pageCacheLib.getKey({
                                    start: fromRecord,
                                    to: fromRecord + (this.pageSize - 1),
                                    gridKey: grid.ctrl.itemId,
                                    order: grid.getOrder(),
                                    filter: grid.getFilter()
                                }),
                                json['page' + i],
                                realPageSize,
                                JSON.parse(JSON.stringify({
                                    total: json.total,
                                    rows: json['page' + i]
                                })));
                        }
                    }
                }

                this.loadJsonRows(page, json);

                if (grid.ctrl.selectRows === 1) { // FirstRow
                    switch (smType) {
                    case 'rowmodel':
                    case 'kscheckboxmodel':
                        if (this.getAt(0)) {
                            grid.checkRecord(this.getAt(0), true, true);
                        }
                        break;
                    case 'spreadsheet':
                        if (this.getAt(0)) {
                            grid.getSelectionModel().select(0);
                        }
                        break;
                    }
                } else if (grid.ctrl.selectRows === 2 && // Previous
                    !KS.isEmpty(prevSelection)) {
                    switch (smType) {
                    case 'cellmodel':
                    case 'kscheckboxmodel':
                    case 'spreadsheet':
                        for (var code in prevSelection) {
                            if (prevSelection.hasOwnProperty(code)) {
                                var rec = grid.findRecord(grid.getCloseCode(prevSelection[code]), grid.closeCode, false);
                                if (rec) {
                                    var selModel = grid.getSelectionModel();
                                    if (selModel.pruneRemoved === false) {
                                        smType !== 'spreadsheet' ?
                                            selModel.selected.removeByKey(prevSelection[code].id) :
                                            selModel.selected.selectedRecords.removeByKey(prevSelection[code].id);
                                    }
                                    selModel.select(rec, true);
                                }
                            }
                        }
                        break;
                    }
                } else if (grid.phantomCheckedColumn) { // CHECKED column data
                    switch (smType) {
                    case 'rowmodel':
                    case 'kscheckboxmodel':
                    case 'spreadsheet':
                        var recs = [];
                        this.each(function(rec) {
                            if (rec.get('CHECKED')) {
                                recs.push(rec);
                            }
                        });
                        grid.getSelectionModel().select(recs, true, true);
                        grid.checkList = recs;
                        break;
                    }
                }
                
                const selection = grid.getSelection();
                if (grid.ctrl.scrollToPreviousSelection && selection.length) {
                    var index = grid.store.indexOf(selection[0]) + 5,
                        count = grid.store.count();
                    grid.getView().focusRow(index > count ? count - 1 : index);
                }
                
                if (grid.ctrl.selectFirstRowIfSelectionIsEmpty) {
                    if (KS.isEmpty(prevSelection) && this.getAt(0)) {
                        grid.getSelectionModel().select(0);
                    }
                }

                grid.confirmCheckSelection();

                if (json.filteredCount > 0 && !grid.store.tree) {
                    var selCount = grid.getSelectedRows().length;
                    grid.setSBText(selCount, 0, grid.totalData === grid.store.data.length ? false : grid.store.data.length, json.filteredCount);
                }
                else 
                    grid.setSBText(grid.getSelectionModel().getSelection().length, grid.checkedCodes ? grid.checkedCodes.length : 0, false);
                grid.fireEvent('afterdatapageload');

                var bufferedRendererPlugin = grid.findPlugin("bufferedrenderer");
                if (bufferedRendererPlugin)
                    bufferedRendererPlugin.onViewScroll(); // отобразить строки для текущей позиции скролла
            },

            loadJsonRows: function(page, json) {
                var grid = this.grid,
                    hasPaging = grid.isPagingEnabled(),
                    fromRecord = hasPaging ? ((page - 1) * this.pageSize) : 0,
                    realPageSize = hasPaging ? this.pageSize : json.rows.length;

                if (fromRecord + this.pageSize > json.total)
                    realPageSize = json.total - fromRecord;

                this.getProxy().data = json;

                if (grid.disablePageCaching !== true) {
                    grid.pageCacheLib.set(grid.pageCacheLib.getKey({
                            start: fromRecord,
                            to: fromRecord + (this.pageSize - 1),
                            gridKey: grid.ctrl.itemId,
                            order: grid.getOrder(),
                            filter: grid.getFilter()
                        }),
                        page,
                        realPageSize,
                        JSON.parse(JSON.stringify(json)));
                } 

                this.loadPage(page,
                    {
                        limit: json.total,
                        start: 0
                    });
            },
            
            getSortInfo: function() {
                const store = this;
                const sorters = store.getSorters();
                if (sorters && sorters.length > 0) {
                    var sortInfo = '';
                    sorters.each(function(sorter) {
                        sortInfo += sorter.getId() + ' ' + sorter.getDirection() + ',';
                    });
                    return sortInfo;
                }
            },

            loadPageFromServerTemplate: function(page, gridObj) {
                var store = this,
                    grid = store.grid,
                    view = grid.parentView,
                    fromRecord = ((page - 1) * store.pageSize),
                    sorters = store.getSorters(),
                    gdp = {
                        type: 'grid',
                        itemId: grid.itemId,
                        start: fromRecord,
                        limit: grid.getBand().PageSize === -1? -1: store.pageSize,
                        filterInfo: grid.getFilter(gridObj)
                    };
                if (Ext.isFunction(view.getAdditionalGetDataParams))
                    view.getAdditionalGetDataParams(gdp);
                
                const sortInfo = store.getSortInfo();
                if (sortInfo)
                    gdp.sortInfo = sortInfo;
                
                if (grid.displayProgress && grid.rendered) {
                    grid.ksObjs.ksProgressBar.showProgressBar();
                    grid.mask(KS.L10n.readingStatus);
                }
                view.serverCall({
                    method: 'GetControlData',
                    params: [gdp],
                    waitMessage: KS.L10n.readingDataPage,
                    disableFog: grid.displayProgress && grid.rendered,
                    complete: function() {
                        if (grid.displayProgress && grid.rendered) {
                            grid.ksObjs.ksProgressBar.hideProgressBar();
                            grid.unmask();
                        }
                    },
                    success: function (json) {
                        store.preventRemoteSort = true;
                        store.loadDataPage(page, json);
                        delete store.preventRemoteSort;
                        store.grid.fireEvent('afterjsonload');
                        grid.needRefreshFilterValues = true;
                    }
                });
            }
        });

    Ext.define('KS.ux.ProgressBarPager',
        {
            requires: ['Ext.ProgressBar'],
            width: 400,
            defaultText: KS.L10n.loadingStatus,
            defaultAnimCfg: {
                duration: 1000,
                easing: 'bounceOut'
            },
            constructor: function(config) {
                if (config) {
                    Ext.apply(this, config);
                }
            },
            init: function(parent) {
                var displayItem;
                if (parent.displayInfo) {
                    this.parent = parent;

                    displayItem = parent.child('#displayItem');
                    if (displayItem) {
                        parent.remove(displayItem, true);
                    }

                    this.progressBar = Ext.create('Ext.ProgressBar',
                        {
                            text: this.defaultText,
                            width: this.width,
                            animate: this.defaultAnimCfg,
                            ui: 'ksProgressBarPager',
                            style: {
                                cursor: 'pointer'
                            },
                            listeners: {
                                el: {
                                    scope: this,
                                    click: this.handleProgressBarClick
                                }
                            }
                        });

                    parent.displayItem = this.progressBar;

                    parent.add(parent.displayItem);
                    Ext.apply(parent, this.parentOverrides);
                }
            },
            handleProgressBarClick: function(e) {
                var parent = this.parent,
                    displayItem = parent.displayItem,
                    box = this.progressBar.getBox(),
                    xy = e.getXY(),
                    position = xy[0] - box.x,
                    pages = Math.ceil(parent.store.getTotalCount() / parent.store.pageSize),
                    newPage = Math.max(Math.ceil(position / (displayItem.width / pages)), 1);

                parent.store.loadPage(newPage);
            },
            parentOverrides: {
                updateInfo: function() {
                    if (this.displayItem) {
                        var count = this.store.getCount(),
                            pageData = this.getPageData(),
                            message = count === 0
                                ? this.emptyMsg
                                : Ext.String.format(
                                    this.displayMsg,
                                    pageData.fromRecord,
                                    pageData.toRecord,
                                    this.store.getTotalCount()
                                ),
                            percentage = pageData.pageCount > 0 ? (pageData.currentPage / pageData.pageCount) : 0;

                        this.displayItem.updateProgress(percentage, message, this.animate || this.defaultAnimConfig);
                    }
                }
            }
        });

    Ext.define('KS.Ext.Grid.PagingToolbar',
        {
            extend: 'Ext.toolbar.Paging',
            dock: 'bottom',
            displayInfo: true,
            reload: false,
            emptyMsg: KS.L10n.emptyMsg,

            listeners: {
                beforechange: function(ptb, page /*, eOpts*/) {
                    var store = ptb.store,
                        fromRecord = ((page - 1) * store.pageSize),
                        cachedData = store.checkPage(page);

                    if (cachedData) {
                        store.loadDataPage(page, cachedData);
                        return false;
                    }

                    if (fromRecord > store.totalCount) {
                        page = (store.totalCount / store.pageSize).toFixed() * 1;
                    }

                    ptb.activePage = page;
                    store.loadPageFromServerTemplate(page);
                    return false;
                }
            },

            initComponent: function() {
                //this.plugins = Ext.create('KS.ux.ProgressBarPager');
                this.callParent(arguments);
                this.activePage = 1;
            },

            getPagingItems: function() {
                var me = this,
                    baseItems = me.baseItems || [],
                    pagerItems = me.callParent(arguments),
                    lastConfig = pagerItems[pagerItems.length - 1];

                //if (!Ext.isEmpty(baseItems))
                baseItems.push({ xtype: 'tbspacer', width: 10 });

                if (lastConfig.itemId === 'refresh') lastConfig.hidden = true;

                var comboStore = {
                    fields: ['value', 'name'],
                    data: [
                        { "value": 10, "name": "10" },
                        { "value": 25, "name": "25" },
                        { "value": 50, "name": "50" },
                        { "value": 75, "name": "75" },
                        { "value": 100, "name": "100" }
                    ]
                };
                if (KS.loadAllPages)
                    comboStore.data.push({ "value": -1, "name": "Все" });

                baseItems.push(
                    {
                        xtype: 'tbtext',
                        itemId: 'pageSizeText',
                        html: KS.pageSizeLabel + ':'
                    },
                    Ext.create('Ext.form.field.ComboBox',
                        {
                            tooltip: me.pageSizeText,
                            overflowText: me.pageSizeText,
                            width: 80,
                            value: me.pageSize,
                            minValue: 0,
                            //Больше 1000 пока не будем делать, большая нагрузка на клиент
                            maxValue: 1000,
                            editable: true,
                            store: comboStore,
                            displayField: 'name',
                            valueField: 'value',
                            listeners: {
                                change: {
                                    fn: function(th, newValue) {
                                        if (!newValue) return false;

                                        newValue = newValue * 1;
                                        if (KS.loadAllPages && newValue === -1 && !KS.useTotalLabelOnLoadAllPages) {
                                            newValue = me.store.getTotalCount(); 
                                            th.setRawValue(newValue);
                                        }

                                        if ((!KS.loadAllPages && newValue > th.maxValue) || newValue === me.pageSize) return false;

                                        me.store.pageSize = newValue;
                                        me.pageSize = newValue;
                                        me.doRefresh();

                                        var view = me.store.grid.parentView;

                                        view.serverCall({
                                            method: 'SetProfileProperty',
                                            params: [view.controlID + 'PageSize', newValue]
                                        });
                                    },
                                    buffer: 500
                                }
                            }
                        }),
                    {
                        xtype: 'tbtext',
                        itemId: 'filterTextCount',
                        hidden: true,
                        html: '<div style="color:red;">Применён фильтр. Показано записей: COUNT</div>'
                    });

                return pagerItems.concat(baseItems);
            },

            getPageData: function() {
                var store = this.store,
                    totalCount = store.getTotalCount(),
                    pageSize = store.pageSize === -1 && KS.useTotalLabelOnLoadAllPages ? totalCount : store.pageSize,
                    fromRecord = ((store.currentPage - 1) * pageSize) + 1;
                if (fromRecord < 0) fromRecord = 0;
                return {
                    total: totalCount,
                    currentPage: store.currentPage,
                    pageCount: Math.ceil(totalCount / pageSize),
                    fromRecord: fromRecord,
                    toRecord: Math.min(store.currentPage * pageSize, totalCount)
                };
            }
        });

    // ============= PUBLIC =======================
    KS.apply(KS.Ext.Grid.prototype,
        {
            addFeature: function (feature) {
                if (!Ext.isArray(this.features))
                    this.features = [];
                this.features.push(feature);
            },

            isPagingEnabled: function() {
                return (this.getBand().PageSize > 0);
            },

            getBand: function() {
                if (this.gridSettings && !Ext.isEmpty(this.gridSettings.Band))
                    return this.gridSettings.Band[0];
                return null;
            },

            getAnyCase: function(rec, field) {
                if (!rec || !field) return null;
                return rec.get(field) || rec.get(field.toLowerCase()) || rec.get(field.toUpperCase());
            },

            getCloseCode: function(rec) {
                return this.getAnyCase(rec, this.closeCode) || null;
            },

            resetGrid: function() {
                if (this.enablePaging === false) {
                    this.store.loadDataPage(1, this.jsonData);
                    this.gridLoaded = true;
                    return;
                }
                if (!this.gridLoaded) {
                    this.store.load({
                        params: {
                            start: 0,
                            limit: this.getBand().PageSize
                        }
                    });
                    this.gridLoaded = true;
                } else {
                    this.resetPage();
                }
            },

            reload: function(json) {
                var store = this.getStore();
                store.resetData();
                if (!Ext.isEmpty(json)) {
                    store.loadDataPage(store.currentPage, json);
                } else {
                    store.loadPageFromServerTemplate(store.currentPage);
                }
            },

            setValue: function(json) {
                var store = this.getStore();
                store.loadDataPage(store.currentPage, json);
            },

            resetPage: function() {
                this.cachedPages = [];
                if (!this.ksObjs.pagingBar) return;
                var t = this.ksObjs.pagingBar, // this.getDockedItems('toolbar[dock="bottom"]')[0],
                    activePage = this.getActivePage();

                if (activePage > 1)
                    t.moveFirst();
                else {
                    this.store.resetData();
                    this.store.loadPageFromServerTemplate(activePage);
                }
            },

            getActivePage: function() {
                var t = this.ksObjs.pagingBar;
                return t.activePage || Math.ceil((t.cursor + t.pageSize) / t.pageSize);
            },

            eachColumnCfg: function(fn) {
                var grid = this;
                Ext.each(this.getColumns(),
                    function(cfg, idx) {
                        if (cfg && typeof (fn) == 'function') {
                            fn.call(grid, cfg, idx);
                        }
                    });
            },

            getColConfigByKey: function(colKey) {
                var result = null;
                this.eachColumnCfg(function(cCfg) {
                    if (cCfg.dataIndex === colKey) {
                        result = cCfg;
                    }
                });
                return result;
            },

            getColCfgByIndex: function(colIndex) {
                return this.getColumns()[colIndex];
            },

            getColIndexByKey: function(colKey) {
                var result = -1;
                Ext.each(this.getColumns(),
                    function(colConfig, i) {
                        if (colConfig.dataIndex === colKey) {
                            result = i;
                        }
                    });
                return result;
            },

            copyToClipBoard: function(rows) {
                this.collectGridData(rows);
                KS.copyToClipBoard(this.tsvData);
            },

            collectGridData: function(cr) {
                var row1 = cr[0], col1 = cr[1], row2 = cr[2], col2 = cr[3];
                this.tsvData = '';
                var rowTsv;
                for (var r = row1; r <= row2; r++) {
                    if (this.tsvData != '') {
                        this.tsvData += '\n';
                    }
                    rowTsv = '';
                    for (var c = col1; c <= col2; c++) {
                        if (rowTsv != '') {
                            rowTsv += '\t';
                        }
                        rowTsv += this.store.getAt(r).get(this.getColumns()[c].dataIndex); 
                    }
                    this.tsvData += rowTsv;
                }
                return this.tsvData;
            },

            pasteFromClipBoard: function() {
                if (!this.hiddentextarea) {
                    this.hiddentextarea = new Ext.Element(document.createElement('textarea'));
                    this.hiddentextarea.setStyle('position', 'absolute');
                    this.hiddentextarea.setStyle('top', '-1000');
                    this.hiddentextarea.addListener('keyup', this.updateGridData, this);
                    Ext.get(document.body).appendChild(this.hiddentextarea.dom);
                }
                this.hiddentextarea.dom.value = '';
                this.hiddentextarea.focus();
            },

            updateGridData: function() {
                //debugger;
                var record = Ext.data.Record.create(this.getColumns());
                var tsvData = this.hiddentextarea.getValue();
                tsvData = tsvData.split('\n');
                var cr = this.getSelectionModel().getSelected().getRange();
                var nextIndex = cr[0][1];
                var gridTotalRows = this.store.getCount();
                for (var rowIndex = 0; rowIndex < tsvData.length; rowIndex++) {
                    if (tsvData[rowIndex].trim() == '') {
                        continue;
                    }
                    var columns = tsvData[rowIndex].split('\t');
                    if (nextIndex > gridTotalRows - 1 && !this.pasteWithHandler) {
                        var newRecord = new record({});
                        this.stopEditing();
                        this.store.insert(nextIndex, newRecord);
                    }
                    var pasteColumnIndex = cr[1][0];
                    for (var columnIndex = 0; columnIndex < columns.length; columnIndex++) {
                        var item = this.getColumns()[pasteColumnIndex];
                        if (item) {
                            if (this.pasteWithHandler) {
                                this.fireEvent('pastecellvalue', nextIndex, item.dataIndex, columns[columnIndex]);
                            } else {
                                this.store.getAt(nextIndex).set(item.dataIndex, columns[columnIndex]);
                            }
                        }
                        pasteColumnIndex++;
                    }
                    nextIndex++;
                }
                this.fireEvent('afterpaste');
                this.hiddentextarea.blur();
            },

            addRecord: function(valuesDict) {
                var store = this.getStore(),
                    proxy = store.proxy,
                    newRec = store.add(valuesDict);
                
                // для bug 175852
                // почему то данные в прокси не обновляются после store.add
                if (proxy && proxy.data && proxy.data.total !== store.data.length) {
                    proxy.data.rows.push(valuesDict);
                    proxy.data.total += 1;
                    if (!Ext.isEmpty(proxy.data.totalCountByTable)) {
                        proxy.data.totalCountByTable += 1;
                    }
                }
                
                return newRec[0] || null;
            },

            removeRecords: function(r) {
                if (KS.isEmpty(r)) return;
                if (KS.isString(r)) {
                    var rec = this.findRecord(r);
                    if (rec) {
                        r = rec;
                    } else {
                        return;
                    }
                }
                this.getStore().remove(r);
            },

            findRowByField: function (field, value) {
                return this.findRecord(value, field);
            },

            findRecord: function(value, colKey, isColKeyCaseSensitive = true) {
                if (!KS.isString(colKey) || KS.isEmpty(colKey)) {
                    colKey = this.closeCode;
                }
                var foundRecs = [];
                this.getStore().each(function(rec) {
                    if (isColKeyCaseSensitive) {
                        if (rec.get(colKey) == value) {
                            foundRecs.push(rec);
                        }
                    }
                    else {
                        if (rec.get(colKey.toLowerCase()) == value ||
                            rec.get(colKey.toUpperCase()) == value) {
                            foundRecs.push(rec);
                        }
                    }
                });
                return foundRecs[0] || null;
            },

            getSelectedRecs: function() {
                return this.getSelectionModel().getSelection();
            },

            getSelectedRows: function() {
                return this.getSelectionModel().getSelection();
            },

            selectLine: function(colKey, value, selectColNum) {
                var grid = this,
                    idx = grid.getStore().find(colKey, value);
                if (idx == -1) {
                    grid.deferredSelectLine = { colKey: colKey, value: value, selectColNum: selectColNum };
                } else {
                    grid.deferredSelectLine = null;
                    grid.getSelectionModel().clearSelections();
                    grid.getSelectionModel().select(idx, selectColNum);
                }
            },

            select: function(rowIdx, colIdx) {
                var sm = this.getSelectionModel();
                if (Ext.isFunction(sm.select)) {
                    sm.select(rowIdx, colIdx); // CellSelectionModel
                } else if (Ext.isFunction(sm.selectRow)) {
                    sm.selectRow(rowIdx); // RowSelectionModel
                }
            },

            createHideButton: function() {
                return Ext.create('Ext.Button',{
                        icon: 'images/ColumnChooser.png',
                        tooltip: KS.L10n.columnVisibilitySettings,
                        scope: this,
                        handler: this.hideButtonHandler
                    });
            },

            hideButtonHandler: function() {
                var grid = this,
                    items = [],
                    ww = Math.max(400, KS.rootViewport.getWidth() / 3),
                    maxHeight = Math.max(100, KS.rootViewport.getHeight() / 1.5);
                grid.eachColumnCfg(
                    function (column) {
                        if (column.visibility && column.width > 0 && 
                            !KS.isEmpty(column.dataIndex) && column.dataIndex !== 'CHECKED') {
                            var label = column.text;
                            if (typeof (grid.getFilterString) == 'function') {
                                label = grid.getFilterString(column.dataIndex);
                            }
                            items.push({
                                boxLabel: label,
                                padding: "0 0 0 10",
                                margin: 0,
                                itemId: "id_"+column.dataIndex,
                                anchor: "95% -53",
                                height: 25,
                                checked: !column.hidden
                            });
                        }
                    });
                if (Ext.isEmpty(items)) return;
                var estimatedWinHeight = 70 + 25 * items.length,
                    autoHeight = (estimatedWinHeight <= maxHeight);
                grid.hideFilter = new Ext.Window({
                    title: KS.L10n.columnsVisibility,
                    autoScroll: true,
                    modal: true,
                    plain: true,
                    width: ww,
                    height: autoHeight ? estimatedWinHeight : maxHeight,
                    maxHeight: maxHeight,
                    autoHeight: autoHeight,
                    minHeight: 300,
                    defaultType: 'checkbox',
                    items: items,
                    buttonAlign: 'center',
                    buttons: new Array({
                            text: KS.L10n.save,
                            cls: 'marked-button',
                            handler: function () {
                                grid.eachColumnCfg(
                                    function (column) {
                                        var field = grid.hideFilter.getComponent("id_"+column.dataIndex);
                                        if (field && Ext.isFunction(field.getValue)) {
                                            column.setHidden(!field.getValue());
                                        }
                                    });
                                grid.hideFilter.hide();
                                var view = grid.parentView;
                                if (view && typeof (view.saveSettings) == 'function') {
                                    setTimeout(function () {
                                        view.saveSettings();
                                    }, 100);
                                }
                            }
                        },
                        {
                            text: KS.L10n.close,
                            cls: 'dim-button',
                            handler: function () {
                                grid.hideFilter.hide();
                            }
                        })
                });
                grid.hideFilter.show();
            },

            getControlState: function (dict, evtName, evtArgs) {
                
                var checkedCodes = this.getCheckedCodes(),
                    activeCode = checkedCodes[0] ? String(checkedCodes[0]) : null,
                    selection = this.getSelection(),
                    state = KS.apply(dict || {},
                        {
                            checkedCodes: checkedCodes,
                            activeCode: activeCode,
                            activeRowIndex: selection.length ? this.store.indexOf(selection[0]) : 0
                        });
                switch(evtName) {
                    case 'celldblclick':
                        var e = evtArgs ? evtArgs[6] : null;
                        if (e && e.position && e.position.column) {
                            state.activeColumn = e.position.column.dataIndex;
                        }
                        break;
                }
                return state;
            },

            moveClass: function() {
            },

            expandRow: function(rowIdx) {
                var expander = this.getPlugin('rowexpander');
                expander.toggleRow(rowIdx, this.getStore().getAt(rowIdx));
            },

            setSBText: function(selCount, checkCount, filterCount, totalCount) {
                var me = this,
                    pagingBar = me.ksObjs.pagingBar,
                    fbl = pagingBar && pagingBar.getComponent('filterTextCount');

                //if (sbl) {
                //    if (!sbl.rendered) {
                //        f1 = true;
                //        sbl.rendered = true;
                //    }
                //    if (sbl.allCount !== allCount) {
                //        sbl.allCount = allCount;
                //        sbl.setText('Количество записей: ' + allCount);
                //    }
                //    if (f1) sbl.rendered = false;
                //}

                //if (sbr) {
                //    if (me.checkModel) chText = 'Отобрано: ' + checkCount + ' ';
                //    if (!sbr.rendered) {
                //        f2 = true;
                //        sbr.rendered = true;
                //    }

                //    selCount = selCount || me.getSelectionModel().getSelection().length;
                //    chText += 'Выделено: ' + selCount;
                //    if (sbr.chText !== chText) {
                //        sbr.chText = chText;
                //        sbr.setText(chText);
                //    }
                //    if (f2) sbr.rendered = false;
                //}

                //var btns = me.ksObjs.tbarBtns;
                //if (btns)
                ////Если не может найти protoEl у btn значит что то не так. проверку на существование btn.protoEl тут добавлять нельзя
                //    Ext.each([btns.treeadd, btns.copy, btns.edit, btns.delete, btns.showRelations, btns.treechange],
                //        function(btn) { btn && btn.setDisabled(!selCount); });

                if (fbl) {
                    var fblVisible = Ext.isNumber(filterCount) && filterCount !== 0;

                    fbl.setVisible(fblVisible);

                    if (fblVisible && filterCount > 0) {
                        var filterText = '<div style="color:red;padding-left:5px;">' +
                            KS.L10n.filteredShowing + ': ' + filterCount +
                            ' (' + KS.L10n.total + ': ' + (me.store.totalCount) + ')' + '</div>';
                        fbl.setText(filterText);
                    }
                }
            },

            getOrder: function(operation) {
                if (!(operation && operation.sorters && operation.sorters.length)) return '';
                var me = this,
                    s = operation.sorters[0],
                    res = { name: s.property, type: s.direction };

                if (['M', 'MAIN'].indexOf(s.property) !== -1) {
                    var mlinks = [],
                        mains = [];
                    Ext.each(me.checkList,
                        function(rec) {
                            var b = rec.data || rec,
                                l = b[me.fieldLink];
                            if (l) {
                                mlinks.push(l);
                                if (b.MAIN) mains.push(l);
                            }
                        });
                    res.mlink = JSON.stringify(mlinks);
                    res.main = JSON.stringify(mains);
                }
                return JSON.stringify(res);
            },

            getFilter: function(grid) {
                var me = grid || this;
                if (me.enableLocking && !KS.forceGridHandlersOnLockableMainGrid) me = me.normalGrid;
                if (!me.filter) return '[]';
                if (me.filter.asString) return me.filter.asString;

                var res = [];
                Ext.each(me.filter,
                    function(el) {
                        if (el.Condition !== null && el.Condition !== -1 && el.Value !== null) {
                            res.push({
                                Name: el.Name,
                                Condition: el.Condition,
                                Value: me.getFilterValue(el)
                            });
                        }
                    });

                return me.filter.asString = JSON.stringify(res);
            },

            //#region редактирование файла

            fileEdit: function(rec) {
                var me = this,
                    view = me.parentView,
                    column = me.getColumnManager().getHeaderByDataIndex(me.fieldExt),
                    accept;

                if (column.tag)
                    accept = column.tag.accept;
                
                if (KS.FileWindow && KS.FileWindow.isVisible()) {
                    return null;
                }

                KS.FileWindow = Ext.create('KS.Ext.FileWindow',
                    {
                        accept: accept,
                        iconCls: KS.getExtStyle(rec.get(me.fieldExt)),
                        saveFilesCallback: function(grid, fileView, file, fileIndex) {
                            let hasFileIndex = !Ext.isEmpty(fileIndex),
                                record;

                            if (!hasFileIndex) {
                                record = rec;
                            } else {
                                record = grid.store.getAt(grid.store.indexOf(rec) + fileIndex);

                                if (KS.addNextMultipleFilesToEmptyRowCells && fileIndex > 0) {
                                    if (!Ext.isEmpty(record?.get(me.fieldExt))) {
                                        record = null; // добавляем в новую строку
                                    }
                                }
                            }
                            
                            if (record) {
                                record.set(me.fieldExt, file.name);
                                me.ksObjs.files[record.id] = file;
                            }
                            
                            file.columnId = me.fieldExt;
                            fileView.enableBtns();

                            if (fileView.closeAfterLoad && (hasFileIndex ? fileIndex === fileView.btnSend.getFileList().length-1 : true))
                                fileView.close();
                        },
                        getFileId: function() {
                            return rec.get(me.fieldExt);
                        },
                        parentView: view,
                        ctrlId: me.ctrlId,
                        grid: me
                    });
            },

            //#endregion редактирование файла

            disable: function() {
                //this.stopEditing();
                //this.getTopToolbar().disable();
            },

            enable: function() {
                //this.getTopToolbar().enable();
            },

            //---------------------------------------------------------------------------------------------
            // Make Ext.grid.column.Column array from gridSettings
            makeColumns: function (grid) {
                var band = grid.getBand(),
                    ctrl = grid.ctrl,
                    columns = [];

                grid.checkedColumnIdx ??= -1;
                grid.hasEditableColumns = false;

                if (band.rowNumberer && band.selection !== 3) {
                    Ext.Array.insert(band.Column, 0, [{
                        xtype: 'rownumberer',
                        minWidth: 50,
                        visibility: true
                    }]);
                }

                //if (gridCfg.fitColumns) gridCfg.viewConfig = { scrollOffset: 0, forceFit: gridCfg.fitColumns };
                band.firstOrder = 1;
                band.lastOrder = 1;
                Ext.each(band.Column, configureColumn, grid);
                Ext.each(ctrl.columnHeaderGroups, addColumnGroup(0, grid), grid);

                Ext.each(band.Column,
                    function(col) {
                        if (grid.groupedColumns && jQuery.inArray(col.order, grid.groupedColumns) >= 0 && !(col.tag && col.tag.fixed)) {
                            var group = null;
                            Ext.each(grid.headGroups,
                                function(hg) {
                                    if (hg.leafColumns && jQuery.inArray(col.order, hg.leafColumns) >= 0)
                                        group = hg;
                                });
                            if (group && !group.added) {
                                columns.push(group);
                                group.added = true;
                            }
                            var headerColumn = findLeafColumn(group, col.dataIndex);
                            if (headerColumn) mergeColumnProps(col, headerColumn);
                        } else {
                            columns.push(col);
                        }
                    });

                if (grid.hasEditableColumns) {
                    var cfg = {
                        ptype: 'cellediting',
                        id: 'cellediting'
                    };
                    if (ctrl.clicksToEdit > 0) {
                        cfg.clicksToEdit = ctrl.clicksToEdit;
                    }
                    grid.addPlugin(cfg);
                }

                return columns;
            }
        });
    
    Ext.override(Ext.panel.Table, {
        resolveEditor: function(col) {
            return resolveEditor(col, this);
        }
    });

    // ============= RENDERERS =======================
    // ReSharper disable UnusedLocals
    function dummyRenderer(value) {
        return value;
    }

    function autoSizeColumns() {
        Ext.each(this.columns, function (column) {
            column.autoSize();
        });
    }

    function sizeRenderer(value) {
        return KS.Ext.formatSize(value);
    }

    function tooltipRenderer(value, metadata) {
        setTooltip(metadata, value);
        return value;
    }

    function checkedRenderer(value) {
        return (value === true || value.toLowerCase() == 'true' || value == '1');
    }

    window.setTooltip = function(metadata, text /*, title*/) {
        if (KS.isEmpty(text)) {
            return;
        }
        metadata.tdAttr = 'data-qtip="' + text.replace(/"/g, "'") + '"';
    }

    function checkboxRenderer(value) {
        return Ext.grid.column.Check.prototype.defaultRenderer.apply(this, arguments);
    }

    // ReSharper restore UnusedLocals

    // ============= EDITORS =======================
    Ext.define('KS.Ext.Grid.numberEditor',
        {
            extend: 'Ext.form.NumberField',
            allowBlank: false,
            allowDecimals: false,
            allowNegative: false,
            style: 'text-align:right'
        });

    Ext.define('KS.Ext.Grid.textEditor',
        {
            extend: 'Ext.form.field.TextArea',
            allowBlank: true,
            enterIsSpecial: true,
            //selectOnFocus: false,
            style: 'text-align:center'
        });

    Ext.define('KS.Ext.Grid.dateEditor',
        {
            extend: 'Ext.form.field.Date',
            allowBlank: true,
            //selectOnFocus: false,
            style: 'text-align:center',
            format: 'd.m.Y',
            altFormats: 'd.m.Y',
            disabledDays: []
        });

    Ext.define('KS.Ext.Grid.checkboxEditor',
        {
            extend: 'Ext.form.field.Checkbox',
            listeners: {
                checkchange: {
                    fn: function (cbx, newValue, oldValue, e) {
                        return true;
                    },
                    scope: this,
                    single: false
                }
            }
        });

    // ============= PRIVATE ======================================================================
    function setEventHandlers(grid) {
        if (grid.isPagingEnabled && grid.isPagingEnabled()) {
            // https://bugzilla.keysystems.ru/bugzilla/show_bug.cgi?id=149894
            // Если настроено несколько сортировок, событие sortchange не срабатывает
            // если на колонке которую кликнули не поменялось направление сортировки
            grid.on('headerclick', sortChangeHandler, grid);
            grid.on('sortchange', sortChangeHandler, grid);
        }
        grid.on('filterchanged', onKsFilterChange, grid);
        grid.on('valuesfilterchanged', onKsValuesFilterChange, grid);
        //grid.on('beforecellclick', function() { return !this.readOnly; }, grid);
    }

    function sortChangeHandler(header, column, e) {
        // при клике на чекбокс не сортируем
        if ($(e.target).hasClass('x-column-header-checkbox'))
            return;
        
        var me = this,
            store = me.getStore(),
            lastSort = me.lastSort;

        //#region Дополнение к багу https://bugzilla.keysystems.ru/bugzilla/show_bug.cgi?id=149894
        // Если настроено несколько сортировок, событие sortchange не срабатывает
        // если на колонке которую кликнули не поменялось направление сортировки
        // чтобы не срабатывало 2 события сразу, добавляем проверку на
        // последние аргументы сортировки
        if (column.columnSettingsView) {
            return;
        }

        if (lastSort)
            if (lastSort.dataIndex === column.dataIndex && lastSort.sortState === column.sortState)
                return;

        me.lastSort = {
            dataIndex: column.dataIndex,
            sortState: column.sortState
        };
        //#endregion
        if (store.remoteSort && !store.preventRemoteSort) {
            this.store.loadPageFromServerTemplate(1);
        }
    }

    function onKsFilterChange(column, val, comboVal) {
        var //comboVal = comboVal,// || this.iconCombo.getValue(),
            grid = this,
            filterVal = val, // || this.iconCombo.getValue(),
            filterProp = column.property || column.dataIndex,
            store = grid.store,
            filters = store.filters.items,
            ind = KS.Array.find(filters, ['_property'], column.dataIndex),
            stringCompare = function (val, filterVal) {
                return !Ext.isEmpty(val) && val.toString().toLowerCase().indexOf(filterVal.toString().toLowerCase());
            };

        if (comboVal === 'valuesFilter') return;

        if (val && Ext.isString(val) && column.aspType === 'combobox' && column.tag && column.tag.isBool)
            val = val.toLowerCase() === 'да' ? '1' : val.toLowerCase() === 'нет' ? '0' : val;

        const filterFeaturePrototype = Ext.grid.feature.Filter.prototype;
        if (filterFeaturePrototype && val === filterFeaturePrototype.nullText || val === filterFeaturePrototype.notNullText || (val === '' && comboVal !== null)) {
            val = 'null';

            if (comboVal != 'is' && comboVal != 'isNot') {
                comboVal = 'is';
            }
        }

        if (ind !== -1) {
            store.removeFilter(filters[ind]);
        } else {
            column.addCls('ks-filterCol');
        }

        // Server-side filter (IIS/Sql)
        if (grid.ctrl.filterMode > 1) {
            if (Ext.isEmpty(val) || val == 'null') {
		        column.removeCls('ks-filterCol');
	        }
            
            if (!grid.filter) {
                grid.filter = {
                    asString: JSON.stringify([])
                }
            }

            var newFilters = [],
	            oldFilters = JSON.parse(grid.filter.asString);
            
            if (comboVal === 'custom') {
                for (var i = 0; i < val.length; i++) {
                    if (!Ext.isEmpty(val[i].value))
                        newFilters.push({
                            Name: filterProp,
                            Condition: val[i].condition,
                            Value: val[i].value
                        });
                }
            } else if (!Ext.isEmpty(val)) {
                newFilters = [{
                    Name: filterProp,
                    Condition: comboVal,
                    Value: val
                }];
            }
            
            // удаляем старые фильтры по колонке
            for (var i = oldFilters.length - 1; i >= 0; i--) {
                if (oldFilters[i].Name === filterProp)
                    oldFilters.splice(i, 1);
            }
            // присваиваем новые фильтры по колонке
            oldFilters = oldFilters.concat(newFilters);

            grid.filter = {
	            asString: JSON.stringify(oldFilters)
            };

            return grid.getStore().loadPageFromServerTemplate(1, grid);
        } else { // Client-side filter (Browser)
	        if (Ext.isEmpty(val)) {
		        column.removeCls('ks-filterCol');
	        } else {
	            var isDate = Ext.isDate(filterVal);
	            
		        var filterFn = Ext.emptyFn,
			        similarity = function(s1, s2) {
				        var longer = s1;
				        var shorter = s2;
				        if (s1.length < s2.length) {
					        longer = s2;
					        shorter = s1;
				        }
				        var longerLength = longer.length;
				        if (longerLength == 0) return 1.0;
				        return (longerLength - editDistance(longer, shorter)) / parseFloat(longerLength);
			        },
			        editDistance = function(s1, s2) {
				        s1 = s1.toLowerCase();
				        s2 = s2.toLowerCase();

				        var costs = new Array();
				        for (var i = 0; i <= s1.length; i++) {
					        var lastValue = i;
					        for (var j = 0; j <= s2.length; j++) {
						        if (i == 0)
							        costs[j] = j;
						        else {
							        if (j > 0) {
								        var newValue = costs[j - 1];
								        if (s1.charAt(i - 1) != s2.charAt(j - 1)) {
									        newValue = Math.min(Math.min(newValue, lastValue),
											        costs[j]) +
										        1;
								        }
								        costs[j - 1] = lastValue;
								        lastValue = newValue;
							        }
						        }
					        }
					        if (i > 0)
						        costs[s2.length] = lastValue;
				        }
				        return costs[s2.length];
			        };
		        
		        newFilters = [];
		        
		        if (comboVal === 'custom') {
                    for (var i = 0; i < val.length; i++) {
                        if (!Ext.isEmpty(val[i].value))
                            newFilters.push({
                                property: filterProp,
                                value: val[i].value,
                                comboVal: val[i].condition
                            });
                    }
                } else if (!Ext.isEmpty(val)) {
                    newFilters.push({
                        property: filterProp,
                        value: filterVal,
                        comboVal: comboVal
                    })
                }		        
		        
                for (var i = 0; i < newFilters.length; i++) {
                    switch (newFilters[i].comboVal) {
                        case 'equals':
                            filterFn = function(item) {
                                var v1 = item.get(filterProp),
                                    v2 = filterVal;

                                return isDate ? v1 - v2 === 0 : v1 === v2;
                            };
                            break;
                        case 'notEquals':
                            filterFn = function(item) {
                                var v1 = item.get(filterProp),
                                    v2 = filterVal;

                                return isDate ? v1 - v2 !== 0 : v1 !== v2;
                            };
                            break;
                        case 'like':
                            filterFn = function(item) {
                                //0.8 - процент "похожести"
                                return similarity(item.get(filterProp), filterVal) > 0.8;
                            };
                            break;
                        case 'startsWith':
                            filterFn = function(item) {
                                return stringCompare(item.get(filterProp), filterVal) === 0;
                            };
                            break;
                        case 'match':
                        case 'contains':
                            filterFn = function(item) {
                                //todo: узнать чем отличается от match
                                var ind = stringCompare(item.get(filterProp), filterVal);
                                return Ext.isNumber(ind) && ind !== -1;
                            };
                            break;
                        case 'endsWith':
                            filterFn = function(item) {
                                var str = item.get(filterProp).toString().toLowerCase();
                                return str.indexOf(filterVal, str.length - filterVal.length) >= 0;
                            };
                            break;
                        case 'doesNotStartsWith':
                            filterFn = function(item) {
                                return stringCompare(item.get(filterProp), filterVal) !== 0;
                            };
                            break;
                        case 'doesNotEndsWith':
                            filterFn = function(item) {
                                var str = item.get(filterProp).toString().toLowerCase();
                                return !(str.indexOf(filterVal, str.length - filterVal.length) >= 0);
                            };
                            break;
                        case 'doesNotContains':
                        case 'doesNotMatch':
                            filterFn = function(item) {
                                //todo: узнать чем отличается от match
                                var ind = stringCompare(item.get(filterProp), filterVal);
                                return Ext.isNumber(ind) && ind === -1;
                            };
                            break;
                        case 'notLike':
                            filterFn = function(item) {
                                //0.8 - процент "похожести"
                                return similarity(item.get(filterProp), filterVal) < 0.8;
                            };
                            break;
                        case 'lessThan':
                            filterFn = function(item) {
                                var number = item.get(filterProp) * 1;
                                return number < filterVal * 1;
                            };
                            break;
                        case 'lessThanOrEqualTo':
                            filterFn = function(item) {
                                var number = item.get(filterProp) * 1;
                                return number <= filterVal * 1;
                            };
                            break;
                        case 'greaterThan':
                            filterFn = function(item) {
                                var number = item.get(filterProp) * 1;
                                return number > filterVal * 1;
                            };
                            break;
                        case 'is':
                            filterFn = function(item) {
                                return Ext.isEmpty(item.get(this.getProperty()));
                            };
                            break;
                        case 'isNot':
                            filterFn = function(item) {
                                return !Ext.isEmpty(item.get(this.getProperty()));
                            };
                            break;
                        case 'greaterThanOrEqualTo':
                            filterFn = function(item) {
                                var number = item.get(filterProp) * 1;
                                return number >= filterVal * 1;
                            };
                            break;
                    }
                    
                    newFilters[i].filterFn = filterFn;
                }

                store.filter(newFilters);

		        
	        }

	        //Применяем только для линейных, у древовидных свое
	        if (!store.tree) {
                var selCount = grid.getSelectionModel().getSelection().length;
                grid.setSBText && grid.setSBText(selCount, 0, !store.filters.length || grid.totalData === store.data.length ? false : store.data.length, selCount);
	        }
        }
    }

    function onKsValuesFilterChange(column, filter) {
        var grid = this,
            filterProp = column.property || column.dataIndex,
            store = grid.store,
            filters = store.filters.items,
            ind = KS.Array.find(filters, ['_property'], column.dataIndex),
            filterValue = filter.filterValue,
            filterType = 'valuesFilter';

        if (ind !== -1) {
            store.removeFilter(filters[ind]);
        } else if (filterValue) {
            column.addCls('ks-filterCol');
        }

        if (!grid.filter) {
            grid.filter = {
                asString: JSON.stringify([])
            };
        }

        var oldFilters = JSON.parse(grid.filter.asString),
            filterInd = KS.Array.find(oldFilters, ['Name'], filterProp);

        if (filterInd === -1) {
            oldFilters.push({
                Name: filterProp,
                Condition: filterType,
                Value: filterValue
            });
        } else {
            if (Ext.isEmpty(filterValue)) {
                oldFilters.splice(filterInd, 1);
                var columnFilter = Ext.Array.findBy(oldFilters,
                    function (filter) {
                        return filter.Name === column.key;
                    });
                if (Ext.isEmpty(columnFilter)) {
                    column.removeCls('ks-filterCol');
                }
            } else {
                oldFilters[filterInd] = {
                    Name: filterProp,
                    Condition: filterType,
                    Value: filterValue
                }
            }
        }

        grid.filter = {
            asString: JSON.stringify(oldFilters)
        };

        grid.filterValue = filterValue;

        if (grid.ctrl.filterMode > 1) { // Server-side filter (IIS/Sql)
            return grid.getStore().loadPageFromServerTemplate(1, grid);
        } else { // Client-side filter (Browser)
            Ext.Array.each(store.filters.items, function (filter, index){
                store.removeFilter(filter._id);
            });

            if (filterValue.length > 0 && !Ext.Array.contains(filterValue, 'Все')) {
                Ext.Array.each(filterValue, function (value, index) {
                    if (value === 'Пустые') {
                        filterValue[index] = '';
                    }
                });

                var filterFn = function (item) {
                    var number = item.get(filterProp);
                    return Ext.Array.contains(filterValue, number);
                };

                store.filter({
                    filterFn: filterFn
                });
            }

            //Применяем только для линейных, у древовидных свое
            if (!store.tree) {
                var selCount = grid.getSelectionModel().getSelection().length;
                grid.setSBText && grid.setSBText(selCount, 0, grid.totalData === store.data.length ? false : store.data.length);
            }
        }
    }

    function ksCheckModelSelectionChange(th, selected) {
        var grid = this.store.grid;
        Ext.each(selected,
            function(rec) {
                grid.checkRecord(rec, true);
            });

        var uncheckedRecs = KS.Array.diffArrays(grid.checkList, this.selected.items);

        Ext.each(uncheckedRecs,
            function(rec) {
                grid.checkRecord(rec, false);
            });

        grid.confirmCheckSelection(selected);
    }

    function findLeafColumn(group, dataIndex) {
        if (!group || !dataIndex) return null;
        if (KS.isEmpty(group.columns)) {
            if (group.dataIndex === dataIndex) return group;
        } else {
            for (var idx in group.columns) {
                if (group.columns.hasOwnProperty(idx)) {
                    var child = group.columns[idx],
                        childAsLeaf = findLeafColumn(child, dataIndex);
                    if (childAsLeaf) return childAsLeaf;
                }
            }
        }
        return null;
    }

    function mergeColumnProps(col, hCol) {
        if (!col || !hCol) return;
        if (KS.isFunction(col.renderer) && KS.isEmpty(hCol.renderer)) {
            hCol.renderer = col.renderer;
        }
    }

    //groupLevel - параметр, определяещий глубину всех групп. по умолчанию 0.
    //введен на случай, когда внутри группы есть колонки с группами (3 и далее уровень)
    //не требует ручного указания, изменяется при помощи итерации внутри метода ++groupLevel
    //grid - тот грид в котором создаем группы колонок
    function addColumnGroup(groupLevel, grid) {
        var band = grid.getBand(),
		    currentGroupLevel = (grid.ctrl.groupLevel || 0);

        //Определяем максимальную глубину групп
        currentGroupLevel = currentGroupLevel < groupLevel ? groupLevel : currentGroupLevel;
        grid.ctrl.groupLevel = currentGroupLevel;

        return function (col) {
            var isGroup = !KS.isEmpty(col.children);

            if (col.parentGroup && col.parentGroup.tag && col.parentGroup.tag.isRequired || col.tag && col.tag.isRequired)
                col.cls += ' dark-red-text';

            //#region https://bugzilla.keysystems.ru/bugzilla/show_bug.cgi?id=170329
            // todo: дополнить условия сокрытия, если все дочерние элементы скрыты, то нужно скрывать и родительский
            col.hidden = col.children && col.children.length === 0;
            //#endregion
            
            if (col.tag) {
                col.textContainerElHeight = col.tag.height > 0 && col.tag.height;
            }
            
		    if (isGroup) {
                col.tooltip = col.header;
			    col.columns = col.children?.filter(x => !x.tag?.fixed);
                col.minWidth = 0;
                col.stateId = col.key + '_group';

                if (col.tag && col.tag.headerStyle) {
                    if (col.style)
                        col.style = col.style + col.tag.headerStyle;
                    else
                        col.style = col.tag.headerStyle;
                }

			    Ext.each(col.columns, function(subCol) { subCol.parentGroup = this; }, col);
			    Ext.each(col.columns, addColumnGroup(++groupLevel, grid), grid);
			    if (KS.isEmpty(col.parentGroup)) {
				    if (KS.isEmpty(grid.headGroups)) grid.headGroups = [];
				    grid.headGroups.push(col);
			    }
			    delete col.dataIndex;
			    delete col.width;
			    delete col.children;
		    } else {
			    if (KS.isEmpty(grid.groupedColumns)) grid.groupedColumns = [];

			    var parentGroup = col.parentGroup;
			    if (parentGroup) {
                    while (!KS.isEmpty(parentGroup.parentGroup)) {
                        parentGroup = parentGroup.parentGroup;
                    }
                    if (KS.isEmpty(parentGroup.leafColumns)) {
                        parentGroup.leafColumns = [];
                    }
                    if (grid.forceFit) {
                        parentGroup.minWidth += col.minWidth ?? 0;
                    }
			    }

			    var bandCol = null;
                Ext.each(band.Column,
                    function(bc) {
                        if (bc.dataIndex === col.dataIndex) bandCol = bc;
                    });
                if (bandCol && parentGroup) {
				    parentGroup.leafColumns.push(bandCol.order);
				    grid.groupedColumns.push(bandCol.order);
                    KS.apply(col, bandCol);
                }
		    }
	    }
    }

    function configureColumn(col, ci) {
        var grid = this,
            ctrl = grid.ctrl,
            band = grid.getBand();

        col.hidden = (col.visibility !== true);
        col.order = ci + 1;
        col.tooltip = col.header;
        col.ksRenderers = [];
        col.grid = grid;
        col.filterType = col.tag?.filterType;
        col.stateId = col.key;
        
        if (col.width === 0) {
            col.width = undefined;
        }  
        
        if (col.sortable && Ext.isFunction(grid.remoteSorterFn) && Ext.isFunction(grid.isPagingEnabled) && grid.isPagingEnabled() && KS.forceColumnRemoteSortOnPagingEnabled === true) {
            // отображаем точно так, как пришло с сервера
            // обязательно нужно указать id
            col.sorter = col.sorting ? new Ext.util.Sorter({
                id: col.dataIndex,
                direction: col.sorting,
                sorterFn: grid.remoteSorterFn
            }) : {
                id: col.dataIndex,
                sorterFn: grid.remoteSorterFn,
                isFakeSorter: true // если true, то не надо добавлять в инициализацию сортировки в store (makeSorters)
            };
        } else if(col.sortable && col.sorting) {
            col.sorter = new Ext.util.Sorter({
                id: col.dataIndex,
                property: col.dataIndex,
                direction: col.sorting
            });
        }

        if (!col.hidden) {
            if (col.order < band.firstOrder) band.firstOrder = col.order;
            if (col.order > band.lastOrder) band.lastOrder = col.order;
            col.tooltip = col.header;
        }

        if (!col.visibility) {
            col.hideable = false;
        }

        if (col.dataIndex === band.autoExpandColumn || ctrl.forceFitColumns)
            col.flex = 1;

        if (col.dataIndex === 'CHECKED') {
            grid.checkedColumnIdx = ci;
            col.dataType = 'Boolean';
            col.aspType = 'checkcolumn';
            col.hideable = false;
            if (band.selection !== 2) {
                col.hidden = true;
                grid.phantomCheckedColumn = true;
            }
        }

        resolveRenderer(col);

        if (col.dataType == 2 || col.dataType === 'system.boolean' && !KS.isFunction(col.renderer)) {
            col.aspType = "checkcolumn";
        }

        if (col.dataType === 'system.datetime') {
            col.format ??= col.aspType === "date_with_time" ? 'd.m.Y H:i:s' : 'd.m.Y';
            col.aspType = "datecolumn";
            col.xtype = "datecolumn";
        }

        switch (col.align) {
        case 1:
        case 'left':
            col.align = 'left';
            break;
        case 2:
        case 'center':
            col.align = 'center';
            break;
        case 3:
        case 'right':
            col.align = 'right';
            break;
        default:
            if (col.aspType === "checkcolumn")
                col.align = 'center';
            break;
        }

        buildColumnFilter(col);

        switch (col.aspType) {
        case 'checkbox':
            col.xtype = 'checkcolumn';
            col.disabled = !col.editable;
            col.dataType = 'system.boolean';
            //col.renderer = checkboxRenderer || Ext.grid.column.Check.prototype.defaultRenderer;
            break;
        case 'checkcolumn':
            col.xtype = 'checkcolumn';
            delete col.renderer;
            if (!col.editable && !col.hidden) {
                col.listeners = {
                    beforecheckchange: function(column, rowIndex, checked, record) {
                        var store = record.store || record.getTreeStore(),
                            grid = store.grid;
                        
                        if (grid.ctrl.uncheckBySelect) {
                            grid.select(rowIndex);
                        } else {
                            var checkList = grid.checkRecord(record, checked);
                            grid.getSelectionModel().doMultiSelect(checkList, true);
                        }
                        return false;
                    }
                };
            }
            break;
        case 'datecolumn':
            col.xtype = 'datecolumn';
            col.format = col.format || 'd.m.Y';
            col.renderer = col.renderer || resolveRendererDateCol;
            col._defaultRenderer = resolveRendererDateCol;
            col.exportRenderer = Ext.grid.column.Date.prototype.defaultRenderer;
            break;
        }

        if (col.multiLine) {
            col.tdCls = 'ks-multiline-row';
            col.variableRowHeight = true;
        }
        
        if (col.tag) {
            if (col.tag.isfiltered) col.cls += ' ks-icon-filter ks-isfiltered ';
            if (col.tag.isRequired) {
                col.require = col.tag.isRequired;
                col.cls += ' dark-red-text ';
            }
            //if (col.tag.height) col.height = col.tag.height;
            
            if (!col.style)
                col.style = "";
            
            col.locked = col.tag.fixed;
            
            col.style = col.style + col.tag.headerStyle;
            
            col.ignoreCopy = col.tag.ignoreCopy;
            
            if (col.tag.rowEditorDataIndex) {
                grid.hasEditableColumns = true;
                col.rowEditorDataIndex = col.tag.rowEditorDataIndex;
                col.getEditor = function(record) {
                    if (!record)
                        return this.field;
                    
                    var _grid = this.up('grid[ownerLockable=undefined]'),
                        editorConfig = JSON.parse(record.get(this.tag.rowEditorDataIndex)),
                        value = record.get(this.dataIndex),
                        editor;
                    
                    editor = _grid.resolveEditor(editorConfig);
                    
                    if (value)
                        editor.setValue(value);
                    
                    editor.getValue = function() {
                        return this.getRawValue();
                    };
                    
                    editor.dataIndex = this.dataIndex;
                    editor.rowEditorConfig = editorConfig;
                    this.field = editor;
                    return editor;
                };
            }
            
            if (col.editable && col.tag.isHyperLink) {
                col.editor = 'KS.Ext.Hyperlink';
            }
        }
        
        if (grid.resolveEditor(col, grid)) grid.hasEditableColumns = true;
        if (Ext.isNumber(grid.headerHeight))
           col.height = grid.headerHeight;

        //Отображение дополнительных символов порядка сортировки в шапке колонки
        if (col.sorting_order > 0) {
            col.dirtyText = col.sorting_order;
        }
    }

    function resolveRenderer(col) {
        try {
            if (col.renderer) {
                if (Ext.isArray(col.renderer)) {
	                var renderersArray = col.renderer;
                    
                    col.renderer = function (val) {
	                    var th = this,
		                    savedArgs = arguments;

                        Ext.each(renderersArray,
                            function (fn) {
                                val = fn.apply(th, savedArgs);
                            });

                        return val;
                    }
                } else if (Ext.isString(col.renderer)) {
                    if (col.renderer.indexOf(',') !== -1) {
                        var renderers = col.renderer.split(',');
                        col.renderer = eval(renderers[0]);
                        col.summaryRenderer = eval(renderers[1]);
                    } else 
	                    col.renderer = eval(col.renderer);
                }
            }

            if (col.tag && col.tag.isWrap) {
                if (col.renderer) col.ksRenderers.push(col.renderer);
                col.renderer = function(val, meta) {
                    var th = this,
                        savedArgs = arguments;

                    Ext.each(col.ksRenderers,
                        function(fn) {
                            val = fn.apply(th, savedArgs);
                        });

                    if (meta)
                        meta.innerCls += ' ks-column-expanded';
                    return val;
                };
            }

        } catch (e) {
            KS.msg('Unknown renderer: ' + col.renderer);
        }
    }
    
    function fileColumnRenderer(val, meta) {
        meta.tdCls = 'ks-fileColumn ' + KS.getExtStyle(val);
        return val;
    }

    function resolveRendererDateCol(value, metadata, record, rowIndex, colIndex, store) {
        if (value != null && value.length > 10) {
            var retDate = new Date(value);
            return Ext.Date.format(retDate, 'd.m.Y');
        } else if (Ext.isDate(value)) {
            return Ext.util.Format.date(value, metadata.column.format);
        }
        return value;
    }

    function resolveEditor(col, grid) {
        if (!col.editable && Ext.isEmpty(col.editor)) {
            setNonEditable(col);
            return false;
        }

        var editorType = null,
            directCreate = false,
            extraCfg = {
                grid: grid,
                col: col
            };
        // custom editor set obviously
        if (!KS.isEmpty(col.editor) && KS.isString(col.editor)) {
            try {
                if (KS.isFunction(eval(col.editor))) {
                    editorType = col.editor;
                }
            } catch (e) {
            }
        }
        if (!editorType) {
	        // try resolve editor from aspType
	        switch (col.aspType) {
	        case 'datecolumn':
                if (col.tag && col.tag.valueslist) {
                    editorType = Ext.form.field.ComboBox;
                    extraCfg = {
                        queryMode: 'local',
                        displayField: 'text',
                        valueField: 'value',
                        editable: !col.tag.onlySelect,
                        store: {
                            data: col.tag.valueslist,
                            fields: [{
                                name: 'value',
                                type: 'date',
                                dateFormat: !Ext.isEmpty(col.format) ? col.format : 'd.m.Y',
                                convert: function(v) {
                                    if (Ext.isEmpty(v))
                                        return undefined;
                                    else if (Ext.isDate(v))
                                        return v;
                                    else if (/new Date/.test(v))
                                        return KS.parseAjaxDateTime(v);

                                    return v;
                                }
                            }]
                        }
                    };
                } else {
                    editorType = KS.Ext.Grid.dateEditor;
                    extraCfg = {
                        format: col.format
                    };   
                }
		        break;
	        case 'combobox':
		        editorType = Ext.form.field.ComboBox;
		        extraCfg = {
			        queryMode: 'local',
			        displayField: 'text',
			        valueField: 'value',
                    editable: !col.tag.onlySelect,
			        store: col.tag.valueslist
		        };
		        break;
	        case 'filecolumn':
		        directCreate = true;
                col.showTriggers = true;
		        editorType = {
                    xtype: 'textfield',
                    editable: false,
                    // reset: Ext.emptyFn,
			        dataIndex: col.dataIndex,
                    grid: grid,
			        text: KS.L10n.fileLabel,
			        resetOriginalValue: Ext.emptyFn,
			        isFormField: true,
                    // getValue: function() {
                    //     var editor = this.ownerCt,
                    //         di = editor.column.dataIndex,
                    //         grid = editor.grid,
                    //         startCell = grid.getSelectionModel().selected.startCell,
                    //         rec = startCell ? startCell.record : null;
                    //
                    //     return rec ? rec.get(di) : null;
                    // },
                    // isValid: function() { return true; },
                    triggers: {
                        file: {
                            hideOnReadOnly: false,
                            handler: function(editor) {
                                var di = editor.column.dataIndex,
                                    grid = editor.grid,
                                    selected = grid.getSelectionModel().selected,
                                    startCell = selected ? selected.startCell : null,
                                    rec = startCell ? startCell.record : editor.record;

                                if (rec) {
                                        grid.fieldExt = di;
                                        grid.fileEdit(rec);
                                    }
                                }
                            }
                        },
                    listeners: {
                        focus: function(editor) {
                                var di = editor.column.dataIndex,
                                    grid = editor.grid,
                                    selected = grid.getSelectionModel().selected,
                                    startCell = selected ? selected.startCell : null,
                                    rec = startCell ? startCell.record : editor.record;
        
                                if (rec) {
                                    editor.triggers.file.el.removeCls(editor.triggers.file.extIcon);
                                    var val = rec.get(di);
                                    editor.triggers.file.extIcon = KS.getExtStyle(val);
                                    editor.triggers.file.el.addCls(KS.getExtStyle(val));
                                }
                        }
                    }
		        };

                if (col.renderer) {
                    col._renderer = col.renderer;
                    
                    col.renderer = function (value, metadata, record, rowIndex, colIndex, store) {
                        var me = this,
                            column = me.getColumnManager().getHeaderAtIndex(colIndex);

                        column._renderer.apply(me, arguments);
                        return fileColumnRenderer.apply(me, arguments);
                    }
                } else {
                    col.renderer = fileColumnRenderer    
                }
		        
		        break;
	        default:
		        break;
	        }
        }

        if (!editorType) {
        // try resolve default editor from dataType
            switch (col.dataType) {
            case 'system.int64':
            case 'system.int32':
                editorType = KS.Ext.Grid.numberEditor;

                if (col.tag) {
                    if (col.tag.maxValue)
                        extraCfg.maxValue = Number(col.tag.maxValue);
                    if (col.tag.minValue)
                        extraCfg.minValue = Number(col.tag.minValue);

                    if (col.tag.fract)
                        extraCfg.decimalPrecision = col.tag.fract.length;
                    else
                        extraCfg.decimalPrecision = 0;
                    
                    if (col.tag.isBigNumberType)
                        extraCfg.isBigNumberType = col.tag.isBigNumberType;
                }
                break;
            case 'system.decimal':
                directCreate = true;
                editorType = {
                    xtype: 'KSnumberfield',
                    maskRe: /[0-9.,-]/,
                    //validator: function(v) {
                    //    return /^-?[0-9]*(\.[0-9]{1,2})?$/.test(v)? true : '';
                    //},
                    style: 'text-align:right'
                };
                
                if (col.tag) {
                    if (col.tag.maxValue)
                        editorType.maxValue = Number(col.tag.maxValue);
                    if (col.tag.minValue)
                        editorType.minValue = Number(col.tag.minValue);
                    
                    if (col.tag.fract)
                        editorType.decimalPrecision = col.tag.fract.length
                    
                    if (col.tag.isBigNumberType)
                        editorType.isBigNumberType = col.tag.isBigNumberType;
                }
                
                break;
            case 2:
            case 'system.boolean':
            case 'Boolean':
                //editorType = KS.Ext.Grid.checkboxEditor;
                col.listeners = {
                    checkchange: function(column, rowIdx, checked, record, e) {
                        var store = record.store || record.getTreeStore(),
                            grid = store.grid,
                            p = e.position;
                        grid.fireEvent("edit",
                            {
                                grid: grid
                            },
                            {
                                grid: grid,
                                record: record,
                                field: column.dataIndex,
                                value: checked,
                                row: p.rowElement,
                                column: column,
                                rowIdx: rowIdx,
                                colIdx: 0
                            });
                    }
                };
                break;
            case 'system.string':
                editorType = KS.Ext.Grid.textEditor;
                extraCfg = {
                    grid: grid,
                    parentView: grid.parentView,

                    triggers: {
                        editBtn: {
                            xclass: 'KS.Ext.view.trigger.Edit'
                        }
                    }
                };
                
                if (col.tag && col.tag.maxLength) {
                    extraCfg.maxLength = col.tag.maxLength;
                    if (col.tag.enforceMaxLength)
                        extraCfg.enforceMaxLength = col.tag.enforceMaxLength;
                }

                if (col.tag && col.tag.minLength)
                    extraCfg.minLength = col.tag.minLength;
                
                break;
            }
        }

        if (!editorType) {
            setNonEditable(col);
            return false;
        }

        try {
            if (Ext.isString(editorType)) {
                editorType = eval(editorType);
            }

            if (directCreate) {
                col.editor = editorType;
                return col.editor || true;
            }

            if (col.tag && !col.tag.isRequired)
                extraCfg.allowBlank = true;

            col.editor = new editorType(extraCfg);
            return col.editor || true;
        } catch (e) {
            setNonEditable(col);
            return false;
        }
    }

    function setNonEditable(col) {
        col.editable = false;
        col.editor = null;
    }

    function buildColumnFilter(col) {
        if (Ext.isEmpty(col.FilterSettings)) {
            col.filter = undefined;
            return;
        }
        var type = 'string',
            value = undefined;
        switch (col.dataType) {
        case 'system.datetime':
            type = 'date';
            break;
        }
        col.filter = {
            type: type,
            value: value
        };
    }

    function createStatusBar() {
        var ksObjs = this.ksObjs;
        return [
            ksObjs.statusBarLeft = Ext.create('Ext.ux.statusbar.StatusBar', { border: 0 }),
            ksObjs.filterBarLeft = Ext.create('Ext.ux.statusbar.StatusBar', { border: 0, hidden: true }),
            '->',
            ksObjs.statusBarRight = Ext.create('Ext.ux.statusbar.StatusBar', { border: 0 })
        ];
    }

    function createContextMenu() {
        var me = this,
            ksObjs = me.ksObjs,
            contextMenu = Ext.create('Ext.menu.Menu',
                {
                    items: [
                        ksObjs.showFilter = Ext.create('Ext.Action',
                            {
                                iconCls: 'ks-icon-filter_empty',
                                text: KS.L10n.filterType,
                                handler: function() {
                                    me.setFilterVisible();
                                    if (me.filterVisible) me.removeGridFilter();
                                }
                            })
                    ]
                });

        return ksObjs.contextMenu = contextMenu;
    }

    function setFilterVisible(isVisible) {
        if (this.enableLocking) {
            this.normalGrid.ksObjs.filterBar.setVisible(isVisible || !this.normalGrid.ksObjs.filterBar.isVisible());
            this.lockedGrid.ksObjs.filterBar.setVisible(isVisible || !this.lockedGrid.ksObjs.filterBar.isVisible());
        } else {
            var filterBar = this.ksObjs.filterBar;
            filterBar.setVisible(isVisible || !filterBar.isVisible());
        }
    }

    function removeGridFilter(column) {
        var grid = this.hasOwnProperty("isLocked") ? this.ownerGrid : this,
            store = grid.getStore();

        if (grid.hasOwnProperty("normalGrid") &&
            grid.hasOwnProperty("lockedGrid"))
        {
            removeGridColumnsFilter.apply(grid.normalGrid, arguments);
            removeGridColumnsFilter.apply(grid.lockedGrid, arguments);
        }
        else
        {
            removeGridColumnsFilter.apply(grid, arguments);
        }

        if (!column) {
            delete grid.filter;
            store.getFilters().removeAll();
        }

        grid.setSBText(grid.getSelectionModel().getSelection().length, grid.checkedCodes ? grid.checkedCodes.length : 0, false);

        const ctrl = grid.ctrl;
        if (ctrl.profileEnabled && ctrl.saveFilterInProfile) {
            grid.saveState();
        }
        
        if (grid.ctrl.filterMode > 1)
            store.loadPageFromServerTemplate(1);
    }

    function removeGridColumnsFilter(column){
        var grid = this,
            filterFeature = grid.editingPlugin?.view.filterFeature ?? grid.getPlugin('gridfilterbar');

        if (grid.hasOwnProperty("isLocked") &&
            column && grid.getColumns().indexOf(column) === -1)
            return;

        // Удаляем либо 1 фильтр, либо все
        if (column) {
            var gridFilters = Ext.isFunction(grid.getFilter) ? grid.getFilter() : grid.filter.asString,
                filters = JSON.parse(gridFilters),
                filtersByIndex = {};

            for (var i = 0; i < filters.length; i++)
                filtersByIndex[filters[i].Name] = i;

            filterFeature?.removeFilter(column);
            if (filtersByIndex.hasOwnProperty(column.dataIndex))
                filters.splice(filtersByIndex[column.dataIndex], 1);

            Ext.apply(grid.filter, {
                asString: JSON.stringify(filters)
            });
        } else {
            var columns = grid.getColumns();

            for (var i = 0; i < columns.length; i++)
                filterFeature?.removeFilter(columns[i]);

            delete grid.filter;
        }
    }
    // ReSharper restore FunctionsUsedBeforeDeclared
}());

// KS.Ext.Tree
(function() {
    if (KS.isDefined(KS.Ext.Tree)) return;

    // ============= RENDER =======================
    Ext.define('KS.Ext.Tree',
        {
            extend: 'Ext.tree.Panel',
            alias: 'widget.exttree',

            //useArrows: true,
            animate: true,
            border: false,
            autoScroll: true,
            columnLines: true,
            rootVisible: false,

            constructor: function(ctrl, cfg) {
                var tree = this;
                
                tree.ksObjs = {};
                tree.ctrl = ctrl;
                tree.autoLoad = Ext.isEmpty(ctrl.value);
                cfg.lines = ctrl.lines;
                cfg.plugins = [];
                cfg.features = [];

                KS.apply(tree,
                    KS.apply(tree, ctrl.json),
                    {
                        gridSettings: ctrl.gridSettings,
                        itemId: ctrl.itemId,
                        ctrl: ctrl,
                        isTpl: true,
                        parentView: ctrl.parentView,
                        maximizable: ctrl.maximizable,
                        useArrows: ctrl.useArrows,
                        columnLines: ctrl.columnLines,
                        rowLines: ctrl.rowLines,
                        removePanelHeader: false
                    });

                if (Ext.isEmpty(cfg.title) || cfg.title === false)
                    cfg.header = false;

                KS.Ext.correctSize(cfg, ctrl);
                Ext.apply(tree, cfg);

                if (this.ctrl.rootVisible) {
                    this.rootVisible = true;
                }

                if (this.ctrl.exporter)
                    cfg.plugins.push({ ptype: 'gridexporter'});
                
                if (this.displayProgress) {
                    cfg.plugins.push({ ptype: 'ksProgress' });
                }

                if (ctrl.customViewConfig && ctrl.parentView && ctrl.itemId)
                    tree.viewConfig = ctrl.parentView[ctrl.itemId + 'ViewConfig'];


                if (ctrl.filterMode > 0) {
                    this.features.push({
                        id: 'filter',
                        ftype: 'filter',
                        dock: 'top'
                    });
                }
                
                
                KS.Ext.Tree.superclass.constructor.call(this, cfg);

                KS.Ext.Grid.prototype.setEventHandlers.apply(this);

                if (this.displayProgress) {
                    this.ksObjs.ksProgressBar = this.plugins[0];
                    this.bodyCls = 'ks-panel-progress';
                }

                if (!this.autoLoad) {
                    this.addChildNodes(this.getRootNode(), this.ctrl.value);
                }

                if (!KS.isEmpty(ctrl.selectedNode)) {
                    this.setSelected(ctrl.selectedNode);
                }
            },

            remoteSorterFn: function () {
                return 0;
            },
            applyState: function (value) {
                if (Ext.isObject(value)) {
                    const sorters = value.storeState?.sorters;
                    if (Ext.isArray(sorters)) {
                        sorters.forEach(x => {
                            if (Ext.isEmpty(x.property)) {
                                x.sorterFn = this.remoteSorterFn;
                            }
                        });
                    }
                }
                this.callParent(arguments);
            },

            makeSorters: function(treeColumns) {

                var sorters = [];
                if (treeColumns) {
                    var sortColumns = [];

                    var columns = treeColumns;
                    for (var i = 0; i < columns.length; i++) {
                        var column = columns[i];
                        var sorter = column.sorter;
                        
                        if (sorter?.isFakeSorter)
                            continue;
                        
                        if (sorter && !column.hidden)
                            sortColumns.push(column);
                        if (column.columns) {
                            columns = columns.concat(column.columns);
                            if (column.columns.length>0) {
                                var childSorters = this.makeSorters(column.columns);
                                if (childSorters && childSorters.length > 0)
                                    sortColumns.push(childSorters);
                            }
                        }
                    }

                    sortColumns.sort(function (x, y) {
                        if (x.sorting_order < y.sorting_order) return -1;
                        if (x.sorting_order > y.sorting_order) return 1;
                        return 0;
                    });
                    Ext.each(sortColumns, function (c) {
                        if (c.sorter)
                            sorters.push(c.sorter);
                    });
                }
                return sorters;

            },
            
            initComponent: function() {
                var tree = this,
	                columns = makeColumns(this),
                    store = Ext.create('Ext.data.TreeStore',
                        {
                            root: {
                                expanded: true,
                                name: 'root'
                            },
                            defaultRootText: '',
                            data: [],
                            grid: tree,
                            sorters: this.makeSorters(columns?.items),
                            pageSize: tree.pageSize,
                            statefulFilters: true,
                            
                            listeners: {
	                            beforeload: function(st, rec) {
		                            /*var expandedLinks = [],
			                            pushToExpanded = function(rec) {
				                            if (rec.isExpanded()) expandedLinks.push(rec.get('LINK'));
			                            },

			                            findExpandedChilds = function(r) {
				                            pushToExpanded(r);

				                            Ext.each(r.childNodes, function(ch) {
					                            pushToExpanded(ch);

					                            if (ch.childNodes) {
						                            Ext.each(ch.childNodes, function(chch) {
							                            findExpandedChilds(chch);
						                            });
					                            }
				                            });
			                            },
			                            allNodes = me.gridStore && me.gridStore.getRootNode().childNodes;

		                            if (allNodes)
			                            Ext.each(allNodes, function(node) {
				                            findExpandedChilds(node);
			                            });

		                            me.expandedLinks = expandedLinks;

		                            return !me.isCreate;*/
	                            }
                            },
                            remoteSort: !tree.ctrl.localSort,
                            filterer: 'bottomup',
                            fields: tree.getBand() ? tree._makeFields(tree.getBand().Column) : [],
                            getTotalCount: function() { return this.totalCount; },
                            getCurrentPage: function() { return this.currentPage; },

                            getSortInfo: function () {
                                const store = this;
                                const sorters = store.getSorters();
                                if (sorters && sorters.length > 0) {
                                    var sortInfo = '';
                                    sorters.each(function (sorter) {
                                        sortInfo += sorter.getId() + ' ' + sorter.getDirection() + ',';
                                    });
                                    return sortInfo;
                                }
                            }
                        }),
                    cfg = {
                        store: store,
                        columns: columns
                    };

                if (this.ctrl.customLoader) {
                    KS.Ext.setTemplateListeners(store,
                        {
                            'beforeload': this.ctrl.customLoader
                        },
                        this.ctrl.parentView);
                } else {
                    store.on('beforeload', templateTreeLoader, this);
                }
                

                if (tree.ctrl.profileEnabled) {
                    tree.stateful ??= {};
                    tree.stateEvents ??= [];

                    if (tree.ctrl.saveFilterInProfile) {
                        tree.stateful.filter = true;
                        tree.stateEvents.push('filterchanged');
                    }
                }

                var band = tree.getBand();
                if (tree.stateful) {
                    tree.stateId = tree.itemId + '~' + tree.parentView.viewID;
                    if (band.layout && !tree.ctrl.saveFilterInProfile) {
                        var state = Ext.decode(band.layout, true);
                        if (state && state.storeState) {
                            //delete state.storeState.filters;
                            band.layout = Ext.encode(state);
                        }
                    }
                    tree.parentView.viewLayout[tree.itemId] = band.layout;
                }

                Ext.apply(this, cfg);
                this.callParent(arguments);
            },

            refreshFilters: function() {
                var tree = this,
                columns = tree.getColumns(),
                filters = tree.store.getFilters();
                
                Ext.each(filters.items,
                    function (filter) {
                        var config = filter.getConfig(),
                            value = config.value;
                        var column = columns.find(x => x.key == config.property);

                        if (column?.filterEditor?.controller && !column.hidden) {
                            column.filterEditor.filterEditor.prevValue = null; // принудительное применение
                            column.filterEditor.filterEditor.setValue(value);
                            column.filterEditor.controller.filter();
                        }
                        else // очищаем если скрыт или без контроллера фильтра
                            tree.store.filter(config.property, "");
                    });
            },

            refreshSorters: function() {
                var tree = this
                    columns = tree.getColumns(),
                    sorters = tree.store.getSorters();

                Ext.each(sorters.items,
                    function (sorter) {
                        var config = sorter.getConfig(),
                            column = columns.find(x => x.key == config.property);

                        column.sort(config.direction);
                    });
            },

            getColCfgByIndex: function(colIndex) {
                return this.getColumns()[colIndex];
            },
            
            fieldsAdapted: function(fields) {
	            if (KS.Array.find(fields, ['name', 'tree']) === -1) {
		            fields.push('tree');
	            }

	            return fields;
            },

            _makeFields: function(columns) {
	            var fields = [];
	            Ext.each(columns,
		            function(c) {
			            if (c.dataIndex) {
				            var fd = {
					            name: c.dataIndex,
					            type: 'string'
				            };
				            switch (c.aspType) {
				            case 'checkcolumn':
				            case 'checkbox':
					            fd.type = 'bool';
					            break;
                            case 'datecolumn':
                                fd.type = 'date';
                                fd.dateFormat = !Ext.isEmpty(c.format) ? c.format : 'd.m.Y';
                                fd.convert = function(v) {
                                    if (Ext.isEmpty(v))
                                        return undefined;
                                    else if (Ext.isDate(v))
                                        return v;
                                    else if (/new Date/.test(v))
                                        return KS.parseAjaxDateTime(v);

                                    return v;
                                }
                                break;
                            }
				            fields.push(fd);
			            }
		            });

	            return this.fieldsAdapted(fields);
            },

            getMenuItems: KS.Ext.Grid.getMenuItem,

            getCheckedRows: function() {
                if (!Ext.isEmpty(this.checkedCodes)) {
                    var tree = this,
                        checkedColName = 'CHECKED';
                    tree.store.each(function (rec) {
                        if (tree.getAnyCase(rec, checkedColName) === false) {
                            tree.removeCodeFromCheckedList(tree.getCloseCode(rec));
                        }
                    });
                }
                return this.getSelectionModel().getSelection();
            },

            getAnyCase: function(rec, field) {
                if (!rec || !field) return null;
                return rec.get(field) || rec.get(field.toLowerCase()) || rec.get(field.toUpperCase());
            },

            getCloseCode: function(rec) {
                return this.getAnyCase(rec, this.closeCode) || null;
            },

            getCheckedCodes: function(includeSelected) {
                var tree = this,
                    checkedRows = tree.getCheckedRows(includeSelected),
                    codes = [];
                Ext.each(checkedRows,
                    function(rec) {
                        var cc = tree.getCloseCode(rec);
                        if (cc) codes.push(cc);
                    });
                return codes;
            },

            moveRecordDown: function(record) {
                if (!record) return false;
                
                var store = this.store,
                    ind = store.indexOf(record),
                    newRec = store.getAt(ind + 1);

                if (!newRec) return false;

                var newRecInd = store.indexOf(newRec);

                store.insert(newRecInd + 1, record);
            },

            moveRecordUp: function(record) {
                if (!record) return false;
                
                var store = this.store,
                    ind = store.indexOf(record),
                    newRec = store.getAt(ind - 1);

                if (!newRec) return false;

                var newRecInd = store.indexOf(newRec);

                store.insert(newRecInd, record);
            },

            getSelectionCount: Ext.emptyFn()
        });

    // ============= PUBLIC =======================
    KS.apply(KS.Ext.Tree.prototype,
        {

            addChildNodes: function(node, data) {
                if (KS.isString(data)) data = Ext.decode(data, true);
                node.loaded = true;

                if (!KS.isEmpty(this.ctrl.band)) {
                    var addDataToNode = function(node) {
                            if (node.columnValues) {
                                for (var key in node.columnValues) {
                                    if (node.columnValues.hasOwnProperty(key)) {
                                        node[key] = node.columnValues[key];
                                    }
                                }
                            }
                        },
                        addDataToAllChildren = function(rootNode) {
                            addDataToNode(rootNode);

                            if (rootNode.children && rootNode.children.length) {
                                Ext.each(rootNode.children,
                                    function(child) {
                                        addDataToAllChildren(child);
                                    });
                            }
                        };

                    Ext.each(data, 
                        function(node) {
                            addDataToAllChildren(node);
                        });
                }

                if (node.isExpandable() && node.isExpanded())
                    node.collapse();

	            node.appendChild(data);

                node.expand();

                // из-за того что переопределяем способ загрузки, 
                // то сортировка не срабатывает если добавить дочерние узлы программно
                if (this.store.sorters.length)
                    this.store.data.sortItems();
            },

            fullReload: function() {
                this.getStore().reload();
            },

            reloadRootNodes: function(data) {
                var root = this.getRootNode();
                root.removeAll();
                this.addChildNodes(root, data);
                this.getView().refresh();
                return true;
            },

            loadSubTreeInRoot: function(data) {
                return this.reloadRootNodes(data);
            },

            getSelected: function() {
                var c = this.getSelectionModel(),
                    sm = (c.selected.items.length > 0) ? c.selected.items[0] : null,
                    rez = (sm && sm.getOwnerTree()) ? sm.data[this.ctrl && this.ctrl.idColumn || 'id'] /*.getPath()*/ : null;

                if (rez && Ext.isString(rez)) {
                    rez = rez.replace(new RegExp('/', 'g'), '|');
                } else {
                    //Т.к. на сервере ожидаем string
                    rez = rez && rez.toString();
                }

                return rez;
            },

            getLevel: function() {
                var selModel = this.getSelectionModel(),
                    selItem = selModel.getSelection()[0];

                return selItem ? selItem.get('depth') : null;
            },

            getSelNode: function() {
                return this.getSelectionModel().getSelected().items[0];
            },

            getSelNodeId: function() {
                var sn = this.getSelNode();
                return sn ? sn.id : null;
            },

            setSelected: function(path) {
                var keys = path.split('|');
                var nodeId = keys[keys.length - 1];
                var node = this.store.getNodeById(nodeId);
                if (node /*&& node.rendered === true*/) {
                    //node.select();
                    this.getSelectionModel().select(node);
                } else {
                    // wait while it rendering ...
                    setTimeout(function() {
                            if (node /*&& node.rendered === true*/) {
                                //node.select();
                                this.getSelectionModel().select(node);
                            }
                        },
                        100);
                }
            },

            selectFirstNode: function () {
                var root = this.getRootNode();
                if (root.hasChildNodes()) {
                    this.getSelectionModel().select(root.childNodes[0]);
                }
            },

            // overrides base method
            getChecked: function() {
                var selNodes = KS.Ext.Tree.superclass.getChecked.call(this);
                var res = [];
                Ext.each(selNodes,
                    function(node) {
                        res.push(node);
                    });
                return res;
            },

            getCheckedPaths: function() {
                var nodes = this.getChecked();
                var res = [];
                Ext.each(nodes,
                    function(node) {
                        res.push(node.getPath());
                    });
                return res;
            },

            setChecked: function(arrPath) {
                var tree = this;
                Ext.each(arrPath,
                    function() {
                        tree.selectPath(this,
                            null,
                            function(bSuccess, oSelNode) {
                                if (bSuccess) {
                                    setChecked(oSelNode, true);
                                } else {
                                    KS.alert(KS.L10n.treeStateError);
                                }
                            });
                    });
            },

            invertAll: function() {
                setCheckedRecursive(this.getRootNode());
            },

            checkAll: function() {
                setCheckedRecursive(this.getRootNode(), true);
            },

            uncheckAll: function() {
                setCheckedRecursive(this.getRootNode(), false);
            },

            getControlState: function (dict) {
                return KS.apply(dict || {},
                    {
                        selectedNodeId: this.getSelected(),
                        selectedNodeLevel: this.getLevel(),
                        checkedNodes: this.getChecked().map(function(x) {
                            return x.get('elementId');
                        })
                    });
            },

            setRootHidden: function(hidden) {
                //var root = this.getRootNode();
                //if (hidden) {
                //    this.hideUI(root);
                //} else {
                //    this.showUI(root);
                //}
            },

            setText: function(node, text) {
                node.set("text", text);
            },

            getText: function(node) {
                return node.data.text;
            },

            checkAllChildren: function () {
                var sn = this.getSelNode();
                if (!sn) return;
                setCheckedRecursive(sn, true);
            },

            checkDirectChildren: function () {
                var sn = this.getSelNode();
                if (!sn) return;
                setChecked(sn, true);
                Ext.each(sn.childNodes, function (subNode) {
                    setChecked(subNode, true);
                });
            },

            checkAllLeafs: function () {
                var sn = this.getSelNode();
                if (!sn) return;
                setCheckedLeafsRecursive(sn, true);
            },

            getBand: function() {
                if (this.config && this.config.ctrl && this.config.ctrl.band)
                    return this.config.ctrl.band;
                return null;
            },

            setIcon: function(node, cls) {
                if (node && cls) 
                    node.set("iconCls", cls); 
            },

            getFilter: function (grid) {
                return '[]'; // not supported yet
            }
        });

    // ============= RENDERERS =======================
    // ReSharper disable UnusedLocals
    function dummyRenderer(value) {
        return value;
    }

    function sizeRenderer(value) {
        return KS.Ext.formatSize(value);
    }
    // ReSharper restore UnusedLocals

    // ============= PRIVATE =======================
    function templateTreeLoader(store, op) {
        var tree = this,
            ctrl = tree.ctrl,
            view = ctrl.parentView,
            node = op.config.node,
            getDataParams = KS.apply({
                    type: 'tree',
                    itemId: ctrl.itemId,
                    parentId: node.id || null
                },
                node.data.json);
        if (tree.displayProgress && tree.rendered) {
            tree.ksObjs.ksProgressBar.showProgressBar();
            tree.mask(KS.L10n.readingStatus);
        }
        view.serverCall({
            method: 'GetControlData',
            waitMessage: KS.L10n.readingNodes,
            disableFog: tree.displayProgress && tree.rendered,
            params: [getDataParams],
            complete: function() {
                if (tree.displayProgress && tree.rendered) {
                    tree.ksObjs.ksProgressBar.hideProgressBar();
                    tree.unmask();
                }
            },
            success: function(data) {
                if (!data || data.length === 0) return;
                tree.addChildNodes(node, data);
                tree.fireEvent('nodelevelload', node);
            }
        });
        return false;
    }

    // Make Column array
    function makeColumns(tree) {
        var ctrl = tree.ctrl;

        if (ctrl && ctrl.columnHeaderGroups) {
            var columns = KS.Ext.Grid.prototype.makeColumns(tree),
                treeColumn;
            Ext.each(columns, function(col) {
                if (col.aspType === 'treecolumn') {
                    treeColumn = col;
                }
            });
            if (treeColumn) {
                treeColumn.xtype = 'treecolumn';
            } else {
                columns.unshift({
                    xtype: 'treecolumn',
                    text: '&nbsp',
                    dataIndex: 'tree',
                    width: 75,
                    draggable: false,
                    sortable: false,
                    //iconCls: 'ks-tree-icon',
                    index: -3,
                    renderer: function (value, meta, rec, rowIndex, colIndex, store, view) {
                        //var val = this.callParent(arguments);
                        eval(tree?.ctrl?.hierarchyColumnRenderer)?.apply(this, arguments)
                        return '';
                    }
                });
            }

		    return {
			    items: columns
		    };
	    }
    }

    function setCheckedRecursive(node, checked) {
        if (node.id !== 'root') setChecked(node, checked);
        Ext.each(node.childNodes,
            function() {
                setCheckedRecursive(this, checked);
            });
    }

    function setCheckedLeafsRecursive(node, checked) {
        if (node.isLeaf())
            setChecked(node, checked);
        Ext.each(node.childNodes, function () {
            setCheckedLeafsRecursive(this, checked);
        });
    }

    function setChecked(node, checked) {
        if (!Ext.isBoolean(checked)) {
            checked = !node.data.checked;
        }
        node.set('checked', checked);
    }


    // ReSharper restore FunctionsUsedBeforeDeclared
}());

// KS.Ext.TreeGrid
(function() {
    if (KS.isDefined(KS.Ext.TreeGrid)) return;

    // ============= COMPONENTS =======================
    Ext.define('KS.Ext.TreeGrid',
        {
            extend: 'KS.Ext.Tree',

            columns: [],
            columnLines: true,
            viewConfig: {
                isLockingView: true,
            },

            /*constructor: function(ctrl, cfg) {
                this.ksObjs = {};
                this.ctrl = ctrl;
                this.autoLoad = Ext.isEmpty(ctrl.value);
                cfg.lines = ctrl.lines;
                cfg.plugins = [];

                if (Ext.isEmpty(cfg.title) || cfg.title === false)
                    cfg.header = false;

                KS.Ext.correctSize(cfg, ctrl);
                Ext.apply(this, cfg);

                if (this.displayProgress) {
                    cfg.plugins.push({ ptype: 'ksProgress' });
                }

                KS.Ext.Tree.superclass.constructor.call(this, cfg);

                if (this.displayProgress) {
                    this.ksObjs.ksProgressBar = this.plugins[0];
                    this.bodyCls = 'ks-panel-progress';
                }

                if (!this.autoLoad) {
                    this.addChildNodes(this.getRootNode(), this.ctrl.value);
                }

                if (!KS.isEmpty(ctrl.selectedNode)) {
                    this.setSelected(ctrl.selectedNode);
                }
            },*/

            columnsAdapted: function() {
                var me = this,
                    columns = me.callParent(arguments);

                if (ArrayLib.find(columns, ['dataIndex'], 'tree') === -1) {
                    columns.unshift({
                        dataIndex: 'tree',
                        width: 75,
                        draggable: false,
                        sortable: false,
                        iconCls: 'ks-tree-icon',
                        xtype: 'treecolumn',
                        index: -3
                    });
                }

                return columns;
            },
            fieldsAdapted: function(fields) {
                var me = this;
                me.callParent(arguments);
                if (!me.thereIsField(fields, 'id')) {
                    fields.push('id');
                }
                if (!me.thereIsField(fields, 'tree')) {
                    fields.push('tree');
                }
                return fields;
            }
        });
}());

// KS.Ext.Panel
(function() {
    if (KS.isDefined(KS.Ext.Panel)) return;

    // ============= COMPONENTS =======================
    Ext.define('KS.Ext.Panel',
        {
            extend: 'Ext.panel.Panel',
            constructor: function(cfg, ctrl) {
                var panel = this;

                panel.ksObjs = {};
                KS.apply(panel,
                    KS.apply(cfg || {}, ctrl ? ctrl.json : null),
                    {
                        isTpl: true,
                        plugins: []
                    });

                if (panel.layout === 'box') {
                    panel.layout = {
                        type: 'box',
                        pack: 'center',
                        align: 'center'
                    };
                }

                if (ctrl && ctrl.ui) {
                    panel.ui = ctrl.ui;
                }

                if (panel.displayProgress) {
                    panel.plugins.push({ ptype: 'ksProgress' });
                }

                KS.Ext.Panel.superclass.constructor.call(panel);

                if (panel.displayProgress) {
                    panel.ksObjs.ksProgressBar = panel.plugins[0];
                    panel.bodyCls = 'ks-panel-progress';
                }
            }
        });

    Ext.define('KS.ux.ProgressBar',
        {
            extend: 'Ext.plugin.Abstract',
            alias: 'plugin.ksProgress',

            init: function(cmp) {
                cmp.on('render',
                    this.renderTest,
                    this,
                    {
                        single: true
                    });
            },

            renderTest: function() {
                var comp = this.getCmp();
                this.ksProgressBar.cls = 'ksProgress';
                comp.addDocked(this.ksProgressBar);
            },

            constructor: function(cfg) {
                cfg = cfg ||
                {
                    text: '',
                    dock: 'top',
                    maskElement: 'body',
                    renderTo: cfg.cmp,
                    width: 300
                };
                this.ksProgressBar = Ext.create('Ext.ProgressBar', cfg);
                return this.superclass.constructor.call(this);
            },

            showProgressBar: function() {
                if (!this.ksProgressBar || this.ksProgressBar._displayed) return;
                this.ksProgressBar.wait({
                    interval: 30,
                    duration: 50000,
                    increment: 45
                });
                this.ksProgressBar._displayed = true;
            },

            hideProgressBar: function() {
                if (!this.ksProgressBar || !this.ksProgressBar._displayed) return;
                // для случаев, когда контейнер уже уничтожен
                this.ksProgressBar && this.ksProgressBar.reset();
                delete this.ksProgressBar._displayed;
            }
        });
})();

// Templates
(function() {
    function setViewListeners(obj, vl, scope) {
        if (Ext.isEmpty(vl) || !Ext.isFunction(obj.on)) return;
        for (var event in vl)
            if (vl.hasOwnProperty(event)) obj.on(event, vl[event], scope);
    }

    function setTemplateListeners(inst, listeners, view) {
        return KS.Ext.setTemplateListeners(inst, listeners, view);
    }

    function resolveTriggers(config, control) {
        var triggers = control.triggers || {},
            view = control.parentView;
        
        Ext.apply(triggers, config.triggers);
        
        if (!triggers)
            return;
        
        var defaults = {
            editOrCreate: {
                xclass: 'KS.Ext.view.trigger.EditOrCreate'
            },
            
            open: {
                xclass: 'KS.Ext.view.trigger.Open'
            },
            
            clear: {
                xclass: 'KS.Ext.view.trigger.Clear'
            },

            expression: {
                xclass: 'KS.Ext.view.trigger.Expression'
            }
        }
        
        $.each(Object.keys(triggers), function(k, v) {
            if (defaults[v]) {
                triggers[v] = Ext.apply(defaults[v], triggers[v]);
            }
        });

        if (control.listeners) {
            var selectHandler = resolveHandler(control.listeners['selectbtn'], view);
            if (selectHandler && selectHandler !== view.notImplementedHandler) {
                triggers.open = KS.apply({
                    xclass: 'KS.Ext.view.trigger.Open',
                    code: control.itemId,
                    parentView: view,
                    hideOnReadOnly: false,
                    handler: selectHandler
                }, triggers.open);

                //buttonsCount++;
            }
        }
        
        return triggers;
    }

    function resolveHandler(handler, view) {
        if (handler) {
            var hParts = handler.split('.'),
                scope = hParts[0],
                fnName = hParts[1] || hParts[0];
            if (scope !== 'view' && view[scope]) {
                scope = view[scope];
            } else {
                scope = view;
            }
            if (scope[fnName] && Ext.isFunction(scope[fnName])) {
                return scope[fnName];
            }
        }
        return view.notImplementedHandler;
    }

    function createPropertyGrid() {
        var ctrl = arguments[0],
            cfg = KS.apply(arguments[1] || {}, ctrl.json),
            propertyNames = {},
            source = {};
        Ext.each(ctrl.properties,
            function(pSpec) {
                propertyNames[pSpec.Property] = pSpec.Name;
                source[pSpec.Property] = (ctrl.value || {})[pSpec.Property] || '';
            });
        KS.apply(cfg,
            {
                propertyNames: propertyNames,
                source: source,
                parentView: ctrl.parentView,
                getValues: function() {
                    return this.source || {};
                }
            });
        KS.Ext.correctSize(cfg, ctrl);
        var pg = new Ext.grid.PropertyGrid(cfg);
        setTemplateListeners(pg, ctrl.listeners, ctrl.parentView);
        return pg;
    }

    function createContainer() {
        var ctrl = arguments[0],
            cfg = KS.apply(arguments[1] || {}, ctrl.json);
        KS.Ext.correctSize(cfg, ctrl);

        KS.apply(cfg,
            {
                listeners: {
                    resize: function(th, width, height, oldWidth, oldHeight, eOpts) {
                        var lbl = th.items.get(0);
                        if (lbl && lbl.id.indexOf('label') !== -1) {
                            lbl.setWidth(width);
                        }
                    }
                }
            });

        var container = new Ext.container.Container(cfg);
        setTemplateListeners(container, ctrl.listeners, ctrl.parentView);
        return container;
    }

    function createPanel() {
        var isTpl = Ext.isObject(arguments[0]),
            ctrl = arguments[0],
            cfg = isTpl ? KS.apply(arguments[1] || {}, {
                maximizable: ctrl.maximizable
            }, ctrl.json) : arguments[1];
        KS.Ext.correctSize(cfg, ctrl);
        var panel = new KS.Ext.Panel(cfg, ctrl);
        setTemplateListeners(panel, ctrl.listeners, ctrl.parentView);
        return panel;
    }

    function createTabPanel() {
        var ctrl = arguments[0],
            view = ctrl.parentView,
            cfg = KS.apply(arguments[1] || {}, ctrl.json);
        if (ctrl.enableTabScroll)
            KS.apply(cfg, {});
        if (Ext.isNumber(ctrl.activeTab))
            KS.apply(cfg, { activeTab: ctrl.activeTab });
        KS.Ext.correctSize(cfg, ctrl);
        var tabPanel = new KS.Ext.tab.Panel(cfg);
        tabPanel.on(KS.tabPanelFirstActivateTabEvent ?? 'afterrender',
            function(tp) {
                tp.setActiveTab(this.activeTab);
            },
            ctrl);
        setTemplateListeners(tabPanel, ctrl.listeners, view);
        return tabPanel;
    }

    function createCombo() {
        var isTpl = Ext.isObject(arguments[0]),
            ctrl = arguments[0],
            view = isTpl ? ctrl.parentView : arguments[1],
            cboCfg = isTpl ? KS.apply(arguments[1] || {}, ctrl.json) : arguments[2],
            triggers = resolveTriggers(cboCfg, ctrl);

        if (Object.keys(triggers).length)
            cboCfg.triggers = triggers;
        
        //В этом случае возвращаем контейнер
        if (ctrl.gridOnExpand) {
            var onSelectFn = view.onSelect;

            //Используем один и тот же грид для всех комбо
            if (!KS.gridOnExpand) {
                    var selectHandler = function(th, records, item, index, e, eOpts) {
                        var combo = this.bindedCombo,
                            values = [];
                        
                        if (records) {
                            //#region !!! не убирать !!! иначе не сортируются отображаемые значения, только добавляются в конец
                            combo && combo.setValue();
                            //#endregion
                            
                            combo && combo.setValue(records);
                            KS.gridOnExpand.setSelection(records);
                        } else {
                            combo && combo.setValue();
                            KS.gridOnExpand.setSelection();
                        }

                        KS.gridOnExpandParentWindow.close();
                        KS.gridOnExpand.expanded = false;
                        onSelectFn && onSelectFn.call(combo, combo, e, KS.gridOnExpand);
                    },
                    grid = KS.Ext.create({
                            type: 'grid',
                            uncheckBySelect: false,
                            json: {},
                            parentView: view,
                            filterMode: 1,
                            listeners: {
                                itemdblclick: function(grid, record, item, index, e, eOpts) {

                                    var selItems = [];
                                    if (KS.gridOnExpand.selMode == 4 || KS.gridOnExpand.selMode === 1)
                                        selItems = [record];
                                    else
                                        selItems = KS.gridOnExpand.getSelectionModel().getSelected().items;
                                    
                                    selectHandler.call(KS.gridOnExpand,
                                        KS.gridOnExpand,
                                        selItems);
                                },
                                itemclick: function (grid, record, item, index, e, eOpts)
                                {
                                    var selectItems = grid.getSelectionModel().getSelected();
									
                                    var allParam = "___все___";
                                    
                                    var idAll = record.data.index && record.data.index.toString().toLowerCase() == allParam;

                                    var items = selectItems.items ?? selectItems.selectedRecords?.items;
                                    var delList = [];

                                    if (KS.gridOnExpand.selMode == 4) {
                                        Ext.each(items, function(item) {
                                            if (item != record)
                                                delList.push(item);
                                        });
                                        grid.getSelectionModel().deselect(delList);
                                    } else {
                                        for (var i = 0; i < items.length; i++) {
                                            if (idAll) {
                                                if (items[i] != record) {
                                                    delList.push(items[i]);
                                                }
                                            } else {
                                                if (items[i].data.index && items[i].data.index.toLowerCase() == allParam) {
                                                    delList.push(items[i]);
                                                }
                                            }
                                        }
                                    }
                                    grid.getSelectionModel().deselect(delList);
                                },
                                specialkey: function(combo, e) {
                                    if (e.getKey() == e.ENTER) {
                                        selectHandler(this);
                                    }
                                }
                            },
                            gridSettings: {
                                resizable: false,
                                Band: [
                                    {
                                        Column: [],
                                        selection: KS.comboGridSelectionMode ?? 1,
                                        //PageSize: 50
                                    }
                                ]
                            }
                        }, {
                            store: Ext.create('Ext.data.Store',
                                {
                                    storeId: 'gridOnExpandStore',
                                    fields: [],
                                    data: []
                                }),
                            columns: [],
                            height: 200,
                            width: 400,
                            ...KS.comboGridAdditionalConfig,
                        });

                    KS.gridOnExpandParentWindow = Ext.create('Ext.window.Window',
                    {
                        minHeight: 200,
                        minWidth: 400,
                        layout: 'fit',
                        resizable: true,
                        draggable: ctrl.draggable || false,
                        resizeHandles: 'se',
                        closeAction: 'hide',
                        frameHeader: false,
                        border: false,
                        constrain: true,
                        //чтобы окно закрывалось по esc, но не было кнопки закрыть
                        initTools: Ext.emptyFn,
                        buttons: [
                            grid.OkBtn = Ext.create('Ext.Button',
                                {
                                    text: KS.L10n.select,
                                    handler: function() {
                                        selectHandler.call(KS.gridOnExpand,
                                            KS.gridOnExpand,
                                            KS.gridOnExpand.getSelection());
                                    }
                                }),
                            {
                                xtype: 'button',
                                text: KS.L10n.clear,
                                handler: function() {
                                    selectHandler.call(KS.gridOnExpand,
                                        KS.gridOnExpand,
                                        null);
                                }
                            },
                            {
                                xtype: 'button',
                                text: KS.L10n.close,
                                handler: function () {
                                    KS.gridOnExpandParentWindow.close();
                                }
                            }
                        ],
                        listeners: {
                            afterrender: function(c) {
                                c.initialSize = c.getSize();
                            },
                            
                            close: function () {
                                if (KS.gridOnExpand.bindedCombo)
                                    KS.gridOnExpand.bindedCombo.paramLastSelection = KS.gridOnExpand.getSelection();
                                KS.gridOnExpand.expanded = false;
                            },
                            
                            show: function(){
                                var g = KS.gridOnExpand,
                                    columns = g.getColumns(),
                                    combo = KS.gridOnExpand.bindedCombo,
                                    w = g.up('window'),
                                    i;
                                
                                for (i = 0; i < columns.length; i++) {
                                    if (columns[i].xtype === 'checkcolumn') {
                                        columns[i].setHidden(!g.multiSelect);
                                        break;
                                    }
                                }
                                
                                g.getSelectionModel().setSelectionMode(g.multiSelect ? 'MULTI' : 'SINGLE');
                                
                                if (combo) {
                                    if (combo.gridState)
                                        for (i = 0; i < combo.gridState.columns.length; i++) {
                                            if (combo.gridState.columns[i].width) {
                                                columns[i].setFlex(undefined);
                                                columns[i].setWidth(combo.gridState.columns[i].width);
                                            }
                                        }
                                    
                                    if (!KS.gridOnExpandWindowDisableState) {
                                        if (combo.windowState) {
                                            w.setSize(combo.windowState);
                                        } else if (!KS.gridOnExpandWindowUseAutoSizeStateIfEmpty) {
                                            w.setSize(w.initialSize);
                                        }
                                    } else {
                                        w.setSize(null, null);
                                    }
                                }
                                
                                if (Ext.isNumber(KS.gridOnExpandWindowMaxHeight)) {
                                    w.setMaxHeight(window.outerHeight * KS.gridOnExpandWindowMaxHeight);
                                }
                            },
                            
                            hide: function() {
                                KS.gridOnExpand.bindedCombo.gridState = KS.gridOnExpand.getState();
                                KS.gridOnExpand.bindedCombo.windowState = KS.gridOnExpand.up('window').getSize();
                            },
                            
                            focusleave: function(c) {
                                c.close();
                            }
                        },
                        items: KS.gridOnExpand = grid
                    });
            }

            cboCfg.editable = true;

            //#region Костыли
            //todo: Сделать нормально, не копипастя соыбтия экста
            cboCfg.onTriggerClick = function(comboBox, trigger, e) {
                var me = this,
                    oldAutoSelect;

                if (!me.readOnly && !me.disabled) {
                    if (me.isExpanded) {
                        me.ksTriggerClicked = false;
                        me.collapse();
                    } else {
                        me.ksTriggerClicked = true;
                        // Alt-Down arrow opens the picker but does not select items:
                        // http://www.w3.org/TR/wai-aria-practices/#combobox
                        if (e && e.type === 'keydown' && e.altKey) {
                            oldAutoSelect = me.autoSelect;
                            me.autoSelect = false;
                            me.expand();
                            me.autoSelect = oldAutoSelect;
                        } else {
                            if (me.triggerAction === 'all') {
                                me.doQuery(me.allQuery, true);
                            } else if (me.triggerAction === 'last') {
                                me.doQuery(me.lastQuery, true);
                            } else {
                                me.doQuery(me.getRawValue(), false, true);
                            }
                        }
                    }
                }
            };
            cboCfg.onExpand = function() {
                var grid = KS.gridOnExpand,
                    combo = this,
                    columns = [],
                    storeCfg = combo.store.config,
                    rawValue = combo.getRawValue(),
                    selIndexes = {},
                    selRecs = combo.paramLastSelection || [],
                    toSelect = [],
                    comboData = combo.store.getData().getRange();
                
                KS.gridOnExpand.selMode = ctrl.gridSelectionMode;
                // Записываем все индексы выделенных записей
                for (var i = 0; i < selRecs.length; i++)
                    selIndexes[selRecs[i].get('index')] = true;

                // Если индекс определен, то добавляем его в выделение
                for (var i = 0; i < comboData.length; i++)
                    if (selIndexes[comboData[i].get('index')])
                        toSelect.push(comboData[i]);

                // Если ничего не было выделено, то выделяем первую запись
                if (!toSelect.length && comboData.length)
                    toSelect.push(comboData[0]);
                
                grid.multiSelect = combo.multiSelect;

                combo.collapse();
                
                if (grid.expanded) {
                    KS.gridOnExpandParentWindow.close();
                    return true;
                }
                
                if (Ext.isNumber(combo.getValue()) || combo.ksTriggerClicked) {
                    if (!grid.bindedCombo || grid.bindedCombo.id !== this.id) {
                        Ext.each(storeCfg.fields,
                            function(field) {
                                if (field === 'index') return 1;
                                if (field === 'item1') return 2;
                                columns.push({
                                    text: field,
                                    dataIndex: field,
                                    visibility: true,
                                    flex: 1
                                });
                            });
    
                        grid.store.fields = storeCfg.fields;
    
                        grid.reconfigure(grid.store, columns);
    
                        if(combo.config.ctrl.fieldsVisibility) {
                            var gridColumns = grid.getColumns();
                            Ext.each(combo.config.ctrl.fieldsVisibility, function (fv) {
                                var ind = KS.Array.find(gridColumns, ['dataIndex'], fv.name);
    
                                if (ind > -1) {
                                    var column = gridColumns[ind];
                                    if (fv.visibility)
                                        column.show();
                                    else
                                        column.hide();                                 
                                }
                            });
                        }
                        
                        //Фильтры могли быть настроены не для текущих данных
                        if (grid.store.filters.length > 0) {
                            for (var i = 0; i < grid.store.filters.items.length; i++) {
                                var filter = grid.store.filters.items[i];
                                var ind = KS.Array.find(grid.visibleColumnManager.columns, ['dataIndex'], filter._property);
                                //меняем состояние фильтра в зависимости от наличия колонки
                                filter._disabled = ind == -1;
                            }
                        }
    
                    }

                    grid.store.loadData(comboData);
                    grid.getSelectionModel().select(toSelect);
                    grid.expanded = true;
                    grid.bindedCombo = combo;

                    KS.gridOnExpandParentWindow.show();
                    KS.gridOnExpandParentWindow.setPosition(combo.inputEl.getX(), combo.getY() + combo.getHeight());
                    
                    // отключено по багу https://bugzilla.keysystems.ru/bugzilla/show_bug.cgi?id=169718
                    //KS.gridOnExpandParentWindow.setWidth(combo.inputEl.getWidth());

                    
                    //#region bug 169139, непонятно зачем нужно, к тому же ломает выбор записей через клик
                    // grid.focus();
                    //#endregion

                    //Если введено значение в комбобокс но его нет в store - значит фильтруем грид
                    //if (rawValue && rawValue.length && !combo.store.getData().find(combo.displayField, rawValue)) {
                    //    var displayFieldColumn;
                    //    Ext.each(grid.visibleColumnManager.columns,
                    //        function(col) {
                    //            if (col.dataIndex === combo.displayField) {
                    //                displayFieldColumn = col;
                    //                return true;
                    //            }
                    //        });
                    //    grid.onKsFilterChange(displayFieldColumn, rawValue);
                    //}

                    var value = combo.getValue(),
                        selectedRecords = typeof(value) === 'string' ? [value] : value ? value : [],
                        indexMap = selectedRecords.reduce((acc, v) => Object.assign(acc, {[v]: true}), {});
                    
                    // Обновляем данные грида
                    if (ctrl.gridAutoRefresh === 1) {
                        grid.mask(KS.L10n.updatingStatus);

                        combo.parentView.serverCall({
                            method: 'GetReportParamData',
                            params: [combo.ctrlId, rawValue],
                            success: function (result) {
                                if (result) {
                                    var selection = [],
                                        newRecords,
                                        fieldsVisibility;

                                    // for (var i = 0; i < selectedRecords.length; i++)
                                    //     indexMap[selectedRecords[i].get('index')] = true;

                                    for (var i = 0; i < result.length; i++) {
                                        if (result[i].Values)
                                            combo.store.loadData(result[i].Values);
                                        fieldsVisibility = result[i].FieldsVisibility;
                                    }

                                    grid.store.loadData(combo.store.getData().getRange());
                                    newRecords = grid.store.getData().getRange();

                                    if(fieldsVisibility) {
                                        var gridColumns = grid.getColumns();
                                        Ext.each(fieldsVisibility, function (fv) {
                                            var ind = KS.Array.find(gridColumns, ['dataIndex'], fv.name);

                                            if (ind > -1) {
                                                var column = gridColumns[ind];
                                                if (fv.visibility)
                                                    column.show();
                                                else
                                                    column.hide();
                                            }
                                        });
                                    }
                                    
                                    for (var i = 0; i < newRecords.length; i++)
                                        if (indexMap[newRecords[i].get('index')])
                                            selection.push(newRecords[i]);

                                    grid.setSelection(selection);
                                }
                                grid.unmask();
                            }
                        });
                    } else {
                        grid.setSelection(grid.store.getRange().filter(x => indexMap[x.get(combo.valueField)]));
                    }
                } else {
                    //FROM SOURCE
                    var picker = combo.getPicker(),
                        keyNav = picker.getNavigationModel(),
                        node;

                    if (keyNav) {
                        keyNav.enable();
                    }

                    combo.doAutoSelect();

                    node = picker.highlightedItem;

                    if (node) {
                        // Need to make sure node has an id without leaving Ext.cache entry 
                        if (!node.id) {
                            node.id = Ext.id();
                        }

                        combo.inputEl.dom.setAttribute('aria-activedescendant', node.id);
                    }
                }

            };
            cboCfg.doRawQuery = function() {};
            //#endregion Костыли
        }

        KS.apply(cboCfg,
            {
                parentView: view,
                //typeAhead: true,
                queryMode: 'local',
                boolCombo: ctrl.boolCombo,
                triggerAction: 'all',
                iconCls: 'no-icon',
                editable: cboCfg.editable || false,
                fieldLabel: ctrl.label,
                disabled: ctrl.disabled,
                hidden: ctrl.hidden,
                disabledCls: ctrl.disabledCls,
                readOnly: ctrl.readOnly,
                fieldCls: ctrl.cls,
                code: ctrl.itemId,
                hideTrigger: ctrl.hideTrigger,
                multiSelect: ctrl.multiSelect,
                labelWidth: ctrl.labelWidth,
                forceSelection: ctrl.forceSelection
            });

        if (isTpl) {
            cboCfg.itemId = ctrl.itemId;
            if (ctrl.value != null) cboCfg.value = ctrl.value;

            try {
                //Замена нулевого значения на спец. символ
                if (ctrl.rows[0][1] === null) {
                    ctrl.rows[0][1] = '&nbsp';
                }
            } catch (e) {
            }

            cboCfg.store = new Ext.data.ArrayStore({
                fields: ctrl.fields,
                data: ctrl.rows
            });
        }

        KS.Ext.correctSize(cboCfg, ctrl);
        var combo = new KS.Ext.NullCombo(cboCfg);

        if (ctrl.gridOnExpand) {
            combo.on('destroy',
                function() {
                    KS.gridOnExpandParentWindow && KS.gridOnExpandParentWindow.close();
                });
        }


        if (isTpl) {
            setTemplateListeners(combo, ctrl.listeners, view);
        } else {
            setViewListeners(combo, cboCfg.viewListeners, view);
        }

        return combo;
    }

    function createTextEditor(ctrl, cfg) {
        var view = ctrl.parentView,
            buttonsCount = 0, items = [{}], editor;

        cfg = KS.apply(cfg || {}, ctrl.json, {
            parentView: view,
            code: ctrl.itemId,
            value: ctrl.value,
            hideTrigger: ctrl.hideTrigger
        });

        var triggers = resolveTriggers(cfg, ctrl);

        if (!(ctrl.listeners && ctrl.listeners['selectbtn'])) {
            triggers = $.extend(true, {
                edit: {
                    xclass: 'KS.Ext.view.trigger.Edit',
                    readOnly: ctrl.readOnly,
                    hideOnReadOnly: false,
                    parentView: view
                }
            }, triggers);
        }
        
        if (Object.keys(triggers).length)
            cfg.triggers = triggers;

        if (ctrl.isHyperlink) {
            KS.apply(cfg, {
                addedFieldCls: ctrl.cls,
                readOnly: ctrl.readOnly,
                flex: 1,
                labelWidth: ctrl.labelWidth
            });
            
            if (cfg.triggers && cfg.triggers.edit)
                cfg.triggers.edit.hideOnReadOnly = true;

            //delete cfg.triggers;
            editor = new KS.Ext.Hyperlink(cfg);
        } else if (ctrl.multiline) {
            KS.apply(cfg, {
                fieldCls: ctrl.disabled ? (ctrl.disabledCls || ctrl.cls) : ctrl.cls,
                disabled: ctrl.disabled,
                hidden: ctrl.hidden,
                disabledCls: ctrl.disabledCls,
                readOnly: ctrl.readOnly,
                flex: 1
            });

            KS.Ext.correctSize(cfg, ctrl);
            editor = new Ext.form.TextArea(cfg);
            
        } else {
            cfg.itemId = 'textField';

            KS.apply(cfg, {
                addedFieldCls: ctrl.cls,
                readOnly: ctrl.readOnly,
                flex: 1,
                labelWidth: ctrl.labelWidth,
                saveWraps: true
            });

            editor = KS.create('textField', cfg);
            
            editor.on('afterrender', function(t) {
                if (t.addedFieldCls) {
                    t.inputEl.addCls(t.addedFieldCls);
                }
            }, ctrl, { single: true });

        }

        setTemplateListeners(editor, ctrl.listeners, view);
        items[0] = editor;

        if (buttonsCount)
            items[0].setStyle('margin-right', '5px');

        var cntrCfg = {
            ctrl: ctrl,
            fieldLabel: ctrl.label,
            label: ctrl.label,
            labelWidth: ctrl.labelWidth,
            labelAlign: cfg.labelAlign,
            anchor: ctrl.anchor,
            padding: ctrl.padding,
            cls: ctrl.cls,
            disabled: ctrl.disabled,
            hidden: ctrl.hidden,
            disabledCls: ctrl.disabledCls,
            textField: items[0],
            items: items,

            layout: {
                type: 'hbox',
                align: 'stretch'
            },

            setReadOnly: function(readOnly) {
                this.items.each(function(child) {
                    if (child && KS.isFunction(child.setReadOnly)) {
                        child.setReadOnly(readOnly);
                    }
                });
            },

            setFieldReadOnly: function(v) {
                var f = this.getComponent('textField');
                f.setReadOnly(v);
            },

            coloriseChild: function(cls, needAdd) {
                var th = this;
                Ext.each(th.items.items, function(ctrl) {
                    if (ctrl) {
                        ctrl[needAdd ? 'addCls' : 'removeCls'](cls);
                    }
                });
            },

            changeFieldCls: function(cls) {
                var f = this.getComponent('textField');
                if (f.addedFieldCls) {
                    f.inputEl.removeCls(f.addedFieldCls);
                }
                if (cls) {
                    f.inputEl.addCls(cls);
                    f.addedFieldCls = cls;
                }
            },

            setValue: function(v) {
                this.items.get(0).setValue(v);
            },

            getValue: function() {
                return this.items.get(0).getValue();
            },

            getTextRawValue: function () {
                return this.getValue();
            }
        };

        for (var field in cfg) {
            var fParts = field.split('.');
            if (fParts[0] === 'owner') {
                cntrCfg[fParts[1]] = cfg[field];
            }
        }

        if (Ext.isNumber(ctrl.width) && ctrl.width > 0) {
            cntrCfg.width = ctrl.width;
        }

        KS.Ext.correctSize(cntrCfg, ctrl);
        delete cntrCfg.cls;
        editor = new Ext.form.FieldContainer(cntrCfg);
        editor.readOnly = cfg.readOnly;
        editor.buttonsCount = buttonsCount;

        return editor;
    }

    function createNumberEditor(ctrl, cfg) {
        var view = ctrl.parentView;
        cfg = KS.apply(cfg || {},
            ctrl.json,
            {
                parentView: view,
                code: ctrl.itemId,
                maxValue: ctrl.maxValue,
                minValue: ctrl.minValue,
                allowDecimals: ctrl.decimalPrecision > 0,
                decimalPrecision: ctrl.decimalPrecision,
                decimalSeparator: Ext.util.Format.decimalSeparator,
                enforceMaxLength: ctrl.enforceMaxLength,
                maxLength: ctrl.maxLength,
                hideTrigger: ctrl.hideTrigger,
                // Конфиг включение разделителя разрядов
                thousandSeparatorEnabled: true,
                disabled: ctrl.disabled,
                hidden: ctrl.hidden,
                disabledCls: ctrl.disabledCls,
                value: ctrl.value,
                clearedValue: ctrl.clearedValue,
                objectDisplayMode: ctrl.objectDisplayMode,
                enableKeyEvents: true,
            });

        var triggers = resolveTriggers(cfg, ctrl);

        cfg.itemId = 'numberField';
        KS.apply(cfg,
            {
                fieldCls: ctrl.cls,
                readOnly: ctrl.readOnly,
                flex: 1
            });

        if (triggers.clear) {
            Ext.apply(triggers.clear, {
                scope: numberField,
                handler: function() {
                    this.setValue(this.clearedValue);
                }
            });
        }

        if (Object.keys(triggers).length)
            cfg.triggers = triggers;

        var numberField = KS.create('numberField', cfg),
            items = [numberField];

        setTemplateListeners(numberField, ctrl.listeners, view);

        var cntrCfg = {
            layout: 'hbox',
            fieldLabel: ctrl.label,
            label: ctrl.label,
            items: items,
            setReadOnly: function(readOnly) {
                var th = this;
                Ext.each(th.items.items,
                    function(ctrl) {
                        if (ctrl && KS.isFunction(ctrl.setReadOnly)) {
                            ctrl.setReadOnly(readOnly);
                        }
                    });
            },
            coloriseChild: function(cls, needAdd) {
                var th = this;
                Ext.each(th.items.items,
                    function(ctrl) {
                        if (ctrl) {
                            ctrl[needAdd ? 'addCls' : 'removeCls'](cls);
                        }
                    });
            },
            setValue: function(v) {
                numberField.setValue(v);
            },
            getValue: function() {
                return numberField.getValue();
            },
            getTextRawValue: function () {
                return numberField.rawValue;
            }
        };

        KS.Ext.correctSize(cntrCfg, ctrl);
        delete cntrCfg.cls;
        var fieldContainer = new Ext.form.FieldContainer(cntrCfg);
        fieldContainer.readOnly = ctrl.readOnly;
        return fieldContainer;
    }

    function createDateTimeEditor(ctrl, cfg) {
        var view = ctrl.parentView;
		var value = ctrl.value ? KS.parseAjaxDateTime(ctrl.value) : undefined;
        KS.apply(cfg || {},
            ctrl.json,
            {
                parentView: view,
                flex: 1,
                format: ctrl.format,
                fieldLabel: ctrl.label,
                disabled: ctrl.disabled,
                hidden: ctrl.hidden,
                disabledCls: ctrl.disabledCls,
                code: ctrl.itemId,
                anchor: ctrl.anchor,
                readOnly: ctrl.readOnly,
                hideTrigger: ctrl.hideTrigger,
                cls: ctrl.cls,
                disabledDays: [],
                editable: ctrl.editable || false,
                value: value
            });

        var triggers = resolveTriggers(cfg, ctrl);

        if (ctrl.cls) {
            cfg.fieldCls = Ext.form.DateField.prototype.fieldCls + ' ' + ctrl.cls;
        }

        if (Object.keys(triggers).length)
            cfg.triggers = triggers;

        if (ctrl.showTime) {
            // var timeEditor = new Ext.form.field.Time({
            // parentView: view,
            // flex: 1,
            // format: 'H:i',
            // disabled: ctrl.disabled,
            // readOnly: ctrl.readOnly,
            // editable: false
            // //value: ctrl.value ? KS.parseAjaxDateTime(ctrl.value) : undefined
            // });
            // items.push(timeEditor);
            cfg.format = cfg.format + " H:i";
            cfg.editable = true;
            cfg.value = value;
        }

        var dateEditor = new Ext.form.field.Date(cfg);
        
        setTemplateListeners(dateEditor, ctrl.listeners, view);
        if (ctrl.simple) return dateEditor;

		var items = [dateEditor];

        var cntrCfg = {
                layout: 'hbox',
                fieldLabel: ctrl.label,
                label: ctrl.label,
                items: items,
                setReadOnly: function(readOnly) {
                    var th = this;
                    Ext.each(th.items.items,
                        function(ctrl) {
                            if (ctrl && KS.isFunction(ctrl.setReadOnly)) {
                                ctrl.setReadOnly(readOnly);
                            }
                        });
                },
                coloriseChild: function(cls, needAdd) {
                    var th = this;
                    Ext.each(th.items.items,
                        function(ctrl) {
                            if (ctrl) {
                                ctrl[needAdd ? 'addCls' : 'removeCls'](cls);
                            }
                        });
                },
                setValue: function(v) {
                    if (KS.isEmpty(v)) {
                        dateEditor.setValue(v);
                    } else {
                        var dt = KS.parseAjaxDateTime(v);
                        if (KS.isEmpty(dt))
                            dateEditor.setValue(v);
                        else
                            dateEditor.setValue(dt);
                    }
                },
                getValue: function() {
                    return dateEditor.getValue();
                },
                getTextRawValue: function () {
                    return dateEditor.rawValue;
                }
            };

        KS.Ext.correctSize(cntrCfg, ctrl);
        delete cntrCfg.cls;
        return new Ext.form.FieldContainer(cntrCfg);
    }

    function createCheckbox() {
        var isTpl = Ext.isObject(arguments[0]),
            ctrl = arguments[0],
            view = isTpl ? ctrl.parentView : arguments[3],
            cbxCfg = isTpl ? KS.apply(arguments[1] || {}, ctrl.json) : arguments[4],
            label = isTpl ? ctrl.label : arguments[1],
            checked = isTpl ? ctrl.value === true : arguments[2];
        
        KS.apply(cbxCfg,
            {
                boxLabel: cbxCfg.boxLabel || label,
                itemId: ctrl.itemId,
                value: ctrl.value,
                disabled: ctrl.disabled,
                hidden: ctrl.hidden,
                disabledCls: ctrl.disabledCls,
                code: ctrl.itemId,
                checked: checked,

                coloriseChild: function(cls, needAdd) {
                    this[needAdd ? 'addCls' : 'removeCls'](cls);
                },
                
                //TODO после переделки на FLEX layout, удалить
                listeners: {
                    'afterrender': function(view){
                        if(view.cultureWidth) {
                            var labelText = view.getEl().down('label.x-form-cb-label-default');

                            labelText.setStyle({
                                'max-width': view.cultureWidth + 'px',
                                'overflow': 'hidden',
                                'text-overflow': 'ellipsis',
                                'white-space': 'nowrap'
                            });

                            Ext.QuickTips.register({
                                target: view.getEl(),
                                text: label
                            });
                        }
                    }
                }
            });
        KS.Ext.correctSize(cbxCfg, ctrl);
        
        var checkbox = new Ext.form.Checkbox(cbxCfg);
        if (isTpl) {
            setTemplateListeners(checkbox, ctrl.listeners, view);
        } else {
            setViewListeners(checkbox, cbxCfg.viewListeners, view);
        }
        
        return checkbox;
    }

    function createRadio() {
        var isTpl = Ext.isObject(arguments[0]),
            ctrl = arguments[0],
            view = isTpl ? ctrl.parentView : arguments[3],
            cbxCfg = isTpl ? KS.apply(arguments[1] || {}, ctrl.json) : arguments[4],
            label = isTpl ? ctrl.label : arguments[1],
            checked = isTpl ? ctrl.value === true : arguments[2];

        KS.apply(cbxCfg,
            {
                boxLabel: cbxCfg.boxLabel || label,
                itemId: ctrl.itemId,
                value: ctrl.value,
                checked: checked
            });
        KS.Ext.correctSize(cbxCfg, ctrl);
        var radio = new Ext.form.Radio(cbxCfg);
        if (isTpl) {
            setTemplateListeners(radio, ctrl.listeners, view);
        } else {
            setViewListeners(radio, cbxCfg.viewListeners, view);
        }
        return radio;
    }

    function createTagField() {
        var isTpl = Ext.isObject(arguments[0]),
            ctrl = arguments[0],
            view = isTpl ? ctrl.parentView : arguments[1],
            cboCfg = isTpl ? KS.apply(arguments[1] || {}, ctrl.json) : arguments[2];

        if (isTpl) {
            cboCfg.itemId = ctrl.itemId;
            if (ctrl.value != null) cboCfg.value = ctrl.value;

            try {
                //Замена нулевого значения на спец. символ
                if (ctrl.rows[0][1] === null) {
                    ctrl.rows[0][1] = '&nbsp';
                }
            } catch (e) {
            }
        }

        KS.apply(cboCfg,
            {
                parentView: view,
                //typeAhead: true,
                queryMode: ctrl.queryMode,
                displayField: 'name',
                valueField: 'code',
                filterPickList: ctrl.filterPickList,
                fieldLabel: ctrl.label,
                labelWidth: ctrl.labelWidth
            });

        cboCfg.store = new Ext.data.ArrayStore({
            fields: ctrl.fields,
            data: ctrl.rows
        });

        KS.Ext.correctSize(cboCfg, ctrl);
        var tagField = new Ext.form.field.Tag(cboCfg);
        if (isTpl) {
            setTemplateListeners(tagField, ctrl.listeners, view);
        } else {
            setViewListeners(tagField, cboCfg.viewListeners, view);
        }

        return tagField;
    }

    function createLabel() {
        var ctrl = arguments[0],
            view = ctrl.parentView,
            lblCfg = KS.apply(arguments[1] || {}, ctrl.json);

        if (KS.isString(lblCfg)) {
            lblCfg = {
                text: lblCfg
            };
        }
        
        KS.apply(lblCfg,
            {
                text: ctrl.value || lblCfg.text,
                autoEl:{
                    tag: 'label',
                    "data-qtip": Ext.String.htmlEncode(ctrl.value || lblCfg.text),
                },
                padding: ctrl.padding,
                
                // надо вешать стиль с шириной, чтобы они не наползали друг на друга
                listeners: {
                    added: function(th, container, pos) {
                        th.setWidth(container.width);
                    }
                }
            });

        KS.Ext.correctSize(lblCfg, ctrl);
        
        lblCfg.cls = 'ks-label-text ' + (lblCfg.cls || '');

        var result, label;

        if (lblCfg.ctrl && lblCfg.ctrl.IsBackgroundFilled) {
            label = new Ext.form.Label(lblCfg);
            setTemplateListeners(label, ctrl.listeners, view);

            result = new Ext.container.Container({
                items: label,
                cls: lblCfg.ctrl.containerCls
            });
        } else {
            result = label = new Ext.form.Label(lblCfg);
        }

        setTemplateListeners(label, ctrl.listeners, view);

        return result;
    }

    function createSimpleMenu() {
        var view = arguments[1],
            items = arguments[2],
            defaults = arguments[3] || { scope: view },
            menu = new Ext.menu.Menu({
                defaults: defaults,
                items: items
            });
        return menu;
    }

    function createToolbar() {
        var isTpl = Ext.isString(arguments[1]),
            tbCfg = isTpl ? {} : arguments[1] || {},
            parentView = arguments[2];

        if (isTpl) {
            if (!parentView) return false;
        } else {
            tbCfg['enableOverflow'] = true;
            // This one breaks separators in toolbars
            //tbCfg.ui = arguments[1].itemId + '-toolbar';
        }

        if (tbCfg.dock === 'Left') {
            tbCfg.layout = {
                type: 'vbox',
                align: 'begin'
            };
        }

        Ext.each(tbCfg.items,
            function(item) {
                if (item.tbarNode.hotKey) {
                    var keyMap = {};
                    keyMap[item.tbarNode.hotKey] = {
                        handler: item.handler,
                        scope: item
                    };
                    parentView.setKeyMap(keyMap);
                }
            });

        return new Ext.toolbar.Toolbar(tbCfg);
    }

    function createTbarButton() {
        var tbarNode = arguments[1],
            view = arguments[2],
            showText = arguments[3] === true,
            btn = {
                tooltip: tbarNode.tooltip || tbarNode.name,
                parentView: view,
                handler: view.getTbarClickHandler(tbarNode)
            };
        KS.apply(btn, tbarNode.additional);
        var hasIcon = view.resolveTbarItemImage(btn, tbarNode.image);
        if (showText || tbarNode.parentNode || !hasIcon) btn.text = tbarNode.name;
        return btn;
    }

    function createButton() {
        var ctrl = arguments[0],
            btnCfg = KS.apply(arguments[1] || {}, ctrl.json);
        var view = ctrl.parentView;
        KS.apply(btnCfg,
            {
                parentView: ctrl.parentView,
                tooltip: ctrl.tooltip,
                text: ctrl.text,
                handler: resolveHandler(ctrl.handler, view),
                disabled: ctrl.disabled,
                hidden: ctrl.hidden,
                disabledCls: ctrl.disabledCls,
            });
        KS.Ext.correctSize(btnCfg, ctrl);
        var btn = new Ext.Button(btnCfg);
        return btn;
    }

    function createSplitter() {
        var ctrl = arguments[0],
            splitterCfg = KS.apply({},
            {
                parentView: ctrl.parentView,
                collapsible: ctrl.collapsible,
                    collapseTarget: ctrl.collapseTarget || 'next'
            });

        return new Ext.resizer.Splitter(splitterCfg);
    }

    function createImage() {
        var isTpl = Ext.isObject(arguments[0]),
            ctrl = isTpl ? arguments[0] : arguments[1],
            view = isTpl ? ctrl.parentView : arguments[3],
            imgCfg = isTpl ? KS.apply(arguments[1] || {}, ctrl.json) : arguments[4];

        KS.Ext.correctSize(imgCfg, ctrl);

        if (ctrl.src) imgCfg.url = ctrl.src;

        var image = new KS.Ext.ImageComponent(imgCfg);

        if (isTpl) {
            setTemplateListeners(image, ctrl.listeners, view);
        } else {
            setViewListeners(image, imgCfg.viewListeners, view);
        }

        return image;
    }


    KS.apply(KS.Ext,
        {
            setTemplateListeners: function(inst, listeners, view) {
                if (Ext.isEmpty(listeners) || !Ext.isFunction(inst.on)) return;
                for (var event in listeners) {
                    if (listeners.hasOwnProperty(event)) {
                        var evObj = inst,
                            scope = view,
                            options = {},
                            eventParts = event.split('.'),
                            eventName = eventParts[0],
                            listener = listeners[event],
                            handler = null,
                            defer = 0;

                        if (eventParts.length > 1) {
                            switch (eventParts[0]) {
                            case 'sm':
                                evObj = inst.getSelectionModel();
                                break;
                            }
                            eventName = eventParts[1];
                        }

                        switch (typeof listener) {
                        case 'string':
                            var targetParts = listener.split('.');
                            handler = view[targetParts[1]] || view.notImplementedHandler;

                            if (!Ext.isEmpty(targetParts[1])) {
                                switch (targetParts[0]) {
                                case 'self':
                                    scope = evObj;
                                    if (Ext.isFunction(evObj[targetParts[1]]))
                                        handler = evObj[targetParts[1]];
                                    break;
                                case 'view':
                                    scope = view;
                                    break;
                                default:
                                    if (view.tpl && view.tpl.controls && view.tpl.controls[targetParts[0]])
                                        scope = view.tpl.controls[targetParts[0]];
                                    break;
                                }
                            }
                            break;
                        case 'object':
                        case '[object Object]':
                            if (listener && listener.methodName) {
                                scope = {
                                    listener: listener,
                                    eventName: eventName,
                                    view: view,
                                    inst: evObj
                                };
                                defer = listener.defer;
                                handler = view.serverEventInterceptor;
                                break;
                            }
                            if (listener && listener.method) {
                                handler = view[listener.method];
                            }
                            if (!KS.isFunction(handler)) {
                                handler = view.notImplementedHandler;
                            }
                            scope = listener.scope === 'view' ? view : evObj;
                            options = { buffer: listener.buffer };
                            break;
                        case 'function':
                            handler = listener;
                            break;
                        default:
                            scope = {
                                listener: listener,
                                eventName: eventName,
                                view: view,
                                inst: evObj
                            };
                            handler = view.serverEventInterceptor;
                            break;
                        }

                        if (defer > 0) {
                            Ext.Function.defer(evObj.addListener, defer, evObj, [eventName, handler, scope, options]);
                        } else {
                            evObj.on(eventName, handler, scope, options);
                        }
                    }
                }
            },

            correctSize: function(cfg, ctrl) {
                KS.Ext.fixLayout(cfg, ctrl);
                if (ctrl.x > 0) cfg.x = ctrl.x;
                if (ctrl.y > 0) cfg.y = ctrl.y;
                if (!KS.isEmpty(ctrl.cls)) cfg.cls = ctrl.cls;
                if (Ext.isNumber(cfg.width) && cfg.width > 0 && cfg.width <= 1) {
                    var tw = KS.tabViewport.getSize().width;
                    cfg.width = tw * cfg.width;
                    if (ctrl && ctrl.json) {
                        ctrl.json.width = cfg.width;
                    }
                }

                if (Ext.isNumber(cfg.height) && cfg.height > 0 && cfg.height <= 1) {
                    var th = KS.tabViewport.getSize().height;
                    cfg.height = th * cfg.height;
                    if (ctrl && ctrl.json) {
                        ctrl.json.height = cfg.height;
                    }
                }

                if (Ext.isBoolean(ctrl.collapsed)) {
                    cfg.collapsible = true;
                    cfg.collapsed = ctrl.collapsed;
                }
            },

            fixLayout: function(cfg, ctrl) {
                if (Ext.isString(cfg.layout) && cfg.layoutConfig) {
                    var layout = cfg.layoutConfig;
                    KS.apply(layout, { type: cfg.layout });
                    KS.apply(cfg, { layout: layout });
                    delete cfg.layoutConfig;
                }
                if (!KS.isEmpty(ctrl.anchor) && KS.isString(ctrl.anchor)) {
                    cfg.anchor = ctrl.anchor;
                }
            },

            processTbarItems: function(rawTbarItems) {
                var tbarItems = [];
                Ext.each(rawTbarItems,
                    function(tbItem) {
                        if (Ext.isString(tbItem)) {
                            if (tbItem === '-') {
                                tbarItems.push({ xtype: 'tbseparator' });
                            } else if (tbItem.indexOf(' ') === 0) {
                                var width = +tbItem.substring(1);
                                if (!(width > 0)) width = 3;
                                tbarItems.push(KS.create('tbspacer', width));
                            }
                        } else if (tbItem.nodeStyle === 4 && tbItem.code === 'Fill') {
                            tbarItems.push(KS.create('tbfill'));
                        } else if (tbItem.nodeStyle === 4 && tbItem.code.startsWith('Space')) {
                            tbarItems.push(KS.create('tbspacer', +tbItem.code.split('_')[1]));
                        } else {
                            tbarItems.push(tbItem);
                        }
                    });
                return tbarItems;
            },

            knownControlRenderers: {
                'container': createContainer,
                'panel': createPanel,
                'tabPanel': createTabPanel,
                'propertyGrid': createPropertyGrid,
                'combo': createCombo,
                'textEditor': createTextEditor,
                'numberEditor': createNumberEditor,
                'dateTimeEditor': createDateTimeEditor,
                'checkbox': createCheckbox,
                'image': createImage,
                'label': createLabel,
                'simpleMenu': createSimpleMenu,
                'toolbar': createToolbar,
                'tbarbutton': createTbarButton,
                'button': createButton,
                'radio': createRadio,
                'tagField': createTagField,
                'splitter': createSplitter
            },

            registerControlRenderer: function(xname, rendererFn) {
                if (Ext.isFunction(rendererFn))
                    KS.Ext.knownControlRenderers[xname] = rendererFn;
            },

            create: function() {
                var isTpl = Ext.isObject(arguments[0]),
                    type = isTpl ? arguments[0].type : arguments[0],
                    ctrl = isTpl ? arguments[0] : {};

                if (isTpl && Ext.isObject(arguments[1])) {
                    arguments[1].ctrl = ctrl;
                }

                switch (type) {
                case 'hidebutton':
                    return new Ext.button.Button(arguments[1]);

                case 'tbspacer':
                    return new Ext.toolbar.Spacer({ xtype: 'tbspacer', width: arguments[1] });

                case 'tbseparator':
                    var tbarNode = arguments[1];
                    if (tbarNode && tbarNode.parentNode) {
                        if (!Ext.isEmpty(tbarNode.additional)) {
                            KS.apply(tbarNode, tbarNode.additional);
                        }
                        return Ext.create('Ext.menu.Separator', tbarNode);
                    }
                    return new Ext.toolbar.Separator();

                case 'tbfill':
                    return new Ext.toolbar.Fill();

                case 'textField':
                    return new Ext.form.field.Text(arguments[1]);

                case 'numberField':
                    return new KS.Ext.form.field.Number(arguments[1]);

                case 'textArea':
                    return new Ext.form.field.TextArea(arguments[1]);

                case 'dateField':
                    var dateField = new Ext.form.field.Date(arguments[1]);
                    setTemplateListeners(dateField, ctrl.listeners, ctrl.parentView);
                    return dateField;

                case 'tree':
                case 'treeGrid':
                    var treeCfg = KS.apply(arguments[1] || {}, ctrl.json),
                        tree = Ext.create('KS.Ext.Tree', ctrl, treeCfg);
                    setTemplateListeners(tree, ctrl.listeners, ctrl.parentView);
                    return tree;
                    /*
                
                                    
                    var treeGridCfg = KS.apply(arguments[1] || {}, ctrl.json),
                        treeGrid = Ext.create('KS.Ext.TreeGrid', ctrl, treeCfg);
                    setTemplateListeners(tree, ctrl.listeners, ctrl.parentView);
                    return tree;*/

                case 'grid':
                    var gridCfg = KS.apply(arguments[1] || {}, ctrl.json),
                        serverCfg = Ext.apply({}, gridCfg),
                        grid = Ext.create('KS.Ext.Grid', ctrl, gridCfg);

                    grid.serverCfg = serverCfg;
                    setTemplateListeners(grid, ctrl.listeners, ctrl.parentView);
                    return grid;

                case 'fieldset':
                    var fsetCfg = KS.apply(arguments[1] || {},
                        ctrl.json,
                        {
                            collapsible: ctrl.collapsible,
                            collapsed: ctrl.collapsible && ctrl.collapsed,
                            checkboxToggle: ctrl.checkboxToggle,
                            title: ctrl.title
                        });
                    KS.Ext.correctSize(fsetCfg, ctrl);
                    var fset = Ext.create('Ext.form.FieldSet', fsetCfg);
                    setTemplateListeners(fset, ctrl.listeners, ctrl.parentView);
                    return fset;

                case 'fieldcontainer':
                    var fcntCfg = KS.apply(arguments[1] || {},
                            ctrl.json,
                            {
                            }),
                        fcnt = Ext.create('Ext.form.FieldContainer', fcntCfg);
                    setTemplateListeners(fcnt, ctrl.listeners, ctrl.parentView);
                    return fcnt;

                case 'radiogroup':
                    var radioGroupCfg = KS.apply(arguments[1] || {},
                            ctrl.json,
                            {
                                columns: ctrl.columns,
                                vertical: ctrl.vertical,
                                title: ctrl.title,
                                itemId: ctrl.itemId,
                                disabled: ctrl.disabled,
                                hidden: ctrl.hidden,
                                disabledCls: ctrl.disabledCls,
                                items: ctrl.isToolBar ? ctrl.items : null
                            }),
                        radioGroup = Ext.create('Ext.form.RadioGroup', radioGroupCfg);
                    setTemplateListeners(radioGroup, ctrl.listeners, ctrl.parentView);
                    return radioGroup;

                case 'checkboxgroup':
                    var checkboxGroupCfg = KS.apply(arguments[1] || {},
                            ctrl.json,
                            {
                                columns: ctrl.columns,
                                vertical: ctrl.vertical,
                                title: ctrl.title
                            }),
                        checkboxGroup = Ext.create('Ext.form.CheckboxGroup', checkboxGroupCfg);
                    setTemplateListeners(checkboxGroup, ctrl.listeners, ctrl.parentView);
                    return checkboxGroup;

                case 'buttongroup':
                    var buttonGroupCfg = KS.apply(arguments[1] || {},
                            ctrl.json,
                            {
                                columns: ctrl.columns,
                                title: ctrl.title,
                                itemId: ctrl.itemId,
                                items: ctrl.items
                            }),
                        buttonGroup = Ext.create('Ext.container.ButtonGroup', buttonGroupCfg);
                    setTemplateListeners(buttonGroup, ctrl.listeners, ctrl.parentView);
                    return buttonGroup;

                case 'htmleditor':
                    var htmlEditorCfg = KS.apply(arguments[1] || {},
                            ctrl.json,
                            {
                                title: ctrl.title,
                                itemId: ctrl.itemId,
                                value: ctrl.value
                            }),
                        htmlEditor = Ext.create('Ext.form.field.HtmlEditor', htmlEditorCfg);
                    setTemplateListeners(htmlEditor, ctrl.listeners, ctrl.parentView);
                    return htmlEditor;

                case 'spreadsheetframe':
                    var spreadsheetFrameCfg = KS.apply(arguments[1] || {}, ctrl.json, { html: ctrl.html } );
                    return new KS.Ext.SpreadsheetFrame(spreadsheetFrameCfg);

                case 'richeditframe':
                    var richEditFrameCfg = KS.apply(arguments[1] || {}, ctrl.json, { html: ctrl.html } );
                    return new KS.Ext.RichEditFrame(richEditFrameCfg);
                }

                var rendererFn = KS.Ext.knownControlRenderers[type];
                if (Ext.isFunction(rendererFn)) {
                    return rendererFn.apply(this, arguments);
                }

                KS.error('Unknown component ' + type);
                return null;
            }
        });
})();




// Ext.ux.StatusBar
(function() {
    Ext.define('Ext.ux.statusbar.StatusBar',
        {
            extend: 'Ext.toolbar.Toolbar',
            xtype: 'statusbar',
            alternateClassName: 'Ext.ux.StatusBar',
            requires: ['Ext.toolbar.TextItem'],
            /**
             * @cfg {String} statusAlign 
             * The alignment of the status element within the overall StatusBar layout.  When the StatusBar is rendered,
             * it creates an internal div containing the status text and icon.  Any additional Toolbar items added in the
             * StatusBar's {@link #cfg-items} config, or added via {@link #method-add} or any of the supported add* methods, will be
             * rendered, in added order, to the opposite side.  The status element is greedy, so it will automatically
             * expand to take up all sapce left over by any other items.  Example usage:
             *
             *     // Create a left-aligned status bar containing a button,
             *     // separator and text item that will be right-aligned (default):
             *     Ext.create('Ext.Panel', {
             *         title: 'StatusBar',
             *         // etc.
             *         bbar: Ext.create('Ext.ux.statusbar.StatusBar', {
             *             defaultText: 'Default status text',
             *             id: 'status-id',
             *             items: [{
             *                 text: 'A Button'
             *             }, '-', 'Plain Text']
             *         })
             *     });
             *
             *     // By adding the statusAlign config, this will create the
             *     // exact same toolbar, except the status and toolbar item
             *     // layout will be reversed from the previous example:
             *     Ext.create('Ext.Panel', {
             *         title: 'StatusBar',
             *         // etc.
             *         bbar: Ext.create('Ext.ux.statusbar.StatusBar', {
             *             defaultText: 'Default status text',
             *             id: 'status-id',
             *             statusAlign: 'right',
             *             items: [{
             *                 text: 'A Button'
             *             }, '-', 'Plain Text']
             *         })
             *     });
             */
            /**
             * @cfg {String} [defaultText='']
             * The default {@link #text} value.  This will be used anytime the status bar is cleared with the
             * `useDefaults:true` option.
             */
            /**
             * @cfg {String} [defaultIconCls='']
             * The default {@link #iconCls} value (see the iconCls docs for additional details about customizing the icon).
             * This will be used anytime the status bar is cleared with the `useDefaults:true` option.
             */
            /**
             * @cfg {String} text 
             * A string that will be <b>initially</b> set as the status message.  This string
             * will be set as innerHTML (html tags are accepted) for the toolbar item.
             * If not specified, the value set for {@link #defaultText} will be used.
             */
            /**
             * @cfg [iconCls='']
             * @inheritdoc Ext.panel.Header#cfg-iconCls
             * @localdoc **Note:** This CSS class will be **initially** set as the status bar 
             * icon.  See also {@link #defaultIconCls} and {@link #busyIconCls}.
             *
             * Example usage:
             *
             *     // Example CSS rule:
             *     .x-statusbar .x-status-custom {
             *         padding-left: 25px;
             *         background: transparent url(images/custom-icon.gif) no-repeat 3px 2px;
             *     }
             *
             *     // Setting a default icon:
             *     var sb = Ext.create('Ext.ux.statusbar.StatusBar', {
             *         defaultIconCls: 'x-status-custom'
             *     });
             *
             *     // Changing the icon:
             *     sb.setStatus({
             *         text: 'New status',
             *         iconCls: 'x-status-custom'
             *     });
             */

            /**
             * @cfg {String} cls 
             * The base class applied to the containing element for this component on render.
             */
            cls: 'x-statusbar',
            /**
             * @cfg {String} busyIconCls 
             * The default {@link #iconCls} applied when calling {@link #showBusy}.
             * It can be overridden at any time by passing the `iconCls` argument into {@link #showBusy}.
             */
            busyIconCls: 'x-status-busy',
            /**
             * @cfg {String} busyText 
             * The default {@link #text} applied when calling {@link #showBusy}.
             * It can be overridden at any time by passing the `text` argument into {@link #showBusy}.
             */
            busyText: 'Loading...',
            /**
             * @cfg {Number} autoClear 
             * The number of milliseconds to wait after setting the status via
             * {@link #setStatus} before automatically clearing the status text and icon.
             * Note that this only applies when passing the `clear` argument to {@link #setStatus}
             * since that is the only way to defer clearing the status.  This can
             * be overridden by specifying a different `wait` value in {@link #setStatus}.
             * Calls to {@link #clearStatus} always clear the status bar immediately and ignore this value.
             */
            autoClear: 5000,

            /**
             * @cfg {String} emptyText 
             * The text string to use if no text has been set. If there are no other items in
             * the toolbar using an empty string (`''`) for this value would end up in the toolbar
             * height collapsing since the empty string will not maintain the toolbar height.
             * Use `''` if the toolbar should collapse in height vertically when no text is
             * specified and there are no other items in the toolbar.
             */
            emptyText: '&#160;',

            /**
             * @private
             */
            activeThreadId: 0,

            initComponent: function() {
                var right = this.statusAlign === 'right';

                this.callParent(arguments);
                this.currIconCls = this.iconCls || this.defaultIconCls;
                this.statusEl = Ext.create('Ext.toolbar.TextItem',
                    {
                        cls: 'x-status-text ' + (this.currIconCls || ''),
                        text: this.text || this.defaultText || ''
                    });

                if (right) {
                    this.cls += ' x-status-right';
                    this.add('->');
                    this.add(this.statusEl);
                } else {
                    this.insert(0, this.statusEl);
                    this.insert(1, '->');
                }
            },

            /**
             * Sets the status {@link #text} and/or {@link #iconCls}. Also supports automatically clearing the
             * status that was set after a specified interval.
             *
             * Example usage:
             *
             *     // Simple call to update the text
             *     statusBar.setStatus('New status');
             *
             *     // Set the status and icon, auto-clearing with default options:
             *     statusBar.setStatus({
             *         text: 'New status',
             *         iconCls: 'x-status-custom',
             *         clear: true
             *     });
             *
             *     // Auto-clear with custom options:
             *     statusBar.setStatus({
             *         text: 'New status',
             *         iconCls: 'x-status-custom',
             *         clear: {
             *             wait: 8000,
             *             anim: false,
             *             useDefaults: false
             *         }
             *     });
             *
             * @param {Object/String} config A config object specifying what status to set, or a string assumed
             * to be the status text (and all other options are defaulted as explained below). A config
             * object containing any or all of the following properties can be passed:
             *
             * @param {String} config.text The status text to display.  If not specified, any current
             * status text will remain unchanged.
             *
             * @param {String} config.iconCls The CSS class used to customize the status icon (see
             * {@link #iconCls} for details). If not specified, any current iconCls will remain unchanged.
             *
             * @param {Boolean/Number/Object} config.clear Allows you to set an internal callback that will
             * automatically clear the status text and iconCls after a specified amount of time has passed. If clear is not
             * specified, the new status will not be auto-cleared and will stay until updated again or cleared using
             * {@link #clearStatus}. If `true` is passed, the status will be cleared using {@link #autoClear},
             * {@link #defaultText} and {@link #defaultIconCls} via a fade out animation. If a numeric value is passed,
             * it will be used as the callback interval (in milliseconds), overriding the {@link #autoClear} value.
             * All other options will be defaulted as with the boolean option.  To customize any other options,
             * you can pass an object in the format:
             * 
             * @param {Number} config.clear.wait The number of milliseconds to wait before clearing
             * (defaults to {@link #autoClear}).
             * @param {Boolean} config.clear.anim False to clear the status immediately once the callback
             * executes (defaults to true which fades the status out).
             * @param {Boolean} config.clear.useDefaults False to completely clear the status text and iconCls
             * (defaults to true which uses {@link #defaultText} and {@link #defaultIconCls}).
             *
             * @return {Ext.ux.statusbar.StatusBar} this
             */
            setStatus: function(config) {
                var me = this;

                config = config || {};
                Ext.suspendLayouts();
                if (Ext.isString(config)) {
                    config = { text: config };
                }
                if (config.text !== undefined) {
                    me.setText(config.text);
                }
                if (config.iconCls !== undefined) {
                    me.setIcon(config.iconCls);
                }

                if (config.clear) {
                    var c = config.clear,
                        wait = me.autoClear,
                        defaults = { useDefaults: true, anim: true };

                    if (Ext.isObject(c)) {
                        c = Ext.applyIf(c, defaults);
                        if (c.wait) {
                            wait = c.wait;
                        }
                    } else if (Ext.isNumber(c)) {
                        wait = c;
                        c = defaults;
                    } else if (Ext.isBoolean(c)) {
                        c = defaults;
                    }

                    c.threadId = this.activeThreadId;
                    Ext.defer(me.clearStatus, wait, me, [c]);
                }
                Ext.resumeLayouts(true);
                return me;
            },

            /**
             * Clears the status {@link #text} and {@link #iconCls}. Also supports clearing via an optional fade out animation.
             *
             * @param {Object} [config] A config object containing any or all of the following properties.  If this
             * object is not specified the status will be cleared using the defaults below:
             * @param {Boolean} config.anim True to clear the status by fading out the status element (defaults
             * to false which clears immediately).
             * @param {Boolean} config.useDefaults True to reset the text and icon using {@link #defaultText} and
             * {@link #defaultIconCls} (defaults to false which sets the text to '' and removes any existing icon class).
             *
             * @return {Ext.ux.statusbar.StatusBar} this
             */
            clearStatus: function(config) {
                config = config || {};

                var me = this,
                    statusEl = me.statusEl;

                if (me.destroyed || config.threadId && config.threadId !== me.activeThreadId) {
                    // this means the current call was made internally, but a newer 
                    // thread has set a message since this call was deferred.  Since 
                    // we don't want to overwrite a newer message just ignore. 
                    return me;
                }

                var text = config.useDefaults ? me.defaultText : me.emptyText,
                    iconCls = config.useDefaults ? (me.defaultIconCls ? me.defaultIconCls : '') : '';

                if (config.anim) {
                    // animate the statusEl Ext.Element 
                    statusEl.el.puff({
                        remove: false,
                        useDisplay: true,
                        callback: function() {
                            statusEl.el.show();
                            me.setStatus({
                                text: text,
                                iconCls: iconCls
                            });
                        }
                    });
                } else {
                    me.setStatus({
                        text: text,
                        iconCls: iconCls
                    });
                }
                return me;
            },

            /**
             * Convenience method for setting the status text directly.  For more flexible options see {@link #setStatus}.
             * @param {String} text (optional) The text to set (defaults to '')
             * @return {Ext.ux.statusbar.StatusBar} this
             */
            setText: function(text) {
                var me = this;
                me.activeThreadId++;
                me.text = text || '';
                if (me.rendered) {
                    me.statusEl.setText(me.text);
                }
                return me;
            },

            /**
             * Returns the current status text.
             * @return {String} The status text
             */
            getText: function() {
                return this.text;
            },

            /**
             * Convenience method for setting the status icon directly.  For more flexible options see {@link #setStatus}.
             * See {@link #iconCls} for complete details about customizing the icon.
             * @param {String} cls (optional) The icon class to set (defaults to '', and any current icon class is removed)
             * @return {Ext.ux.statusbar.StatusBar} this
             */
            setIcon: function(cls) {
                var me = this;

                me.activeThreadId++;
                cls = cls || '';

                if (me.rendered) {
                    if (me.currIconCls) {
                        me.statusEl.removeCls(me.currIconCls);
                        me.currIconCls = null;
                    }
                    if (cls.length > 0) {
                        me.statusEl.addCls(cls);
                        me.currIconCls = cls;
                    }
                } else {
                    me.currIconCls = cls;
                }
                return me;
            },

            /**
             * Convenience method for setting the status text and icon to special values that are pre-configured to indicate
             * a "busy" state, usually for loading or processing activities.
             *
             * @param {Object/String} config (optional) A config object in the same format supported by {@link #setStatus}, or a
             * string to use as the status text (in which case all other options for setStatus will be defaulted).  Use the
             * `text` and/or `iconCls` properties on the config to override the default {@link #busyText}
             * and {@link #busyIconCls} settings. If the config argument is not specified, {@link #busyText} and
             * {@link #busyIconCls} will be used in conjunction with all of the default options for {@link #setStatus}.
             * @return {Ext.ux.statusbar.StatusBar} this
             */
            showBusy: function(config) {
                if (Ext.isString(config)) {
                    config = { text: config };
                }
                config = Ext.applyIf(config || {},
                    {
                        text: this.busyText,
                        iconCls: this.busyIconCls
                    });
                return this.setStatus(config);
            }
        });
})();

// KS.Ext.LogDownloader
(function() {
    KS.Ext.LogDownloader = {
        show: function() {
            var me = this;

            WorkspaceView.serverCall({
                method: 'GetLogList',
                success: function(data) {
                    KS.Ext.LogDownloader.initComponents.apply(me, [data]);
                }
            });
        },

        initComponents: function(data) {
            var me = this;

            if (Ext.isEmpty(data)) {
                KS.alert(KS.L10n.emptyMsg);
                return;
            }

            Ext.create('Ext.data.Store',
                {
                    storeId: 'logDownloaderStore',
                    fields: new Array({ name: 'FileName' }, { name: 'Size' }),
                    data: data
                });

            me.logListGrid = Ext.create('Ext.grid.Panel',
                {
                    store: Ext.data.StoreManager.lookup('logDownloaderStore'),
                    columns: new Array({
                            header: KS.L10n.fileNameLabel,
                            width: 300,
                            dataIndex: 'FileName'
                        },
                        {
                            header: KS.L10n.sizeLabel,
                            width: 70,
                            dataIndex: 'Size',
                            renderer: function(value) {
                                return KS.formatSize(value, 1);
                            }
                        }),
                    border: false
                });

            me.logWindow = KS.Ext.showAdjustableWindow([me.logListGrid],
                {
                    title: KS.L10n.serverTextLogs,
                    width: 390,
                    buttons: new Array({
                            text: KS.L10n.download,
                            handler: function() {
                                if (!KS.isValid(me.logWindow.selectedFile))
                                    return;
                                var u = String(window.location.href).replace(/Workspace.*/,
                                    'PlatformHandler.axd?log=' + me.logWindow.selectedFile);
                                KS.openUrl(u);
                            }
                        },
                        {
                            text: KS.L10n.cancel,
                            handler: function() {
                                me.logWindow.close();
                            }
                        })
                });

            me.logListGrid.getSelectionModel().on('selectionchange',
                function(sm) {
                    me.logWindow.selectedFile = null;
                    var s = sm.getSelection();
                    if (!Ext.isEmpty(s))
                        me.logWindow.selectedFile = s[0].data.FileName;
                });

            me.logWindow.selectedFile = null;
            me.logWindow.show();
        }
    };
})();

// KS.Ext.view.trigger.*
// Кнопки для полей
(function() {
    Ext.define('KS.Ext.view.trigger.Clear', {
        extend: 'Ext.form.trigger.Trigger',
        cls: 'ks-icon-clean',
        hideOnReadOnly: false,
        tooltip: KS.L10n.clear,
        itemId: 'clear',
        
        handler: function() {
            this.setValue();
        }
    });

    Ext.define('KS.Ext.view.trigger.EditOrCreate', {
        extend: 'Ext.form.trigger.Trigger',
        itemId: 'edit',
        hideOnReadOnly: false,
        tooltip: KS.L10n.elementItemView_EditButtonTooltip
    });

    Ext.define('KS.Ext.view.trigger.Open', {
        extend: 'Ext.form.trigger.Trigger',
        cls: 'ks-icon-get_dictionary',
        hideOnReadOnly: false,
        tooltip: KS.L10n.lisst,
        
        setReadOnly: function() {
            
        }
    });

    Ext.define('KS.Ext.view.trigger.Expression', {
        extend: 'Ext.form.trigger.Trigger',
        tooltip: KS.L10n.interactivity_DocumentSchema_Expression,
        hideOnReadOnly: false,
        cls: 'ks-icon-fx',
        weight: 0,

        handler: function(field, button) {
            var me = this;

            Ext.create('KS.Ext.TextEditor', {
                textField: me,
                grid: field.grid,
                title: KS.L10n.ExpressionManager,
                parentView: me.parentView,
                textValue: me.expression,
                readOnly: field.readOnly || field.textEditorReadOnly
            });
        }
    });

    Ext.define('KS.Ext.view.trigger.Edit', {
        extend: 'Ext.form.trigger.Trigger',
        tooltip: KS.L10n.edit,
        hideOnReadOnly: false,
        cls: 'ks-text-edit',
        
        handler: function(field, button) {
            var me = this;
            
            Ext.create('KS.Ext.TextEditor', {
                textField: me,
                grid: field.grid,
                parentView: me.parentView,
                textValue: me.value,
                readOnly: field.readOnly || field.textEditorReadOnly
            });
        }
    });
})();

// KS.Ext.ImageComponent
(function() {
    Ext.define('KS.Ext.ImageComponent',
        {
            extend: 'Ext.Component',
            alias: 'widget.ksimage',

            url: Ext.BLANK_IMAGE_URL, //for initial src value

            autoEl: {
                tag: 'img',
                src: Ext.BLANK_IMAGE_URL,
                cls: 'tng-managed-image'
            },

            initComponent: function() {
                KS.Ext.ImageComponent.superclass.initComponent.call(this);
            },

            //  Add our custom processing to the onRender phase.
            //  We add a 'load' listener to our element.
            onRender: function() {
                KS.Ext.ImageComponent.superclass.onRender.apply(this, arguments);
                this.el.on('load', this.onLoad, this);
                if (this.url) {
                    this.setSrc(this.url);
                }
            },

            onLoad: function() {
                this.fireEvent('load', this);
            },

            setSrc: function(src) {
                this.el.dom.src = src;
            }
        });
})();

// KS.Ext.StateProvider
(function() {
    Ext.define('KS.Ext.StateProvider',
        {
            extend: 'Ext.state.Provider',
            requires: ['Ext.state.*'],

            constructor: function() {
                return {
                    get: function(name) {
                        var a = name.split('~');
                        if (a.length != 2)
                            return null;
                        var view = KS.getView(a[1]);
                        if (!view || !view.viewLayout)
                            return null;
                        return typeof(view.viewLayout[a[0]]) === 'string' ? Ext.decode(view.viewLayout[a[0]], true) : view.viewLayout[a[0]];
                    },

                    set: function(name, value) {
                        var a = name.split('~');
                        if (a.length != 2)
                            return;
                        var view = KS.getView(a[1]);
                        if (!view || !view.viewLayout)
                            return;
                        view.viewLayout[a[0]] = value;
                    },

                    clear: function() {
                    }
                };
            }
        });
    Ext.state.Manager.setProvider(new KS.Ext.StateProvider());
})();

// удалить как только подключим транспиляцию в es5
if (Ext.browser.is.IE)
    KS.apply(KS, {
        pasteFromClipboard: function() { }
    });
else
    eval("KS.apply(KS, { " + 
        "pasteFromClipboard: async function(selection) { " + 
            "selection.textArea.focus(); " +
            "var text = await navigator.clipboard.readText(); " +
            "selection.textArea.setValue(selection.left + text + selection.right); " +
        "}" +
    "})");

// KS.Ext.TextEditor
(function() {
    Ext.define('KS.Ext.TextEditor', {
        extend: 'Ext.window.Window',
        title: KS.L10n.textEditor,
        layout: { type: 'vbox', align: 'stretch' },
        resizable: true,
        modal: false,
        autoShow: true,
        width: '40%',
        textBuffer: [],
        closeAction: 'destroy',
        bbarMaxDefaultValue: 'MAX',
        bbarMinDefaultValue: '0',
        fileButton: false,
        cutButton: false,
        copyButton: false,
        pasteButton: false,
        removeButton: false,
        tbFillForUndoNext: true,
        closeIfIsNotValid: true,
        undoTooltipText: KS.L10n.prevValue,
        redoTooltipText: KS.L10n.nextValue,
        readOnly: false,
        skipActionableOnSave: false,
        
        controller: {
            keyboardAction: function(c) { 
                var me = this,
                    selection = me.getSelectionContext();
                
                me[c.action](selection);
            },
            
            cut: function(selection) {
                var me = this;
                
                selection.textArea.setValue(selection.left + selection.right);
                me.copy(selection);
            },
            
            copy: function(selection) {
                KS.copyToClipBoard(selection.text);
            },
            
            paste: function(selection) {
                // window.isSecureContext // проверка на защищенное соединение
                if (window.isSecureContext)
                    try {
                        KS.pasteFromClipboard(selection);
                    } catch (err) {
                        Ext.MessageBox.alert(KS.L10n.attention, KS.L10n.useCtrlVCombination);
                    }
                else
                    Ext.MessageBox.alert(KS.L10n.attention, KS.L10n.useCtrlVCombination);
            },
            
            remove: function(selection) {
                selection.textArea.setValue(selection.left + selection.right);
            },
            
            getSelectionContext: function() {
                var me = this,
                    textArea = me.view.textArea,
                    value = textArea.getRawValue(),
                    selection = textArea.getTextSelection(),
                    start = selection[0],
                    end = selection[1];
                
                return {
                    text: value.slice(start, end),
                    start: start,
                    end: start,
                    value: value,
                    left: value.slice(0, start),
                    right: value.slice(end),
                    textArea: textArea
                };
            },
            
            redo: function() {
                var me = this.view;
                
                if (me.textBufferInd < me.textBuffer.length - 1) {
                    me.ignoreBuffer = true;
                    me.textArea.setValue(me.textBuffer[++me.textBufferInd]);
                    me.ignoreBuffer = false;
                }
            },
            
            undo: function() {
                var me = this.view;
                
                if (me.textBufferInd > 0) {
                    me.ignoreBuffer = true;
                    me.textArea.setValue(me.textBuffer[--me.textBufferInd]);
                    me.ignoreBuffer = false;
                }
            }
        },

        listeners: {
            beforeclose: function(editor) {
                var value = editor.textArea.getValue();
                
                if (!editor.closeIfIsNotValid && !editor.textArea.isValid()) {
                    Ext.MessageBox.alert(KS.L10n.textEditor, editor.textArea.getErrors().join('<br>'));
                    return false;
                }

                if (value != editor.textValue) {
                    new Ext.window.MessageBox().confirm(KS.L10n.textEditor, KS.L10n.textBeenChanged, function(result) {
                        var me = this;

                        if (result === 'yes') {
                            me.save();
                        }

                        if (result === 'yes' || result === 'no') {
                            me.textValue = me.textArea.getValue();
                            me.close();
                        }
                    }, editor);

                    return false;
                }
            }
        },

        initComponent: function() {
            var me = this;

            me.bbar = me.createBbar();
            me.items = me.createItems();
            
            if (!me.readOnly) {
                me.tbar = me.createTbar();
            }
            
            me.callParent(arguments);
        },
        
        createBbar: function() {
            var me = this,
                field = me.textField,
                minLabel = (me.localizeBBar ? KS.L10n.minLabel: 'MIN') + ': ',
                maxLabel = (me.localizeBBar ? KS.L10n.maxLabel: 'MAX') + ': ';

            if (Ext.isEmpty(field.minLength) || field.minLength === 0)
                minLabel += me.bbarMinDefaultValue;
            else 
                minLabel += field.minLength;

            if (Ext.isEmpty(field.maxLength) || field.maxLength === Number.MAX_VALUE)
                maxLabel += me.bbarMaxDefaultValue;
            else
                maxLabel += field.maxLength;

            return [
                minLabel,
                maxLabel,
                '->',
                KS.L10n.charaCount + ': ',
                me.charCount = Ext.create('Ext.form.field.Text',
                    {
                        disabled: true,
                        value: me.textField.getValue() ? me.textField.getValue().length : '0'
                    })
            ];
        },

        createTbar: function() {
            var me = this,
                callback = function(files) {
                    if (files && files[0]) {
                        this.serverCall({
                            method: 'DoSaveFiles',
                            params: [files, true, null],
                            waitMessage: KS.L10n.saving,
                            success: function(file) {
                                me.textArea.setValue(file.content);
                            }
                        });
                    }
                },
                items = [];
            
            me.saveButton = Ext.create({
                xtype: 'button',
                tooltip: KS.L10n.save,
                iconCls: 'ks-icon-save',
                handler: me.save,
                scope: me,
                disabled: !me.textField.isValid()
            });
            
            if (me.fileButton)
                items.push(KS.create({
                    itemId: 'NEW_FILE',
                    parentView: me.parentView,
                    type: 'filefield',
                    usePopup: false,
                    cls: 'ks-toolbar-file-editor'
                }, {
                    buttonOnly: true,
                    callback: callback,
                    width: 18,
                    buttonConfig: {
                        iconCls: 'ks-icon-open',
                        accept: '.txt',
                        text: '',
                        border: 0,
                        tooltip: KS.L10n.open
                    }
                }));
            
            items.push(me.saveButton, {
                xtype: 'button',
                tooltip: KS.L10n.cut,
                iconCls: 'ks-icon-cut',
                handler: 'keyboardAction',
                action: 'cut',
                hidden: !me.cutButton
            }, {
                xtype: 'button',
                tooltip: KS.L10n.copy,
                iconCls: 'ks-icon-copy',
                handler: 'keyboardAction',
                action: 'copy',
                hidden: !me.copyButton
            }, {
                xtype: 'button',
                tooltip: KS.L10n.pasteMenuLabel,
                iconCls: 'ks-icon-paste',
                handler: 'keyboardAction',
                action: 'paste',
                hidden: !me.pasteButton
            }, {
                xtype: 'button',
                tooltip: KS.L10n.removeMenuLabel,
                iconCls: 'ks-icon-delete',
                handler: 'keyboardAction',
                action: 'remove',
                hidden: !me.removeButton
            });
            
            if (me.tbFillForUndoNext)
                items.push('->');

            items.push({
                xtype: 'button',
                tooltip: me.undoTooltipText,
                iconCls: 'ks-icon-undo',
                handler: 'undo'
            });

            items.push({
                xtype: 'button',
                tooltip: me.redoTooltipText,
                iconCls: 'ks-icon-redo',
                handler: 'redo'
            });
            
            if (me.textField.readOnly)
                Ext.each(items, function(item){
                    if (Ext.isFunction(item.setHidden))
                        item.setHidden(true);
                    else
                        item.hidden = true;
                })
            
            return items;
        },
        createItems: function() {
            var me = this,
                items = [
                    me.textPanel = Ext.create('Ext.FormPanel',
                        {
                            layout: 'border',
                            height: 400,
                            fileUpload: true,
                            items: [
                                me.linesNumber = Ext.create('Ext.form.field.TextArea',
                                    {
                                        border: 1,
                                        disabled: true,
                                        maxWidth: 50,
                                        value: 1,
                                        region: 'west'
                                    }),
                                me.textArea = Ext.create('Ext.form.field.TextArea',
                                    {
                                        region: 'center',
                                        maxLength: me.textField.maxLength,
                                        minLength: me.textField.minLength,
                                        editWindow: me,
                                        readOnly: me.readOnly || me.textField.readOnly,
                                        listeners: {
                                            change: function(th, v) {
                                                if (v && v.indexOf('\n')) {
                                                    var lines = v.split('\n').length,
                                                        linesVal = '',
                                                        i = 0;

                                                    for (i; i < lines; i++) {
                                                        linesVal += (+i + 1) + '\n';
                                                    }

                                                    me.linesNumber.setValue(linesVal);
                                                }

                                                if (!me.ignoreBuffer) me.textBufferInd = me.textBuffer.push(v) - 1;
                                                me.charCount.setValue(v.length);
                                            },

                                            validitychange: function(field, isValid) {
                                                var view = field.editWindow;
                                                
                                                if (view.saveButton)
                                                    view.saveButton.setDisabled(!isValid);
                                            }
                                        },

                                        keyMap: {
                                            'CmdOrCtrl+Z': 'undo',
                                            'CmdOrCtrl+Y': 'redo'
                                        }
                                    })
                            ]
                        })
                ];

            me.textArea.setValue(me.textValue);
            return items;
        },

        save: function() {
            var me = this,
                val = me.textArea.getValue(),
                cellEditor = me.textField.ownerCt;

            if (me.grid && cellEditor && cellEditor.context) {
                cellEditor.context.value = val;
                if (!me.skipActionableOnSave) {
                    me.grid.fireEvent('edit', cellEditor, cellEditor.context);
                    me.grid.view.setActionableMode(true, cellEditor.context);
                }
                cellEditor.editingPlugin.context.record.set(me.textField.dataIndex, val)
                cellEditor.editingPlugin.completeEdit();
            } else {
                me.textField.setValue(val);
            }

            me.textValue = val;
        }
    });
})();

// KS.Ext.Hyperlink
(function() {
    Ext.define('KS.Ext.Hyperlink', {
        extend: 'Ext.form.field.Text',
        editable: false,
        fieldStyle: 'color: blue; cursor: pointer; text-decoration: underline',
        rows: 1,

        bind: {
            value: '{value}'
        },

        triggers: {
            edit: {
                handler: 'edit',
                cls: 'ks-text-edit',
                tooltip: KS.L10n.indicateHyperlink,
                hideOnReadOnly: true
            }
        },

        viewModel: {
            data: {
                tooltip: null,
                text: null,
                url: null
            },

            formulas: {
                value: function(get) {
                    var tooltip = Ext.String.htmlEncode(get('tooltip')),
                        text = Ext.String.htmlEncode(get('text')),
                        url = Ext.String.htmlEncode(get('url')),
                        value;

                    if (tooltip)
                        tooltip = ' title="' + tooltip + '"';
                    
                    if (url)
                        url = ' href="' + url + '"';
                    
                    if (tooltip || text || url)
                        value = Ext.String.format('<a{0}{1}>{2}</a>', tooltip, url, text);
                    
                    return value;
                }
            }
        },

        controller: {
            bindings: {
                onTooltipChange: '{tooltip}'
            },

            onTooltipChange: function(tooltip) {
                if (this.view.inputWrap)
                    this.view.inputWrap.dom.setAttribute('title', tooltip || this.getViewModel().get('url') || '');
            },

            open: function() {
                var value = this.view.getValue();

                if (value)
                    $(value).attr('target', '_blank')[0].click();
            }
        },

        listeners: {
            click: {
                element: 'inputWrap',
                fn: 'open'
            }
        },

        edit: function(btn) {
            var me = this,
                vm = me.viewModel,
                cellEditor;
            
            if (me.up().xtypesMap.celleditor) {
                cellEditor = me.up();
            }

            if (me.editWindow && !me.editWindow.destroyed)
                return;

            me.editWindow = Ext.create({
                xtype: 'window',
                autoShow: true,
                title: KS.L10n.hyperlinkEdit,
                width: 400,
                padding: 10,
                referenceHolder: true,
                defaultFocus: 'textfield',
                defaultButton: 'okButton',
                modal: true,
                editor: me,
                resizable: false,
                
                controller: {
                    save: function() {
                        var me = this,
                            vm = me.view.editor.getViewModel(),
                            form = me.view.lookupReference('form');

                        if (cellEditor) {
                            cellEditor.grid.setActionableMode(true, cellEditor.context);
                        }
                        
                        vm.setData(form.getValues()).notify();

                        if (cellEditor) {
                            cellEditor.completeEdit();
                        }
                        
                        me.close();
                    },

                    close: function() {
                        this.view.close();
                    }
                },

                items: {
                    xtype: 'form',
                    reference: 'form',
                    border: 0,

                    layout: {
                        type: 'vbox',
                        align: 'stretch'
                    },

                    defaults: {
                        xtype: 'textfield',
                        margin: '0 0 10 0',
                        labelSeparator: ''
                    },

                    items: [{
                        name: 'url',
                        value: vm.get('url'),
                        fieldLabel: KS.L10n.address + ' (URL)',
                        labelStyle: 'font-weight: bold',
                    }, {
                        name: 'text',
                        value: vm.get('text'),
                        fieldLabel: KS.L10n.text
                    }, {
                        name: 'tooltip',
                        value: vm.get('tooltip'),
                        fieldLabel: KS.L10n.tip
                    }],

                    buttons: [{
                        text: 'OK',
                        reference: 'okButton',
                        handler: 'save'
                    }, {
                        text: KS.L10n.cancel,
                        handler: 'close'
                    }]
                }
            });
        },

        valueToRaw: function(value) {
            return Ext.String.htmlDecode(this.getViewModel().get('text'));
        },

        rawToValue: function(value) {
            var vm = this.getViewModel();

            vm.set('text', value);

            return vm.get('value');
        },

        setValue: function(value) {
            var me = this,
                vm = me.getViewModel(),
                link = $(Ext.String.htmlDecode(value)),
                url = link.attr('href');

            vm.setData({
                tooltip: link.attr('title'),
                text: link.text() || url,
                url: url
            }).notify();

            value = me.callParent([value]);

            me.refreshEmptyText();

            return value;
        },

        getValue: function() {
            var me = this,
                vm = me.getViewModel(),
                val;

            if (vm)
                val = vm.get('value');
            
            if (!val)
                val = me.value;
            
            me.value = val;
            
            return val;
        }
    });
})();


//comboBox с null-значениями в items
// KS.Ext.NullCombo
(function() {
    Ext.define('KS.Ext.NullCombo',
        {
            extend: 'Ext.form.field.ComboBox',
            getDisplayValue: function(tplData) {
                var s;
                tplData = tplData || this.displayTplData;
                s = this.getDisplayTpl().apply(tplData);
                s = (s == null) ? '' : String(s);
                // The display field may have newlines characters, but the raw value in
                // the field will not because they will be automatically stripped, so do
                // the same here for the sake of comparison.
                if (s === '&nbsp') return '';

                return s.replace(this.newlineRe, '');
            }
        });
})();

// Добавление меню в чекбокс
// KS.Ext.selection.CheckboxModel
(function() {
    Ext.define('KS.Ext.selection.CheckboxModel',
        {
            alias: 'selection.kscheckboxmodel',
            extend: 'Ext.selection.CheckboxModel',
            onHeaderClick: function(headerCt, header, e) {
                var me = this,
                    store = me.store,
                    isChecked,
                    records,
                    i,
                    len,
                    selections,
                    selection;

                if (me.column.triggerEl && e.target === me.column.triggerEl.dom) {
                    e.stopEvent();
                    header.showMenuBy(e, e.target, header);
                    return false;
                }

                me.callParent(arguments);
            },
            getMenuItems: function() {
                var me = this,
                    grid = me.view.grid;

                return [
                    {
                        text: KS.L10n.all,
                        handler: function() { grid.checkAll(); }
                    },
                    {
                        text: KS.L10n.nothing,
                        handler: function() { grid.uncheckAll(); }
                    },
                    '-',
                    {
                        text: KS.L10n.inversion,
                        handler: function() { grid.invertAll(); }
                    }, {
                        text: KS.L10n.checkFromBeginning,
                        handler: function() { grid.checkFromFirst(); }
                    }, {
                        text: KS.L10n.checkFromCurrent,
                        handler: function() { grid.checkToEnd(); }
                    }, {
                        text: KS.L10n.betweenChecked,
                        handler: function() { grid.checkBetween(); }
                    }
                ];
            },
            getHeaderConfig: function() {
                var config = this.callParent(arguments);

                config.width = this.checkColumnWidth ?? 48;
                config.menuDisabled = false;
                config.getMenuItems = this.getMenuItems;
                return config;
            }
        });
})();

//Таб панель с нашим таббаром
// KS.Ext.tab.Panel
(function() {
    //Таб бар с возможностью максимизации таба
    Ext.define('KS.Ext.tab.Bar',
        {
            extend: 'Ext.tab.Bar',
            
            onRootResize: function() {
                var context = this.maximizeContext, xy;

                if (context.condition) {
                    xy = [0, 0];
                    context.tabPanel.setLocalXY(xy);
                    size = context.rootPanel.getSize();
                    size.height -= 5;
                    size.width -= 10;
                } else {
                    size = context.tabPanel.serverSize;
                    xy = context.tabPanel.serverXY;
                    context.tabPanel.setLocalXY(xy);
                }

                context.tabPanel.setSize(size);
            },
            
            onHideMaximizedItem: function() {
                this.maximize();
            },
            
            maximize: function() {
                var tab = this,
                    grid = tab.card,
                    tabPanel = grid.ownerCt,
                    condition = tabPanel.ksMaximazed ? false : true,
                    rootEl = grid.parentView.rootEl;

                //Панель - контейнер
                var rootPanel;
                if (Ext.isFunction(grid.parentView.getMaximizedRootPanel)) {
                    rootPanel = grid.parentView.getMaximizedRootPanel(tabPanel);
                } else {
                    rootPanel = rootEl.items.items[0];
                    if (rootPanel.__proto__ && rootPanel.__proto__.$className === "KS.Ext.tab.Panel") {
                        rootPanel = tabPanel.ownerCt;
                    }
                }

                if (!tabPanel.serverSize || !tabPanel.serverXY) {
                    tabPanel.serverXY = tabPanel.getLocalXY();
                    tabPanel.serverSize = tabPanel.getSize();

                    //Смещение относительно скроллбара
                    /*tabPanel.serverXY[0] += rootPanel.getScrollX();
                    tabPanel.serverXY[1] += rootPanel.getScrollY();*/
                }

                var rootPanelItems;
                if (Ext.isFunction(grid.parentView.getMaximizeItems))
                    rootPanelItems = grid.parentView.getMaximizeItems(tabPanel);
                else 
                    rootPanelItems = rootPanel && rootPanel.items;

                Ext.suspendLayouts();
                if (rootPanelItems) {
                    Ext.each(rootPanelItems.items,
                        function(item) {
                            if (item.ctrlId && item.ctrlId !== tab.tabBar.tabPanel.ctrlId) {
                                if (condition){
                                    item.isHiddenItem = item.hidden;
                                    item.setVisible && item.setVisible(!condition);
                                }
                                else {
                                    if (!item.isHiddenItem){
                                        item.setVisible && item.setVisible(!condition);
                                    }
                                }
                            }
                        });
                }

                var xy, size;

                tab.maximizeContext = {
                    rootPanel: rootPanel,
                    tabPanel: tabPanel,
                    condition: condition
                };

                if (condition) {
                    xy = [0, 0];
                    tabPanel.serverSize = tabPanel.getSize();
                    tabPanel.serverXY = tabPanel.getLocalXY();
                    tabPanel.setLocalXY(xy);
                    size = rootPanel.getSize();
                    size.height -= 5; // padding / убираем скролл
                    size.width -= 10; // padding

                    rootPanel.addListener('resize', KS.Ext.tab.Bar.prototype.onRootResize, tab);
                    tab.on('hide', KS.Ext.tab.Bar.prototype.onHideMaximizedItem, tab);
                } else {
                    if (Ext.isFunction(grid.parentView.getRestoreMaximizeSize)) {
                        size = grid.parentView.getRestoreMaximizeSize(rootPanel);
                    } else {
                        size = tabPanel.serverSize;
                    }
                    xy = tabPanel.serverXY;
                    tabPanel.setLocalXY(xy);
                    rootPanel.removeListener('resize', KS.Ext.tab.Bar.prototype.onRootResize, tab);
                    tab.un('hide', KS.Ext.tab.Bar.prototype.onHideMaximizedItem, tab);
                }

                if (condition) {
                    tabPanel.setMaxHeight();
                } else {
                    tabPanel.setMaxHeight(tabPanel.initialConfig.maxHeight);
                }
                tabPanel.setSize(size);
                tabPanel.ksMaximazed = condition;
                rootPanel.ksMaximized = condition;
                Ext.resumeLayouts(true);
                
                
                //#region способ с окном
                //grid = Ext.apply({}, tab.card),
                //ownerCt = grid.ownerCt,
                //copyGrid = tab.card,
                //win = new Ext.Window({
                //    title: tab.title,
                //    icon: '',
                //    autoScroll: true,
                //    //constrainHeader: true,
                //    resizable: true,
                //    modal: true,
                //    layout: 'fit',
                //    //floatable: true,
                //    closeAction: 'hide',
                //    listeners: {
                //        //show: function(window, eOpts) {
                //        //    grid.tools.maximize.hide();
                //        //},
                //        //beforehide: function(window, eOpts) {
                //        //    console.log("beforehide");
                //        //    window.items.first().tools.maximize.show();
                //        //    window.items.first().el.appendTo(Ext.get(grid.renderTo));
                //        //},
                //        hide: function(window, eOpts) {
                //            //ownerCt.add(tab);
                //        }
                //    }
                //}),
                //changeGridId = function(tbar, findId, newId) {
                //    if (tbar.Top) {
                //        Ext.each(tbar.Top.nodes,
                //            function(node) {
                //                if (node.additional && node.additional.gridId) {
                //                    node.additional.gridId = newId;
                //                }
                //            });
                //    }
                //    return tbar;
                //};

                //tab.tabBar.tabPanel
                //copyGrid.parentView.containerPanel = win;
                //newTbar = copyGrid.parentView.buildTemplateToolbars(copyGrid.ctrl.toolbars, copyGrid.ctrl.itemId),

                //var newTbar = copyGrid.parentView.buildTemplateToolbars(
                //        changeGridId(copyGrid.ctrl.toolbars, copyGrid.ctrl.itemId, 'maxGrid_123'),
                //        'maxGrid_123'),
                //    cfg = KS.apply(newTbar, copyGrid.parentView.overrideTemplateControlCfg()),
                //    grid = Ext.create('KS.Ext.Grid', copyGrid.ctrl, Ext.apply(cfg, copyGrid.serverCfg));

                //grid.getDocked()
                //grid.removeDocked ( item, [flags] ) 
                //ctrl.parentView = this;
                //var tbars = this.buildTemplateToolbars(ctrl.toolbars, ctrl.itemId),
                //    cfg = KS.apply(tbars, this.overrideTemplateControlCfg(ctrlId)),
                //    instance = KS.create(ctrl, cfg);

                //ownerCt.doRemove(tab, false);

                //win.show();
                //win.items.add(grid);
                //win.maximize();
                //#endregion способ с окном
            },

            onAdd: function(tab, pos) {
                if (tab.card && tab.card.maximizable) {
                    tab.iconAlign = 'right';
                    tab.setIcon('PlatformHandler.axd?icon=maximize_panel.png');
                    tab.setTooltip(KS.L10n.fullscreen);
                    tab.maximize = this.maximize.bind(tab);
                }

                this.callParent([
                    tab,
                    pos
                ]);
            },
            privates: {
                onClick: function(e, target) {
                    var me = this,
                        tabEl,
                        tab,
                        isCloseClick,
                        tabInfo;

                    if (e.getTarget('.' + Ext.baseCSSPrefix + 'box-scroller')) {
                        return;
                    }
                    if (Ext.isIE8 && me.vertical) {
                        tabInfo = me.getTabInfoFromPoint(e.getXY());
                        tab = tabInfo.tab;
                        isCloseClick = tabInfo.close;
                    } else {
                        // The target might not be a valid tab el.
                        tabEl = e.getTarget('.' + Ext.tab.Tab.prototype.baseCls);
                        tab = tabEl && Ext.getCmp(tabEl.id);
                        isCloseClick = tab && tab.closeEl && (target === tab.closeEl.dom);
                    }
                    if (isCloseClick) {
                        e.preventDefault();
                    }

                    if (target.id.endsWith('btnIconEl') && KS.isFunction(tab.maximize)) {
                        tab.maximize(me.tabPanel);
                    }

                    if (tab && tab.isDisabled && !tab.isDisabled()) {
                        // This will focus the tab; we do it before activating the card
                        // because the card may attempt to focus itself or a child item.
                        // We need to focus the tab explicitly because click target is
                        // the Bar, not the Tab.
                        tab.beforeClick(isCloseClick);
                        if (tab.closable && isCloseClick) {
                            tab.onCloseClick();
                        } else {
                            me.doActivateTab(tab);
                        }
                    }
                }
            }
        });

    Ext.define('KS.Ext.tab.Panel',
        {
            extend: 'Ext.tab.Panel',
            applyTabBar: function(tabBar) {
                var me = this,
                    // if we are rendering the tabbar into the panel header, use same alignment
                    // as header position, and ignore tabPosition.
                    dock = (me.tabBarHeaderPosition != null) ? me.getHeaderPosition() : me.getTabPosition();
                return new KS.Ext.tab.Bar(Ext.apply({
                        ui: me.ui,
                        dock: dock,
                        tabRotation: me.getTabRotation(),
                        vertical: (dock === 'left' || dock === 'right'),
                        plain: me.plain,
                        tabStretchMax: me.getTabStretchMax(),
                        tabPanel: me
                    },
                    tabBar));
            }
        });
})();

// Числовое поле с разделителем разрядов
// KS.Ext.form.field.Number
(function() {
    Ext.define('KS.Ext.form.field.Number',
        {
            extend: 'Ext.form.field.Number',
            alias: 'widget.KSnumberfield',
            thousandSeparatorEnabled: false,
            allowDecimals: true,
            decimalPrecision: 2,
            decimalSeparator: Ext.util.Format.decimalSeparator,

            toBaseNumber: function(value) {
                var me = this;
                return String(value).replace(new RegExp('[' + Ext.util.Format.thousandSeparator + ']', 'g'), '')
                    .replace(me.decimalSeparator, '.');
            },
            parseRawValue: function(value) {
                var me = this;
                value = parseFloat(me.toBaseNumber(value));
                return isNaN(value) ? null : value;
            },

            getErrors: function(value) {
                if (!this.thousandSeparatorEnabled)
                    return this.callParent(arguments);
                value = arguments.length > 0 ? value : this.processRawValue(this.getRawValue());

                var me = this,
                    errors = [],
                    format = Ext.String.format,
                    num;

                if (value.length < 1) {
                    return errors;
                }

                value = me.toBaseNumber(value);

                if (isNaN(value)) {
                    errors.push(format(me.nanText, value));
                }

                num = me.parseValue(value);

                if (me.minValue === 0 && num < 0) {
                    errors.push(this.negativeText);
                } else if (num < me.minValue) {
                    errors.push(format(me.minText, me.minValue));
                }

                if (num > me.maxValue) {
                    errors.push(format(me.maxText, me.maxValue));
                }

                return errors;
            },

            rawToValue: function(rawValue) {
                if (!this.thousandSeparatorEnabled)
                    return this.callParent(arguments);
                var value = this.fixPrecision(this.parseRawValue(rawValue));
                if (value === null) {
                    value = rawValue || null;
                }
                return value;
            },

            valueToRaw: function(value) {
                if (!this.thousandSeparatorEnabled) {
                    return this.callParent(arguments);
                }
                var me = this,
                    decimalSeparator = me.decimalSeparator,
                    format = '0,000';
                if (me.allowDecimals) {
                    for (var i = 0; i < me.decimalPrecision; i++) {
                        if (i == 0) {
                            format += '.';
                        }
                        format += '0';
                    }
                }
                value = me.parseValue(value);
                value = me.fixPrecision(value);
                value = Ext.isNumber(value) ? value : parseFloat(String(value).replace(decimalSeparator, '.'));
                value = isNaN(value) ? '' : Ext.util.Format.number(value, format);
                value = String(value).replace(/[.,]/, decimalSeparator);

                return value;
            },

            getSubmitValue: function() {
                if (!this.thousandSeparatorEnabled)
                    return this.callParent();
                var me = this,
                    value = me.callSuper();

                if (!me.submitLocaleSeparator) {
                    value = me.toBaseNumber(value);
                }
                return value;
            },

            setMinValue: function(value) {
                if (!this.thousandSeparatorEnabled)
                    return this.callParent(arguments);
                var me = this,
                    ariaDom = me.ariaEl.dom,
                    minValue,
                    allowed,
                    ariaDom;

                me.minValue = minValue = Ext.Number.from(value, Number.NEGATIVE_INFINITY);
                me.toggleSpinners();

                if (ariaDom) {
                    if (minValue > Number.NEGATIVE_INFINITY) {
                        ariaDom.setAttribute('aria-valuemin', minValue);
                    } else {
                        ariaDom.removeAttribute('aria-valuemin');
                    }
                }

                if (me.disableKeyFilter !== true) {
                    allowed = me.baseChars + '';

                    if (me.allowExponential) {
                        allowed += me.decimalSeparator + 'e+-';
                    } else {
                        allowed += Ext.util.Format.thousandSeparator;
                        if (me.allowDecimals) {
                            allowed += me.decimalSeparator;
                        }
                        if (me.minValue < 0) {
                            allowed += '-';
                        }
                    }

                    allowed = Ext.String.escapeRegex(allowed);
                    me.maskRe = new RegExp('[' + allowed + ']');
                    if (me.autoStripChars) {
                        me.stripCharsRe = new RegExp('[^' + allowed + ']', 'gi');
                    }
                }
            }
        });
})();

//File Uploader
(function() {
    function doUpload(uplField, evt) {
        var form = this.filesPanel.getForm();
        if (form.isValid())
            this.uploadFiles(form, $.proxy(this.saveFiles, this), uplField, evt, this.filefield);
    }

    function uploadFiles(form, callback, uplField, evt, filefield) {
        if (KS.checkHtml5UploadSupport()) {
            try {
                this.html5Upload(form, callback, uplField, evt, filefield);
            } catch (e) {
                this.extUpload(form, callback, uplField, evt, filefield);
            }
        } else {
            this.extUpload(form, callback);
        }
    }

    function extUpload(form, callback, uplField, evt, filefield) {
        var fileView = this,
            view = fileView.parentView,
            url = 'PlatformHandler.axd?upload=1&important=1',
            setMultiple = function() {
                uplField.fileInputEl.dom.setAttribute('multiple', this.multiple);
            };

        callback = callback || uplField.callback;

        form.submit({
            url: url,
            method: 'POST',
            fileUpload: true,
            waitMsg: KS.L10n.sendingFile,
            success: function() { setMultiple(); },
            failure: function(fp, o) {
                setMultiple();
                callback.call(view, o.result, filefield, fileView);
            }
        });
    }

    function html5Upload(form, callback, uplField, evt, grid) {
        var fileName = null;
        if (Ext.isArray(evt)) {
            if (evt.target && !KS.isEmpty(evt.target.files))
                fileName = evt.target.files[0]; 
        } else if (KS.isString(evt)) {
            fileName = this.btnSend.getFileList()[0];
        } else if (KS.isObject(evt)) {
            if (evt.target && !KS.isEmpty(evt.target.files))
                fileName = evt.target.files[0];
        }

        if (KS.isEmpty(fileName)) {
            callback(null, null, uplField);
        }
        else {
            var uploader = new KS.Ext.Html5Uploader({
                file: fileName,
                grid: grid,
                parentView: this,
                success: callback
            });
            if (uploader.isValid())
                uploader.upload();
        }
    }

    // File edit implementation
    KS.apply(KS.Ext,
        {
            downloadFileFromGrid: function (fileName) {
                var me = this,
                    grid = me.grid,
                    files = grid.ksObjs.files,
                    rec = me.record,
                    col = me.column;
                
                if (!rec) {
                    var cell = grid.getSelectionModel().selected.startCell;
                    rec = cell.record;
                    col = cell.column;
                }

                if (files && files[rec.id]) {
                    KS[me.openAction || 'openUrl'](files[rec.id].path);
                } else if (fileName !== '') {
                    this.parentView.serverCall({
                        method: 'DoOpenFile',
                        params: [grid.itemId, rec.get(grid.closeCode), col.dataIndex],
                        waitMessage: KS.L10n.gettingFile,
                        success: function (filePath) {
                            if (!filePath) {
                                return;
                            }
                            files[rec.id] = {
                                path: filePath
                            };

                            KS[me.openAction || 'openUrl'](filePath);
                        },
                        failure: function (fp, o) {
                        }
                    });
                }

                if (this.closeAfterView)
                    this.close();
            },

            downloadFileFromField: function (fileId) {
                var me = this,
                    filefield = me.filefield,
                    files = filefield.files,
                    filesKeys = files[fileId];

                if (filesKeys) {
                    if (filesKeys.path) {
                        //if (files && filesKeys[0]) {
                        //KS.openUrl(files[filesKeys[0]].path);
                        KS[me.openAction || 'openUrl'](filesKeys.path);
                    } else {
                        filefield.parentView.serverCall({
                            method: 'DoOpenFileFromBtn',
                            params: [filesKeys.xml],
                            waitMessage: KS.L10n.gettingFile,
                            success: function (path) {
                                filesKeys.path = path;
                                KS[me.openAction || 'openUrl'](path);
                            }
                        });
                    }
                }

                if (this.closeAfterView)
                    this.close();
            },

            fileEdit: function(filefield, ctrlId, saveFileCallback, clearFileCallback) {
                var view = this;

                Ext.create('KS.Ext.FileWindow',
                    {
                        filefield: filefield,
                        accept: filefield.accept,
                        title: filefield.multiple ? KS.L10n.multipleFiles : KS.L10n.fileLabel,
                        iconCls: KS.getExtStyle(filefield.getValue()),
                        saveFilesCallback: function(grid, fileView, file) {
                            var value = file.name;
                            
                            if (file.fileKey && filefield.ctrl && filefield.ctrl.useShortFileName) {
                                value = ((file.fileKey.fileName || '') + (file.fileKey.fileExtension || '')) || value;
                            }
                            
                            filefield.setValue(value);
                            filefield.files = {};

                            if (file.fileKey)
                                filefield.files[file.fileKey.ID] = file;

                            fileView.enableBtns();

                            if (fileView.closeAfterLoad)
                                fileView.close();

                            saveFileCallback && saveFileCallback(file, ctrlId);
                        },
                        multiple: filefield.multiple,
                        getFileId: function() {
                            var key = Object.keys(filefield.files)[0] || '';
                            if (key === 'null' || key === 'undefined') key = ''
                            return key;
                        },

                        downloadFile: KS.Ext.downloadFileFromField,

                        clearFile: function() {
                            var me = this;

                            me.setIconCls('');
                            filefield.setValue('');
                            filefield.files = {};
                            me.enableBtns();

                            clearFileCallback && clearFileCallback();
                            me.doUpload(me);
                        },

                        saveFiles: function(fileKeys, filefield, fileView) {
                            var view = this.parentView || this;

                            view.serverCall({
                                method: 'DoSaveFiles',
                                params: [fileKeys, false, ctrlId],
                                waitMessage: KS.L10n.saving,
                                success: function(file) {
                                    if (fileView && fileView.saveFilesCallback) {
                                        fileView.saveFilesCallback.call(this, filefield, fileView, file);
                                    }
                                }
                            });
                        },

                        doUpload: doUpload,
                        uploadFiles: uploadFiles,
                        extUpload: extUpload,
                        html5Upload: html5Upload,

                        parentView: view,
                        ctrlId: ctrlId
                    });
            }
        });

    Ext.define('KS.Ext.FileWindow',
        {
            extend: 'Ext.window.Window',
            title: KS.L10n.fileLabel,
            iconCls: 'ks-icon-new',
            layout: { type: 'vbox', align: 'stretch' },
            resizable: false,
            modal: false,
            autoShow: true,
            cls: 'ks-file-window',
            initComponent: function() {
                var me = this;
                
                if (me.accept) {
                    me.maxFileSizes = me.accept.split(',').reduce(function (acc, v) {
                        var formatted = v.split(':');
                        
                        if (formatted.length > 1)
                            acc[formatted[0]] = Number(formatted[1]);
                        
                        return acc;
                    }, {});
                    me.accept = me.accept.replace(/[:]\d+/g, '');
                }

                me.width = me.multiple ? 400 : 170;
                me.items = me.createItems();
                
                if (me.parentView.containerPanel)
                    me.parentView.containerPanel.add(me);
                
                me.callParent(arguments);
            },

            downloadFile: KS.Ext.downloadFileFromGrid,

            doUpload: function(uplField, evt) {
                var form = this.filesPanel.getForm();
                if (form.isValid())
                    this.uploadFiles(form, this.saveFiles, uplField, evt, this.grid);
            },

            uploadFiles: function(form, callback, uplField, evt, grid) {
                if (KS.checkHtml5UploadSupport()) {
                    try {
                        this.html5Upload(form, callback, uplField, evt, grid);
                    } catch (e) {
                        this.extUpload(form, callback);
                    }
                } else {
                    this.extUpload(form, callback);
                }
            },

            extUpload: function(form, callback) {
                var fileView = this,
                    view = fileView.parentView,
                    url = 'PlatformHandler.axd?upload=1&important=1';

                if (fileView.btnSend.getValue())
                    form.submit({
                        url: url,
                        method: 'POST',
                        fileUpload: true,
                        waitMsg: KS.L10n.sendingFile,
                        success: function () { },
                        failure: function (fp, o) {
                            callback.call(view, o.result, null, fileView);
                        }
                    });
                else
                    callback.call(view, null, null, fileView);
            },

            html5Upload: function(form, callback, uplField, evt, grid) {
                if (Ext.typeOf(evt) === 'string')
                    evt = {};
                    
                if (!evt.target)
                    evt.target = {};
                
                if (!evt.target.files)
                    evt.target.files = this.btnSend.getFileList(); 
                    
                if (Ext.isEmpty(evt.target.files)) return;
                
                const toUpload = [];
                for (let i = 0; i < evt.target.files.length; i++) {
                    toUpload.push(new KS.Ext.Html5Uploader({
                        file: evt.target.files[i],
                        grid: grid,
                        parentView: this,
                        success: (function(fileKeys, grid, fileView) {
                            callback(fileKeys, grid, fileView, this.fileIndex);
                        }).bind({fileIndex: i})
                    }));
                }

                uploadFileList(toUpload);
                
                async function uploadFileList(list) {
                    const uploader = list.shift();
                    if (uploader.isValid())
                        await uploader.upload();
                    
                    if (list.length)
                        uploadFileList(list);
                }
            },

            saveFiles: function(fileKeys, grid, fileView, fileIndex) {
                grid = grid || this[fileView.ctrlId];

                var view = fileView.parentView;

                if (grid) {
                    var cell = grid.getSelectionModel().selected.startCell;
                    let closeCode;
                    
                    if (Ext.isEmpty(fileIndex)) {
                        closeCode = cell.record.get(grid.closeCode);
                    } else {
                        let record = grid.store.getAt(cell.rowIdx + fileIndex);
                        
                        if (KS.addNextMultipleFilesToEmptyRowCells && fileIndex > 0) {
                            if (!Ext.isEmpty(record?.get(cell.column.dataIndex))) {
                                record = null; // добавляем новую строку
                            }   
                        }
                        
                        closeCode = record?.get(grid.closeCode);
                    }

                    view.serverCall({
                        method: 'DoSaveFilesGrid',
                        params: [
                            fileKeys, false, fileView.ctrlId, closeCode ?? null, cell.column.dataIndex
                        ],
                        waitMessage: KS.L10n.saving,
                        success: function(file) {
                            fileView.saveFilesCallback.call(this, grid, fileView, file, fileIndex);
                        }
                    });
                } else {
                    view.serverCall({
                        method: 'DoSaveFiles',
                        params: [fileKeys, false],
                        waitMessage: KS.L10n.saving,
                        success: fileView.saveFilesCallback.bind(this, fileKeys, fileView)
                    });
                }

            },

            fileExists: function(exist, noExist) {
                var id = this.getFileId();
                (KS.isEmpty(id) ? noExist : exist)();
            },

            createItems: function() {
                var me = this,
                    val = this.getFileId() !== '',
                    res = [
                        me.filesPanel = Ext.create('Ext.FormPanel',
                            {
                                fileUpload: true,
                                hideLabels: true,
                                //autoHeight: true,
                                layout: { type: 'vbox', align: 'stretch' },
                                defaults: {
                                    flex: 1,
                                    allowBlank: false,
                                    msgTarget: 'side'
                                },
                                items: [
                                    //me.btnSend = Ext.create('Ext.form.field.File', {
                                    //    cls: 'browse-file-button',
                                    //    name: 'file',
                                    //    anchor: '100%',
                                    //    multiple: true,
                                    //    buttonOnly: true,
                                    //    buttonText: 'Choose files',
                                    //    listeners: {
                                    //        change: function(filefield, newFileName, oldFileName) {
                                    //            var displayFileNames = this.up('form').getForm().findField('fileNames'),
                                    //                fileList = filefield.getFileList(),
                                    //                fileNames = Ext.Array.pluck(fileList, 'name');

                                    //            displayFileNames.setValue(fileNames.join(','));
                                    //        }
                                    //    }
                                    //})
                                    me.btnSend = Ext.create('Ext.form.field.File', //'Ext.form.field.FileButton',
                                        {
                                            accept: me.accept,
                                            buttonOnly: !me.multiple,
                                            buttonText: KS.L10n.select,
                                            buttonMargin: 0,
                                            padding: me.multiple ? '5' : '0',
                                            multiple: me.multiple,
                                            allowBlank: true,
                                            disabled: me.readOnly,
                                            listeners: {
                                                change: {
                                                    fn: function() {
                                                        var files = this.btnSend.getFileList(),
                                                            size, format, file, maxSize;
                                                        
                                                        if (this.maxFileSizes) {
                                                            if (Ext.isEmpty(files) || !files.length) return;
                                                            
                                                            for (let i = 0; i < files.length; i++) {
                                                                file = files[i];
                                                                size = file.size;
                                                                format = file.name.split('.').pop();

                                                                if (format) {
                                                                    maxSize = this.maxFileSizes['.' + format];
                                                                    if (size > maxSize) {
                                                                        Ext.MessageBox.alert(KS.L10n.attention, Ext.String.format(KS.L10n.fileLoadSizeError, maxSize));
                                                                        this.btnSend.reset();
                                                                        return;
                                                                    }
                                                                }
                                                            }
                                                        }
                                                        
                                                        this.doUpload.apply(this, arguments);
                                                    },
                                                    scope: me
                                                }
                                            }
                                        }),
                                    me.btnOpen = Ext.create('Ext.Button',
                                        {
                                            text: KS.L10n.open,
                                            iconCls: 'ks-icon-export',
                                            hidden: me.multiple,
                                            disabled: !val,
                                            handler: function() {
                                                me.downloadFile.call(me, me.getFileId());
                                            }
                                        }),
                                    me.btnClear = Ext.create('Ext.Button',
                                        {
                                            text: KS.L10n.clear,
                                            iconCls: 'ks-icon-clean',
                                            disabled: me.readOnly || !val,
                                            handler: function() {
                                                me.fileExists(
                                                    function() {
                                                        KS.selectDialogShow(KS.L10n.attention,
                                                            KS.L10n.deleteExistFile,
                                                            function() { me.clearFile(); });
                                                    },
                                                    function() { me.clearFile(); });
                                            }
                                        }),
                                    me.fileDrag = KS.fileWindowDragDropDisabled ? null : Ext.create('KS.drag.File')
                                ]
                            })
                    ];

                me.enableBtns();

                return res;
            },
            clearFile: function() {
                var me = this,
                    grid = me.grid,
                    files = grid.ksObjs.files,
                    rec = grid.getSelectionModel().selected.startCell.record;

                // todo: почистить файл на сервере
                me.setIconCls('');
                rec.set(grid.fieldExt, '');
                delete files[rec.id];
                me.enableBtns();
                me.doUpload(me)
            },
            enableBtns: function() {
                var me = this;

                me.fileExists(function() {
                        me.btnClear.setDisabled(false);
                        me.btnOpen.setDisabled(false);
                    },
                    function() {
                        me.btnClear.setDisabled(true);
                        me.btnOpen.setDisabled(true);
                    });
            }
        });

    //Форма перетаскивания для загрузки файлов
    Ext.define('KS.drag.File',
        {
            extend: 'Ext.panel.Panel',
            xtype: 'drag-file',
            controller: 'drag-file',

            requires: [
                'Ext.layout.container.Fit'
            ],

            width: 300,
            height: 100,
            bodyPadding: 5,
            layout: 'fit',

            bodyCls: 'drag-file-ct',

            html:
                '<div class="drag-file-label">' +
                    '<p>или перенесите сюда файлы для загрузки</p>' +
                    '</div>' +
                    '<div class="drag-file-icon"></div><div class="drag-drop-zone"></div>'
        });

    Ext.define('KS.Ext.FileUploader',
        {
            extend: 'Ext.app.ViewController',
            alias: 'controller.drag-file',

            requires: ['Ext.drag.Target'],

            afterRender: function(view) {
                var body = view.body;

                view.loader = view.up('window');

                if (KS.checkHtml5UploadSupport()) {
                    this.target = new Ext.drag.Target({
                        element: $(body.dom).find('.drag-drop-zone')[0],
                        listeners: {
                            scope: this,
                            dragenter: this.onDragEnter,
                            dragleave: this.onDragLeave,
                            drop: this.onDrop
                        }
                    });
                } else {
                    body.down('.drag-file-label').setHtml(
                        KS.L10n.fileDrag
                    );
                    body.el.addCls('nosupport');
                }
            },

            onDragEnter: function() {
                this.getView().body.addCls('active');
            },

            onDragLeave: function() {
                this.getView().body.removeCls('active');
            },

            onDrop: function(target, info) {
                var view = this.getView(),
                    body = view.body,
                    icon = body.down('.drag-file-icon');

                body.removeCls('active').addCls('dropped');
                icon.addCls('fa-spin');

                var me = this,
                    files = info.files,
                    len = files.length,
                    s;

                if (len > 1) {
                    s = 'Загружено ' + len + ' файлов';
                } else {
                    s = 'Загружен  ' + files[0].name;
                }

                Ext.toast({
                    html: s,
                    closable: false,
                    align: 't',
                    slideInDuration: 400,
                    minWidth: 400
                });

                me.timer = Ext.defer(function() {
                        if (!view.destroyed) {
                            icon.removeCls('fa-spin');
                            icon.fadeOut({
                                callback: function() {
                                    body.removeCls('dropped');
                                    icon.setOpacity(1);
                                    icon.show();
                                }
                            });
                        }
                        me.timer = null;
                    },
                    2000);

                view.loader.doUpload(view,
                    {
                        target: {
                            files: info.files
                        }
                    }); //: function(uplField, evt) {
            },

            destroy: function() {
                Ext.undefer(this.timer);
                this.target = Ext.destroy(this.target);
                this.callParent();
            }
        });

    // Поле с возможностью загрузки нескольки файлов
    Ext.define('KS.Ext.form.field.File',
        {
            override: 'Ext.form.field.File',
            onRender: function() {
                this.callParent(arguments);
                this.fileInputEl.dom.setAttribute('multiple', this.multiple);
            },
            getFileList: function() {
                return this.fileInputEl.dom.files;
            }
        });

    Ext.define('KS.Ext.Html5Uploader',
        {
            extend: 'Ext.Component',
            uploadscript: 'PlatformHandler.axd?upload=1&important=1&partial=1',
            portion: 1024 * 256,
            maxRetries: 5,
            timeout: 15000,

            constructor: function(config) {
                Ext.apply(this, config);
                var name = encodeURI(this.file.name);
                this.uploadscript +=
                    '&portion=' +
                    this.portion +
                    '&name=' +
                    name +
                    '&size=' +
                    this.file.size +
                    '&type=' +
                    this.file.type;
            },

            isValid: function() {
                return !Ext.isEmpty(this.file);
            },

            displayStatus: function(msg) {
                var me = this;
                if (me.grid) {
                    //if (!me.gridRec) {
                    //    me.gridRec = new (me.grid.store.recordType)({
                    //        LINK_FILE: KS.getFakeLink(),
                    //        FULL_NAME: me.file.name
                    //    });
                    //    me.grid.store.add(me.gridRec);
                    //}
                    //var currStatus = KS.Grid.getAnyCase(me.gridRec, 'STATUS') || '';
                    //me.gridRec.set('STATUS', msg || currStatus + '.');
                }
            },

            upload: function() {
                this.parentView.mask(KS.L10n.sendingFile);
                this.retriesLeft = this.maxRetries;
                this.loadFrom = 0;
                this.loadTo = (this.file.size > this.portion) ? this.portion : this.file.size;
                if (this.grid) this.grid.hasUploadTasks = true;
                this.promise = new Ext.Deferred();
                this.uploadPortion();
                return this.promise;
            },

            stopUpload: function(msg, isError) {
                this.parentView.unmask();
                this.displayStatus(msg);
                if (this.grid) this.grid.hasUploadTasks = false;
                if (isError === true && Ext.isString(msg)) throw (msg);
            },

            uploadPortion: function() {
                var me = this,
                    reader = new FileReader();

                reader.onloadend = function(evt) {
                    if (evt.target.readyState === FileReader.DONE) {
                        me.filePortionLoadEnd(evt.target.result);
                    } else {
                        me.stopUpload('FileReader error: ' + evt.target.readyState, true);
                    }
                };

                var sliceFn = this.file.slice || this.file.webkitSlice || this.file.mozSlice;
                if (sliceFn) {
                    var blob = sliceFn.call(me.file, me.loadFrom, me.loadTo);
                    reader.readAsArrayBuffer(blob);
                } else {
                    me.stopUpload('Html5 not supported', true);
                }
            },

            tryRetry: function() {
                if (this.retriesLeft <= 0) {
                    this.stopUpload(KS.L10n.loadingError);
                    this.promise.reject();
                } else {
                    this.retriesLeft--;
                    this.displayStatus();
                    this.uploadPortion();
                }
            },

            filePortionLoadEnd: function(result) {
                var me = this,
                    xhr = new XMLHttpRequest();

                xhr.open('POST', me.uploadscript + '&from=' + me.loadFrom, true);
                xhr.setRequestHeader("Content-Type", (me.file.type ?? "application/x-binary") + "; charset=x-user-defined");

                xhr.uploader = me;
                xhr.addEventListener("load", me.xhrLoadHandler, false);
                xhr.addEventListener("error", me.xhrErrorHandler, false);
                xhr.addEventListener("abort", me.xhrAbortHandler, false);

                xhr.upload.uploader = me;
                xhr.upload.addEventListener("progress", me.xhrProgressHandler, false);

                me.xhrHttpTimeout = setTimeout(function() {
                        xhr.abort();
                    },
                    me.timeout);

                var sendFn = xhr.send || xhr.sendAsBinary;
                if (sendFn) {
                    sendFn.call(xhr, result);
                } else {
                    me.stopUpload('Binary send not supported!', true);
                }
            },

            xhrProgressHandler: function(evt) {
                var me = this.uploader;
                if (evt.lengthComputable) {
                    var percentComplete = Math.round((me.loadFrom + evt.loaded) * 1000 / me.file.size) / 10;
                    me.displayStatus(KS.L10n.loadingStatus + ' (' + percentComplete + '%)');
                }
            },

            xhrLoadHandler: function(evt) {
                var me = this.uploader;
                clearTimeout(me.xhrHttpTimeout);

                if (evt.target.status != 200) {
                    me.tryRetry();
                } else {
                    me.retriesLeft = me.maxRetries;

                    var key = Ext.decode(evt.target.response, true);
                    if (key && key.value) {
                        me.key = key;
                        me.uploadscript += '&fid=' + me.key.value;
                    }

                    me.loadFrom += me.portion;

                    if (me.file.size > me.loadFrom) {
                        me.loadTo = me.loadFrom + me.portion;
                        if (me.loadTo > me.file.size)
                            me.loadTo = me.file.size;
                        me.uploadPortion(me.loadFrom, me.loadTo);
                    } else {
                        me.stopUpload(KS.L10n.loadingSuccess);
                        me.success.call(me.parentView.view, [me.key], me.grid, me.parentView);
                        me.promise.resolve();
                    }
                }
            },

            xhrErrorHandler: function(/*evt*/) {
                var me = this.uploader;
                clearTimeout(me.xhrHttpTimeout);
                me.tryRetry();
            },

            xhrAbortHandler: function(/*evt*/) {
                var me = this.uploader;
                clearTimeout(me.xhrHttpTimeout);
                me.tryRetry();
            }
        });

    function createFileField(ctrl, cfg) {
        cfg = cfg || {};
        var view = ctrl.parentView,
            fieldCfg = KS.apply(cfg,
                ctrl.json,
                {
                    parentView: view,
                    code: ctrl.itemId,
                    value: ctrl.value,
                    itemId: 'filefield',
                    fieldCls: ctrl.cls,
                    readOnly: ctrl.readOnly,
                    fileId: cfg.fileId || '',
                    files: cfg.files || {},
                    flex: 1,
                    accept: ctrl.accept,
                    triggers: ctrl.triggers,
                    editable: !KS.fileFieldNotEditable 
                }),
            items = [],
            cntrCfg = {
                layout: 'hbox',
                fieldLabel: ctrl.label,
                label: ctrl.label,

                coloriseChild: function (cls, needAdd) {
                    var th = this;
                    Ext.each(th.items.items, function (ctrl) {
                        if (ctrl)
                            ctrl[needAdd ? 'addCls' : 'removeCls'](cls);
                    });
                },

                setReadOnly: function (readOnly) {
                    this.items.each(function(child) {
                        if (child && KS.isFunction(child.setReadOnly)) {
                            child.setReadOnly(readOnly);
                        }
                    });
                },
            };

        for (var field in cfg) {
            var fParts = field.split('.');
            if (fParts[0] === 'owner') {
                cntrCfg[fParts[1]] = cfg[field];
            }
        }

        if (ctrl.usePopup) {
            var file = fieldCfg.value,
                clearFileCallback,
                saveFileCallback;

            if (ctrl.useShortFileName) {
                fieldCfg.value = file ? file.fileKey : '';
            } else {
                fieldCfg.value = file ? file.name : '';
            }

            var filefield = KS.create('textField', Object.assign(fieldCfg, {
               height: undefined // перекрывает картинку, высота нужна только контейнеру
            }));

            if (file) {
                filefield.files[file.fileKey] = file;
            }

            if (cfg.controledImageID) {
                saveFileCallback = function(file, ctrlId) {
                    if (view && view[cfg.controledImageID]) {
                        view[cfg.controledImageID].setSrc(file.path);
                    }
                }

                clearFileCallback = function() {
                    if (view && view[cfg.controledImageID]) {
                        view[cfg.controledImageID].setSrc('');
                    }
                }
            }

            filefield.fileBtn = new Ext.Button({
                text: KS.L10n.fileLabel,
                itemId: 'filefield-btn-' + ctrl.itemId,
                filefield: filefield,
                resetOriginalValue: Ext.emptyFn,
                isFormField: true,
                ctrlId: ctrl.itemId,

                setReadOnly: function (value) {
                    this.setHandler(value ? 'openFile' : 'openDesigner');
                },

                setValue: function(v) {
                    if (!v) return false;
                    this.handler();
                },

                getValue: function() {
                    var editor = this.ownerCt,
                        di = editor.column.dataIndex,
                        grid = editor.grid,
                        rec = grid.getSelectionModel().selected.startCell.record;

                    return rec.get(di);
                },

                isValid: function () {
                    return true;
                },

                handler: 'openDesigner',

                openFile: function () {
                    var me = this,
                        key = Object.keys(filefield.files)[0] || '';
                    if (key === 'null' || key === 'undefined') key = '';

                    KS.Ext.downloadFileFromField.call({
                        filefield: me.filefield,
                        openAction: 'downloadFile'
                    }, key);
                },

                openDesigner: function () {
                    var ffd = this.filefield;
                    if (ffd) {
                        KS.Ext.fileEdit.call(ffd.parentView, ffd, this.ctrlId, saveFileCallback, clearFileCallback);
                    }
                }
            });


            items.push(filefield);
            items.push(filefield.fileBtn);

            KS.Ext.setTemplateListeners(filefield, ctrl.listeners, view);
        } else {
            items.push(Ext.create('Ext.form.Panel',
                {
                    width: fieldCfg.width || 190,
                    layout: 'fit',
                    items: [
                        {
                            xtype: 'fileuploadfield',
                            doUpload: doUpload,
                            buttonOnly: fieldCfg.buttonOnly,
                            buttonConfig: fieldCfg.buttonConfig,
                            uploadFiles: uploadFiles,
                            accept: fieldCfg.accept,
                            extUpload: extUpload,
                            callback: fieldCfg.callback,
                            html5Upload: html5Upload,
                            parentView: view,
                            emptyText: fieldCfg.emptyText,
                            saveFiles: view.saveFiles,
                            listeners: {
                                change: function(uplField, evt) {
                                    this.filesPanel = this.ownerCt;
                                    this.doUpload.call(this, uplField, evt);
                                }
                            }
                        }
                    ]
                }));
        }

        cntrCfg.items = items;
        KS.Ext.correctSize(cntrCfg, ctrl);
        cntrCfg.cls = 'ks-file-field';
        return new Ext.form.FieldContainer(cntrCfg);
    }

    KS.Ext.registerControlRenderer('filefield', createFileField);
})();

Ext.define('KS.view.root.Toolbar', {
    extend: 'Ext.toolbar.Toolbar' 
});

Ext.define('KS.view.root.Viewport', {
    extend: 'Ext.container.Viewport'
});

Ext.define('KS.view.root.GroupViewport', {
    extend: 'Ext.tab.Panel'
});

Ext.define('KS.view.root.GroupViewportWrapper', {
    extend: 'Ext.panel.Panel'
});

//#region Отображение подсказок при переполнеии текста в контейнере
/**
 * Утилита для отображения подсказок в таблицах/полях формы
 */
Ext.define('KS.util.Overflow', {
    singleton: true,

    /**
     * Привязать подсказки к таблице
     *
     * @param {Ext.grid.Panel} grid
     */
    bindGridTooltip: function (grid) {
        return; // вырубаем пока, производительность оч сильно проседает
        
        // todo нужно обновлять подсказки только при наведении на ячейку, иначе слишком много вызовов
        // grid.view.addListener('beforecellmouseenter', function (table, record, item) {
        //     update(item);
        // });
        if (grid.getColumns().length * grid.store.data.length > 100)
            return;
        
        
        grid.view.addListener('refresh', function (table) {
            update(table.grid);
        });

        grid.store.addListener('refresh', function (store) {
            update(store.grid);
        });

        grid.store.addListener('add', function (store) {
            update(store.grid);
        });

        function update(c) {
            var cells = $(c.el.dom).find('div.x-grid-cell-inner');

            for (var i = 0; i < cells.length; i++) {
                if (!$(cells[i]).parent().hasClass('ks-multiline-row'))
                    KS.util.Overflow.updateTooltip(cells[i], cells[i].innerText);
            }
        }
    },

    /**
     * Привязать подсказки к компоненту
     * 
     * @param {Ext.form.field.Base} field
     */
    bindFieldTooltip: function (field) {
        field.addListener('change', update);
        field.addListener('resize', update);

        function update(c) {
            KS.util.Overflow.updateTooltip(c.inputEl.dom, c.getValue());
        }
    },

    /**
     * Устанавливает/удаляет подсказку
     * 
     * @param {any} el - объект jQuery или элемент DOM
     * @param {any} value - значение ячейки
     * @param {any} [bindTo=el] - объект jQuery или элемент DOM к которому привязать подсказку
     */
    updateTooltip: function (el, value, bindTo) {
        bindTo = $(bindTo || el);
        el = $(el);

        if (this.check(el, value))
            bindTo.attr('title', value);
        else
            bindTo.removeAttr('title');
    },

    /**
     * Проверка переполнения значения над его контейнером
     * 
     * @param {any} el - объект jQuery или элемент DOM
     * @param {any} value - значение ячейки
     */
    check: function (el, value) {
        el = $(el);
        return this.getContentWidth(el, value) > el.width();
    },

    /**
     * Получить ширину текста независимо от его контейнера
     *
     * @param {any} el - объект jQuery или элемент DOM
     * @param {string} value
     * @returns {number}
     */
    getContentWidth: function(el, value) {
        el = $(el);
        
        var s = $('<span >' + value + '</span>'),
            width;

        s.css({
            position: 'absolute',
            left: -9999,
            top: -9999,
            'font-family': el.css('font-family'),
            'font-size': el.css('font-size'),
            'font-weight': el.css('font-weight'),
            'font-style': el.css('font-style')
        });

        $('body').append(s);

        width = s.width();

        s.remove();

        return width;
    }
});

Ext.override(Ext.tab.Bar, {
    config: {
        defaults: {
            listeners: {
                mouseover: function (c) {
                    KS.util.Overflow.updateTooltip(c.el.dom, c.getText());
                }
            }
        }
    }
});

Ext.override(Ext.tree.Panel, {
    config: {
        listeners: {
            itemmouseenter: function (c, record, item) {
                var $item = $(item),
                    parentWidth = $item.parent().width(),
                    items = $item.find('.x-grid-cell-inner > div'),
                    container = $('<div/>'),
                    width = parentWidth - $(items[0]).width() * items.length + 'px';

                container.css({
                    width: width
                });

                KS.util.Overflow.updateTooltip(container, item.innerText, item);
            }
        }
    }
});
//#endregion

// BUGS ovveride
// Тут переопределяются вещи которые вылетают в Ext.js
// строго указывать до запятой версию Ext.js чтобы при обновлении удалить

Ext.override(Ext.panel.Panel, {
    expandToolText: KS.L10n.expand,
    collapseToolText: KS.L10n.collapse,
    closeToolText: KS.L10n.close
});

Ext.override(Ext.window.Window, {
    expandToolText: KS.L10n.expand,
    collapseToolText: KS.L10n.collapse,
    closeToolText: KS.L10n.close
});

Ext.override(Ext.picker.Date, {
    startDay: 1
});

Ext.override(Ext.form.field.Date, {
    startDay: 1
});

// вылетает если скроллить вправо при первом открытии view.Table Extjs 6.5.3.57
Ext.override(Ext.view.Table,
    {
        onFocusEnter: function(e) {
            // We need to react in a correct way to focus entering the TableView.
            // Much of this is based upon http://www.w3.org/TR/wai-aria-practices-1.1/#h-grid
            // specifically: "Once focus has been moved inside the grid, subsequent tab presses that re-enter the grid shall return focus to the cell that last held focus."
            //
            // If an interior element is being focused, then if it is a cell, we enter navigable mode at that cell.
            // If an interior element *within* a cell is being focused, we enter actionable mode at that cell and focus that element.
            // If just the view itself is being focused we focus the lastFocused CellContext. This is the last cell position which
            // the user navigated to in any mode, actionable or navigable. It is maintained during navigation in navigable mode.
            // It is set upon focus leave if focus left during actionable mode - set to actionPosition.
            // actionPosition is cleared when actionable mode is exited.
            //
            // The important context is lastFocused.
            var me = this,
                fromComponent = e.fromComponent,
                navigationModel = me.getNavigationModel(),
                focusPosition,
                cell,
                focusTarget;
            // If a mousedown listener has synchronously focused an internal element
            // from outside and proceeded to process focus consequences, then the impending focusenter
            // MUST NOT process focus consequences.
            // See Ext.grid.NavigationModel#onCellMouseDown
            if (me.containsFocus) {
                return Ext.Component.prototype.onFocusEnter.call(me, e);
            }
            // FocusEnter while in actionable mode.
            if (me.actionableMode) {
                // If we own the actionPosition it must be due to a setActionPosition call
                // setting the actionPosition and then focusing the actionable element.
                // We need to disable view outer el focusing while focus is inside.
                if (me.actionPosition) {
                    me.el.dom.setAttribute('tabIndex', '-1');
                    me.cellFocused = true;
                    return;
                }
                // Must have swapped sides of a lockable.
                // We don't know what we're focusing into yet.
                // So exit actionable mode.
                // We could be focusing a cell, in which case navigable mode is correct.
                // If we are focusing an interior element that is not a cell, we will enter actionable mode.
                me.ownerGrid.setActionableMode(false);
            }
            // The underlying DOM event
            e = e.event;
            // We can only focus if there are rows in the row cache to focus *and* records
            // in the store to back them. Buffered Stores can produce a state where
            // the view is not cleared on the leading end of a reload operation, but the
            // store can be empty.
            if (!me.cellFocused && me.all.getCount() && me.dataSource.getCount()) {
                focusTarget = e.getTarget();
                // The View's el has been focused.
                // We now have to decide which cell to focus
                if (focusTarget === me.el.dom) {
                    // This lastFocused value is set on mousedown on the scrollbar in IE/Edge.
                    // Those browsers focus the element on mousedown on its scrollbar
                    // which is not what we want, so throw focus back in this
                    // situation.
                    // See Ext.view.navigationModel for this being set.
                    if (me.lastFocused === 'scrollbar') {

                        // #region KSBUG вот здесь дополнительная проверка
                        if (e.relatedTarget && e.relatedTarget.focus) {
                            e.relatedTarget.focus();
                        }
                        // #endregion KSBUG вот здесь дополнительная проверка
                        return;
                    }
                    focusPosition = me.getDefaultFocusPosition(fromComponent);
                    // Not a descendant which we allow to carry focus. Focus the view el.
                    if (!focusPosition) {
                        e.stopEvent();
                        me.el.focus();
                        return;
                    }
                    // We are entering navigable mode, so we have a focusPosition but no focusTarget
                    focusTarget = null;
                }
                // Hit the invisible focus guard. This mean SHIT+TAB back into the grid.
                // Focus last cell.
                else if (focusTarget === me.tabGuardEl) {
                    focusPosition = new Ext.grid.CellContext(me).setPosition(me.all.endIndex,
                        me.getVisibleColumnManager().getColumns().length - 1);
                    focusTarget = null;
                }
                // Now there are just two valid choices.
                // Focused a cell, or an interior element within a cell.
                else if (cell = e.getTarget(me.getCellSelector())) {
                    // Programmatic focus of a cell...
                    if (focusTarget === cell) {
                        // We are entering navigable mode, so we have a focusPosition but no focusTarget
                        focusPosition =
                            new Ext.grid.CellContext(me).setPosition(me.getRecord(focusTarget),
                                me.getHeaderByCell(cell));
                        focusTarget = null;
                    }
                    // If what is being focused an interior element, but is not a cell, we plan to enter
                    // actionable mode. This will happen when an ActionColumn invokes a modal window
                    // and that window is dismissed leading to automatic focus of the previously focused element.
                    // This also happens when SHIFT+TAB moves back towards the view. It navigated to the last tabbable element.
                    // Testing whether the focusTarget isFocusable is a fix for IE. It can sometimes fire a focus event with the .x-scroll-scroller as the target
                    else if (focusTarget && Ext.fly(focusTarget).isFocusable() && me.el.contains(focusTarget)) {
                        // We are entering actionable mode, so we have a focusPosition and a focusTarget
                        focusPosition =
                            new Ext.grid.CellContext(me).setPosition(me.getRecord(focusTarget),
                                me.getHeaderByCell(cell));
                    }
                }
            }
            // We must exit from the above code block with focusPosition set to a CellContext
            // which is going to be either the navigable or actionable position. If focusPosition
            // is null, we are not focusing the view.
            //
            // IF we are entering actionable mode, then focusTarget will be set to an internal
            // focusable element within the cell referenced by focusPosition.
            // We calculated a cell to focus on. Either from the target element, or the last focused position
            if (focusPosition) {
                // Disable tabbability of elements within this view.
                me.toggleChildrenTabbability(false);
                // If we fall through to here with a focusTarget, it means that it's an internal focusable element
                // and we request to enter actionable mode at the focusPosition
                if (focusTarget) {
                    // Tell actionable mode which element we want to focus.
                    // By default it focuses the first focusable in the cell.
                    focusPosition.target = focusTarget;
                    // If we successfully entered actionable mode at the requested position, prevent entering navigable mode by nulling
                    // the focusPosition, and focus the intended target (setActionableMode will have focused the *first* tabbable in the cell)
                    // If we were unsuccessful, then we must proceed with focusPosition set in order to enter navigable mode here.
                    if (me.ownerGrid.setActionableMode(true, focusPosition)) {
                        focusPosition = null;
                    }
                }
                // Test again here.
                // If we successfully entered actionable mode, this will be null.
                // If the attempt failed, it should fall back to navigable mode.
                if (focusPosition) {
                    navigationModel.setPosition(focusPosition, null, e, null, true);
                }
                // We now contain focus if that was successful
                me.cellFocused = me.el.contains(Ext.Element.getActiveElement());
                if (me.cellFocused) {
                    me.el.dom.setAttribute('tabIndex', '-1');
                }
            }
            // Skip the AbstractView's implementation.
            // It initializes its NavModel differently.
            Ext.Component.prototype.onFocusEnter.call(me, e);
        }
    });

// вылетает если скроллить вправо т.к. у LockingGridView нет body а в events он используется Ext JS 6.6.0.258
Ext.override(Ext.grid.locking.View,
	{
		body: {}
	});

/**
 * Ext JS 6.7.0.210
 * Не срабатывает снятие выделения в гриде если добавить дополнительные строки
 * https://bugzilla.keysystems.ru/bugzilla/show_bug.cgi?id=136697
 */
Ext.override(Ext.grid.selection.SpreadsheetModel, {
    privates: {
        fireSelectionChange: function() {
            var me = this,
                sel = me.selected,
                view = sel.view,
                grid = view.ownerGrid,
                store = view.dataSource,
                records, count;
            // Inform selection object that we're done
            me.updateSelectionExtender();
            // We must still fire a selectionchange event through the SelectionModel
            // because Ext.panel.Table listens for this event to update its bound selection.
            if (sel.isRows) {
                records = sel.getRecords();
                count = store.getCount() || store.getTotalCount();
                // When there is a BufferedStore the allSelected flag cannot be set
                // in a manual selection
                if (me.pruneRemoved === true) {
                    // eslint-disable-next-line max-len
                    me.selected.allSelected = !!(store.isBufferedStore ? me.selected.allSelected : count && records.length && (count === records.length));
                }
                me.fireEvent('selectionchange', me, records);
            } else if (sel.isCells) {
                me.selected.allSelected = false;
                // eslint-disable-next-line max-len
                me.fireEvent('selectionchange', me, sel.getCount() ? me.store.getRange.apply(sel.view.dataSource, sel.getRowRange()) : []);
            }
            grid.fireEvent('selectionchange', grid, sel);
        }
    }
});

/**
 * Ext JS 6.7.0.210
 * Не срабатывает событие открытия редактора по ячейке сортированного грида
 * https://bugzilla.keysystems.ru/bugzilla/show_bug.cgi?id=136838
 */
Ext.override(Ext.grid.plugin.CellEditing, {
    /**
     * Override
     * Т.к. нет редактора ячейки по клику из-за сортировки, вызываем событие редактирования явно асинхронно
     */
    selectAfterSort: function (table, td, cellIndex, record, tr, rowIndex, e) {
        var me = this,
            grid = table.grid;

        if (!me.activeRecord) {
            grid.removeListener('beforecellmousedown', me.selectAfterSort);
            return;
        }

        if (me.activeRecord.id !== record.id)
            setTimeout(() => {
                me.startEdit(record, table.grid.getColumns()[cellIndex]);
            }, 0);
    },

    activateCell: function (position, skipBeforeCheck, doFocus) {
        var me = this,
            record = position.record,
            column = position.column,
            prevEditor = me.getActiveEditor(),
            view = me.view,
            isResuming = me.restartEvent != null,
            context, contextGeneration, cell, editor, p, editValue, abortEdit;

        if (isResuming) {
            me.restartEvent = Ext.destroy(me.restartEvent);
        }

        context = me.getEditingContext(record, column);

        if (!context || !column.getEditor(record)) {
            return;
        }

        // Activating a new cell while editing.
        // Complete the edit, and cache the editor in the detached body.
        if (prevEditor && prevEditor.editing) {
            // Silently drop actionPosition in case completion of edit causes
            // and view refreshing which would attempt to restore actionable mode
            view.actionPosition = null;

            contextGeneration = context.generation;

            if (prevEditor.completeEdit() === false) {
                return;
            }

            // Complete edit could cause a sort or column movement.
            // Reposition context unless user code has modified it for its own purposes.
            if (context.generation === contextGeneration) {
                context.refresh();
            }
        }

        if (!skipBeforeCheck) {
            // Allow vetoing, or setting a new editor *before* we call getEditor
            contextGeneration = context.generation;

            // Disable focus restoration in any of the before edit handling.
            // We are going to be doing that below
            if (view.actionableMode) {
                view.skipSaveFocusState = true;
            }

            //#region Override
            /**
             * https://bugzilla.keysystems.ru/bugzilla/show_bug.cgi?id=136838
             */
            if (me.grid.store.sorters.length)
                me.grid.addListener('beforecellmousedown', me.selectAfterSort, me);
            //#endregion Override

            abortEdit = me.beforeEdit(context) === false ||
                me.fireEvent('beforeedit', me, context) === false || context.cancel;

            // Clear temporary flag
            view.skipSaveFocusState = false;

            if (abortEdit) {
                return;
            }

            // beforeedit edit could cause sort or column movement
            // Reposition context unless user code has modified it for its own purposes.
            if (context.generation === contextGeneration) {
                context.refresh();
            }
        }

        // Recapture the editor. The beforeedit listener is allowed to replace the field.
        editor = me.getEditor(record, column);

        // If the events fired above ('beforeedit' and potentially 'edit') triggered
        // any destructive operations regather the context using the ordinal position.
        if (context.cell !== context.getCell(true)) {
            context = me.getEditingContext(context.rowIdx, context.colIdx, null, context.view);
            position.setPosition(context);
        }

        if (editor) {
            cell = Ext.get(context.cell);

            // Ensure editor is there in the cell.
            // And will then be found in the tabbable children of the activating cell
            if (!editor.rendered) {
                editor.hidden = true;
                editor.render(cell);
            } else {
                p = editor.el.dom.parentNode;

                if (p !== cell.dom) {
                    // This can sometimes throw an error
                    // https://code.google.com/p/chromium/issues/detail?id=432392
                    try {
                        p.removeChild(editor.el.dom);
                    } catch (e) {
                        // ignore
                    }

                    if (editor.container && editor.container.dom !== cell.dom) {
                        editor.container.collect();
                    }

                    editor.container = cell;
                    cell.dom.appendChild(editor.el.dom, cell.dom.firstChild);
                }
            }

            // Refresh the contextual value in case any event handlers (either the 'beforeedit'
            // of this edit, or the 'edit' of any just terminated previous editor) mutated
            // the record
            // https://sencha.jira.com/browse/EXTJS-19899
            editValue = context.record.get(context.column.dataIndex);

            if (editValue !== context.originalValue) {
                context.value = context.originalValue = editValue;
            }

            me.setEditingContext(context);

            // Request that the editor start.
            // Ensure that the focusing defaults to false.
            // It may veto, and return with the editing flag false.
            editor.startEdit(cell, context.value, (doFocus && !isResuming) || false, isResuming);

            // Set contextual information if we began editing (can be vetoed by events)
            if (editor.editing) {
                me.setActiveEditor(editor);
                me.setActiveRecord(context.record);
                me.setActiveColumn(context.column);
                me.editing = true;
                me.scroll = position.view.el.getScroll();

                if (isResuming) {
                    editor.setValue(me.cachedEditorValue);
                    me.cachedEditorValue = null;
                }
            }

            // Return true if the cell is actionable according to us
            return editor.editing;
        }
    }
});

// Version: 7.0.0.156 Build date: 2019-08-22 21:19:41
// клик при readonly по полю
Ext.override(Ext.form.trigger.Trigger, {
    onClick: function() {
        var me = this,
            args = arguments,
            e = me.clickRepeater ? args[1] : args[0],
            handler = me.handler,
            field = me.field;

        //#region override
        if (handler && (!field.readOnly || !me.hideOnReadOnly) && me.isFieldEnabled()) {
            Ext.callback(me.handler, me.scope, [field, me, e], 0, field);
        }
        //#endregion
        
        // if (handler && !field.readOnly && me.isFieldEnabled()) {
        //     Ext.callback(me.handler, me.scope, [field, me, e], 0, field);
        // }
    }
})

// Version: 7.0.0.156 Build date: 2019-08-22 21:19:41
// сохранение переноса строки в текстовых немногострочных атрибутах
Ext.override(Ext.form.field.Text, {
    setRawValue: function(value) {
        var me = this,
            rawValue = me.rawValue;
        if (!me.transformRawValue.$nullFn) {
            value = me.transformRawValue(value);
        }
        value = Ext.valueFrom(value, '');

        if (me.saveWraps)
            value = me.saveWordWraps(value);

        if (rawValue === undefined || rawValue !== value) {
            me.rawValue = value;
            // Some Field subclasses may not render an inputEl
            if (me.inputEl) {
                me.bindChangeEvents(false);
                me.inputEl.dom.value = value;
                me.bindChangeEvents(true);
            }
        }
        if (me.rendered && me.reference) {
            me.publishState('rawValue', value);
        }
        return value;
    },

    saveWordWraps: function(str) {
        var me = this,
            value = str,
            lastIndex = 0;

        me._wordWraps = {};

        for (var i = str.indexOf('\n'); i != -1; i = str.indexOf('\n')) {
            str = str.substring(i + 1);

            lastIndex = value.length - (str.length + 1);

            me._wordWraps[lastIndex] = true;
        }

        return value.replace(/\n/g, ' ')
    },

    restoreWordWraps: function(str) {
        var me = this,
            value = "";

        for (var i = 0; i < str.length; i++) {
            if (me._wordWraps[i])
                value += '\n';
            else
                value += str[i];
        }

        return value;
    },

    rawToValue: function(value) {
        return this.restoreWordWraps(value);
    },

    initComponent: function() {
        var me = this,
            emptyCls = me.emptyCls;

        me._wordWraps = {};

        if (me.allowOnlyWhitespace === false) {
            me.allowBlank = false;
        }
        if (me.grow) {
            me.liquidLayout = false;
        }
        if (me.size) {
            Ext.log.warn('Ext.form.field.Text "size" config was deprecated in Ext 5.0. ' + 'Please specify a "width" or use a layout instead.');
        }
        // In Ext JS 4.x the layout system used the following magic formula for converting
        // the "size" config into a pixel value.
        if (me.size) {
            me.defaultBodyWidth = me.size * 6.5 + 20;
        }
        if (!me.onTrigger1Click) {
            // for compat with 4.x TriggerField
            me.onTrigger1Click = me.onTriggerClick;
        }
        me.callParent();
        if (me.readOnly) {
            me.setReadOnly(me.readOnly);
        }
        me.fieldFocusCls = me.baseCls + '-focus';
        me.emptyUICls = emptyCls + ' ' + emptyCls + '-' + me.ui;
        me.addStateEvents('change');
    },
})

// Ext JS 7.0.0.156
// Сохранение позиций записей при выделении
Ext.override(Ext.selection.Model, {
    getSelection: function() {
        //#region override
        var selection = this.selected.getRange();
        
        if (this.saveSelectionOrder)
            selection.sort(function(x, y) {
                return x.internalId - y.internalId;
            });
        
        return selection;
        //#endregion override
    },

    getStoreSelection: function() {
        var selModel = this,
            selection = selModel.getSelection();
        // Получаем только те строки, которые есть в store
        var selectionInStore = Ext.Array.filter(selection, function(rec) {
            return !!selModel.store.data.map[rec.id];
        });
        return selectionInStore;
    }
});

// Ext JS 7.0.0.156 
// в Ext.layout.container.Card.setActiveItem нет проверки на тип activeItem, он может быть либо число(вызовется исключение), либо объект ExtJS
Ext.override(Ext.layout.container.Card, {
    setActiveItem: function() {
        const activeItem = this.activeItem;
        
        if (Ext.isNumber(activeItem)) {
            this.activeItem = this.getActiveItem(); // this.activeItem как объект ExtJS
        }
        
        if (this.activeItem && this.activeItem.rendered === false) { // если не отрендерен активный, то выйдет исключение
            this.activeItem = 0;
        }
        
        const result = this.callParent(arguments);
        
        if (result === false) { // если ничего не поменялось, то возвращаем как было
            this.activeItem = activeItem;
        }
        
        return result;
    }
});

// При pruneRemoved = false инициализируем selectedRecords, чтобы избежать ошибок при фильтрации, если не было выделения строк
Ext.override(Ext.grid.selection.Rows, {
    constructor: function(view) {
        this.callParent(arguments);
        var selModel = this.view.getSelectionModel();
        if (selModel.pruneRemoved === false && selModel.type === 'spreadsheet') {
            // Инициализируем selectedRecords
            this.selectedRecords = this.createRecordCollection();
        }
    }
});
