////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
// BASE

(function(viewClass) {
    KS.apply(viewClass,
        {
            onInit: function() {
                this.renderViewTemplate();
            },

            renderViewTemplate: function() {
                if (!this.tpl) return;
                if (!this._tplCtrls) this._tplCtrls = [];
                if (this.tpl.root) {
                    this.renderTemplateRoot();
                } else {
                    this.createTemplateControls();
                }

                KS.registerCssStyles(this.tpl.cssList);
                KS.registerStringCss(this.tpl.cssString);
            },

            createTemplateControls: function() {
                var tc = this.tpl.controls || [];
                for (var ctrlId in tc) {
                    if (tc.hasOwnProperty(ctrlId)) {
                        this.createTemplateControl(tc[ctrlId], ctrlId);
                    }
                }
            },

            createTemplateControl: function(ctrl, ctrlId) {
                if (ctrl) {
                    ctrl.parentView = this;
                    var tbars = this.buildTemplateToolbars(ctrl.toolbars, ctrl.itemId),
                        cfg = KS.apply(tbars, this.overrideTemplateControlCfg(ctrlId)),
                        instance = KS.create(ctrl, cfg);
                    ctrlId = ctrlId || ctrl.itemId;
                    if (instance && !KS.isEmpty(ctrlId)) {
                        instance.ctrlId = ctrlId;
                        this[ctrlId] = instance;
                        this._tplCtrls.push(instance);
                        if (Ext.isObject(this.tpl.controls))
                            this.tpl.controls[ctrlId] = ctrl;
                    }
                    return instance;
                }
                return null;
            },

            overrideTemplateControlCfg: function() {
                return {};
            },

            renderTemplateRoot: function() {
                var r = this.tpl.root;
                if (KS.isString(r)) {
                    r = this.tpl.controls[r];
                }
                if (KS.isObject(r)) {
                    this.rootEl = this.createTemplateControl(r);
                }
                this.addPanelItems(r, this.rootEl);
                this.renderToParent(this.rootEl);
                this.onTemplateRendered();
                this._tplRendered = true;
            },

            onTemplateRendered: function() {
            },

            addPanelItems: function(parentCtrl, parentInst) {
                var type = (parentCtrl.type || '').toLowerCase(),
                    canHaveItems = type.indexOf('panel') >= 0 ||
                        type.indexOf('container') >= 0 ||
                        type.indexOf('fieldset') >= 0 ||
                        type.indexOf('radiogroup') >= 0 ||
                        type.indexOf('checkboxgroup') >= 0;
                if (!canHaveItems || KS.isEmpty(parentCtrl.items)) return;
                for (var idx = 0; idx < parentCtrl.items.length; idx++) {
                    var item = parentCtrl.items[idx],
                        ctrl = null,
                        inst = null;
                    if (item) {
                        ctrl = KS.isString(item) ? this.tpl.controls[item] : item;
                        var ctrlId = KS.isString(item) ? item : ctrl.itemId;
                        inst = this.createTemplateControl(ctrl, ctrlId);
                    }
                    if (ctrl && inst) {
                        this.addPanelItems(ctrl, inst);
                        parentInst.add(inst);
                    }
                }
            }
        });
}(KS.ClientView.prototype));

////////////////////////////////////////////////////////////////////////////////
// Toolbars
(function(viewClass) {
    KS.apply(viewClass,
        {
            buildTemplateToolbars: function(toolbars, itemId) {
                var result = {};
                if (toolbars) {
                    result.tbar = this.buildTemplateToolbar(toolbars["Top"], itemId + 'Tbar');
                    result.bbar = this.buildTemplateToolbar(toolbars["Bottom"], itemId + 'Bbar');
                    result.lbar = this.buildTemplateToolbar(toolbars["Left"], itemId + 'Lbar');
                    result.rbar = this.buildTemplateToolbar(toolbars["Right"], itemId + 'Rbar');
                }
                return result;
            },

            buildTemplateToolbar: function(toolbar, itemId) {
                if (KS.isEmpty(toolbar) || KS.isEmpty(toolbar.nodes)) return false;
                var items = [];
                for (var idx = 0; idx < toolbar.nodes.length; idx++) {
                    var item = this.buildToolbarItemControl(toolbar.nodes[idx]);
                    if (item) items.push(item);
                }
                var inst = KS.create('toolbar',
                    { items: items, itemId: itemId, dock: toolbar.dock },
                    this.containerPanel);
                inst.rawItems = items;
                return inst;
            },

            getToolbar: function() {
                return null;
            },

            getToolbarItem: function() {
                return null;
            },

            setTbarItemAttributes: function() {
            },

            isGrid: function(ctrl) {
                return ctrl && ctrl.gridSettings;
            },

            findOwnerContainer: function(inst) {
                if (inst.tbarNode &&
                    inst.tbarNode.additional &&
                    !KS.isEmpty(inst.tbarNode.additional.owner) &&
                    this[inst.tbarNode.additional.owner])
                    return this[inst.tbarNode.additional.owner];
                return null;
            },

            buildToolbarItemControl: function(tbarNode) {
                if (tbarNode.WebVisibility === false) return null;
                var ctrl = null;
                switch (tbarNode.nodeStyle) {
                case -1: // DEFAULT
                    break;

                case 0: // BUTTONTOOL
                    ctrl = this.buildToolbarBtn(tbarNode, false);
                    //ctrl = KS.create('tbarbutton', tbarNode, this, false);
                    break;

                case 1: // CHECK (Несохраняемый в профиль)
                case 2: // GROUP
                    break;

                case 3: //'SEPARATOR'
                    ctrl = KS.create('tbseparator', tbarNode);
                    break;

                case 4: // CONTAINER
                    ctrl = this.buildContainerToolbarItemControl(tbarNode, null);
                    break;

                case 6: // TEXTBOX
                    //debugger;
                    if (tbarNode.additional && tbarNode.additional.nodetype == 'filefield') {
                        ctrl = KS.create({
                                type: 'filefield',
                                parentView: this,
                                itemId: tbarNode.code,
                                usePopup: tbarNode.usePopup,
                                listeners: tbarNode.listeners
                            },
                            tbarNode.additional);
                    } else {
                        ctrl = KS.create({
                                type: 'textEditor',
                                parentView: this,
                                itemId: tbarNode.code,
                                value: tbarNode.additional ? tbarNode.additional.value : null,
                                listeners: tbarNode.listeners
                            },
                            tbarNode.additional);
                    }
                    break;

                case 7: // LABEL
                    ctrl = KS.create('label',
                        Ext.apply({
                            iconCls: tbarNode.image ? 'ks-icon-' + tbarNode.image : '',
                            cls: tbarNode.additional ? tbarNode.additional.cls : undefined,
                            text: tbarNode.name,
                            id: this.controlID + tbarNode.code
                        }, tbarNode.additional));
                    
                    
                    
                    break;

                case 8: // SPLITTER
                    break;

                case 9: // COMBOBOX
                    ctrl = KS.create({
                            type: 'combo',
                            parentView: this,
                            label: tbarNode.additional.label,
                            itemId: tbarNode.code,
                            gridOnExpand: tbarNode.additional.gridOnExpand,
                            name: tbarNode.additional.displayField,
                            code: tbarNode.additional.valueField,
                            listeners: tbarNode.listeners,
                            fields: tbarNode.additional.fields,
                            rows: tbarNode.additional.rows,
                            value: tbarNode.additional.value
                        },
                        tbarNode.additional);
                    break;

                case 10: // BUTTONTOOL_WITH_TEXT (Кнопка с текстом)
                    ctrl = this.buildToolbarBtn(tbarNode, true);
                    break;

                case 11: // POPUP_WITH_TEXT (Кнопка с подкнопками с текстом)
                    ctrl = this.buildToolbarBtn(tbarNode, true);
                    break;

                case 12: // CHECK_WITH_TEXT (Несохраняемый в профиль check с текстом)
                    ctrl = KS.create({
                            type: 'checkbox',
                            parentView: this,
                            label: tbarNode.name,
                            itemId: tbarNode.code,
                            value: tbarNode.checked,
                            listeners: tbarNode.listeners
                        },
                        tbarNode.additional);
                    break;

                case 5: // POPUP (Сама кнопка копируется на нижний уровень)
                case 13: // POPUP2 (Сама кнопка НЕ копируется на нижний уровень)
                    ctrl = this.buildToolbarBtn(tbarNode, tbarNode.nodeStyle == 5);
                    break;

                case 16: // DATEBOX
                    ctrl = KS.create({
                            type: 'dateField',
                            parentView: this,
                            itemId: tbarNode.code,
                            format: tbarNode.additional.format || null,
                            value: tbarNode.additional ? tbarNode.additional.value : null,
                            listeners: tbarNode.listeners
                        },
                        tbarNode.additional);
                    break;

                case 101: // CHECK2 (Сохраняемый в профиль)
                    break;
                }

                if (ctrl && !KS.isEmpty(tbarNode.childNodes)) {
                    var subItems = [];
                    for (var idx in tbarNode.childNodes) {
                        if (tbarNode.childNodes.hasOwnProperty(idx)) {
                            var subItem = tbarNode.childNodes[idx];
                            subItem.parentNode = tbarNode;
                            var subCtrl = this.buildToolbarItemControl(subItem);
                            if (subCtrl) subItems.push(subCtrl);
                        }
                    }
                    if (!KS.isEmpty(subItems)) {
                        var plugin = tbarNode.pluginName || tbarNode.pluginNameWeb;
                        if ((((tbarNode.nodeStyle === 0 || tbarNode.nodeStyle === 13) && ctrl.handler) || plugin)) {
                            ctrl.split = true;
                        }
                        ctrl.menu = KS.create('simpleMenu', this, subItems, {});
                    }
                }
                if (ctrl && typeof (this.processToolbarItemControl) == 'function')
                    ctrl = this.processToolbarItemControl(ctrl, tbarNode);
                if (ctrl) ctrl.tbarNode = tbarNode;
                return ctrl;
            },

            childNodesToItems: function(tbarNode) {
                var items = [];
                for (var idxr in tbarNode.childNodes) {
                    if (tbarNode.childNodes.hasOwnProperty(idxr)) {
                        var item = tbarNode.childNodes[idxr];
                        item.parentNode = tbarNode;
                        var ctrl = this.buildToolbarItemControl(item);
                        if (ctrl) items.push(ctrl);
                    }
                }
                tbarNode.childNodes = null;
                return items;
            },

            processToolbarItemControl: function(ctrl) {
                return ctrl;
            },

            buildToolbarBtn: function() {
                return null;
            },

            buildContainerToolbarItemControl: function(tbarNode) {
                if (tbarNode.additional && tbarNode.additional.nodetype === 'buttongroup') {
                    var buttongroupItems = this.childNodesToItems(tbarNode);
                    return KS.create({
                            type: 'buttongroup',
                            columns: tbarNode.additional.columns,
                            itemId: tbarNode.code,
                            title: tbarNode.name,
                            items: buttongroupItems
                        },
                        tbarNode.additional);
                } else if (tbarNode.additional && tbarNode.additional.nodetype === 'radiogroup') {
                    var radiogroupItems = this.childNodesToItems(tbarNode);
                    return KS.create({
                            type: 'radiogroup',
                            itemId: tbarNode.code,
                            columns: tbarNode.additional.columns,
                            vertical: tbarNode.additional.vertical,
                            title: tbarNode.title,
                            isToolBar: true,
                            disabled: tbarNode.disabled,
                            items: radiogroupItems
                        },
                        tbarNode.additional);
                } else if (tbarNode.additional && tbarNode.additional.nodetype === 'radio') {
                    return KS.create({
                            type: 'radio',
                            parentView: this,
                            label: tbarNode.name,
                            itemId: tbarNode.code,
                            value: tbarNode.checked,
                            listeners: tbarNode.listeners
                        },
                        tbarNode.additional);
                } else if (this.tpl && this.tpl.controls && this.tpl.controls[tbarNode.code]) {
                    return this.createTemplateControl(this.tpl.controls[tbarNode.code]);
                } else if (tbarNode.nodeStyle === 4 && tbarNode.code === 'Fill') {
                    return KS.create('tbfill');
                } else if (tbarNode.nodeStyle === 4 && tbarNode.code.startsWith('Space')) {
                    return KS.create('tbspacer', +tbarNode.code.split('_')[1]);
                }
                return {};
            },

            checkHandler: function(method) {
                if (KS.isEmpty(method) || !KS.isString(method)) return null;
                var parts = method.split('.'),
                    scope = parts[0],
                    name = parts[1],
                    isBinded = parts[2] && Ext.String.startsWith(parts[2], 'bind');

                if (scope === 'view') {
                    scope = this;
                } else {
                    return null;
                }

                if (!KS.isEmpty(name) && scope[name] && KS.isFunction(scope[name]))
                    return isBinded ? scope[name].bind(scope) : scope[name];
            },

            getTbarClickHandler: function(tbarNode) {
                if (tbarNode.code === 'EXIT') {
                    return this.doClose;
                }

                if (tbarNode.nodeType == "expopup")
                    return undefined;

                return this.checkHandler(tbarNode.pluginNameWeb) ||
                    (KS.isEmpty(tbarNode.code) ? undefined : this.templateTbarClickHandler);
            },

            templateTbarClickHandler: function() {
                var view = this.parentView,
                    node = this.tbarNode,
                    ajax = {
                        method: 'ToolbarClickHandler',
                        waitMessage: node.waitMessage,
                        params: [node.code || null, node.additional || {}, view.getTemplateState()],
                        success: view.checkHandler(node.onSuccess) || view.templateTbarClickHandlerCallback
                    };

                view.beforeServerCall && view.beforeServerCall(ajax, node, 'templateTbarClickHandler', this);
                view.serverCall(ajax);
            },

            templateTbarClickHandlerCallback: function() {
            },

            doClose: function() {
                var view = this.parentView || this;
                if (KS.isFunction(view.close)) view.close();
            },

            notImplementedHandler: function() {
                KS.msg('[' + (this.name || '') + '] not implemented');
            },

            emtpyHandler: function() {
            }
        });
}(KS.ClientView.prototype));

////////////////////////////////////////////////////////////////////////////////
// Events
(function(viewClass) {
    KS.apply(viewClass,
        {
            serverEventInterceptor: function() {
                var listener = this.listener,
                    methodName = listener.methodName,
                    mask = listener.mask,
                    needProfile = (methodName === 'SaveControlProfile'),
                    templState = this.view.getTemplateState(this.inst, needProfile, this.eventName, [].slice.call(arguments, 0)),
                    ajax = {
                        method: 'RaiseControlEvent',
                        params: [methodName, templState]
                    };
                if (mask != null) {
                    switch (mask.target) {
                    case 0: // None
                        ajax.disableFog = true;
                        break;
                    case 1: // View
                        break;
                    case 2: // Controls
                        break;
                    case 3: // Toolbars
                        break;
                    }
                    if (!KS.isEmpty(mask.message))
                        ajax.waitMessage = mask.message;
                }
                this.view.serverCall(ajax);
            },

            getTemplateState: function (src, needProfile, evtName, evtArgs) {
                var state = {};
                if (src && src.ctrlId) {
                    state.EventControlId = src.ctrlId;
                    this.applyCtrlState(state, src, needProfile, evtName, evtArgs);
                } else {
                    if (this.tpl && this.tpl.controls) {
                        for (var ctrlId in this.tpl.controls) {
                            if (this.tpl.controls.hasOwnProperty(ctrlId) && this[ctrlId] && this[ctrlId].rendered) {
                                this.applyCtrlState(state, this[ctrlId], needProfile, evtName, evtArgs);
                            }
                        }
                    }
                }
                return state;
            },

            applyCtrlState: function (state, src, needProfile, evtName, evtArgs) {
                var dict = {};
                if (KS.isFunction(src.getControlState)) {
                    dict["CTRLSTATE_" + src.ctrlId] = JSON.stringify(src.getControlState(null, evtName, evtArgs));
                }
                if (needProfile) {
                    if (KS.isFunction(src.getProfile)) {
                        dict["CTRLPROFILE_" + src.ctrlId] = JSON.stringify(src.getProfile());
                    } else if (src &&
                        src.parentView &&
                        src.parentView.viewLayout &&
                        src.parentView.viewLayout[src.ctrlId]) {
                        dict["CTRLPROFILE_" + src.ctrlId] = JSON.stringify(src.parentView.viewLayout[src.ctrlId]);
                    }
                }
                if (KS.isEmpty(state.AddProperties)) state.AddProperties = {};
                KS.apply(state.AddProperties, dict);
            }
        });
}(KS.ClientView.prototype));