////////////////////////////////////////////////////////////////////////////////
KS.viewID = 'M';
// главное окно с точки зрения waitbox

KS.ClientView = function(viewID) {
    var me = this;
    me.viewID = viewID || {};
    me.controlID = viewID || {};
    me._dropWindow = false;
    me.tasks = {};
    me.dependentViews = [];
    me.resources = {};
    me.masterView = null; // идентификатор родительского окна (если есть)
    me.ajaxQueue = []; // очередь сообщений
    KS.registerView(me);
};

KS.ClientView.prototype = {
    tryExecuteTask: function(name) {
        if (name in this.tasks) {
            var r = this.tasks[name].apply(this, []);
            if (typeof(r) !== 'undefined')
                return Boolean(r);
            return true;
        }
        return false;
    },

    init: function() {
        var me = this;
        var action = function() {
            var e = document.getElementById(me.controlID + '_class');
            if (e) me._serverClass = eval(e.value);
            if (me.onInit != null) {
                TRACE('Init view ' + me.viewID + ' [' + (!!e ? e.value : 'none') + ']', 'view');
                me.onInit.apply(me);
            }
        };

        if (KS.catchErrors) {
            try {
                action();
            } catch(ex) {
                me.onError.apply(me, [ex]);
            }
        } else
            action();
    },

    activate: function() {
    },

    onValuesSelected: function() {
    },

    onUpdateData: function(/*arg*/) {
    },

    onReloadData: function(/*arg*/) {
    },

    onRefresh: function(/*arg*/) {
    },

    // сбор данных, теоретически способных помочь в локализации проблемы
    getIssueData: function() {
        return {};
    },

    onBeforeClose: function(/*panel*/) {
        var me = this;
        if (me._dropWindow) {
            me._dropWindow = false;
            return true;
        }
        return me.close();
    },

    onClose: function(/*panel*/) {
        this._dropWindow = false;
    },

    onAfterClose: function() {
    },

    onError: function(ex) {
        this.forceStopWaiting();
        if (ex != null) {
            if ('message' in ex) KS.error(ex.message);
            else KS.error(ex.toString());
        }
    },

    onActivate: function(/*panel*/) {
        // планируется отправлять активное окно попутно с запросами        
        //        this.serverCall({
        //                async: true,
        //                method: 'ShowView',
        //                params: [],
        //                disableFog: true
        //            });
    },

    onDependentChanged: function() {
    },

    close: function (closeContainerPanel) {
        var me = this;

        if (typeof(me.addChildView) !== 'function') {
            var c = me.dependentViews.length;
            if (c > 0) {
                var msg = KS.L10n.unableCloseForm + ' ' + c;
                var r = c % 10;
                if (r == 1) msg = msg + KS.L10n.clientView_DependentWindow;
                else if (r > 0 && r <= 4) msg = msg + KS.L10n.clientView_DependentWindows;
                else msg = msg + KS.L10n.clientView_DependentsWindows;
                KS.alert(msg);
                return false;
            }
        }

        me._closing = true;
        me.serverCall({
            method: 'CloseView',
            disableFog: false,
            waitMessage: KS.L10n.closingWindow,
            success: function() {
                if (closeContainerPanel !== false && me.containerPanel && me.containerPanel.doClose) {
                     me.containerPanel.doClose();
                }

                me.drop();
                me.onAfterClose();
            }
        });

        return true;
    },

    drop: function() {
        var me = this;
        me._dropWindow = true;
        $('#' + me.updatePanel + '_u').val('');
        KS.unregisterView(me);
        KS._syncPanel(me.updatePanel);
        var e = document.getElementById(me.updatePanel);
        if (e) {
            while (e.hasChildNodes())
                e.removeChild(e.firstChild);
        }
    },

    removeFromAjaxQueue: function(uniqueID) {
        var me = this;
        for (var i = 0; i < me.ajaxQueue.length; i++) {
            if (me.ajaxQueue[i].uniqueID == uniqueID) {
                me.ajaxQueue.splice(i, 1);
                break;
            }
        }
    },

    continueFromAjaxQueue: function() {
        var me = this;
        if (me.ajaxQueue.length > 0) {
            var cfg = me.ajaxQueue[0];
            KS.log(KS.L10n.sendingMsgQueue + ' ' + cfg.method, 'ajax');
            me._doServerCall(cfg);
        }
    },

    serverCall: function(cfg) {
        var me = this;
        cfg.viewContext = me;
        if (!(cfg.method in me._serverClass))
            throw KS.L10n.asyncMethod + ' ' + cfg.method + ' ' + KS.L10n.notFound + ".";

        cfg.uniqueID = KS.getNextID();

        if (!cfg.urgent) {
            me.ajaxQueue.push(cfg);
            var l = me.ajaxQueue.length;
            if (l > 1) {
                KS.log(KS.L10n.clientView_MessagePlacedQueue + cfg.method + KS.L10n.clientView_Previously + me.ajaxQueue[l - 2].method, 'queue');
                return null;
            }
        }

        return me._doServerCall(cfg);
    },

    _doServerCall: function(cfg) {
        var p = [cfg];
        if (!!cfg.params) p = p.concat(cfg.params);
        return this._serverClass[cfg.method].apply(this._serverClass, p);
    },

    includeStyles: function(arr) {
        if (KS.isValid(arr)) {
            $.each(arr, function(n, o) {
                var vCss = document.createElement('link');
                vCss.rel = 'stylesheet';
                vCss.type = 'text/css';
                vCss.href = o;
                document.getElementsByTagName('head')[0].appendChild(vCss);
            });
        }
    },

    syncClientData: function(macroSequence, surely) {
        //debugger;
        var letsDo = surely;
        if (!surely) {
            if (!macroSequence) return;
            if (!this.Document) return;
            var currMacro = macroSequence.getCurrentMacro();
            //если сейчас клиентский макрос, то на клиенте последние данные
            if (!currMacro || currMacro.isClient) return;
            //если был серверный макрос и следующий макрос клиентский
            //или произойдет завершение последовательности
            var nextMacro = macroSequence.getNextMacro();
            letsDo = !nextMacro || nextMacro.isClient;
        }
        if (letsDo) {
            this.serverCall({
                async: false,
                method: 'DocumentDataValues',
                params: [],
                success: function(values) {
                    this.Document.setValues({ dsValues: values, fillControls: true });
                }
            });
        }
    }
};

KS.Grid = {
    Column: function(cfg) {
        return KS.apply({}, cfg, {
            key: null,
            dataIndex: "ID",
            header: null,
            order: 0,
            width: 0,
            resizable: true,
            filter: null,
            sorting: null,
            sorting_order: 0,
            sortable: false,
            result: null,
            visibility: false,
            hideable: true,
            groupby: false,
            expandrows: false,
            editable: false,
            align: 0,
            locked: false,
            editor: null,
            renderer: null,
            aspType: null,
            dataType: null,
            RowLayout: null
        });
    },

    ColumnArray: function(arr) {
        var r = [];
        for (var n = 0; n < arr.length; n++) {
            r.push(KS.Grid.Column(arr[n]));
        }
        return r;
    },

    getAnyCase: function(rec, field) {
        if (!rec || !field) {
            return null;
        }
        return rec.get(field) || rec.get(field.toLowerCase()) || rec.get(field.toUpperCase());
    }
};

KS.apply(KS.ClientView.prototype, KS.WaitBox);