Ext.define('Svod.displayChat.DisplayChatSendMessageContainer', {
    extend:  Ext.panel.Panel,

    xtype: 'displayChatSendMessageContainer',

    cls: 'displayChatSendMessageContainer',

    reference: 'displayChatSendMessageContainer',

    referenceHolder: true,

    width: '100%',

    title: `
             <div class="displayChatSendMessageContainer-buttonBackContainer">
                <button class="displayChatSendMessageContainer-buttonBack">К списку чатов</button>                
                <p class="displayChatSendMessageContainer-chatName"></p>
                <div class="displayChatSendMessageContainer-chatBotNameContainer">
                    <p class="displayChatSendMessageContainer-chatBotName"></p>
                    <button class="chatBot-closeButton" hidden="true">Сменить базу данных Чат-бота</button>
                </div>
            </div>
        `,

    // отображение сообщений
    displayChat: null,

    // поле отправки сообщения
    messageField: null,

    // кнопка отправки сообщения
    postMessageButton: null,

    flex: 1,

    layout: {
        type: 'vbox',
        pack: 'start',
        align: 'stretch'
    },

    items: [],

    fbar: [
        {
            xtype: 'panel',
            cls: 'postMessageForm',
            width: '100%',
            minHeight: 48,
            border: false,
            items: [
                {
                    xtype: 'textareafield',
                    name: 'messageField',
                    reference: 'messageField',
                    cls: 'messageField',
                    maxLength: 1000,
                    grow: true,
                    growMin: 32,
                    growMax: 120,
                    anchor: '100%',
                    height: '100%',
                    emptyText: 'Введите ваш вопрос здесь',
                    enableKeyEvents: true,
                    listeners: {
                        keypress(textareafield, eventObject){
                            let component = this.up('displayChatSendMessageContainer');
                            component.parentView.messageFieldKeypress(component, textareafield, eventObject);
                        },
                        change(){
                            let component = this.up('displayChatSendMessageContainer');
                            component.parentView.messageFieldKeypressChange(component);
                        },
                        afterrender() {
                            let component = this.up('displayChatSendMessageContainer');
                            component.parentView.setTooltip(this, 'Введите ваш вопрос, максимум символов' +
                                    ': ' +
                                    this.maxLength)
                        }
                    }
                },
                {
                    xtype: 'button',
                    reference: 'postMessageButton',
                    cls: 'postMessageButton',
                    focusCls: 'chatBotButtonFocus',
                    name: 'postMessageButton',
                    tooltip: 'Отправить сообщение',
                    handler() {
                        let component = this.up('displayChatSendMessageContainer');
                        component.parentView.postMessageButtonHandler(component);
                    }
                }
            ]
        }
    ],

    listeners: {
        afterrender() {
            const component = this;

            component.getEl().on(
                'click',
                function (event, domElement) {
                    component.toggleChatListArea();
                },
                null,
                { delegate: '.displayChatSendMessageContainer-buttonBack' }
            );

            component.getEl().on(
                'click',
                function (event, domElement) {
                    component.changeChatBotDataBase();
                },
                null,
                { delegate: '.chatBot-closeButton' }
            );

            new Ext.tip.ToolTip({
                target: component,
                delegate: [
                    '.displayChatSendMessageContainer-buttonBack',
                    '.displayChatSendMessageContainer-chatName',
                    '.displayChatSendMessageContainer-chatBotName',
                    '.chatBot-closeButton'
                ],
                listeners: {
                    beforeshow(tip) {
                        const current = tip.currentTarget.dom;
                        tip.setHtml(current.innerHTML);
                    }
                }
            });
        },

        beforeshow() {
            const chatStore = this.mainComponent.chatStore;
            const chatName = chatStore?.getById(this.mainComponent.chatModelId)
                ?.data?.Name;

            if (chatName) {
                this.toggleShowTitle(true);
            }
        }
    },

    initComponent() {
        const component = this;
        let view = component.parentView;

        component
            .addDisplayChat({ 
                displayChatSendMessageContainer: component,
                parentView: view
            })
            .then((res) => {
                component.displayChat = component.add(res);
                const scrollBottomBtn = view.createScrollBottomBtn(component);
                // Функция scrollEventListener к body компонента  работает только после рендера
                component.mainComponent.scrollBottomBtn = scrollBottomBtn;
                component.add(scrollBottomBtn);
                view.scrollEventListener(
                    component.displayChat,
                    component.mainComponent,
                    scrollBottomBtn
                );
            });

        Ext.panel.Panel.prototype.initComponent.call(this);

        component.messageField = component.lookupReference('messageField');
        component.postMessageButton = component.lookupReference('postMessageButton');
    },

    async addDisplayChat(config) {
        return await new Promise((resolve) => {
            setTimeout(() => resolve(new Svod.displayChat.DisplayChat({ ...config })), 0);
        });
    },

    toggleChatListArea() {
        const chatListArea = this.mainComponent.chatListArea;

        this.parentView.toggleView(chatListArea, this);
    },

    toggleShowTitle(toggle) {
        const chatStore = this.mainComponent.chatStore;
        const chatModelId = this.mainComponent.chatModelId;
        const chatModel = chatStore?.getById(chatModelId)?.data;
        const isMultipleChatbotDataBase =
            this.mainComponent.chatBotInfo.length > 1;

        if (toggle && chatModel) {
            this.getEl().dom.querySelector(
                '.displayChatSendMessageContainer-chatName'
            ).innerHTML = chatModel?.Name;
            this.getEl().dom.querySelector(
                '.displayChatSendMessageContainer-chatBotName'
            ).innerHTML = chatModel?.ChatBotName;
            this.getEl().dom.querySelector('.chatBot-closeButton').hidden = !(
                isMultipleChatbotDataBase && chatModel?.ChatBotName
            );
        } else {
            this.getEl().dom.querySelector(
                '.displayChatSendMessageContainer-chatName'
            ).innerHTML = '';
            this.getEl().dom.querySelector(
                '.displayChatSendMessageContainer-chatBotName'
            ).innerHTML = '';

            if (isMultipleChatbotDataBase) {
                this.getEl().dom.querySelector('.chatBot-closeButton').hidden =
                    true;
            }
        }
    },

    changeChatBotDataBase() {
        let view = this.parentView;
        view.hideScrollBottomBtn(
            this.mainComponent?.scrollBottomBtn
        );
        const name = this.mainComponent.chatStore.getById(
            this.mainComponent.chatModelId
        ).data.Name;
        const query =
            this.mainComponent.chatMessageStore.data.items[
                this.mainComponent.chatMessageStore.data.items.length - 1
            ].data.Query;
        view.addNotChosedChat(
            name,
            this.mainComponent,
            this.mainComponent.chatMessageStore,
            null,
            this.mainComponent.maxChatCount
        );
        view.toggleShowTitle(true);
        view.sendMessage(query, this.mainComponent);
    }
});
