// var KS = KS || {};
// KS.HttpModule = KS.HttpModule || {};
// KS.HttpModule.Npx = 
function lavandaNpx(lavandaCall) {
    var _call = function (p) {
        p.command = "npx/v1/" + p.command;
        p.contentType = "application/json; charset=utf-8";
        p.data = JSON.stringify(p.data);

        var onSuccess = p.onSuccess;
        if (onSuccess) {
            p.onSuccess = function (value) {
                var rv;
                try {
                    rv = JSON.parse(value);
                    if (rv[0].error) {
                        p.onError(rv[0].error);
                        return;
                    }
                    try {
                        rv = JSON.parse(rv[0].value);
                    } catch (e) {
                        rv = rv[0].value;
                    }
                } catch (e) {
                    rv = value;
                }
                onSuccess(rv);
            };
        }

        lavandaCall(p);
    };

    return {

        DeleteArchive: function (p) {
            _call({
                command: "deletearchive",
                data: [{}],
                timeout: (typeof p.timeout === "number") ? p.timeout : 1000,
                onProgress: (typeof p.onProgress === "function") ? function (response, progressevent) {
                    p.onProgress(response, progressevent);
                } : null,
                onSuccess: (typeof p.onSuccess === "function") ? function (value) {
                    p.onSuccess(value);
                } : null,
                onError: (typeof p.onError === "function") ? function (msg) {
                    p.onError(msg);
                } : null
            });
        },

        SelectCertificates: function (p) {
            // в onSuccess сделать проверку на структуру данных, вдруг там не массив сертификатов
            _call({
                command: "selectcertificate",
                data: [{
                    id: "1",
                    name: (p.keyId) ? p.keyId : null,
                    params: (p.params) ? p.params : null
                }],
                timeout: (typeof p.timeout === "number") ? p.timeout : 3000,
                onProgress: (typeof p.onProgress === "function") ? function (response, progressevent) {
                    p.onProgress(response, progressevent);
                } : null,
                onSuccess: (typeof p.onSuccess === "function") ? function (value) {
                    p.onSuccess(value);
                } : null,
                onError: (typeof p.onError === "function") ? function (msg) {
                    p.onError(msg);
                } : null
            });
        },

        Sign: function (p) {
            // в onSuccess сделать проверку на структуру данных, вдруг там не массив сертификатов
            _call({
                command: "sign",
                data: [{
                    id: "1",
                    text: (typeof p.text === "string") ? p.text : null,
                    cert: (typeof p.name === "string") ? p.name : null,
                    params: (typeof p.params === "number") ? String(p.params) : null,
                    strparams: (typeof p.strParams === "string") ? p.strParams : null
                }],
                timeout: (typeof p.timeout === "number") ? p.timeout : 600000,
                onProgress: (typeof p.onProgress === "function") ? function (response, progressevent) {
                    p.onProgress(response, progressevent);
                } : null,
                onSuccess: (typeof p.onSuccess === "function") ? function (value) {
                    p.onSuccess(value);
                } : null,
                onError: (typeof p.onError === "function") ? function (msg) {
                    p.onError(msg);
                } : null
            });
        },

        SignBinary: function (p) {
            var formData = new FormData();
            formData.append("data", p.blob);
            formData.append("cert", p.name);
            formData.append("params", String(p.params));

            _call({
                command: "signbinary",
                contentType: "multipart/form-data",
                data: formData,
                timeout: (typeof p.timeout === "number") ? p.timeout : 600000,
                onProgress: (typeof p.onProgress === "function") ? function (response, progressevent) {
                    p.onProgress(response, progressevent);
                } : null,
                onSuccess: (typeof p.onSuccess === "function") ? function (value) {
                    p.onSuccess(value);
                } : null,
                onError: (typeof p.onError === "function") ? function (msg) {
                    p.onError(msg);
                } : null
            });
        },

        SignArray: function (p) {
            var data = p.data.map(function (p2) {
                return {
                    id: (typeof p2.id === "number") ? String(p2.id) : null,
                    text: (typeof p2.text === "string") ? p2.text : null,
                    cert: (typeof p.name === "string") ? p.name : null,
                    params: (typeof p.params === "number") ? String(p.params) : null,
                    strparams: (typeof p.strParams === "string") ? p.strParams : null
                };
            });

            _call({
                command: "sign",
                data: data,
                timeout: (typeof p.timeout === "number") ? p.timeout : 600000,
                onProgress: (typeof p.onProgress === "function") ? function (response, progressevent) {
                    p.onProgress(response, progressevent);
                } : null,
                onSuccess: (typeof p.onSuccess === "function") ? function (value) {
                    alert("call k необходимо сделать метод _call для множественного ответа");
                    // необходимо сделать метод _call для множественного ответа
                    p.onSuccess(value);
                } : null,
                onError: (typeof p.onError === "function") ? function (msg) {
                    p.onError(msg);
                } : null
            });
        },

        Hash: function (p /*text, name, params, onProgress, onSuccess, onError*/) {
            // в onSuccess сделать проверку на структуру данных, вдруг там не массив сертификатов
            _call({
                command: "hash",
                data: [{
                    id: "1",
                    text: (typeof p.text === "string") ? p.text : null,
                    cert: (typeof p.name === "string") ? p.name : null,
                    params: (typeof p.params === "number") ? String(p.params) : null
                }],
                timeout: (typeof p.timeout === "number") ? p.timeout : 3000,
                onProgress: (typeof p.onProgress === "function") ? function (response, progressevent) {
                    p.onProgress(response, progressevent);
                } : null,
                onSuccess: (typeof p.onSuccess === "function") ? function (value) {
                    p.onSuccess(value);
                } : null,
                onError: (typeof p.onError === "function") ? function (msg) {
                    p.onError(msg);
                } : null
            });
        }

        //// deprecated
        //DownloadFile: function (p) {
        //    // в onSuccess сделать проверку на структуру данных, вдруг там не массив сертификатов
        //    _call({
        //        command: "downloadfile",
        //        data: [{
        //            id: "1",
        //            url: (typeof p.url === "string") ? p.url : null
        //        }],
        //        timeout: (typeof p.timeout === "number") ? p.timeout : 300000,
        //        onProgress: (typeof p.onProgress === "function") ? function (response, progressevent) {
        //            p.onProgress(response, progressevent);
        //        } : null,
        //        onSuccess: (typeof p.onSuccess === "function") ? function (value) {
        //            p.onSuccess(value[0].value);
        //        } : null,
        //        onError: (typeof p.onError === "function") ? function (msg) {
        //            p.onError(msg);
        //        } : null
        //    });
        //},

        //// deprecated
        //SignFileWeb: function (p /*path, name, params, strParams, onProgress, onSuccess, onError*/) {
        //    // в onSuccess сделать проверку на структуру данных, вдруг там не массив сертификатов
        //    _call({
        //        command: "signfileweb",
        //        data: [{
        //            id: "1",
        //            path: (typeof p.path === "string") ? p.path : null,
        //            cert: (typeof p.name === "string") ? p.name : null,
        //            params: (typeof p.params === "number") ? String(p.params) : null,
        //            strparams: (typeof p.strParams === "string") ? p.strParams : null
        //        }],
        //        timeout: (typeof p.timeout === "number") ? p.timeout : 600000,
        //        onProgress: (typeof p.onProgress === "function") ? function (response, progressevent) {
        //            p.onProgress(response, progressevent);
        //        } : null,
        //        onSuccess: (typeof p.onSuccess === "function") ? function (value) {
        //            p.onSuccess(value[0].value);
        //        } : null,
        //        onError: (typeof p.onError === "function") ? function (msg) {
        //            p.onError(msg);
        //        } : null
        //    });
        //}
    };
};