﻿UserWorkingSheduleView = KS.extend(BaseTreeView, {});

// ============= COMMON =======================
(function(viewClass) {
    KS.apply(viewClass,
        {
            onTemplateRendered: function() {
                this.discardChanges();
                this.mainGrid.gridLoaded = true;
                this.baseTree.selectFirstNode();
            },

            onSetSavedState: function(saved) {
                this.getToolbarItem(this.rootPanel, null, 'SAVE').setDisabled(saved);
            },

            //После обновления
            resetView: function() {
                var selNode = this.baseTree.getSelNode();
                if (selNode)
                    this.setTreeFilter(this.baseTree.getSelNode());
            },

            getTbarClickHandler: function(tbarItem) {
                var sc = UserWorkingSheduleView.superclass;
                switch (tbarItem.code) {
                    case "NEW":
                        return null;

                    case "ADD_USER":
                        return this.addUserInGroup;

                    case "ADD_GROUP":
                        return this.addGroupInGroup;                    
                    
                    case "DELETE":
                        return this.deleteInGroup;

                    case "NEW_NODE":
                        return this.createNewNode;                    
                    
                    case "EDIT":
                        return this.editNode;                    
                    
                    case "DELETE_NODE":
                        return this.deleteNode;

                    case "MARK":
                        return this.invertTreeNode; 

                    case "MARK_CHILD":
                    case "MARK_CHILD2":
                    case "MARK_DIRECT_CHILDREN":
                        return this.checkTreeNode;

                    case "UNMARK":
                        return this.uncheckTreeNode;

                default:
                    return sc.getTbarClickHandler.apply(this, arguments);
                }
            },

            onValuesSelected: function(arg) {
                if (arg[0][0]) {
                    this.setTreeFilter(this.baseTree.getSelNode());
                    this.touch();
                }
            }
        });
}(UserWorkingSheduleView.prototype));

// ============= GRID =======================
(function(viewClass) {
    KS.apply(viewClass,
        {
            addUserInGroup: function() {
                var view = this.parentView;
                var selNode = view.baseTree.getSelNode();
                if (selNode) {
                    var groupLink = selNode.id;
                    if (groupLink !== 0) {
                        view.serverCall({
                            method: 'AddUserInGroup',
                            params: [groupLink]
                        });
                    }
                }
            },            
            
            addGroupInGroup: function() {
                var view = this.parentView;
                var selNode = view.baseTree.getSelNode();
                if (selNode) {
                    var groupLink = selNode.id;
                    if (groupLink !== 0) {
                        view.serverCall({
                            method: 'AddGroupInGroup',
                            params: [groupLink]
                        });
                    }
                }
            },

            deleteInGroup: function() {
                var view = this.parentView || this;
                var checkedRows = view.mainGrid.getCheckedRows();
                var checkedUsers = [];
                Ext.each(checkedRows, function(record) {
                    checkedUsers.push(view.mainGrid.getAnyCase(record, "LINK_USER"));
                });
                var selNode = view.baseTree.getSelNode();
                if (selNode) {
                    var groupLink = selNode.id;
                    if (groupLink !== 0) {
                        view.serverCall({
                            method: 'DeleteUsersFromGroup',
                            params: [groupLink, checkedUsers],
                            success: function() {
                                view.setTreeFilter(selNode);
                                this.touch();
                            }
                        });
                    }
                }
            }
        });
}(UserWorkingSheduleView.prototype));

// ============= TREE =======================
(function(viewClass) {
    KS.apply(viewClass,
        {
            createNewNode: function() {
                var view = this.parentView;
                view.getNodeData("NEW", 0);
            },

            getNodeData: function(mode, selNodeId) {
                var view = this;
                view.serverCall({
                    method: 'GetNodeGridData',
                    waitMessage: 'Открывается ...',
                    params: [mode, selNodeId],
                    success: function(settings) {
                        view.showCreateNewNode(settings, mode === "EDIT", selNodeId);
                    }
                });
            },

            showCreateNewNode: function(settings, isEdit, selNodeId) {
                this.descriptionGrid = this.getPropertyGridByOption(settings[0], "descriptionGrid", "Описание");
                this.daysGrid = this.getPropertyGridByOption(settings[1], "daysGrid", "Дни недели");
                var view = this;
                this.nodePanelWin =  KS.showModal([this.descriptionGrid, this.daysGrid], {
                    title: 'Свойства',
                    autoHeight: false,    
                    layout: "anchor",
                    height: 500, 
                    minHeight: 200,
                    width: 600,
                    minWidth: 300,
                    buttonAlign: 'left',
                    buttons: new Array('->', {
                            text: 'ОК',
                            cls: 'dim-button',
                            handler: function () {
                                view.doCreateNewNode(isEdit, selNodeId);
                            }
                        }, { xtype: 'tbspacer', width: 8 },
                        {
                            text: 'Отмена',
                            cls: 'dim-button',
                            handler: function() {
                                view.nodePanelWin.close();
                            }
                        })
                }, true);
            },
            
            doCreateNewNode: function(isEdit, selNodeId) {
                var view = this;
                var newValues = [];
                newValues.push(this.descriptionGrid.source);
                newValues.push(this.daysGrid.source);
                view.serverCall({
                    method: 'EditNode',
                    params: [newValues, isEdit, selNodeId],
                    waitMessage: isEdit ? 'Редактрование ...' : 'Создание ...',
                    success: function(result) {
                        if (result === true) {
                            this.baseTree.getRootNode().removeAll(true);
                            this.baseTree.fullReload();
                            view.nodePanelWin.close();
                            view.touch();
                        }
                    }
                });
            },
            
            editNode: function() {
                var view = this.parentView;
                var selNode = view.baseTree.getSelNode();
                if (selNode) {
                    view.getNodeData("EDIT", selNode.id);
                }
            },

            deleteNode: function() {
                var view = this.parentView;
                var selNode = view.baseTree.getSelNode();
                if (selNode) {
                    if (selNode.id === "0") return;
                    KS.confirm("Удалить выделенную группу?", "Подтвердите удаление", function (btn) {
                        if (btn === 'yes')
                            view.serverCall({
                                method: 'DeleteNode',
                                params: [selNode.id],
                                success: function() {
                                    view.baseTree.getRootNode().removeAll(true);
                                    view.baseTree.fullReload();
                                    view.touch();
                                }
                            });
                    });
                }
            }
        });
}(UserWorkingSheduleView.prototype));

if (typeof(Sys) !== 'undefined') Sys.Application.notifyScriptLoaded();