﻿ReportOutputFormView = KS.extend(BaseSvodView, {
    constructor: function(viewId) {
        ReportOutputFormView.superclass.constructor.call(this, viewId);
    },

    renderGrid: function(data) {
        var view = this;
        view.data = data;
	    if (view.data.resultUrl) {
	        window.open(view.data.resultUrl, '_blank', 'height=580, width=840, resizable=yes, menubar=yes, location=no,status=yes, scrollbars=yes');
	        view.close();
	    } else {
	        view.gridWrapper.removeAll(true);
            if (data.mainGrid) {
                data.mainGrid.parentView = view;
                view.mainGrid = KS.create(data.mainGrid);
                view.gridWrapper.add(view.mainGrid);
            }
            KS.updateLayout(view.gridWrapper);
		}
    },

    next: function() {
        var view = this.parentView || this,
            checkedRowIdxs = [],
            recs = view.mainGrid.getCheckedRows();
        if (Ext.isEmpty(recs)) return;
        Ext.each(recs, function(rec) {
            checkedRowIdxs.push(view.mainGrid.store.indexOf(rec));
        });
        view.serverCall({
            method: 'Next',
            params: [checkedRowIdxs],
            success: view.renderGrid
        });
    }
});

if (typeof (Sys) !== 'undefined') Sys.Application.notifyScriptLoaded();