﻿// ============= VIEW =======================
UniDictItemView = KS.extend(BaseSvodView, {
    constructor: function (viewId) {
        UniDictItemView.superclass.constructor.call(this, viewId);
    },

    customName: 'UniDictItemView',
    defaultSelectRowsColumnIndex: 3,
    defaultSelectRowsHistoryColumnIndex: 5
});

// ============= BASE =======================
(function (viewClass) {
    var sc = UniDictItemView.superclass;

    KS.apply(viewClass, {
        onTemplateRendered: function () {
            this.accessCachedValues = [];
            if (this.data.identifier.IsNewOutcome){
                this.touch();
            } else {
                this.discardChanges();
            }
        },

        getTbarClickHandler: function(tbarItem) {
            switch (tbarItem.code) {
                case "CALCULATE_MENU":
                case "HIERARCHY_ADDITIONAL":
                case "SETTINGS":
                    return null;
                    
                case "OPEN":
                    return this.openDictionatyHierarchy;
            }
            return sc.getTbarClickHandler.call(this, tbarItem);
        },

        processToolbarItemControl: function(ctrl, tbarItem, schema) {
            if (tbarItem.nodeStyle === 4 &&
                tbarItem.additional &&
                tbarItem.additional.DATETIMEEDITOR_VALUE === 'DATETIMEEDITOR') {
                ctrl = new Ext.form.FieldContainer({
                    layout: 'hbox',
                    itemId: 'uniDictDateContainer',
                    items: [
                        {
                            xtype: 'button',
                            tooltip: 'Очистить',
                            height: '24px',
                            iconCls: 'ks-icon-clean',
                            parentView: this,
                            handler: this.clearUniDictDate
                        },
                        {
                            xtype: 'datefield',
                            itemId: 'uniDictDate',
                            format: 'd.m.Y',
                            value: this.data.uniDictDate ? KS.parseAjaxDateTime(this.data.uniDictDate) : new Date(),
                            listeners:{
                                change:{
                                    fn: this.setUniDictDate,
                                    scope: this
                                }
                            }
                        }]
                });
                return ctrl;
            }

            if (tbarItem.nodeStyle === 12) {
                switch (tbarItem.code) {
                    case "SHOW_DISABLE_ROWS":
                        ctrl.on("change", this.showDisableRowsCheck, this);
                        break;
                    case "SHOW_DISABLE_ROWS_History":
                        ctrl.on("change", this.showDisableHistoryRowsCheck, this);
                        break;
                    case "SHOW_OVERRIDE":
                        ctrl.on("change", this.setShowOverrideRows, this);
                        break;
                }
            }

            return sc.processToolbarItemControl.apply(this, arguments);
        },

        rootTabChange: function(tabPanel, newCard) {
            if (!newCard.tabLoaded){
                switch (newCard.ctrlId){
                    case "generalTab":
                        this.loadGeneralTab();
                        break;
                        
                    case "hierarchyRowsTab":
                        this.hierarchyRowsGrid.reload();
                        break;
                        
                    case "accessTab":
                        this.loadUniDictRights();
                        break;
                        
                    case "dictionHierarchyTab":
                        this.dictionHierarchyGrid.reload();
                        break;
                }
                newCard.tabLoaded = true;
            }        
        },

        beforeSaveChanges: function(){
            this.saveAccessCachedValues(true);
        },

        saveChanges: function () {
            var view = this.parentView || this;
            view.beforeSaveChanges();
            view.serverCall({
                method: 'SaveChangesUniDict',
                params: [view.columnsHasChanges ? true : false],
                waitMessage: 'Сохранение ...',
                success: function (gridChanges) {
                    if (gridChanges['hasSaveErrors'] === true) {
                        return;
                    }
                    if (view.columnsHasChanges) {
                        view.reconfigureRowsGrid(gridChanges["rowsGrid"], "rowsGrid");
                        view.reconfigureRowsGrid(gridChanges["rowsHistoryGrid"], "rowsHistoryGrid");
                        view.columnsHasChanges = false;
                    }
                    view.discardChanges();
                    view.reload();
                }
            });
        },

        reconfigureRowsGrid: function (gridColumns, gridKey) {
            var view = this;
            if (!view[gridKey])
                return;
            Ext.each(gridColumns, function (col) {
                var existingColumn = Ext.Array.findBy(view[gridKey].columnManager.columns, function(column) {
                    return column.key === col.key;
                });
                if (existingColumn != null) {
                    col.align = existingColumn.align;
                    col.aspType = existingColumn.aspType;
                    col.doUpdateHeaderState = existingColumn.doUpdateHeaderState;
                    col.editable = existingColumn.editable;
                    col.hidden = existingColumn.hidden;
                    col.hideable = existingColumn.hideable;
                    col.renderer = existingColumn.renderer;
                    col.textAlign = existingColumn.textAlign;
                    col.tooltip = existingColumn.tooltip;
                    col.updateHeaderState = existingColumn.updateHeaderState;
                    col.xtype = existingColumn.xtype;
                }
                else {
                    col.hidden = !col.visibility;
                    col.renderer = window[col.renderer];
                }
                view[gridKey].resolveEditor(col, view[gridKey]);
            });
            view[gridKey].reconfigure(gridColumns);
            view[gridKey].doUpdateHeaderState = gridColumns[0].doUpdateHeaderState;
            view[gridKey].updateHeaderState = gridColumns[0].updateHeaderState;
        },

        onSetSavedState: function (savedState) {
            var saveBtn = this.getToolbarItem(this.rootPanel, null, 'SAVE');
            if (saveBtn)
                saveBtn.setDisabled(savedState);
        },

        doReload: function () {
            var view = this;
            var activeNodeId = view.budgetTree.getSelNodeId() || "";
            view.serverCall({
                method: 'ReloadUniDictItem',
                params: [view.getBudgetContext(), activeNodeId],
                waitMessage: 'Обновление ...',
                success: function() {
                    if (!Ext.isEmpty(activeNodeId))
                        view.selectedBudgetTreeNodeId = activeNodeId;
                    view.reloadCallback();
                }
            });
        },

        resetView: function () {
            this.containerPanel.setTitle(this.data.dictionCaption);                
            
            // Переключаемся на вкладку "Строки" и обновляем её
            this.reloadRowsTab();

            // Обновить вкладку "Общие" при открытии
            this.generalTab.tabLoaded = false;
            
            // Обновить вкладку "Иерархия строк" при открытии
            this.hierarchyRowsTab.tabLoaded = false;
            
            // Обновить данные на вкладке "Колонки"
            this.reloadColumnsTree();
            
            // Обновить вкладку "Доступ" при открытии
            this.accessTab.tabLoaded = false;            
            this.accessCachedValues = [];
        },

        onServerSaveDoubleCodes: function(protocol, errorMessage){
            var view = this;
            view.warningProtocolWin = KS.Ext.showAdjustableWindow(protocol, {
                title : 'Протокол',
                listeners: {
                    close: function() {
                        view.confirmSaveDoubleCodes(errorMessage);
                    }
                },
                buttons: ['->', {
                    text: 'ОК',
                    cls: 'dim-button',
                    handler: function () {
                        view.warningProtocolWin.close();
                    }
                }]
            });
        },

        confirmSaveDoubleCodes: function(errorMessage){
            var view = this;
            KS.confirm(errorMessage + "<br> Продолжить сохранение?" , "Внимание", function(btn) {
                if (btn === 'yes') {
                    view.saveWithDoubleCodes();
                } else {
                    KS.alert("Сохранение отменено");
                }
            });
        },
        
        saveWithDoubleCodes: function(){
            var view = this;
            view.serverCall({
                method: 'SaveWithDoubleCodes',
                waitMessage: 'Сохранение ...',
                success: function (hasSaveErrors) {
                    if (hasSaveErrors === true) {
                        KS.alert('Документ не сохранен!');
                        return;
                    }
                    view.discardChanges();
                    view.reload();
                }
            });
        }
    });
}(UniDictItemView.prototype));

// ============= OVERALL TOOLBAR =======================
(function (viewClass) {
    KS.apply(viewClass, {
        viewModeComboChange: function(comp, newValue){
            this.serverCall({
                method: 'ViewModeComboChange',
                params: [newValue],
                disableFog: true,
                success: this.setRootTabVisible
            });
        },
        
        setRootTabVisible: function(options){
            this.columnsTab.tab.setVisible(options["COLUMNS"]);
            this.hierarchyRowsTab.tab.setVisible(options["ROWS_HIERARCHY"]);
            this.accessTab.tab.setVisible(options["RIGHTS"]);
            this.dictionHierarchyTab.tab.setVisible(options["DICTION_HIERARCHY"]);

            this.data.settings.ViewMode = options["VIEW_MODE"];
            
            var activeTab = this.rootTabPanel.getActiveTab();
            if (activeTab && !activeTab.tab.isVisible()){
                this.rootTabPanel.setActiveTab(2);
            }
        },

        getCheckedLinks: function (store, closeCode) {
            var recs = this.getCheckedRecords(store, false),
                links = [];
            Ext.each(recs, function (rec) {
                links.push(KS.Grid.getAnyCase(rec, closeCode));
            });
            return links;
        },

        getGridExcelAdditionals: function(grid) {
            var ccc = '';
            var links = this.getCheckedLinks(grid.store, grid.closeCode);
            Ext.each(links,
                function(cc) {
                    ccc += "'" + cc + "',";
                });
            return {
                'checkedCodes': ccc
            }
        },
        
        onExport: function() {
            var view = this.parentView || this;
            var checkedCodes = view.getCheckedLinks(view.rowsGrid.getStore(), view.rowsGrid.closeCode);
            view.serverCall({
                method: 'OnExport',
                params: [checkedCodes]
            });
        },

        syncDict: function(tbarItem) {
            var view = this.parentView,
                code = tbarItem.tbarNode.code,
                isSaveBtnEnable = !view.getToolbarItem(view.rootPanel, null, 'SAVE').disabled;

            view.serverCall({
                method: 'OnOpenSyncOptions',
                params: [code, isSaveBtnEnable]
            });
        },

        afterCloseSyncOptions: function() {
            this.serverCall({
                method: 'AfterCloseSyncOptions'
            });
        }
    });
}(UniDictItemView.prototype));

// ============= ROWS TOOLBAR =======================
(function (viewClass) {
    KS.apply(viewClass, {
        isHistoryGridBtn: function (element) {
            return (element.tbarNode.code.split('_')[1] === "History");
        },

        addRow: function () {
            var view = this.parentView,
                dictionLink = KS.getFakeLink(),
                dictionLinkHistory = KS.getFakeLink(),
                isHistory = view.isHistoryGridBtn(this);

            if (isHistory) {
                if (view.activeRow) {
                    dictionLink = KS.Grid.getAnyCase(view.activeRow, 'LINK_DICTION_ROW');
                } else {
                    KS.msg('Не выбрана строка');
                    return;
                }
            }
            view.serverCall({
                method: isHistory ? 'AddDictionRowHistory' : 'AddDictionRow',
                params: [dictionLink, dictionLinkHistory, view.getBudgetContext()],
                waitMessage: 'Создание строки ...',
                success: function (rowDict) {
                    view.newRowCallback(rowDict, isHistory);
                }
            });
        },

        copyRow: function () {
            var view = this.parentView;
            if (!view.activeRow) return;
            var isHistory = view.isHistoryGridBtn(this),
                srcDictionLink = KS.Grid.getAnyCase(view.activeRow, 'LINK_DICTION_ROW'),
                params = [srcDictionLink];
            if (isHistory) {
                var sh = view.getSelectedRowHistory();
                if (Ext.isEmpty(sh)) return;
                params.push( KS.Grid.getAnyCase(sh[0], 'LINK_DICTION_ROW_HISTORY'));
            }
            view.serverCall({
                method: isHistory ? 'CopyDictionRowHistory' : 'CopyDictionRow',
                params: params.concat([KS.getFakeLink(), view.getBudgetContext()]),
                waitMessage: 'Копирование строки ...',
                success: function (rowDict) {
                    view.newRowCallback(rowDict, isHistory);
                }
            });
        },

        newRowCallback: function (rowDict, isHistory) {
            var grid = (isHistory) ? this.rowsHistoryGrid : this.rowsGrid;
            rowDict['DATE'] = eval(rowDict['DATE'].replaceAll('/', ''));
            rowDict['END_DATE'] = eval(rowDict['END_DATE'].replaceAll('/', ''));
            grid.addRecord(rowDict);
            this.touch();
            var rowIdx = grid.store.getCount() - 1,
                startEditColIdx = (isHistory)
                    ? this.defaultSelectRowsHistoryColumnIndex
                    : this.defaultSelectRowsColumnIndex;
            this.selectRowsCell(rowIdx, startEditColIdx, isHistory);
        },

        deleteRows: function () {
            var view = this.parentView,
                isHistory = view.isHistoryGridBtn(this),
                store = (isHistory ? view.rowsHistoryGrid : view.rowsGrid)['store'],
                recs2Del = view.getCheckedRecords(store, true),
                rowLink = 0,
                links = [];
            if (Ext.isEmpty(recs2Del)) return;
            Ext.each(recs2Del, function(rec) {
                if (isHistory) {
                    rowLink = KS.Grid.getAnyCase(rec, 'LINK_DICTION_ROW');
                    links.push(KS.Grid.getAnyCase(rec, 'LINK_DICTION_ROW_HISTORY'));
                } else {
                    links.push(KS.Grid.getAnyCase(rec, 'LINK_DICTION_ROW'));
                }
            });
            if (!isHistory && view.rowsGrid.clickedRowIndex !== undefined &&
                store.data.items[view.rowsGrid.clickedRowIndex].data['CHECKED'])
                Ext.Array.insert(recs2Del, recs2Del.length, view.rowsHistoryGrid.store.data.items);
            KS.confirm("Удалить выделенные строки?", "Подтвердите удаление",
                function (btn) {
                    if (btn === 'yes') {
                        view.serverCall({
                            method: 'DeleteRows',
                            params: [rowLink, links, view.getBudgetContext()],
                            success: function () {
                                view.touch();
                                Ext.each(recs2Del, function (rec2Del) {
                                    rec2Del.store.remove(rec2Del);
                                });
                            }
                        });
                    }
                });
        },

        // Переопределение из BaseSvodView для CellModel, т.к. не работает если снимаются все галочки
        markInvertHandler: function () {
            var grid = this.parentView.findOwnerGrid(this) || this.parentView.getMarkableGrid();
            if (grid) {
                if (grid.getSelectionModel().isCellModel){
                    grid.store.each(function (rec) { grid.checkRecord(rec, !rec.get('CHECKED')); });
                } else {
                    grid.markInvert();
                }
            }
        },

        // Переопределение из BaseSvodView для CellModel, т.к. не работает если снимаются все галочки
        unmarkHandler: function() {
            var grid = this.parentView.findOwnerGrid(this) || this.parentView.getMarkableGrid();
            if (grid) {
                if (grid.getSelectionModel().isCellModel) {
                    grid.store.each(function (rec) { grid.checkRecord(rec, false); });
                } else {
                    grid.unmark();
                }
            }
        },

        setRowsAppearance: function(){
            var view = this.parentView || this,
                grid = view.rowsGrid,
                store = grid.getStore();

            var checkedRecs = view.getCheckedRecords(store, true);
            if (!Ext.isEmpty(checkedRecs) && !Ext.isEmpty(grid.getColConfigByKey('LINK_SETTING'))) {
                var mode = this.tbarNode.code;
                var rowsDict = [];
                Ext.each(checkedRecs, function(record){
                    rowsDict.push(KS.Grid.getAnyCase(record, 'LINK_DICTION_ROW'));
                });

                view.serverCall({
                    method: 'SetRowsAppearance',
                    params: [mode, rowsDict],
                    disableFog: true,
                    success: function(resultDict){
                        for (var linkDictionRow in resultDict) {
                            if (resultDict.hasOwnProperty(linkDictionRow) ) {
                                var record = grid.findRecord(linkDictionRow,'LINK_DICTION_ROW');
                                if (record){
                                    record.set('LINK_SETTING', resultDict[linkDictionRow])
                                }
                            }
                        }
                        view.rowsHistoryGrid.getView().refresh();
                        view.touch();
                    }
                });   
            }
        },

        upRow: function(){
            var view = this.parentView || this;
            view.moveRow(true);
        },

        downRow: function(){
            var view = this.parentView || this;
            view.moveRow(false);
        },

        moveRow: function(isUp) {
            var view = this;
            var grid = view.rowsGrid;
            var store = grid.getStore();
            var checkedRecs = view.getCheckedRecords(store, true);
            if (!Ext.isEmpty(checkedRecs) && !Ext.isEmpty(grid.getColConfigByKey('ORDER'))) {
                var columnIndex = view.defaultSelectRowsColumnIndex;
                if (grid.getSelectionModel().getPosition())
                    columnIndex = grid.getSelectionModel().getPosition().colIdx;

                var currentRow = checkedRecs[0];
                var rowIndex = store.indexOf(currentRow);
                var endIndex = store.getCount() -1;
                var needMove = isUp ?
                    rowIndex > 0 :
                    rowIndex < endIndex;

                if (needMove) {
                    var nextRowIndex = rowIndex + (isUp ? -1 : 1);
                    var nextRow = store.getAt(nextRowIndex);
                    var nextOrder = KS.Grid.getAnyCase(nextRow, 'ORDER');
                    var nextDictionRowLinkHistory = KS.Grid.getAnyCase(nextRow, 'LINK_DICTION_ROW_HISTORY');
                    var currentOrder = KS.Grid.getAnyCase(currentRow, 'ORDER')
                    var currentDictionRowLinkHistory = KS.Grid.getAnyCase(currentRow, 'LINK_DICTION_ROW_HISTORY');

                    var rowsDict = [
                        {
                            'LINK_DICTION_ROW_HISTORY' : currentDictionRowLinkHistory,
                            'ORDER' : nextOrder
                        },
                        {
                            'LINK_DICTION_ROW_HISTORY' : nextDictionRowLinkHistory,
                            'ORDER' : currentOrder
                        }
                    ]

                    var moveRowCallback = function () {
                        grid.getStore().remove(currentRow);
                        currentRow.set('ORDER', nextOrder);
                        grid.getStore().insert(nextRowIndex, currentRow);
                        nextRow.set('ORDER', currentOrder);

                        view.activeRow = null;
                        view.selectRowsCell(nextRowIndex, columnIndex);
                        view.touch();
                    }

                    view.setRowsOrder(rowsDict, moveRowCallback);
                }
            }
        },

        setDefaultRowsOrder: function() {
            var view = this.parentView || this;
            var grid = view.rowsGrid;
            if (!Ext.isEmpty(grid.getColConfigByKey('ORDER'))) {
                KS.confirm("Установить порядок в соответствии с отображением?", "Внимание", function(btn) {
                    if (btn === 'yes') {
                        var rowsDict = [];
                        grid.getStore().each(function(record, index){
                            rowsDict.push({
                                'LINK_DICTION_ROW_HISTORY' : KS.Grid.getAnyCase(record, 'LINK_DICTION_ROW_HISTORY'),
                                'ORDER': index
                            });
                        });

                        view.setRowsOrder(rowsDict, function() {
                            grid.getStore().each(function(record, index){
                                record.set('ORDER', index);
                            });
                            view.touch();
                        });
                    }
                });
            }
        },

        incOrderRows: function(){
            var view = this.parentView || this;
            view.changeOrderRows(true);
        },

        decOrderRows: function(){
            var view = this.parentView || this;
            view.changeOrderRows(false);
        },

        changeOrderRows: function(isInc){
            var view = this;
            var grid = view.rowsGrid;
            var store = grid.getStore();
            var checkedRecs = view.getCheckedRecords(store, true);
            if (!Ext.isEmpty(checkedRecs) && !Ext.isEmpty(grid.getColConfigByKey('ORDER'))) {
                var msg = (isInc ? "Увеличить" : "Уменьшить") + " порядок выбранных строк(" + checkedRecs.length + ") ?";
                KS.confirm(msg, "Внимание", function(btn) {
                    if (btn === 'yes') {
                        var rowsDict = [];
                        Ext.each(checkedRecs, function(record){
                            rowsDict.push({
                                'LINK_DICTION_ROW_HISTORY' : KS.Grid.getAnyCase(record, 'LINK_DICTION_ROW_HISTORY'),
                                'ORDER': +KS.Grid.getAnyCase(record, 'ORDER') + (isInc ? 1 : -1)
                            });
                        });

                        view.setRowsOrder(rowsDict, function() {
                            Ext.each(checkedRecs, function(record){
                                record.set('ORDER', +KS.Grid.getAnyCase(record, 'ORDER') + (isInc ? 1 : -1));
                            });
                            view.touch();
                        });
                    }
                });
            }
        },

        setRowsOrder: function(rowsDict, callBack){
            this.serverCall({
                method: 'SetRowsOrder',
                params: [rowsDict],
                success: callBack
            });
        },

        deleteAllHistory: function(){
            var view = this.parentView || this;
            view.rowsGroupOperation("Удалить все версии для выбранных строк", "CLEAR_HISTORY")
        },

        setMonoliteRows: function(){
            var view = this.parentView || this;
            view.rowsGroupOperation("Объединить коды выбранных строк", "SET_MONOLITE");
        },

        setCompositeRows: function(){
            var view = this.parentView || this;
            view.rowsGroupOperation("Перевести коды в составные для выбранных строк", "SET_COMPOSITE");
        },

        usingInReport: function(){
            var view = this.parentView || this;
            view.rowsGroupOperation(null, "USING_IN_REPORT");
        },

        rowsGroupOperation: function(msg, operationCode){
            var view = this;
            var grid = view.rowsGrid;
            var store = grid.getStore();
            var checkedRecs = view.getCheckedRecords(store, true);
            if (!Ext.isEmpty(checkedRecs)) {
                if (!Ext.isEmpty(msg)) {
                    KS.confirm(msg + "(" + checkedRecs.length + ") ?", "Внимание", function (btn) {
                        if (btn === 'yes') {
                            view.doRowsGroupOperation(checkedRecs, operationCode);
                        }
                    });
                } else {
                    view.doRowsGroupOperation(checkedRecs, operationCode);
                }
            }
        },

        doRowsGroupOperation: function(checkedRecs, operationCode){
            var view = this;
            var dictionRowLinks = [];
            Ext.each(checkedRecs, function(record){
                dictionRowLinks.push(KS.Grid.getAnyCase(record, 'LINK_DICTION_ROW'));
            });
            view.serverCall({
                method: 'RowsGroupOperation',
                params: [operationCode, dictionRowLinks],
                success: function() {
                    view.resetRows();
                    view.touch();
                }
            });
        },

        setDefaultsRowsView: function(){
            var view = this.parentView || this;
            KS.confirm("Установить внешний вид по умолчанию?", "Внимание", function(btn) {
                if (btn === 'yes') {
                    view.serverCall({
                        method: 'SetDefaultsRowsView',
                        success: function(newRowsGrid) {
                            if (newRowsGrid) {
                                var rowsGrid = view.rowsGrid;
                                var parentGridPanel = rowsGrid.ownerCt;
                                var gridIndex = parentGridPanel.items.items.indexOf(rowsGrid);
                                parentGridPanel.remove(rowsGrid);
                                view.rowsGrid = view.createTemplateControl(newRowsGrid);
                                parentGridPanel.insert(gridIndex, view.rowsGrid);

                                view.resetRows();
                            }
                        }
                    });
                }
            });
        },

        mergingRowsOfReport: function(){
            var view = this.parentView || this;
            var grid = view.rowsGrid;
            var store = grid.getStore();
            var checkedRecs = view.getCheckedRecords(store, true);
            if (!Ext.isEmpty(checkedRecs)) {
                var dictionRowLinks = [];
                Ext.each(checkedRecs, function(record){
                    dictionRowLinks.push(KS.Grid.getAnyCase(record, 'LINK_DICTION_ROW'));
                });
                view.serverCall({
                    method: 'GetMergingRowsGrid',
                    params: [dictionRowLinks, view.getBudgetContext()],
                    success: function(mergingRowsGrid) {
                        view.showMergingRowsGrid(mergingRowsGrid, dictionRowLinks);
                    }
                });
            }
        },

        showMergingRowsGrid: function(mergingRowsGrid, dictionRowLinks){
            var view = this;
            this.mergingRowsGrid = this.createTemplateControl(mergingRowsGrid);
            this.mergingRowsWin = KS.showModal(this.mergingRowsGrid,
                {
                    title: "Выберите значение...",
                    autoHeight: false,
                    layout: "fit",
                    minWidth: 400,
                    minHeight: 300,
                    width: Math.max(400, KS.rootViewport.getWidth() / 2),
                    height: Math.max(300, KS.rootViewport.getHeight() / 1.5),
                    buttonAlign: 'left',
                    buttons: ['->',
                        {
                            text: 'ОК',
                            cls: 'dim-button',
                            handler: function() {
                                view.doMergingRowsOfReport(dictionRowLinks);
                            }
                        },
                        { xtype: 'tbspacer', width: 8 },
                        {
                            text: 'Отмена',
                            cls: 'dim-button',
                            handler: function() {
                                view.mergingRowsWin.close();
                            }
                        }]
                }, true);
        },

        doMergingRowsOfReport: function(dictionRowLinks){
            var view = this;
            var checkedRows = view.mergingRowsGrid.getCheckedRows();
            if (!Ext.isEmpty(checkedRows)){
                var linkDictionRow = KS.Grid.getAnyCase(checkedRows[0], "LINK_DICTION_ROW");
                view.mergingRowsWin.mask('Пожалуйста, подождите...');
                view.serverCall({
                    method: 'MergingRowsOfReport',
                    params: [dictionRowLinks, linkDictionRow, view.getBudgetContext()],
                    success: function() {
                        view.mergingRowsWin.unmask();
                        view.mergingRowsWin.close();
                        // В презенторе запускается BeginReload
                        view.resetRows();
                    },
                    error: function(){
                        view.mergingRowsWin.unmask();
                    }
                });
            }
        },

        groupSetRows: function(){
            var view = this.parentView || this;
            var checkedRecs = view.getCheckedRecords(view.rowsGrid.getStore(), true);
            if (!Ext.isEmpty(checkedRecs)){
                view.serverCall({
                    method: 'GetGroupSetProperties',
                    success: view.showGroupSetProperties
                });
            }
        },

        showGroupSetProperties: function (listOptions) {
            if (!Ext.Object.isEmpty(listOptions)) {
                var view = this;
                view.groupSetPanel = Ext.create("Ext.panel.Panel", {
                    layout: 'anchor'
                })
                var i = 0;
                for (var prop in listOptions) {
                    if (listOptions.hasOwnProperty(prop)) {
                        var propertyGrid = view.getPropertyGridByOption(listOptions[prop], "groupSetProp_" + i++, prop);
                        propertyGrid.on("propertychange", view.touch, view);
                        view.groupSetPanel.add(propertyGrid);
                    }
                }

                view.groupSetWin = KS.showModal(view.groupSetPanel,
                    {
                        title: "Свойства",
                        autoHeight: false,
                        layout: "fit",
                        minWidth: 400,
                        minHeight: 300,
                        width: Math.max(400, KS.rootViewport.getWidth() / 2),
                        height: Math.max(300, KS.rootViewport.getHeight() / 1.5),
                        buttonAlign: 'left',
                        buttons: ['->',
                            {
                                text: 'ОК',
                                cls: 'dim-button',
                                handler: function() {
                                    view.setGroupSetProperties();
                                }
                            },
                            { xtype: 'tbspacer', width: 8 },
                            {
                                text: 'Отмена',
                                cls: 'dim-button',
                                handler: function() {
                                    view.groupSetWin.close();
                                }
                            }]
                    }, true);
            }
        },

        setGroupSetProperties: function(){
            var view = this;
            var checkedRecs = view.getCheckedRecords(view.rowsGrid.getStore(), true);
            var dictionRowHistoryLinks = [];
            Ext.each(checkedRecs, function(record){
                dictionRowHistoryLinks.push(KS.Grid.getAnyCase(record, 'LINK_DICTION_ROW_HISTORY'));
            });
            var properties = view.collectGroupSetProperties();

            view.groupSetWin.mask('Пожалуйста, подождите...');
            view.serverCall({
                method: 'SetGroupSetProperties',
                params: [dictionRowHistoryLinks, properties],
                success: function() {
                    Ext.each(checkedRecs, function(checkedRec){
                        for (var prop in properties) {
                            if (properties.hasOwnProperty(prop) && !Ext.isEmpty(view.rowsGrid.getColConfigByKey(prop))) {
                                checkedRec.set(prop, properties[prop]);
                            }
                        }
                    });

                    view.groupSetWin.unmask();
                    view.groupSetWin.close();
                    view.touch();
                },
                error: function(){
                    view.groupSetWin.unmask();
                }
            });
        },

        collectGroupSetProperties: function() {
            var properties = {};
            this.groupSetPanel.items.each(function(propertyGrid){
                var sourcePropGrid = propertyGrid.source;
                if (!Ext.Object.isEmpty(sourcePropGrid)) {
                    for (var prop in sourcePropGrid) {
                        if (sourcePropGrid.hasOwnProperty(prop) && !Ext.isEmpty(sourcePropGrid[prop])) {
                            var propKey = prop.split("#")[1];
                            properties[propKey] = sourcePropGrid[prop];
                        }
                    }
                }
            });
            return properties;
        },

        deleteOverride: function(){
            var view = this.parentView || this;
            var checkedRecs = view.getCheckedRecords(view.rowsGrid.getStore(), false);
            var dictionRowHistoryLinks = [];
            Ext.each(checkedRecs, function(record){
                dictionRowHistoryLinks.push(KS.Grid.getAnyCase(record, 'LINK_DICTION_ROW_HISTORY'));
            });
            var budgetContext = view.getBudgetContext();
            if (budgetContext.BudgetLink > 0 || budgetContext.OrganizationLink > 0) {
                var message = dictionRowHistoryLinks.length === 0
                    ? "Удалить все переопределенные значения для узла '" + budgetContext.Text + "'?"
                    : "Удалить переопределенные значения для узла '" + budgetContext.Text + "' для выбранных строк?";

                KS.confirm(message, "Внимание", function (btn) {
                    if (btn === 'yes') {
                        view.serverCall({
                            method: 'DeleteOverride',
                            params: [dictionRowHistoryLinks, budgetContext],
                            success: function() {
                                view.resetRows();
                                if (view.budgetTree.getSelNode())
                                    view.markBudgetTreeNode(view.budgetTree.getSelNode(), false);
                                view.touch();
                            }
                        });
                    }
                });
            }
        },

        deleteAllOverride: function(){
            var view = this.parentView || this;
            KS.confirm("Удалить все переопределенные значения?", "Внимание", function (btn) {
                if (btn === 'yes') {
                    var activeNodeId = view.budgetTree.getSelNodeId() || "";
                    view.serverCall({
                        method: 'DeleteAllOverride',
                        params: [view.getBudgetContext(), activeNodeId],
                        success: function() {
                            view.resetRows();
                            if (!Ext.isEmpty(activeNodeId))
                                view.selectedBudgetTreeNodeId = activeNodeId;
                            view.reloadBudgetTree();
                            view.touch();
                        }
                    });
                }
            });
        }
    });
}(UniDictItemView.prototype));

// ============= ROWS =======================
(function (viewClass) {
    KS.apply(viewClass, {
        gridGetRowClass: function(record) {
            var grid = this.grid;
            if (grid.itemId === "rowsHistoryGrid") {
                var linkDictionRow = KS.Grid.getAnyCase(record, "LINK_DICTION_ROW");
                record = grid.parentView.rowsGrid.findRecord(linkDictionRow,'LINK_DICTION_ROW');
            }

            var linkSetting = KS.Grid.getAnyCase(record, 'link_setting');
            if (linkSetting) {
                return "link-setting-" + linkSetting;
            }
            return "";
        },

        budgetTreeLoaded: function () {
            if (this.selectedBudgetTreeNodeId){
                this.budgetTree.setSelected(this.selectedBudgetTreeNodeId);
                this.scrollToActiveNode(this.budgetTree);
                this.selectedBudgetTreeNodeId = null;
            } else {
                this.budgetTree.selectFirstNode();
            }
        },

        reloadBudgetTree: function(){
            this.budgetTree.getRootNode().removeAll(true);
            this.budgetTree.fullReload();
        },

        reloadRowsTab: function(){
            this.rootTabPanel.setActiveTab(2);

            // Убираем фильтр, установленный в goToRow
            var filterFeature = this.rowsGrid.getView().getFeature("filter");
            if (filterFeature){
                var filters = filterFeature.filters;
                if (filters && filters["CODE"]) {
                    var column = this.rowsGrid.getColConfigByKey("CODE");
                    this.rowsGrid.removeGridFilter(column);
                }
            }

            this.resetRows();
            this.reloadBudgetTree();
        },

        rebuildRows: function () {
            this.serverCall({
                method: 'RebuildRows',
                params: [this.getBudgetContext()],
                waitMessage: 'Обновление ...',
                success: this.resetRows
            });
        },

        resetRows: function () {
            var grid = this.rowsGrid;
            if (grid.getSelectionModel().getPosition()) {
                this.rowsCridSelectedCell = {
                    colIdx : grid.getSelectionModel().getPosition().colIdx,
                    rowIdx : grid.getSelectionModel().getPosition().rowIdx
                }
            }
            grid.reload();
        },

        getBudgetContext: function () {
            var bl = 0,
                ol = 0,
                t = null,
                node = this.budgetTree.getSelNode();
            if (node) {
                var linksArr = node.id.split('_');
                bl = +linksArr[2];
                ol = +linksArr[1];
                t = node.text || node.data.text;
            }
            if (bl < 0) // Для узла "Нет фильтра"
                bl = 0;
            return {
                BudgetLink: bl,
                OrganizationLink: ol,
                Text: t
            }
        },

        getCheckedRecords: function (store, includeSelected) {
            var recs = [];
            store.each(function (rec) {
                if (KS.Grid.getAnyCase(rec, "CHECKED")) 
                    recs.push(rec);
            });
            if (Ext.isEmpty(recs) && includeSelected === true)
                recs = recs.concat(store.grid.getSelection());
            return recs;
        },

        clearUniDictDate: function () {
            var view = this.parentView || this;
            view.setUniDictDate(null, null);
        },

        setUniDictDate: function (df, d) {
            var view = this;
            view.serverCall({
                method: 'SetDate',
                params: [d ? d.getFullYear() : 0, d ? d.getMonth() + 1 : 0, d ? d.getDate() : 0, this.getBudgetContext()],
                waitMessage: 'Установка даты ...',
                success: function (data) {
                    view.setUniDictCmpValue(KS.parseAjaxDateTime(data.uniDictDate));
                    view.resetRows();
                }
            });
        },

        setUniDictCmpValue: function(newValue){
            var rowsToolbar = this.getToolbar(this.rowsGrid);
            if (rowsToolbar){
                var dateContainer = rowsToolbar.getComponent('uniDictDateContainer');
                if (dateContainer) {
                    var dateCmp = dateContainer.getComponent('uniDictDate');
                    if (dateCmp)
                        dateCmp.setValue(newValue);
                }
            }
        },

        afterRowsLoadHandler: function () {
            if (!this.rowsGrid.rendered || !this.rowsHistoryGrid.rendered)
                return;
            if (this.rowsHistoryGrid) 
                this.rowsHistoryGrid.store.removeAll();
            if (this.rowsGrid.store.getCount() > 0) {
                var rowIdx = this.rowsCridSelectedCell ? this.rowsCridSelectedCell.rowIdx : 0;
                var colIdx = this.rowsCridSelectedCell ? this.rowsCridSelectedCell.colIdx : this.defaultSelectRowsColumnIndex;
                this.selectRowsCell(rowIdx, colIdx);
            }
        },

        selectRowsCell: function(rowIdx, colIdx, isHistory){
            var grid = (isHistory) ? this.rowsHistoryGrid : this.rowsGrid;
            grid.getSelectionModel().select({
                row: rowIdx,
                column: colIdx
            });
            if (!isHistory)
                this.selectDictionRow(null, rowIdx);
        },

        selectDictionRow: function (sm, rowIndex) {
            var view = this;
            var rec = this.rowsGrid.store.getAt(rowIndex);
            if (!rec || this.activeRow === rec) return;
            this.activeRow = rec;
            var linkDictionRow = KS.Grid.getAnyCase(rec, 'LINK_DICTION_ROW');
            this.rowsHistoryGrid.mask();
            this.serverCall({
                method: 'BuildRowHistory',
                params: [linkDictionRow || 0, this.getBudgetContext()],
                disableFog: true,
                success: function() {
                    view.rowsHistoryGrid.unmask();
                    view.resetRowHistory();
                },
                error: function() {
                    view.rowsHistoryGrid.unmask();
                }
            });
        },

        getSelectedRowHistory: function () {
            return (this.rowsHistoryGrid) ? this.getCheckedRecords(this.rowsHistoryGrid.store, true) : [];
        },

        rowsGridClick: function (gridView, td, cellIndex, record, tr, rowIndex, e) {
            var view = gridView.grid.parentView;
            view.selectDictionRow(null, rowIndex);
            gridView.grid.clickedRowIndex = rowIndex;
            
            var column = e.position.column;
            if (column && column.isCheckColumn && column.dataIndex !== 'CHECKED'){
                var dataIndex = column.dataIndex;
                view.saveRowValue(null, {
                    record : record,
                    grid: gridView.grid,
                    field: dataIndex,
                    value: KS.Grid.getAnyCase(record, dataIndex)
                })
            }
        },
        
        rowsGridBeforeEdit: function (e, context) {
            var isDisable = KS.Grid.getAnyCase(context.record, "IS_DISABLE");
            if ((Ext.isBoolean(isDisable) && isDisable) ||
                (Ext.isString(isDisable) && isDisable.toLowerCase() === "true"))
                return false;

            // Чтобы при начале редактировая ячейки 'пусто' в эдиторе не было данных
            if (context.field === "END_DATE" && Ext.util.Format.date(context.value, 'd.m.Y') === '06.06.2079')
                context.value = null;

            return true;
        },

        saveRowValue: function (e, context) {
            if (context.column && context.column.isCheckColumn) // для чеков выходим, т.к. значение чека меняется после, и приходим из rowsGridClick
                return;
            var dictionLink = 0,
                dictionLinkHistory = KS.Grid.getAnyCase(context.record, 'LINK_DICTION_ROW_HISTORY') || 0;
            if (context.grid === this.rowsGrid)
                dictionLink = KS.Grid.getAnyCase(context.record, 'LINK_DICTION_ROW');
            var disableFog = this.rowsGrid.getStore().getTotalCount() <= 1000;
            var view = this;
            var budgetContext = this.getBudgetContext();
            this.serverCall({
                method: 'SaveRowValue',
                params: [dictionLink, dictionLinkHistory, context.field, context.value, this.getBudgetContext()],
                disableFog: disableFog,
                success: function(){
                    if ((budgetContext.BudgetLink > 0 || budgetContext.OrganizationLink > 0)
                        && view.budgetTree.getSelNode()) {
                        view.markBudgetTreeNode(view.budgetTree.getSelNode(), true);
                    }
                    view.touch();
                },
                error: function () {
                    context.record.reject();
                }
            });
        },

        resetRowHistory: function () {
            this.rowsHistoryGrid.reload();
        },

        showDisableRowsCheck: function (ci, checked) {
            this.data.showDisabledRows = checked;
            this.setDisabledRowsVisibility(false);
        },

        showDisableHistoryRowsCheck: function (ci, checked) {
            this.data.showDisabledHistoryRows = checked;
            this.setDisabledRowsVisibility(true);
        },

        setShowOverrideRows: function(ci, checked){
            var view = this;
            view.serverCall({
                method: 'SetOverrideRowsVisibility',
                params: [checked, this.getBudgetContext()],
                waitMessage: 'Применение настроек ...',
                success: function() {
                    view.resetRows();
                }
            });
        },

        setDisabledRowsVisibility: function (isHistory) {
            var view = this;
            this.serverCall({
                method: 'SetDisabledRowsVisibility',
                params: [this.data.showDisabledRows, this.data.showDisabledHistoryRows],
                waitMessage: 'Применение настроек ...',
                success: function() {
                    if (isHistory)
                        view.resetRowHistory();
                    else
                        view.resetRows();
                }
            });
        },

        getExcelImportRowsTabPanel: function () {
            var view = this.parentView || this;
            view.serverCall({
                method: 'GetExcelImportRowsTabPanel',
                success: view.showExcelImportRowsTabPanel
            });
        },

        markBudgetTreeNode: function(node, override){
            var nodeText = node.get("text");
            if (override)
                node.set("text", "<b>" + nodeText + "</b>");
            else
                node.set("text", nodeText.replace("<b>", "").replace("</b>", ""));
        }
    });
}(UniDictItemView.prototype));

// ============= GENERAL TAB =======================
(function (viewClass) {
    KS.apply(viewClass, {
        loadGeneralTab: function () {
            var view = this;
            view.serverCall({
                method: 'GetGeneralGridData',
                disableFog: true,
                success: function(listSettings) {
                    view.addPropertyGrids(listSettings);
                }
            });
        },

        addPropertyGrids: function (listSettings) {
            if (listSettings != null && listSettings.length === 2) {
                var generalPropertyGrid = this.getPropertyGridByOption(listSettings[0], "generalPropertyGrid", "Общие");
                this.additionalPropertyGrid = this.getPropertyGridByOption(listSettings[1], "additionalPropertyGrid", "Дополнительно");
                generalPropertyGrid.on("propertychange", this.generalPropertyGridChange);
                this.additionalPropertyGrid.on("propertychange", this.generalPropertyGridChange);
                this.generalTab.removeAll();
                this.generalTab.add(generalPropertyGrid);
                this.generalTab.add(this.additionalPropertyGrid);
            }
        },

        correctPropertyValue: function (value, recordId) {
            if (recordId.indexOf("LINK_DICTION_ROW_DEFAULT") !== -1 && // В клиенте ставим одно значение, на сервер отправляем другое
                this.generalLinkDictionRowDefault) {
                return this.generalLinkDictionRowDefault;
            }
            
            switch(Ext.typeOf(value)) {
                case "date":
                    value = Ext.util.Format.date(value, 'd.m.Y H:i:s');
                    break;
                case "number":
                    value = value.toString();
                    break;
                case "boolean":
                    value = value ? "True" : "False";
                    break;
                case "null":
                    return "";
            }
            return value;
        },

        generalPropertyGridChange: function (source, recordId, newValue, oldValue) {
            var view = this.parentView;
            if (!this.validate()) {
                view.loadGeneralTab();
                return;
            }
            newValue = view.correctPropertyValue(newValue, recordId);
            if (newValue === oldValue) return;
            var code = recordId.split("#")[1] || "";
            view.serverCall({
                method: 'ChangePropertyGridValue',
                disableFog: true,
                params: [code, newValue],
                success: function() {
                    view.touch();
                }
            });
        },

        propertyGridDictSelect: function (propId) {                   // из BaseSvodView
            if (propId.indexOf("LINK_DICTION_ROW_DEFAULT") !== -1) {
                var view = this;
                view.serverCall({
                    method: 'GetSelectDefaultRowGrid',
                    success: function(selectDefaultRowGrid) {
                        if (selectDefaultRowGrid != null)
                            view.showSelectDefaultRowGrid(selectDefaultRowGrid, propId);
                    }
                });
            }
        },

        showSelectDefaultRowGrid: function (selectDefaultRowGrid, propId) {
            var view = this;
            selectDefaultRowGrid.parentView = view;
            view.selectDefaultRowGrid = KS.create(selectDefaultRowGrid);
            view.selectDefaultRowWin = KS.showModal(view.selectDefaultRowGrid, {
                title: 'Выбертие значение...',
                resizable: true,
                maximizable: true,
                autoScroll: true,
                modal: true,
                width: Math.max(400, KS.rootViewport.getWidth() / 3),
                height: Math.max(300, KS.rootViewport.getHeight() / 2),
                buttonAlign: 'left',
                buttons: ['->', {
                        text: 'ОК',
                        scope: this,
                        handler: function () {
                            view.setGeneralDefaultRow(propId);
                        }
                    },{ xtype: 'tbspacer', width: 8 },
                    {
                        text: 'Отмена',
                        cls: 'dim-button',
                        handler: function() {
                            view.selectDefaultRowWin.close();
                        }
                    }]
            }, true);
        },

        setGeneralDefaultRow: function (propId) {
            var selectedRows = this.selectDefaultRowGrid.getCheckedRows();
            if (selectedRows.length > 0){
                var linkDictionRow = KS.Grid.getAnyCase(selectedRows[0], "LINK_DICTION_ROW");
                var code = KS.Grid.getAnyCase(selectedRows[0], "CODE");
                this.generalLinkDictionRowDefault = linkDictionRow;
                this.additionalPropertyGrid.setProperty(propId, code);
                this.selectDefaultRowWin.close();
            }
        }
    });
}(UniDictItemView.prototype));    

// ============= HIERARCHY ROWS TAB =======================
(function (viewClass) {
    KS.apply(viewClass, {
        afterHierarchyRowsLoad: function () {
            if (this.hierarchyRowsGrid.store.getCount() > 0) {
                var lastRow = this.hierarchyRowsGrid.getStore().last();
                if (lastRow) {
                    this.loadHierarchyRowsTreeData(lastRow);
                    this.hierarchyRowsGrid.getSelectionModel().select([lastRow]);
                }
            }
        },

        hierarchyRowsGridDblClick: function (treeView, record) {
            this.loadHierarchyRowsTreeData(record);
        },

        newHierarchyRow: function () {
            var view = this.parentView || this;
            view.getEditHierarchyRowOptions(null);
        },

        editHierarchyRow: function () {
            var view = this.parentView || this;
            var checkedCodes = view.hierarchyRowsGrid.getCheckedCodes();
            if (!Ext.isEmpty(checkedCodes)) {
                var linkHistory = checkedCodes.pop();
                view.getEditHierarchyRowOptions(linkHistory);
            }
        },
        
        getEditHierarchyRowOptions: function(linkHistory) {
            this.serverCall({
                method: 'GetEditHierarchyRowOptions',
                params: [linkHistory],
                success: function(hierarchyRowProps) {
                    this.showEditHierarchyRowPanel(hierarchyRowProps, linkHistory);
                }
            });
        },

        showEditHierarchyRowPanel: function(hierarchyRowProps, linkHistory) {
            if (Ext.isEmpty(hierarchyRowProps)) return;
            var view = this;
            this.hierarchyRowPropertyGrid = this.getPropertyGridByOption(hierarchyRowProps, "hierarchyRowPropertyGrid", "1. Общие");
            view.hierarchyRowPropertyWin = KS.showModal(view.hierarchyRowPropertyGrid, {
                title: 'Свойства',
                resizable: true,
                maximizable: true,
                autoScroll: true,
                modal: true,
                width: Math.max(400, KS.rootViewport.getWidth() / 2),
                height: Math.max(300, KS.rootViewport.getHeight() / 2),
                buttonAlign: 'left',
                buttons: ['->', {
                        text: 'ОК',
                        scope: this,
                        handler: function () {
                            view.setHierarchyRowOptions(linkHistory);
                        }
                    },{ xtype: 'tbspacer', width: 8 },
                    {
                        text: 'Отмена',
                        cls: 'dim-button',
                        handler: function() {
                            view.cancelEditHierarchyRow(linkHistory);
                        }
                    }]
            }, true);
        },

        setHierarchyRowOptions: function(linkHistory) {
            var newOptions = this.hierarchyRowPropertyGrid.source;
            this.serverCall({
                method: 'SetHierarchyRowOptions',
                params: [linkHistory, newOptions],
                success: function() {
                    this.hierarchyRowPropertyWin.close();
                    this.touch();
                    this.hierarchyRowsGrid.reload();
                }
            });
        },

        cancelEditHierarchyRow: function(linkHistory) {
            this.serverCall({
                method: 'CancelEditHierarchyRow',
                params: [linkHistory],
                disableFog: true,
                success: function() {
                    this.hierarchyRowPropertyWin.close();
                }
            });
        },
        
        copyHierarchyRow: function () {
            var view = this.parentView || this;
            var selectedRows = view.hierarchyRowsGrid.getSelectedRows();
            if (!Ext.isEmpty(selectedRows)) {
                var lastRow = selectedRows.pop();
                var name = KS.Grid.getAnyCase(lastRow, "NAME");
                KS.confirm("Копировать иерархию " + name + "?", "Внимание", function(btn) {
                    if (btn === 'yes') {
                        var linkHistory = KS.Grid.getAnyCase(lastRow, "LINK_HISTORY");
                        view.serverCall({
                            method: 'CopyHierarchyRow',
                            params: [linkHistory],
                            success: function() {
                                view.hierarchyRowsGrid.reload();
                                view.touch();
                            }
                        });
                    }
                });
            }
        },

        // приходим сюда после копирования
        onServerEditHierarchyRow: function(linkHistory) {
            var record = this.hierarchyRowsGrid.findRecord(linkHistory);
            if (record) {
                this.hierarchyRowsGrid.getSelectionModel().select([record]);
                this.getEditHierarchyRowOptions(linkHistory);
            }
        },
        
        deleteHierarchyRows: function () {
            var view = this.parentView || this;
            var selectedRows = view.hierarchyRowsGrid.getSelectedRows();
            if (Ext.isEmpty(selectedRows)) return;
            var selectedCodes = [];
            var identifierLink = view.data.identifier.Link.toString();
            Ext.each(selectedRows, function(row){
                var linkDiction = KS.Grid.getAnyCase(row, "LINK_DICTION");
                if (identifierLink === linkDiction)
                    selectedCodes.push(KS.Grid.getAnyCase(row, "LINK_HISTORY"));
            });
            if (Ext.isEmpty(selectedCodes)) return;
            KS.confirm("Будет удалено строк: " + selectedCodes.length + ". Продолжить?", "Внимание", function (btn) {
                if (btn === 'yes')
                    view.deleteHierarchyRowInternal(selectedCodes);
            });
        },

        deleteHierarchyRowInternal: function(selectedCodes){
            this.serverCall({
                method: 'DeleteHierarchyRows',
                params: [selectedCodes],
                waitMessage: 'Удаление ...',
                success: function(deleted) {
                    if (deleted){
                        this.touch();
                        this.hierarchyRowsGrid.reload();
                    }
                }
            });
        },

// ============= HIERARCHY TREE =================
        loadHierarchyRowsTreeData: function (hierarchyRow) {
            if (!hierarchyRow) return;
            var linkHistory = KS.Grid.getAnyCase(hierarchyRow, "LINK_HISTORY");
            var date = KS.Grid.getAnyCase(hierarchyRow, "DATE");
            var dateFormat = Ext.Date.format(date, 'd.m.Y');
            this.serverCall({
                method: 'LoadHierarchyRowsTreeData',
                waitMessage: 'Загрузка иерархии строк на дату ' + dateFormat,
                params: [linkHistory, date]
            });
        },

        onServerReloadHierarchyRowTree: function (linkHistory) {
            this.reloadHierarchyRowTree();
            this.hierarchyRowsTree.linkHistory = linkHistory;
        },

        reloadHierarchyRowTree: function() {
            this.hierarchyRowsTree.getRootNode().removeAll(true);
            this.hierarchyRowsTree.fullReload();
        },

        hierarchyTreeInvert: function () {
            var tree = this.parentView.hierarchyRowsTree;
            if (tree) {
                uniDictSetCheckedRecursive(tree.getRootNode());
            }
        },

        hierarchyTreeUnmark: function () {
            var tree = this.parentView.hierarchyRowsTree;
            if (tree) {
                uniDictSetCheckedRecursive(tree.getRootNode(), false);
            }
        },

        hierarchyTreeMarkChild: function () {
            var tree = this.parentView.hierarchyRowsTree;
            if (tree) {
                var sn = tree.getSelNode();
                if (!sn) return;
                Ext.each(sn.childNodes, function (subNode) {
                    uniDictSetCheckedRecursive(subNode, true);
                });
            }
        },

        hierarchyTreeMarkChildOneLevel: function () {
            var tree = this.parentView.hierarchyRowsTree;
            if (tree) {
                var sn = tree.getSelNode();
                if (!sn) return;
                Ext.each(sn.childNodes, function (subNode) {
                    if (subNode.id !== 'root' && subNode.data.checked !== null) 
                        setChecked(subNode, true);
                });
            }
        },

        hierarchyTreeCollapse: function() {
            var tree = this.parentView.hierarchyRowsTree;
            if (tree) {
                tree.collapseAll();
            }
        },

        hierarchyTreeExpand: function() {            
            var tree = this.parentView.hierarchyRowsTree;
            if (tree) {
                tree.expandAll();
            }
        },

        hierarchyNodeCalculate: function() {
            var view = this.parentView;
            var tree = view.hierarchyRowsTree;
            var checkedNodes = tree.getChecked();
            var selNode = tree.getSelNode();
            if (Ext.isEmpty(checkedNodes) && selNode)
                checkedNodes.push(selNode);
            var checkedIds = [];
            Ext.each(checkedNodes, function(node) {
                checkedIds.push(node.id);
            });
            if (Ext.isEmpty(checkedIds)) return;

            var btnCode = this.tbarNode.code;
            var type = null;
            switch (btnCode) {
                case "CALCULATE_NEVER":
                    type = 2;
                    break;

                case "CALCULATE_IF_EXISTS_DATA":
                    type = 1;
                    break;

                case "CALCULATE_ALWAYS":
                    type = 0;
                    break;
            }
            if (type == null) return;
            view.serverCall({
                method: 'HierarchyNodeCalculate',
                params: [checkedIds, type],
                success: function() {
                    view.reloadHierarchyRowTree();
                    view.touch();
                }
            });
        },

        replaceHierarchyRowsTreeNode: function() {
            var view = this.parentView || this;
            var code = this.tbarNode.code;
            var tree = view.hierarchyRowsTree;
            var checkedNodes = tree.getChecked();
            var selNode = tree.getSelNode();
            if (Ext.isEmpty(checkedNodes) && selNode)
                checkedNodes.push(selNode);
            if (!Ext.isEmpty(checkedNodes)) {
                var checkedLinks = [];
                Ext.each(checkedNodes,
                    function(node) {
                        checkedLinks.push(node.id);
                    });
                if (Ext.isEmpty(checkedLinks)) return;
                view.serverCall({
                    method: 'GetReplaceHierarchyRowsTree',
                    success: function(replaceNodeTree) {
                        view.showReplaceTree(replaceNodeTree, checkedLinks, code);
                    }
                });
            }
        },

        showReplaceTree: function(replaceNodeTree, checkedLinks, code) {
            var view = this;
            replaceNodeTree.parentView = this;
            this.replaceNodeTree = KS.create(replaceNodeTree);
            this.replaceNodeWin = KS.showModal(this.replaceNodeTree,
                {
                    title: 'Выберите значение...',
                    autoHeight: false,
                    layout: 'fit',
                    height: Math.max(500, KS.rootViewport.getHeight() / 1.5),
                    minHeight: 200,
                    width: Math.max(600, KS.rootViewport.getWidth() / 2),
                    minWidth: 300,
                    buttonAlign: 'left',
                    parentView: view,
                    listeners: {
                        beforeclose: this.beforeReplaceNodeWinClose
                    },
                    buttons: ['->',
                        {
                            text: 'ОК',
                            cls: 'dim-button',
                            handler: function() {
                                var selNode = view.replaceNodeTree.getSelNode();
                                view.doReplaceHierarchyRowsTreeNode(checkedLinks, code, selNode, true);
                            }
                        },
                        { xtype: 'tbspacer', width: 8 },
                        {
                            text: 'Отмена',
                            cls: 'dim-button',
                            handler: function() {
                                view.closeReplaceNodeWin();
                            }
                        }]
                },
                true);
        },

        replaceNodeTreeLoaded: function(){
            this.replaceNodeTree.nodeLoaded = true; // запоминаем что дерево загрузилось
        },

        beforeReplaceNodeWinClose: function(){
            if (!this.parentView.replaceNodeTree.nodeLoaded) { // Если закрывать окно до того как загрузилось дерево, то падает js
                return false;
            }
        },

        doReplaceHierarchyRowsTreeNode: function(checkedLinks, code, finalNode, needReloadTree) {
            var view = this;
            if (finalNode) {
                var finalNodeId = finalNode.id;

                if (checkedLinks.indexOf(finalNodeId) !== -1) { // циклическая ссылка
                    view.closeReplaceNodeWin();
                    return;
                }

                var parentNode = null;
                switch(code) {
                    case "SET_BEFORE":
                    case "SET_AFTER":
                        if (finalNode.parentNode && !finalNode.parentNode.data.root)
                            parentNode = finalNode.parentNode;
                        break;

                    case "SET_TO":
                        parentNode = finalNode;
                        break;
                }

                var parentNodeId = parentNode ? parentNode.id : null;
                var parentNodeChildLinks = [];
                if (parentNode && parentNode.childNodes) {
                    Ext.each(parentNode.childNodes, function (child) {
                        parentNodeChildLinks.push(child.id);
                    })
                }

                if (finalNodeId != null && parentNodeId != null) {
                    view.closeReplaceNodeWin();
                    view.serverCall({
                        method: 'ReplaceHierarchyRowsTreeNode',
                        disableFog: true,
                        params: [checkedLinks, finalNodeId, code, parentNodeId, parentNodeChildLinks],
                        success: function(activeNodeId) {
                            if (needReloadTree) {
                                if (!Ext.isEmpty(activeNodeId))
                                    view.hierarchyRowsTreeNodeIdToScroll = activeNodeId;
                                view.reloadHierarchyRowTree();
                            }
                            view.touch();
                        }
                    });
                }
            }
        },

        closeReplaceNodeWin: function(){
            if (this.replaceNodeWin)
                this.replaceNodeWin.close();
        },

        excludeHierarchyRow: function() {
            var view = this.parentView || this;
            var isExclude = this.tbarNode.code === "EXCLUDE";
            var tree = view.hierarchyRowsTree;
            var checkedNodes = tree.getChecked();
            var selNode = tree.getSelNode();
            if (Ext.isEmpty(checkedNodes) && selNode)
                checkedNodes.push(selNode);
            if (!Ext.isEmpty(checkedNodes)) {
                var msg = isExclude 
                    ? "Исключить выбранные узлы (" + checkedNodes.length + ") из иерархии?" 
                    : "Удалить выбранные узлы (" + checkedNodes.length + ") из иерархии?";
                KS.confirm(msg,
                    "Внимание",
                    function(btn) {
                        if (btn === 'yes') {
                            view.deleteSelectedRowsFromHierarchy(checkedNodes, isExclude);
                        }
                    });
            }
        },

        deleteSelectedRowsFromHierarchy: function(checkedNodes, isExclude) {
            var view = this;
            var links = [];
            Ext.each(checkedNodes,
                function(node) {
                    links.push(node.id);
                });
            view.serverCall({
                method: 'DeleteSelectedRowsFromHierarchy',
                params: [links, isExclude],
                success: function(result) {
                    if (result) {
                        view.reloadHierarchyRowTree();
                        view.touch();
                    }
                }
            });
        },

        goToRow: function(){
            var view = this.parentView || this;
            var selNode = view.hierarchyRowsTree.getSelNode();
            if (!selNode) return;
            var code = selNode.get("text");
            view.rootTabPanel.setActiveTab(2);
            var filterFeature = view.rowsGrid.getView().getFeature("filter");
            if (filterFeature)
                filterFeature.setFilter("CODE", code, "equals");
        }
    });
}(UniDictItemView.prototype));

// ============= COLUMNS =======================
(function (viewClass) {
    KS.apply(viewClass, {
        reloadColumnsTree: function() {
            this.columnsTree.getRootNode().removeAll(true);
            this.columnsTree.fullReload();
        },

        columnsTreeLoaded: function(){
            if (this.selectedColumnLink){
                this.columnsTree.setSelected(this.selectedColumnLink);
                this.selectedColumnLink = null;
            } else {
                this.columnsTree.selectFirstNode();
            }
        },

        columnSelected: function(selModel, selected){
            if (selected && selected.length > 0 && selected[0].id ){
                var columnLink = selected[0].id;
                this.loadColumnProperty(columnLink);
            }
        },

        loadColumnProperty: function(columnLink, forWinEdit) { //forWinEdit - для редактирования в модальном окне
            this.serverCall({
                method: 'GetColumnProperty',
                params: [columnLink],
                disableFog: true,
                success: function(settings){
                    this.addColumnProperty(settings, columnLink, forWinEdit)
                }
            });
        },

        addColumnProperty: function(settings, columnLink, forWinEdit) {
            if (settings != null) {
                if (forWinEdit){
                    this.columnPropertyGridInWin = this.getPropertyGridByOption(settings, "columnPropertyGridInWin", "Свойства");
                    this.showColumnPropertyEditWin(this.columnPropertyGridInWin, columnLink);
                } else {
                    this.columnPropertyGridInPanel = this.getPropertyGridByOption(settings, "columnPropertyGridInPanel", "Свойства");
                    this.columnPropertyGridInPanel.on("propertychange", this.columnPropertyGridChange, this);
                    this.columnPropertyGridInPanel.columnLink = columnLink;
                    this.columnPropertyPanel.removeAll();
                    this.columnPropertyPanel.add(this.columnPropertyGridInPanel);
                }
            }
        },

        columnPropertyGridChange: function(source, recordId, newValue){
            this.setColumnOptions(this.columnPropertyGridInPanel.columnLink, this.columnPropertyGridInPanel);
        },

        newColumn: function(){
            var view = this.parentView || this;
            view.loadColumnProperty(null, true);
        },

        editColumn: function(){
            var view = this.parentView || this;
            var selNodeId = view.columnsTree.getSelNodeId();
            if (!Ext.isEmpty(selNodeId)){
                view.loadColumnProperty(selNodeId, true);                
            }
        },

        showColumnPropertyEditWin: function(columnPropertyGrid, columnLink){
            var view = this;
            view.columnPropertyEditWin = KS.showModal(columnPropertyGrid, {
                title: 'Свойства',
                resizable: true,
                maximizable: true,
                autoScroll: true,
                listeners: {
                    close: function() {
                        if (!view.columnPropertyEditWin.propertyChanged) {
                            view.cancelEditColumn(columnLink);
                        }
                        delete view.columnPropertyEditWin;
                    }
                },
                modal: true,
                width: Math.max(400, KS.rootViewport.getWidth() / 2),
                height: Math.max(300, KS.rootViewport.getHeight() / 2),
                buttonAlign: 'left',
                buttons: ['->', {
                    text: 'ОК',
                    scope: this,
                    handler: function () {
                        view.setColumnOptions(columnLink, columnPropertyGrid);
                    }
                },{ xtype: 'tbspacer', width: 8 },
                    {
                        text: 'Отмена',
                        cls: 'dim-button',
                        handler: function() {
                            view.columnPropertyEditWin.close();
                        }
                    }]
            }, true);
        },

        setColumnOptions: function(columnLink, propertyGrid) {
            var view = this,
                newOptions = propertyGrid.source,
                validateResult = view.validateColumnOptions(propertyGrid, newOptions);

            if (!Ext.isEmpty(validateResult.errorMsg)) {
                if (view.columnPropertyEditWin) {
                    view.serverCall({
                        method: 'ValidateOrderOptions',
                        params: [columnLink, view.getFormattedOptions(newOptions)],
                        disableFog: true,
                        success: function(setResults) {
                            if (setResults != null) {
                                Ext.each(setResults.invalidValueIds, function (valueId) {
                                    validateResult.invalidValueIds.push(valueId);
                                });
                            }
                            view.setColumnOptionsCallback(propertyGrid, columnLink, validateResult, validateResult.errorMsg);
                        }
                    });
                } else {
                    KS.alert(validateResult.errorMsg, "Окно свойств");
                    view.selectedColumnLink = columnLink;
                    view.reloadColumnsTree();
                }
            } else {
                view.serverCall({
                    method: 'SetColumnOptions',
                    params: [columnLink, view.getFormattedOptions(newOptions)],
                    disableFog: true,
                    success: function (setResults) {
                        view.setColumnOptionsCallback(propertyGrid, columnLink, setResults, validateResult.errorMsg);
                    }
                });
            }
        },

        getFormattedOptions: function (newOptions) {
            var options = {};
            Ext.Object.each(newOptions, function (key, value) {
                options[key.split('#')[1]] = value;
            });
            return options;
        },

        setColumnOptionsCallback: function (propertyGrid, columnLink, setResults, validateErrorMsg) {
            var view = this;
            if (!Ext.isEmpty(setResults) && setResults.invalidValueIds) {
                if (setResults.invalidValueIds.length === 0 && Ext.isEmpty(validateErrorMsg) && setResults.editedColumnLink) {
                    if (view.columnPropertyEditWin) {
                        view.columnPropertyEditWin.propertyChanged = true;
                        view.columnPropertyEditWin.close();
                    }
                    view.touch();
                    view.selectedColumnLink = setResults.editedColumnLink;
                    view.columnsHasChanges = true;
                    view.reloadColumnsTree();
                } else {
                    KS.alert(validateErrorMsg !== '' ? validateErrorMsg : 'Недопустимое значение свойства', 'Окно свойств');
                    if (view.columnPropertyEditWin) {
                        Ext.each(setResults.invalidValueIds, function(itemId) {
                            var record = propertyGrid.store.findRecord('name', new RegExp('#' + itemId));
                            if (record === null)
                                return true;

                            var prevValue = record.previousValues;
                            if (prevValue)
                                propertyGrid.source[record.id] = prevValue.value;
                        });
                        propertyGrid.store.proxy.data = propertyGrid.source;
                        propertyGrid.store.reload();
                    } else {
                        view.selectedColumnLink = columnLink;
                        view.reloadColumnsTree();
                    }
                }
            }
        },

        validateColumnOptions: function(propertyGrid, newOptions) {
            var errorMsg = "",
                invalidValues = [],
                items = propertyGrid.store.data.items;

            Ext.Object.each(propertyGrid.sourceConfig, function(key, value) {
                var splittedKey = key.split('#'),
                    itemIndex = parseInt(splittedKey[0]),
                    settings = propertyGrid.settings[itemIndex];

                if (items[itemIndex].previousValues) {
                    if (!Ext.isEmpty(newOptions[key]) && settings.MaxLength && newOptions[key].length > settings.MaxLength) {
                        errorMsg = "Допустимая длина поля '" + settings.Name + "' меньше " + settings.MaxLength + " символа(ов).";
                        invalidValues.push(splittedKey[1]);
                    }
                    else if ((value.type === 'boolean' && !Ext.isBoolean(newOptions[key])) ||
                             (value.type === 'number' && ((!settings.AllowBlank && newOptions[key] === null) ||
                                 newOptions[key] < settings.MinValue || newOptions[key] > settings.MaxValue))) {
                        errorMsg = "Недопустимое значение свойства";
                        invalidValues.push(splittedKey[1]);
                    }

                    items[itemIndex].data.value = items[itemIndex].previousValues.value;
                }
            });
            return {
                errorMsg: errorMsg,
                invalidValueIds: invalidValues
            };
        },
        
        cancelEditColumn: function(columnLink) {
            this.serverCall({
                method: 'CancelEditColumn',
                params: [columnLink],
                disableFog: true
            });
        },

        deleteColumns: function(){
            var view = this.parentView;
            var checkedNodes = view.columnsTree.getChecked();
            var checkedIds = [];
            Ext.each(checkedNodes, function(node) {
                if (Number(node.id) !== 0)
                    checkedIds.push(node.id);
            });
            if (Ext.isEmpty(checkedIds)){
                var selNodeId = view.columnsTree.getSelNodeId();
                if (selNodeId && Number(selNodeId) !== 0)
                    checkedIds.push(selNodeId);
                else
                    return;  
            } 
            view.serverCall({
                method: 'DeleteColumns',
                params: [checkedIds],
                disableFog: true,
                success: function() {
                    view.touch();
                    view.columnsHasChanges = true;
                    view.reloadColumnsTree();
                }
            });
        },

        moveColumn: function(){
            var view = this.parentView || this;
            var selNodeId = view.columnsTree.getSelNodeId();
            if (Ext.isEmpty(selNodeId)) return;
            var btnCode = this.tbarNode.code;
            view.serverCall({
                method: 'MoveColumn',
                params: [selNodeId, btnCode],
                disableFog: true,
                success: function() {
                    view.touch();
                    view.selectedColumnLink = selNodeId;
                    view.columnsHasChanges = true;
                    view.reloadColumnsTree();
                }
            });
        },
        
        columnMarkAction: function(){
            var btnCode = this.tbarNode.code;
            var tree = this.parentView.columnsTree;
            switch (btnCode){
                case "MARK_COLUMN":
                    tree.invertAll();
                    break;
                    
                case "MARK_CHILD_COLUMN":
                case "MARK_CHILD2_COLUMN":
                    tree.checkAllChildren();
                    break;
                    
                case "MARK_DIRECT_CHILDREN_COLUMN":
                    tree.checkDirectChildren();
                    break;
                    
                case "UNMARK_COLUMN":
                    tree.uncheckAll();
                    break;
            }
        }
    });
}(UniDictItemView.prototype));

// ============= ACCESS =======================
(function (viewClass) {
    KS.apply(viewClass, {

        loadUniDictRights: function(){
            var view = this;
            this.serverCall({
                method: 'OnLoadUniDictRights',
                waitMessage: 'Загрузка прав на справочник...',
                cancellable: true,
                abort: this.cancelLoadUniDictRights,
                success: function() {
                    view.accessGrid.reload();
                }
            });
        },

        cancelLoadUniDictRights: function(){
            // нужно ли при отмене загрузки при следующем открытии вкладки опять начинать загрузку
            // this.accessTab.tabLoaded = false;
        },
                
        accessModeComboChange: function(comp, newValue){
            var view = this;
            this.saveAccessCachedValues(false);
            this.serverCall({
                method: 'AccessModeComboChange',
                params: [newValue],
                disableFod: true,
                success: function(newControl) {
                    view.rebuildAccessGrid(newControl);
                }
            });
        },

        rebuildAccessGrid: function(newControl) {
            if (!Ext.isEmpty(newControl)) {
                this.tpl.controls[newControl.itemId] = newControl;
                var newGrid = this.createTemplateControl(newControl);
                this.accessTab.remove(newGrid.ctrlId);
                this.accessTab.insert(0, newGrid);
                this.accessGrid.reload();
            }
        },
        
        accessGridCellClick: function(gridView, td, cellIndex, record) {
            var grid = gridView.grid;
            var column = grid.getColumns()[cellIndex];
            if (column && column.renderer === tripleCheckboxRenderer &&
                column.dataIndex.toLowerCase().indexOf("read_only") === -1) {
                var dataIndex = column.dataIndex;
                var oldValue = record.get(dataIndex);
                var closeCode= record.get("ENTITY_CLOSE_CODE");
                if (Ext.isEmpty(closeCode)) return;
                var newValue = "";
                
                switch (oldValue.toLowerCase()) {
                    case "":
                        newValue = 'false';
                        break;
                    case 'false':
                        newValue = 'true';
                        break;
                    case 'true':
                        newValue = "";
                        break;
                }

                this.addInAccessCachedValues(closeCode, dataIndex, newValue);
                record.set(dataIndex, newValue);
                this.touch();
            }
        },

        addInAccessCachedValues: function(closeCode, dataIndex, newValue) {
            var newCachedValue = {
                'closeCode': closeCode,
                'dataIndex': dataIndex,
                'newValue': newValue
            };
            if (!Ext.isEmpty(this.accessCachedValues)) {
                var existingCahcedValues = null;
                Ext.each(this.accessCachedValues, function(cachedValue){
                    if (cachedValue.closeCode === newCachedValue.closeCode &&
                        cachedValue.dataIndex === newCachedValue.dataIndex) {
                        existingCahcedValues = cachedValue;
                        return false;
                    }
                });
                if (!Ext.isEmpty(existingCahcedValues)){
                    existingCahcedValues.newValue = newCachedValue.newValue;
                    return;
                }
            }
            this.accessCachedValues.push(newCachedValue);
        },

        saveAccessCachedValues: function(isBeforeSave){
            if (!Ext.isEmpty(this.accessCachedValues)) {
                var view = this;
                this.serverCall({
                    method: 'SaveAccessCachedValues',
                    params: [this.accessCachedValues],                
                    waitMessage: isBeforeSave ? 'Сохранение ...' : 'Подождите...',
                    disableFod: !isBeforeSave,
                    success: function(){
                        view.accessCachedValues = [];
                    }
                });
            }
        }
    });
}(UniDictItemView.prototype));

// ============= Excel Form ===================
(function (viewClass) {
    KS.apply(viewClass, {
        showExcelImportRowsTabPanel: function (panel) {
            var view = this;
            view.excelImportRowsPanel = view.createTemplateControl(panel, 'excelImportRowsPanel');
            view.addPanelItems(panel, view.excelImportRowsPanel);
            view.excelImportRowsModal = KS.showModal(view.excelImportRowsPanel, {
                title: 'Настройки',
                autoHeight: true,
                resizable: false,
                maximizable: false,
                layout: 'anchor',
                height: KS.rootViewport.getHeight() * 0.8,
                width: KS.rootViewport.getWidth() * 0.8,
                buttonAlign: 'left',
                buttons: ['->', {
                    text: 'ОК',
                    cls: 'dim-button',
                    handler: function () {
                        view.saveExcelWorkbookChanges();
                    }
                }, { xtype: 'tbspacer', width: 8 },
                    {
                        text: 'Отмена',
                        cls: 'dim-button',
                        handler: function () {
                            view.excelImportRowsModal.close();
                        }
                    }]
            }, true);
        },

        saveExcelWorkbookChanges: function () {
            var view = this;
            var spreadsheetState = view.spreadsheet.getSpreadsheetState();
            $.ajax({
                type: 'POST',
                url: 'MKS/SaveDocument',
                data: { spreadsheetState: spreadsheetState },
                success: function () {
                    view.doExcelImportRows();
                }
            });
        },

        doExcelImportRows: function () {
            var view = this;
            var deleteDuplicates = view.deleteDuplicatesCombo.value;
            var addNewCodes = view.addNewCodesCombo.value;
            var rowExistsBehaviour = view.rowExistsBehaviourCombo.value | 0;
            var showProtocol = view.showProtocolCombo.value;
            var newRowDate = view.getToolbarItem(view.excelImportRowsPanel, null, 'START_DATE').getValue();
            var year = newRowDate.getFullYear();
            var month = newRowDate.getMonth() + 1; // Months start at 0!
            var day = newRowDate.getDate();
            view.serverCall({
                method: 'DoExcelImportRows',
                params: [year, month, day, deleteDuplicates, addNewCodes, rowExistsBehaviour, showProtocol],
                success: function () {
                    view.excelImportRowsModal.close();
                    view.rebuildRows();
                    view.rowsHistoryGrid.reload();
                    view.touch();
                }
            });
        },

        setImportExcelColumns: function () {
            var view = this.parentView || this;
            var region = view.spreadsheet.GetSelection();
            region['sheetIndex'] = view.spreadsheet.sheetIndex || 1;
            view.serverCall({
                method: 'SetImportExcelColumns',
                params: [region],
                success: function () {
                    //view.reloadFrame();
                }
            });
        },

        setImportExcelKeys: function () {
            var view = this.parentView || this;
            var region = view.spreadsheet.GetSelection();
            region['sheetIndex'] = view.spreadsheet.sheetIndex || 1;
            view.serverCall({
                method: 'SetImportExcelKeys',
                params: [region],
                success: function () {
                    //view.reloadFrame();
                }
            });
        },

        reloadFrame: function () {
            var spreadsheetFrame = document.getElementById(`spreadsheet_frame_${this.viewID}`);
            if (spreadsheetFrame)
                spreadsheetFrame.contentWindow.location.reload(true);
        },

        onSpreadsheetDocumentChanged: function (s, e) { var view = this; },

        onSpreadsheetCellEndEdit: function (s, e) { var view = this; },
    });
}(UniDictItemView.prototype));

// ============= DICTIONARY HIERARCHY =======================
(function (viewClass) {
    KS.apply(viewClass, {
        openDictionatyHierarchy: function(){
            var view = this.parentView ||this;
            var checkedRows = view.dictionHierarchyGrid.getCheckedRows();
            if (Ext.isEmpty(checkedRows)) return;
            var activeRow = checkedRows[0];
            var name = KS.Grid.getAnyCase(activeRow, "NAME");
            var dictionLink = KS.Grid.getAnyCase(activeRow, "LINK_DICTION_CHILD");
            KS.confirm("Открыть справочник '"+ name + "'?", "Внимание", function (btn) {
                if (btn === 'yes') {
                    view.serverCall({
                        method: 'OnOpenUniDict',
                        params: [name, dictionLink]
                    });
                }
            });      
        }
    });
}(UniDictItemView.prototype));

function uniDictSetCheckedRecursive(node, checked) {
    if (node.id !== 'root' && node.data.checked !== null) 
        setChecked(node, checked);
    Ext.each(node.childNodes, function() {
        uniDictSetCheckedRecursive(this, checked);
    });
}

// ============= RENDERERS =======================
function unidictItemRenderer(value, metadata, record) {
    var isDisable = KS.Grid.getAnyCase(record, "IS_DISABLE");
    if ((Ext.isBoolean(isDisable) && isDisable) ||
        (Ext.isString(isDisable) && isDisable.toLowerCase() === "true"))
        metadata.css += ' read-only-cell';
    return value;
}

function unidictDateRenderer(value, metadata, record, rowIndex, colIndex, store) {
    unidictItemRenderer(value, metadata, record, rowIndex, colIndex, store);
    var colCfg = store.grid.getColCfgByIndex(colIndex);
    if (colCfg && colCfg.tag === 'disabled') {
        metadata.css += ' disabled-org-cell';
    }
    if (Ext.isEmpty(value) && record.previousValues && 
        !Ext.isEmpty(record.previousValues[colCfg.dataIndex])) {
        value = record.previousValues[colCfg.dataIndex];
    }
    if (!Ext.isEmpty(value) && (new Date(value) != "Invalid Date") && (Ext.isString(value) &&value.indexOf("GMT") !== -1)) { 
        value = new Date(value);
    }
    if (Ext.isString(value) && !Ext.isEmpty(value)) {
        var parsed = KS.parseAjaxDateTime(value);
        if (parsed) {
            value = Ext.util.Format.date(parsed, 'd.m.Y');
        } else if (value.length > 10) {
            value = value.substring(0, 10);
        }
    } else {
        value = Ext.util.Format.date(value, 'd.m.Y');
    }
    return (value === '06.06.2079') ? '(пусто)' : value;
}

if (typeof (Sys) !== 'undefined') Sys.Application.notifyScriptLoaded();