﻿// ============= VIEW =======================
SavedFormExportView = KS.extend(BaseDictionaryView, {});

// ============= RENDER =======================
(function(viewClass) {
    var sc = SavedFormExportView.superclass;

    KS.apply(viewClass, {
        onTemplateRendered: function() {
            var checkedCodes = this.mainGrid.checkedCodes;
            this.mainGrid.store.each(function (rec) {
                if (checkedCodes.indexOf(rec.get("link_saved_form")) >= 0) 
                    rec.set("CHECKED", true);
            });
        },

        buildContainerToolbarItemControl: function (tbarItem) {
            switch (tbarItem.code) {
                case 'Container1':
                    var formatCombo = this.tpl.controls['formatCombo'];
                    return this.createTemplateControl(formatCombo);

                case 'exportSettings':
                    return this.createOptionsGroup({
                        title: 'Настройки экспорта',
                        width: 340,
                        items: [
                            {
                                id: 'archive',
                                xtype: 'checkbox',
                                checked: this.data.isArchive,
                                boxLabel: 'Упаковать в архив'
                            }, {
                                id: 'exportChild',
                                xtype: 'checkbox',
                                boxLabel: 'Выгрузить отчеты подведомственных организаций',
                                listeners: {
                                    "change": function(cmp, checked) {
                                        this.ownerCt.getComponent("exportChildMode").setDisabled(!checked);
                                    }
                                }
                            }, {
                                id: 'exportChildMode',
                                xtype: 'radiogroup',
                                width: 300,
                                disabled: true,
                                defaults: { name: 'exportChildMode' },
                                items: [
                                    { inputValue: 1, boxLabel: 'На 1 уровень вниз', checked: true },
                                    { inputValue: 2, boxLabel: 'На все уровни вниз' }
                                ]
                            }, {
                                id: 'orgCodeToFileName',
                                xtype: 'checkbox',
                                boxLabel: 'Добавить код организации в имя файла'
                            }, {
                                id: 'oneFile',
                                xtype: 'checkbox',
                                boxLabel: 'В один файл для каждого типа формы'
                            }, {
                                id: 'withFiles',
                                xtype: 'checkbox',
                                boxLabel: 'Выгрузить с прикрепленными файлами',
                                listeners: {
                                    "change": function(cmp, checked) {
                                        var archiveCheckbox = this.ownerCt.getComponent("archive");
                                        if (archiveCheckbox) {
                                            archiveCheckbox.setDisabled(checked);
                                            archiveCheckbox.setValue(false);
                                        }
                                        var oneFileCheckBox = this.ownerCt.getComponent("oneFile");
                                        if (oneFileCheckBox) {
                                            oneFileCheckBox.setDisabled(checked);
                                            oneFileCheckBox.setValue(false);
                                        }
                                    }
                                }
                            }
                        ]
                    });
            }
            return sc.buildContainerToolbarItemControl.apply(this, arguments);
        },

        editCell: function (e, context) {
            if (context.value === null || context.value === context.originalValue) 
                return false;
            var dataIndex = context.field;
            if (dataIndex !== "VERSION_FILE") return false;
            var closeCode = KS.Grid.getAnyCase(context.record, "LINK_SAVED_FORM");
            var newValue = context.value;
            this.serverCall({
                method: 'SetFileVersion',
                disableFog : true,
                params: [dataIndex, closeCode, newValue],
                success: function(hasErrors) {
                    if (hasErrors) {
                        context.record.reject();
                    }
                }
            });
            return true;
        }
    });
}(SavedFormExportView.prototype));

// ============= EXPORT =======================
(function(viewClass) {
    KS.apply(viewClass, {
        select: function() {
            var view = this.parentView,
                grid = view.mainGrid,
                checkedCodes = [];
            grid.store.each(function (rec) {
                var closeCode = grid.getCloseCode(rec);
                if (rec.get("CHECKED"))
                    checkedCodes.push(closeCode);
                else
                    view.removeCodeFromCheckedList(closeCode);
            });
            if (Ext.isEmpty(checkedCodes)) return;
            var additional = view.getAdditional();
            view.serverCall({
                method: 'PrepareExport',
                waitMessage: 'Инициализация ...',
                params: [checkedCodes, additional],
                success: view.startExport
            });
        },

        removeCodeFromCheckedList: function (cc) {
            var idx = $.inArray(cc, this.mainGrid.checkedCodes);
            if (idx >= 0) this.mainGrid.checkedCodes.splice(idx, 1);
        },

        startExport: function(exportData) {
            this.linksToProcess = exportData.links;
            this.dataBaseToProcess = exportData.dataBase;
            this.linksCount = exportData.links.length;
            this.fileIndex = 0;
            this.doExport();
        },

        doExport: function () {
            if (Ext.isEmpty(this.linksToProcess)) {
                this.finalizeExport();
            } else {
                var links = this.linksToProcess.splice(0, 1)[0],
                    dataBase = this.dataBaseToProcess.splice(0, 1)[0],
                    waitMessage = 'Экспорт ',
                    isLast = this.linksToProcess.length === 0 ? true : false ;
                if (this.linksCount > 1) {
                    var perCent = Math.floor((this.linksCount - this.linksToProcess.length) / this.linksCount * 100.0);
                    waitMessage += '(' + perCent + '%)';
                }
                var additional = this.getAdditional();
                if (additional.exportChild) 
                    this.fileIndex++;
                this.serverCall({
                    method: 'DoExport',
                    waitMessage: waitMessage + '...',
                    params: [links, dataBase, this.fileIndex, additional, isLast],
                    cancellable: true,
                    success: this.doExport
                });
            }
        },

        finalizeExport: function () {
            this.serverCall({
                method: 'FinalizeExport',
                waitMessage: 'Получение протокола ...',
                success: this.showHtmlProtocolInContainer
            });
        },

        getAdditional: function () {
            var additional = this.collectExportOptions();
            additional['format'] = this.formatCombo.getValue();
            if (this.version) additional['version'] = this.version.value;
            return additional;
        },

        collectExportOptions: function () {
            var view = this,
                result = {};
            this.selectOptions123.items.each(function(item) {
                if (KS.isString(item.id)) {
                    var value = view.getExportOption(item.id);
                    if (value !== null) result[item.id] = value;
                }
            });
            return result;
        },

        getExportOption: function(name) {
            var optCntr = this.selectOptions123;
            if (!optCntr) return null;
            var ct = optCntr.getComponent(name);
            if (!ct) return null;
            var value = ct.getValue();
            if (ct.xtype === 'radiogroup' && ct.disabled === false && value)
                value = value[name];
            return value;
        }
    });
}(SavedFormExportView.prototype));

function exportVersionFileRenderer(value) {
    return "<b>" + value + "</b>";
}

if (typeof (Sys) !== 'undefined') { Sys.Application.notifyScriptLoaded(); }