// ============= VIEW =======================
SavedFormBatchExportView = KS.extend(BaseSvodView, {});

// ============= MAIN =======================
(function(viewClass) {
    KS.apply(viewClass, {   
        setTitleByStep: function(step){
            step = step || this.getCurrentStep();
            var title = "";
            switch (step){
                case 0:
                    title = "Шаг 1 из 4. Выбор организаций и бюджетов";
                    break;
                case 1:
                    title = "Шаг 2 из 4. Выбор форм";
                    break;
                case 2:
                    title = "Шаг 3 из 4. Настройка экспорта";
                    break;
                case 3:
                case 4:
                    title = "Информация об экспорте";
                    break;
            }
            this.containerPanel.setTitle(title);
        },

        setActiveItemInRootPanel: function (itemIndex) {
            this.rootPanel.setActiveItem(itemIndex);
            this.rootPanel.activeItem = itemIndex;
        },

        getCurrentStep: function () {
            return this.rootPanel.activeItem;
        },

        prevStep: function(){
            var view = this.parentView || this;
            var currStep = view.getCurrentStep();
            var prevStep = currStep - 1;
            if (currStep > 0) {
                view.setActiveItemInRootPanel(prevStep);
                view.updateStepButtons();
                view.setTitleByStep();
            }
        },
        
        nextStep: function(){
            var view = this.parentView || this;
            var currStep = view.getCurrentStep();
            var nextStep = currStep + 1;
            if (currStep < 3){
                if (view.validateTab(currStep)){
                    view.setActiveItemInRootPanel(nextStep);
                    switch(nextStep){
                        case 1:
                            view.loadForms();
                            break;
                        case 2:
                            view.loadSettingsGrid();
                            break;
                        case 3:
                            view.createSummary();
                            break;
                    }                    
                    view.updateStepButtons();
                    view.setTitleByStep();
                }
            } else {
                view.doExport();
            }            
        },
        
        validateTab: function(step){
            switch(step){
                case 0:
                    var checkedNodes = this.budgetTree.getChecked();
                    if (Ext.isEmpty(checkedNodes)) {
                        KS.warning("Не выбран ни один узел дерева организаций и бюджетов");
                        return false;
                    }
                    break;
                case 1:
                    var checkedRows = this.formsGrid.getCheckedRows();
                    if (Ext.isEmpty(checkedRows)) {
                        KS.warning("Не выбрана ни одна форма для экспорта");
                        return false;
                    }
                    break;
                case 2:
                    var notValidRecord = null;
                    this.settingsGrid.getStore().each(function(record){
                        if (!Ext.isEmpty(KS.Grid.getAnyCase(record, "print_str")) && 
                            KS.Grid.getAnyCase(record, "settings").toLowerCase() !== 'true'){
                            notValidRecord = record;
                            return false;
                        }
                    });
                    if (!Ext.isEmpty(notValidRecord)) {
                        var formCode = KS.Grid.getAnyCase(notValidRecord, "code");
                        KS.warning("Для формы " + formCode + " не указаны настройки печати");
                        return false;
                    }
                    break;
            }
            return true;
        },

        updateStepButtons: function(step){
            step = step || this.getCurrentStep();
            var pervBtn = this.getToolbarItem(this.rootPanel, 'bottom', 'BACK');
            var nextBtn = this.getToolbarItem(this.rootPanel, 'bottom', 'NEXT');
            var cancelBtn = this.getToolbarItem(this.rootPanel, 'bottom', 'CANCEL');

            if (step == 4) {
                pervBtn.setHidden(true);
                nextBtn.setHidden(true);
                cancelBtn.setText("Выход");
            } else { //step [0,3]
                pervBtn.setHidden(step == 0);
                var text = step == 3 ? "Экспорт" : "Далее";
                nextBtn.setText(text);
                nextBtn.setTooltip(text);
            }
        },
        
        closeButton: function () {
            var view = this.parentView || this;
            view.close();
        },

        onValuesSelected: function (args) {
            if (!Ext.isEmpty(args) && !Ext.isEmpty(args[0]) &&
                !Ext.isEmpty(args[0][0]) && !Ext.isEmpty(args[0][0]['LINK_FORM'])) {
                var linkForm = args[0][0]['LINK_FORM'];
                var record = this.settingsGrid.findRecord(linkForm, 'LINK_FORM');
                if (record)
                    record.set("SETTINGS", true);
            }
        },

        doExport: function(){
            var checkedNodes = this.budgetTree.getChecked();
            var checkedLinks = [];
            Ext.each(checkedNodes,
                function(node) {
                    checkedLinks.push(node.id);
                });
            this.serverCall({
                method: 'StartExport',
                params: [checkedLinks],
                waitMessage: 'Выгрузка отчетов...'
            });
        }
    });
}(SavedFormBatchExportView.prototype));

// ============= MAIN_SETTINGS ======================= 
(function(viewClass) {
    KS.apply(viewClass, {
        openSettings: function(){
            var view = this.parentView || this;
            view.serverCall({
                method: 'GetSettingsProperties',
                success: view.showSettingsWin
            });
        },

        showSettingsWin: function(listOptions){
            if (listOptions) {
                var view = this;
                this.settingsPropPanel = Ext.create('Ext.panel.Panel', {
                    flex : 1
                });
                if (!Ext.Object.isEmpty(listOptions)) {
                    var i = 0;
                    for (var prop in listOptions) {
                        if (listOptions.hasOwnProperty(prop)) {
                            var propertyGrid = this.getPropertyGridByOption(listOptions[prop], "settingsPropGrid" + i++, prop);
                            this.settingsPropPanel.add(propertyGrid);
                        }
                    }
                }

                this.settingsWin = KS.showModal(this.settingsPropPanel,
                    {
                        title: 'Свойства',
                        autoHeight: false,
                        layout: 'anchor',
                        height: 500,
                        minHeight: 200,
                        width: 600,
                        minWidth: 300,
                        buttonAlign: 'left',
                        buttons: ['->',
                            {
                                text: 'ОК',
                                cls: 'dim-button',
                                handler: function() {
                                    view.saveSettings();
                                }
                            },
                            { xtype: 'tbspacer', width: 8 },
                            {
                                text: 'Отмена',
                                cls: 'dim-button',
                                handler: function() {
                                    view.settingsWin.close();
                                }
                            }]
                    },
                    true);
            }
        },

        saveSettings: function(){
            var ruleProperty = {};
            Ext.each(this.settingsPropPanel.items.items, function(propertyGrid) {
                var sourcePropGrid = propertyGrid.source;
                if (!Ext.Object.isEmpty(sourcePropGrid)) {
                    for (var prop in sourcePropGrid) {
                        if (sourcePropGrid.hasOwnProperty(prop)) {
                            var propKey = prop.split("#")[1];
                            ruleProperty[propKey] = sourcePropGrid[prop];
                        }
                    }
                }
            });
            var view = this;
            this.serverCall({
                method: 'SaveSettings',
                params: [ruleProperty],
                success: function(){
                    view.settingsWin.close();
                }
            });
        }
    });
}(SavedFormBatchExportView.prototype));

// ============= BUDGET_TREE ======================= 
(function(viewClass) {
    KS.apply(viewClass, {
        
    });
}(SavedFormBatchExportView.prototype));

// ============= FORMS_GRID ======================= 
(function(viewClass) {
    KS.apply(viewClass, {
        loadForms: function (){
            var checkedNodes = this.budgetTree.getChecked();
            var checkedLinks = [];
            Ext.each(checkedNodes,
                function(node) {
                    checkedLinks.push(node.id);
                });
            this.serverCall({
                method: 'LoadForms',
                params: [checkedLinks]
            });
        },
        
        onServerLoadFormsGrid: function(formsGrid){
            if (Ext.isEmpty(formsGrid)) return;
            this.formsGrid = this.createTemplateControl(formsGrid);
            this.formsPanel.removeAll();
            this.formsPanel.add(this.formsGrid);            
        },
        
        onServerLoadFormsGridFail: function(msg){
            this.formsPanel.setHtml(msg);
        },

        markInvertHandler: function () {
            this.parentView.formsGrid.markInvert();
        },

        markTopHandler: function() {
            this.parentView.formsGrid.markTop();
        },

        markAllHandler: function() {
            this.parentView.formsGrid.markAll();
        },

        markRestHandler: function() {
            this.parentView.formsGrid.markRest();
        },

        markBetweenHandler: function() {
            this.parentView.formsGrid.markBetween();
        },

        unmarkHandler: function() {
            this.parentView.formsGrid.unmark();
        }
    });
}(SavedFormBatchExportView.prototype));

// ============= SETTINGS_GRID ======================= 
(function(viewClass) {
    KS.apply(viewClass, {
        loadSettingsGrid: function(){
            var checkedRows = this.formsGrid.getCheckedRows(),
                checkedCodes = [];
            Ext.each(checkedRows, function(row){
                checkedCodes.push(KS.Grid.getAnyCase(row, "LINK_FORM"));
            })
            this.serverCall({
                method: 'LoadSettingsGrid',
                params: [checkedCodes]
            });
        },

        onServerLoadSettingsGrid: function(settingsGrid){
            if (Ext.isEmpty(settingsGrid)) return;
            this.settingsGrid = this.createTemplateControl(settingsGrid);
            this.settingsGridPanel.removeAll();
            this.settingsGridPanel.add(this.settingsGrid);
        },

        onServerLoadSettingsGridFail: function(msg){
            this.settingsGridPanel.setHtml(msg);
        },

        settingsGridDblClick: function(gridView, record, element, rowIndex, e){
            var column = e.position.column; 
            if (column.renderer == dictRenderer || column.renderer == printStrRenderer){
                var formCloseCode = KS.Grid.getAnyCase(record, gridView.grid.closeCode);
                this.getDictGrid(column.dataIndex, formCloseCode);
            }
        },

        getDictGrid: function(dataIndex, formCloseCode){
            var view = this;
            this.serverCall({
                method: 'GetDictGrid',
                params: [dataIndex, formCloseCode],
                success: function(dictGrid){
                    view.showDictGrid(dictGrid, dataIndex, formCloseCode);
                }
            });
        },
        
        showDictGrid: function(dictGrid, dataIndex, formCloseCode){
            if (Ext.isEmpty(dictGrid)) return;
            var view = this;
            view.dictGrid = this.createTemplateControl(dictGrid);
            view.dictWin = KS.showModal(view.dictGrid, {
                title: 'Выберите значение...',
                autoHeight: false,
                height: 500,
                minHeight: 200,
                width: 600,
                minWidth: 300,
                buttonAlign: 'left',
                buttons: ['->', 
                    {
                        text: 'ОК',
                        scope: this,
                        handler: function () {
                            view.selectFromDictGrid(dataIndex, formCloseCode);
                        }
                    },
                    { xtype: 'tbspacer', width: 8 },
                    {
                        text: 'Отмена',
                        cls: 'dim-button',
                        handler: function() {
                            view.dictWin.close();
                        }
                    }]
            }, true);
        },
        
        selectFromDictGrid: function(dataIndex, formCloseCode){
            var view = this;
            var checkedRows = view.dictGrid.getCheckedRows();
            if (Ext.isEmpty(checkedRows)) return;
            var checkedData = [];
            Ext.each(checkedRows, function(row){
                checkedData.push(row.data);
            })
            view.serverCall({
                method: 'SelectFromDictGrid',
                params: [checkedData, dataIndex, formCloseCode],
                success: function(result){
                    if (result) {
                        view.dictWin.close();
                        view.settingsGrid.reload()
                    }
                }
            });
        },

        settingsGridCellClick: function(gridView, td, cellIndex, record, tr, rowIndex, e){
            var view = this;
            var column = e.position.column;
            var dataIndex = column.dataIndex;
            gridView.grid.selectedRowIndex = KS.Grid.getAnyCase(record, gridView.grid.closeCode);
            if (column.isCheckColumn){
                var closeCode = KS.Grid.getAnyCase(record, gridView.grid.closeCode);
                var newValue = KS.Grid.getAnyCase(record, dataIndex);
                view.serverCall({
                    method: 'SetSettingsGridValue',
                    params: [dataIndex, [closeCode], newValue],
                    disableFog: true
                });
            } else if (column.renderer == settingsColumnRenderer){
                view.serverCall({
                    method: 'OpenFormPrintSettings',
                    params: [record.data]
                });
            }
        },

        changePrintStrCell: function(closeCode){
            var view = this;
            view.serverCall({
                method: 'ClearPrintTemplate',
                params: [closeCode],
                success: function(result){
                    if (result)
                        view.settingsGrid.reload();
                }
            });
        },

        beforeSettingsGridRender: function(grid) {
            var view = this;
            var columns = grid.getColumns();
            Ext.each(columns, function(column){
                if (!Ext.isEmpty(column.aspType) && column.aspType === 'checkcolumn' &&
                    !Ext.isEmpty(column.tag) && !Ext.isEmpty(column.tag.columnTooltip) && !Ext.isEmpty(column.tag.cssList)) {
                    column.tooltip = column.tag.columnTooltip;
                    column.cssList = column.tag.cssList;
                    column.getMenuItems = view.settingGridHeaderGetMenuItems;
                }
            });
        },

        settingGridHeaderGetMenuItems: function() {
            var view = this.view.panel.parentView,
                grid = view.settingsGrid;

            return [
                {
                    text: KS.L10n.all,
                    handler: function () {
                        view.setCheckValues(true, grid, grid.currentColumnDataIndex);
                    }
                },
                {
                    text: KS.L10n.nothing,
                    handler: function () {
                        view.setCheckValues(false, grid, grid.currentColumnDataIndex);
                    }
                },
                '-',
                {
                    text: KS.L10n.inversion,
                    handler: function () {
                        view.settingsGridInvertCheckboxes(grid, grid.currentColumnDataIndex);
                    }
                },
                {
                    text: KS.L10n.checkFromBeginning,
                    handler: function () {
                        view.settingsGridCheckFromBeginning(grid, grid.currentColumnDataIndex);
                    }
                },
                {
                    text: KS.L10n.checkFromCurrent,
                    handler: function () {
                        view.settingsGridCheckFromCurrent(grid, grid.currentColumnDataIndex);
                    }
                },
                {
                    text: KS.L10n.betweenChecked,
                    handler: function () {
                        view.settingsGridCheckBetween(grid, grid.currentColumnDataIndex);
                    }
                }
            ];
        },

        settingsGridHeaderTriggerClick: function (ct, column, e, triggerEl) {
            if (column.aspType === 'checkcolumn' && triggerEl && e.target === triggerEl.dom) {
                e.stopEvent();
                column.grid.currentColumnDataIndex = column.dataIndex;
                column.showMenuBy(e, e.target, column);
                return false;
            }
        },

        settingsGridHeaderClick: function (ct, column, e, htmlElement) {
            var view = this,
                className = htmlElement.className;
            if (column.aspType === 'checkcolumn' && !Ext.isEmpty(className) && !Ext.isEmpty(column.cssList)) {
                var newValue;
                switch (Ext.Array.indexOf(column.cssList, className)) {
                    case 0: // unchecked
                        newValue = true;
                        break;

                    case 1: // checked
                        newValue = false;
                        break;

                    default:
                        return false;
                }

                view.settingsGridPanel.mask();
                htmlElement.className = column.cssList[newValue ? 1 : 0];
                view.setCheckValues(newValue, column.view.grid, column.dataIndex);
                return false;
            }
            return true;
        },

        settingsGridInvertCheckboxes: function (grid, dataIndex) {
            this.serverCall({
                method: 'SetSettingsGridInvertedValues',
                params: [dataIndex],
                disableFog: true,
                success: function() {
                    grid.reload();
                }
            });
        },

        settingsGridCheckFromBeginning: function (grid, dataIndex) {
            var view = this,
                closeCodes = [];

            if (grid.selectedRowIndex) {
                Ext.each(grid.store.getRange(0, grid.selectedRowIndex), function (item) {
                    closeCodes.push(KS.Grid.getAnyCase(item, grid.closeCode));
                });
                view.setCheckValues(true, grid, dataIndex, closeCodes);
            }
        },

        settingsGridCheckFromCurrent: function (grid, dataIndex) {
            var view = this,
                closeCodes = [];

            if (grid.selectedRowIndex) {
                Ext.each(grid.store.getRange(grid.selectedRowIndex, grid.store.data.items.length), function (item) {
                    closeCodes.push(KS.Grid.getAnyCase(item, grid.closeCode));
                });
                view.setCheckValues(true, grid, dataIndex, closeCodes);
            }
        },

        settingsGridCheckBetween: function (grid, dataIndex) {
            var view = this,
                closeCodes = [],
                firstCheckedEl = null,
                lastCheckedEl = null;

            grid.store.each(function(item) {
                if (item.data[dataIndex]) {
                    if (!firstCheckedEl)
                        firstCheckedEl = item;
                    lastCheckedEl = item;
                }
            });

            if (firstCheckedEl) {
                var start = grid.store.indexOf(firstCheckedEl),
                    end = grid.store.indexOf(lastCheckedEl);
                Ext.each(grid.store.getRange(start, end), function(item) {
                    closeCodes.push(KS.Grid.getAnyCase(item, grid.closeCode));
                });
                view.setCheckValues(true, grid, dataIndex, closeCodes);
            }
        },

        setCheckValues: function (newValue, grid, dataIndex, closeCodes) {
            var view = this;
            if (!closeCodes) {
                closeCodes = [];
                grid.store.each(function(item) {
                    closeCodes.push(KS.Grid.getAnyCase(item, grid.closeCode));
                });
            }
            view.serverCall({
                method: 'SetSettingsGridValue',
                params: [dataIndex, closeCodes, newValue],
                disableFog: true,
                success: function() {
                    grid.reload();
                },
                complete: function(){
                    grid.selectedRowIndex = null;
                    view.settingsGridPanel.unmask();
                }
            });
        }
    });
}(SavedFormBatchExportView.prototype));

// ============= SUMMARY_TREE ======================= 
(function(viewClass) {
    KS.apply(viewClass, {
        createSummary: function(){
            var exportpath = this.getToolbarItem(this.rootPanel, 'top', 'exportPath').getValue();
                
            var checkedNodes = this.budgetTree.getChecked();
            var checkedNodesData = [];
            Ext.each(checkedNodes, function(checkedNode){
                checkedNodesData.push(checkedNode.data);
            });
            
            var checkedForms = this.formsGrid.getCheckedRows();
            var checkedFormsData = [];
            Ext.each(checkedForms, function(checkedForm){
                checkedFormsData.push(checkedForm.data);
            });

            this.serverCall({
                method: 'CreateSummary',
                params: [exportpath, checkedNodesData, checkedFormsData],
                success: this.addSummaryTree
            });            
        },

        addSummaryTree: function(summaryTree){
            if (Ext.isEmpty(summaryTree)) return;
            this.summaryTree = this.createTemplateControl(summaryTree);
            this.summaryTreePanel.removeAll();
            this.summaryTreePanel.add(this.summaryTree);
        }
    });
}(SavedFormBatchExportView.prototype));

// ============= RESULTS_GRID ======================= 
(function(viewClass) {
    KS.apply(viewClass, {
        onServerExportCompleted: function(){
            this.setActiveItemInRootPanel(4);
            this.updateStepButtons();            
        },
        
        onServerLoadResultsGrid: function(resultsGrid){
            if (Ext.isEmpty(resultsGrid)) return;
            this.resultsGrid = this.createTemplateControl(resultsGrid);
            this.resultsGridPanel.removeAll();
            this.resultsGridPanel.add(this.resultsGrid);
        },

        onServerLoadResultsGridFail: function(msg){
            this.resultsGridPanel.setHtml(msg);
        },

        downloadExportZip: function(){
            var view = this.parentView || this;
            view.serverCall({
                method: 'DownloadExportZip',
                disableFog: true
            });
        },

        resultsGridCellClick: function(gridView, td, cellIndex, record, tr, rowIndex, e){
            var view = this;
            var column = e.position.column;
            var dataIndex = column.dataIndex;
            if (dataIndex === "RESULT"){
                var protocol = KS.Grid.getAnyCase(record, "PROTOCOL");
                if (!Ext.isEmpty(protocol)){
                    var closeCode = gridView.grid.getCloseCode(record);
                    view.serverCall({
                        method: 'ShowExportProtocol',
                        params: [closeCode]
                    });
                }
            }
        }
    });
}(SavedFormBatchExportView.prototype));

function changePrintStrCell(viewId, closeCode) {
    var view = KS.getView(viewId);
    if (view)
        view.changePrintStrCell(closeCode);
}

// ============= RENDERERS =======================
function printStrRenderer(value, metadata, record, rowIndex, colIndex, store) {
    if (Ext.isString(value))
        setTooltip(metadata, value);
    metadata.css += ' sidewall-dict-cell';

    var grid = store.grid,
        closeCode = KS.Grid.getAnyCase(record, grid.closeCode),
        viewId = grid.parentView.viewID,
        cleanBtn = '<img src="PlatformHandler.axd?icon=clean.png" onclick="changePrintStrCell(\'' + viewId + '\',\'' + closeCode + '\')" style="vertical-align: middle;"/>';
    
    return cleanBtn + value;
}

function settingsColumnRenderer(value, metadata) {
    if (value.toLowerCase() === 'true'){
        metadata.css += ' link-setting-88';
    } else {
        metadata.css += ' link-setting-99';
    }
    return "Настройки";
}

function typeNameColumnRenderer(value, metadata, record){
    var type = +KS.Grid.getAnyCase(record, "TYPE");
    var icon = "";
    switch (type)
    {
        case 0:  //Success
            icon = "galka.png";
            break;
        case 1:  //Error
            icon = "errorx16.png";
            break;
        case 2:  //Info
            icon = "info.png";
            break;
        case 3:  //Recycle
            icon = "delete_local.png";
            break;
        case 4:  //PrintCancel
            icon = "report_query_dis.png";
            break;            
        case 5:  //Warning
            icon = "warning.png";
            break;
    }
    
    return (!Ext.isEmpty(icon) ? '<img src="PlatformHandler.axd?icon=' + icon + '" style="vertical-align: middle;"/>' : "") 
        + value;
}
